/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterGridView;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListCache;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.pccs.placs.business.model.ProgressReportConstant;
import kd.pccs.placs.business.model.TaskConstant;
import kd.pccs.placs.business.utils.project.StageStatusHelper;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.DefaultEnum;
import kd.pccs.placs.common.enums.EnableEnum;
import kd.pccs.placs.common.enums.MajorTypeEnum;
import kd.pccs.placs.common.enums.PersonTypeEnum;
import kd.pccs.placs.common.enums.PlanEnum;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.enums.RiskColorEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.enums.TaskTypeEnum;
import kd.pccs.placs.common.enums.project.ProjectStageEnum;
import kd.pccs.placs.common.enums.project.ProjectStatusEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.common.utils.permission.PermServiceHelper;
import kd.pccs.placs.formplugin.base.AbstractPlacsListPlugin;
import org.jetbrains.annotations.NotNull;

public class TaskReportListPlugin
extends AbstractPlacsListPlugin {
    private static final Log logger = LogFactory.getLog(TaskReportListPlugin.class);
    private static final String TASKREPORT = "taskreport";
    private static final String PLBZWC = "plbzwc";
    private static final String SZGX = "szgx";
    private static final String DUTYTASKTF = "dutytasktf";
    private static final String ASSISTTASKTF = "assisttasktf";
    private static final String CHOOSEDEPT = "choosedept";
    private static final String TFTYPE = "tftype";
    private static final String EXPORT = "exportlistbyselectfields";
    private static final String CALLBACKID_REFRESHBACK = "refreshcallback";
    private static final String PERCENT_OK = "100";
    private static final String TASKREPORT_ORG_SELECT = "taskreport_org_select";
    public static final String MAINRESPONSE = "1";
    public static final String COOPERATION = "2";
    public static final String SHARE = "3";
    public static final int RESPONORSHARE_PEERSONTYPE = 1;
    public static final int COOPERATE_PERSONTYPE = 2;
    public static final String PROJECT_ITEM_CACHE = "projectitem";

    public void filterContainerInit(FilterContainerInitArgs args) {
        List list = args.getCommonFilterColumns();
        List orgList = PermServiceHelper.getAllPermOrgsByOperate((String)"15", (String)RequestContext.get().getUserId(), (String)this.getAppId(), (String)((ListView)this.getView()).getBillFormId(), (String)"view");
        CommonFilterColumn projectColumn = (CommonFilterColumn)list.get(0);
        List<ComboItem> proComboItems = this.buildProComboItems(orgList, RequestContext.get().getUserId());
        projectColumn.setComboItems(proComboItems);
        List proItemIds = proComboItems.stream().map(item -> item.getId()).collect(Collectors.toList());
        this.getPageCache().put(PROJECT_ITEM_CACHE, JSON.toJSONString(proItemIds));
        CommonFilterColumn majorCFC = (CommonFilterColumn)list.get(5);
        List<ComboItem> majorItems = this.buildMajorTypeCombo();
        majorCFC.setComboItems(majorItems);
        String beFirst = this.getPageCache().get("beFirst");
        if (beFirst == null || beFirst.equals("true")) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
            FilterGridView filterGridView = (FilterGridView)filterContainer.getItems().get(1);
            int proIndex = -1;
            List items = filterGridView.getItems();
            for (int i = 0; i < items.size(); ++i) {
                CommonFilterColumn filterColumn = (CommonFilterColumn)items.get(i);
                if (!filterColumn.getFieldName().equals("project.name") && !filterColumn.getFieldName().equals("project.fullname")) continue;
                proIndex = i;
                break;
            }
            if (null != customParams.get("project") && proIndex >= 0) {
                ((CommonFilterColumn)filterGridView.getItems().get(proIndex)).setDefaultValue(customParams.get("project").toString());
            }
            this.getPageCache().put("beFirst", "false");
        }
        super.filterContainerInit(args);
    }

    public List<ComboItem> buildProComboItems(List<Long> orgList, String userId) {
        DynamicObject[] projects = this.getProjByOrgList(orgList, userId);
        return this.loadProComboItems(projects);
    }

    protected DynamicObject[] getProjByOrgList(List<Long> orgIdList, String userId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (orgIdList != null && orgIdList.size() > 0) {
            QFilter orgFilter = new QFilter(this.setProjectBizOrgFileName(), "in", orgIdList);
            qFilters.add(orgFilter);
        }
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        qFilters.add(statusFilter);
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        qFilters.add(enableFilter);
        DynamicObject[] projects = BusinessDataServiceHelper.load((String)this.getProjectFormId(), (String)"id,billname,billno,billstatus", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        return projects;
    }

    protected String setProjectBizOrgFileName() {
        return "org";
    }

    protected List<ComboItem> loadProComboItems(DynamicObject[] projects) {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        for (DynamicObject project : projects) {
            ComboItem item = new ComboItem();
            item.setId(project.getPkValue().toString());
            item.setCaption(new LocaleString(project.getString("name")));
            item.setValue(project.getPkValue().toString());
            combos.add(item);
        }
        return combos;
    }

    protected List<ComboItem> builldTaskSourceComboUseTaskType(List<ComboItem> list) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf(DefaultEnum.YES.getValue().charAt(0)));
        QFilter typeFilter = new QFilter("number", "=", (Object)TaskTypeEnum.ASSIGNTASK.getValue());
        DynamicObject assignTaskSource = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasksource"), (String)"id,name", (QFilter[])new QFilter[]{enableFilter, typeFilter});
        if (null != list && null != assignTaskSource) {
            ComboItem item = new ComboItem();
            item.setId(assignTaskSource.getString("id"));
            OrmLocaleValue name = (OrmLocaleValue)assignTaskSource.get("name");
            item.setCaption(new LocaleString(name.getLocaleValue()));
            item.setValue(assignTaskSource.getString("id"));
            list.add(item);
        }
        return list;
    }

    protected List<ComboItem> buildMajorTypeCombo() {
        OrmLocaleValue type;
        ComboItem item;
        String plantype;
        QFilter[] filters = new QFilter[]{new QFilter("enable", "=", (Object)Character.valueOf(DefaultEnum.YES.getValue().charAt(0)))};
        DynamicObject[] majorTypes = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"number, name, status, creator, modifier, enable, createtime, modifytime, masterid, group, description, plantypename, plantype, issysfield", (QFilter[])filters, (String)"plantype asc,number asc");
        List<ComboItem> majorItems = new ArrayList<ComboItem>();
        majorItems = this.builldTaskSourceComboUseTaskType(majorItems);
        for (DynamicObject major : majorTypes) {
            plantype = major.getString("plantype");
            if (!StringUtils.equalsIgnoreCase((CharSequence)plantype, (CharSequence)PlanTypeEnum.MAINPLAN.getValue()) && !StringUtils.equalsIgnoreCase((CharSequence)plantype, (CharSequence)PlanTypeEnum.DEPTPLAN.getValue()) && !StringUtils.equalsIgnoreCase((CharSequence)plantype, (CharSequence)PlanTypeEnum.PRIVATEPLAN.getValue()) && !StringUtils.equalsIgnoreCase((CharSequence)plantype, (CharSequence)PlanTypeEnum.DEPTFENJIEPLAN.getValue())) continue;
            item = new ComboItem();
            item.setId(major.getString("id"));
            type = (OrmLocaleValue)major.get("plantypename");
            item.setCaption(new LocaleString(type.getLocaleValue()));
            item.setValue(major.getString("id"));
            majorItems.add(item);
        }
        for (DynamicObject major : majorTypes) {
            plantype = major.getString("plantype");
            if (StringUtils.equalsIgnoreCase((CharSequence)plantype, (CharSequence)PlanTypeEnum.MAINPLAN.getValue()) || StringUtils.equalsIgnoreCase((CharSequence)plantype, (CharSequence)PlanTypeEnum.DEPTPLAN.getValue()) || StringUtils.equalsIgnoreCase((CharSequence)plantype, (CharSequence)PlanTypeEnum.PRIVATEPLAN.getValue()) || StringUtils.equalsIgnoreCase((CharSequence)plantype, (CharSequence)PlanTypeEnum.DEPTFENJIEPLAN.getValue())) continue;
            item = new ComboItem();
            item.setId(major.getString("id"));
            type = (OrmLocaleValue)major.get("plantypename");
            item.setCaption(new LocaleString(type.getLocaleValue()));
            item.setValue(major.getString("id"));
            majorItems.add(item);
        }
        return majorItems;
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("project.id".equals(fieldName) || "project.name".equals(fieldName)) {
            String projItemStr = this.getPageCache().get(PROJECT_ITEM_CACHE);
            List projItems = (List)JSON.parseObject((String)projItemStr, (TypeReference)new TypeReference<ArrayList<String>>(){}, (Feature[])new Feature[0]);
            List projItemList = projItems.stream().map(Long::parseLong).collect(Collectors.toList());
            args.addCustomQFilter(new QFilter("id", "in", projItemList));
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        FilterGridView filterGridView = (FilterGridView)filterContainer.getItems().get(1);
        Object projectId = args.getFilterValue("project.id");
        if (projectId == null) {
            return;
        }
        CommonFilterColumn planTypeCommonFilterColumn = (CommonFilterColumn)filterGridView.getItems().get(5);
        List<ComboItem> planTypeComboItems = this.buildPlanTypeComboItems(projectId);
        planTypeCommonFilterColumn.setComboItems(planTypeComboItems);
        super.filterContainerSearchClick(args);
    }

    protected List<Long> getPerOrgIds() {
        return PermServiceHelper.getAllPermOrgsByOperate((String)"15", (String)RequestContext.get().getUserId(), (String)this.getAppId(), (String)((ListView)this.getView()).getBillFormId(), (String)"view");
    }

    public void setFilter(SetFilterEvent e) {
        List realFilterList = e.getQFilters();
        logger.info(String.format("<<<<<log>>>>> e.getQFilters(): %s", realFilterList));
        ListCache listCache = new ListCache(this.getPageCache());
        List cacheFilterList = listCache.getListViewFilterParameter().getQFilters();
        logger.info(String.format("<<<<<log>>>>> filterList: %s", cacheFilterList));
        QFilter logicalQFilter = null;
        QFilter colorQFilter = null;
        for (QFilter qFilter : realFilterList) {
            if (StringUtils.equalsIgnoreCase((CharSequence)qFilter.getProperty(), (CharSequence)"logical")) {
                logicalQFilter = qFilter;
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)qFilter.getProperty(), (CharSequence)"riskcolor")) continue;
            colorQFilter = qFilter;
        }
        if (null != logicalQFilter) {
            realFilterList.remove(logicalQFilter);
        }
        if (null != colorQFilter) {
            Object riskColor = colorQFilter.getValue();
            ArrayList<String> colorList = new ArrayList<String>(10);
            if (riskColor instanceof List) {
                for (Object obj : (List)riskColor) {
                    colorList.add((String)obj);
                }
            } else {
                colorList.add((String)riskColor);
            }
            if (colorList.contains(RiskColorEnum.NOCOLOR.getValue())) {
                realFilterList.remove(colorQFilter);
                colorList.remove(RiskColorEnum.NOCOLOR.getValue());
                ArrayList<String> colors = new ArrayList<String>();
                colors.add(RiskColorEnum.RED.getValue());
                colors.add(RiskColorEnum.YELLOW.getValue());
                QFilter newColorQFilter = new QFilter("riskcolor", "in", colorList).or(new QFilter("riskcolor", "not in", colors));
                realFilterList.add(newColorQFilter);
            }
        }
        String userId = RequestContext.get().getUserId();
        List chargeOrgList = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)Boolean.TRUE);
        ArrayList<Long> chargeOrgIdList = new ArrayList<Long>(10);
        List<Long> orgIds = this.getPerOrgIds();
        ArrayList<Long> commonOrgIdList = new ArrayList<Long>(10);
        for (Long orgId : orgIds) {
            if (chargeOrgList.contains(orgId)) {
                if (logicalQFilter == null) {
                    List allSubordinateOrgs = OrgServiceHelper.getAllSubordinateOrgs((long)orgId, (boolean)true);
                    chargeOrgIdList.addAll(allSubordinateOrgs);
                    continue;
                }
                chargeOrgIdList.add(orgId);
                continue;
            }
            commonOrgIdList.add(orgId);
        }
        QFilter userOrDeptFilter = this.getUserFilterByLogicalFilter(logicalQFilter, chargeOrgIdList, commonOrgIdList);
        QFilter latestTaskFilter = new QFilter("islatest", "=", (Object)MAINRESPONSE).and("status", "=", (Object)StatusEnum.CHECKED.getValue()).and("relationtask", "=", (Object)0);
        realFilterList.add(latestTaskFilter);
        ArrayList<QFilter> newQFilters = new ArrayList<QFilter>();
        newQFilters.addAll(realFilterList);
        if (null != userOrDeptFilter) {
            newQFilters.add(userOrDeptFilter);
        }
        newQFilters.add(latestTaskFilter);
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"belongplantype,plans,planid,tasksource,meettask", (QFilter[])newQFilters.toArray(new QFilter[newQFilters.size()]));
        ArrayList<Object> taskList = new ArrayList<Object>();
        this.filterLatestTask(tasks, taskList);
        QFilter taskFilter = new QFilter("id", "in", taskList);
        realFilterList.add(taskFilter);
    }

    protected String getProjectOrg() {
        return "project.createorg.id";
    }

    protected QFilter getUserFilterByLogicalFilter(QFilter logicalQFilter, List<Long> chargeOrgIdList, List<Long> commonOrgIdList) {
        String userId = RequestContext.get().getUserId();
        QFilter userOrDeptFilter = null;
        if (null != logicalQFilter) {
            Object value = logicalQFilter.getValue();
            if (value instanceof ArrayList) {
                ArrayList list = new ArrayList(10);
                Object listFilter = logicalQFilter.getValue();
                for (Object obj : (List)listFilter) {
                    list.add(obj);
                }
                for (int i = 0; i < list.size(); ++i) {
                    String logical = list.get(i).toString();
                    userOrDeptFilter = this.getUserOrDeptFilterByMuiltyLogical(userOrDeptFilter, logical, chargeOrgIdList, commonOrgIdList);
                }
            } else {
                userOrDeptFilter = this.getUserOrDeptFilterByOneLogical(logicalQFilter, chargeOrgIdList, commonOrgIdList);
            }
        } else {
            if (chargeOrgIdList != null && !chargeOrgIdList.isEmpty()) {
                userOrDeptFilter = new QFilter("responsibledept", "in", chargeOrgIdList).or("multicooperationdept.fbasedataid.id", "in", chargeOrgIdList);
            }
            if (commonOrgIdList != null && !commonOrgIdList.isEmpty()) {
                if (userOrDeptFilter != null) {
                    QFilter respFilter = new QFilter("responsibledept", "in", commonOrgIdList).and("responsibleperson", "=", (Object)Long.parseLong(userId));
                    QFilter coopFilter = new QFilter("multicooperationdept.fbasedataid.id", "in", commonOrgIdList).and("multicooperationperson.fbasedataid.id", "=", (Object)Long.parseLong(userId));
                    QFilter shareFilter = new QFilter("sharer", "=", (Object)Long.parseLong(userId));
                    userOrDeptFilter = userOrDeptFilter.or(respFilter).or(coopFilter).or(shareFilter);
                } else {
                    QFilter respFilter = new QFilter("responsibledept", "in", commonOrgIdList).and("responsibleperson", "=", (Object)Long.parseLong(userId));
                    QFilter coopFilter = new QFilter("multicooperationdept.fbasedataid.id", "in", commonOrgIdList).and("multicooperationperson.fbasedataid.id", "=", (Object)Long.parseLong(userId));
                    QFilter shareFilter = new QFilter("sharer", "=", (Object)Long.parseLong(userId));
                    userOrDeptFilter = respFilter.or(coopFilter).or(shareFilter);
                }
            }
        }
        return userOrDeptFilter;
    }

    protected QFilter getUserOrDeptFilterByMuiltyLogical(QFilter userOrDeptFilter, String logical, List<Long> chargeOrgIdList, List<Long> commonOrgIdList) {
        String userId = RequestContext.get().getUserId();
        long userlongId = Long.parseLong(userId);
        if (userOrDeptFilter == null) {
            if (StringUtils.equalsIgnoreCase((CharSequence)logical, (CharSequence)MAINRESPONSE)) {
                if (chargeOrgIdList != null && !chargeOrgIdList.isEmpty()) {
                    userOrDeptFilter = new QFilter("responsibledept", "in", chargeOrgIdList).and("responsibleperson", "=", (Object)userlongId);
                }
                if (commonOrgIdList != null && !commonOrgIdList.isEmpty()) {
                    QFilter respFilter = new QFilter("responsibledept", "in", commonOrgIdList).and("responsibleperson", "=", (Object)userlongId);
                    userOrDeptFilter = userOrDeptFilter != null ? userOrDeptFilter.or(respFilter) : respFilter;
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)logical, (CharSequence)COOPERATION)) {
                if (chargeOrgIdList != null && !chargeOrgIdList.isEmpty()) {
                    userOrDeptFilter = new QFilter("multicooperationdept.fbasedataid.id", "in", chargeOrgIdList).and("multicooperationperson.fbasedataid.id", "=", (Object)userlongId);
                }
                if (commonOrgIdList != null && !commonOrgIdList.isEmpty()) {
                    QFilter coopFilter = new QFilter("multicooperationdept.fbasedataid.id", "in", commonOrgIdList).and("multicooperationperson.fbasedataid.id", "=", (Object)userlongId);
                    userOrDeptFilter = userOrDeptFilter != null ? userOrDeptFilter.or(coopFilter) : coopFilter;
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)logical, (CharSequence)SHARE)) {
                userOrDeptFilter = new QFilter("sharer", "in", (Object)userlongId);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)logical, (CharSequence)MAINRESPONSE)) {
            if (chargeOrgIdList != null && !chargeOrgIdList.isEmpty()) {
                QFilter chargeRespFilter = new QFilter("responsibledept", "in", chargeOrgIdList).and("responsibleperson", "=", (Object)userlongId);
                userOrDeptFilter = userOrDeptFilter.or(chargeRespFilter);
            }
            if (commonOrgIdList != null && !commonOrgIdList.isEmpty()) {
                QFilter respFilter = new QFilter("responsibledept", "in", commonOrgIdList).and("responsibleperson", "=", (Object)userlongId);
                userOrDeptFilter = userOrDeptFilter.or(respFilter);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)logical, (CharSequence)COOPERATION)) {
            if (chargeOrgIdList != null && !chargeOrgIdList.isEmpty()) {
                QFilter chargeCoopFilter = new QFilter("multicooperationdept.fbasedataid.id", "in", chargeOrgIdList).and("multicooperationperson.fbasedataid.id", "=", (Object)userlongId);
                userOrDeptFilter = userOrDeptFilter.or(chargeCoopFilter);
            }
            if (commonOrgIdList != null && !commonOrgIdList.isEmpty()) {
                QFilter coopFilter = new QFilter("multicooperationdept.fbasedataid.id", "in", commonOrgIdList).and("multicooperationperson.fbasedataid.id", "=", (Object)userlongId);
                userOrDeptFilter = userOrDeptFilter.or(coopFilter);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)logical, (CharSequence)SHARE)) {
            userOrDeptFilter = userOrDeptFilter.or("sharer", "=", (Object)userlongId);
        }
        return userOrDeptFilter;
    }

    protected QFilter getUserOrDeptFilterByOneLogical(QFilter logicalQFilter, List<Long> chargeOrgIdList, List<Long> commonOrgIdList) {
        String userId = RequestContext.get().getUserId();
        long userLongId = Long.parseLong(userId);
        QFilter userOrDeptFilter = null;
        String logical = logicalQFilter.getValue().toString();
        if (StringUtils.equalsIgnoreCase((CharSequence)logical, (CharSequence)MAINRESPONSE)) {
            if (chargeOrgIdList != null && !chargeOrgIdList.isEmpty()) {
                userOrDeptFilter = new QFilter("responsibledept", "in", chargeOrgIdList).and("responsibleperson", "=", (Object)userLongId);
            }
            if (commonOrgIdList != null && !commonOrgIdList.isEmpty()) {
                QFilter respFilter = new QFilter("responsibledept", "in", commonOrgIdList).and("responsibleperson", "=", (Object)userLongId);
                userOrDeptFilter = userOrDeptFilter != null ? userOrDeptFilter.or(respFilter) : respFilter;
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)logical, (CharSequence)COOPERATION)) {
            if (chargeOrgIdList != null && !chargeOrgIdList.isEmpty()) {
                userOrDeptFilter = new QFilter("multicooperationdept.fbasedataid.id", "in", chargeOrgIdList).and("multicooperationperson.fbasedataid.id", "=", (Object)userLongId);
            }
            if (commonOrgIdList != null && !commonOrgIdList.isEmpty()) {
                QFilter coopFilter = new QFilter("multicooperationdept.fbasedataid.id", "in", commonOrgIdList).and("multicooperationperson.fbasedataid.id", "=", (Object)userLongId);
                userOrDeptFilter = userOrDeptFilter != null ? userOrDeptFilter.or(coopFilter) : coopFilter;
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)logical, (CharSequence)SHARE)) {
            userOrDeptFilter = new QFilter("sharer", "=", (Object)userLongId);
        }
        return userOrDeptFilter;
    }

    protected void filterLatestTask(DynamicObject[] tasks, List<Object> taskList) {
        QFilter statusFilter = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
        for (DynamicObject task : tasks) {
            DynamicObject belongType = task.getDynamicObject("belongplantype");
            if (null != belongType && StringUtils.equalsIgnoreCase((CharSequence)belongType.getString("number"), (CharSequence)"MASTERPLAN_S")) {
                this.addLatestTask(taskList, statusFilter, task, "masterplan");
                continue;
            }
            if (null != belongType && (StringUtils.equalsIgnoreCase((CharSequence)belongType.getString("number"), (CharSequence)"TRANSACTIONPLAN_S") || StringUtils.equalsIgnoreCase((CharSequence)belongType.getString("number"), (CharSequence)"DECOMPOSITIONTASK_S"))) {
                this.addLatestTask(taskList, statusFilter, task, "deptplan");
                continue;
            }
            if (null != belongType && StringUtils.equalsIgnoreCase((CharSequence)belongType.getString("number"), (CharSequence)"PERSONALPLAN_S")) {
                taskList.add(task.getPkValue());
                continue;
            }
            this.addLatestTask(taskList, statusFilter, task, "specialplan");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addLatestTask(List<Object> taskList, QFilter statusFilter, DynamicObject task, String entityId) {
        String planId = task.getString("planid");
        DynamicObject taskSource = task.getDynamicObject("tasksource");
        if (null != taskSource) {
            QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf(DefaultEnum.YES.getValue().charAt(0)));
            QFilter taskSourceFilter = new QFilter("id", "=", taskSource.getPkValue());
            taskSource = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasksource"), (String)"id,number", (QFilter[])new QFilter[]{taskSourceFilter, enableFilter});
        }
        QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(planId));
        DynamicObject plan = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)entityId), (String)"name", (QFilter[])new QFilter[]{idFilter, statusFilter});
        if (plan == null) {
            if ((null == taskSource || !StringUtils.equalsIgnoreCase((CharSequence)taskSource.getString("number"), (CharSequence)TaskTypeEnum.ASSIGNTASK.getValue())) && task.getDynamicObject("meettask") == null) return;
            taskList.add(task.getPkValue());
            return;
        } else {
            taskList.add(task.getPkValue());
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        ListView view = (ListView)this.getView();
        Object focusRowPkId = view.getFocusRowPkId();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"percent")) {
            QFilter taskid = new QFilter("task", "=", focusRowPkId);
            QFilter taskreportStatus = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            QFilter[] filters = new QFilter[]{taskid, taskreportStatus};
            DynamicObject[] taskReportObjs = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)TASKREPORT), (String)ProgressReportConstant.AllProperty, (QFilter[])filters, (String)"modifytime desc");
            if (null == taskReportObjs || taskReportObjs.length == 0) {
                DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((Object)focusRowPkId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
                int percent = taskObj.getInt("percent");
                if (percent == 0) {
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u4efb\u52a1\u6682\u65e0\u6c47\u62a5\u8bb0\u5f55\u3002", (String)"TaskReportListPlugin_42", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObject sourceTask = taskObj.getDynamicObject("sourcetask");
                if (sourceTask != null) {
                    QFilter sameSourceTaskFilter = new QFilter("sourcetask", "=", (Object)sourceTask.getPkValue().toString());
                    QFilter taskStatus = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
                    DynamicObject[] sameSourceTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"", (QFilter[])new QFilter[]{sameSourceTaskFilter, taskStatus});
                    if (sameSourceTasks == null || sameSourceTasks.length == 0) {
                        this.getView().showMessage(ResManager.loadKDStringExt((String)"\u4efb\u52a1\u6682\u65e0\u6c47\u62a5\u8bb0\u5f55\u3002", (String)"TaskReportListPlugin_42", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    ArrayList<String> taskIds = new ArrayList<String>(sameSourceTasks.length);
                    for (DynamicObject task : sameSourceTasks) {
                        taskIds.add(task.getPkValue().toString());
                    }
                    taskid = new QFilter("task", "in", taskIds);
                    taskReportObjs = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)TASKREPORT), (String)ProgressReportConstant.AllProperty, (QFilter[])new QFilter[]{taskid, taskreportStatus}, (String)"auditdate desc", (int)1);
                    if (null == taskReportObjs || taskReportObjs.length == 0) {
                        this.getView().showMessage(ResManager.loadKDStringExt((String)"\u4efb\u52a1\u6682\u65e0\u6c47\u62a5\u8bb0\u5f55\u3002", (String)"TaskReportListPlugin_42", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                } else {
                    this.getView().showMessage(ResManager.loadKDStringExt((String)"\u4efb\u52a1\u6682\u65e0\u6c47\u62a5\u8bb0\u5f55\u3002", (String)"TaskReportListPlugin_42", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            map.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)TASKREPORT));
            map.put("pkId", taskReportObjs[0].getPkValue().toString());
            map.put("taskId", focusRowPkId);
            map.put("viewPercent", focusRowPkId);
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
            parameter.setAppId(this.getAppId());
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(parameter);
            args.setCancel(true);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"meetassigncount")) {
            map.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"));
            map.put("pkId", focusRowPkId.toString());
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
            parameter.setAppId(this.getAppId());
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCustomParam("activedTab", (Object)"meetresolution");
            this.getView().showForm(parameter);
            args.setCancel(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        FormOperate operate = (FormOperate)args.getSource();
        switch (key = operate.getOperateKey()) {
            case "taskreport": {
                this.doTaskReport(args);
                break;
            }
            case "plbzwc": {
                this.batchMarkCompleted(args);
                break;
            }
            case "szgx": {
                this.doSetShare(args);
                break;
            }
            case "dutytasktf": {
                this.dutyTaskTransfer(args);
                break;
            }
            case "assisttasktf": {
                this.assistTaskTransfer(args);
                break;
            }
            case "exportlistbyselectfields": {
                if (((ListView)this.getView()).getSelectedRows().size() > 0) break;
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u4efb\u52a1\u3002", (String)"TaskReportListPlugin_35", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    protected void assistTaskTransfer(BeforeDoOperationEventArgs args) {
        Object id = ((ListView)this.getView()).getSelectedRows().get(0).getPrimaryKeyValue();
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)id, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
        if (null != task) {
            DynamicObject taskSource = task.getDynamicObject("tasksource");
            String completionStatus = task.getString("completionstatus");
            if (null != taskSource && StringUtils.equalsIgnoreCase((CharSequence)taskSource.getString("number"), (CharSequence)TaskTypeEnum.ASSIGNTASK.getValue())) {
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u4ea4\u529e\u4efb\u52a1\u65e0\u6cd5\u8f6c\u4ea4\u534f\u529e\u4eba\u3002", (String)"TaskReportListPlugin_43", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(completionStatus) || CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(completionStatus)) {
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u4efb\u52a1\u5df2\u5b8c\u6210\uff0c\u4e0d\u80fd\u8f6c\u4ea4\u3002", (String)"TaskReportListPlugin_37", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        HashMap<String, Object> customMap = new HashMap<String, Object>();
        ListSelectedRowCollection listSelectedRows = ((ListView)this.getView()).getSelectedRows();
        HashMap<Object, Integer> taskToRow = new HashMap<Object, Integer>();
        ArrayList<Object> taskIds = new ArrayList<Object>();
        for (ListSelectedRow row : listSelectedRows) {
            Object taskId = row.getPrimaryKeyValue();
            taskIds.add(taskId);
            taskToRow.put(taskId, row.getRowKey() + 1);
        }
        if (taskIds.size() > 0) {
            customMap.put("taskIds", taskIds);
        }
        HashMap taskIdToDuty = new HashMap();
        QFilter taskidFilter = new QFilter("assistentity.atask", "in", taskIds);
        QFilter islatestFilter = new QFilter("islatest", "=", (Object)DefaultEnum.YES.getValue());
        QFilter[] ofilters = new QFilter[]{taskidFilter, islatestFilter};
        DynamicObject[] assisttasktransfer = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"assisttasktransfer"), (String)"id,name,assistentity.atask", (QFilter[])ofilters);
        for (Object e : taskIds) {
            for (DynamicObject assisttask : assisttasktransfer) {
                DynamicObjectCollection assistentity = assisttask.getDynamicObjectCollection("assistentity");
                for (DynamicObject dt : assistentity) {
                    if (!e.equals(dt.getDynamicObject("atask").getPkValue())) continue;
                    taskIdToDuty.put(e, assisttask.getPkValue());
                }
            }
        }
        QFilter taskId = new QFilter("atask", "in", taskIds);
        QFilter qFilter = new QFilter("islatesta", "=", (Object)DefaultEnum.YES.getValue());
        QFilter[] filters = new QFilter[]{taskId, qFilter};
        DynamicObject[] assists = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"assisttransfer"), (String)"id, astatus, atask_id", (QFilter[])filters);
        ArrayList tempSaveFids = new ArrayList();
        ArrayList unCheckedFids = new ArrayList();
        ArrayList checkedFids = new ArrayList();
        ArrayList<Object> tempSaveTaskIds = new ArrayList<Object>();
        ArrayList<Object> unCheckedTaskIds = new ArrayList<Object>();
        ArrayList<Object> checkedTaskIds = new ArrayList<Object>();
        boolean isTempSave = false;
        boolean isUnChecked = false;
        boolean isChecked = false;
        if (assists.length > 0) {
            for (DynamicObject dt : assists) {
                if (taskIdToDuty.get(dt.get("atask_id")) == null) continue;
                if (StatusEnum.TEMPSAVE.getValue().equals(dt.get("astatus"))) {
                    isTempSave = true;
                    if (!tempSaveFids.contains(taskIdToDuty.get(dt.get("atask_id")))) {
                        tempSaveFids.add(taskIdToDuty.get(dt.get("atask_id")));
                    }
                    if (tempSaveTaskIds.contains(dt.get("atask_id"))) continue;
                    tempSaveTaskIds.add(dt.get("atask_id"));
                    continue;
                }
                if (StatusEnum.UNCHECKED.getValue().equals(dt.get("astatus"))) {
                    isUnChecked = true;
                    if (!unCheckedFids.contains(taskIdToDuty.get(dt.get("atask_id")))) {
                        unCheckedFids.add(taskIdToDuty.get(dt.get("atask_id")));
                    }
                    if (unCheckedTaskIds.contains(dt.get("atask_id"))) continue;
                    unCheckedTaskIds.add(dt.get("atask_id"));
                    continue;
                }
                if (!StatusEnum.CHECKED.getValue().equals(dt.get("astatus")) && dt.get("astatus") != null) continue;
                isChecked = true;
                if (!checkedFids.contains(taskIdToDuty.get(dt.get("atask_id")))) {
                    checkedFids.add(taskIdToDuty.get(dt.get("atask_id")));
                }
                if (checkedTaskIds.contains(dt.get("atask_id"))) continue;
                checkedTaskIds.add(dt.get("atask_id"));
            }
            if (taskIds.size() > assists.length) {
                isChecked = true;
            }
        } else {
            isChecked = true;
        }
        ArrayList<Object> taskIdSort = new ArrayList<Object>();
        if (!isUnChecked && (isTempSave || isChecked)) {
            if (tempSaveFids.size() == 1 && !isChecked) {
                this.openTransferRecord(customMap, tempSaveFids.get(0), "_assisttasktransfer");
            } else {
                this.showForm(customMap, ShowType.MainNewTabPage, this.getAppId() + "_assisttasktransfer");
            }
        } else if (isUnChecked && !isTempSave && !isChecked) {
            if (unCheckedFids.size() > 1) {
                StringBuilder detailMessage = this.getDetailMessage(taskToRow, taskIds, unCheckedTaskIds, taskIdSort);
                this.getView().showMessage(detailMessage.toString());
            } else {
                this.openTransferRecord(customMap, unCheckedFids.get(0), "_assisttasktransfer");
            }
        } else if (isUnChecked && (isTempSave || isChecked)) {
            StringBuilder detailMessage = this.getDetailMessage(taskToRow, taskIds, unCheckedTaskIds, taskIdSort);
            String shortMessage = ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u4efb\u52a1\u5df2\u5728\u8f6c\u4ea4\u5ba1\u6279\u6d41\u7a0b\u4e2d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TaskReportListPlugin_44", (String)"pccs-placs-formplugin", (Object[])new Object[0]);
            String pkId = null;
            if (tempSaveFids.size() == 1 && !isChecked) {
                pkId = tempSaveFids.get(0).toString();
            }
            this.getPageCache().put("pkId", pkId);
            this.getPageCache().put("unCheckedTaskIds", StringUtils.join((Object[])unCheckedTaskIds.toArray()));
            this.getView().showConfirm(shortMessage, detailMessage.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(ASSISTTASKTF, (IFormPlugin)this));
        }
    }

    protected void dutyTaskTransfer(BeforeDoOperationEventArgs args) {
        Object id = ((ListView)this.getView()).getSelectedRows().get(0).getPrimaryKeyValue();
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)id, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
        if (null != task) {
            DynamicObject taskSource = task.getDynamicObject("tasksource");
            String completionStatus = task.getString("completionstatus");
            if (null != taskSource && StringUtils.equalsIgnoreCase((CharSequence)taskSource.getString("number"), (CharSequence)TaskTypeEnum.ASSIGNTASK.getValue())) {
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u4ea4\u529e\u4efb\u52a1\u65e0\u6cd5\u8f6c\u4ea4\u8d23\u4efb\u4eba\u3002", (String)"TaskReportListPlugin_45", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(completionStatus) || CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(completionStatus)) {
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u4efb\u52a1\u5df2\u5b8c\u6210\uff0c\u4e0d\u80fd\u8f6c\u4ea4\u3002", (String)"TaskReportListPlugin_37", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        HashMap<String, Object> customMap = new HashMap<String, Object>();
        ListSelectedRowCollection listSelectedRows = ((ListView)this.getView()).getSelectedRows();
        HashMap<Object, Integer> taskToRow = new HashMap<Object, Integer>();
        ArrayList<Object> taskIds = new ArrayList<Object>();
        for (ListSelectedRow row : listSelectedRows) {
            Object taskId = row.getPrimaryKeyValue();
            taskIds.add(taskId);
            taskToRow.put(taskId, row.getRowKey() + 1);
        }
        if (taskIds.size() > 0) {
            customMap.put("taskIds", taskIds);
        }
        HashMap taskIdToDuty = new HashMap();
        QFilter taskidFilter = new QFilter("dutyentity.task", "in", taskIds);
        QFilter islatestFilter = new QFilter("islatest", "=", (Object)DefaultEnum.YES.getValue());
        QFilter[] ofilters = new QFilter[]{taskidFilter, islatestFilter};
        DynamicObject[] dutytasktransfers = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"dutytasktransfer"), (String)"id,name,dutyentity.task", (QFilter[])ofilters);
        for (Object e : taskIds) {
            for (DynamicObject dutytask : dutytasktransfers) {
                DynamicObjectCollection dutyentity = dutytask.getDynamicObjectCollection("dutyentity");
                for (DynamicObject dt : dutyentity) {
                    if (!e.equals(dt.getDynamicObject("task").getPkValue())) continue;
                    taskIdToDuty.put(e, dutytask.getPkValue());
                }
            }
        }
        QFilter taskId = new QFilter("task", "in", taskIds);
        QFilter qFilter = new QFilter("islatestd", "=", (Object)DefaultEnum.YES.getValue());
        QFilter[] filters = new QFilter[]{taskId, qFilter};
        DynamicObject[] dutys = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"dutytransfer"), (String)"id, dstatus, task_id", (QFilter[])filters);
        ArrayList tempSaveFids = new ArrayList();
        ArrayList unCheckedFids = new ArrayList();
        ArrayList checkedFids = new ArrayList();
        ArrayList<Object> tempSaveTaskIds = new ArrayList<Object>();
        ArrayList<Object> unCheckedTaskIds = new ArrayList<Object>();
        ArrayList<Object> checkedTaskIds = new ArrayList<Object>();
        boolean isTempSave = false;
        boolean isUnChecked = false;
        boolean isChecked = false;
        if (dutys.length > 0) {
            for (DynamicObject dt : dutys) {
                if (StatusEnum.TEMPSAVE.getValue().equals(dt.get("dstatus"))) {
                    isTempSave = true;
                    if (!tempSaveFids.contains(taskIdToDuty.get(dt.get("task_id")))) {
                        tempSaveFids.add(taskIdToDuty.get(dt.get("task_id")));
                    }
                    if (tempSaveTaskIds.contains(dt.get("task_id"))) continue;
                    tempSaveTaskIds.add(dt.get("task_id"));
                    continue;
                }
                if (StatusEnum.UNCHECKED.getValue().equals(dt.get("dstatus"))) {
                    isUnChecked = true;
                    if (!unCheckedFids.contains(taskIdToDuty.get(dt.get("task_id")))) {
                        unCheckedFids.add(taskIdToDuty.get(dt.get("task_id")));
                    }
                    if (unCheckedTaskIds.contains(dt.get("task_id"))) continue;
                    unCheckedTaskIds.add(dt.get("task_id"));
                    continue;
                }
                if (!StatusEnum.CHECKED.getValue().equals(dt.get("dstatus")) && dt.get("dstatus") != null) continue;
                isChecked = true;
                if (!checkedFids.contains(taskIdToDuty.get(dt.get("task_id")))) {
                    checkedFids.add(taskIdToDuty.get(dt.get("task_id")));
                }
                if (checkedTaskIds.contains(dt.get("task_id"))) continue;
                checkedTaskIds.add(dt.get("task_id"));
            }
            if (taskIds.size() > dutys.length) {
                isChecked = true;
            }
        } else {
            isChecked = true;
        }
        ArrayList<Object> taskIdSort = new ArrayList<Object>();
        if (!isUnChecked && (isTempSave || isChecked)) {
            if (tempSaveFids.size() == 1 && !isChecked) {
                this.openTransferRecord(customMap, tempSaveFids.get(0), "_dutytasktransfer");
            } else {
                this.showForm(customMap, ShowType.MainNewTabPage, this.getAppId() + "_dutytasktransfer");
            }
        } else if (isUnChecked && !isTempSave && !isChecked) {
            if (unCheckedFids.size() > 1) {
                StringBuilder detailMessage = this.getDetailMessage(taskToRow, taskIds, unCheckedTaskIds, taskIdSort);
                this.getView().showMessage(detailMessage.toString());
            } else {
                this.openTransferRecord(customMap, unCheckedFids.get(0), "_dutytasktransfer");
            }
        } else if (isUnChecked && (isTempSave || isChecked)) {
            StringBuilder detailMessage = this.getDetailMessage(taskToRow, taskIds, unCheckedTaskIds, taskIdSort);
            String shortMessage = ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u4efb\u52a1\u5df2\u5728\u8f6c\u4ea4\u5ba1\u6279\u6d41\u7a0b\u4e2d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TaskReportListPlugin_44", (String)"pccs-placs-formplugin", (Object[])new Object[0]);
            String pkId = null;
            if (tempSaveFids.size() == 1 && !isChecked) {
                pkId = tempSaveFids.get(0).toString();
            }
            this.getPageCache().put("pkId", pkId);
            this.getPageCache().put("unCheckedTaskIds", StringUtils.join((Object[])unCheckedTaskIds.toArray()));
            this.getView().showConfirm(shortMessage, detailMessage.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(DUTYTASKTF, (IFormPlugin)this));
        }
    }

    @NotNull
    private StringBuilder getDetailMessage(Map<Object, Integer> taskToRow, List<Object> taskIds, List<Object> unCheckedTaskIds, List<Object> taskIdSort) {
        block0: for (Object tId : taskIds) {
            for (Object unCheckedTaskId : unCheckedTaskIds) {
                if (!tId.equals(unCheckedTaskId)) continue;
                taskIdSort.add(tId);
                continue block0;
            }
        }
        StringBuilder detailMessage = new StringBuilder();
        for (Object sortId : taskIdSort) {
            detailMessage.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4efb\u52a1\u5df2\u5728\u5ba1\u6279\u6d41\u7a0b\u4e2d\u3002", (String)"TaskReportListPlugin_46", (String)"pccs-placs-formplugin", (Object[])new Object[0]), taskToRow.get(sortId))).append("\r\n");
        }
        return detailMessage;
    }

    private void openTransferRecord(HashMap<String, Object> customMap, Object billId, String formId) {
        customMap.put("formId", this.getAppId() + formId);
        customMap.put("pkId", billId.toString());
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(customMap);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(parameter);
    }

    private void showForm(Map<String, Object> data, ShowType showType, String formId) {
        if (data == null) {
            data = new HashMap<String, Object>();
        }
        data.put("formId", formId);
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(data);
        parameter.getOpenStyle().setShowType(showType);
        this.getView().showForm(parameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)TASKREPORT)) {
            this.getView().invokeOperation("refresh");
        }
    }

    protected void doSetShare(BeforeDoOperationEventArgs args) {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)false, (int)1, (boolean)true);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SZGX));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    protected void doSetShare() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)false, (int)1, (boolean)true);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SZGX));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    protected void batchMarkCompleted(BeforeDoOperationEventArgs args) {
        String userId;
        HasPermOrgResult allPermOrgs;
        List permObjectsByNumber = PermissionServiceHelper.getPermObjectsByNumber((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"));
        String permid = "";
        for (Map map : permObjectsByNumber) {
            if (!((String)map.get("permItemName")).equals(ResManager.loadKDString((String)"\u6279\u91cf\u6807\u6ce8\u5b8c\u6210", (String)"TaskReportListPlugin_16", (String)"pccs-placs-formplugin", (Object[])new Object[0]))) continue;
            permid = (String)map.get("permItemId");
            break;
        }
        if (!(allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)Long.parseLong(userId = RequestContext.get().getUserId()), (String)this.getAppId(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"), (String)permid)).hasAllOrgPerm()) {
            long orgId = RequestContext.get().getOrgId();
            List hasPermOrgs = allPermOrgs.getHasPermOrgs();
            if (!hasPermOrgs.contains(orgId)) {
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u60a8\u6ca1\u6709\u201c\u6279\u91cf\u6807\u6ce8\u5b8c\u6210\u201d\u7684\u6743\u9650\u3002", (String)"TaskReportListPlugin_47", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        ListView listView = (ListView)this.getView();
        ListSelectedRowCollection listSelectedRows = listView.getSelectedRows();
        ArrayList<Object> taskIdList = new ArrayList<Object>();
        for (ListSelectedRow row : listSelectedRows) {
            Object taskId = row.getPrimaryKeyValue();
            taskIdList.add(taskId);
        }
        QFilter manualComFilter = new QFilter("autocomplete", "=", (Object)Boolean.FALSE);
        QFilter latestFilter = new QFilter("latest", "=", (Object)Boolean.TRUE);
        QFilter percentFilter = new QFilter("percent", "=", (Object)100);
        QFilter taskIdFilter = new QFilter("task", "in", taskIdList);
        QFilter statusFilter1 = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] manualComReports = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)TASKREPORT), (String)"id,task,percent,autocomplete", (QFilter[])new QFilter[]{manualComFilter, latestFilter, percentFilter, taskIdFilter, statusFilter1});
        QFilter statusFilter2 = new QFilter("billstatus", "!=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] noCheckedReports = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)TASKREPORT), (String)"id,task,percent,autocomplete", (QFilter[])new QFilter[]{latestFilter, taskIdFilter, statusFilter2});
        List<String> noCReportIdList = Arrays.stream(noCheckedReports).map(o -> o.getPkValue().toString()).collect(Collectors.toList());
        String[] noCReportIds = new String[noCReportIdList.size()];
        noCReportIdList.toArray(noCReportIds);
        Map bizProcessStatus = WorkflowServiceHelper.getBizProcessStatus((String[])noCReportIds);
        if (manualComReports.length + bizProcessStatus.size() >= taskIdList.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u4efb\u52a1\u5747\u5df2\u5b8c\u6210\u6216\u5176\u8fdb\u5ea6\u6c47\u62a5\u5904\u4e8e\u6d41\u7a0b\u4e2d\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u6279\u91cf\u6807\u6ce8\u5b8c\u6210\u3002", (String)"TaskReportListPlugin_39", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        List manualComTaskIds = Arrays.stream(manualComReports).map(o -> o.getDynamicObject("task").getPkValue()).collect(Collectors.toList());
        ArrayList<Object> inProcessTaskIds = new ArrayList<Object>();
        for (DynamicObject noCReport : noCheckedReports) {
            if (!bizProcessStatus.containsKey(noCReport.getPkValue().toString())) continue;
            inProcessTaskIds.add(noCReport.getDynamicObject("task").getPkValue());
        }
        taskIdList.removeAll(manualComTaskIds);
        taskIdList.removeAll(inProcessTaskIds);
        StringBuilder detailMessage = new StringBuilder();
        for (ListSelectedRow row : listSelectedRows) {
            Object taskId = row.getPrimaryKeyValue();
            if (!taskIdList.contains(taskId)) continue;
            detailMessage.append(row.getName()).append("\r\n");
        }
        String batchMarkTaskIds = SerializationUtils.toJsonString(taskIdList);
        this.getPageCache().put("batchMarkTaskIds", batchMarkTaskIds);
        String shortMessage = String.format(ResManager.loadKDString((String)"\u9664\u6389\u5df2\u5b8c\u6210\u548c\u5176\u8fdb\u5ea6\u6c47\u62a5\u5904\u4e8e\u6d41\u7a0b\u4e2d\u7684\u4efb\u52a1\uff0c\u5269\u4f59\u5171%s\u5f20\u5355\u636e\uff0c\u786e\u5b9a\u8981\u5c06\u9009\u4e2d\u5355\u636e\u6279\u91cf\u6807\u6ce8\u5b8c\u6210\u5417\uff1f", (String)"TaskReportListPlugin_28", (String)"pccs-placs-formplugin", (Object[])new Object[0]), taskIdList.size());
        this.getView().showConfirm(shortMessage, detailMessage.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(PLBZWC, (IFormPlugin)this));
    }

    protected void doTaskReport(BeforeDoOperationEventArgs args) {
        QFilter taskReportPersonType;
        if (((ListView)this.getView()).getSelectedRows().size() > 1) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u4e00\u6b21\u53ea\u5141\u8bb8\u6c47\u62a5\u4e00\u6761\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaskReportListPlugin_5", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Object taskId = ((ListView)this.getView()).getSelectedRows().get(0).getPrimaryKeyValue();
        QFilter latestFilter = new QFilter("latest", "=", (Object)Boolean.TRUE);
        QFilter taskIdFilter = new QFilter("task", "=", taskId);
        QFilter statusFilter = new QFilter("billstatus", "not in", (Object)new String[]{StatusEnum.CHECKED.getValue(), StatusEnum.TEMPSAVE.getValue()});
        DynamicObject[] noCheckedReports = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)TASKREPORT), (String)"id,task,percent,autocomplete", (QFilter[])new QFilter[]{latestFilter, taskIdFilter, statusFilter});
        List<String> noCReportIdList = Arrays.stream(noCheckedReports).map(o -> o.getPkValue().toString()).collect(Collectors.toList());
        String[] noCReportIds = new String[noCReportIdList.size()];
        noCReportIdList.toArray(noCReportIds);
        Map bizProcessStatus = WorkflowServiceHelper.getBizProcessStatus((String[])noCReportIds);
        if (bizProcessStatus != null && !bizProcessStatus.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5df2\u6709\u201c\u8fdb\u5ea6\u6c47\u62a5\u201d\u8fdb\u5165\u5ba1\u6279\u6d41\uff0c\u8bf7\u5148\u5ba1\u6279\u518d\u6c47\u62a5\u3002", (String)"TaskReportListPlugin_48", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)TASKREPORT));
        map.put("taskId", taskId);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
        showParameter.setAppId(this.getAppId());
        QFilter taskid = new QFilter("task", "=", task.getPkValue());
        QFilter taskreportStatus = new QFilter("billstatus", "=", (Object)StatusEnum.TEMPSAVE.getValue()).or("billstatus", "=", (Object)StatusEnum.UNCHECKED.getValue());
        QFilter[] filters = null;
        String userId = RequestContext.get().getUserId();
        DynamicObject responPerson = task.getDynamicObject("responsibleperson");
        DynamicObjectCollection cooperatePersons = task.getDynamicObjectCollection("multicooperationperson");
        List coopersonIds = cooperatePersons.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList());
        DynamicObject sharer = task.getDynamicObject("sharer");
        if (null != responPerson && StringUtils.equals((CharSequence)responPerson.getString("id"), (CharSequence)userId) || null != sharer && StringUtils.equals((CharSequence)sharer.getString("id"), (CharSequence)userId)) {
            map.put("person", 1);
            taskReportPersonType = new QFilter("persontype", "=", (Object)PersonTypeEnum.RESPONSIBLEPERSON.getValue()).or("persontype", "=", (Object)PersonTypeEnum.SHARER.getValue());
            filters = new QFilter[]{taskid, taskreportStatus, taskReportPersonType};
        } else if (null != cooperatePersons && cooperatePersons.size() > 0 && coopersonIds.contains(Long.parseLong(userId))) {
            map.put("person", 2);
            taskReportPersonType = new QFilter("persontype", "=", (Object)PersonTypeEnum.COOPERATIONPERSON.getValue());
            filters = new QFilter[]{taskid, taskreportStatus, taskReportPersonType};
        } else {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u53ea\u6709\u4efb\u52a1\u7684\u8d23\u4efb\u4eba\u3001\u534f\u529e\u4eba\u548c\u5171\u4eab\u4eba\uff0c\u624d\u80fd\u6c47\u62a5\u8be5\u4efb\u52a1\u3002", (String)"TaskReportListPlugin_49", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObject[] taskReports = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)TASKREPORT), (String)ProgressReportConstant.AllProperty, (QFilter[])filters);
        if (null != taskReports && taskReports.length > 0) {
            showParameter.setStatus(OperationStatus.EDIT);
            map.put("editreport", Boolean.TRUE);
            ((BillShowParameter)showParameter).setPkId(taskReports[0].getPkValue());
        } else {
            showParameter.setStatus(OperationStatus.ADDNEW);
            map.put("addreport", Boolean.TRUE);
        }
        showParameter.setCustomParams(map);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACKID_REFRESHBACK));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent mesce) {
        super.confirmCallBack(mesce);
        if (StringUtils.equals((CharSequence)PLBZWC, (CharSequence)mesce.getCallBackId()) && mesce.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.batchMarkConfirm(mesce);
        } else if (StringUtils.equals((CharSequence)CHOOSEDEPT, (CharSequence)mesce.getCallBackId()) && mesce.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.taskDeptTransfer();
        } else if (StringUtils.equals((CharSequence)CHOOSEDEPT, (CharSequence)mesce.getCallBackId()) && mesce.getResult().equals((Object)MessageBoxResult.Cancel)) {
            this.getView().invokeOperation("refresh");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u8f6c\u4ea4\u5b8c\u6210\u3002", (String)"TaskReportListPlugin_50", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        } else if (StringUtils.equals((CharSequence)DUTYTASKTF, (CharSequence)mesce.getCallBackId()) && mesce.getResult().equals((Object)MessageBoxResult.Yes)) {
            HashMap<String, Object> customMap = new HashMap<String, Object>();
            ArrayList<Iterator<String>> taskIds = new ArrayList<Iterator<String>>();
            ListSelectedRowCollection listSelectedRows = ((ListView)this.getView()).getSelectedRows();
            for (ListSelectedRow row : listSelectedRows) {
                Iterator<String> taskId = row.getPrimaryKeyValue();
                taskIds.add(taskId);
            }
            String unCheckedTaskId = this.getPageCache().get("unCheckedTaskIds");
            if (unCheckedTaskId != null) {
                List<String> unCheckedTaskIds = Collections.singletonList(unCheckedTaskId);
                for (String id : unCheckedTaskIds) {
                    if (!taskIds.contains(Long.valueOf(id.toString()))) continue;
                    taskIds.remove(Long.valueOf(id.toString()));
                }
            }
            customMap.put("taskIds", taskIds);
            String pkId = this.getPageCache().get("pkId");
            if (pkId != null) {
                this.openTransferRecord(customMap, pkId, "_dutytasktransfer");
            } else {
                this.showForm(customMap, ShowType.MainNewTabPage, this.getAppId() + "_dutytasktransfer");
            }
            this.getPageCache().remove("pkId");
            this.getPageCache().remove("unCheckedTaskIds");
        } else if (StringUtils.equals((CharSequence)ASSISTTASKTF, (CharSequence)mesce.getCallBackId()) && mesce.getResult().equals((Object)MessageBoxResult.Yes)) {
            HashMap<String, Object> customMap = new HashMap<String, Object>();
            ArrayList<Object> taskIds = new ArrayList<Object>();
            ListSelectedRowCollection listSelectedRows = ((ListView)this.getView()).getSelectedRows();
            for (ListSelectedRow row : listSelectedRows) {
                Object taskId = row.getPrimaryKeyValue();
                taskIds.add(taskId);
            }
            String unCheckedTaskId = this.getPageCache().get("unCheckedTaskIds");
            if (unCheckedTaskId != null) {
                List<Object> unCheckedTaskIds = Collections.singletonList(unCheckedTaskId);
                for (Object id : unCheckedTaskIds) {
                    if (!taskIds.contains(Long.valueOf(id.toString()))) continue;
                    taskIds.remove(Long.valueOf(id.toString()));
                }
            }
            customMap.put("taskIds", taskIds);
            String pkId = this.getPageCache().get("pkId");
            if (pkId != null) {
                this.openTransferRecord(customMap, pkId, "_assisttasktransfer");
            } else {
                this.showForm(customMap, ShowType.MainNewTabPage, this.getAppId() + "_assisttasktransfer");
            }
            this.getPageCache().remove("pkId");
            this.getPageCache().remove("unCheckedTaskIds");
        }
    }

    protected void batchMarkConfirm(MessageBoxClosedEvent mesce) {
        String batchMarkTaskIds = this.getPageCache().get("batchMarkTaskIds");
        List taskIds = (List)SerializationUtils.fromJsonString((String)batchMarkTaskIds, List.class);
        ORM orm = ORM.create();
        for (Long taskId : taskIds) {
            this.reportingTask(taskId, false, orm);
        }
        ListView listView = (ListView)this.getView();
        listView.refresh();
    }

    protected void reportingTask(Object taskId, boolean beAutoComplete, ORM orm) {
        DynamicObject parent;
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
        if (task.getBigDecimal("percent").intValue() != 100) {
            task.set("riskcolor", null);
            if (beAutoComplete) {
                task.set("completedescription", (Object)ResManager.loadKDString((String)"\u4e0b\u7ea7\u5b50\u4efb\u52a1\u5df2\u5b8c\u6210\uff0c\u7236\u7ea7\u4efb\u52a1\u72b6\u6001\u81ea\u52a8\u66f4\u65b0\u4e3a\u5b8c\u6210\u3002", (String)"TaskReportListPlugin_51", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            }
            task.set("realendtime", (Object)task.getDate("planendtime"));
            task.set("percent", (Object)PERCENT_OK);
            task.set("completionstatus", (Object)CompletionStatusEnum.ONTIMECOMPLETE.getValue());
            task.set("realtimedeviation", (Object)BigDecimal.ZERO);
            DynamicObject majortype = task.getDynamicObject("majortype");
            DynamicObject project = task.getDynamicObject("project");
            if (project != null && majortype != null && StringUtils.equals((CharSequence)majortype.getString("number"), (CharSequence)MajorTypeEnum.FEASIBILITYSTUDY_S.getValue())) {
                StageStatusHelper.changeStatus((DynamicObject)project, (ProjectStageEnum)ProjectStageEnum.FEASIBILITYSTUDYSTAGE_S, (ProjectStatusEnum)ProjectStatusEnum.APPROVAL_IN);
            }
            DynamicObject taskReport = this.createNewTaskReport(task, beAutoComplete, orm);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskReport});
            this.updateRelateTaskData(task);
            this.updateTaskReportRecordStatus(taskId, taskReport.getPkValue());
        }
        if ((parent = task.getDynamicObject("parent")) == null) {
            return;
        }
        DynamicObject parentTask = BusinessDataServiceHelper.loadSingle((Object)parent.getPkValue(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
        QFilter sonFilter = new QFilter("parent", "=", parentTask.getPkValue());
        DynamicObject[] sonTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,percent", (QFilter[])new QFilter[]{sonFilter});
        boolean beFullComplete = true;
        for (DynamicObject son : sonTasks) {
            if (son.getInt("percent") >= 100) continue;
            beFullComplete = false;
        }
        if (!beFullComplete) {
            return;
        }
        DynamicObject relation = parentTask.getDynamicObject("relationtask");
        if (relation == null) {
            this.reportingTask(parentTask.getPkValue(), true, orm);
        } else {
            DynamicObject quotedTask = BusinessDataServiceHelper.loadSingle((Object)relation.getPkValue(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
            Object sourceTaskId = null;
            DynamicObject source = quotedTask.getDynamicObject("sourcetask");
            sourceTaskId = source == null ? quotedTask.getPkValue() : source.getPkValue();
            QFilter filter1 = new QFilter("sourcetask", "=", sourceTaskId).or(new QFilter("id", "=", sourceTaskId));
            QFilter filter2 = new QFilter("islatest", "=", (Object)MAINRESPONSE);
            QFilter filter3 = new QFilter("relationtask", "=", (Object)0);
            QFilter filter4 = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
            QFilter[] filters = new QFilter[]{filter1, filter2, filter3, filter4};
            DynamicObject suitParentTask = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id", (QFilter[])filters);
            this.reportingTask(suitParentTask.getPkValue(), true, orm);
        }
    }

    protected void updateTaskReportRecordStatus(Object taskId, Object taskReportId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter taskFilter = new QFilter("task", "=", taskId);
        filters.add(taskFilter);
        QFilter idFilter = new QFilter("id", "!=", taskReportId);
        filters.add(idFilter);
        DynamicObject[] reports = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)TASKREPORT), (String)"latest", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        if (reports.length == 0) {
            return;
        }
        for (DynamicObject report : reports) {
            report.set("latest", (Object)DefaultEnum.NO.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])reports);
    }

    protected void updateRelateTaskData(DynamicObject task) {
        DynamicObject sourceTask = task.getDynamicObject("sourcetask");
        DynamicObject[] relationTasks = null;
        if (sourceTask == null) {
            QFilter qFilter = new QFilter("relationtask", "=", task.getPkValue());
            relationTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)TaskConstant.AllProperty, (QFilter[])new QFilter[]{qFilter});
            if (relationTasks.length == 0) {
                return;
            }
        } else {
            QFilter taskFilter = new QFilter("sourcetask", "=", sourceTask.getPkValue()).or(new QFilter("id", "=", sourceTask.getPkValue()));
            DynamicObject[] allTaskOfPlan = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id", (QFilter[])new QFilter[]{taskFilter});
            Set taskIdSet = Arrays.stream(allTaskOfPlan).map(o -> o.getPkValue()).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("relationtask", "in", taskIdSet);
            relationTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"realendtime,percent,completionstatus,completedescription", (QFilter[])new QFilter[]{qFilter});
            if (relationTasks.length == 0) {
                return;
            }
        }
        Date realEndTime = task.getDate("realendtime");
        for (DynamicObject relationTask : relationTasks) {
            relationTask.set("realendtime", (Object)realEndTime);
            relationTask.set("percent", (Object)PERCENT_OK);
            relationTask.set("completionstatus", task.get("completionstatus"));
            relationTask.set("completedescription", task.get("completedescription"));
        }
        SaveServiceHelper.save((DynamicObject[])relationTasks);
    }

    protected DynamicObject createNewTaskReport(DynamicObject task, boolean beAutoComplete, ORM orm) {
        DynamicObject taskReport = new DynamicObject(MetaDataUtil.getDT((String)this.getAppId(), (String)TASKREPORT));
        Long id = orm.genLongId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)TASKREPORT));
        taskReport.set("id", (Object)id);
        taskReport.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
        String userId = RequestContext.get().getUserId();
        taskReport.set("creator", (Object)userId);
        taskReport.set("modifier", (Object)userId);
        taskReport.set("auditor", (Object)userId);
        Date date = DateUtil.getCurrentDate();
        taskReport.set("createtime", (Object)date);
        taskReport.set("modifytime", (Object)date);
        taskReport.set("auditdate", (Object)date);
        taskReport.set("iscomplete", (Object)Boolean.TRUE);
        taskReport.set("completetime", (Object)task.getDate("realendtime"));
        taskReport.set("task", task.getPkValue());
        taskReport.set("percent", (Object)PERCENT_OK);
        if (beAutoComplete) {
            taskReport.set("autocomplete", (Object)DefaultEnum.YES.getValue());
        }
        taskReport.set("reportdesc", (Object)ResManager.loadKDString((String)"\u6279\u91cf\u6807\u6ce8\u5b8c\u6210", (String)"TaskReportListPlugin_16", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        String name = RequestContext.get().getUserName();
        DynamicObject responsibleperson = task.getDynamicObject("responsibleperson");
        DynamicObjectCollection cooperatePersons = task.getDynamicObjectCollection("multicooperationperson");
        List coopersonIds = cooperatePersons.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList());
        DynamicObject sharer = task.getDynamicObject("sharer");
        if (null != responsibleperson && StringUtils.equals((CharSequence)responsibleperson.getString("id"), (CharSequence)userId)) {
            taskReport.set("huibaoperson", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u4e3b\u8d23\u4eba\uff09", (String)"TaskReportListPlugin_30", (String)"pccs-placs-formplugin", (Object[])new Object[0]), name));
        } else if (null != cooperatePersons && cooperatePersons.size() > 0 && coopersonIds.contains(Long.parseLong(userId))) {
            taskReport.set("huibaoperson", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u534f\u529e\u4eba\uff09", (String)"TaskReportListPlugin_31", (String)"pccs-placs-formplugin", (Object[])new Object[0]), name));
        } else if (null != sharer && StringUtils.equals((CharSequence)sharer.getString("id"), (CharSequence)userId)) {
            taskReport.set("huibaoperson", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u5171\u4eab\u4eba\uff09", (String)"TaskReportListPlugin_32", (String)"pccs-placs-formplugin", (Object[])new Object[0]), name));
        } else {
            taskReport.set("huibaoperson", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u6279\u91cf\u6807\u6ce8\u4eba\uff09", (String)"TaskReportListPlugin_33", (String)"pccs-placs-formplugin", (Object[])new Object[0]), name));
        }
        DynamicObjectCollection taskcg = task.getDynamicObjectCollection("taskresultdocentry");
        DynamicObjectCollection taskReportEntry = taskReport.getDynamicObjectCollection("achieveentity");
        if (null != taskcg) {
            long[] ids = DB.genLongIds((String)("t_" + this.getAppId() + "_taskreportdoc"), (int)taskcg.size());
            for (int i = 0; i < taskcg.size(); ++i) {
                DynamicObject cgEntry = new DynamicObject(taskReportEntry.getDynamicObjectType());
                long cgEntryId = ids[i];
                taskReport.getDataEntityType().getPrimaryKey().setValueFast((Object)cgEntry, (Object)cgEntryId);
                cgEntry.set("seq", (Object)(i + 1));
                cgEntry.set("resultname", ((DynamicObject)taskcg.get(i)).get("resultname"));
                cgEntry.set("force", ((DynamicObject)taskcg.get(i)).get("force"));
                cgEntry.set("desc", ((DynamicObject)taskcg.get(i)).get("resultdescription"));
                cgEntry.set("frequency", ((DynamicObject)taskcg.get(i)).get("frequency"));
                cgEntry.set("resultid", ((DynamicObject)taskcg.get(i)).getPkValue());
                taskReportEntry.add(i, cgEntry);
            }
        }
        return taskReport;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actiongId = e.getActionId();
        ListView listView = (ListView)this.getView();
        switch (actiongId) {
            case "refreshcallback": {
                listView.refresh();
                break;
            }
            case "szgx": {
                if (null == e.getReturnData()) break;
                this.bindUserForTask(e, listView, SZGX);
                break;
            }
            case "dutytasktf": {
                if (null == e.getReturnData()) break;
                this.bindUserForTask(e, listView, DUTYTASKTF);
                break;
            }
            case "assisttasktf": {
                if (null == e.getReturnData()) break;
                this.bindUserForTask(e, listView, ASSISTTASKTF);
                break;
            }
            case "choosedept": {
                this.bindDeptForTask(e, listView);
                break;
            }
        }
    }

    protected void taskDeptTransfer() {
        List orgIds = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("deptList"), List.class);
        QFilter qFilter = new QFilter("id", "in", (Object)orgIds);
        boolean beAssitTF = this.getPageCache().get(TFTYPE).equalsIgnoreCase(ASSISTTASKTF);
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"bos_adminorg", (boolean)beAssitTF, (int)1, (boolean)true);
        listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CHOOSEDEPT));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void bindUserForTask(ClosedCallBackEvent e, ListView listView, String operationFlag) {
        ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
        ListSelectedRowCollection listSelectedRows = listView.getSelectedRows();
        ArrayList<Object> taskIds = new ArrayList<Object>();
        for (ListSelectedRow row : listSelectedRows) {
            Object taskId = row.getPrimaryKeyValue();
            taskIds.add(taskId);
        }
        QFilter taskid = new QFilter("id", "in", taskIds);
        QFilter[] filters = new QFilter[]{taskid};
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,sharer,responsibleperson,multicooperationperson,responsibledept,multicooperationdept,relationtask", (QFilter[])filters);
        List deptList = new ArrayList();
        boolean beManyDept = false;
        if (operationFlag.equalsIgnoreCase(SZGX) || operationFlag.equalsIgnoreCase(DUTYTASKTF)) {
            Object userId = rows.get(0).getPrimaryKeyValue();
            if (null != userId) {
                deptList = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId.toString()), (boolean)false);
                Long mainOrgId = null;
                if (deptList.size() > 1) {
                    beManyDept = true;
                    mainOrgId = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(userId.toString()));
                }
                if (StringUtils.equals((CharSequence)operationFlag, (CharSequence)SZGX)) {
                    beManyDept = false;
                    for (DynamicObject task : tasks) {
                        task.set("sharer", userId);
                    }
                } else if (StringUtils.equals((CharSequence)operationFlag, (CharSequence)DUTYTASKTF)) {
                    QFilter relationId = new QFilter("relationtask", "in", taskIds).or("id", "in", taskIds);
                    for (DynamicObject task : tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,sharer,responsibleperson,multicooperationperson,responsibledept,multicooperationdept,relationtask", (QFilter[])new QFilter[]{relationId})) {
                        DynamicObjectCollection coopersons = task.getDynamicObjectCollection("multicooperationperson");
                        List coopersonIds = coopersons.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList());
                        if (coopersons != null && coopersons.size() > 0 && coopersonIds.contains(Long.parseLong(userId.toString()))) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d23\u4efb\u4eba\u4e0e\u534f\u529e\u4eba\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f6c\u4ea4\u3002", (String)"TaskReportListPlugin_13", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        task.set("responsibleperson", userId);
                        task.set("responsibledept", (Object)(mainOrgId != null ? mainOrgId : deptList.get(0)));
                    }
                    this.getPageCache().put(TFTYPE, DUTYTASKTF);
                }
            }
        } else if (StringUtils.equals((CharSequence)operationFlag, (CharSequence)ASSISTTASKTF)) {
            List transferCooPersonIds = rows.stream().map(o -> Long.parseLong(o.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            ORM orm = ORM.create();
            for (DynamicObject task : tasks) {
                if (task.getDynamicObject("responsibleperson") != null && transferCooPersonIds.contains(Long.parseLong(task.getDynamicObject("responsibleperson").getPkValue().toString()))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u534f\u529e\u4eba\u4e0e\u8d23\u4efb\u4eba\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f6c\u4ea4\u3002", (String)"TaskReportListPlugin_15", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject[] coopers = BusinessDataServiceHelper.load((Object[])transferCooPersonIds.toArray(), (DynamicObjectType)MetaDataUtil.getDT((String)"bos", (String)"user"));
                DynamicObjectCollection transferCooPersons = new DynamicObjectCollection();
                DynamicObjectType coopersonDT = task.getDynamicObjectCollection("multicooperationperson").getDynamicObjectType();
                for (int i = 0; i < coopers.length; ++i) {
                    DynamicObject cooper = new DynamicObject(coopersonDT);
                    cooper.set("pkid", (Object)orm.genLongId((IDataEntityType)coopersonDT));
                    cooper.set("fbasedataid", (Object)coopers[i]);
                    cooper.set("fbasedataid_id", coopers[i].getPkValue());
                    transferCooPersons.add((Object)cooper);
                }
                task.set("multicooperationperson", (Object)transferCooPersons);
                List transferCooOrgIds = UserServiceHelper.getUserMainOrgIds(transferCooPersonIds);
                DynamicObject[] coodepts = BusinessDataServiceHelper.load((Object[])transferCooOrgIds.toArray(), (DynamicObjectType)MetaDataUtil.getDT((String)"bos", (String)"org"));
                DynamicObjectCollection transferCooDepts = new DynamicObjectCollection();
                DynamicObjectType coodeptDT = task.getDynamicObjectCollection("multicooperationdept").getDynamicObjectType();
                for (int i = 0; i < coodepts.length; ++i) {
                    DynamicObject coodept = new DynamicObject(coodeptDT);
                    coodept.set("pkid", (Object)orm.genLongId((IDataEntityType)coodeptDT));
                    coodept.set("fbasedataid", (Object)coodepts[i]);
                    coodept.set("fbasedataid_id", coodepts[i].getPkValue());
                    transferCooDepts.add((Object)coodept);
                }
                task.set("multicooperationdept", (Object)transferCooDepts);
            }
            this.getPageCache().put(TFTYPE, ASSISTTASKTF);
            for (Long tranCooPerId : transferCooPersonIds) {
                List userDepts = UserServiceHelper.getUserDepartment((long)tranCooPerId, (boolean)false);
                if (userDepts.size() > 1) {
                    beManyDept = true;
                }
                deptList.addAll(userDepts);
            }
        }
        SaveServiceHelper.save((DynamicObject[])tasks);
        if (beManyDept) {
            this.getPageCache().put("deptList", SerializationUtils.toJsonString(deptList));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6240\u9009\u4eba\u5458\u5c5e\u4e8e\u591a\u4e2a\u90e8\u95e8\uff0c\u8bf7\u9009\u62e9\u5f52\u5c5e\u90e8\u95e8\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TaskReportListPlugin_17", (String)"pccs-placs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CHOOSEDEPT));
            return;
        }
        this.getView().invokeOperation("refresh");
        switch (operationFlag) {
            case "szgx": {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u5b8c\u6210\u3002", (String)"TaskReportListPlugin_41", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                break;
            }
            case "dutytasktf": {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u8f6c\u4ea4\u5b8c\u6210\u3002", (String)"TaskReportListPlugin_50", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                break;
            }
            case "assisttasktf": {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u8f6c\u4ea4\u5b8c\u6210\u3002", (String)"TaskReportListPlugin_50", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void bindDeptForTask(ClosedCallBackEvent e, ListView listView) {
        ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
        String tfType = this.getPageCache().get(TFTYPE);
        ListSelectedRowCollection listSelectedRows = listView.getSelectedRows();
        ArrayList<Object> taskIds = new ArrayList<Object>();
        for (ListSelectedRow row : listSelectedRows) {
            Object taskId = row.getPrimaryKeyValue();
            taskIds.add(taskId);
        }
        QFilter relationId = new QFilter("relationtask", "in", taskIds).or("id", "in", taskIds);
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,sharer,responsibleperson,multicooperationperson,responsibledept,multicooperationdept,relationtask", (QFilter[])new QFilter[]{relationId});
        ORM orm = ORM.create();
        for (DynamicObject task : tasks) {
            if (StringUtils.equals((CharSequence)tfType, (CharSequence)DUTYTASKTF)) {
                Object orgId;
                Object object = orgId = rows != null ? rows.get(0).getPrimaryKeyValue() : null;
                if (null == orgId) continue;
                task.set("responsibledept", orgId);
                continue;
            }
            if (!StringUtils.equals((CharSequence)tfType, (CharSequence)ASSISTTASKTF) || rows == null || rows.size() <= 0) continue;
            Object[] orgIds = rows.getPrimaryKeyValues();
            DynamicObject[] orgs = BusinessDataServiceHelper.load((Object[])orgIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
            DynamicObjectType orgDT = task.getDynamicObjectCollection("multicooperationdept").getDynamicObjectType();
            DynamicObjectCollection depts = new DynamicObjectCollection();
            for (int i = 0; i < orgs.length; ++i) {
                DynamicObject dept = new DynamicObject(orgDT);
                dept.set("pkid", (Object)orm.genLongId((IDataEntityType)orgDT));
                dept.set("fbasedataid", (Object)orgs[i]);
                dept.set("fbasedataid_id", orgs[i].getPkValue());
                depts.add((Object)dept);
            }
            task.set("multicooperationdept", (Object)depts);
        }
        SaveServiceHelper.save((DynamicObject[])tasks);
        this.getView().invokeOperation("refresh");
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u8f6c\u4ea4\u5b8c\u6210\u3002", (String)"TaskReportListPlugin_50", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
    }

    protected Set<Object> getProjectKinds(DynamicObject[] projects) {
        HashSet<Object> kinds = new HashSet<Object>(projects.length);
        for (DynamicObject project : projects) {
            DynamicObject kind = project.getDynamicObject(this.getProjectKind());
            if (kind == null) continue;
            kinds.add(kind.getPkValue());
        }
        return kinds;
    }

    protected List<ComboItem> buildPlanTypeComboItems(Object projectId) {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
        DynamicObject[] projects = projectId instanceof ArrayList ? BusinessDataServiceHelper.load((Object[])((ArrayList)projectId).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getProjectFormId())) : BusinessDataServiceHelper.load((Object[])new Object[]{projectId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getProjectFormId()));
        Set<Object> kinds = this.getProjectKinds(projects);
        kinds.add(0L);
        QFilter filter = new QFilter("group", "in", kinds);
        QFilter planTypeFilter = new QFilter("plantype", "!=", (Object)PlanTypeEnum.MAJORPLAN.getValue());
        filter.or(planTypeFilter);
        DynamicObject[] majors = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"plantype,plantypename", (QFilter[])new QFilter[]{filter}, (String)"plantype asc,number asc");
        if (majors.length > 0) {
            for (DynamicObject planType : majors) {
                PlanTypeEnum typeEnum = PlanTypeEnum.getEnumByValue((Object)planType.get("plantype"));
                if (typeEnum == null) continue;
                ComboItem item = new ComboItem();
                item.setId(planType.getPkValue().toString());
                item.setCaption(new LocaleString(planType.getString("plantypename")));
                item.setValue(planType.getPkValue().toString());
                if (typeEnum == PlanTypeEnum.MAINPLAN || typeEnum == PlanTypeEnum.DEPTPLAN || typeEnum == PlanTypeEnum.PRIVATEPLAN || typeEnum == PlanTypeEnum.DEPTFENJIEPLAN) {
                    combos.add(0, item);
                    continue;
                }
                combos.add(item);
            }
        }
        return combos;
    }

    protected String getProjectKind() {
        return "group";
    }

    protected String getProjectFormId() {
        return "bd_project";
    }
}

