/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.api.BizProcessStatus;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.base.AbstractPlacsListPlugin;
import org.apache.commons.lang3.StringUtils;

public class WorkFlowFlexListPlugin
extends AbstractPlacsListPlugin {
    private static Log log = LogFactory.getLog(WorkFlowFlexListPlugin.class);
    private Map<String, String> auditorsMap = new HashMap<String, String>();
    private Map<String, String> taskIdAndReportId = new HashMap<String, String>();
    private String enName = "";

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                List<Object> pkIds;
                DynamicObjectCollection rows = super.getData(arg0, arg1);
                if (rows.isEmpty()) {
                    return rows;
                }
                String entityName = this.getEntityType().getName();
                WorkFlowFlexListPlugin.this.enName = entityName;
                if (entityName.contains("reporttaskview")) {
                    for (DynamicObject row : rows) {
                        BigDecimal rtd = row.getBigDecimal("realtimedeviation");
                        if (rtd.compareTo(BigDecimal.ZERO) < 0) {
                            row.set("realtimedeviation", (Object)rtd.multiply(new BigDecimal(-1)));
                            continue;
                        }
                        row.set("realtimedeviation", (Object)BigDecimal.ZERO);
                    }
                }
                long t1 = System.currentTimeMillis();
                if (entityName.contains("reporttaskview")) {
                    DynamicObject[] latestReports;
                    pkIds = new ArrayList();
                    rows.forEach(v -> pkIds.add(Long.valueOf(v.getPkValue().toString())));
                    QFilter latestFilter = new QFilter("latest", "=", (Object)Boolean.TRUE);
                    QFilter taskIdFilter = new QFilter("task", "in", pkIds);
                    QFilter statusFilter = new QFilter("billstatus", "!=", (Object)StatusEnum.CHECKED.getValue());
                    for (DynamicObject report : latestReports = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)WorkFlowFlexListPlugin.this.getAppId(), (String)"taskreport"), (String)"id,percent,autocomplete,task", (QFilter[])new QFilter[]{latestFilter, taskIdFilter, statusFilter})) {
                        WorkFlowFlexListPlugin.this.taskIdAndReportId.put(report.getDynamicObject("task").getPkValue().toString(), report.getPkValue().toString());
                    }
                    List latestReportIds = Arrays.stream(latestReports).map(o -> o.getPkValue().toString()).collect(Collectors.toList());
                    if (!latestReportIds.isEmpty()) {
                        WorkFlowFlexListPlugin.this.getNextAuditors(latestReportIds);
                    }
                } else {
                    pkIds = rows.stream().filter(o -> !StatusEnum.CHECKED.getValue().equals(o.get("billstatus"))).map(o -> o.getPkValue().toString()).collect(Collectors.toList());
                    if (!pkIds.isEmpty()) {
                        WorkFlowFlexListPlugin.this.getNextAuditors(pkIds);
                    }
                }
                long t2 = System.currentTimeMillis();
                log.info("\u5ba1\u6838\u4eba\u6570\u636e\u52a0\u8f7dB \u7528\u65f6\uff1a " + (t2 - t1) + "ms");
                return rows;
            }
        });
    }

    public void packageData(PackageDataEvent e) {
        String columnKey;
        super.packageData(e);
        if (e.getSource() instanceof ColumnDesc && "nextauditor".equals(columnKey = ((ColumnDesc)e.getSource()).getKey()) && this.auditorsMap != null && this.auditorsMap.size() > 0) {
            String id = e.getRowData().getPkValue().toString();
            if (this.enName.contains("reporttaskview")) {
                id = this.taskIdAndReportId.get(id);
            }
            String auditor = this.auditorsMap.get(id);
            e.setFormatValue((Object)auditor);
        }
    }

    private void getNextAuditors(List<String> pkIds) {
        this.auditorsMap = new HashMap<String, String>(pkIds.size());
        String[] ids = new String[pkIds.size()];
        String nodeName = "";
        pkIds.toArray(ids);
        Map allPro = WorkflowServiceHelper.getBizProcessStatus((String[])ids);
        for (Map.Entry entry : allPro.entrySet()) {
            List node = (List)entry.getValue();
            int count = 0;
            StringBuilder participantName = new StringBuilder();
            StringBuilder msg = new StringBuilder();
            try {
                for (BizProcessStatus e : node) {
                    nodeName = e.getCurrentNodeName();
                    String auditor = e.getParticipantName();
                    participantName.append(",");
                    if (e.getProcessStatus().equals("2")) {
                        participantName.append(ResManager.loadKDString((String)"\u6302\u8d77", (String)"WorkFlowFlexListPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    } else if (auditor != null && !"".equals(auditor.trim())) {
                        participantName.append(auditor);
                    }
                    if (++count != 3) continue;
                    participantName.append("...");
                    break;
                }
                if (!StringUtils.isBlank((CharSequence)nodeName)) {
                    msg.append(nodeName);
                    if (!StringUtils.isBlank((CharSequence)participantName)) {
                        msg.append('/');
                        msg.append(participantName.toString().replaceFirst(",", ""));
                    }
                }
            }
            catch (Exception e) {
                log.info("ErWorkFlowFlexListForOtherPlugin>>>\u83b7\u53d6\u5ba1\u6279\u4eba\u51fa\u73b0\u5f02\u5e38: " + e.getMessage());
            }
            this.auditorsMap.put((String)entry.getKey(), msg.toString());
        }
    }
}

