/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.pccs.placs.business.utils.task.WorkHoursUtils;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.base.AbstractPlacsListPlugin;
import org.apache.commons.lang3.StringUtils;

public class WorkHoursBillListPlugin
extends AbstractPlacsListPlugin {
    private static final Log logger = LogFactory.getLog(WorkHoursBillListPlugin.class);
    private static final String CANCEL_OP = "cancel";
    private String OWNER_FILTER_VALUE = "103";
    private static final String CURRENT_USER = "103";
    private static final String OTHER_USER = "104";

    public void filterContainerInit(FilterContainerInitArgs args) {
        CommonFilterColumn ownerUserFilter;
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        String currenUserId = RequestContext.get().getUserId();
        WorkHoursUtils unit = this.getUtil();
        if ((unit.isProjMaster(currenUserId) || unit.isDeptManager(currenUserId)) && !filterColumnList.contains(ownerUserFilter = this.buildOwnerFilterColumn())) {
            ownerUserFilter.setDefaultValue(RequestContext.get().getUserId());
            ownerUserFilter.setConstantDefaultValue((Object)CURRENT_USER);
            filterColumnList.add(ownerUserFilter);
        }
        super.filterContainerInit(args);
    }

    protected CommonFilterColumn buildOwnerFilterColumn() {
        CommonFilterColumn ownerUserFilter = new CommonFilterColumn();
        ownerUserFilter.setKey("owner.id");
        ownerUserFilter.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5de5\u65f6\u5f52\u5c5e\u4eba", (String)"WorkHoursBillListPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0])));
        ownerUserFilter.setFieldName("owner.id");
        ownerUserFilter.setEntryEntity(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"workhours_bill"));
        ownerUserFilter.setMustInput(false);
        ownerUserFilter.setType("user");
        return ownerUserFilter;
    }

    public void setFilter(SetFilterEvent e) {
        String currenUserId = RequestContext.get().getUserId();
        List filters = e.getQFilters();
        QFilter qFilter = null;
        WorkHoursUtils unit = this.getUtil();
        boolean isProjMaster = unit.isProjMaster(currenUserId);
        boolean isDeptManager = unit.isDeptManager(currenUserId);
        if (isProjMaster || isDeptManager) {
            List managerDepts;
            List projManagerProjects;
            if (StringUtils.isBlank((CharSequence)this.OWNER_FILTER_VALUE)) {
                qFilter = new QFilter("owner.id", "=", (Object)Long.valueOf(currenUserId));
            }
            if (isProjMaster && (StringUtils.isBlank((CharSequence)this.OWNER_FILTER_VALUE) || StringUtils.equals((CharSequence)OTHER_USER, (CharSequence)this.OWNER_FILTER_VALUE)) && !CollectionUtils.isEmpty((Collection)(projManagerProjects = unit.getProjManagerProjects(currenUserId)))) {
                if (qFilter == null) {
                    qFilter = new QFilter("project.id", "in", (Object)projManagerProjects);
                } else {
                    qFilter.or(new QFilter("project.id", "in", (Object)projManagerProjects));
                }
            }
            if (isDeptManager && (StringUtils.isBlank((CharSequence)this.OWNER_FILTER_VALUE) || StringUtils.equals((CharSequence)OTHER_USER, (CharSequence)this.OWNER_FILTER_VALUE)) && !CollectionUtils.isEmpty((Collection)(managerDepts = unit.getManagerDepts(currenUserId)))) {
                if (qFilter == null) {
                    qFilter = new QFilter("depart.id", "in", (Object)managerDepts);
                } else {
                    qFilter.or(new QFilter("depart.id", "in", (Object)managerDepts));
                }
            }
            filters.add(qFilter);
        } else {
            QFilter qfilter = new QFilter("owner.id", "=", (Object)Long.valueOf(currenUserId));
            filters.add(qfilter);
        }
        e.setOrderBy("createtime desc,billno desc");
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFiterList = (List)filterValues.get("customfilter");
        if (customFiterList == null) {
            return;
        }
        for (int i = customFiterList.size() - 1; i >= 0; --i) {
            List values;
            Map customFiter = (Map)customFiterList.get(i);
            List fieldNames = (List)customFiter.get("FieldName");
            if (fieldNames == null || fieldNames.isEmpty() || !StringUtils.equals((CharSequence)"owner.id", (CharSequence)((String)fieldNames.get(0))) || (values = (List)customFiter.get("Value")) == null || values.isEmpty()) continue;
            if (values.get(0) == null || StringUtils.isBlank((CharSequence)values.get(0).toString())) {
                this.OWNER_FILTER_VALUE = null;
                break;
            }
            this.OWNER_FILTER_VALUE = values.get(0).toString();
            break;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && (StringUtils.equals((CharSequence)"submit", (CharSequence)formOperate.getOperateKey()) || StringUtils.equals((CharSequence)"audit", (CharSequence)formOperate.getOperateKey()) || StringUtils.equals((CharSequence)CANCEL_OP, (CharSequence)formOperate.getOperateKey()))) {
            this.getView().invokeOperation("refresh");
        }
        super.afterDoOperation(args);
    }

    protected WorkHoursUtils getUtil() {
        return new WorkHoursUtils(this.getView());
    }
}

