/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.placs.business.utils.task.WorkHoursUtils;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.base.AbstractPlacsFormPlugin;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class WorkHoursBillPlugin
extends AbstractPlacsFormPlugin {
    private static final String CANCEL_OP = "cancel";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.refreshEntity(e);
    }

    protected void refreshEntity(EventObject e) {
        this.setHeaderTitle();
        this.setCellStyle();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && (StringUtils.equals((CharSequence)"submit", (CharSequence)formOperate.getOperateKey()) || StringUtils.equals((CharSequence)"audit", (CharSequence)formOperate.getOperateKey()) || StringUtils.equals((CharSequence)CANCEL_OP, (CharSequence)formOperate.getOperateKey()))) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void setCellStyle() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("taskworkhours");
        DynamicObject workHoursBillObj = this.getModel().getDataEntity(true);
        Date workhoursstarttime = workHoursBillObj.getDate("workhoursstarttime");
        DynamicObjectCollection entrys = workHoursBillObj.getDynamicObjectCollection("taskworkhours");
        if (CollectionUtils.isEmpty((Collection)entrys)) {
            return;
        }
        for (int rowIndex = 0; rowIndex < entrys.size(); ++rowIndex) {
            DynamicObject item = (DynamicObject)entrys.get(rowIndex);
            DynamicObject taskObj = item.getDynamicObject("task");
            for (int j = 1; j <= 7; ++j) {
                Date workdate = DateUtils.addDays((Date)DateUtil.getThisWeekSunDay((Date)workhoursstarttime), (int)(j - 1));
                DynamicObject workhoursObj = WorkHoursUtils.getWorkhoursObj((Date)(workdate = DateUtil.parseShortDate((String)DateUtil.formatShortDate((Date)workdate))), (DynamicObject)taskObj, (String)this.getAppId());
                if (workhoursObj == null) continue;
                boolean belongCurrentWorkHoursBill = false;
                String oriBIllID = workHoursBillObj.getString("oribillid");
                if (StringUtils.isBlank((CharSequence)oriBIllID)) {
                    Map splitBills = WorkHoursUtils.getSplitBills((String)workHoursBillObj.getPkValue().toString(), (String)this.getAppId());
                    for (Map.Entry entry : splitBills.entrySet()) {
                        DynamicObject obj = (DynamicObject)entry.getValue();
                        if (!this.belongCurrentWorkHoursBill(obj, workhoursObj).booleanValue()) continue;
                        belongCurrentWorkHoursBill = true;
                        break;
                    }
                } else if (this.belongCurrentWorkHoursBill(workHoursBillObj, workhoursObj).booleanValue()) {
                    belongCurrentWorkHoursBill = true;
                }
                if (belongCurrentWorkHoursBill) continue;
                String columPrefix = "day_" + j;
                String actualColumKey = columPrefix + "_actual";
                String effectiveColumKey = columPrefix + "_effective";
                ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(10);
                CellStyle cellStyle = new CellStyle();
                cellStyle.setRow(rowIndex);
                cellStyle.setFieldKey(actualColumKey);
                cellStyle.setForeColor("#b2b2b2");
                cellStyles.add(cellStyle);
                CellStyle effecteiveCellStyle = new CellStyle();
                effecteiveCellStyle.setRow(rowIndex);
                effecteiveCellStyle.setFieldKey(effectiveColumKey);
                effecteiveCellStyle.setForeColor("#b2b2b2");
                cellStyles.add(effecteiveCellStyle);
                entryGrid.setCellStyle(cellStyles);
            }
        }
    }

    protected Boolean belongCurrentWorkHoursBill(DynamicObject workHoursBillObj, DynamicObject workHoursObj) {
        QFilter workHoursBillFilter = new QFilter("workhoursbillid", "=", (Object)workHoursBillObj.getPkValue().toString());
        QFilter workHoursFilter = new QFilter("workhours", "=", workHoursObj.getPkValue());
        return QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"workhours_billmap"), (QFilter[])new QFilter[]{workHoursBillFilter, workHoursFilter});
    }

    protected void setHeaderTitle() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("taskworkhours");
        Date workhoursstarttime = this.getModel().getDataEntity(true).getDate("workhoursstarttime");
        Map days = WorkHoursUtils.getDays((Date)workhoursstarttime, (Date)DateUtils.addDays((Date)workhoursstarttime, (int)6));
        String shortdays = StringUtils.join((Iterable)((Iterable)days.get("shortdays")), (String)",");
        String[] split = shortdays.split(",");
        ArrayList<LocaleString> titles = new ArrayList<LocaleString>(10);
        if (split != null) {
            for (String dayShort : split) {
                titles.add(new LocaleString("zh_CN", dayShort));
            }
            for (int i = 1; i <= 7; ++i) {
                String key = "day_" + i + "_group";
                Control control = this.getView().getControl(key);
                if (control == null) break;
                entryGrid.setColumnProperty(control.getKey(), "header", (Object)new LocaleString("zh_CN", titles.get(i - 1)));
            }
        }
    }
}

