/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.placs.business.model.TaskConstant;
import kd.pccs.placs.business.model.WorkhoursListConstant;
import kd.pccs.placs.business.utils.task.WorkHoursUtils;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.EnableEnum;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.base.AbstractPlacsFormPlugin;
import kd.pccs.placs.formplugin.model.PlanTaskModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class WorkHoursListPlugin
extends AbstractPlacsFormPlugin
implements ClickListener {
    private static final Log logger = LogFactory.getLog(WorkHoursListPlugin.class);
    private static final String BUTTONSTATUSPREFIX = "btn_status_";
    private static final String BUTTONPLANFINISHDATEPREFIX = "btn_planfinishdate_";
    private static final String BUTTONFROMTYPEPREFIX = "btn_fromtype_";
    private static final String DATERANGEPREFIX = "daterangefield_";
    private static final String ENTRYCOLUMNKEYPREFIX = "day_";
    private static final String ENTRYCOLUMNKEY_DAYGROUP_SUFFIX = "_group";
    private static final String SPLICE_STR = "_";
    private static final String ENTRYCOLUMNKEY_ACTUAL_SUFFIX = "_actual";
    private static final String ENTRYCOLUMNKEY_EFFECTIVE_SUFFIX = "_effective";
    private static final String PLANENDTIMEBEGIN = "planendtime_begin";
    private static final String PLANENDTIMEEND = "planendtime_end";
    private static final String BUTTONREFRESH = "buttonrefresh";
    private static final String BUTTONLASTWEEK = "buttonlastweek";
    private static final String BUTTONTHISWEEK = "buttonthisweek";
    private static final String BUTTONNEXTWEEK = "buttonnextweek";
    private static final String GENERATE_WORKHOURSBILL_OP = "generateworkhoursbill";
    private static final String WORKHOURSBILL_LIST_OP = "workhoursbilllist";
    private static BigDecimal STANDARD_HOURS = new BigDecimal("24");
    private static final List<String> PLAN_FINISHDATE_LIST = Stream.of("btn_planfinishdate_0", "btn_planfinishdate_1", "btn_planfinishdate_2", "btn_planfinishdate_3", "btn_planfinishdate_4").collect(Collectors.toList());

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String oldWeek = this.getPageCache().get("week");
        if (StringUtils.isEmpty((CharSequence)oldWeek)) {
            this.setPageCache("week", WorkhoursListConstant.WeekParam.THISWEEK.getValue());
            this.setWeekDaysCache();
            this.updateWeekButtonStyle(WorkhoursListConstant.WeekParam.THISWEEK);
            this.initQueryBtnSelected();
        }
        this.refreshDataGrid(this.getAppId());
    }

    protected void initQueryBtnSelected() {
        int i;
        this.getPageCache().put("btn_status_0", "false");
        this.getPageCache().put("btn_planfinishdate_0", "true");
        this.getPageCache().put("btn_fromtype_0", "true");
        this.updateBtnSelectedStyle("btn_status_0", false);
        this.updateBtnSelectedStyle("btn_planfinishdate_0", true);
        this.updateBtnSelectedStyle("btn_fromtype_0", true);
        this.getPageCache().put("btn_status_2", "true");
        this.getPageCache().put("btn_status_3", "true");
        this.getPageCache().put("btn_status_6", "true");
        for (i = 1; i <= 6; ++i) {
            if (i == 2 || i == 3 || i == 6) {
                this.updateBtnSelectedStyle(BUTTONSTATUSPREFIX + i, true);
                continue;
            }
            this.updateBtnSelectedStyle(BUTTONSTATUSPREFIX + i, false);
        }
        for (i = 1; i <= 5; ++i) {
            this.updateBtnSelectedStyle(BUTTONPLANFINISHDATEPREFIX + i, false);
        }
        for (i = 1; i <= 5; ++i) {
            this.updateBtnSelectedStyle(BUTTONFROMTYPEPREFIX + i, false);
        }
    }

    public void registerListener(EventObject e) {
        int i;
        super.registerListener(e);
        Button button1 = (Button)this.getView().getControl(BUTTONREFRESH);
        button1.addClickListener((ClickListener)this);
        Button button2 = (Button)this.getView().getControl(BUTTONLASTWEEK);
        button2.addClickListener((ClickListener)this);
        Button button3 = (Button)this.getView().getControl(BUTTONTHISWEEK);
        button3.addClickListener((ClickListener)this);
        Button button4 = (Button)this.getView().getControl(BUTTONNEXTWEEK);
        button4.addClickListener((ClickListener)this);
        for (i = 0; i <= 6; ++i) {
            Button status = (Button)this.getView().getControl(BUTTONSTATUSPREFIX + i);
            status.addClickListener((ClickListener)this);
        }
        for (i = 0; i <= 5; ++i) {
            Button planfinishdate = (Button)this.getView().getControl(BUTTONPLANFINISHDATEPREFIX + i);
            planfinishdate.addClickListener((ClickListener)this);
        }
        for (i = 0; i <= 5; ++i) {
            Button fromtype = (Button)this.getView().getControl(BUTTONFROMTYPEPREFIX + i);
            fromtype.addClickListener((ClickListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        String appId = this.getAppId();
        if (BUTTONREFRESH.equals(key)) {
            this.refreshDataGrid(appId);
        } else if (BUTTONLASTWEEK.equals(key)) {
            this.handleLastWeekClickEvent();
            this.refreshDataGrid(appId);
        } else if (BUTTONTHISWEEK.equals(key)) {
            this.handleThisWeekClickEvent();
            this.refreshDataGrid(appId);
        } else if (BUTTONNEXTWEEK.equals(key)) {
            this.handleNextWeekClickEvent();
            this.refreshDataGrid(appId);
        } else if (key != null && key.startsWith(BUTTONSTATUSPREFIX)) {
            boolean flag = this.getInvertSelectdValue(key);
            if (!flag && "btn_status_0".equals(key)) {
                this.getPageCache().put(key, "true");
            } else {
                this.handleStatusChangeEvent(key, flag);
                this.refreshDataGrid(appId);
            }
        } else if (key != null && key.startsWith(BUTTONPLANFINISHDATEPREFIX)) {
            if ("btn_planfinishdate_5".equals(key)) {
                return;
            }
            boolean flag = this.getInvertSelectdValue(key);
            if (!flag && "btn_planfinishdate_0".equals(key)) {
                this.getPageCache().put(key, "true");
            } else {
                this.handlePlanfinishdateChangeEvent(key, flag);
                this.refreshDataGrid(appId);
            }
        } else if (key != null && key.startsWith(BUTTONFROMTYPEPREFIX)) {
            boolean flag = this.getInvertSelectdValue(key);
            if (!flag && "btn_fromtype_0".equals(key)) {
                this.getPageCache().put(key, "true");
            } else {
                this.handleFromTypeChangeEvent(key, flag);
                this.refreshDataGrid(appId);
            }
        }
    }

    protected boolean getInvertSelectdValue(String key) {
        boolean flag;
        String s = this.getPageCache().get(key);
        if ("true".equals(s)) {
            flag = false;
            this.getPageCache().put(key, "false");
        } else {
            flag = true;
            this.getPageCache().put(key, "true");
        }
        return flag;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (name == null) {
            return;
        }
        ChangeData[] valueSet = e.getChangeSet();
        if (name.startsWith(ENTRYCOLUMNKEYPREFIX)) {
            this.entryDayChange(name, valueSet[0]);
        } else if (name.startsWith(DATERANGEPREFIX)) {
            this.refreshDataGrid(this.getAppId());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "generateworkhoursbill": {
                OperationResult operationResult = args.getOperationResult();
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"WorkHoursListPlugin_5", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                break;
            }
            case "workhoursbilllist": {
                ListShowParameter para = ShowFormHelper.createShowListForm((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"workhours_bill"), (boolean)true, (int)2, (boolean)false);
                this.getView().showForm((FormShowParameter)para);
                break;
            }
        }
    }

    protected void entryDayChange(String name, ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        DynamicObject task = (DynamicObject)this.getModel().getValue("task", rowIndex);
        Object pkValue = task.getPkValue();
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        boolean isActualWorkHour = this.isActualWorkHour(name);
        BigDecimal standardHours = this.getStandardHours();
        BigDecimal currentTotalActuralWorkHours = BigDecimal.ZERO;
        BigDecimal currenTotalEffectiveWorkHours = BigDecimal.ZERO;
        DynamicObject[] workHourObjs = this.getDayTotalWorkHours(name, pkValue);
        if (workHourObjs != null && workHourObjs.length != 0) {
            if (isActualWorkHour) {
                BigDecimal currentFilterTotalActuralWorkHours = Arrays.stream(workHourObjs).map(workHourObj -> (BigDecimal)workHourObj.get("actualhour")).reduce(BigDecimal.ZERO, BigDecimal::add);
                currentTotalActuralWorkHours = currentTotalActuralWorkHours.add(currentFilterTotalActuralWorkHours);
                currentTotalActuralWorkHours = currentTotalActuralWorkHours.add(newValue == null ? BigDecimal.ZERO : (BigDecimal)newValue);
                if ((currentTotalActuralWorkHours = currentTotalActuralWorkHours.setScale(2, 1)).compareTo(standardHours) > 0) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5929\u5b9e\u9645\u603b\u5de5\u65f6\u4e3a%1$s\u5c0f\u65f6\uff0c\u5df2\u8d85\u8fc7%2$s\u5c0f\u65f6\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"WorkHoursListPlugin_6", (String)"pccs-placs-formplugin", (Object[])new Object[0]), currentTotalActuralWorkHours, standardHours), Integer.valueOf(2500));
                    this.getModel().setValue(name, oldValue, rowIndex);
                    return;
                }
            } else {
                BigDecimal currentFilterTotalEffectiveWorkHours = Arrays.stream(workHourObjs).map(workHourObj -> (BigDecimal)workHourObj.get("effectivehour")).reduce(BigDecimal.ZERO, BigDecimal::add);
                currenTotalEffectiveWorkHours = currenTotalEffectiveWorkHours.add(currentFilterTotalEffectiveWorkHours);
                currenTotalEffectiveWorkHours = currenTotalEffectiveWorkHours.add(newValue == null ? BigDecimal.ZERO : (BigDecimal)newValue);
                if ((currenTotalEffectiveWorkHours = currenTotalEffectiveWorkHours.setScale(2, 1)).compareTo(standardHours) > 0) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5929\u6709\u6548\u603b\u5de5\u65f6\u4e3a%1$s\u5c0f\u65f6\u3002\u5df2\u8d85\u8fc7%2$s\u5c0f\u65f6\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"WorkHoursListPlugin_8", (String)"pccs-placs-formplugin", (Object[])new Object[0]), currenTotalEffectiveWorkHours, standardHours), Integer.valueOf(2500));
                    this.getModel().setValue(name, oldValue, rowIndex);
                    return;
                }
            }
        }
        if (newValue != null) {
            this.saveOrUpdateWorkHour(pkValue, name, (BigDecimal)newValue);
        }
        BigDecimal sum = BigDecimal.ZERO;
        BigDecimal effectiveSum = BigDecimal.ZERO;
        for (int i = 1; i <= 7; ++i) {
            String columKey = ENTRYCOLUMNKEYPREFIX + i + ENTRYCOLUMNKEY_ACTUAL_SUFFIX;
            BigDecimal hour = (BigDecimal)this.getModel().getValue(columKey, rowIndex);
            sum = sum.add(hour);
            String effectiveColumKey = ENTRYCOLUMNKEYPREFIX + i + ENTRYCOLUMNKEY_EFFECTIVE_SUFFIX;
            BigDecimal effctiveHour = (BigDecimal)this.getModel().getValue(effectiveColumKey, rowIndex);
            effectiveSum = effectiveSum.add(effctiveHour);
        }
        this.getModel().setValue("daysum_actual", (Object)sum, rowIndex);
        this.getModel().setValue("daysum_effective", (Object)effectiveSum, rowIndex);
        if (isActualWorkHour) {
            this.fillEffectiveWorkHour(name, newValue, rowIndex);
        }
    }

    protected BigDecimal getStandardHours() {
        return STANDARD_HOURS;
    }

    protected Boolean isActualWorkHour(String columKey) {
        return columKey.startsWith(ENTRYCOLUMNKEYPREFIX) && columKey.endsWith(ENTRYCOLUMNKEY_ACTUAL_SUFFIX);
    }

    protected DynamicObject[] getDayTotalWorkHours(String key, Object excludeTaskID) {
        String userId = RequestContext.get().getUserId();
        Date workdate = this.getChangedColumnDate(Integer.parseInt(key.split(SPLICE_STR)[1]));
        ArrayList<QFilter> qlist = new ArrayList<QFilter>(10);
        qlist.add(new QFilter("workdate", "=", (Object)workdate));
        qlist.add(new QFilter("creator", "=", (Object)Long.valueOf(userId)));
        qlist.add(new QFilter("task", "<>", excludeTaskID));
        qlist.add(new QFilter("task.islatest", "=", (Object)"1"));
        DynamicObject[] workHourObjs = BusinessDataServiceHelper.load((String)(this.getAppId() + SPLICE_STR + "workhours"), (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,task,workdate,actualhour,effectivehour", (QFilter[])qlist.toArray(new QFilter[qlist.size()]));
        return workHourObjs;
    }

    protected void fillEffectiveWorkHour(String name, Object newValue, int rowIndex) {
        String effectiveKey = name.replace(ENTRYCOLUMNKEY_ACTUAL_SUFFIX, ENTRYCOLUMNKEY_EFFECTIVE_SUFFIX);
        Object effecticeValue = this.getModel().getValue(effectiveKey, rowIndex);
        if (effecticeValue != null && ((BigDecimal)effecticeValue).compareTo(BigDecimal.ZERO) != 0) {
            return;
        }
        this.getModel().setValue(effectiveKey, newValue, rowIndex);
    }

    protected void saveOrUpdateWorkHour(Object pkValue, String name, BigDecimal workhour) {
        String userId = RequestContext.get().getUserId();
        Date workdate = this.getChangedColumnDate(Integer.parseInt(name.split(SPLICE_STR)[1]));
        ArrayList<QFilter> qlist = new ArrayList<QFilter>(10);
        qlist.add(new QFilter("workdate", "=", (Object)workdate));
        qlist.add(new QFilter("creator", "=", (Object)Long.valueOf(userId)));
        qlist.add(new QFilter("task", "=", pkValue));
        DynamicObject[] old = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"workhours"), (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,task,workdate,actualhour,effectivehour", (QFilter[])qlist.toArray(new QFilter[qlist.size()]), (String)"modifytime desc");
        DynamicObject workHourObject = new DynamicObject(MetaDataUtil.getDT((String)this.getAppId(), (String)"workhours"));
        Date currentDate = DateUtil.getCurrentDate();
        if (old.length > 0) {
            workHourObject = old[0];
            if (this.isActualWorkHour(name).booleanValue()) {
                workHourObject.set("actualhour", (Object)workhour);
            } else {
                workHourObject.set("effectivehour", (Object)workhour);
            }
            workHourObject.set("modifier", (Object)userId);
            workHourObject.set("modifytime", (Object)currentDate);
        } else {
            if (this.isActualWorkHour(name).booleanValue()) {
                workHourObject.set("actualhour", (Object)workhour);
            } else {
                workHourObject.set("effectivehour", (Object)workhour);
            }
            workHourObject.set("modifytime", (Object)currentDate);
            workHourObject.set("modifier", (Object)userId);
            workHourObject.set("creator", (Object)userId);
            workHourObject.set("createtime", (Object)currentDate);
            workHourObject.set("enable", (Object)EnableEnum.ENABLE.getValue());
            workHourObject.set("workdate", (Object)workdate);
            workHourObject.set("status", (Object)StatusEnum.TEMPSAVE.getValue());
            workHourObject.set("task", pkValue);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{workHourObject});
    }

    protected Date getChangedColumnDate(int column) {
        String daysStr = "";
        String week = this.getPageCache().get("week");
        if (week.equals(WorkhoursListConstant.WeekParam.THISWEEK.getValue())) {
            daysStr = this.getPageCache().get("THIS_WEEK_DAYS");
        } else if (week.equals(WorkhoursListConstant.WeekParam.NEXTWEEK.getValue())) {
            daysStr = this.getPageCache().get("NEXT_WEEK_DAYS");
        } else if (week.equals(WorkhoursListConstant.WeekParam.LASTWEEK.getValue())) {
            daysStr = this.getPageCache().get("LAST_WEEK_DAYS");
        }
        return DateUtil.parseShortDate((String)daysStr.split(",")[column - 1]);
    }

    protected void setHeaderTitle() {
        Object s;
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        ArrayList<LocaleString> titles = new ArrayList<LocaleString>(10);
        String[] split = null;
        String week = this.getPageCache().get("week");
        if (week.equals(WorkhoursListConstant.WeekParam.THISWEEK.getValue())) {
            s = this.getPageCache().get("THIS_WEEK_DAYS_SHORT");
            split = ((String)s).split(",");
        } else if (week.equals(WorkhoursListConstant.WeekParam.LASTWEEK.getValue())) {
            s = this.getPageCache().get("LAST_WEEK_DAYS_SHORT");
            split = ((String)s).split(",");
        } else if (week.equals(WorkhoursListConstant.WeekParam.NEXTWEEK.getValue())) {
            s = this.getPageCache().get("NEXT_WEEK_DAYS_SHORT");
            split = ((String)s).split(",");
        }
        if (split != null) {
            for (String dayShort : split) {
                titles.add(new LocaleString("zh_CN", dayShort));
            }
            for (int i = 1; i <= 7; ++i) {
                String key = ENTRYCOLUMNKEYPREFIX + i + ENTRYCOLUMNKEY_DAYGROUP_SUFFIX;
                Control control = this.getView().getControl(key);
                if (control == null) break;
                grid.setColumnProperty(control.getKey(), "header", (Object)new LocaleString("zh_CN", titles.get(i - 1)));
            }
        }
    }

    protected void refreshDataGrid(String appId) {
        this.updatePlanEndRangeFilter();
        this.setHeaderTitle();
        LinkedHashMap<String, Object> filterMap = new LinkedHashMap<String, Object>();
        List<QFilter> filters = this.getQueryFilter(filterMap);
        DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)TaskConstant.AllProperty, (QFilter[])filters.toArray(new QFilter[filters.size()]));
        List<PlanTaskModel> firstTaskList = this.queryTaskWithReport(filterMap, appId);
        List<PlanTaskModel> secondTaskIds = this.getSortedTaskDynamicObject(dynamicObject);
        List<PlanTaskModel> thirdTaskList = this.queryTaskWithDelayedTasked(filterMap, appId);
        List<PlanTaskModel> tasks = this.getUnionTasks(firstTaskList, secondTaskIds, thirdTaskList);
        Object projectPk = this.getView().getFormShowParameter().getCustomParams().get("project");
        Object sourceOpen = this.getView().getFormShowParameter().getCustomParam("source");
        if ("masterplan".equals(sourceOpen) && projectPk != null) {
            tasks = tasks.stream().filter(task -> projectPk.toString().equals(task.getProject())).collect(Collectors.toList());
        }
        Date workHoursStartTime = DateUtil.parseShortDate((String)this.getPageCache().get("WEEKFIRSTDAY"));
        this.getModel().setValue("workhoursstarttime", (Object)workHoursStartTime);
        this.getModel().deleteEntryData("entryentity");
        this.getModel().beginInit();
        for (PlanTaskModel task2 : tasks) {
            int row = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("task", (Object)task2.getId(), row);
            this.getModel().setValue("majortype", (Object)task2.getPlanTypeView(), row);
            this.getModel().setValue("completionstatus", (Object)task2.getCompleteStatus(), row);
            DynamicObject[] taskHours = this.queryTaskHours(task2.getId());
            this.fillCellValueAndStyle(row, taskHours);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    protected List<PlanTaskModel> queryTaskWithDelayedTasked(Map<String, Object> filterMap, String appId) {
        Date planendtimeend;
        Date planendtimebegin;
        Object majortypes;
        Date begin = DateUtil.parseShortDate((String)this.getPageCache().get("WEEKFIRSTDAY"));
        String sqlStr = String.format("SELECT tab.FENTRYID,tab.FPLANSTARTTIME,tab.FPLANENDTIME,tab.FCOMPLETIONSTATUS,tab.FREALENDTIME,tab.FPLANTYPE,tab.FREALPLANCOMPLETETIME,tab.FPROJECTID FROM ( select a.FENTRYID,a.FPLANSTARTTIME,a.FPLANENDTIME,a.FCOMPLETIONSTATUS,a.FREALENDTIME,a.FPROJECTID,m.FPLANTYPE,max(r.FCOMPLETETIME) as FREALPLANCOMPLETETIME from T_%s_TASK a LEFT JOIN T_%s_MAJORTYPE m ON a.FBELONGPLANTYPEID=m.FID LEFT JOIN T_%s_TASKREPORT r ON a.FENTRYID=r.FTASKID AND r.FLATEST='1' WHERE (a.fresponsiblepersonid=?) and a.FISLATEST='1' and a.FSTATUS='C' and a.FRELATIONTASKID=0 AND a.FPLANENDTIME<? ", appId, appId, appId);
        StringBuilder sql = new StringBuilder(sqlStr);
        String weekQuery = this.getPageCache().get("week");
        boolean isNextWeek = false;
        if (weekQuery.equals(WorkhoursListConstant.WeekParam.NEXTWEEK.getValue())) {
            isNextWeek = true;
        }
        String groupBySql = " GROUP BY a.FENTRYID,a.FPLANSTARTTIME,a.FPLANENDTIME,a.FCOMPLETIONSTATUS,a.FPROJECTID,a.FREALENDTIME,m.FPLANTYPE ) tab WHERE (tab.FREALENDTIME  >= ?  OR (TAB.FREALENDTIME IS NULL AND  TAB.FREALPLANCOMPLETETIME IS null ) OR (TAB.FREALENDTIME IS NULL AND     TAB.FREALPLANCOMPLETETIME IS NOT null" + (isNextWeek ? "   AND (TAB.FREALPLANCOMPLETETIME >= ? OR TAB.FREALPLANCOMPLETETIME <= ? )" : " ") + " )) ";
        ArrayList<Comparable<Long>> paramsList = new ArrayList<Comparable<Long>>(10);
        paramsList.add(Long.valueOf(RequestContext.get().getUserId()));
        paramsList.add(begin);
        Object statuses = filterMap.get("completionstatus");
        if (statuses != null) {
            List statuses1 = (List)statuses;
            List collect = statuses1.stream().map(s -> "'" + s + "'").collect(Collectors.toList());
            sql.append(" AND a.FCOMPLETIONSTATUS in (").append(StringUtils.join(collect, (char)',')).append(')');
        }
        if ((majortypes = filterMap.get("majortype")) != null) {
            List temp = (List)majortypes;
            List typeIds = temp.stream().map(typeId -> "'" + typeId + "'").collect(Collectors.toList());
            sql.append(" AND m.FPLANTYPE in (").append(StringUtils.join(typeIds, (char)',')).append(')');
        }
        if ((planendtimebegin = (Date)filterMap.get(PLANENDTIMEBEGIN)) != null) {
            sql.append(" AND a.FPLANENDTIME >? ");
            paramsList.add(planendtimebegin);
        }
        if ((planendtimeend = (Date)filterMap.get(PLANENDTIMEEND)) != null) {
            sql.append(" AND a.FPLANENDTIME <? ");
            paramsList.add(planendtimeend);
        }
        sql.append(groupBySql);
        paramsList.add(begin);
        if (isNextWeek) {
            paramsList.add(begin);
            paramsList.add(DateUtil.parseShortDate((String)DateUtil.formatShortDate((Date)DateUtil.getCurrentDate())));
        }
        Object[] params = paramsList.toArray(new Object[paramsList.size()]);
        String dbRouteKey = MetaDataUtil.getDT((String)this.getAppId(), (String)"workhours").getDBRouteKey();
        List taskList = (List)DB.query((DBRoute)new DBRoute(dbRouteKey), (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<PlanTaskModel>>(){

            public List<PlanTaskModel> handle(ResultSet rs) throws Exception {
                ArrayList<PlanTaskModel> result = new ArrayList<PlanTaskModel>(10);
                while (rs.next()) {
                    PlanTaskModel temp = new PlanTaskModel();
                    temp.setId(rs.getLong("fentryid"));
                    temp.setPlanEndDate(rs.getDate("fplanendtime"));
                    temp.setPlanStartDate(rs.getDate("fplanstarttime"));
                    temp.setCompleteStatus(rs.getString("fcompletionstatus"));
                    temp.setPlanType(rs.getString("fplantype"));
                    temp.setProject(rs.getString("fprojectid"));
                    result.add(temp);
                }
                return result;
            }
        });
        return taskList;
    }

    protected List<PlanTaskModel> getUnionTasks(List<PlanTaskModel> firstTasks, List<PlanTaskModel> secondTasks, List<PlanTaskModel> thirdTaskList) {
        TreeSet<PlanTaskModel> set = new TreeSet<PlanTaskModel>((o1, o2) -> {
            if ((int)(o1.getPlanStartDate().getTime() - o2.getPlanStartDate().getTime()) == 0) {
                return o1.getId().compareTo(o2.getId());
            }
            return (int)(o1.getPlanStartDate().getTime() - o2.getPlanStartDate().getTime());
        });
        ArrayList<PlanTaskModel> tasks = new ArrayList<PlanTaskModel>(10);
        if (thirdTaskList != null && thirdTaskList.size() > 0) {
            set.addAll(thirdTaskList);
        }
        if (firstTasks != null && firstTasks.size() > 0) {
            set.addAll(firstTasks);
        }
        if (secondTasks != null && secondTasks.size() > 0) {
            set.addAll(secondTasks);
        }
        tasks.addAll(set);
        return tasks;
    }

    protected List<PlanTaskModel> getSortedTaskDynamicObject(DynamicObject[] dynamicObject) {
        List<Object> list = new ArrayList(10);
        ArrayList<PlanTaskModel> tasks = new ArrayList<PlanTaskModel>(10);
        if (dynamicObject != null && dynamicObject.length > 0) {
            list = Arrays.asList(dynamicObject);
        }
        list.forEach(d -> {
            PlanTaskModel temp = new PlanTaskModel();
            temp.setId(d.getLong("id"));
            temp.setPlanEndDate(d.getDate("planendtime"));
            temp.setPlanStartDate(d.getDate("planstarttime"));
            temp.setCompleteStatus(d.getString("completionstatus"));
            temp.setProject(d.getDynamicObject("project") == null ? "0" : d.getDynamicObject("project").getPkValue().toString());
            DynamicObject majortype = d.getDynamicObject("belongplantype");
            temp.setPlanType(majortype == null ? "" : majortype.getString("plantype"));
            tasks.add(temp);
        });
        return tasks;
    }

    protected List<PlanTaskModel> queryTaskWithReport(Map<String, Object> filterMap, String appId) {
        Date planendtimeend;
        Object majortypes;
        Date end = DateUtil.getEndDayTime((Date)DateUtil.parseShortDate((String)this.getPageCache().get("WEEKLASTDAY")));
        String sqlStr = String.format("select a.FENTRYID,a.FPLANSTARTTIME,a.FPLANENDTIME,a.FCOMPLETIONSTATUS,a.FPROJECTID,m.FPLANTYPE from T_%s_TASK a LEFT JOIN T_%s_MAJORTYPE m ON a.FBELONGPLANTYPEID=m.FID WHERE (a.fresponsiblepersonid=?) and a.FISLATEST='1' and a.FSTATUS='C' and a.FRELATIONTASKID=0 AND a.FPLANSTARTTIME > ? AND EXISTS(SELECT b.FID FROM T_%s_TASKREPORT b WHERE b.FTASKID=a.FENTRYID AND b.FCREATETIME <=?)", appId, appId, appId);
        StringBuilder sql = new StringBuilder(sqlStr);
        Object statuses = filterMap.get("completionstatus");
        if (statuses != null) {
            List statuses1 = (List)statuses;
            List collect = statuses1.stream().map(s -> "'" + s + "'").collect(Collectors.toList());
            sql.append(" AND a.FCOMPLETIONSTATUS in (").append(StringUtils.join(collect, (char)',')).append(')');
        }
        if ((majortypes = filterMap.get("majortype")) != null) {
            List temp = (List)majortypes;
            List typeIds = temp.stream().map(typeId -> "'" + typeId + "'").collect(Collectors.toList());
            sql.append(" AND m.FPLANTYPE in (").append(StringUtils.join(typeIds, (char)',')).append(')');
        }
        ArrayList<Comparable<Long>> paramsList = new ArrayList<Comparable<Long>>(10);
        paramsList.add(Long.valueOf(RequestContext.get().getUserId()));
        paramsList.add(end);
        paramsList.add(end);
        Date planendtimebegin = (Date)filterMap.get(PLANENDTIMEBEGIN);
        if (planendtimebegin != null) {
            sql.append(" AND a.FPLANENDTIME >=?");
            paramsList.add(planendtimebegin);
        }
        if ((planendtimeend = (Date)filterMap.get(PLANENDTIMEEND)) != null) {
            sql.append(" AND a.FPLANENDTIME <=?");
            paramsList.add(planendtimeend);
        }
        Object[] params = paramsList.toArray(new Object[paramsList.size()]);
        sql.append(" group by a.FENTRYID,a.FPLANSTARTTIME,a.FPLANENDTIME,a.FCOMPLETIONSTATUS,a.FPROJECTID,m.FPLANTYPE ");
        String dbRouteKey = MetaDataUtil.getDT((String)this.getAppId(), (String)"workhours").getDBRouteKey();
        List taskList = (List)DB.query((DBRoute)new DBRoute(dbRouteKey), (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<PlanTaskModel>>(){

            public List<PlanTaskModel> handle(ResultSet rs) throws Exception {
                ArrayList<PlanTaskModel> result = new ArrayList<PlanTaskModel>(10);
                while (rs.next()) {
                    PlanTaskModel temp = new PlanTaskModel();
                    temp.setId(rs.getLong("fentryid"));
                    temp.setPlanEndDate(rs.getDate("fplanendtime"));
                    temp.setPlanStartDate(rs.getDate("fplanstarttime"));
                    temp.setCompleteStatus(rs.getString("fcompletionstatus"));
                    temp.setPlanType(rs.getString("fplantype"));
                    temp.setProject(rs.getString("fprojectid"));
                    result.add(temp);
                }
                return result;
            }
        });
        return taskList;
    }

    protected void fillCellValueAndStyle(int row, DynamicObject[] taskHours) {
        String weekDaysCache = this.getWeekDaysCache();
        String[] split = weekDaysCache.split(",");
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        BigDecimal sum = new BigDecimal(0);
        BigDecimal effectiveSum = BigDecimal.ZERO;
        String today = DateUtil.formatShortDate((Date)DateUtil.getCurrentDate());
        for (int i = 1; i <= 7; ++i) {
            String columPrefix = ENTRYCOLUMNKEYPREFIX + i;
            String columKey = columPrefix + ENTRYCOLUMNKEY_ACTUAL_SUFFIX;
            BigDecimal hour = new BigDecimal(0);
            String effectiveKey = columPrefix + ENTRYCOLUMNKEY_EFFECTIVE_SUFFIX;
            BigDecimal effectiveHour = BigDecimal.ZERO;
            String day = split[i - 1];
            if (taskHours != null) {
                for (DynamicObject taskHour : taskHours) {
                    Date workDate = (Date)taskHour.get("workdate");
                    if (!day.equals(DateUtil.formatShortDate((Date)workDate))) continue;
                    hour = (BigDecimal)taskHour.get("actualhour");
                    effectiveHour = (BigDecimal)taskHour.get("effectivehour");
                    this.setCellStyle(grid, taskHour, row, columKey, effectiveKey);
                    break;
                }
            }
            this.getModel().setValue(columKey, (Object)hour, row);
            this.getModel().setValue(effectiveKey, (Object)effectiveHour, row);
            sum = sum.add(hour);
            effectiveSum = effectiveSum.add(effectiveHour);
            int compareTo = day.compareTo(today);
            if (compareTo == 0) {
                grid.setColumnProperty(columKey, "bc", (Object)"#ffffaa");
                grid.setColumnProperty(effectiveKey, "bc", (Object)"#ffffaa");
                continue;
            }
            grid.setColumnProperty(columKey, "bc", null);
            grid.setColumnProperty(effectiveKey, "bc", null);
        }
        this.getModel().setValue("daysum_actual", (Object)sum, row);
        this.getModel().setValue("daysum_effective", (Object)effectiveSum, row);
    }

    protected void setCellStyle(EntryGrid grid, DynamicObject taskHour, int row, String actualColumKey, String effectiveKey) {
        String status = taskHour.getString("status");
        if (StringUtils.equals((CharSequence)StatusEnum.UNCHECKED.getValue(), (CharSequence)status)) {
            this.getView().setEnable(Boolean.FALSE, row, new String[]{actualColumKey, effectiveKey});
            ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(10);
            CellStyle cellStyle = new CellStyle();
            cellStyle.setRow(row);
            cellStyle.setFieldKey(actualColumKey);
            cellStyle.setForeColor("#70B603");
            CellStyle effecteiveCellStyle = new CellStyle();
            effecteiveCellStyle.setRow(row);
            effecteiveCellStyle.setFieldKey(effectiveKey);
            effecteiveCellStyle.setForeColor("#70B603");
            cellStyles.add(cellStyle);
            cellStyles.add(effecteiveCellStyle);
            grid.setCellStyle(cellStyles);
        } else if (StringUtils.equals((CharSequence)StatusEnum.CHECKED.getValue(), (CharSequence)status)) {
            this.getView().setEnable(Boolean.FALSE, row, new String[]{actualColumKey, effectiveKey});
            ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(10);
            CellStyle cellStyle = new CellStyle();
            cellStyle.setRow(row);
            cellStyle.setFieldKey(actualColumKey);
            cellStyle.setForeColor("#00B2FF");
            CellStyle effecteiveCellStyle = new CellStyle();
            effecteiveCellStyle.setRow(row);
            effecteiveCellStyle.setFieldKey(effectiveKey);
            effecteiveCellStyle.setForeColor("#00B2FF");
            cellStyles.add(cellStyle);
            cellStyles.add(effecteiveCellStyle);
            grid.setCellStyle(cellStyles);
        }
    }

    protected String getWeekDaysCache() {
        String s = "";
        String week = this.getPageCache().get("week");
        if (week.equals(WorkhoursListConstant.WeekParam.THISWEEK.getValue())) {
            s = this.getPageCache().get("THIS_WEEK_DAYS");
        } else if (week.equals(WorkhoursListConstant.WeekParam.LASTWEEK.getValue())) {
            s = this.getPageCache().get("LAST_WEEK_DAYS");
        } else if (week.equals(WorkhoursListConstant.WeekParam.NEXTWEEK.getValue())) {
            s = this.getPageCache().get("NEXT_WEEK_DAYS");
        }
        return s;
    }

    protected void updateBtnSelectedStyle(String key, boolean isSelected) {
        HashMap<String, Object> propertiesMapSelected = new HashMap<String, Object>(16);
        propertiesMapSelected.put("fc", "#5e80eb");
        propertiesMapSelected.put("bc", "#F3F8FF");
        HashMap<String, String> selectedborder = new HashMap<String, String>(16);
        HashMap<String, HashMap<String, String>> selectedstyle = new HashMap<String, HashMap<String, String>>(16);
        selectedborder.put("b", "1px_solid_#5e80eb");
        selectedborder.put("l", "1px_solid_#5e80eb");
        selectedborder.put("r", "1px_solid_#5e80eb");
        selectedborder.put("t", "1px_solid_#5e80eb");
        selectedstyle.put("b", selectedborder);
        propertiesMapSelected.put("s", selectedstyle);
        HashMap<String, Object> propertiesMapUnSelected = new HashMap<String, Object>(16);
        HashMap<String, String> unselectedborder = new HashMap<String, String>(16);
        HashMap<String, HashMap<String, String>> unselectedstyle = new HashMap<String, HashMap<String, String>>(16);
        unselectedborder.put("b", "1px_solid_#F3F8FF");
        unselectedborder.put("l", "1px_solid_#F3F8FF");
        unselectedborder.put("r", "1px_solid_#F3F8FF");
        unselectedborder.put("t", "1px_solid_#F3F8FF");
        unselectedstyle.put("b", unselectedborder);
        propertiesMapUnSelected.put("fc", "#8d929f");
        propertiesMapUnSelected.put("bc", "#F3F8FF");
        propertiesMapUnSelected.put("s", unselectedstyle);
        this.getView().updateControlMetadata(key, isSelected ? propertiesMapSelected : propertiesMapUnSelected);
    }

    protected DynamicObject[] queryTaskHours(Long taskId) {
        ArrayList<QFilter> qlist = new ArrayList<QFilter>(10);
        qlist.add(new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId())));
        qlist.add(new QFilter("task", "=", (Object)taskId));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String week = this.getPageCache().get("week");
        Date begin = null;
        Date end = null;
        try {
            if (week.equals(WorkhoursListConstant.WeekParam.THISWEEK.getValue())) {
                String this_week_days = this.getPageCache().get("THIS_WEEK_DAYS");
                begin = simpleDateFormat.parse(this_week_days.split(",")[0]);
                end = simpleDateFormat.parse(this_week_days.split(",")[6]);
            } else if (week.equals(WorkhoursListConstant.WeekParam.LASTWEEK.getValue())) {
                String last_week_days = this.getPageCache().get("LAST_WEEK_DAYS");
                begin = simpleDateFormat.parse(last_week_days.split(",")[0]);
                end = simpleDateFormat.parse(last_week_days.split(",")[6]);
            } else if (week.equals(WorkhoursListConstant.WeekParam.NEXTWEEK.getValue())) {
                String next_week_days = this.getPageCache().get("NEXT_WEEK_DAYS");
                begin = simpleDateFormat.parse(next_week_days.split(",")[0]);
                end = simpleDateFormat.parse(next_week_days.split(",")[6]);
            }
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
        }
        if (end != null) {
            qlist.add(new QFilter("workdate", ">=", begin));
        }
        if (end != null) {
            qlist.add(new QFilter("workdate", "<=", end));
        }
        return BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"workhours"), (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,task,workdate,actualhour,effectivehour", (QFilter[])qlist.toArray(new QFilter[qlist.size()]), (String)"workdate asc,modifytime desc");
    }

    protected List<QFilter> getQueryFilter(Map<String, Object> filterMap) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        this.setStatusFilter(filterList, filterMap);
        this.setPlanFinishDateFilter(filterList, filterMap);
        this.setFromTypeFilter(filterList, filterMap);
        this.setTaskPlanBeginAndPlanEndFilter(filterList);
        this.setUserIdFilter(filterList);
        filterList.add(new QFilter("islatest", "=", (Object)"1"));
        filterList.add(new QFilter("relationtask", "=", (Object)0));
        filterList.add(new QFilter("status", "=", (Object)"C"));
        return filterList;
    }

    protected void setUserIdFilter(List<QFilter> filterList) {
        String userId = RequestContext.get().getUserId();
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            filterList.add(new QFilter("responsibleperson", "=", (Object)Long.valueOf(userId)).or(new QFilter("multicooperationperson.fbasedataid.id", "=", (Object)Long.valueOf(userId))));
        }
    }

    protected void setTaskPlanBeginAndPlanEndFilter(List<QFilter> filterList) {
        Date now = DateUtil.getCurrentDate();
        Date monday = null;
        Date sunday = null;
        String week = this.getPageCache().get("week");
        if (WorkhoursListConstant.WeekParam.THISWEEK.getValue().equals(week)) {
            monday = DateUtil.getThisWeekMonday((Date)now);
            sunday = DateUtil.getThisWeekSunDay((Date)now);
        } else if (WorkhoursListConstant.WeekParam.LASTWEEK.getValue().equals(week)) {
            monday = DateUtil.getLastWeekMonday((Date)now);
            sunday = DateUtil.getLastWeekSunday((Date)now);
        } else if (WorkhoursListConstant.WeekParam.NEXTWEEK.getValue().equals(week)) {
            monday = DateUtil.getNextWeekMonday((Date)now);
            sunday = DateUtil.getNextWeekSunday((Date)now);
        }
        int addDayNum = this.calAddDayNum(now);
        this.getPageCache().put("WEEKFIRSTDAY", DateUtil.formatShortDate((Date)DateUtils.addDays((Date)monday, (int)addDayNum)));
        this.getPageCache().put("WEEKLASTDAY", DateUtil.formatShortDate((Date)DateUtils.addDays((Date)sunday, (int)addDayNum)));
        filterList.add(new QFilter("planstarttime", "<=", (Object)DateUtils.addDays((Date)sunday, (int)addDayNum)));
        filterList.add(new QFilter("planendtime", ">=", (Object)DateUtils.addDays((Date)monday, (int)addDayNum)));
    }

    protected int calAddDayNum(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int i = -1;
        if (cal.get(7) == 1) {
            i = 6;
        }
        return i;
    }

    protected void setFromTypeFilter(List<QFilter> filterList, Map<String, Object> filterMap) {
        boolean value = this.isBtnSelectdValue("btn_fromtype_0");
        ArrayList<String> fromTypeList = new ArrayList<String>(10);
        if (!value) {
            boolean value5;
            boolean value4;
            boolean value3;
            boolean value2;
            boolean value1 = this.isBtnSelectdValue("btn_fromtype_1");
            if (value1) {
                fromTypeList.add(PlanTypeEnum.MAINPLAN.getValue());
            }
            if (value2 = this.isBtnSelectdValue("btn_fromtype_2")) {
                fromTypeList.add(PlanTypeEnum.MAJORPLAN.getValue());
            }
            if (value3 = this.isBtnSelectdValue("btn_fromtype_3")) {
                fromTypeList.add(PlanTypeEnum.DEPTPLAN.getValue());
            }
            if (value4 = this.isBtnSelectdValue("btn_fromtype_4")) {
                fromTypeList.add(PlanTypeEnum.PRIVATEPLAN.getValue());
            }
            if (value5 = this.isBtnSelectdValue("btn_fromtype_5")) {
                fromTypeList.add(PlanTypeEnum.DEPTFENJIEPLAN.getValue());
            }
        }
        if (fromTypeList.size() > 0) {
            filterList.add(new QFilter("belongplantype.plantype", "in", fromTypeList));
            filterMap.put("majortype", fromTypeList);
        }
    }

    protected void setPlanFinishDateFilter(List<QFilter> filterList, Map<String, Object> filterMap) {
        Date now = DateUtil.getCurrentDate();
        boolean value = this.isBtnSelectdValue("btn_planfinishdate_0");
        Date beginDate = null;
        Date endDate = null;
        if (!value) {
            beginDate = (Date)this.getModel().getValue("daterangefield_startdate");
            endDate = (Date)this.getModel().getValue("daterangefield_enddate");
            if (beginDate == null && endDate == null) {
                boolean value4;
                boolean value3;
                boolean value2;
                boolean value1 = this.isBtnSelectdValue("btn_planfinishdate_1");
                if (value1) {
                    beginDate = DateUtils.addDays((Date)DateUtil.getThisWeekMonday((Date)now), (int)-1);
                    endDate = DateUtils.addDays((Date)DateUtil.getThisWeekSunDay((Date)now), (int)-1);
                }
                if (value2 = this.isBtnSelectdValue("btn_planfinishdate_2")) {
                    beginDate = DateUtils.addDays((Date)DateUtil.getNextWeekMonday((Date)now), (int)-1);
                    endDate = DateUtils.addDays((Date)DateUtil.getNextWeekSunday((Date)now), (int)-1);
                }
                if (value3 = this.isBtnSelectdValue("btn_planfinishdate_3")) {
                    beginDate = DateUtil.getFirstDayOfThisMonth((Date)now);
                    endDate = DateUtil.getLastDayOfThisMonth((Date)now);
                }
                if (value4 = this.isBtnSelectdValue("btn_planfinishdate_4")) {
                    beginDate = DateUtil.getFirstDayOfNextMonth((Date)now);
                    endDate = DateUtil.getLastDayOfNextMonth((Date)now);
                }
            }
            if (beginDate != null) {
                filterList.add(new QFilter("planendtime", ">=", (Object)beginDate));
                filterMap.put(PLANENDTIMEBEGIN, beginDate);
            }
            if (endDate != null) {
                filterList.add(new QFilter("planendtime", "<=", (Object)DateUtil.getEndDayTime((Date)endDate)));
                filterMap.put(PLANENDTIMEEND, endDate);
            }
        }
    }

    protected void setStatusFilter(List<QFilter> filterList, Map<String, Object> filterMap) {
        boolean value = this.isBtnSelectdValue("btn_status_0");
        ArrayList<String> statuslist = new ArrayList<String>(10);
        if (!value) {
            boolean value6;
            boolean value5;
            boolean value4;
            boolean value3;
            boolean value2;
            boolean value1 = this.isBtnSelectdValue("btn_status_1");
            if (value1) {
                statuslist.add(CompletionStatusEnum.UNSTART.getValue());
            }
            if (value2 = this.isBtnSelectdValue("btn_status_2")) {
                statuslist.add(CompletionStatusEnum.PROGRESSING.getValue());
            }
            if (value3 = this.isBtnSelectdValue("btn_status_3")) {
                statuslist.add(CompletionStatusEnum.OVERDUE.getValue());
            }
            if (value4 = this.isBtnSelectdValue("btn_status_4")) {
                statuslist.add(CompletionStatusEnum.ONTIMECOMPLETE.getValue());
            }
            if (value5 = this.isBtnSelectdValue("btn_status_5")) {
                statuslist.add(CompletionStatusEnum.OVERDUECOMPLETE.getValue());
            }
            if (value6 = this.isBtnSelectdValue("btn_status_6")) {
                statuslist.add(CompletionStatusEnum.ESTIMATEDELAY.getValue());
            }
        }
        if (statuslist.size() > 0) {
            filterList.add(new QFilter("completionstatus", "in", statuslist));
            filterMap.put("completionstatus", statuslist);
        }
    }

    protected boolean isBtnSelectdValue(String key) {
        String s = this.getPageCache().get(key);
        boolean f = "true".equals(s);
        return f;
    }

    protected void handleNextWeekClickEvent() {
        this.setPageCache("week", WorkhoursListConstant.WeekParam.NEXTWEEK.getValue());
        this.updateWeekButtonStyle(WorkhoursListConstant.WeekParam.NEXTWEEK);
    }

    protected void handleThisWeekClickEvent() {
        this.setPageCache("week", WorkhoursListConstant.WeekParam.THISWEEK.getValue());
        this.updateWeekButtonStyle(WorkhoursListConstant.WeekParam.THISWEEK);
    }

    protected void handleLastWeekClickEvent() {
        this.setPageCache("week", WorkhoursListConstant.WeekParam.LASTWEEK.getValue());
        this.updateWeekButtonStyle(WorkhoursListConstant.WeekParam.LASTWEEK);
    }

    protected void setWeekDaysCache() {
        Date now = DateUtil.getCurrentDate();
        Date thisWeekMonday = DateUtil.getThisWeekMonday((Date)now);
        Date thisWeekSunDay = DateUtil.getThisWeekSunDay((Date)now);
        Date lastWeekMonday = DateUtil.getLastWeekMonday((Date)now);
        Date lastWeekSunday = DateUtil.getLastWeekSunday((Date)now);
        Date nextWeekMonday = DateUtil.getNextWeekMonday((Date)now);
        Date nextWeekSunday = DateUtil.getNextWeekSunday((Date)now);
        int i = this.calAddDayNum(now);
        Map days = WorkHoursUtils.getDays((Date)DateUtils.addDays((Date)thisWeekMonday, (int)i), (Date)DateUtils.addDays((Date)thisWeekSunDay, (int)i));
        this.setPageCache("THIS_WEEK_DAYS", StringUtils.join((Iterable)((Iterable)days.get("days")), (String)","));
        this.setPageCache("THIS_WEEK_DAYS_SHORT", StringUtils.join((Iterable)((Iterable)days.get("shortdays")), (String)","));
        Map days1 = WorkHoursUtils.getDays((Date)DateUtils.addDays((Date)lastWeekMonday, (int)i), (Date)DateUtils.addDays((Date)lastWeekSunday, (int)i));
        this.setPageCache("LAST_WEEK_DAYS", StringUtils.join((Iterable)((Iterable)days1.get("days")), (String)","));
        this.setPageCache("LAST_WEEK_DAYS_SHORT", StringUtils.join((Iterable)((Iterable)days1.get("shortdays")), (String)","));
        Map days2 = WorkHoursUtils.getDays((Date)DateUtils.addDays((Date)nextWeekMonday, (int)i), (Date)DateUtils.addDays((Date)nextWeekSunday, (int)i));
        this.setPageCache("NEXT_WEEK_DAYS", StringUtils.join((Iterable)((Iterable)days2.get("days")), (String)","));
        this.setPageCache("NEXT_WEEK_DAYS_SHORT", StringUtils.join((Iterable)((Iterable)days2.get("shortdays")), (String)","));
    }

    protected void updateWeekButtonStyle(WorkhoursListConstant.WeekParam selectedBtnValue) {
        HashMap<String, String> propertiesMapSelected = new HashMap<String, String>(16);
        propertiesMapSelected.put("bc", "#56aaff");
        propertiesMapSelected.put("fc", "#ffffff");
        HashMap<String, String> propertiesMapUnSelected = new HashMap<String, String>(16);
        propertiesMapUnSelected.put("bc", "#e5e5e5");
        propertiesMapUnSelected.put("fc", "#000000");
        switch (selectedBtnValue) {
            case LASTWEEK: {
                this.getView().updateControlMetadata(BUTTONLASTWEEK, propertiesMapSelected);
                this.getView().updateControlMetadata(BUTTONTHISWEEK, propertiesMapUnSelected);
                this.getView().updateControlMetadata(BUTTONNEXTWEEK, propertiesMapUnSelected);
                break;
            }
            case THISWEEK: {
                this.getView().updateControlMetadata(BUTTONTHISWEEK, propertiesMapSelected);
                this.getView().updateControlMetadata(BUTTONLASTWEEK, propertiesMapUnSelected);
                this.getView().updateControlMetadata(BUTTONNEXTWEEK, propertiesMapUnSelected);
                break;
            }
            case NEXTWEEK: {
                this.getView().updateControlMetadata(BUTTONNEXTWEEK, propertiesMapSelected);
                this.getView().updateControlMetadata(BUTTONTHISWEEK, propertiesMapUnSelected);
                this.getView().updateControlMetadata(BUTTONLASTWEEK, propertiesMapUnSelected);
                break;
            }
        }
    }

    protected void setPageCache(String key, String value) {
        this.getPageCache().put(key, value);
    }

    protected void clearOtherPlanfinishdateFilter(String name) {
        PLAN_FINISHDATE_LIST.forEach(d -> {
            if (!d.equals(name)) {
                this.getPageCache().put(d, "false");
                this.updateBtnSelectedStyle((String)d, false);
            }
        });
    }

    protected void handleFromTypeChangeEvent(String name, boolean propValue) {
        this.updateBtnSelectedStyle(name, propValue);
        if ("btn_fromtype_0".equals(name)) {
            if (propValue) {
                this.clearFromTypeFilter();
            }
        } else if (propValue) {
            this.resetFromTypeFilterSwitch(false);
        }
        if (!propValue && this.needResetFromTypeFilterSwitch()) {
            this.resetFromTypeFilterSwitch(true);
        }
    }

    protected void handlePlanfinishdateChangeEvent(String name, boolean propValue) {
        this.updateBtnSelectedStyle(name, propValue);
        if (propValue) {
            this.clearOtherPlanfinishdateFilter(name);
            this.getModel().beginInit();
            this.getModel().setValue("daterangefield_startdate", null);
            this.getModel().setValue("daterangefield_enddate", null);
            this.getModel().endInit();
            this.getView().updateView();
        }
        if (!propValue && this.needResetPlanfinishdateFilterSwitch()) {
            this.getPageCache().put("btn_planfinishdate_0", "true");
            this.updateBtnSelectedStyle("btn_planfinishdate_0", true);
        }
    }

    protected void updatePlanEndRangeFilter() {
        Optional<String> first;
        Object start = this.getModel().getValue("daterangefield_startdate");
        Object end = this.getModel().getValue("daterangefield_enddate");
        if (start != null || end != null) {
            PLAN_FINISHDATE_LIST.forEach(d -> {
                this.setPageCache((String)d, "false");
                this.updateBtnSelectedStyle((String)d, false);
            });
        }
        if (!(start != null && end != null || (first = PLAN_FINISHDATE_LIST.stream().filter(d -> "true".equals(this.getPageCache().get(d))).findFirst()).isPresent())) {
            this.setPageCache("btn_planfinishdate_0", "true");
            this.updateBtnSelectedStyle("btn_planfinishdate_0", true);
        }
    }

    protected void handleStatusChangeEvent(String name, boolean propValue) {
        this.updateBtnSelectedStyle(name, propValue);
        if ("btn_status_0".equals(name)) {
            if (propValue) {
                this.clearStatusFilter();
            }
        } else if (propValue) {
            this.resetStatusFilterSwitch(false);
        }
        if (!propValue && this.needResetStatusFilterSwitch()) {
            this.resetStatusFilterSwitch(true);
        }
    }

    protected boolean needResetFromTypeFilterSwitch() {
        boolean f = true;
        for (int i = 1; i <= 5; ++i) {
            String value = this.getPageCache().get(BUTTONFROMTYPEPREFIX + i);
            if (!"true".equals(value)) continue;
            f = false;
        }
        return f;
    }

    protected boolean needResetPlanfinishdateFilterSwitch() {
        boolean f = true;
        for (int i = 1; i <= 4; ++i) {
            String value = this.getPageCache().get(BUTTONPLANFINISHDATEPREFIX + i);
            if (!"true".equals(value)) continue;
            f = false;
        }
        return f;
    }

    protected boolean needResetStatusFilterSwitch() {
        boolean f = true;
        for (int i = 1; i <= 6; ++i) {
            String value = this.getPageCache().get(BUTTONSTATUSPREFIX + i);
            if (!"true".equals(value)) continue;
            f = false;
        }
        return f;
    }

    protected void resetFromTypeFilterSwitch(boolean isOpen) {
        this.getPageCache().put("btn_fromtype_0", isOpen ? "true" : "false");
        this.updateBtnSelectedStyle("btn_fromtype_0", isOpen);
    }

    protected void resetStatusFilterSwitch(boolean isOpen) {
        this.getPageCache().put("btn_status_0", isOpen ? "true" : "false");
        this.updateBtnSelectedStyle("btn_status_0", isOpen);
    }

    protected void clearFromTypeFilter() {
        this.getPageCache().put("btn_fromtype_1", "false");
        this.getPageCache().put("btn_fromtype_2", "false");
        this.getPageCache().put("btn_fromtype_3", "false");
        this.getPageCache().put("btn_fromtype_4", "false");
        this.getPageCache().put("btn_fromtype_5", "false");
        this.updateBtnSelectedStyle("btn_fromtype_1", false);
        this.updateBtnSelectedStyle("btn_fromtype_2", false);
        this.updateBtnSelectedStyle("btn_fromtype_3", false);
        this.updateBtnSelectedStyle("btn_fromtype_4", false);
        this.updateBtnSelectedStyle("btn_fromtype_5", false);
    }

    protected void clearStatusFilter() {
        this.getPageCache().put("btn_status_1", "false");
        this.getPageCache().put("btn_status_2", "false");
        this.getPageCache().put("btn_status_3", "false");
        this.getPageCache().put("btn_status_4", "false");
        this.getPageCache().put("btn_status_5", "false");
        this.getPageCache().put("btn_status_6", "false");
        this.updateBtnSelectedStyle("btn_status_1", false);
        this.updateBtnSelectedStyle("btn_status_2", false);
        this.updateBtnSelectedStyle("btn_status_3", false);
        this.updateBtnSelectedStyle("btn_status_4", false);
        this.updateBtnSelectedStyle("btn_status_5", false);
        this.updateBtnSelectedStyle("btn_status_6", false);
    }
}

