/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin.base;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.pccs.placs.formplugin.base.AbstractPlacsBillPlugin;

public class TreeSelectCtrlPlugin
extends AbstractPlacsBillPlugin
implements CellClickListener,
RowClickEventListener {
    private static final String selectrows = "selectrows_tplplugin";
    private static final String fixedSeletedRowMapKey = "fixedseletedrowmap";

    public void afterBindData(EventObject e) {
        String[] treeEntryKeyArray;
        super.afterBindData(e);
        for (String treekey : treeEntryKeyArray = this.getTreeEntryKeyArray()) {
            String cacheKey = this.getCacheKey(treekey);
            Set<Integer> selectRows = this.getSelectRows(treekey);
            this.getPageCache().put(cacheKey, JSON.toJSONString(selectRows));
        }
    }

    public void registerListener(EventObject e) {
        String[] treeEntryKeyArray;
        super.registerListener(e);
        for (String key : treeEntryKeyArray = this.getTreeEntryKeyArray()) {
            TreeEntryGrid treeEntryGrid;
            if (key == null || (treeEntryGrid = (TreeEntryGrid)this.getControl(key)) == null) continue;
            treeEntryGrid.addCellClickListener((CellClickListener)this);
            treeEntryGrid.addRowClickListener((RowClickEventListener)this);
        }
    }

    public String[] getTreeEntryKeyArray() {
        return new String[]{"treeentryentity"};
    }

    private boolean isFixedSelectRow(String treeKey, int row) {
        long count;
        Map<String, int[]> treeFixedSeletedRowMap = this.getTreeFixedSeletedRowMap();
        int[] ints = treeFixedSeletedRowMap.get(treeKey);
        return ints != null && (count = Arrays.stream(ints).filter(i -> i == row).count()) > 0L;
    }

    public Map<String, int[]> getTreeFixedSeletedRowMap() {
        Map<String, Object> map = new HashMap<String, int[]>();
        String fixedSelectedRowMapCahceStr = this.getPageCache().get(fixedSeletedRowMapKey);
        if (fixedSelectedRowMapCahceStr != null) {
            map = (Map)JSON.parseObject((String)fixedSelectedRowMapCahceStr, (TypeReference)new TypeReference<HashMap<String, int[]>>(){}, (Feature[])new Feature[0]);
        }
        return map;
    }

    public void setTreeFixedSeletedRowMap(Map<String, int[]> map) {
        if (map != null) {
            String mapCache = JSON.toJSONString(map);
            this.getPageCache().put(fixedSeletedRowMapKey, mapCache);
        }
    }

    private String getCacheKey(String treekey) {
        return "selectrows_tplplugin_" + treekey;
    }

    public void entryRowClick(RowClickEvent evt) {
        if (!(evt.getSource() instanceof TreeEntryGrid) || evt.getRow() == -1) {
            return;
        }
        this.processAutoSelect((EventObject)evt, null);
    }

    private void unSelectAll(TreeEntryGrid treeEntryGrid, String cacheKey, Set<Integer> selectRows, Set<Integer> fixedSelectedRow) {
        selectRows.addAll(fixedSelectedRow);
        this.getPageCache().put(cacheKey, JSON.toJSONString(selectRows));
        int[] ints1 = selectRows.stream().mapToInt(o -> o).toArray();
        treeEntryGrid.selectRows(ints1, ints1[0]);
    }

    public void cellClick(CellClickEvent evt) {
        if (!(evt.getSource() instanceof TreeEntryGrid) || evt.getRow() == -1) {
            return;
        }
        String fieldKey = evt.getFieldKey();
        this.processAutoSelect((EventObject)evt, fieldKey);
    }

    private synchronized void processAutoSelect(EventObject evt, String fieldKey) {
        Boolean includetree;
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)evt.getSource();
        Control control = this.getControl("includetreeclick");
        if (control != null && !(includetree = (Boolean)this.getModel().getValue("includetreeclick")).booleanValue()) {
            return;
        }
        String treekey = treeEntryGrid.getKey();
        String cacheKey = this.getCacheKey(treekey);
        Set<Integer> selectRows = this.getSelectRows(treekey);
        if (!"0".equals(fieldKey)) {
            String selectRowsStr = this.getPageCache().get(cacheKey);
            Set selectCache = new HashSet<Integer>();
            if (selectRowsStr != null) {
                selectCache = (Set)JSON.parseObject((String)selectRowsStr, (TypeReference)new TypeReference<HashSet<Integer>>(){}, (Feature[])new Feature[0]);
            }
            selectCache.addAll(selectRows);
            if (selectCache.size() > 0) {
                treeEntryGrid.selectRows(selectCache.stream().mapToInt(o -> o).toArray(), ((Integer)selectCache.stream().findAny().get()).intValue());
            }
        }
        if (selectRows.size() == 0) {
            Map<String, int[]> treeFixedSeletedRowMap = this.getTreeFixedSeletedRowMap();
            int[] ints = treeFixedSeletedRowMap.get(treekey);
            if (ints != null && ints.length > 0) {
                Set<Integer> fixedSelectedRow = Arrays.stream(ints).boxed().collect(Collectors.toSet());
                this.unSelectAll(treeEntryGrid, this.getCacheKey(treekey), selectRows, fixedSelectedRow);
            }
        } else {
            this.autoSelect(treekey, cacheKey);
        }
    }

    public void cellDoubleClick(CellClickEvent evt) {
        if (!(evt.getSource() instanceof TreeEntryGrid)) {
            return;
        }
        String fieldKey = evt.getFieldKey();
        this.processAutoSelect((EventObject)evt, fieldKey);
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        if (!(evt.getSource() instanceof TreeEntryGrid)) {
            return;
        }
        this.processAutoSelect((EventObject)evt, null);
    }

    private void autoSelect(String treekey, String cacheKey) {
        Optional clickRowOption;
        String selectRowsStr = this.getPageCache().get(cacheKey);
        Set selectCache = new HashSet();
        if (selectRowsStr != null) {
            selectCache = (Set)JSON.parseObject((String)selectRowsStr, (TypeReference)new TypeReference<HashSet<Integer>>(){}, (Feature[])new Feature[0]);
        }
        Set<Integer> selectRows = this.getSelectRows(treekey);
        Set<Integer> newSelectRows = this.getSelectRows(treekey);
        int clickRow = -1;
        boolean isSelect = false;
        if (selectRows.size() > selectCache.size()) {
            isSelect = true;
            selectRows.removeAll(selectCache);
            clickRowOption = selectRows.stream().findFirst();
        } else {
            isSelect = false;
            selectCache.removeAll(selectRows);
            clickRowOption = selectCache.stream().findFirst();
        }
        if (!clickRowOption.isPresent()) {
            return;
        }
        clickRow = (Integer)clickRowOption.get();
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(treekey, clickRow);
        DynamicObjectCollection entries = this.getModel().getEntryEntity(treekey);
        if (isSelect) {
            Set<Integer> parents = this.getParents(entries, rowEntity, new HashSet<Integer>());
            Set<Integer> children = this.getChildren(entries, rowEntity, new HashSet<Integer>());
            newSelectRows.addAll(parents);
            newSelectRows.addAll(children);
        } else if (!this.isFixedSelectRow(treekey, clickRow)) {
            this.removeNoChildrenParents(entries, rowEntity, clickRow, newSelectRows);
            Set<Integer> children = this.getChildren(entries, rowEntity, new HashSet<Integer>());
            newSelectRows.removeAll(children);
        } else {
            newSelectRows.add(clickRow);
        }
        int[] ints = newSelectRows.stream().mapToInt(o -> o).toArray();
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(treekey);
        treeEntryGrid.selectRows(ints, clickRow);
        this.getPageCache().put(cacheKey, JSON.toJSONString(newSelectRows));
    }

    private Set<Integer> getSelectRows(String treeKey) {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(treeKey);
        HashSet<Integer> selectRows = new HashSet<Integer>();
        int[] selectedRows = treeEntryGrid.getEntryState().getSelectedRows();
        if (selectedRows != null && selectedRows.length > 0) {
            selectRows.addAll(Arrays.stream(selectedRows).boxed().collect(Collectors.toSet()));
        }
        return selectRows;
    }

    private void removeNoChildrenParents(DynamicObjectCollection entries, DynamicObject rowEntity, int curRow, Set<Integer> selectRows) {
        if (rowEntity == null) {
            return;
        }
        Long pid = (Long)rowEntity.get("pid");
        selectRows.remove(curRow);
        if (pid == null || pid.equals(0L)) {
            return;
        }
        boolean hasChildren = false;
        int row = -1;
        DynamicObject noChildrenParent = null;
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject entity = (DynamicObject)entries.get(i);
            Long pid1 = (Long)entity.get("pid");
            Long id = (Long)entity.get("id");
            if (row == -1 && pid.equals(id)) {
                noChildrenParent = entity;
                row = i;
            }
            if (!pid.equals(pid1) || !selectRows.contains(i)) continue;
            hasChildren = true;
        }
        if (hasChildren) {
            return;
        }
        this.removeNoChildrenParents(entries, noChildrenParent, row, selectRows);
    }

    private Set<Integer> getParents(DynamicObjectCollection entries, DynamicObject curRow, Set<Integer> resultRows) {
        Long pid = (Long)curRow.get("pid");
        if (pid == null || pid.equals(0L)) {
            return resultRows;
        }
        Object[] rowparent = this.findRowEntiy(entries, pid);
        if (rowparent == null) {
            return resultRows;
        }
        Integer prow = (Integer)rowparent[0];
        DynamicObject parent = (DynamicObject)rowparent[1];
        if (rowparent[1] != null) {
            resultRows.add(prow);
            return this.getParents(entries, parent, resultRows);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u6811\u7ed3\u6784\u5f02\u5e38\u3002", (String)"TreeSelectCtrlPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
    }

    private Object[] findRowEntiy(DynamicObjectCollection entries, Long id) {
        Object[] rowObject = null;
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject rowEntity = (DynamicObject)entries.get(i);
            if (!id.equals(rowEntity.getLong("id"))) continue;
            rowObject = new Object[]{i, rowEntity};
            break;
        }
        return rowObject;
    }

    private List<Object[]> findChildren(DynamicObjectCollection entries, Long id) {
        ArrayList<Object[]> rowObjects = new ArrayList<Object[]>();
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject rowEntity = (DynamicObject)entries.get(i);
            if (!id.equals(rowEntity.getLong("pid"))) continue;
            Object[] rowObject = new Object[]{i, rowEntity};
            rowObjects.add(rowObject);
        }
        return rowObjects;
    }

    private Set<Integer> getChildren(DynamicObjectCollection entries, DynamicObject curRow, Set<Integer> resultRows) {
        if (curRow == null) {
            return resultRows;
        }
        Long id = (Long)curRow.get("id");
        List<Object[]> children = this.findChildren(entries, id);
        if (children.size() > 0) {
            for (Object[] child : children) {
                resultRows.add((Integer)child[0]);
                this.getChildren(entries, (DynamicObject)child[1], resultRows);
            }
            return resultRows;
        }
        return resultRows;
    }
}

