/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin.helper;

import java.util.LinkedList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.control.TreeEntryGrid;

public class TreeEntryGridHelper {
    private static int DEFAULT_MAX_LEVEL = 6;
    private static int DEFAULT_MIN_LEVEL = 1;

    public static void expandNodes(TreeEntryGrid grid, String levelColKey, int level) {
        if (DEFAULT_MIN_LEVEL == level || DEFAULT_MAX_LEVEL == level) {
            grid.setCollapse(1 == level);
            return;
        }
        LinkedList<Integer> collapseRows = new LinkedList<Integer>();
        LinkedList<Integer> expandRows = new LinkedList<Integer>();
        DynamicObject[] dataEntitys = grid.getEntryData().getDataEntitys();
        for (int i = 0; i < dataEntitys.length; ++i) {
            int ri = 0;
            Object levelColObj = dataEntitys[i].get(levelColKey);
            if (levelColObj instanceof Integer) {
                ri = (Integer)levelColObj;
            } else if (levelColObj instanceof DynamicObject) {
                ri = ((DynamicObject)levelColObj).getInt("level");
            }
            if (ri < level) {
                expandRows.add(i);
                continue;
            }
            if (level != ri) continue;
            collapseRows.add(i);
        }
        int[] ris = new int[expandRows.size()];
        int index = 0;
        for (Integer row : expandRows) {
            ris[index++] = row;
        }
        grid.expand(ris);
        if (collapseRows.size() > 0) {
            ris = new int[collapseRows.size()];
            index = 0;
            for (Integer row : collapseRows) {
                ris[index++] = row;
            }
            grid.collapse(ris);
        }
    }

    public static void expandNodes(TreeEntryGrid grid, String levelColKey, int level, Map<String, Integer> taskLevelMap) {
        if (DEFAULT_MIN_LEVEL == level || DEFAULT_MAX_LEVEL == level) {
            grid.setCollapse(1 == level);
            return;
        }
        LinkedList<Integer> collapseRows = new LinkedList<Integer>();
        LinkedList<Integer> expandRows = new LinkedList<Integer>();
        DynamicObject[] dataEntitys = grid.getEntryData().getDataEntitys();
        for (int i = 0; i < dataEntitys.length; ++i) {
            int ri = 0;
            Object levelColObj = dataEntitys[i].get(levelColKey);
            if (levelColObj instanceof Long) {
                String key = String.valueOf(levelColObj);
                ri = taskLevelMap.get(key) == null ? 0 : taskLevelMap.get(key);
            } else if (levelColObj instanceof DynamicObject) {
                DynamicObject task = (DynamicObject)levelColObj;
                String taskId = String.valueOf(task.getPkValue());
                int n = ri = taskLevelMap.get(taskId) == null ? 0 : taskLevelMap.get(taskId);
            }
            if (ri < level) {
                expandRows.add(i);
                continue;
            }
            if (level != ri) continue;
            collapseRows.add(i);
        }
        int[] ris = new int[expandRows.size()];
        int index = 0;
        for (Integer row : expandRows) {
            ris[index++] = row;
        }
        grid.expand(ris);
        if (collapseRows.size() > 0) {
            ris = new int[collapseRows.size()];
            index = 0;
            for (Integer row : collapseRows) {
                ris[index++] = row;
            }
            grid.collapse(ris);
        }
    }
}

