/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin.mobile;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;
import kd.pccs.placs.business.base.AbstractPlacsMobFormAdapter;
import kd.pccs.placs.business.utils.task.TaskUtil;

public class AssignTaskMobFormPlugin
extends AbstractPlacsMobFormAdapter
implements ClickListener {
    private static final String RP_BaseData = "responsibleperson";
    private static final String MCP_BaseData = "multicooperationperson";
    private static final Log LOG = LogFactory.getLog(AssignTaskMobFormPlugin.class);
    private static final String formBillId = "task";
    private static final String assignTaskBillId = "assigntask";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button backBtn = (Button)this.getView().getControl("back_btn");
        backBtn.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long taskIdValue = (Long)formShowParameter.getCustomParam("taskId");
        if (taskIdValue != null) {
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskIdValue, (String)this.getEntityMetaDataTag(formBillId));
            this.initData(task);
        }
        BigDecimal version = (BigDecimal)this.getModel().getValue("version");
        BigDecimal newVersion = version.add(BigDecimal.ONE);
        this.getModel().setValue("version", (Object)newVersion);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        this.deptChanged(fieldKey);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "back_btn": {
                this.getView().close();
                break;
            }
        }
    }

    protected void initData(DynamicObject task) {
        DynamicObjectCollection cpDepts;
        DynamicObject rpDept;
        String status = task.getString("status");
        if ("A".equals(status)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"submit_task"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"attachmentpanelap"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"submit_task"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"attachmentpanelap"});
            this.getView().setStatus(OperationStatus.VIEW);
        }
        this.getModel().setValue("id", (Object)task.getLong("id"));
        this.getModel().setValue("taskname", (Object)task.getString("name"));
        this.getModel().setValue("start_time", (Object)task.getDate("planstarttime"));
        this.getModel().setValue("end_time", (Object)task.getDate("planendtime"));
        this.getModel().setValue(RP_BaseData, (Object)task.getDynamicObject(RP_BaseData));
        DynamicObjectCollection multicooperationperson = task.getDynamicObjectCollection(MCP_BaseData);
        if (multicooperationperson != null && multicooperationperson.size() > 0) {
            DynamicObjectCollection collection = new DynamicObjectCollection();
            for (DynamicObject mcp : multicooperationperson) {
                DynamicObject dynamicObject = mcp.getDynamicObject("fbasedataid");
                collection.add((Object)dynamicObject);
            }
            this.getModel().setValue(MCP_BaseData, (Object)collection);
        }
        if ((rpDept = task.getDynamicObject("responsibledept")) != null) {
            this.getModel().setValue("rp_dept_bd", (Object)rpDept);
        }
        if ((cpDepts = task.getDynamicObjectCollection("multicooperationdept")) != null && cpDepts.size() > 0) {
            this.getModel().setValue("cp_dept_bd", (Object)cpDepts);
        }
        this.getModel().setValue("content", (Object)task.getString("contentrequirements"));
        this.syncToFileService(task);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (StringUtils.isEmpty((CharSequence)String.valueOf(this.getModel().getValue("taskname")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"AssignTaskMobFormPlugin_12", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (this.getModel().getValue("start_time") == null || this.getModel().getValue("end_time") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d77\u6b62\u65e5\u671f\u3002", (String)"AssignTaskMobFormPlugin_13", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Date startTime = (Date)this.getModel().getValue("start_time");
        Date endTime = (Date)this.getModel().getValue("end_time");
        try {
            long mainOrgId = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(RequestContext.get().getUserId()));
            TaskUtil.getAbsDurationByOrgId((Object)mainOrgId, (Date)startTime, (Date)endTime, (String)this.getAppId());
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
            args.setCancel(true);
        }
        if (this.getModel().getValue(RP_BaseData) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8d23\u4efb\u4eba\u201d\u3002", (String)"AssignTaskMobFormPlugin_14", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (this.getModel().getValue("rp_dept_bd") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8d23\u4efb\u4eba\u90e8\u95e8\u201d\u3002", (String)"AssignTaskMobFormPlugin_15", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String value = (String)this.getModel().getValue("content");
        if (StringUtils.isEmpty((CharSequence)value)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5185\u5bb9\u8981\u6c42\u201d\u3002", (String)"AssignTaskMobFormPlugin_16", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key = afterDoOperationEventArgs.getOperateKey();
        if ((StringUtils.equals((CharSequence)key, (CharSequence)"save") || StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"updateAndSave")) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4ea4\u529e\u4efb\u52a1\u53d1\u5e03\u6210\u529f\u3002", (String)"AssignTaskMobFormPlugin_11", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            HashMap<String, Boolean> data = new HashMap<String, Boolean>();
            data.put("assignRefresh", true);
            this.getView().returnDataToParent(data);
            this.getView().close();
        }
    }

    protected void initDoc(DynamicObject task) {
        QFilter[] filters = new QFilter[]{new QFilter("finterid", "=", (Object)String.valueOf(task.getPkValue())), new QFilter("fbilltype", "=", (Object)task.getDataEntityType().getName()), new QFilter("fattachmentpanel", "=", (Object)"attachmentpanel")};
        DynamicObject[] files = BusinessDataServiceHelper.load((String)"bos_attachment", (String)"fattachmentname,fattachmentsize,fbilltype,fnumber,ffileid,fmodifytime", (QFilter[])filters);
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        dynamicObjects.addAll(Arrays.asList(files));
        this.getModel().setValue("attachmentpanel", (Object)dynamicObjects);
    }

    protected void syncToFileService(DynamicObject task) {
        QFilter[] filters = new QFilter[]{new QFilter("finterid", "=", (Object)String.valueOf(task.getPkValue())), new QFilter("fbilltype", "=", (Object)this.getEntityMetaDataTag(assignTaskBillId)), new QFilter("fattachmentpanel", "=", (Object)"attachmentpanel")};
        DynamicObject[] files = BusinessDataServiceHelper.load((String)"bos_attachment", (String)"fattachmentname,fattachmentsize,fbilltype,fnumber,ffileid,fmodifytime", (QFilter[])filters);
        ArrayList attchmentList = new ArrayList(32);
        for (DynamicObject file : files) {
            String fileName = file.getString("fattachmentname");
            LinkedHashMap<String, String> attachmentMap = new LinkedHashMap<String, String>(16);
            attachmentMap.put("name", fileName);
            attachmentMap.put("size", file.getString("fattachmentsize"));
            attachmentMap.put("status", "success");
            attachmentMap.put("type", file.getString("fbilltype"));
            attachmentMap.put("uid", file.getString("fnumber"));
            String fullUrl = UrlService.getAttachmentFullUrl((String)file.getString("ffileid"));
            attachmentMap.put("url", fullUrl);
            attchmentList.add(attachmentMap);
        }
        AttachmentPanel panel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        panel.upload(attchmentList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String generateTempUrl(String fileUrl, String fileName) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream inputStream = null;
        try {
            URL url = new URL(fileUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            inputStream = conn.getResponseCode() >= 400 ? conn.getErrorStream() : conn.getInputStream();
            String tempUrl = cache.saveAsUrl(fileName, inputStream, 5000);
            String address = RequestContext.get().getClientFullContextPath();
            if (!address.endsWith("/")) {
                address = address + "/";
            }
            String string = tempUrl = address + tempUrl;
            return string;
        }
        catch (IOException e) {
            LOG.info("fail to generate temp url" + e.getMessage());
            String string = "";
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    private void deptChanged(String fieldKey) {
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)RP_BaseData)) {
            DynamicObject responsibleperson = (DynamicObject)this.getModel().getValue(RP_BaseData);
            if (responsibleperson != null) {
                long orgId = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(responsibleperson.getPkValue().toString()));
                DynamicObject responsibleDept = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgId)});
                if (responsibleDept != null) {
                    this.getModel().setValue("rp_dept_bd", (Object)responsibleDept);
                }
            } else {
                this.getModel().setValue("rp_dept_bd", null);
            }
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)MCP_BaseData)) {
            DynamicObjectCollection mcpPersons = (DynamicObjectCollection)this.getModel().getValue(MCP_BaseData);
            if (mcpPersons != null) {
                StringBuilder stringBuilder = new StringBuilder();
                DynamicObjectCollection mcpDeptObjects = new DynamicObjectCollection();
                for (DynamicObject mcpPerson : mcpPersons) {
                    String id = ((DynamicObject)mcpPerson.get("fbasedataid")).getPkValue().toString();
                    long orgId = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(id));
                    DynamicObject mcpDept = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgId)});
                    if (mcpDept == null) continue;
                    stringBuilder.append(mcpDept.getString("name")).append(",");
                    mcpDeptObjects.add((Object)mcpDept);
                }
                this.getModel().setValue("cp_dept_bd", (Object)mcpDeptObjects);
            } else {
                this.getModel().setValue("cp_dept_bd", null);
            }
        }
    }
}

