/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin.mobile;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pccs.placs.business.base.AbstractPlacsMobFormAdapter;
import kd.pccs.placs.business.utils.task.TaskIconMobUtil;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.enums.TaskTypeMobColorEnum;
import kd.pccs.placs.common.utils.YunZJUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PostTaskMobFormPlugin
extends AbstractPlacsMobFormAdapter
implements ClickListener {
    public void afterCreateNewData(EventObject e) {
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        String taskId = pageCache.get("taskId");
        if (taskId == null) {
            return;
        }
        QFilter preTaskFilter = new QFilter("pretask.id", "=", (Object)Long.valueOf(taskId));
        QFilter status = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] postTasks = BusinessDataServiceHelper.load((String)this.getEntityMetaDataTag("task"), (String)"id,name,tasktype,completionstatus,responsibleperson", (QFilter[])new QFilter[]{preTaskFilter, status});
        this.initPostTaskTitle(postTasks.length);
        Container postTaskListPanel = (Container)this.getView().getControl("posttask_list_panel");
        ArrayList<Map> containers = new ArrayList<Map>(10);
        for (int i = 0; i < postTasks.length; ++i) {
            DynamicObject postTask = postTasks[i];
            FlexPanelAp rowPanelAp = this.buildPanel(i);
            LabelAp taskNameLabel = this.buildTaskNameLabel(postTask, i);
            rowPanelAp.getItems().add(taskNameLabel);
            LabelAp taskTypeLabel = this.buildTaskTypeLabel(postTask, i);
            rowPanelAp.getItems().add(taskTypeLabel);
            ImageAp completionStatusIcon = this.buildCompletionStatusIcon(postTask, i);
            rowPanelAp.getItems().add(completionStatusIcon);
            LabelAp completionStatusLabel = this.buildCompletionStatusLabel(postTask, i);
            rowPanelAp.getItems().add(completionStatusLabel);
            LabelAp contactLabel = this.buildContactLabel(postTask, i);
            rowPanelAp.getItems().add(contactLabel);
            VectorAp jumpIcon = this.buildJumpIcon(postTask, i);
            rowPanelAp.getItems().add(jumpIcon);
            containers.add(rowPanelAp.createControl());
        }
        postTaskListPanel.addControls(containers);
        this.getView().updateView();
    }

    protected FlexPanelAp buildPanel(int i) {
        FlexPanelAp rowPanelAp = new FlexPanelAp();
        rowPanelAp.setKey("row_" + i);
        rowPanelAp.setWidth(new LocaleString("100%"));
        rowPanelAp.setAutoTextWrap(true);
        rowPanelAp.setHeight(new LocaleString("40px"));
        rowPanelAp.setAlignItems("center");
        rowPanelAp.setAlignContent("flex-start");
        rowPanelAp.setWrap(true);
        return rowPanelAp;
    }

    protected LabelAp buildTaskNameLabel(DynamicObject postTask, int index) {
        String taskName = postTask.getString("name");
        LabelAp taskNameLabel = new LabelAp();
        taskNameLabel.setWidth(new LocaleString("20%"));
        if (StringUtil.isEmptyString((String)taskName)) {
            return taskNameLabel;
        }
        taskNameLabel.setKey("task_name_val_" + index);
        taskNameLabel.setName(new LocaleString(taskName));
        return taskNameLabel;
    }

    protected LabelAp buildTaskTypeLabel(DynamicObject postTask, int index) {
        LabelAp taskTypeLabel = new LabelAp();
        DynamicObject tasktype = postTask.getDynamicObject("tasktype");
        if (tasktype == null) {
            return taskTypeLabel;
        }
        String taskTypeName = postTask.getString("tasktype.name");
        String taskNumber = postTask.getString("tasktype.number");
        TaskTypeMobColorEnum typeMobColorEnum = TaskTypeMobColorEnum.findByValue((String)taskNumber);
        taskTypeLabel.setId("task_type_val_" + index);
        taskTypeLabel.setKey("task_type_val_" + index);
        taskTypeLabel.setName(new LocaleString(taskTypeName));
        taskTypeLabel.setRadius("2");
        taskTypeLabel.setForeColor(typeMobColorEnum.getForeColor());
        taskTypeLabel.setBackColor(typeMobColorEnum.getBackColor());
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("5px");
        style.setMargin(margin);
        Padding padding = new Padding();
        padding.setLeft("7px");
        padding.setRight("7px");
        style.setPadding(padding);
        Border border = new Border();
        border.setBottom("0.5px_solid_" + typeMobColorEnum.getBorderColor());
        border.setRight("0.5px_solid_" + typeMobColorEnum.getBorderColor());
        border.setTop("0.5px_solid_" + typeMobColorEnum.getBorderColor());
        border.setLeft("0.5px_solid_" + typeMobColorEnum.getBorderColor());
        style.setBorder(border);
        taskTypeLabel.setStyle(style);
        return taskTypeLabel;
    }

    protected void jumpToChat(int rowIndex) {
        String userId = this.getPageCache().get("user_id_" + rowIndex);
        if (StringUtils.isEmpty((CharSequence)userId) || !StringUtils.isNumeric((CharSequence)userId)) {
            return;
        }
        List userInfoList = UserServiceHelper.get(Collections.singletonList(Long.valueOf(userId)));
        if (CollectionUtils.isEmpty((Collection)userInfoList)) {
            return;
        }
        Map userInfo = (Map)userInfoList.get(0);
        String userOpenId = (String)userInfo.get("useropenid");
        if (StringUtils.isEmpty((CharSequence)userOpenId)) {
            return;
        }
        YunZJUtil.openChatView((IFormView)this.getView(), (String)userOpenId);
    }

    protected ImageAp buildCompletionStatusIcon(DynamicObject postTask, int index) {
        ImageAp vectorIcon = new ImageAp();
        String completionStatus = postTask.getString("completionstatus");
        if (StringUtil.isEmptyString((String)completionStatus)) {
            return vectorIcon;
        }
        CompletionStatusEnum statusEnum = CompletionStatusEnum.getEnumByValue((Object)completionStatus);
        if (statusEnum == null) {
            return vectorIcon;
        }
        vectorIcon.setKey("completion_status_icon" + index);
        vectorIcon.setWidth(new LocaleString("16px"));
        vectorIcon.setHeight(new LocaleString("16px"));
        vectorIcon.setImageKey(TaskIconMobUtil.setStatusImg((String)statusEnum.getValue()));
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("10px");
        style.setMargin(margin);
        vectorIcon.setStyle(style);
        return vectorIcon;
    }

    protected LabelAp buildCompletionStatusLabel(DynamicObject postTask, int index) {
        LabelAp completionStatusLabel = new LabelAp();
        String completionStatus = postTask.getString("completionstatus");
        if (StringUtil.isEmptyString((String)completionStatus)) {
            return completionStatusLabel;
        }
        CompletionStatusEnum statusEnum = CompletionStatusEnum.getEnumByValue((Object)completionStatus);
        if (statusEnum == null) {
            return completionStatusLabel;
        }
        completionStatusLabel.setKey("completion_status_val_" + index);
        completionStatusLabel.setName(new LocaleString(statusEnum.getName()));
        completionStatusLabel.setWidth(new LocaleString("15%"));
        return completionStatusLabel;
    }

    protected LabelAp buildContactLabel(DynamicObject postTask, int index) {
        LabelAp contactLabel = new LabelAp();
        DynamicObject responsiblePerson = postTask.getDynamicObject("responsibleperson");
        if (responsiblePerson == null) {
            return contactLabel;
        }
        String responsiblePersonName = responsiblePerson.getString("name");
        this.getPageCache().put("user_id_" + index, responsiblePerson.getPkValue().toString());
        contactLabel.setFontSize(16);
        contactLabel.setKey("contact_label_" + index);
        contactLabel.setName(new LocaleString(responsiblePersonName));
        contactLabel.setTextAlign("center");
        contactLabel.setClickable(true);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("60px");
        style.setMargin(margin);
        contactLabel.setStyle(style);
        return contactLabel;
    }

    protected VectorAp buildJumpIcon(DynamicObject postTask, int index) {
        VectorAp vectorIcon = new VectorAp();
        vectorIcon.setId("jump_icon" + index);
        vectorIcon.setKey("jump_icon" + index);
        vectorIcon.setfontClass("kdfont kdfont-fangxiangyou");
        vectorIcon.setTextAlign("center");
        vectorIcon.setClickable(true);
        vectorIcon.setOperationKey("jump");
        return vectorIcon;
    }

    protected void initPostTaskTitle(Integer postTaskNum) {
        Label postTaskTitleVal = (Label)this.getView().getControl("posttask_title_val");
        if (postTaskTitleVal != null) {
            postTaskTitleVal.setText(postTaskNum.toString());
        }
        this.getPageCache().put("postTaskNum", postTaskNum.toString());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void onGetControl(OnGetControlArgs e) {
        if (StringUtils.contains((CharSequence)e.getKey(), (CharSequence)"jump_icon")) {
            Vector button = new Vector();
            button.setKey(e.getKey());
            button.setView(this.getView());
            button.addClickListener((ClickListener)this);
            e.setControl((Control)button);
        } else if (StringUtils.contains((CharSequence)e.getKey(), (CharSequence)"contact_label_")) {
            Label label = new Label();
            label.setKey(e.getKey());
            label.setView(this.getView());
            label.addClickListener((ClickListener)this);
            e.setControl((Control)label);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button c = (Button)evt.getSource();
        String key = c.getKey().toLowerCase();
        if (key.contains("jump_icon")) {
            String rowIndex = StringUtils.replace((String)key, (String)"jump_icon", (String)"");
            this.jumpToChat(Integer.parseInt(rowIndex));
        } else if (key.contains("contact_label_")) {
            String rowIndex = StringUtils.replace((String)key, (String)"contact_label_", (String)"");
            this.jumpToChat(Integer.parseInt(rowIndex));
        }
    }
}

