/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin.mobile;

import com.kingdee.bos.qing.data.util.DateUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterMobileListPushDownRefreshEvent;
import kd.bos.form.events.AfterMobileListPushDownRefreshListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pccs.placs.business.base.AbstractPlacsMobListAdapter;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.DefaultEnum;
import kd.pccs.placs.common.enums.PlanEnum;
import kd.pccs.placs.common.enums.RiskColorEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.enums.TaskTypeEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.common.utils.permission.PermServiceHelper;

public class TaskMobListPlugin
extends AbstractPlacsMobListAdapter
implements ClickListener {
    private static final Log LOG = LogFactory.getLog(TaskMobListPlugin.class);
    private static final String screenEntityID = "report_screen_mobile";
    private static final String detailEntityID = "taskreport_mobile";
    private static final String detailAssignEntityID = "assigntask_mobile";
    private static final String reportlistEntityID = "reportlist_mobile";
    private static final String billlistap = "billlistap";
    private static final String billlistapAssign = "billlistap_assign";
    public static final String MAINRESPONSE = "1";
    public static final String COOPERATION = "2";
    public static final String SHARE = "3";
    public static final String hasCompleteStatus = "4,5";
    public static final String status_all = "0";
    public static final String chartAp = "piechartap";
    public static final String chartApAssign = "piechartap_assign";
    protected static final String[] chartColors = new String[]{"#D0DBFF", "#00BBFF", "#F57582", "#83F348", "#2EECE9", "#FFDB4A"};
    public static final String reportStatus = "status";
    public static final String assignStatus = "assignStatus";
    private static final String IMAGE_PATH = "icons/pc/state/";

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)"screenClose", (CharSequence)actionId)) {
            if (e.getReturnData() != null) {
                Map data = (Map)e.getReturnData();
                String time = (String)data.get("selectedTime");
                String type = (String)data.get("selectedType");
                this.getPageCache().put("selectedTime", time);
                this.getPageCache().put("selectedType", type);
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                if ("range".equals(time)) {
                    Date startTime = (Date)data.get("startTime");
                    Date endTime = (Date)data.get("endTime");
                    this.getPageCache().put("startTime", DateUtils.DateToString((Date)startTime, (String)"yyyy/MM/dd"));
                    this.getPageCache().put("endTime", DateUtils.DateToString((Date)endTime, (String)"yyyy/MM/dd"));
                    this.addScreen(time, type, (Date)data.get("startTime"), (Date)data.get("endTime"), qFilters);
                } else {
                    this.addScreen(time, type, null, null, qFilters);
                }
                String statusSelect = this.getPageCache().get(reportStatus);
                this.addStatusSelect(qFilters, statusSelect);
                int count = this.initReportListAndCharts(qFilters);
                this.initComboItems(statusSelect, count);
            }
        } else if (StringUtils.equals((CharSequence)"refresh", (CharSequence)actionId) && e.getReturnData() != null) {
            ArrayList<Object> qFilters = new ArrayList<QFilter>();
            this.initAssignListAndCharts(qFilters);
            qFilters = new ArrayList();
            String statusSelect = this.getPageCache().get(reportStatus);
            this.addStatusSelect(qFilters, statusSelect);
            this.initReportListAndCharts(qFilters);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Container screen = (Container)this.getView().getControl("flex_screen");
        screen.addClickListener((ClickListener)this);
        BillList billList = (BillList)this.getView().getControl(billlistap);
        billList.addListRowClickListener((ListRowClickListener)this);
        billList.addMobileListPushDownRefreshistener((AfterMobileListPushDownRefreshListener)this);
        BillList billListAssign = (BillList)this.getView().getControl(billlistapAssign);
        billListAssign.addListRowClickListener((ListRowClickListener)this);
        billListAssign.addMobileListPushDownRefreshistener((AfterMobileListPushDownRefreshListener)this);
        Button assignTaskBtn = (Button)this.getView().getControl("assign_task_btn");
        assignTaskBtn.addClickListener((ClickListener)this);
        Chart pieChart = (Chart)this.getControl(chartAp);
        pieChart.addClickListener((ClickListener)this);
        Chart pieChartAssign = (Chart)this.getControl(chartApAssign);
        pieChartAssign.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ArrayList<Object> qFilters = new ArrayList<QFilter>();
        this.initAssignListAndCharts(qFilters);
        qFilters = new ArrayList();
        String statusSelect = CompletionStatusEnum.PROGRESSING.getValue();
        this.addStatusSelect(qFilters, statusSelect);
        int count = this.initReportListAndCharts(qFilters);
        this.initComboItems(statusSelect, count);
    }

    protected int initReportListAndCharts(List<QFilter> qFilters) {
        this.filterReportTaskList(qFilters);
        ArrayList<QFilter> chartsQFilters = new ArrayList<QFilter>(qFilters);
        this.refreshCharts(chartsQFilters, chartAp);
        return this.refreshReportBilllistap(qFilters);
    }

    protected void initAssignListAndCharts(List<QFilter> qFilters) {
        this.filterAssignTaskList(qFilters);
        this.refreshAssignTaskList(qFilters);
        ArrayList<QFilter> chartsQFilters = new ArrayList<QFilter>(qFilters);
        this.refreshCharts(chartsQFilters, chartApAssign);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "flex_screen": {
                this.openScreenView();
                break;
            }
            case "assign_task_btn": {
                this.openAssignTask();
                break;
            }
            case "piechartap": {
                this.chartApClickEvent(evt);
                break;
            }
            case "piechartap_assign": {
                this.chartApClickEvent(evt);
                break;
            }
        }
    }

    private void chartApClickEvent(EventObject evt) {
        ChartClickEvent event = (ChartClickEvent)evt;
        String clickName = event.getName();
        String key = event.getSource().getKey();
        String statusSelect = this.getStatusValue(clickName);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        this.addStatusSelectCharts(qFilters, statusSelect);
        if (chartAp.equals(key)) {
            int count = this.refreshReportTaskList(qFilters);
            this.initComboItems(statusSelect, count);
            this.getPageCache().put(reportStatus, statusSelect);
        } else if (chartApAssign.equals(key)) {
            this.filterAssignTaskList(qFilters);
            this.refreshAssignTaskList(qFilters);
            this.getPageCache().put(assignStatus, statusSelect);
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        BillList billList = (BillList)evt.getSource();
        String key = billList.getKey();
        HashMap<String, String> map = new HashMap<String, String>();
        ListSelectedRow row = evt.getCurrentListSelectedRow();
        if (row == null) {
            return;
        }
        Object taskId = null;
        if (billlistap.equals(key)) {
            taskId = row.getPrimaryKeyValue();
            map.put("formId", this.getEntityMetaDataTag(detailEntityID));
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setCustomParam("taskId", taskId);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh"));
            this.getView().showForm(showParameter);
        } else if (billlistapAssign.equals(key)) {
            taskId = row.getPrimaryKeyValue();
            map.put("formId", this.getEntityMetaDataTag(detailAssignEntityID));
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setCustomParam("taskId", taskId);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh"));
            this.getView().showForm(showParameter);
        }
    }

    public void afterPushDownRefresh(AfterMobileListPushDownRefreshEvent evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (billlistap.equals(key)) {
            String statusSelect = this.getPageCache().get(reportStatus);
            if (statusSelect != null && !statusSelect.equals(status_all)) {
                qFilters.add(new QFilter("completionstatus", "=", (Object)statusSelect));
            }
            this.refreshReportTaskList(qFilters);
            this.refreshCharts(qFilters, chartAp);
        } else if (billlistapAssign.equals(key)) {
            String statusSelect = this.getPageCache().get(assignStatus);
            if (statusSelect != null && !statusSelect.equals(status_all)) {
                qFilters.add(new QFilter("completionstatus", "=", (Object)statusSelect));
            }
            this.initAssignListAndCharts(qFilters);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"status_select", (CharSequence)fieldKey)) {
            String statusSelect = String.valueOf(this.getModel().getValue("status_select"));
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            this.addStatusSelect(qFilters, statusSelect);
            int count = this.refreshReportTaskList(qFilters);
            this.initComboItems(statusSelect, count);
        }
    }

    protected String getStatusValue(String name) {
        if (name != null) {
            for (CompletionStatusEnum enums : CompletionStatusEnum.values()) {
                if (!StringUtils.equals((CharSequence)name, (CharSequence)enums.getName())) continue;
                return enums.getValue();
            }
        }
        return null;
    }

    protected void initComboItems(String statusSelect, int count) {
        ComboItem comboItem;
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("status_select");
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(10);
        String onlineComplete = CompletionStatusEnum.ONTIMECOMPLETE.getValue();
        String overComplete = CompletionStatusEnum.OVERDUECOMPLETE.getValue();
        LocaleString thisCombo = null;
        if (statusSelect.equals(status_all)) {
            comboItem = new ComboItem(new LocaleString(String.format(ResManager.loadKDString((String)"\u5168\u90e8\uff08%s\uff09", (String)"TaskMobListPlugin_0", (String)"pccs-placs-formplugin", (Object[])new Object[0]), count)), status_all);
            propertyItems.add(comboItem);
            comboEdit.selectedStore(comboItem);
            thisCombo = comboItem.getCaption();
        } else {
            propertyItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8", (String)"TaskMobListPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0])), status_all));
        }
        if (hasCompleteStatus.contains(statusSelect)) {
            comboItem = new ComboItem(new LocaleString(String.format(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\uff08%s\uff09", (String)"TaskMobListPlugin_2", (String)"pccs-placs-formplugin", (Object[])new Object[0]), count)), "5");
            propertyItems.add(comboItem);
            comboEdit.selectedStore(comboItem);
            thisCombo = comboItem.getCaption();
        } else {
            propertyItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"TaskMobListPlugin_3", (String)"pccs-placs-formplugin", (Object[])new Object[0])), "5"));
        }
        for (CompletionStatusEnum statusEnum : CompletionStatusEnum.values()) {
            ComboItem comboItem2 = new ComboItem();
            String value = statusEnum.getValue();
            comboItem2.setValue(value);
            if (value.equals(onlineComplete) || value.equals(overComplete)) continue;
            if (statusSelect.equals(value)) {
                comboItem2.setCaption(new LocaleString(statusEnum.getName() + " \uff08" + count + "\uff09"));
                comboEdit.selectedStore(comboItem2);
                thisCombo = comboItem2.getCaption();
            } else {
                comboItem2.setCaption(new LocaleString(statusEnum.getName()));
            }
            propertyItems.add(comboItem2);
        }
        comboEdit.setComboItems(propertyItems);
        this.getModel().beginInit();
        if (hasCompleteStatus.contains(statusSelect)) {
            this.getModel().setValue("status_select", (Object)"5");
        } else {
            this.getModel().setValue("status_select", (Object)statusSelect);
        }
        this.getModel().endInit();
        this.getView().updateView("flexpanelap2");
    }

    protected void addStatusSelect(List<QFilter> qFilters, String statusSelect) {
        if (statusSelect != null && !status_all.equals(statusSelect)) {
            if (hasCompleteStatus.contains(statusSelect)) {
                statusSelect = CompletionStatusEnum.ONTIMECOMPLETE.getValue() + "," + CompletionStatusEnum.OVERDUECOMPLETE.getValue();
                qFilters.add(new QFilter("completionstatus", "in", (Object)statusSelect.split(",")));
            } else {
                qFilters.add(new QFilter("completionstatus", "=", (Object)statusSelect));
            }
        }
        this.getPageCache().put(reportStatus, statusSelect);
    }

    protected void addStatusSelectCharts(List<QFilter> qFilters, String statusSelect) {
        if (statusSelect != null && !status_all.equals(statusSelect)) {
            qFilters.add(new QFilter("completionstatus", "=", (Object)statusSelect));
        }
    }

    protected void openScreenView() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("formId", this.getEntityMetaDataTag(screenEntityID));
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
        showParameter.getOpenStyle().setShowType(ShowType.NonModal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "screenClose"));
        this.getView().showForm(showParameter);
    }

    protected void openAssignTask() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("formId", this.getEntityMetaDataTag(detailAssignEntityID));
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh"));
        this.getView().showForm(showParameter);
    }

    protected void addScreen(String time, String type, Date startTime, Date endTime, List<QFilter> qFilters) {
        if (time != null) {
            if (time.equals("range")) {
                qFilters.add(new QFilter("planendtime", ">=", (Object)startTime));
                qFilters.add(new QFilter("planendtime", "<=", (Object)endTime));
            } else {
                try {
                    String mainTime = this.exchangeToTime(time);
                    if (mainTime != null) {
                        qFilters.add(new QFilter("planendtime", ">=", (Object)DateUtils.stringToDate((String)mainTime, (String)"yyyy/MM/dd")));
                    }
                }
                catch (ParseException e) {
                    LOG.error((Throwable)e);
                    throw new KDBizException(e.toString());
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)type) && !type.contains("all")) {
            String[] types = type.split(",");
            DynamicObject[] taskTypes = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasktype"), (String)"number, name, status, creator, modifier, enable, createtime, modifytime, masterid, checkboxisprojecttask, mulilangtextdescription, checkboxissys", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)types)});
            if (taskTypes.length > 0) {
                Set taskIds = Stream.of(taskTypes).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
                qFilters.add(new QFilter("tasktype", "in", taskIds));
            }
        }
    }

    protected int refreshReportTaskList(List<QFilter> qFilters) {
        String time = this.getPageCache().get("selectedTime");
        String type = this.getPageCache().get("selectedType");
        if ("range".equals(time)) {
            String startTime = this.getPageCache().get("startTime");
            String endTime = this.getPageCache().get("endTime");
            try {
                this.addScreen(time, type, DateUtils.stringToDate((String)startTime, (String)"yyyy/MM/dd"), DateUtils.stringToDate((String)endTime, (String)"yyyy/MM/dd"), qFilters);
            }
            catch (ParseException exception) {
                LOG.error((Throwable)exception);
                throw new KDBizException(exception.toString());
            }
        } else {
            this.addScreen(time, type, null, null, qFilters);
        }
        this.filterReportTaskList(qFilters);
        return this.refreshReportBilllistap(qFilters);
    }

    protected String exchangeToTime(String selectedTime) {
        String time = null;
        Calendar calendar = Calendar.getInstance();
        switch (selectedTime) {
            case "all": {
                break;
            }
            case "thisMonth": {
                calendar.add(2, 0);
                calendar.set(5, 1);
                time = DateUtils.DateToString((Date)calendar.getTime(), (String)"yyyy/MM/dd");
                break;
            }
            case "thisWeek": {
                calendar.set(7, 2);
                time = DateUtils.DateToString((Date)calendar.getTime(), (String)"yyyy/MM/dd");
                break;
            }
            case "range": {
                break;
            }
        }
        LOG.info(time);
        return time;
    }

    protected void filterAssignTaskList(List<QFilter> qFilters) {
        DynamicObject taskType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasktype"), (String)"number, name, status, creator, modifier, enable, createtime, modifytime, masterid, checkboxisprojecttask, mulilangtextdescription, checkboxissys", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)TaskTypeEnum.ASSIGNTASK.getValue())});
        if (null != taskType) {
            qFilters.add(new QFilter("tasktype", "=", taskType.getPkValue()));
        }
        QFilter creatoFilter = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        qFilters.add(creatoFilter);
        QFilter taskSourceFilter = new QFilter("number", "=", (Object)TaskTypeEnum.ASSIGNTASK.getValue());
        DynamicObject taskSource = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasksource"), (String)"id", (QFilter[])new QFilter[]{taskSourceFilter});
        if (null != taskSource) {
            qFilters.add(new QFilter("tasksource", "=", taskSource.getPkValue()));
        }
    }

    protected void refreshAssignTaskList(List<QFilter> qFilters) {
        BillList billlistap = (BillList)this.getControl(billlistapAssign);
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setQFilters(qFilters);
        billlistap.setFilterParameter(filterParameter);
        billlistap.setOrderBy("planendtime desc");
        billlistap.refresh();
        this.getView().updateView("tabpageap1");
    }

    protected void refreshCharts(List<QFilter> qFilters, String chartAp) {
        PieChart pieChart = (PieChart)this.getControl(chartAp);
        this.drawCharts(qFilters, pieChart);
    }

    protected void filterReportTaskList(List<QFilter> qFilters) {
        String userId = RequestContext.get().getUserId();
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            QFilter respFilter = new QFilter("responsibleperson", "=", (Object)Long.parseLong(userId));
            QFilter statusFilter = new QFilter(reportStatus, "=", (Object)BillStatus.C);
            QFilter coopFilter = new QFilter("multicooperationperson.fbasedataid.id", "=", (Object)Long.parseLong(userId));
            QFilter shareFilter = new QFilter("sharer", "=", (Object)Long.parseLong(userId));
            qFilters.add(respFilter.or(coopFilter).or(shareFilter).and(statusFilter));
        }
        this.filterReportTask(qFilters);
    }

    protected int refreshReportBilllistap(List<QFilter> qFilters) {
        BillList billlistap = (BillList)this.getControl(billlistap);
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setQFilters(qFilters);
        billlistap.setFilterParameter(filterParameter);
        billlistap.setOrderBy("planendtime desc");
        billlistap.refresh();
        this.getView().updateView("flexpanelap1");
        return billlistap.queryBillDataCount();
    }

    protected String getStatusImg(String status) {
        switch (status) {
            case "1": {
                return "icons/pc/state/weikaishi.png";
            }
            case "2": {
                return "icons/pc/state/jinxingzhong.png";
            }
            case "3": {
                return "icons/pc/state/yuqiweiwancheng.png";
            }
            case "4": {
                return "icons/pc/state/anqijinxing.png";
            }
            case "5": {
                return "icons/pc/state/yuqijinxing.png";
            }
            case "6": {
                return "icons/pc/state/yujiyuqi.png";
            }
        }
        return null;
    }

    protected void drawCharts(List<QFilter> qFilters, PieChart pieChart) {
        pieChart.clearData();
        pieChart.setShowLegend(true);
        pieChart.setLegendVertical(true);
        pieChart.setLegendPropValue("right", (Object)5);
        pieChart.setLegendPropValue("top", (Object)"5");
        pieChart.setLegendPropValue("itemWidth", (Object)10);
        pieChart.setLegendPropValue("itemHeight", (Object)10);
        PieSeries series = pieChart.createPieSeries(ResManager.loadKDString((String)"\u6211\u63a5\u6536\u7684\u4efb\u52a1", (String)"TaskMobListPlugin_4", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        series.setCenter("43%", "58%");
        series.setRadius("45%", "70%");
        HashMap labelMap = new HashMap();
        HashMap<String, Comparable<Boolean>> normalMap = new HashMap<String, Comparable<Boolean>>();
        normalMap.put("show", Boolean.valueOf(true));
        normalMap.put("fontSize", Integer.valueOf(14));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{c}").append(ResManager.loadKDString((String)"\u6761", (String)"TaskMobListPlugin_5", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
        normalMap.put("formatter", stringBuilder);
        labelMap.put("normal", normalMap);
        series.setPropValue("label", labelMap);
        series.setData(this.initChartsData(chartColors, this.initStatusValues(qFilters), CompletionStatusEnum.values()));
        this.getView().updateView(pieChart.getKey());
    }

    private Map<String, BigDecimal> initStatusValues(List<QFilter> qFilters) {
        System.setProperty("orm.opt.in.threshold", "100");
        List ids = Arrays.stream(CompletionStatusEnum.values()).map(CompletionStatusEnum::getValue).collect(Collectors.toList());
        QFilter delFilter = null;
        for (QFilter qFilter : qFilters) {
            if ("completionstatus".equals(qFilter.getProperty())) {
                qFilter.__setCP("in");
                qFilter.__setValue(ids);
            }
            if (!"id".equals(qFilter.getProperty())) continue;
            delFilter = qFilter;
        }
        if (delFilter != null) {
            qFilters.remove(delFilter);
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(" select  fcompletionstatus ,count(fid) num  from ", new Object[0]).append(this.getTaskTableName(), new Object[0]);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"belongplantype,plans,planid,tasksource", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        ArrayList<Object> taskList = new ArrayList<Object>();
        this.filterLatestTask(tasks, taskList);
        if (qFilters.size() > 0) {
            sqlBuilder.append("where 1=1  ", new Object[0]);
            if (taskList.size() > 0) {
                sqlBuilder.append("and", new Object[0]);
                sqlBuilder.appendIn(((IDataEntityProperty)dt.getProperties().get((Object)"id")).getAlias(), taskList);
            } else {
                return new HashMap<String, BigDecimal>();
            }
        }
        sqlBuilder.append("group by fcompletionstatus ", new Object[0]);
        String algoKey = "EcTaskListFormPlugin.executeSql";
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"cr"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                map.put(row.getString(0), row.getBigDecimal(1));
            }
        }
        return map;
    }

    protected String getTaskTableName() {
        return "t_" + this.getAppId() + "_task";
    }

    protected ItemValue[] initChartsData(String[] colors, Map<String, BigDecimal> values, CompletionStatusEnum[] names) {
        ItemValue[] items = new ItemValue[names.length];
        for (int i = 0; i < names.length; ++i) {
            BigDecimal value = values.get(names[i].getValue());
            items[i] = value != null ? new ItemValue(names[i].getName(), (Number)value, colors[i]) : new ItemValue(names[i].getName(), (Number)0, colors[i]);
        }
        return items;
    }

    protected void filterReportTask(List<QFilter> qFilterList) {
        QFilter logicalQFilter = null;
        QFilter colorQFilter = null;
        for (QFilter qFilter : qFilterList) {
            if (StringUtils.equalsIgnoreCase((CharSequence)qFilter.getProperty(), (CharSequence)"logical")) {
                logicalQFilter = qFilter;
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)qFilter.getProperty(), (CharSequence)"riskcolor")) continue;
            colorQFilter = qFilter;
        }
        List orgIds = PermServiceHelper.getAllPermOrgsByOperate((String)"15", (String)RequestContext.get().getUserId(), (String)this.getAppId(), (String)this.getEntityMetaDataTag(reportlistEntityID), (String)"view");
        if (null != logicalQFilter) {
            qFilterList.remove(logicalQFilter);
        }
        if (null != colorQFilter) {
            Object riskColor = colorQFilter.getValue();
            ArrayList<String> colorList = new ArrayList<String>(10);
            if (riskColor instanceof List) {
                for (Object obj : (List)riskColor) {
                    colorList.add((String)obj);
                }
            } else {
                colorList.add((String)riskColor);
            }
            if (colorList.contains(RiskColorEnum.NOCOLOR.getValue())) {
                qFilterList.remove(colorQFilter);
                colorList.remove(RiskColorEnum.NOCOLOR.getValue());
                ArrayList<String> color = new ArrayList<String>();
                color.add(RiskColorEnum.RED.getValue());
                color.add(RiskColorEnum.YELLOW.getValue());
                QFilter newColorQFilter = new QFilter("riskcolor", "in", colorList).or(new QFilter("riskcolor", "not in", color));
                qFilterList.add(newColorQFilter);
            }
        }
        String userId = RequestContext.get().getUserId();
        List chargeOrgList = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)Boolean.TRUE);
        ArrayList<Long> chargeOrgIdList = new ArrayList<Long>(10);
        ArrayList<Long> commonOrgIdList = new ArrayList<Long>(10);
        for (Long orgId : orgIds) {
            if (chargeOrgList.contains(orgId)) {
                if (logicalQFilter == null) {
                    List allSubordinateOrgs = OrgServiceHelper.getAllSubordinateOrgs((long)orgId, (boolean)true);
                    chargeOrgIdList.addAll(allSubordinateOrgs);
                    continue;
                }
                chargeOrgIdList.add(orgId);
                continue;
            }
            commonOrgIdList.add(orgId);
        }
        QFilter userOrDeptFilter = this.getUserFilterByLogicalFilter(logicalQFilter, chargeOrgIdList, commonOrgIdList);
        QFilter latestTaskFilter = new QFilter("islatest", "=", (Object)MAINRESPONSE).and(reportStatus, "=", (Object)StatusEnum.CHECKED.getValue()).and("relationtask", "=", (Object)0);
        qFilterList.add(latestTaskFilter);
        ArrayList<QFilter> newQFilters = new ArrayList<QFilter>();
        newQFilters.addAll(qFilterList);
        if (null != userOrDeptFilter) {
            newQFilters.add(userOrDeptFilter);
        }
        newQFilters.add(latestTaskFilter);
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"belongplantype,plans,planid,tasksource", (QFilter[])newQFilters.toArray(new QFilter[newQFilters.size()]));
        ArrayList<Object> taskList = new ArrayList<Object>();
        this.filterLatestTask(tasks, taskList);
        QFilter taskFilter = new QFilter("id", "in", taskList);
        qFilterList.add(taskFilter);
    }

    protected QFilter getUserFilterByLogicalFilter(QFilter logicalQFilter, List<Long> chargeOrgIdList, List<Long> commonOrgIdList) {
        String userId = RequestContext.get().getUserId();
        QFilter userOrDeptFilter = null;
        if (null != logicalQFilter) {
            Object value = logicalQFilter.getValue();
            if (value instanceof ArrayList) {
                ArrayList list = new ArrayList(10);
                Object listFilter = logicalQFilter.getValue();
                for (Object obj : (List)listFilter) {
                    list.add(obj);
                }
                for (int i = 0; i < list.size(); ++i) {
                    String logical = list.get(i).toString();
                    userOrDeptFilter = this.getUserOrDeptFilterByMuiltyLogical(userOrDeptFilter, logical, chargeOrgIdList, commonOrgIdList);
                }
            } else {
                userOrDeptFilter = this.getUserOrDeptFilterByOneLogical(logicalQFilter, chargeOrgIdList, commonOrgIdList);
            }
        } else {
            if (chargeOrgIdList != null && !chargeOrgIdList.isEmpty()) {
                userOrDeptFilter = new QFilter("responsibledept", "in", chargeOrgIdList).or("multicooperationdept.fbasedataid.id", "in", chargeOrgIdList);
            }
            if (commonOrgIdList != null && !commonOrgIdList.isEmpty()) {
                if (userOrDeptFilter != null) {
                    QFilter respFilter = new QFilter("responsibledept", "in", commonOrgIdList).and("responsibleperson", "=", (Object)Long.parseLong(userId));
                    QFilter coopFilter = new QFilter("multicooperationdept.fbasedataid.id", "in", commonOrgIdList).and("multicooperationperson.fbasedataid.id", "=", (Object)Long.parseLong(userId));
                    QFilter shareFilter = new QFilter("sharer", "=", (Object)Long.parseLong(userId));
                    userOrDeptFilter = userOrDeptFilter.or(respFilter).or(coopFilter).or(shareFilter);
                } else {
                    QFilter respFilter = new QFilter("responsibledept", "in", commonOrgIdList).and("responsibleperson", "=", (Object)Long.parseLong(userId));
                    QFilter coopFilter = new QFilter("multicooperationdept.fbasedataid.id", "in", commonOrgIdList).and("multicooperationperson.fbasedataid.id", "=", (Object)Long.parseLong(userId));
                    QFilter shareFilter = new QFilter("sharer", "=", (Object)Long.parseLong(userId));
                    userOrDeptFilter = respFilter.or(coopFilter).or(shareFilter);
                }
            }
        }
        return userOrDeptFilter;
    }

    protected QFilter getUserOrDeptFilterByMuiltyLogical(QFilter userOrDeptFilter, String logical, List<Long> chargeOrgIdList, List<Long> commonOrgIdList) {
        String userId = RequestContext.get().getUserId();
        long userlongId = Long.parseLong(userId);
        if (userOrDeptFilter == null) {
            if (StringUtils.equalsIgnoreCase((CharSequence)logical, (CharSequence)MAINRESPONSE)) {
                if (chargeOrgIdList != null && !chargeOrgIdList.isEmpty()) {
                    userOrDeptFilter = new QFilter("responsibledept", "in", chargeOrgIdList).and("responsibleperson", "=", (Object)userlongId);
                }
                if (commonOrgIdList != null && !commonOrgIdList.isEmpty()) {
                    QFilter respFilter = new QFilter("responsibledept", "in", commonOrgIdList).and("responsibleperson", "=", (Object)userlongId);
                    userOrDeptFilter = userOrDeptFilter != null ? userOrDeptFilter.or(respFilter) : respFilter;
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)logical, (CharSequence)COOPERATION)) {
                if (chargeOrgIdList != null && !chargeOrgIdList.isEmpty()) {
                    userOrDeptFilter = new QFilter("multicooperationdept.fbasedataid.id", "in", chargeOrgIdList).and("multicooperationperson.fbasedataid.id", "=", (Object)userlongId);
                }
                if (commonOrgIdList != null && !commonOrgIdList.isEmpty()) {
                    QFilter coopFilter = new QFilter("multicooperationdept.fbasedataid.id", "in", commonOrgIdList).and("multicooperationperson.fbasedataid.id", "=", (Object)userlongId);
                    userOrDeptFilter = userOrDeptFilter != null ? userOrDeptFilter.or(coopFilter) : coopFilter;
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)logical, (CharSequence)SHARE)) {
                userOrDeptFilter = new QFilter("sharer", "in", (Object)userlongId);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)logical, (CharSequence)MAINRESPONSE)) {
            if (chargeOrgIdList != null && !chargeOrgIdList.isEmpty()) {
                QFilter chargeRespFilter = new QFilter("responsibledept", "in", chargeOrgIdList).and("responsibleperson", "=", (Object)userlongId);
                userOrDeptFilter = userOrDeptFilter.or(chargeRespFilter);
            }
            if (commonOrgIdList != null && !commonOrgIdList.isEmpty()) {
                QFilter respFilter = new QFilter("responsibledept", "in", commonOrgIdList).and("responsibleperson", "=", (Object)userlongId);
                userOrDeptFilter = userOrDeptFilter.or(respFilter);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)logical, (CharSequence)COOPERATION)) {
            if (chargeOrgIdList != null && !chargeOrgIdList.isEmpty()) {
                QFilter chargeCoopFilter = new QFilter("multicooperationdept.fbasedataid.id", "in", chargeOrgIdList).and("multicooperationperson.fbasedataid.id", "=", (Object)userlongId);
                userOrDeptFilter = userOrDeptFilter.or(chargeCoopFilter);
            }
            if (commonOrgIdList != null && !commonOrgIdList.isEmpty()) {
                QFilter coopFilter = new QFilter("multicooperationdept.fbasedataid.id", "in", commonOrgIdList).and("multicooperationperson.fbasedataid.id", "=", (Object)userlongId);
                userOrDeptFilter = userOrDeptFilter.or(coopFilter);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)logical, (CharSequence)SHARE)) {
            userOrDeptFilter = userOrDeptFilter.or("sharer", "=", (Object)userlongId);
        }
        return userOrDeptFilter;
    }

    protected QFilter getUserOrDeptFilterByOneLogical(QFilter logicalQFilter, List<Long> chargeOrgIdList, List<Long> commonOrgIdList) {
        String userId = RequestContext.get().getUserId();
        long userLongId = Long.parseLong(userId);
        QFilter userOrDeptFilter = null;
        String logical = logicalQFilter.getValue().toString();
        if (StringUtils.equalsIgnoreCase((CharSequence)logical, (CharSequence)MAINRESPONSE)) {
            if (chargeOrgIdList != null && !chargeOrgIdList.isEmpty()) {
                userOrDeptFilter = new QFilter("responsibledept", "in", chargeOrgIdList).and("responsibleperson", "=", (Object)userLongId);
            }
            if (commonOrgIdList != null && !commonOrgIdList.isEmpty()) {
                QFilter respFilter = new QFilter("responsibledept", "in", commonOrgIdList).and("responsibleperson", "=", (Object)userLongId);
                userOrDeptFilter = userOrDeptFilter != null ? userOrDeptFilter.or(respFilter) : respFilter;
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)logical, (CharSequence)COOPERATION)) {
            if (chargeOrgIdList != null && !chargeOrgIdList.isEmpty()) {
                userOrDeptFilter = new QFilter("multicooperationdept.fbasedataid.id", "in", chargeOrgIdList).and("multicooperationperson.fbasedataid.id", "=", (Object)userLongId);
            }
            if (commonOrgIdList != null && !commonOrgIdList.isEmpty()) {
                QFilter coopFilter = new QFilter("multicooperationdept.fbasedataid.id", "in", commonOrgIdList).and("multicooperationperson.fbasedataid.id", "=", (Object)userLongId);
                userOrDeptFilter = userOrDeptFilter != null ? userOrDeptFilter.or(coopFilter) : coopFilter;
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)logical, (CharSequence)SHARE)) {
            userOrDeptFilter = new QFilter("sharer", "=", (Object)userLongId);
        }
        return userOrDeptFilter;
    }

    protected void filterLatestTask(DynamicObject[] tasks, List<Object> taskList) {
        QFilter statusFilter = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
        for (DynamicObject task : tasks) {
            DynamicObject belongType = task.getDynamicObject("belongplantype");
            if (null != belongType && StringUtils.equalsIgnoreCase((CharSequence)belongType.getString("number"), (CharSequence)"MASTERPLAN_S")) {
                this.addLatestTask(taskList, statusFilter, task, "masterplan");
                continue;
            }
            if (null != belongType && (StringUtils.equalsIgnoreCase((CharSequence)belongType.getString("number"), (CharSequence)"TRANSACTIONPLAN_S") || StringUtils.equalsIgnoreCase((CharSequence)belongType.getString("number"), (CharSequence)"DECOMPOSITIONTASK_S"))) {
                this.addLatestTask(taskList, statusFilter, task, "deptplan");
                continue;
            }
            if (null != belongType && StringUtils.equalsIgnoreCase((CharSequence)belongType.getString("number"), (CharSequence)"PERSONALPLAN_S")) {
                taskList.add(task.getPkValue());
                continue;
            }
            this.addLatestTask(taskList, statusFilter, task, "specialplan");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addLatestTask(List<Object> taskList, QFilter statusFilter, DynamicObject task, String entityId) {
        String planId = task.getString("planid");
        DynamicObject taskSource = task.getDynamicObject("tasksource");
        if (null != taskSource) {
            QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf(DefaultEnum.YES.getValue().charAt(0)));
            QFilter taskSourceFilter = new QFilter("id", "=", taskSource.getPkValue());
            taskSource = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasksource"), (String)"id,number", (QFilter[])new QFilter[]{taskSourceFilter, enableFilter});
        }
        QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(planId));
        DynamicObject plan = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)entityId), (String)"name", (QFilter[])new QFilter[]{idFilter, statusFilter});
        if (plan == null) {
            if (null == taskSource || !StringUtils.equalsIgnoreCase((CharSequence)taskSource.getString("number"), (CharSequence)TaskTypeEnum.ASSIGNTASK.getValue())) return;
            taskList.add(task.getPkValue());
            return;
        } else {
            taskList.add(task.getPkValue());
        }
    }
}

