/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin.mobile;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.Video;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.Slider;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SliderEvent;
import kd.bos.form.control.events.SliderListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.HyperlinkAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.placs.business.base.AbstractPlacsMobFormAdapter;
import kd.pccs.placs.business.model.ProgressReportConstant;
import kd.pccs.placs.business.utils.task.AttachInfo;
import kd.pccs.placs.business.utils.task.AttachmentClassification;
import kd.pccs.placs.business.utils.task.AttachmentUtil;
import kd.pccs.placs.business.utils.task.TaskIconMobUtil;
import kd.pccs.placs.business.utils.task.TaskReportAttachMobUtil;
import kd.pccs.placs.business.utils.task.TaskReportDateMobUtil;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.PersonTypeEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.enums.TaskCompleteStatusMobColorEnum;
import kd.pccs.placs.common.enums.TaskTypeEnum;
import kd.pccs.placs.common.enums.TaskTypeMobColorEnum;
import kd.pccs.placs.common.enums.TransactionTypeEnum;
import org.apache.commons.collections4.CollectionUtils;

public class TaskReportEditMobPlugin
extends AbstractPlacsMobFormAdapter
implements ClickListener,
SliderListener {
    public void registerListener(EventObject e) {
        Button reportTaskBtn;
        super.registerListener(e);
        Button closeBtn = (Button)this.getView().getControl("close_btn");
        closeBtn.addClickListener((ClickListener)this);
        Button backBtn = (Button)this.getView().getControl("back_btn");
        backBtn.addClickListener((ClickListener)this);
        Button reportRecordBtn = (Button)this.getControl("reportrecordbtn");
        if (reportRecordBtn != null) {
            reportRecordBtn.addClickListener((ClickListener)this);
        }
        if ((reportTaskBtn = (Button)this.getControl("reporttaskbtn")) != null) {
            reportTaskBtn.addClickListener((ClickListener)this);
        }
        Slider progressSlider = (Slider)this.getControl("task_progress_sliderap");
        progressSlider.addSliderListener((SliderListener)this);
        this.addImageListeners();
    }

    protected void addImageListeners() {
        for (int i = 0; i < 9; ++i) {
            this.addClickListeners(new String[]{"imageap" + i});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long taskIdValue = (Long)formShowParameter.getCustomParam("taskId");
        if (taskIdValue == null) {
            return;
        }
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskIdValue, (String)this.getEntityMetaDataTag("reporttaskview"));
        this.initData(task);
    }

    protected void initData(DynamicObject task) {
        if (task == null) {
            return;
        }
        this.initDataForTaskName(task);
        this.initDataForPlanTime(task);
        this.initDataForExpectTime(task);
        this.initDataForCompletionStatus(task);
        this.initHiddenData(task);
        this.initDataForTaskProgress(task);
        this.initDataForPostTask(task);
        this.initDocEntry(task);
        this.loadReportRecord(task);
        this.initPageCache(task);
    }

    protected void initDocEntry(DynamicObject task) {
        if (this.isAchievementNode(task)) {
            this.initResultDocEntry(task);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"attachmentpanel"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"attachmentpanel"});
        }
    }

    protected boolean isAchievementNode(DynamicObject task) {
        boolean achievementNode = false;
        DynamicObjectCollection transactionTypeList = task.getDynamicObjectCollection("transactiontype");
        for (DynamicObject txType : transactionTypeList) {
            if (txType == null || txType.getDynamicObject(1) == null || !Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.getDynamicObject(1).getString("number"))) continue;
            achievementNode = true;
            break;
        }
        return achievementNode;
    }

    protected void initResultDocEntry(DynamicObject task) {
        DynamicObjectCollection taskResultDocEntry = task.getDynamicObjectCollection("taskresultdocentry1");
        Container taskAttachmentsPanel = (Container)this.getView().getControl("achieverpanel");
        if (taskAttachmentsPanel == null) {
            return;
        }
        ArrayList docControls = new ArrayList();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("achieveentity");
        for (int i = 0; i < taskResultDocEntry.size(); ++i) {
            DynamicObject resultDoc = (DynamicObject)taskResultDocEntry.get(i);
            DynamicObject dynamicObject = entryEntity.addNew();
            dynamicObject.set("resultname", (Object)resultDoc.getString("resultname1"));
            dynamicObject.set("desc", (Object)resultDoc.getString("resultdescription"));
            dynamicObject.set("force", (Object)resultDoc.getString("force1"));
            dynamicObject.set("frequency", (Object)resultDoc.getString("frequency1"));
        }
        taskAttachmentsPanel.addControls(docControls);
        this.getModel().setValue("docentrynum", (Object)taskResultDocEntry.size());
    }

    protected void initPageCache(DynamicObject task) {
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("taskId", task.getPkValue().toString());
    }

    protected void initDataForPostTask(DynamicObject task) {
        Label posttaskNumLabel;
        QFilter preTaskFilter = new QFilter("pretask.id", "=", task.getPkValue());
        QFilter status = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObjectCollection result = QueryServiceHelper.query((String)this.getEntityMetaDataTag("task"), (String)"id", (QFilter[])new QFilter[]{preTaskFilter, status});
        Integer postTaskNum = 0;
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            postTaskNum = result.size();
        }
        if ((posttaskNumLabel = (Label)this.getControl("posttask_num_label")) != null) {
            posttaskNumLabel.setText(postTaskNum.toString());
        }
    }

    protected void initDataForCompleteDescription(DynamicObject task) {
        String completeDescription = task.getString("completedescription");
        if (StringUtils.isEmpty((CharSequence)completeDescription)) {
            return;
        }
        this.getModel().setValue("reportdesc", (Object)completeDescription);
    }

    protected void initHiddenData(DynamicObject task) {
        String userName = RequestContext.get().getUserName();
        if (!StringUtil.isEmptyString((String)userName)) {
            this.getModel().setValue("huibaoperson", (Object)userName);
        }
        this.getModel().setValue("task", task.getPkValue());
        this.initHuibaorenData(task);
    }

    protected void initHuibaorenData(DynamicObject taskReportView) {
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskReportView.getPkValue(), (String)this.getEntityMetaDataTag("task"));
        DynamicObject responPerson = task.getDynamicObject("responsibleperson");
        DynamicObjectCollection cooperatePersons = task.getDynamicObjectCollection("multicooperationperson");
        List cooperatePersonIds = cooperatePersons.stream().map(o -> o.getString("fbasedataid_id")).collect(Collectors.toList());
        DynamicObject sharer = task.getDynamicObject("sharer");
        String name = RequestContext.get().getUserName();
        String userId = RequestContext.get().getUserId();
        if (null != responPerson && StringUtils.equals((CharSequence)responPerson.getString("id"), (CharSequence)userId)) {
            this.getModel().setValue("huibaoperson", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u4e3b\u8d23\u4eba\uff09", (String)"TaskReportEditMobPlugin_13", (String)"pccs-placs-formplugin", (Object[])new Object[0]), name));
            this.getModel().setValue("persontype", (Object)PersonTypeEnum.RESPONSIBLEPERSON.getValue());
        } else if (CollectionUtils.isNotEmpty(cooperatePersonIds) && cooperatePersonIds.contains(userId)) {
            this.getModel().setValue("huibaoperson", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u534f\u529e\u4eba\uff09", (String)"TaskReportEditMobPlugin_14", (String)"pccs-placs-formplugin", (Object[])new Object[0]), name));
            this.getModel().setValue("persontype", (Object)PersonTypeEnum.COOPERATIONPERSON.getValue());
        } else if (null != sharer && StringUtils.equals((CharSequence)userId, (CharSequence)sharer.getString("id"))) {
            this.getModel().setValue("huibaoperson", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u5171\u4eab\u4eba\uff09", (String)"TaskReportEditMobPlugin_15", (String)"pccs-placs-formplugin", (Object[])new Object[0]), name));
            this.getModel().setValue("persontype", (Object)PersonTypeEnum.SHARER.getValue());
        }
    }

    protected void initDataForTaskProgress(DynamicObject task) {
        Integer percent = task.getInt("percent");
        boolean progressEnable = true;
        Slider taskProgressSliderap = (Slider)this.getControl("task_progress_sliderap");
        Object personType = this.getModel().getValue("persontype");
        if (PersonTypeEnum.COOPERATIONPERSON.getValue().equals(personType)) {
            percent = 0;
            progressEnable = false;
        }
        taskProgressSliderap.setSliderValue((Number)0, (Number)percent);
        if (percent == 100 || !progressEnable) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"task_progress_sliderap"});
        }
        this.getModel().setValue("percent", (Object)percent);
        this.setStatusColor("task_progress_sliderap", task);
    }

    protected void setStatusColor(String controlKey, DynamicObject task) {
        String completionStatus = task.getString("completionstatus");
        TaskCompleteStatusMobColorEnum statusMobColorEnum = TaskCompleteStatusMobColorEnum.findByCompleteStatus((String)completionStatus);
        HashMap<String, String> ctrl = new HashMap<String, String>();
        ctrl.put("fc", statusMobColorEnum.getColor());
        ctrl.put("bc", statusMobColorEnum.getColor());
        this.getView().updateControlMetadata(controlKey, ctrl);
    }

    protected void initDataForExpectTime(DynamicObject task) {
        String completionstatus = task.getString("completionstatus");
        CompletionStatusEnum completionStatusEnum = CompletionStatusEnum.getEnumByValue((Object)completionstatus);
        Date expectTime = task.getDate("expecttime");
        if (expectTime == null && CompletionStatusEnum.OVERDUE == completionStatusEnum) {
            expectTime = new Date();
        }
        if (expectTime == null) {
            expectTime = task.getDate("planendtime");
        }
        this.getModel().setValue("completetime", (Object)expectTime);
    }

    protected void initDataForCompletionStatus(DynamicObject task) {
        String completionstatus = task.getString("completionstatus");
        CompletionStatusEnum completionStatusEnum = CompletionStatusEnum.getEnumByValue((Object)completionstatus);
        if (completionStatusEnum == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"completionstatus_label"});
            return;
        }
        Label completionStatusLabel = (Label)this.getControl("completionstatus_label");
        if (completionStatusLabel == null) {
            return;
        }
        completionStatusLabel.setText(completionStatusEnum.getName());
        Image image = (Image)this.getView().getControl("completionstatus_pic");
        image.setUrl(this.getIconUrl(completionStatusEnum));
    }

    protected String getIconUrl(CompletionStatusEnum completionStatusEnum) {
        return TaskIconMobUtil.setStatusImg((String)completionStatusEnum.getValue());
    }

    protected void initDataForTaskName(DynamicObject task) {
        String taskName = task.getString("name");
        if (StringUtil.isEmptyString((String)taskName)) {
            taskName = "";
        }
        Label titleLabel = (Label)this.getView().getControl("title_label");
        titleLabel.setText(taskName);
        Label taskNameLabel = (Label)this.getView().getControl("task_name");
        taskNameLabel.setText(taskName);
        String taskTypeName = task.getString("tasktype.name");
        String taskNumber = task.getString("tasktype.number");
        TaskTypeEnum taskTypeEnum = TaskTypeEnum.getEnumByValue((Object)taskNumber);
        this.getView().setVisible(Boolean.valueOf(TaskTypeEnum.ASSIGNTASK == taskTypeEnum), new String[]{"contentrequirement_panel"});
        TaskTypeMobColorEnum typeMobColorEnum = TaskTypeMobColorEnum.findByValue((String)taskNumber);
        if (StringUtil.isEmptyString((String)taskTypeName) || typeMobColorEnum == null) {
            return;
        }
        Label taskTypeLabel = (Label)this.getView().getControl("tasktype_label");
        taskTypeLabel.setText(taskTypeName);
        HashMap<String, Object> ctrl = new HashMap<String, Object>();
        ctrl.put("fc", typeMobColorEnum.getForeColor());
        ctrl.put("bc", typeMobColorEnum.getBackColor());
        Style style = new Style();
        Border border = new Border();
        border.setBottom("0.5px_solid_" + typeMobColorEnum.getBorderColor());
        border.setRight("0.5px_solid_" + typeMobColorEnum.getBorderColor());
        border.setTop("0.5px_solid_" + typeMobColorEnum.getBorderColor());
        border.setLeft("0.5px_solid_" + typeMobColorEnum.getBorderColor());
        style.setBorder(border);
        ctrl.put("s", style.getStyle());
        this.getView().updateControlMetadata("tasktype_label", ctrl);
    }

    protected void initDataForPlanTime(DynamicObject task) {
        Date planStartTime = task.getDate("planstarttime");
        Date planEndTime = task.getDate("planendtime");
        DateRangeEdit headFieldEdit = (DateRangeEdit)this.getView().getControl("plantime");
        String keyHeadDateStart = headFieldEdit.getStartDateFieldKey();
        String keyHeadDateEnd = headFieldEdit.getEndDateFieldKey();
        if (planStartTime != null) {
            this.getModel().setValue(keyHeadDateStart, (Object)planStartTime);
        }
        if (planEndTime != null) {
            this.getModel().setValue(keyHeadDateEnd, (Object)planEndTime);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void update(SliderEvent sliderEvent) {
        Number[] progressVal = sliderEvent.getValue();
        Number right = progressVal[1];
        this.getModel().setValue("percent", (Object)right.intValue());
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "close_btn": {
                this.closeView();
                break;
            }
            case "back_btn": {
                this.toBackView();
                break;
            }
            case "reporttaskbtn": {
                this.showReportTaskView();
                break;
            }
            case "reportrecordbtn": {
                this.showReportRecordView();
                break;
            }
        }
    }

    protected void showReportTaskView() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"reportrecordbtn", "task_progress_all_panel", "task_attachments_panel", "mtoolbarap"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"reporttaskbtn", "task_report_records_panel", "report_record_panel"});
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"plantime", "completetime"});
    }

    protected void showReportRecordView() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"reporttaskbtn", "task_report_records_panel", "report_record_panel"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"reportrecordbtn", "task_progress_all_panel", "task_attachments_panel", "mtoolbarap"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"plantime", "completetime"});
    }

    protected void loadReportRecord(DynamicObject task) {
        QFilter taskId = new QFilter("task", "=", task.getPkValue());
        DynamicObject relationTask = task.getDynamicObject("relationtask");
        if (relationTask != null) {
            taskId = new QFilter("task", "=", relationTask.getPkValue());
        }
        QFilter[] filters = new QFilter[]{taskId};
        DynamicObject[] taskReportObjs = BusinessDataServiceHelper.load((String)this.getEntityMetaDataTag("taskreport"), (String)(ProgressReportConstant.AllProperty + ",achieveentity.id,achieveentity.attachmentfield,achieveentity.resultname,achieveentity.desc,achieveentity.force,achieveentity.resultid,achieveentity.frequency"), (QFilter[])filters, (String)"modifytime desc");
        List<DynamicObject> reportEntryEntity = Arrays.asList(taskReportObjs);
        if (CollectionUtils.isEmpty(reportEntryEntity)) {
            this.hiddenInitPanel();
            return;
        }
        Container reportRecordContainer = (Container)this.getView().getControl("task_report_records_panel");
        if (reportRecordContainer == null) {
            this.hiddenInitPanel();
            return;
        }
        if (this.isReportListVisiable()) {
            List<Map<String, Object>> controls = this.showReportListView(reportEntryEntity, task);
            reportRecordContainer.addControls(controls);
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"task_report_records_panel"});
        DynamicObject reportRecord = reportEntryEntity.get(0);
        this.showRecentReportView(reportRecord, task);
    }

    protected boolean isReportListVisiable() {
        return false;
    }

    protected List<Map<String, Object>> showReportListView(List<DynamicObject> reportEntryEntity, DynamicObject task) {
        ArrayList<Map<String, Object>> controls = new ArrayList<Map<String, Object>>(reportEntryEntity.size());
        for (int i = 0; i < reportEntryEntity.size(); ++i) {
            DynamicObject reportRecord = reportEntryEntity.get(i);
            FlexPanelAp rowPanelAp = new FlexPanelAp();
            rowPanelAp.setKey("record_row_" + i);
            rowPanelAp.setWidth(new LocaleString("100%"));
            rowPanelAp.setTextAlign("center");
            rowPanelAp.setAlignContent("center");
            rowPanelAp.setAutoTextWrap(true);
            rowPanelAp.setWrap(true);
            FlexPanelAp leftPanelAp = new FlexPanelAp();
            leftPanelAp.setKey("left_panel_" + i);
            leftPanelAp.setWidth(new LocaleString("20%"));
            Style rightRowStyle = new Style();
            Padding rightRowPadding = new Padding();
            rightRowPadding.setLeft("12px");
            rightRowPadding.setRight("12px");
            rightRowPadding.setTop("8px");
            rightRowPadding.setBottom("8px");
            rightRowStyle.setPadding(rightRowPadding);
            FlexPanelAp leftRowPanel = new FlexPanelAp();
            leftRowPanel.setKey("left_row_" + i);
            leftRowPanel.setHeight(new LocaleString("40px"));
            leftRowPanel.setAlignSelf("center");
            leftRowPanel.setTextAlign("center");
            leftRowPanel.setAlignItems("center");
            leftRowPanel.setAlignContent("center");
            leftRowPanel.setStyle(rightRowStyle);
            LabelAp dateLabel = new LabelAp();
            dateLabel.setKey("date_" + i);
            Date createTime = reportRecord.getDate("createtime");
            dateLabel.setName(new LocaleString(TaskReportDateMobUtil.toShowName((Date)createTime)));
            dateLabel.setFontSize(14);
            dateLabel.setAutoTextWrap(true);
            leftRowPanel.getItems().add(dateLabel);
            leftPanelAp.getItems().add(leftRowPanel);
            FlexPanelAp rightPanelAp = new FlexPanelAp();
            rightPanelAp.setKey("right_panel_" + i);
            rightPanelAp.setWidth(new LocaleString("80%"));
            FlexPanelAp rightRowPanel = new FlexPanelAp();
            rightRowPanel.setKey("right_row_" + i);
            rightRowPanel.setWidth(new LocaleString("100%"));
            rightRowPanel.setHeight(new LocaleString("40px"));
            rightRowPanel.setTextAlign("center");
            rightRowPanel.setAlignSelf("center");
            rightRowPanel.setAlignItems("center");
            rightRowPanel.setStyle(rightRowStyle);
            LabelAp progressNameLabel = new LabelAp();
            progressNameLabel.setKey("progressNameLabel_" + i);
            progressNameLabel.setName(new LocaleString(ResManager.loadKDString((String)"\u9879\u76ee\u8fdb\u5ea6\uff1a", (String)"TaskReportEditMobPlugin_3", (String)"pccs-placs-formplugin", (Object[])new Object[0])));
            progressNameLabel.setFontSize(14);
            LabelAp progressValLabel = new LabelAp();
            progressValLabel.setKey("progressValLabel_" + i);
            Integer percent = reportRecord.getInt("percent");
            progressValLabel.setName(new LocaleString("" + percent + "%"));
            String completionStatus = task.getString("completionstatus");
            TaskCompleteStatusMobColorEnum statusMobColorEnum = TaskCompleteStatusMobColorEnum.findByCompleteStatus((String)completionStatus);
            progressValLabel.setForeColor(statusMobColorEnum.getColor());
            rightRowPanel.getItems().add(progressNameLabel);
            rightRowPanel.getItems().add(progressValLabel);
            FlexPanelAp reportDescPanel = new FlexPanelAp();
            reportDescPanel.setKey("reportDescPanel_" + i);
            reportDescPanel.setWidth(new LocaleString("100%"));
            reportDescPanel.setFontSize(14);
            reportDescPanel.setStyle(rightRowStyle);
            LabelAp reportDescLabel = new LabelAp();
            reportDescLabel.setKey("reportDescLabel_" + i);
            String reportDesc = reportRecord.getString("reportdesc");
            reportDescLabel.setName(new LocaleString(reportDesc));
            reportDescLabel.setFontSize(14);
            reportDescPanel.getItems().add(reportDescLabel);
            FlexPanelAp imageListPanel = new FlexPanelAp();
            imageListPanel.setKey("imageListPanel_" + i);
            imageListPanel.setWidth(new LocaleString("100%"));
            FlexPanelAp videoPanel = new FlexPanelAp();
            videoPanel.setKey("videoPanel_" + i);
            videoPanel.setWidth(new LocaleString("100%"));
            FlexPanelAp attachePanel = new FlexPanelAp();
            attachePanel.setKey("attachePanel_" + i);
            attachePanel.setWidth(new LocaleString("100%"));
            rightPanelAp.getItems().add(rightRowPanel);
            rightPanelAp.getItems().add(reportDescPanel);
            rightPanelAp.getItems().add(imageListPanel);
            rightPanelAp.getItems().add(videoPanel);
            rightPanelAp.getItems().add(attachePanel);
            rowPanelAp.getItems().add(leftPanelAp);
            rowPanelAp.getItems().add(rightPanelAp);
            controls.add(rowPanelAp.createControl());
        }
        return controls;
    }

    protected void showRecentReportView(DynamicObject reportRecord, DynamicObject task) {
        Date createTime = reportRecord.getDate("createtime");
        Label timeValLabel = (Label)this.getView().getControl("time_text_val_lab");
        if (timeValLabel != null) {
            timeValLabel.setText(TaskReportDateMobUtil.toShowName((Date)createTime));
        }
        Label progressTextVal = (Label)this.getView().getControl("progress_text_val");
        Integer percent = reportRecord.getInt("percent");
        progressTextVal.setText("" + percent + "%");
        String completionStatus = task.getString("completionstatus");
        TaskCompleteStatusMobColorEnum statusMobColorEnum = TaskCompleteStatusMobColorEnum.findByCompleteStatus((String)completionStatus);
        HashMap<String, String> ctrl = new HashMap<String, String>();
        ctrl.put("fc", statusMobColorEnum.getColor());
        this.getView().updateControlMetadata("progress_text_val", ctrl);
        String reportDesc = reportRecord.getString("reportdesc");
        this.getModel().setValue("report_desc_show", (Object)reportDesc);
        if (this.isAchievementNode(task)) {
            this.loadAchievesAttachment(reportRecord);
        } else {
            this.loadAttachment(reportRecord);
        }
    }

    protected void hiddenInitPanel() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"report_record_row_panel"});
    }

    protected void loadAchievesAttachment(DynamicObject reportRecord) {
        DynamicObjectCollection achieveEntity = reportRecord.getDynamicObjectCollection("achieveentity");
        if (achieveEntity == null) {
            this.hiddenInitPanel();
            return;
        }
        List<DynamicObjectCollection> allAttachments = achieveEntity.stream().map(achieve -> achieve.getDynamicObjectCollection("attachmentfield")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(allAttachments)) {
            this.hiddenInitPanel();
            return;
        }
        this.showAttachments(allAttachments);
    }

    protected void loadAttachment(DynamicObject reportRecord) {
        QFilter[] filters = new QFilter[]{new QFilter("FInterID", "=", (Object)reportRecord.getPkValue().toString()), new QFilter("FBillType", "=", (Object)reportRecord.getDataEntityType().getName()), new QFilter("fattachmentpanel", "=", (Object)"attachmentpanel")};
        DynamicObject[] bosAttachments = BusinessDataServiceHelper.load((String)"bos_attachment", (String)"fattachmentname,fattachmentsize,fbilltype,fnumber,ffileid,fmodifytime,fextname", (QFilter[])filters);
        List attachments = Arrays.asList(bosAttachments).stream().map(bosAttachment -> AttachmentUtil.convertToBDAttachment((DynamicObject)bosAttachment)).collect(Collectors.toList());
        AttachmentClassification attachmentClassification = TaskReportAttachMobUtil.classifyAttachments(attachments);
        this.showAttachments(attachmentClassification);
    }

    protected void showAttachments(List<DynamicObjectCollection> allAttachments) {
        AttachmentClassification attachmentClassification = TaskReportAttachMobUtil.classify(allAttachments);
        this.showAttachments(attachmentClassification);
    }

    protected void showAttachments(AttachmentClassification attachmentClassification) {
        ArrayList imageUrls = new ArrayList(attachmentClassification.getImageUrls());
        IFormView view = this.getView();
        if (CollectionUtils.isNotEmpty(imageUrls)) {
            int i;
            for (i = 0; i < imageUrls.size(); ++i) {
                AttachInfo attachInfo = (AttachInfo)imageUrls.get(i);
                view.setVisible(Boolean.valueOf(true), new String[]{"pictureview" + i});
                this.getModel().setValue("pictureview" + i, (Object)attachInfo.getUrl());
            }
            for (i = imageUrls.size(); i < 9; ++i) {
                view.setVisible(Boolean.valueOf(false), new String[]{"pictureview" + i});
            }
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{"imagepanel"});
        }
        if (CollectionUtils.isNotEmpty((Collection)attachmentClassification.getVideoUrls())) {
            AttachInfo videoAttach = (AttachInfo)attachmentClassification.getVideoUrls().get(0);
            Video video = (Video)this.getView().getControl("videodoc");
            video.setSrc(videoAttach.getUrl());
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"video_panel"});
        }
        if (CollectionUtils.isNotEmpty((Collection)attachmentClassification.getOtherUrls())) {
            List otherUrls = attachmentClassification.getOtherUrls();
            Container attachContainer = (Container)this.getView().getControl("other_attach_all_panel");
            ArrayList<Map> controls = new ArrayList<Map>(otherUrls.size());
            for (int i = 0; i < otherUrls.size(); ++i) {
                FlexPanelAp flexPanelAp = new FlexPanelAp();
                flexPanelAp.setKey("other_attach_panel" + i);
                flexPanelAp.setWidth(new LocaleString("100%"));
                Style style = new Style();
                Padding padding = new Padding();
                padding.setBottom("2px");
                padding.setTop("2px");
                padding.setLeft("4px");
                style.setPadding(padding);
                flexPanelAp.setStyle(style);
                flexPanelAp.setAlignSelf("flex-start");
                flexPanelAp.setAlignItems("center");
                flexPanelAp.setAlignContent("center");
                flexPanelAp.setOverflow("");
                VectorAp vectorAp = new VectorAp();
                vectorAp.setKey("icon_link");
                vectorAp.setForeColor("#55A0F5");
                vectorAp.setfontClass("kdfont kdfont-youfujian");
                flexPanelAp.getItems().add(vectorAp);
                Style linkStyle = new Style();
                Margin linkMargin = new Margin();
                linkMargin.setLeft("2px");
                linkStyle.setMargin(linkMargin);
                AttachInfo attachInfo = (AttachInfo)otherUrls.get(i);
                HyperlinkAp hyperlinkAp = new HyperlinkAp();
                hyperlinkAp.setLinkUrl(attachInfo.getUrl());
                hyperlinkAp.setKey("attachlink" + i);
                hyperlinkAp.setName(new LocaleString(attachInfo.getName()));
                hyperlinkAp.setForeColor("#55A0F5");
                hyperlinkAp.setFontSize(12);
                hyperlinkAp.setStyle(style);
                hyperlinkAp.setAutoTextWrap(true);
                hyperlinkAp.setWidth(new LocaleString("90%"));
                flexPanelAp.getItems().add(hyperlinkAp);
                controls.add(flexPanelAp.createControl());
            }
            attachContainer.addControls(controls);
        }
    }

    protected void closeView() {
        this.getView().close();
    }

    protected void toBackView() {
        this.getView().close();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"doreport")) {
            Integer entryNum;
            String reportdesc;
            Date completeTime;
            String curPerson = (String)this.getModel().getValue("huibaoperson");
            if (StringUtils.isEmpty((CharSequence)curPerson)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u4efb\u52a1\u7684\u8d23\u4efb\u4eba\u3001\u534f\u529e\u4eba\u548c\u5171\u4eab\u4eba\uff0c\u624d\u80fd\u6c47\u62a5\u8be5\u4efb\u52a1\u3002", (String)"TaskReportEditMobPlugin_23", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if ((completeTime = (Date)this.getModel().getValue("completetime")) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b8c\u6210\u65f6\u95f4\u3002", (String)"TaskReportEditMobPlugin_17", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            Object personType = this.getModel().getValue("persontype");
            if (!PersonTypeEnum.COOPERATIONPERSON.getValue().equals(personType)) {
                Integer percent = (Integer)this.getModel().getValue("percent");
                if (percent == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u4efb\u52a1\u8fdb\u5ea6\u3002", (String)"TaskReportEditMobPlugin_18", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                } else if (percent <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u62a5\u8fdb\u5ea6\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"TaskReportEditMobPlugin_19", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
            if (StringUtil.isEmptyString((String)(reportdesc = (String)this.getModel().getValue("reportdesc")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b8c\u6210\u60c5\u51b5\u8bf4\u660e\u3002", (String)"TaskReportEditMobPlugin_20", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if ((entryNum = (Integer)this.getModel().getValue("docentrynum")) > 0) {
                DynamicObjectCollection achieveEntryEntity = this.getModel().getEntryEntity("achieveentity");
                for (int i = 0; i < achieveEntryEntity.size(); ++i) {
                    DynamicObject achieveEntity = (DynamicObject)achieveEntryEntity.get(i);
                    String resultName = achieveEntity.getString("resultname");
                    DynamicObjectCollection attachmentField = achieveEntity.getDynamicObjectCollection("attachmentfield");
                    if (attachmentField.size() != 0) continue;
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u201c%s\u201d\u7684\u6210\u679c\u6587\u6863\u3002", (String)"TaskReportEditMobPlugin_24", (String)"pccs-placs-formplugin", (Object[])new Object[0]), resultName));
                    args.setCancel(true);
                    break;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"doreport") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6c47\u62a5\u6210\u529f\u3002", (String)"TaskReportEditMobPlugin_22", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6c47\u62a5\u6210\u529f\u3002", (String)"TaskReportEditMobPlugin_22", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
            HashMap<String, Boolean> pData = new HashMap<String, Boolean>();
            pData.put("reportRefresh", true);
            this.getView().returnDataToParent(pData);
            this.getView().close();
        }
    }
}

