/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin.mobile;

import com.kingdee.bos.qing.data.util.DateUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.pccs.placs.common.enums.TaskTypeEnum;

public class TaskScreenFormPlugin
extends AbstractMobFormPlugin
implements ClickListener {
    private static final Log LOG = LogFactory.getLog(TaskScreenFormPlugin.class);
    private static final String timePatten = "--";
    private static Map<String, String> selectedType = new HashMap<String, String>();

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button confirmBtn = (Button)this.getView().getControl("sc_confirm_btn");
        confirmBtn.addClickListener((ClickListener)this);
        Button resetBtn = (Button)this.getView().getControl("reset_btn");
        resetBtn.addClickListener((ClickListener)this);
        Container dateselect = (Container)this.getView().getControl("dateselect");
        dateselect.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String time = this.getView().getParentView().getPageCache().get("selectedTime");
        String type = this.getView().getParentView().getPageCache().get("selectedType");
        String startTime = this.getView().getParentView().getPageCache().get("startTime");
        String endTime = this.getView().getParentView().getPageCache().get("endTime");
        if (time != null) {
            this.getModel().setValue("timeradiogroup", (Object)time);
        }
        if (type != null) {
            selectedType = this.stringToMap(type.split(","));
            this.showTypes(type);
        } else {
            selectedType.put("all", "all");
            this.getModel().setValue("cb_all", (Object)true);
        }
        if (startTime != null) {
            try {
                this.getModel().setValue("start_time", (Object)DateUtils.stringToDate((String)startTime, (String)"yyyy/MM/dd"));
                this.getModel().setValue("end_time", (Object)DateUtils.stringToDate((String)endTime, (String)"yyyy/MM/dd"));
                FieldEdit rangeRadio = (FieldEdit)this.getView().getControl("range_radio");
                String value = startTime + timePatten + endTime;
                rangeRadio.setCaption(new LocaleString(value));
            }
            catch (ParseException exception) {
                LOG.error((Throwable)exception);
                throw new KDBizException(exception.toString());
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "sc_confirm_btn": {
                this.screenConfirmBtn();
                break;
            }
            case "dateselect": {
                DateRangeEdit rangeBtn = (DateRangeEdit)this.getView().getControl("daterangebtn");
                rangeBtn.focus();
                break;
            }
            case "reset_btn": {
                selectedType = new HashMap<String, String>();
                selectedType.put("all", "all");
                this.getModel().setValue("cb_all", (Object)true);
                this.getModel().setValue("timeradiogroup", (Object)"all");
                this.getView().updateView();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "end_time": {
                this.endTimeChanged();
                break;
            }
            case "cb_all": {
                if (((Boolean)this.getModel().getValue("cb_all")).booleanValue()) {
                    selectedType = new HashMap<String, String>();
                    selectedType.put("all", "all");
                    this.getModel().setValue("cb_keynode", (Object)false);
                    this.getModel().setValue("cb_important", (Object)false);
                    this.getModel().setValue("cb_normal", (Object)false);
                    this.getModel().setValue("cb_route", (Object)false);
                    this.getModel().setValue("cb_assign", (Object)false);
                    this.getView().updateView("flexpanelap21");
                    break;
                }
                selectedType.remove("all");
                break;
            }
            case "cb_keynode": {
                if (((Boolean)this.getModel().getValue("cb_keynode")).booleanValue()) {
                    selectedType.put("KEYNODE_S", "KEYNODE_S");
                    this.updateBtnAll();
                    break;
                }
                selectedType.remove("KEYNODE_S");
                break;
            }
            case "cb_important": {
                if (((Boolean)this.getModel().getValue("cb_important")).booleanValue()) {
                    selectedType.put("IMPORTANTNODE_S", "IMPORTANTNODE_S");
                    this.updateBtnAll();
                    break;
                }
                selectedType.remove("IMPORTANTNODE_S");
                break;
            }
            case "cb_normal": {
                if (((Boolean)this.getModel().getValue("cb_normal")).booleanValue()) {
                    selectedType.put("GENERALNODE_S", "GENERALNODE_S");
                    this.updateBtnAll();
                    break;
                }
                selectedType.remove("GENERALNODE_S");
                break;
            }
            case "cb_route": {
                if (((Boolean)this.getModel().getValue("cb_route")).booleanValue()) {
                    selectedType.put("ROUTINEWORK_S", "ROUTINEWORK_S");
                    this.updateBtnAll();
                    break;
                }
                selectedType.remove("ROUTINEWORK_S");
                break;
            }
            case "cb_assign": {
                if (((Boolean)this.getModel().getValue("cb_assign")).booleanValue()) {
                    selectedType.put("ASSIGNTASK_S", "ASSIGNTASK_S");
                    this.updateBtnAll();
                    break;
                }
                selectedType.remove("ASSIGNTASK_S");
                break;
            }
        }
    }

    private void updateBtnAll() {
        selectedType.remove("all");
        this.getModel().setValue("cb_all", (Object)false);
        this.getView().updateView("flexpanelap21");
    }

    protected void screenConfirmBtn() {
        String selectedTime = (String)this.getModel().getValue("timeradiogroup");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("selectedTime", selectedTime);
        data.put("selectedType", this.mapToString(selectedType));
        if ("range".equals(selectedTime)) {
            DateRangeEdit rangeBtn = (DateRangeEdit)this.getView().getControl("daterangebtn");
            Date headdatestart = (Date)this.getModel().getValue(rangeBtn.getStartDateFieldKey());
            Date headdateend = (Date)this.getModel().getValue(rangeBtn.getEndDateFieldKey());
            if (headdatestart == null || headdateend == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u65e5\u671f\u4e0d\u80fd\u9009\u62e9\u7a7a\u7684\u65e5\u671f\u3002", (String)"TaskScreenFormPlugin_2", (String)"pccs-placs-formplugin", (Object[])new Object[0]));
                return;
            }
            data.put("startTime", headdatestart);
            data.put("endTime", headdateend);
        }
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    private void endTimeChanged() {
        DateRangeEdit rangeBtn = (DateRangeEdit)this.getView().getControl("daterangebtn");
        Date headdatestart = (Date)this.getModel().getValue(rangeBtn.getStartDateFieldKey());
        Date headdateend = (Date)this.getModel().getValue(rangeBtn.getEndDateFieldKey());
        FieldEdit rangeRadio = (FieldEdit)this.getView().getControl("range_radio");
        if (headdatestart != null && headdateend != null) {
            String value = DateUtils.DateToString((Date)headdatestart, (String)"yyyy/MM/dd") + timePatten + DateUtils.DateToString((Date)headdateend, (String)"yyyy/MM/dd");
            rangeRadio.setCaption(new LocaleString(value));
        } else {
            rangeRadio.setCaption(new LocaleString(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u65e5\u671f", (String)"TaskScreenFormPlugin_1", (String)"pccs-placs-formplugin", (Object[])new Object[0])));
        }
        this.getModel().setValue("timeradiogroup", (Object)"range");
    }

    protected String mapToString(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String value : map.values()) {
            stringBuilder.append(value).append(",");
        }
        return stringBuilder.toString();
    }

    protected Map<String, String> stringToMap(String[] strings) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (String value : strings) {
            map.put(value, value);
        }
        return map;
    }

    protected void showTypes(String type) {
        if (type.contains("all")) {
            this.getModel().setValue("cb_all", (Object)true);
            return;
        }
        if (type.contains(TaskTypeEnum.KEYNODE.getValue())) {
            this.getModel().setValue("cb_keynode", (Object)true);
        }
        if (type.contains(TaskTypeEnum.IMPORTANTNODE.getValue())) {
            this.getModel().setValue("cb_important", (Object)true);
        }
        if (type.contains(TaskTypeEnum.GENERALNODE.getValue())) {
            this.getModel().setValue("cb_normal", (Object)true);
        }
        if (type.contains(TaskTypeEnum.ROUTINEWORK.getValue())) {
            this.getModel().setValue("cb_route", (Object)true);
        }
        if (type.contains(TaskTypeEnum.ASSIGNTASK.getValue())) {
            this.getModel().setValue("cb_assign", (Object)true);
        }
    }
}

