/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin.warn;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.service.earlywarn.impl.DefaultEarlyWarnBillDataSource;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.pccs.placs.business.model.TaskConstant;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.PlanEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;

public class TaskWarnCustomDataSource
extends DefaultEarlyWarnBillDataSource {
    public List<QFilter> buildFilter(String dataSource, FilterCondition filterCondition, EarlyWarnContext context) {
        List filters = super.buildFilter(dataSource, filterCondition, context);
        Map customConditionMap = context.getCustomConditionDataMap();
        Map warnSet = (Map)customConditionMap.get("warnset");
        Set taskTypes = warnSet.keySet();
        Set taskTypeIds = taskTypes.stream().map(Long::valueOf).collect(Collectors.toSet());
        QFilter filter = new QFilter("tasktype", "in", taskTypeIds);
        filter.and(new QFilter("islatest", "=", (Object)true));
        filter.and(new QFilter("relationtask", "=", (Object)0));
        filter.and(new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue()));
        ArrayList<String> compStatus = new ArrayList<String>();
        compStatus.add(CompletionStatusEnum.ONTIMECOMPLETE.getValue());
        compStatus.add(CompletionStatusEnum.OVERDUECOMPLETE.getValue());
        filter.and(new QFilter("completionstatus", "not in", compStatus));
        this.addFilterByWarnScpoe(customConditionMap, filter);
        this.addFilterByUnStart(warnSet, filter);
        this.addFilterByOver(warnSet, filter);
        this.addFilterByProgressing(warnSet, filter);
        filters.add(filter);
        return filters;
    }

    protected void addFilterByUnStart(Map<String, Map<String, JSONObject>> warnSet, QFilter filter) {
        DynamicObject[] taskUnstarts;
        ArrayList<Object> taskIds = new ArrayList<Object>();
        Date today = DateUtil.getStartDayTime((Date)new Date());
        QFilter unstart = new QFilter("planstarttime", ">", (Object)today);
        for (DynamicObject task : taskUnstarts = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)TaskConstant.AllProperty, (QFilter[])new QFilter[]{filter, unstart})) {
            Date planStartTime = task.getDate("planstarttime");
            DynamicObject tasktype = task.getDynamicObject("tasktype");
            if (tasktype == null) continue;
            Map<String, JSONObject> typeSet = warnSet.get(tasktype.getString("id"));
            Map setInfo = (Map)typeSet.get("1");
            int startday = (Integer)setInfo.get("startday");
            int endday = (Integer)setInfo.get("endday");
            int daysBetween = DateUtil.getDaysBetweenTwoDate((Date)today, (Date)planStartTime);
            if (daysBetween <= startday && daysBetween >= endday) continue;
            taskIds.add(task.getPkValue());
        }
        if (taskIds.size() > 0) {
            filter.and(new QFilter("id", "not in", taskIds));
        }
    }

    protected void addFilterByOver(Map<String, Map<String, JSONObject>> warnSet, QFilter filter) {
        DynamicObject[] taskOvers;
        ArrayList<Object> taskIds = new ArrayList<Object>();
        Date today = DateUtil.getStartDayTime((Date)new Date());
        QFilter over = new QFilter("planendtime", "<", (Object)today);
        for (DynamicObject task : taskOvers = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)TaskConstant.AllProperty, (QFilter[])new QFilter[]{filter, over})) {
            Date planEndTime = task.getDate("planendtime");
            DynamicObject tasktype = task.getDynamicObject("tasktype");
            if (tasktype == null) continue;
            Map<String, JSONObject> typeSet = warnSet.get(tasktype.getString("id"));
            Map setInfo = (Map)typeSet.get("4");
            int startday = (Integer)setInfo.get("startday");
            int daysBetween = DateUtil.getDaysBetweenTwoDate((Date)planEndTime, (Date)today);
            if (daysBetween >= startday) continue;
            taskIds.add(task.getPkValue());
        }
        if (taskIds.size() > 0) {
            filter.and(new QFilter("id", "not in", taskIds));
        }
    }

    protected void addFilterByProgressing(Map<String, Map<String, JSONObject>> warnSet, QFilter filter) {
        DynamicObject[] tasks;
        ArrayList<Object> taskIds = new ArrayList<Object>();
        Date today = DateUtil.getStartDayTime((Date)new Date());
        QFilter startFil = new QFilter("planstarttime", "<=", (Object)today);
        QFilter endFil = new QFilter("planendtime", ">=", (Object)today);
        for (DynamicObject task : tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)TaskConstant.AllProperty, (QFilter[])new QFilter[]{filter, startFil, endFil})) {
            Date planStartTime = task.getDate("planstarttime");
            Date planEndTime = task.getDate("planendtime");
            int taskDays = DateUtil.getDaysBetweenTwoDate((Date)planStartTime, (Date)planEndTime);
            DynamicObject tasktype = task.getDynamicObject("tasktype");
            if (tasktype == null) continue;
            Map<String, JSONObject> typeSet = warnSet.get(tasktype.getString("id"));
            Map setInfo = (Map)typeSet.get("3");
            int startday = (Integer)setInfo.get("startday");
            int endday = (Integer)setInfo.get("endday");
            int daysBetweenEnd = DateUtil.getDaysBetweenTwoDate((Date)today, (Date)planEndTime);
            if (daysBetweenEnd <= startday && daysBetweenEnd >= endday) continue;
            Map setInfoMid = (Map)typeSet.get("2");
            int startdayMid = (Integer)setInfoMid.get("startday");
            int enddayMid = (Integer)setInfoMid.get("endday");
            int midDay = taskDays / 2;
            int daysBetweenStart = DateUtil.getDaysBetweenTwoDate((Date)planStartTime, (Date)today);
            if (daysBetweenStart >= midDay - startdayMid && daysBetweenStart <= midDay - enddayMid) continue;
            taskIds.add(task.getPkValue());
        }
        if (taskIds.size() > 0) {
            filter.and(new QFilter("id", "not in", taskIds));
        }
    }

    protected void addFilterByWarnScpoe(Map<String, Object> customConditionMap, QFilter filter) {
        String warnscope = (String)customConditionMap.get("warnscope");
        Boolean includechild = (Boolean)customConditionMap.get("includechild");
        if (StringUtils.equals((CharSequence)"1", (CharSequence)warnscope)) {
            DynamicObject[] assignTask;
            DynamicObject[] personplans;
            DynamicObject[] deptplans;
            DynamicObject[] masterplans;
            HashSet<Object> taskIds = new HashSet<Object>(16);
            List orgs = (List)customConditionMap.get("org");
            if (includechild.booleanValue()) {
                orgs = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.parseLong("15"), (List)orgs, (boolean)true);
            }
            QFilter filter1 = new QFilter("org", "in", (Object)orgs);
            QFilter filter2 = new QFilter("billstatus", "=", (Object)"C");
            QFilter filter3 = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
            for (DynamicObject plan : masterplans = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)"taskentity, taskentity.islatest", (QFilter[])new QFilter[]{filter1, filter2, filter3})) {
                DynamicObjectCollection taskentity = plan.getDynamicObjectCollection("taskentity");
                for (Object task : taskentity) {
                    if (!task.getBoolean("islatest")) continue;
                    taskIds.add(task.getPkValue());
                }
            }
            for (DynamicObject plan : deptplans = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"deptplan"), (String)"taskentity, taskentity.islatest", (QFilter[])new QFilter[]{filter1, filter2, filter3})) {
                DynamicObjectCollection taskentity = plan.getDynamicObjectCollection("taskentity");
                for (DynamicObject task : taskentity) {
                    if (!task.getBoolean("islatest")) continue;
                    taskIds.add(task.getPkValue());
                }
            }
            for (DynamicObject plan : personplans = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"personplan"), (String)"entryentity, entryentity.islatest", (QFilter[])new QFilter[]{filter1, filter2})) {
                DynamicObjectCollection taskentity = plan.getDynamicObjectCollection("entryentity");
                for (DynamicObject task : taskentity) {
                    if (!task.getBoolean("islatest")) continue;
                    taskIds.add(task.getPkValue());
                }
            }
            QFilter orgfilter = new QFilter("creatororg", "in", (Object)orgs);
            QFilter lastfilter = new QFilter("islatest", "=", (Object)true);
            for (DynamicObject task : assignTask = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"assigntask"), (String)"creatororg,islatest", (QFilter[])new QFilter[]{orgfilter, filter2, lastfilter})) {
                taskIds.add(task.getPkValue());
            }
            if (taskIds.size() > 0) {
                filter.and(new QFilter("id", "in", taskIds));
            } else {
                filter.and(new QFilter("id", "=", (Object)0L));
            }
        } else if (StringUtils.equals((CharSequence)"2", (CharSequence)warnscope)) {
            List projects = (List)customConditionMap.get("project");
            filter.and(new QFilter("project", "in", (Object)projects));
        }
    }

    protected String getAppId() {
        return "placs";
    }
}

