/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin.warn;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnCustomReceiver;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;

public class TaskWarnCustomReceiver
implements IEarlyWarnCustomReceiver {
    public List<Long> getReceiverIds(EarlyWarnContext context, DynamicObject[] dynamicObjects) {
        Map customConditionMap = context.getCustomConditionDataMap();
        HashSet<Long> setIds = new HashSet<Long>();
        Map warnSet = (Map)customConditionMap.get("warnset");
        if (dynamicObjects.length > 0) {
            this.setReceivers(dynamicObjects[0], setIds, warnSet);
        }
        ArrayList<Long> receiverIds = new ArrayList<Long>();
        receiverIds.addAll(setIds);
        return receiverIds;
    }

    protected void setReceivers(DynamicObject dynamicObject, Set<Long> setIds, Map<String, Map<String, JSONObject>> warnSet) {
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
        DynamicObject tasktype = task.getDynamicObject("tasktype");
        Date planStartTime = task.getDate("planstarttime");
        Date planEndTime = task.getDate("planendtime");
        Date today = DateUtil.getStartDayTime((Date)new Date());
        if (tasktype != null) {
            Map setInfo;
            Map<String, JSONObject> typeSet = warnSet.get(tasktype.getString("id"));
            Boolean responsibleperson = false;
            Boolean cooperationperson = false;
            List appointor = new ArrayList();
            if (DateUtil.compareByDay((Date)today, (Date)planStartTime) < 0) {
                setInfo = (Map)typeSet.get("1");
                responsibleperson = (Boolean)setInfo.get("responsibleperson");
                cooperationperson = (Boolean)setInfo.get("cooperationperson");
                appointor = (List)setInfo.get("appointor");
            } else if (DateUtil.compareByDay((Date)today, (Date)planStartTime) >= 0 && DateUtil.compareByDay((Date)today, (Date)planEndTime) <= 0) {
                Map setInfoMid = (Map)typeSet.get("2");
                Map setInfoComp = (Map)typeSet.get("3");
                int startday = (Integer)setInfoComp.get("startday");
                int endday = (Integer)setInfoComp.get("endday");
                int daysBetweenEnd = DateUtil.getDaysBetweenTwoDate((Date)today, (Date)planEndTime);
                if (daysBetweenEnd <= startday && daysBetweenEnd >= endday) {
                    responsibleperson = (Boolean)setInfoComp.get("responsibleperson");
                    cooperationperson = (Boolean)setInfoComp.get("cooperationperson");
                    appointor = (List)setInfoComp.get("appointor");
                } else {
                    responsibleperson = (Boolean)setInfoMid.get("responsibleperson");
                    cooperationperson = (Boolean)setInfoMid.get("cooperationperson");
                    appointor = (List)setInfoMid.get("appointor");
                }
            } else if (DateUtil.compareByDay((Date)today, (Date)planEndTime) > 0) {
                setInfo = (Map)typeSet.get("4");
                responsibleperson = (Boolean)setInfo.get("responsibleperson");
                cooperationperson = (Boolean)setInfo.get("cooperationperson");
                appointor = (List)setInfo.get("appointor");
            }
            if (responsibleperson.booleanValue()) {
                DynamicObject responsible = task.getDynamicObject("responsibleperson");
                setIds.add((Long)responsible.getPkValue());
            }
            if (cooperationperson.booleanValue()) {
                DynamicObjectCollection multicooperationperson = task.getDynamicObjectCollection("multicooperationperson");
                for (DynamicObject person : multicooperationperson) {
                    setIds.add((Long)person.get("fbasedataid_id"));
                }
            }
            if (appointor.size() > 0) {
                for (Map adminorg : appointor) {
                    if (adminorg.get("fbasedataid") == null) continue;
                    Map basedata = (Map)adminorg.get("fbasedataid");
                    setIds.add((Long)basedata.get("id"));
                }
            }
        }
    }

    protected String getAppId() {
        return "placs";
    }
}

