/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.formplugin.warn;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.kit.StringTemplateParser;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnMessageCompiler;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;

public class TaskWarnMessageCompiler
implements IEarlyWarnMessageCompiler {
    public String getSingleMessage(String expression, List<String> fields, DynamicObject data, EarlyWarnContext context) {
        if (null == expression || null == data) {
            return "";
        }
        HashMap<String, String> macroMap = new HashMap<String, String>(16);
        Map customConditionMap = context.getCustomConditionDataMap();
        Map warnSet = (Map)customConditionMap.get("warnset");
        String message = this.getMessage(data, warnSet);
        boolean setMessage = false;
        for (String field : fields) {
            String value = "";
            if ("message".equals(field)) {
                value = message;
                setMessage = true;
            } else {
                String[] arr = StringUtil.split((String)field, (String)".");
                String objValue = this.getValue(data, arr);
                value = objValue == null ? "" : objValue.toString();
            }
            macroMap.put(field, value);
        }
        StringTemplateParser parser = new StringTemplateParser();
        String parse = parser.parse(expression, macroName -> (String)macroMap.get(macroName));
        if (setMessage) {
            return parse;
        }
        return parse + message;
    }

    protected String getMessage(DynamicObject data, Map<String, Map<String, JSONObject>> warnSet) {
        String message = "";
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)data.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
        DynamicObject tasktype = task.getDynamicObject("tasktype");
        Date planStartTime = task.getDate("planstarttime");
        Date planEndTime = task.getDate("planendtime");
        Date today = DateUtil.getStartDayTime((Date)new Date());
        if (tasktype != null) {
            Map<String, JSONObject> typeSet = warnSet.get(tasktype.getString("id"));
            if (DateUtil.compareByDay((Date)today, (Date)planStartTime) < 0) {
                Map setInfo = (Map)typeSet.get("1");
                message = (String)setInfo.get("warnmsg");
            } else if (DateUtil.compareByDay((Date)today, (Date)planStartTime) >= 0 && DateUtil.compareByDay((Date)today, (Date)planEndTime) <= 0) {
                Map setInfoMid = (Map)typeSet.get("2");
                Map setInfoComp = (Map)typeSet.get("3");
                int startday = (Integer)setInfoComp.get("startday");
                int endday = (Integer)setInfoComp.get("endday");
                int daysBetweenEnd = DateUtil.getDaysBetweenTwoDate((Date)today, (Date)planEndTime);
                message = daysBetweenEnd <= startday && daysBetweenEnd >= endday ? (String)setInfoComp.get("warnmsg") : (String)setInfoMid.get("warnmsg");
            } else if (DateUtil.compareByDay((Date)today, (Date)planEndTime) > 0) {
                Map setInfo = (Map)typeSet.get("4");
                message = (String)setInfo.get("warnmsg");
            }
        }
        return message;
    }

    protected String getValue(DynamicObject data, String[] arr) {
        if (null == arr || arr.length == 0) {
            return "";
        }
        Object obj = data.get(arr[0]);
        if (obj instanceof DynamicObject) {
            return this.getValue((DynamicObject)obj, Arrays.copyOfRange(arr, 1, arr.length));
        }
        return StringUtil.toSafeString((Object)obj);
    }

    public String getMergeMessage(String s, List<String> list, EarlyWarnContext earlyWarnContext) {
        return s;
    }

    protected String getAppId() {
        return "placs";
    }
}

