/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.business.callback;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.business.base.AbstractPlacsBillAdapter;
import kd.pccs.placs.business.callback.CallBack;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import org.apache.commons.collections4.CollectionUtils;

public class MasterPlanImpProTaskCallback
implements CallBack {
    private IDataModel dataModel;
    private IFormView formView;
    private String appId;
    private static final String ID_PLANTYPE_PLANTYPENAME = "id,plantype,plantypename";
    private static final String TOTALTABPAGEAP = "tabpageap";

    @Override
    public void closedCallBack(AbstractPlacsBillAdapter formPlugin, ClosedCallBackEvent e) {
        this.dataModel = formPlugin.getModel();
        this.formView = formPlugin.getView();
        this.appId = formPlugin.getAppId();
        this.afterImportProjectTaskCallBack(e);
    }

    protected void afterImportProjectTaskCallBack(ClosedCallBackEvent e) {
        List taskIds = (List)e.getReturnData();
        if (CollectionUtils.isNotEmpty((Collection)taskIds)) {
            DynamicObject[] importTasks;
            for (DynamicObject task : importTasks = BusinessDataServiceHelper.load((Object[])taskIds.toArray(), (DynamicObjectType)MetaDataUtil.getDT((String)this.appId, (String)"task"))) {
                DynamicObject preTask = task.getDynamicObject("pretask");
                if (preTask == null || taskIds.contains(Long.parseLong(preTask.getPkValue().toString()))) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u201c%s\u201d\u7684\u524d\u7f6e\u4efb\u52a1\u3002", (String)"MasterPlanImpProTaskCallback_4", (String)"pccs-placs-business", (Object[])new Object[0]), task.getString("name")));
            }
            this.fillEntryByRelationTask(importTasks, false, this.getMainPlanType());
        }
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.formView.getControl("taskentity");
        this.modifyTabName(TOTALTABPAGEAP, "taskentity");
        treeEntryGrid.setCollapse(false);
        this.dataModel.updateCache();
    }

    protected void modifyTabName(String tabName, String entryName) {
        int rowCount = this.dataModel.getEntryRowCount(entryName);
        TabPage tabPage = (TabPage)this.formView.getControl(tabName);
        if (rowCount == 0) {
            LocaleString text = new LocaleString(ResManager.loadKDString((String)"\u4e3b\u9879\u8ba1\u5212", (String)"MasterPlanImpProTaskCallback_0", (String)"pccs-placs-business", (Object[])new Object[0]));
            tabPage.setText(text);
        } else {
            LocaleString text = new LocaleString(String.format(ResManager.loadKDString((String)"\u4e3b\u9879\u8ba1\u5212[%s]", (String)"MasterPlanImpProTaskCallback_1", (String)"pccs-placs-business", (Object[])new Object[0]), rowCount));
            tabPage.setText(text);
        }
    }

    protected DynamicObject getMainPlanType() {
        return BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.appId, (String)"majortype"), (String)ID_PLANTYPE_PLANTYPENAME, (QFilter[])new QFilter[]{new QFilter("plantype", "=", (Object)PlanTypeEnum.MAINPLAN.getValue())});
    }

    protected void fillEntryByRelationTask(DynamicObject[] tasks, boolean isUpdate, DynamicObject mainPlanType) {
        Set taskIdSet = Arrays.stream(tasks).map(o -> o.getPkValue()).collect(Collectors.toSet());
        DynamicObjectCollection taskEntries = this.dataModel.getEntryEntity("taskentity");
        DynamicObjectType taskEntryDT = taskEntries.getDynamicObjectType();
        ORM orm = ORM.create();
        long[] ids = orm.genLongIds(MetaDataUtil.getEntityId((String)this.appId, (String)"task"), tasks.length);
        int idIndex = 0;
        HashMap<Object, Long> refMap = new HashMap<Object, Long>(tasks.length);
        HashMap<Long, DynamicObject> newIdAndNewTask = new HashMap<Long, DynamicObject>(tasks.length);
        for (DynamicObject task : tasks) {
            DynamicObject parent;
            task = BusinessDataServiceHelper.loadSingle((Object)task.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.appId, (String)"task"));
            DynamicObject newEntry = new DynamicObject(taskEntryDT);
            Long pk = ids[idIndex++];
            refMap.put(task.getPkValue(), pk);
            newEntry.set("id", (Object)pk);
            newEntry.set("name", task.get("name"));
            newEntry.set("controllevel", task.get("controllevel"));
            newEntry.set("aimfinishtime", task.get("aimfinishtime"));
            newEntry.set("comptimedeviation", task.get("comptimedeviation"));
            newEntry.set("absoluteduration", task.get("absoluteduration"));
            newEntry.set("taskversion", this.dataModel.getValue("version"));
            newEntry.set("status", (Object)StatusEnum.TEMPSAVE.getValue());
            newEntry.set("achievementnode", task.get("achievementnode"));
            DynamicObject project = (DynamicObject)this.dataModel.getValue("project");
            newEntry.set("taskproject", (Object)project);
            newEntry.set("belongplantype", (Object)task.getDynamicObject("belongplantype"));
            newEntry.set("tasktype", (Object)task.getDynamicObject("tasktype"));
            newEntry.set("isleaf", task.get("isleaf"));
            newEntry.set("transactiontype", (Object)this.getTxTypes(task.getDynamicObjectCollection("transactiontype"), orm));
            newEntry.set("logical", task.get("logical"));
            newEntry.set("relativeduration", task.get("relativeduration"));
            newEntry.set("pretask", task.get("pretask"));
            if (!isUpdate && mainPlanType != null) {
                newEntry.set("belongplantype", (Object)mainPlanType);
            }
            for (parent = task.getDynamicObject("parent"); parent != null && !taskIdSet.contains(parent.getPkValue()); parent = parent.getDynamicObject("parent")) {
                parent = BusinessDataServiceHelper.loadSingleFromCache((Object)parent.getPkValue(), (DynamicObjectType)MetaDataUtil.getDT((String)this.appId, (String)"task"));
            }
            long pid = parent == null ? 0L : (Long)parent.getPkValue();
            newEntry.set("pid", (Object)pid);
            newIdAndNewTask.put(pk, newEntry);
            taskEntries.add((Object)newEntry);
        }
        for (DynamicObject task : taskEntries) {
            Long pid = task.getLong("pid");
            if (pid == 0L || !refMap.containsKey(pid)) continue;
            task.set("pid", refMap.get(pid));
        }
        for (DynamicObject task : taskEntries) {
            DynamicObject oldPreTask = task.getDynamicObject("pretask");
            if (oldPreTask == null) continue;
            Object newPk = refMap.get(oldPreTask.getPkValue());
            task.set("pretask", newIdAndNewTask.get(newPk));
        }
        this.dataModel.updateEntryCache(taskEntries);
        this.formView.invokeOperation("save");
        this.dataModel.updateCache();
        this.formView.updateView("taskentity");
    }

    protected DynamicObjectCollection getTxTypes(DynamicObjectCollection oldCol, ORM orm) {
        DynamicObjectCollection newCol = new DynamicObjectCollection();
        DynamicObjectType txDT = oldCol.getDynamicObjectType();
        long[] longIds = orm.genLongIds((IDataEntityType)txDT, oldCol.size());
        for (int i = 0; i < oldCol.size(); ++i) {
            DynamicObject oldTx = (DynamicObject)oldCol.get(i);
            DynamicObject newTx = new DynamicObject(txDT);
            newTx.set("pkid", (Object)longIds[i]);
            newTx.set("fbasedataid", oldTx.get("fbasedataid"));
            newTx.set("fbasedataid_id", oldTx.get("fbasedataid_id"));
            newCol.add((Object)newTx);
        }
        return newCol;
    }

    protected void copyTaskFile(DynamicObject relationTask, DynamicObject currentTask) {
        DynamicObjectCollection taskReferDocEntries;
        String achievementNode = currentTask.get("achievementnode").toString();
        DynamicObjectType resultDocEntryDT = MetaDataUtil.getSubEntryDT((String)this.appId, (String)"deptplan", (String)"taskentity", (String)"taskresultdocentry");
        DynamicObjectType referDocEntryDT = MetaDataUtil.getSubEntryDT((String)this.appId, (String)"deptplan", (String)"taskentity", (String)"taskreferdocentry");
        ORM orm = ORM.create();
        DynamicObjectCollection taskResultDocEntries = relationTask.getDynamicObjectCollection("taskresultdocentry");
        if (!taskResultDocEntries.isEmpty()) {
            DynamicObjectCollection resultDocEntries = new DynamicObjectCollection();
            long[] resultDocEntryPks = orm.genLongIds((IDataEntityType)resultDocEntryDT, taskResultDocEntries.size());
            int resultDocEntryindex = 0;
            for (DynamicObject resultDocEntry : taskResultDocEntries) {
                Long resultDocEntryPk = resultDocEntryPks[resultDocEntryindex++];
                DynamicObject newResultDoc = new DynamicObject(resultDocEntryDT);
                newResultDoc.set("id", (Object)resultDocEntryPk);
                newResultDoc.setParent((Object)currentTask);
                newResultDoc.set("resultname", resultDocEntry.get("resultname"));
                newResultDoc.set("force", resultDocEntry.get("force"));
                newResultDoc.set("frequency", resultDocEntry.get("frequency"));
                newResultDoc.set("resultdescription", resultDocEntry.get("resultdescription"));
                resultDocEntries.add((Object)newResultDoc);
            }
            currentTask.set("taskresultdocentry", (Object)resultDocEntries);
        }
        if (!(taskReferDocEntries = relationTask.getDynamicObjectCollection("taskreferdocentry")).isEmpty()) {
            DynamicObjectCollection referDocEntries = new DynamicObjectCollection();
            long[] referDocEntryPks = orm.genLongIds((IDataEntityType)referDocEntryDT, taskReferDocEntries.size());
            int taskReferDocIndex = 0;
            for (DynamicObject referDocEntry : taskReferDocEntries) {
                Long referDocEntryPk = referDocEntryPks[taskReferDocIndex++];
                DynamicObject newReferDoc = new DynamicObject(referDocEntryDT);
                newReferDoc.setParent((Object)currentTask);
                newReferDoc.set("id", (Object)referDocEntryPk);
                newReferDoc.set("referdocname", referDocEntry.get("referdocname"));
                DynamicObjectCollection doces = referDocEntry.getDynamicObjectCollection("attachment");
                if (doces != null && !doces.isEmpty()) {
                    DynamicObjectCollection newDoces = new DynamicObjectCollection();
                    DynamicObjectType docDT = doces.getDynamicObjectType();
                    for (DynamicObject doc : doces) {
                        DynamicObject newDoc = new DynamicObject(docDT);
                        referDocEntry.getDataEntityType().getPrimaryKey().setValueFast((Object)newDoc, (Object)orm.genLongId((IDataEntityType)docDT));
                        newDoc.set("fbasedataid", (Object)doc.getDynamicObject("fbasedataid"));
                        newDoces.add((Object)newDoc);
                    }
                    newReferDoc.set("attachment", (Object)newDoces);
                }
                newReferDoc.set("description", referDocEntry.get("description"));
                referDocEntries.add((Object)newReferDoc);
            }
            currentTask.set("taskreferdocentry", (Object)referDocEntries);
        }
    }
}

