/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.business.excelimport;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.format.DateFormatObject;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.form.IFormController;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.pccs.placs.business.excelimport.CommonDataExporter;
import kd.pccs.placs.business.excelimport.ICommonImportAndExport;
import kd.pccs.placs.common.enums.DefaultEnum;
import kd.pccs.placs.common.utils.poi.POIHelper;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;

public class CommonImportAndExport
implements ICommonImportAndExport {
    private static final Log logger = LogFactory.getLog(CommonImportAndExport.class);
    protected SimpleDateFormat sdf = new SimpleDateFormat(InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId())).getDateFormat().getDateFormat());
    public Map<String, Object> params = new HashMap<String, Object>();
    public ExportWriterFormat formator;
    public IFormView parentView;
    public Map<String, Map<String, Integer>> entryIndexMap = new HashMap<String, Map<String, Integer>>();
    private static final String STARTINDEX = "startIndex";
    private static final String ENDINDEX = "endIndex";

    @Override
    public String executeExportTask(Map<String, Object> params) throws KDException {
        this.params.putAll(params);
        boolean exportData = (Boolean)this.params.get("isExportData");
        this.formator = this.loadExportFormat();
        ArrayList<ExportWriterFormat> formats = new ArrayList<ExportWriterFormat>(10);
        formats.add(this.formator);
        CommonDataExporter exporter = new CommonDataExporter("sheet1", formats);
        String fileName = this.genDataExportFileName(LocalDate.now());
        if (exportData) {
            this.exportData(exporter, formats);
        }
        String url = exporter.flush(fileName, 5000);
        return url;
    }

    public void exportData(CommonDataExporter exporter, List<ExportWriterFormat> formats) {
        DynamicObjectCollection mainData = this.getParentView().getModel().getEntryEntity(this.getEntryKey());
        exporter.exportData(mainData, formats, this.params);
    }

    public IFormView getParentView() {
        if (this.parentView == null) {
            String parentPageId = (String)this.params.get("parentpageid");
            if (StringUtils.isBlank((CharSequence)parentPageId)) {
                return null;
            }
            this.parentView = SessionManager.getCurrent().getView(parentPageId);
            IFormController srv = (IFormController)this.parentView.getService(IFormController.class);
            srv.registerListener();
        }
        return this.parentView;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public String getEntityNumber() {
        return (String)this.getParams().get("entitynumber");
    }

    public String getEntryKey() {
        return (String)this.getParams().get("entryKey");
    }

    public ExportWriterFormat loadExportFormat() {
        MetadataService metaService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String formatJson = metaService.getExportWriter(this.getEntityNumber(), 0L, null, null);
        List formats = JSONObject.parseArray((String)formatJson, ExportWriterFormat.class);
        ExportWriterFormat format = (ExportWriterFormat)formats.get(0);
        ExportWriterFormat entryFormat = null;
        for (ExportWriterFormat format1 : format.next) {
            if (!format1.name.equals(this.getEntryKey())) continue;
            entryFormat = format1;
            break;
        }
        if (entryFormat != null) {
            entryFormat.fields.add(1, "parent");
            HashMap<String, String> parentValue = new HashMap<String, String>();
            parentValue.put("InputType", "multilang");
            parentValue.put("MustInput", "false");
            parentValue.put("DisplayName", ResManager.loadKDString((String)"\u4e0a\u7ea7\u540d\u79f0", (String)"CommonImportAndExport_0", (String)"pccs-placs-business", (Object[])new Object[0]));
            parentValue.put("DataKey", (String)((Map)entryFormat.properties.get("name")).get("DataKey"));
            parentValue.put("propName", "parent");
            entryFormat.properties.put("parent", parentValue);
            ArrayList<String> parentColumn = new ArrayList<String>(1);
            parentColumn.add("parent");
            entryFormat.flexColumn.put("parent", parentColumn);
            ArrayList<String> parentDisplay = new ArrayList<String>(1);
            parentDisplay.add(ResManager.loadKDString((String)"\u4e0a\u7ea7\u540d\u79f0", (String)"CommonImportAndExport_0", (String)"pccs-placs-business", (Object[])new Object[0]));
            entryFormat.flexColumnDisplay.put("parent", parentDisplay);
            ArrayList<String> parentDesc = new ArrayList<String>(1);
            parentDesc.add(ResManager.loadKDString((String)"\u6587\u672c", (String)"CommonImportAndExport_1", (String)"pccs-placs-business", (Object[])new Object[0]));
            entryFormat.flexColumnDesc.put("parent", parentDesc);
        }
        return entryFormat;
    }

    public String genDataExportFileName(LocalDate now) {
        String fileName = ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e_", (String)"CommonImportAndExport_2", (String)"pccs-placs-business", (Object[])new Object[0]);
        fileName = fileName + this.formator.displayName;
        fileName = fileName + String.format("_%02d%02d", now.getMonthValue(), now.getDayOfMonth());
        return fileName.replaceAll("[\n`~!@#$%^&*()+=|{}':;',\\[\\]<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c \u3001\uff1f]", "").replaceAll(" ", "_");
    }

    @Override
    public DynamicObjectCollection executeImportTask(Map<String, Object> param) {
        this.params.putAll(param);
        this.formator = this.loadExportFormat();
        ArrayList<ExportWriterFormat> formats = new ArrayList<ExportWriterFormat>(10);
        formats.add(this.formator);
        String url = (String)this.params.get("url");
        String appId = (String)this.params.get("appId");
        this.importTemplateCheck(formats, url);
        JSONArray data = this.parseExcelData(url);
        JSONArray errorData = new JSONArray();
        boolean hasError = this.checkOutExcelData(this.formator, data, errorData);
        if (hasError) {
            this.exportErrorData(url, errorData);
            return null;
        }
        DynamicObjectCollection entrys = this.importExcelData(this.formator, data, appId);
        return entrys;
    }

    public DynamicObjectCollection importExcelData(ExportWriterFormat format, JSONArray data, String appId) {
        ORM orm = ORM.create();
        int startRow = 0;
        boolean startColumn = false;
        int currentNum = 0;
        int temNum = 0;
        int preOffset = 0;
        int temOffset = 0;
        boolean lastOffset = false;
        Long parentid = (Long)this.getParentView().getModel().getDataEntity().getPkValue();
        DynamicObjectCollection entrysdt = this.parentView.getModel().getEntryEntity(this.getEntryKey());
        entrysdt.clear();
        DynamicObject entry = null;
        DynamicObject subEntry = null;
        long[] entryIds = orm.genLongIds((IDataEntityType)entrysdt.getDynamicObjectType(), data.size());
        for (int i = 0; i < data.size(); ++i) {
            Map<String, Object> dataMap = this.getDataMap(JSONArray.parseArray((String)data.get(i).toString()));
            entry = new DynamicObject(entrysdt.getDynamicObjectType());
            temOffset = preOffset = this.createEntrysData(entry, parentid, entryIds[i], preOffset, format, dataMap, entrysdt);
            if (format.next.size() > 0) {
                for (ExportWriterFormat subFormat : format.next) {
                    currentNum = i;
                    DynamicObjectCollection subEntrysdt = entry.getDynamicObjectCollection(subFormat.name);
                    long[] subEntryIds = orm.genLongIds((IDataEntityType)subEntrysdt.getDynamicObjectType(), data.size());
                    for (int j = currentNum; j < data.size(); ++j) {
                        JSONArray mainData;
                        JSONArray column = JSONArray.parseArray((String)data.get(j).toString());
                        Map<String, Object> dataMap1 = this.getDataMap(column);
                        if (this.checkEntryIsNull(subFormat.name, column)) {
                            ++currentNum;
                            break;
                        }
                        subEntry = new DynamicObject(subEntrysdt.getDynamicObjectType());
                        preOffset = this.createEntrysData(subEntry, entryIds[i], subEntryIds[j], this.entryIndexMap.get(subFormat.name).get(STARTINDEX), subFormat, dataMap1, subEntrysdt);
                        subEntrysdt.add((Object)subEntry);
                        if (++currentNum < data.size() && !this.checkEntryIsNull(format.name, mainData = JSONArray.parseArray((String)data.get(currentNum).toString()))) break;
                    }
                    if (currentNum - 1 > temNum) {
                        temNum = currentNum - 1;
                    }
                    currentNum = startRow;
                }
                if (temNum > startRow) {
                    startRow = temNum;
                }
                i = startRow;
                currentNum = startRow;
            }
            preOffset = 0;
            entrysdt.add((Object)entry);
        }
        return entrysdt;
    }

    public boolean checkEntryIsNull(String name, JSONArray da) {
        return da.subList(this.entryIndexMap.get(name).get(STARTINDEX).intValue(), this.entryIndexMap.get(name).get(ENDINDEX).intValue()).stream().allMatch(it -> JSON.parseObject((String)it.toString()).get((Object)"cellValue") == null || StringUtils.isEmpty((CharSequence)JSON.parseObject((String)it.toString()).get((Object)"cellValue").toString()));
    }

    @NotNull
    public Map<String, Object> getDataMap(JSONArray data) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        for (Object column : data) {
            JSONObject jObject = JSONObject.parseObject((String)column.toString());
            String columnKey = jObject.getString("columnKey");
            Object cellValueObject = jObject.get((Object)"cellValue");
            dataMap.put(columnKey, cellValueObject);
        }
        return dataMap;
    }

    public int createEntrysData(DynamicObject entry, Long parentid, Long entryId, int offset, ExportWriterFormat format, Map<String, Object> dataMap, DynamicObjectCollection entrysdt) {
        entry.set("id", (Object)entryId);
        entry.setParent((Object)parentid);
        try {
            entry.set("isleaf", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        for (int i = 0; i < format.fields.size(); ++i) {
            String fieldName = (String)format.fields.get(i);
            Map property = (Map)format.properties.get(fieldName);
            Object inputType = null;
            if (property != null && !"id".equals(inputType = property.get("InputType")) && !"pid".equals(inputType)) {
                if (inputType instanceof JSONArray) {
                    Object value = dataMap.get(fieldName);
                    HashMap comboPropData = new HashMap(10);
                    ((JSONArray)inputType).forEach(obj -> {
                        if (obj.toString().split(" # ").length > 1) {
                            comboPropData.put(obj.toString().split(" # ", -1)[0], obj.toString().split(" # ", -1)[1]);
                        }
                    });
                    if (comboPropData.size() > 0) {
                        entry.set(fieldName, comboPropData.get(value));
                    } else {
                        entry.set(fieldName, value);
                    }
                } else if ("date".equals(inputType) && dataMap.get(fieldName) != null && !"".equals(dataMap.get(fieldName))) {
                    Date planStartTime = new Date();
                    try {
                        planStartTime.setTime(Long.parseLong(dataMap.get(fieldName).toString()));
                    }
                    catch (NumberFormatException e) {
                        try {
                            planStartTime = this.sdf.parse(dataMap.get(fieldName).toString());
                        }
                        catch (ParseException e1) {
                            logger.info(String.format("Excel\u4e2d\u5bfc\u5165\u7684\u65e5\u671f\u201c%s\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", dataMap.get(fieldName).toString()));
                        }
                    }
                    entry.set(fieldName, (Object)planStartTime);
                } else {
                    if ("basedata".equals(inputType) || "flex".equals(inputType) || "largetext".equals(inputType) || "multilang".equals(inputType)) {
                        offset = this.dealBaseData(entry, format, property, fieldName, offset, inputType, dataMap, entrysdt);
                        continue;
                    }
                    entry.set(fieldName, dataMap.get(fieldName));
                }
            }
            ++offset;
        }
        return offset;
    }

    public int dealBaseData(DynamicObject entry, ExportWriterFormat format, Map<String, Object> property, String fieldName, int offset, Object inputType, Map<String, Object> dataMap, DynamicObjectCollection entrysdt) {
        ORM orm = ORM.create();
        List splitCols = (List)format.flexColumn.get(fieldName);
        if ("multilang".equals(inputType)) {
            if ("parent".equals(fieldName) && StringUtils.isNotBlank((Object)dataMap.get(fieldName))) {
                Long pid = null;
                for (DynamicObject dt : entrysdt) {
                    if (!dataMap.get(fieldName).equals(dt.getString(this.params.get("name").toString()))) continue;
                    pid = Long.parseLong(dt.getPkValue().toString());
                    dt.set("isleaf", (Object)Boolean.FALSE);
                }
                entry.set("pid", pid);
            } else if (!"parent".equals(fieldName)) {
                entry.set(fieldName, dataMap.get(splitCols.get(0)));
            }
            return ++offset;
        }
        DataEntityPropertyCollection dataEntityProperty = entry.getDataEntityType().getProperties();
        QFilter enableFilter = new QFilter("enable", "=", (Object)DefaultEnum.YES.getValue());
        String entityName = null;
        if (entry.getDataEntityType().getProperties().get((Object)fieldName) instanceof MulBasedataProp) {
            entityName = ((MulBasedataProp)entry.getDataEntityType().getProperties().get((Object)fieldName)).getBaseEntityId();
            if (splitCols != null) {
                DynamicObject baseData;
                QFilter numberFilter;
                QFilter nameFilter;
                int i;
                Object filter = null;
                QFilter[] filters = new QFilter[splitCols.size()];
                String numberStr = "";
                String nameStr = "";
                for (int j = 0; j < splitCols.size(); ++j) {
                    if ("number".equals(((String)splitCols.get(j)).split("\\.")[1])) {
                        numberStr = dataMap.get(splitCols.get(j)) != null ? (String)dataMap.get(splitCols.get(j)) : "";
                    } else if ("name".equals(((String)splitCols.get(j)).split("\\.")[1])) {
                        nameStr = dataMap.get(splitCols.get(j)) != null ? (String)dataMap.get(splitCols.get(j)) : "";
                    }
                    ++offset;
                }
                String[] numberStrs = StringUtils.isNotBlank((CharSequence)numberStr) ? numberStr.split(";|\uff1b") : new String[]{};
                String[] nameStrs = StringUtils.isNotBlank((CharSequence)nameStr) ? nameStr.split(";|\uff1b") : new String[]{};
                DynamicObjectCollection baseDataList = new DynamicObjectCollection();
                ArrayList<Object> pkValueList = new ArrayList<Object>();
                if (numberStrs.length > 0) {
                    for (i = 0; i < numberStrs.length; ++i) {
                        nameFilter = null;
                        numberFilter = new QFilter("number", "=", (Object)numberStrs[i]);
                        if (nameStrs.length > i && StringUtils.isNotBlank((CharSequence)nameStrs[i])) {
                            nameFilter = new QFilter("name", "=", (Object)nameStrs[i]);
                        }
                        if ((baseData = BusinessDataServiceHelper.loadSingle((String)entityName, (String)"id,number,name", (QFilter[])new QFilter[]{nameFilter, numberFilter, enableFilter})) == null || pkValueList.contains(baseData.getPkValue())) continue;
                        baseDataList.add((Object)baseData);
                        pkValueList.add(baseData.getPkValue());
                    }
                } else {
                    for (i = 0; i < nameStrs.length; ++i) {
                        nameFilter = new QFilter("name", "=", (Object)nameStrs[i]);
                        numberFilter = null;
                        if (numberStrs.length > i && StringUtils.isNotBlank((CharSequence)numberStrs[i])) {
                            numberFilter = new QFilter("number", "=", (Object)numberStrs[i]);
                        }
                        if ((baseData = BusinessDataServiceHelper.loadSingle((String)entityName, (String)"id,number,name", (QFilter[])new QFilter[]{nameFilter, numberFilter, enableFilter})) == null || pkValueList.contains(baseData.getPkValue())) continue;
                        baseDataList.add((Object)baseData);
                        pkValueList.add(baseData.getPkValue());
                    }
                }
                DynamicObjectCollection dataBases = entry.getDynamicObjectCollection(fieldName);
                DynamicObjectType dt = dataBases.getDynamicObjectType();
                dataBases.clear();
                for (DynamicObject data : baseDataList) {
                    DynamicObject dataRow = new DynamicObject(dt);
                    dataRow.set("pkid", (Object)orm.genLongId((IDataEntityType)dt));
                    dataRow.set("fbasedataid", (Object)data);
                    dataRow.set("fbasedataid_id", data.getPkValue());
                    dataBases.add((Object)dataRow);
                }
            }
        } else {
            DynamicObject[] baseData;
            entityName = ((BasedataProp)entry.getDataEntityType().getProperties().get((Object)fieldName)).getBaseEntityId();
            QFilter filter = null;
            QFilter[] filters = new QFilter[splitCols.size()];
            boolean arrayFlag = false;
            if (splitCols != null) {
                for (int j = 0; j < splitCols.size(); ++j) {
                    if (StringUtils.isNotBlank((Object)dataMap.get(splitCols.get(j)))) {
                        filters[j] = filter = new QFilter(((String)splitCols.get(j)).split("\\.")[1], "=", dataMap.get(splitCols.get(j)));
                        arrayFlag = true;
                    }
                    ++offset;
                }
            }
            DynamicObject[] dynamicObjectArray = baseData = arrayFlag ? BusinessDataServiceHelper.load((String)entityName, (String)"id,number,name", (QFilter[])filters) : null;
            if ("pretask".equals(fieldName) && baseData != null) {
                String nameFlag = "pretask.name";
                entry.set(fieldName, dataMap.get(nameFlag));
            } else if (baseData != null) {
                entry.set(fieldName, (Object)baseData[0]);
            }
        }
        return offset;
    }

    public void exportErrorData(String url, JSONArray errorData) {
        String newUrl = null;
        try {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream in = cache.getInputStream(url);
            XSSFWorkbook xWb = null;
            xWb = new XSSFWorkbook(in);
            XSSFSheet sheet = xWb.getSheetAt(0);
            JSONArray errorColumnHead = JSONArray.parseArray((String)errorData.get(0).toString());
            JSONObject columnHeadValue = JSONObject.parseObject((String)errorColumnHead.get(0).toString());
            String columnHeadKey = columnHeadValue.getString("columnKey");
            String columnHeadName = columnHeadValue.getString("columnName");
            XSSFRow columnKeyRow = sheet.getRow(2);
            XSSFFont headFont = xWb.createFont();
            headFont.setColor(IndexedColors.RED.getIndex());
            XSSFCellStyle headCellStyle = xWb.createCellStyle();
            headCellStyle.setFont((Font)headFont);
            int index = 0;
            sheet.setColumnHidden(0, Boolean.FALSE.booleanValue());
            XSSFCell columnKeyCell = columnKeyRow.createCell(index);
            columnKeyCell.setCellValue(columnHeadKey);
            columnKeyCell.setCellStyle((CellStyle)headCellStyle);
            XSSFRow headRow = sheet.getRow(3);
            XSSFCell headCell = headRow.createCell(index);
            headCell.setCellValue(columnHeadName);
            headCell.setCellStyle((CellStyle)headCellStyle);
            for (int i = 0; i < errorData.size(); ++i) {
                JSONArray errorColumn = JSONArray.parseArray((String)errorData.get(i).toString());
                JSONObject columnValue = JSONObject.parseObject((String)errorColumn.get(0).toString());
                String cellValue = columnValue.getString("cellValue");
                XSSFRow iRow = sheet.getRow(i + 4);
                XSSFFont font = xWb.createFont();
                font.setColor(IndexedColors.RED.getIndex());
                XSSFCellStyle cellStyle = xWb.createCellStyle();
                cellStyle.setFont((Font)font);
                XSSFCell columnCell = iRow.createCell(index);
                columnCell.setCellValue(cellValue);
                columnCell.setCellStyle((CellStyle)cellStyle);
                sheet.setColumnWidth(0, CommonImportAndExport.calcColumnWidth(cellValue, 0));
            }
            newUrl = this.flush(xWb, ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u679c", (String)"CommonImportAndExport_3", (String)"pccs-placs-business", (Object[])new Object[0]), 5000);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        this.parentView.download(newUrl);
    }

    private static int calcColumnWidth(String caption, int defColWidth) {
        int colWidth;
        boolean var2 = false;
        try {
            colWidth = Math.max(256 * defColWidth / 8 * 2, 256 * (caption.getBytes("GBK").length + 12));
        }
        catch (UnsupportedEncodingException var4) {
            colWidth = 256 * (caption.getBytes().length + 8);
        }
        return Math.min(colWidth, 51200);
    }

    public String flush(XSSFWorkbook wb, String fileName, int timeoutSecond) {
        try {
            String var38;
            Throwable var4 = null;
            try {
                File temp = File.createTempFile(UUID.randomUUID().toString(), ".xlsx");
                try (FileOutputStream fos = new FileOutputStream(temp);){
                    wb.write((OutputStream)fos);
                }
                try (FileInputStream inputStream = new FileInputStream(temp);){
                    String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(fileName + ".xlsx", (InputStream)inputStream, timeoutSecond);
                    temp.deleteOnExit();
                    var38 = url;
                }
            }
            catch (Throwable var34) {
                var4 = var34;
                throw var34;
            }
            finally {
                if (wb != null) {
                    if (var4 != null) {
                        try {
                            wb.close();
                        }
                        catch (Throwable var30) {
                            var4.addSuppressed(var30);
                        }
                    } else {
                        wb.close();
                    }
                }
            }
            return var38;
        }
        catch (IOException var36) {
            throw new RuntimeException(var36);
        }
    }

    public boolean checkOutExcelData(ExportWriterFormat format, JSONArray data, JSONArray errorData) {
        boolean hasError = false;
        int preOffset = 0;
        boolean temCount = false;
        DynamicObjectCollection entrysdt = this.getParentView().getModel().getEntryEntity(this.getEntryKey());
        DynamicObject entry = null;
        DynamicObject subEntry = null;
        for (int i = 0; i < data.size(); ++i) {
            Object row = data.get(i);
            JSONArray column = (JSONArray)row;
            Map<String, Object> dataMap = this.getDataMap(column);
            JSONArray errorColumn = new JSONArray();
            JSONArray errorMsg = new JSONArray();
            JSONObject errorInfo = new JSONObject();
            errorInfo.put("columnKey", (Object)"errorinfo");
            errorInfo.put("columnName", (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u63d0\u793a\u4fe1\u606f", (String)"CommonImportAndExport_4", (String)"pccs-placs-business", (Object[])new Object[0]));
            entry = new DynamicObject(entrysdt.getDynamicObjectType());
            if (!this.checkEntryIsNull(format.name, column)) {
                preOffset = this.checkData(i, entry, format, this.entryIndexMap.get(format.name).get(STARTINDEX), column, errorMsg, dataMap, data);
            }
            if (format.next.size() > 0) {
                for (ExportWriterFormat subFormat : format.next) {
                    DynamicObjectCollection subEntrysdt = entry.getDynamicObjectCollection(subFormat.name);
                    subEntry = new DynamicObject(subEntrysdt.getDynamicObjectType());
                    if (this.checkEntryIsNull(subFormat.name, column)) continue;
                    preOffset = this.checkData(i, subEntry, subFormat, this.entryIndexMap.get(subFormat.name).get(STARTINDEX), column, errorMsg, dataMap, data);
                }
            }
            if (errorMsg.size() > 0) {
                errorInfo.put("cellValue", (Object)String.format(ResManager.loadKDString((String)"\u6570\u636e\u6709\u8bef\uff1a%s\u3002", (String)"CommonImportAndExport_27", (String)"pccs-placs-business", (Object[])new Object[0]), errorMsg));
                hasError = true;
            } else {
                errorInfo.put("cellValue", (Object)ResManager.loadKDString((String)"\u6570\u636e\u65e0\u8bef\u3002", (String)"CommonImportAndExport_28", (String)"pccs-placs-business", (Object[])new Object[0]));
            }
            errorColumn.add(0, (Object)errorInfo);
            errorData.add((Object)errorColumn);
        }
        return hasError;
    }

    public int checkData(int index, DynamicObject entry, ExportWriterFormat format, int offset, JSONArray column, JSONArray errorMsg, Map<String, Object> dataMap, JSONArray data) {
        FormatObject formatObject = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
        DateFormatObject dateFormat = formatObject.getDateFormat();
        for (int i = 0; i < format.fields.size(); ++i) {
            String fieldName = (String)format.fields.get(i);
            Map property = (Map)format.properties.get(fieldName);
            JSONObject columnValue = column.getJSONObject(offset);
            String cellValue = columnValue.getString("cellValue");
            String columnKey = columnValue.getString("columnKey");
            Object inputType = null;
            boolean mustInput = false;
            if (property != null) {
                inputType = property.get("InputType");
                mustInput = Boolean.TRUE.equals(property.get("MustInput"));
                if (mustInput && StringUtils.isEmpty((CharSequence)cellValue)) {
                    errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u9879\uff1a\u201c%s\u201d\u3002", (String)"CommonImportAndExport_29", (String)"pccs-placs-business", (Object[])new Object[0]), property.get("DisplayName")));
                }
                if ("name".equals(fieldName)) {
                    block5: for (int k = 0; k < data.size(); ++k) {
                        JSONArray jsonArray = data.getJSONArray(k);
                        for (int j = 0; j < jsonArray.size(); ++j) {
                            String name;
                            JSONObject jsonObject = jsonArray.getJSONObject(j);
                            if (!columnKey.equals(jsonObject.getString("columnKey")) || !(name = jsonObject.getString("cellValue")).equals(cellValue)) continue;
                            if (index <= k) continue block5;
                            errorMsg.add((Object)ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u8f93\u5165\u4e0d\u540c\u7684\u4efb\u52a1\u540d\u79f0\u3002", (String)"CommonImportAndExport_30", (String)"pccs-placs-business", (Object[])new Object[0]));
                            break block5;
                        }
                    }
                }
                if (!"id".equals(inputType) && !"pid".equals(inputType)) {
                    if (inputType instanceof JSONArray) {
                        HashMap comboPropData = new HashMap(10);
                        ((JSONArray)inputType).forEach(obj -> {
                            if (obj.toString().split(" # ").length > 1) {
                                comboPropData.put(obj.toString().split(" # ", -1)[0], obj.toString().split(" # ", -1)[1]);
                            }
                        });
                        if (comboPropData.size() > 0 && comboPropData.get(cellValue) == null && StringUtils.isNotBlank((CharSequence)cellValue)) {
                            errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5339\u914d\u4e0d\u5230\u4e0b\u62c9\u9009\u9879\u3002", (String)"CommonImportAndExport_25", (String)"pccs-placs-business", (Object[])new Object[0]), cellValue));
                        }
                    } else if ("date".equals(inputType)) {
                        if (!StringUtils.isEmpty((CharSequence)cellValue)) {
                            try {
                                this.sdf.parse(cellValue);
                            }
                            catch (Exception e1) {
                                try {
                                    Date cellValueD = (Date)columnValue.get((Object)"cellValue");
                                    this.sdf.format(cellValueD);
                                }
                                catch (Exception e2) {
                                    errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u683c\u5f0f\u6709\u8bef,\u8bf7\u8f93\u5165\u65e5\u671f\u7c7b\u578b\u3002", (String)"CommonImportAndExport_31", (String)"pccs-placs-business", (Object[])new Object[0]), property.get("DisplayName")));
                                }
                            }
                        }
                    } else if (!"datetime".equals(inputType)) {
                        if ("decimal".equals(inputType)) {
                            String reg;
                            if (cellValue != null && !cellValue.matches(reg = "^(-?\\d+)(\\.\\d+)?")) {
                                errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u683c\u5f0f\u6709\u8bef,\u8bf7\u8f93\u5165\u6570\u5b57\u7c7b\u578b\u3002", (String)"CommonImportAndExport_16", (String)"pccs-placs-business", (Object[])new Object[0]), property.get("DisplayName")));
                            }
                        } else if ("basedata".equals(inputType) || "flex".equals(inputType) || "multilang".equals(inputType) || "largetext".equals(inputType)) {
                            offset = this.checkBashData(entry, format, property, fieldName, offset, inputType, errorMsg, dataMap, data);
                            continue;
                        }
                    }
                }
            }
            ++offset;
        }
        return offset;
    }

    public int checkBashData(DynamicObject entry, ExportWriterFormat format, Map<String, Object> property, String fieldName, int offset, Object inputType, JSONArray errorMsg, Map<String, Object> dataMap, JSONArray data) {
        ORM orm = ORM.create();
        List splitCols = (List)format.flexColumn.get(fieldName);
        List splitDisplay = (List)format.flexColumnDisplay.get(fieldName);
        if ("multilang".equals(inputType)) {
            if ("parent".equals(splitCols.get(0)) && StringUtils.isNotBlank((Object)dataMap.get(splitCols.get(0)))) {
                String nameFlag;
                String parentName = dataMap.get(fieldName).toString();
                if (parentName.equals(dataMap.get(nameFlag = (String)((List)format.flexColumn.get(this.params.get("name").toString())).get(0)))) {
                    errorMsg.add((Object)ResManager.loadKDString((String)"\u4e0a\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e0e\u672c\u8eab\u540d\u79f0\u76f8\u540c\u3002", (String)"CommonImportAndExport_26", (String)"pccs-placs-business", (Object[])new Object[0]));
                } else {
                    boolean exist = false;
                    for (Object jsonData : data) {
                        JSONArray column = (JSONArray)jsonData;
                        Map<String, Object> jsonDataMap = this.getDataMap(column);
                        if (!parentName.equals(jsonDataMap.get(nameFlag))) continue;
                        exist = true;
                    }
                    if (!exist) {
                        errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u540d\u79f0\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"CommonImportAndExport_11", (String)"pccs-placs-business", (Object[])new Object[0]), parentName));
                    }
                }
            }
            return ++offset;
        }
        JSONArray baseDataInfo = new JSONArray();
        JSONObject baseInfo = null;
        DataEntityPropertyCollection dataEntityProperty = entry.getDataEntityType().getProperties();
        QFilter enableFilter = new QFilter("enable", "=", (Object)DefaultEnum.YES.getValue());
        String entityName = null;
        if (entry.getDataEntityType().getProperties().get((Object)fieldName) instanceof MulBasedataProp) {
            entityName = ((MulBasedataProp)entry.getDataEntityType().getProperties().get((Object)fieldName)).getBaseEntityId();
            if (splitCols != null) {
                Object filter = null;
                QFilter[] filters = new QFilter[splitCols.size()];
                String numberStr = "";
                String nameStr = "";
                for (int j = 0; j < splitCols.size(); ++j) {
                    if ("number".equals(((String)splitCols.get(j)).split("\\.")[1])) {
                        numberStr = dataMap.get(splitCols.get(j)) != null ? (String)dataMap.get(splitCols.get(j)) : null;
                    } else if ("name".equals(((String)splitCols.get(j)).split("\\.")[1])) {
                        nameStr = dataMap.get(splitCols.get(j)) != null ? (String)dataMap.get(splitCols.get(j)) : null;
                    }
                    ++offset;
                }
                if (StringUtils.isNotBlank((CharSequence)nameStr)) {
                    String[] nameStrs = nameStr.split(";|\uff1b");
                    String[] numberStrs = new String[]{};
                    if (StringUtils.isNotBlank((CharSequence)numberStr)) {
                        numberStrs = numberStr.split(";|\uff1b");
                    }
                    DynamicObjectCollection baseDataList = new DynamicObjectCollection();
                    for (int i = 0; i < nameStrs.length; ++i) {
                        DynamicObject baseData;
                        QFilter nameFilter = new QFilter("name", "=", (Object)nameStrs[i]);
                        QFilter numberFilter = null;
                        if (numberStrs.length > i && StringUtils.isNotBlank((CharSequence)numberStrs[i])) {
                            numberFilter = new QFilter("number", "=", (Object)numberStrs[i]);
                        }
                        if ((baseData = BusinessDataServiceHelper.loadSingle((String)entityName, (String)"id,number,name", (QFilter[])new QFilter[]{nameFilter, numberFilter, enableFilter})) == null && numberStrs[i] != null && nameStrs[i] != null) {
                            errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u5b58\u5728\u201c%1$s\u201d=\u201c%2$s\u201d,\u201c%3$s\u201d=\u201c%4$s\u201d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"CommonImportAndExport_19", (String)"pccs-placs-business", (Object[])new Object[0]), splitDisplay.get(0), numberStrs[i], splitDisplay.get(1), nameStrs[i]));
                            continue;
                        }
                        if (baseData != null) continue;
                        errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u5b58\u5728\u201c%1$s\u201d=\u201c%2$s\u201d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"CommonImportAndExport_20", (String)"pccs-placs-business", (Object[])new Object[0]), splitDisplay.get(1), nameStrs[i]));
                    }
                } else if (StringUtils.isEmpty((CharSequence)nameStr) && StringUtils.isNotBlank((CharSequence)numberStr)) {
                    String[] numberStrs = numberStr.split(";|\uff1b");
                    DynamicObjectCollection baseDataList = new DynamicObjectCollection();
                    for (int i = 0; i < numberStrs.length; ++i) {
                        QFilter numberFilter = new QFilter("number", "=", (Object)numberStrs[i]);
                        DynamicObject baseData = BusinessDataServiceHelper.loadSingle((String)entityName, (String)"id,number,name", (QFilter[])new QFilter[]{numberFilter, enableFilter});
                        if (baseData != null) continue;
                        errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u5b58\u5728\u201c%1$s\u201d=\u201c%2$s\u201d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"CommonImportAndExport_20", (String)"pccs-placs-business", (Object[])new Object[0]), splitDisplay.get(0), numberStrs[i]));
                    }
                }
            }
        } else {
            entityName = ((BasedataProp)entry.getDataEntityType().getProperties().get((Object)fieldName)).getBaseEntityId();
            QFilter filter = null;
            QFilter[] filters = new QFilter[splitCols.size()];
            if (splitCols != null) {
                for (int j = 0; j < splitCols.size(); ++j) {
                    baseInfo = new JSONObject();
                    if (StringUtils.isNotBlank((Object)dataMap.get(splitCols.get(j)))) {
                        baseInfo.put("name", splitDisplay.get(j));
                        baseInfo.put("value", dataMap.get(splitCols.get(j)));
                        baseDataInfo.add((Object)baseInfo);
                        filters[j] = filter = new QFilter(((String)splitCols.get(j)).split("\\.")[1], "=", dataMap.get(splitCols.get(j)));
                    }
                    ++offset;
                }
            }
            DynamicObject[] baseData = BusinessDataServiceHelper.load((String)entityName, (String)"number,name", (QFilter[])filters);
            String nameFlag = "pretask.name";
            if (StringUtils.equals((CharSequence)"pretask", (CharSequence)fieldName) && dataMap.get(nameFlag) != null) {
                boolean exist = false;
                for (Object jsonData : data) {
                    JSONArray column = (JSONArray)jsonData;
                    Map<String, Object> jsonDataMap = this.getDataMap(column);
                    if (!dataMap.get(nameFlag).equals(jsonDataMap.get(nameFlag))) continue;
                    exist = true;
                }
                if (!exist) {
                    errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u201c%1$s\u201d\u4e3a\u201c%2$s\u201d\u7684\u6570\u636e\u3002", (String)"CommonImportAndExport_32", (String)"pccs-placs-business", (Object[])new Object[0]), ((JSONObject)baseDataInfo.get(0)).get((Object)"name"), ((JSONObject)baseDataInfo.get(0)).get((Object)"value")));
                }
            } else if (baseData.length < 1 && baseDataInfo.size() > 1 && !StringUtils.equals((CharSequence)"pretask", (CharSequence)fieldName)) {
                errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u5b58\u5728\u201c%1$s\u201d=\u201c%2$s\u201d,\u201c%3$s\u201d=\u201c%4$s\u201d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"CommonImportAndExport_19", (String)"pccs-placs-business", (Object[])new Object[0]), ((JSONObject)baseDataInfo.get(0)).get((Object)"name"), ((JSONObject)baseDataInfo.get(0)).get((Object)"value"), ((JSONObject)baseDataInfo.get(1)).get((Object)"name"), ((JSONObject)baseDataInfo.get(1)).get((Object)"value")));
            } else if (baseData.length < 1 && baseDataInfo.size() == 1 && !StringUtils.equals((CharSequence)"pretask", (CharSequence)fieldName)) {
                errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u5b58\u5728\u201c%1$s\u201d=\u201c%2$s\u201d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"CommonImportAndExport_20", (String)"pccs-placs-business", (Object[])new Object[0]), ((JSONObject)baseDataInfo.get(0)).get((Object)"name"), ((JSONObject)baseDataInfo.get(0)).get((Object)"value")));
            }
        }
        return offset;
    }

    public JSONArray parseExcelData(String url) {
        JSONArray jsonArray = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            try {
                TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                InputStream in = cache.getInputStream(url);
                XSSFWorkbook xWb = new XSSFWorkbook(in);
                XSSFSheet sheet = xWb.getSheetAt(0);
                int rowNum = sheet.getLastRowNum();
                if (rowNum <= 3) {
                    return jsonArray;
                }
                XSSFRow columnKeyRow = sheet.getRow(2);
                XSSFRow headRow = sheet.getRow(3);
                int columnNum = columnKeyRow.getLastCellNum();
                for (int j = 4; j <= rowNum; ++j) {
                    JSONArray jsonRow = new JSONArray();
                    XSSFRow iRow = sheet.getRow(j);
                    if (iRow == null) continue;
                    for (int i = 1; i < columnNum; ++i) {
                        JSONObject jsonObject = new JSONObject();
                        XSSFCell columnKeyRowCell = columnKeyRow.getCell(i);
                        XSSFCell headRowCell = headRow.getCell(i);
                        headRowCell.setCellType(CellType.STRING);
                        jsonObject.put("columnKey", (Object)columnKeyRowCell.getStringCellValue());
                        jsonObject.put("columnName", (Object)headRowCell.getStringCellValue());
                        XSSFCell cell = iRow.getCell(i);
                        if (cell != null) {
                            if (cell.getCellType() == CellType.NUMERIC) {
                                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                    jsonObject.put("cellValue", (Object)cell.getDateCellValue());
                                } else {
                                    jsonObject.put("cellValue", (Object)cell.getNumericCellValue());
                                }
                            } else {
                                jsonObject.put("cellValue", (Object)cell.getStringCellValue());
                            }
                        } else {
                            jsonObject.put("cellValue", null);
                        }
                        jsonRow.add((Object)jsonObject);
                    }
                    jsonArray.add((Object)jsonRow);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        return jsonArray;
    }

    public void importTemplateCheck(List<ExportWriterFormat> formats, String url) {
        String srcHashCode = this.srcColumnHashCode(formats);
        String excelColumnHashCode = this.getExcelColumnHashCode(url);
        if (!StringUtils.equals((CharSequence)excelColumnHashCode, (CharSequence)srcHashCode)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u7684\u6a21\u677f\u3002", (String)"CommonImportAndExport_33", (String)"pccs-placs-business", (Object[])new Object[0]));
        }
    }

    public String getExcelColumnHashCode(String url) {
        String excelColumnHashCode = null;
        String[] columnKey = null;
        if (StringUtils.isNotBlank((CharSequence)url)) {
            block6: {
                TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                try {
                    InputStream in = cache.getInputStream(url);
                    XSSFWorkbook xWb = new XSSFWorkbook(in);
                    XSSFSheet sheet = xWb.getSheetAt(0);
                    XSSFRow columnKeyRow = sheet.getRow(2);
                    int columnNum = columnKeyRow.getLastCellNum();
                    columnKey = new String[columnNum];
                    for (int i = 0; i < columnNum; ++i) {
                        XSSFCell columnKeyRowCell = columnKeyRow.getCell(i);
                        columnKey[i] = columnKeyRowCell != null ? columnKeyRowCell.getStringCellValue() : null;
                    }
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    if (!"bos.downloadFailed".equals(((KDException)e).getErrorCode().getCode())) break block6;
                    throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"CommonImportAndExport_15", (String)"pccs-placs-business", (Object[])new Object[0]));
                }
            }
            if (columnKey != null) {
                excelColumnHashCode = POIHelper.stringArrayToHash(columnKey);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u201c\u5bfc\u5165\u6587\u4ef6\u201d\u3002", (String)"CommonImportAndExport_34", (String)"pccs-placs-business", (Object[])new Object[0]));
        }
        return excelColumnHashCode;
    }

    public String srcColumnHashCode(List<ExportWriterFormat> formats) {
        String[] columnKey = this.getColumnKeys(formats);
        String srcheadHashCode = POIHelper.stringArrayToHash((String[])columnKey);
        return srcheadHashCode;
    }

    public String[] getColumnKeys(List<ExportWriterFormat> formats) {
        ArrayList<String> columnKeys = new ArrayList<String>(10);
        int headOffset = 0;
        for (ExportWriterFormat format : formats) {
            headOffset = this.obtainColumnKeys(format, headOffset, columnKeys);
        }
        columnKeys.add(0, null);
        String[] columnKey = columnKeys.toArray(new String[columnKeys.size()]);
        return columnKey;
    }

    private int obtainColumnKeys(ExportWriterFormat format, int preOffset, List<String> columnKey) {
        HashMap<String, Integer> index = new HashMap<String, Integer>();
        index.put(STARTINDEX, preOffset);
        int offset = preOffset;
        for (int i = 0; i < format.fields.size(); ++i) {
            String fieldName = (String)format.fields.get(i);
            Map property = (Map)format.properties.get(fieldName);
            Object inputType = null;
            if (property != null) {
                inputType = property.get("InputType");
                if (!"id".equals(inputType) && !"pid".equals(inputType)) {
                    if ("basedata".equals(inputType) || "flex".equals(inputType) || "multilang".equals(inputType) || "largetext".equals(inputType)) {
                        offset = CommonImportAndExport.splitColumnKey(format, property, fieldName, offset, columnKey);
                        continue;
                    }
                } else {
                    fieldName = fieldName.replace('.', '_');
                }
            }
            columnKey.add(fieldName);
            ++offset;
        }
        index.put(ENDINDEX, offset - 1);
        this.entryIndexMap.put(format.name, index);
        for (ExportWriterFormat wr : format.next) {
            offset = this.obtainColumnKeys(wr, offset, columnKey);
        }
        return offset;
    }

    private static int splitColumnKey(ExportWriterFormat format, Map<String, Object> property, String fieldName, int offset, List<String> columnKey) {
        ArrayList splitCols = (ArrayList)format.flexColumn.get(fieldName);
        if ("multilang".equals(property.get("InputType"))) {
            splitCols = new ArrayList();
            List multilang = (List)format.flexColumn.get(fieldName);
            splitCols.add(multilang.get(0));
        }
        if (splitCols != null) {
            for (int j = 0; j < splitCols.size(); ++j) {
                columnKey.add((String)splitCols.get(j));
                ++offset;
            }
        }
        return offset;
    }
}

