/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.business.operation;

import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.pccs.placs.business.base.AbstractPlacsBillAdapter;
import kd.pccs.placs.business.operation.Operation;
import kd.pccs.placs.business.operation.OperationMappingHandler;

public class OperationStrategy {
    private Operation operation;
    private OperationMappingHandler mappingHandler = new OperationMappingHandler();

    public OperationStrategy(String operationType) {
        this.operation = this.choose(operationType);
    }

    public void afterDoOperation(AbstractPlacsBillAdapter formPlugin) {
        if (this.operation != null) {
            this.operation.afterDoOperation(formPlugin);
        }
    }

    public void closedCallBack(AbstractPlacsBillAdapter formPlugin, ClosedCallBackEvent closedCallBackEvent) {
        if (this.operation != null) {
            this.operation.closedCallBack(formPlugin, closedCallBackEvent);
        }
    }

    public void confirmCallBack(AbstractPlacsBillAdapter formPlugin, MessageBoxClosedEvent event) {
        if (this.operation != null) {
            this.operation.confirmCallBack(formPlugin, event);
        }
    }

    private Operation choose(String operationType) {
        return this.mappingHandler.getOperationMapping().get(operationType);
    }
}

