/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.business.operation;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.pccs.placs.business.base.AbstractPlacsBillAdapter;
import kd.pccs.placs.business.operation.ImportOperation;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.utils.SerializeHelper;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;

public class ProImpTaskOperation
implements ImportOperation {
    @Override
    public void afterDoOperation(AbstractPlacsBillAdapter formPlugin) {
        IDataModel dataModel = formPlugin.getModel();
        IFormView view = formPlugin.getView();
        if ((Long)dataModel.getDataEntity().get("id") == 0L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5c1a\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"ProImpTaskOperation_0", (String)"pccs-placs-business", (Object[])new Object[0]));
            return;
        }
        view.showConfirm(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u5c06\u5220\u9664\u73b0\u6709\u4efb\u52a1\u53ca\u4efb\u52a1\u6267\u884c\u8bb0\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProImpTaskOperation_1", (String)"pccs-placs-business", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("proimptask"));
    }

    @Override
    public void confirmCallBack(AbstractPlacsBillAdapter formPlugin, MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (!MessageBoxResult.Yes.equals((Object)result)) {
            return;
        }
        IDataModel dataModel = formPlugin.getModel();
        IFormView view = formPlugin.getView();
        dataModel.deleteEntryData("taskentity");
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        HashMap<String, String> customMap = new HashMap<String, String>(16);
        map.put("formId", MetaDataUtil.getEntityId((String)formPlugin.getAppId(), (String)"impothertaskf7"));
        map.put("customParams", customMap);
        QFilter filter = this.buildTaskFilter(formPlugin);
        map.put("filter", SerializeHelper.serialize((Object)filter));
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, "importprojecttask"));
        StyleCss css = new StyleCss();
        css.setHeight("600px");
        css.setWidth("1200px");
        parameter.getOpenStyle().setInlineStyleCss(css);
        DynamicObject org = (DynamicObject)dataModel.getValue("org");
        String orgId = org.getString("id");
        customMap.put("orgId", orgId);
        customMap.put("billType", "projectplan");
        DynamicObject project = (DynamicObject)dataModel.getValue("project");
        if (project != null) {
            String projectId = project.getString("id");
            customMap.put("proId", projectId);
        }
        view.showForm(parameter);
    }

    @Override
    public void closedCallBack(AbstractPlacsBillAdapter formPlugin, ClosedCallBackEvent closedCallBackEvent) {
    }

    private QFilter buildTaskFilter(AbstractPlacsBillAdapter formPlugin) {
        IDataModel dataModel = formPlugin.getModel();
        QFilter projectTaskFilter = this.getProjectTaskFilter();
        QFilter filterStatus = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter filterLatest = new QFilter("islatest", "=", (Object)"1");
        QFilter filterProject = new QFilter("project", "<>", (Object)0L);
        QFilter relationFilter = new QFilter("relationtask", "=", (Object)0);
        ArrayList<String> importedTaskIds = new ArrayList<String>(10);
        int rowCount = dataModel.getEntryRowCount("taskentity");
        for (int i = 0; i < rowCount; ++i) {
            if (dataModel.getValue("relationtask", i) == null) continue;
            DynamicObject task = (DynamicObject)dataModel.getValue("relationtask", i);
            importedTaskIds.add(task.getPkValue().toString());
        }
        QFilter taskFilter = new QFilter("id", "not in", importedTaskIds);
        return projectTaskFilter.and(filterStatus).and(filterLatest).and(filterProject).and(taskFilter).and(relationFilter);
    }

    private QFilter getProjectTaskFilter() {
        return new QFilter(String.format("%s.%s", "belongplantype", "plantype"), "<>", (Object)PlanTypeEnum.PRIVATEPLAN.getValue());
    }
}

