/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.business.utils.project;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.placs.common.enums.project.ProjectStageEnum;
import kd.pccs.placs.common.enums.project.ProjectStatusEnum;

public class StageStatusHelper {
    private static final String PROJECTSTATUS = "bd_projectstatus";
    private static final String PROJECTSTAGE = "pmbs_projectstage";
    public static final String NUMBER = "number";

    public static void initProStatus(DynamicObject obj) {
        Object pkValue = obj.getPkValue();
        DynamicObject appPro = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"pmas_pro_approval");
        DynamicObject project = appPro.getDynamicObject("pro");
        DynamicObject proKind = appPro.getDynamicObject("kind");
        QFilter filter = new QFilter("projectkind", "=", proKind.getPkValue());
        DynamicObject[] projectstageentries = BusinessDataServiceHelper.load((String)"pmbs_prokindctrlsetting", (String)"projectstageentry,projectstage", (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection stageentry = null;
        if (projectstageentries.length > 0) {
            stageentry = projectstageentries[0].getDynamicObjectCollection("projectstageentry");
        }
        if (stageentry != null && !stageentry.isEmpty()) {
            ArrayList<DynamicObject> prostatus = new ArrayList<DynamicObject>();
            for (DynamicObject entry : stageentry) {
                DynamicObject prosta = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_prostatus"));
                prosta.set("proapproval", pkValue);
                prosta.set("project", project != null ? project.getPkValue() : null);
                prosta.set("projectstage", entry.getDynamicObject("projectstage").getPkValue());
                prosta.set("stagename", (Object)entry.getDynamicObject("projectstage").getString("name"));
                prosta.set("projectstatus", null);
                prostatus.add(prosta);
            }
            SaveServiceHelper.save((DynamicObject[])prostatus.toArray(new DynamicObject[prostatus.size()]));
        }
    }

    public static void changeStatusByApp(DynamicObject proApprove, ProjectStageEnum stage, ProjectStatusEnum status) {
        QFilter filter2;
        QFilter filter1;
        DynamicObject[] stageStatus;
        DynamicObject prostage = null;
        if (stage != null) {
            prostage = BusinessDataServiceHelper.loadSingle((Object)stage.getId(), (String)PROJECTSTAGE);
        }
        DynamicObject prostatus = null;
        if (status != null) {
            prostatus = BusinessDataServiceHelper.loadSingle((Object)status.getId(), (String)PROJECTSTATUS);
        }
        if ((stageStatus = BusinessDataServiceHelper.load((String)"pmas_prostatus", (String)"project, projectstage, projectstatus, remarks, stagename, proapproval", (QFilter[])new QFilter[]{filter1 = new QFilter("proapproval", "=", proApprove.getPkValue()), filter2 = new QFilter("projectstage", "=", prostage == null ? null : prostage.getPkValue())})) != null && stageStatus.length > 0) {
            stageStatus[0].set("projectstatus", prostatus == null ? null : prostatus.getPkValue());
            SaveServiceHelper.save((DynamicObject[])stageStatus);
        }
    }

    public static void relateProject(DynamicObject obj) {
        Object pkValue = obj.getPkValue();
        DynamicObject appPro = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"pmas_pro_approval");
        DynamicObject project = appPro.getDynamicObject("pro");
        QFilter filter = new QFilter("proapproval", "=", pkValue);
        DynamicObject[] stageStatusObjs = BusinessDataServiceHelper.load((String)"pmas_prostatus", (String)"project, projectstage, projectstatus, remarks, stagename, proapproval", (QFilter[])new QFilter[]{filter});
        if (stageStatusObjs != null && stageStatusObjs.length > 0) {
            for (DynamicObject stageStatus : stageStatusObjs) {
                stageStatus.set("project", project.getPkValue());
            }
            SaveServiceHelper.save((DynamicObject[])stageStatusObjs);
        }
    }

    public static void changeStatus(DynamicObject project, ProjectStageEnum stage, ProjectStatusEnum status) {
        QFilter filter2;
        QFilter filter1;
        DynamicObject[] stageStatus;
        DynamicObject prostage = null;
        if (stage != null) {
            prostage = BusinessDataServiceHelper.loadSingle((Object)stage.getId(), (String)PROJECTSTAGE);
        }
        DynamicObject prostatus = null;
        if (status != null) {
            prostatus = BusinessDataServiceHelper.loadSingle((Object)status.getId(), (String)PROJECTSTATUS);
        }
        if ((stageStatus = BusinessDataServiceHelper.load((String)"pmas_prostatus", (String)"project, projectstage, projectstatus, remarks, stagename, proapproval", (QFilter[])new QFilter[]{filter1 = new QFilter("project", "=", project.getPkValue()), filter2 = new QFilter("projectstage", "=", prostage == null ? null : prostage.getPkValue())})) != null && stageStatus.length > 0) {
            stageStatus[0].set("projectstatus", prostatus == null ? null : prostatus.getPkValue());
            SaveServiceHelper.save((DynamicObject[])stageStatus);
        }
    }

    public static void changeProStatus(DynamicObject project, ProjectStatusEnum status, String reason) {
        DynamicObject prostatus = null;
        if (status != null) {
            prostatus = BusinessDataServiceHelper.loadSingle((Object)status.getId(), (String)PROJECTSTATUS);
        }
        DynamicObject pro = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project");
        pro.set("prostatus", prostatus == null ? null : prostatus.getPkValue());
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{pro});
            }
            catch (Throwable e1) {
                h.markRollback();
                throw e1;
            }
        }
        QFilter filter = new QFilter("pro", "=", project.getPkValue());
        DynamicObject[] projectApp = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"id,prostatus,changereason", (QFilter[])new QFilter[]{filter});
        if (projectApp != null && projectApp.length > 0) {
            projectApp[0].set("prostatus", prostatus == null ? null : prostatus.getPkValue());
            projectApp[0].set("changereason", (Object)reason);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{projectApp[0]});
        }
    }

    public static void changeStatusList(List<DynamicObject> projectList, ProjectStageEnum stage, ProjectStatusEnum status) {
        DynamicObject prostage = null;
        if (stage != null) {
            prostage = BusinessDataServiceHelper.loadSingle((Object)stage.getId(), (String)PROJECTSTAGE);
        }
        DynamicObject prostatus = null;
        if (status != null) {
            prostatus = BusinessDataServiceHelper.loadSingle((Object)status.getId(), (String)PROJECTSTATUS);
        }
        for (DynamicObject project : projectList) {
            QFilter filter2;
            QFilter filter1 = new QFilter("project", "=", project.getPkValue());
            DynamicObject[] stageStatus = BusinessDataServiceHelper.load((String)"pmas_prostatus", (String)"project, projectstage, projectstatus, remarks, stagename, proapproval", (QFilter[])new QFilter[]{filter1, filter2 = new QFilter("projectstage", "=", prostage == null ? null : prostage.getPkValue())});
            if (stageStatus == null || stageStatus.length <= 0) continue;
            stageStatus[0].set("projectstatus", prostatus == null ? null : prostatus.getPkValue());
            SaveServiceHelper.save((DynamicObject[])stageStatus);
        }
    }

    public static void changeProStatusList(List<DynamicObject> projectList, ProjectStatusEnum status, String reason) {
        DynamicObject prostatus = null;
        if (status != null) {
            prostatus = BusinessDataServiceHelper.loadSingle((Object)status.getId(), (String)PROJECTSTATUS);
        }
        for (DynamicObject project : projectList) {
            DynamicObject pro = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project");
            pro.set("prostatus", prostatus == null ? null : prostatus.getPkValue());
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{pro});
                }
                catch (Throwable e1) {
                    h.markRollback();
                    throw e1;
                }
            }
            QFilter filter = new QFilter("pro", "=", project.getPkValue());
            DynamicObject[] projectApp = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"id,prostatus,changereason", (QFilter[])new QFilter[]{filter});
            if (projectApp == null || projectApp.length <= 0) continue;
            projectApp[0].set("prostatus", prostatus == null ? null : prostatus.getPkValue());
            projectApp[0].set("changereason", (Object)reason);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{projectApp[0]});
        }
    }
}

