/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.business.utils.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.pccs.placs.common.enums.EnableEnum;

public class DealWithEntryDataUtils {
    public static final String ENTITY_PID = "pid";
    public static final String ENTITY_LEVEL = "level";
    public static final String ENTITY_ISLEAF = "isleaf";

    public static void updateEntryLevelData(DynamicObjectCollection entries) {
        HashMap<Object, List<DynamicObject>> parentToChildMap = new HashMap<Object, List<DynamicObject>>();
        for (DynamicObject entry : entries) {
            Object parentId = entry.getPkValue();
            ArrayList<DynamicObject> childList = (ArrayList<DynamicObject>)parentToChildMap.get(parentId);
            if (childList != null && !childList.isEmpty()) continue;
            childList = new ArrayList<DynamicObject>();
            for (DynamicObject sonTask : entries) {
                if (!StringUtils.equals((CharSequence)sonTask.getString(ENTITY_PID), (CharSequence)parentId.toString())) continue;
                childList.add(sonTask);
            }
            parentToChildMap.put(parentId, childList);
        }
        DynamicObjectCollection newEntries = new DynamicObjectCollection();
        for (DynamicObject entry : entries) {
            Long pid = entry.getLong(ENTITY_PID);
            int level = 1;
            if (pid != 0L) continue;
            DealWithEntryDataUtils.addChildTask(newEntries, parentToChildMap, entry, level);
        }
        entries.clear();
        entries.addAll((Collection)newEntries);
    }

    private static void addChildTask(DynamicObjectCollection newEntries, Map<Object, List<DynamicObject>> parentToChildMap, DynamicObject parentEntity, int level) {
        List<DynamicObject> childList = parentToChildMap.get(parentEntity.getPkValue());
        if (!childList.isEmpty()) {
            parentEntity.set(ENTITY_LEVEL, (Object)level);
            parentEntity.set(ENTITY_ISLEAF, (Object)EnableEnum.DISABLE.getValue());
            newEntries.add((Object)parentEntity);
            ++level;
            for (DynamicObject child : childList) {
                DealWithEntryDataUtils.addChildTask(newEntries, parentToChildMap, child, level);
            }
        } else {
            parentEntity.set(ENTITY_LEVEL, (Object)level);
            parentEntity.set(ENTITY_ISLEAF, (Object)EnableEnum.ENABLE.getValue());
            newEntries.add((Object)parentEntity);
        }
    }
}

