/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.business.utils.task;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.pccs.placs.business.excelimport.CommonDataExporter;
import kd.pccs.placs.business.excelimport.CommonImportAndExport;
import kd.pccs.placs.business.utils.task.TaskUtil;
import kd.pccs.placs.common.utils.DateUtil;

public class DeptPlanTaskImpAndExpUtil
extends CommonImportAndExport {
    protected IFormView view;

    public DeptPlanTaskImpAndExpUtil() {
    }

    public DeptPlanTaskImpAndExpUtil(IFormView view) {
        this.view = view;
    }

    protected String[] getHiddenColumnKey() {
        return new String[]{"level", "isleaf", "percent", "status", "relationtask", "coopersontx", "coodepttx", "achievementnode", "islatest", "prechangetask", "sourcetask", "taskversion", "taskprojecttx", "completionstatus", "taskmubiaotx", "tasktimepctx", "belongplantype", "sourcetask", "prechangetask", "islatest", "taskcontrolleveltx", "majortype", "realendtime", "expecttime", "tasksource", "transactiontype", "completedescription", "meetassigncount", "realtimedeviation"};
    }

    public void exportDeptModel(IFormView view, boolean isExportData, String entryKey) {
        String parentPageId = null;
        String entityNumber = null;
        if (isExportData) {
            parentPageId = view.getPageId();
            entityNumber = view.getEntityId();
        } else {
            parentPageId = view.getParentView().getPageId();
            entityNumber = view.getParentView().getEntityId();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("parentpageid", parentPageId);
        params.put("isExportData", isExportData);
        params.put("entitynumber", entityNumber);
        params.put("entryKey", entryKey);
        String url = this.executeExportTask(params);
        view.download(url);
        view.showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6210\u529f\u3002", (String)"DeptPlanTaskImpAndExpUtil_0", (String)"pccs-placs-business", (Object[])new Object[0]), Integer.valueOf(2000));
    }

    @Override
    public String executeExportTask(Map<String, Object> params) throws KDException {
        this.params.putAll(params);
        boolean exportData = (Boolean)this.params.get("isExportData");
        this.formator = this.loadExportFormat();
        ArrayList<ExportWriterFormat> formats = new ArrayList<ExportWriterFormat>(10);
        formats.add(this.formator);
        CommonDataExporter exporter = new CommonDataExporter("sheet1", formats);
        String fileName = this.genDataExportFileName(LocalDate.now());
        if (exportData) {
            this.exportData(exporter, formats);
        }
        String url = exporter.flush(fileName, 5000);
        return url;
    }

    @Override
    public ExportWriterFormat loadExportFormat() {
        MetadataService metaService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String formatJson = metaService.getExportWriter(this.getEntityNumber(), 0L, null, null);
        List formats = JSONObject.parseArray((String)formatJson, ExportWriterFormat.class);
        ExportWriterFormat format = (ExportWriterFormat)formats.get(0);
        ExportWriterFormat entryFormat = null;
        for (ExportWriterFormat format1 : format.next) {
            if (!format1.name.equals(this.getEntryKey())) continue;
            entryFormat = format1;
            break;
        }
        if (entryFormat != null) {
            entryFormat.fields.remove("tasknametx");
            entryFormat.fields.add(0, "tasknametx");
            this.params.put("name", "tasknametx");
            entryFormat.fields.add(1, "parent");
            HashMap<String, String> parentValue = new HashMap<String, String>();
            parentValue.put("InputType", "multilang");
            parentValue.put("MustInput", "false");
            parentValue.put("DisplayName", ResManager.loadKDString((String)"\u4e0a\u7ea7\u540d\u79f0", (String)"DeptPlanTaskImpAndExpUtil_1", (String)"pccs-placs-business", (Object[])new Object[0]));
            parentValue.put("DataKey", (String)((Map)entryFormat.properties.get("tasknametx")).get("DataKey"));
            parentValue.put("propName", "parent");
            entryFormat.properties.put("parent", parentValue);
            ArrayList<String> parentColumn = new ArrayList<String>(1);
            parentColumn.add("parent");
            entryFormat.flexColumn.put("parent", parentColumn);
            ArrayList<String> parentDisplay = new ArrayList<String>(1);
            parentDisplay.add(ResManager.loadKDString((String)"\u4e0a\u7ea7\u540d\u79f0", (String)"DeptPlanTaskImpAndExpUtil_1", (String)"pccs-placs-business", (Object[])new Object[0]));
            entryFormat.flexColumnDisplay.put("parent", parentDisplay);
            ArrayList<String> parentDesc = new ArrayList<String>(1);
            parentDesc.add(ResManager.loadKDString((String)"\u6587\u672c", (String)"DeptPlanTaskImpAndExpUtil_2", (String)"pccs-placs-business", (Object[])new Object[0]));
            entryFormat.flexColumnDesc.put("parent", parentDesc);
            this.columnHidden(entryFormat);
            ArrayList<ExportWriterFormat> removeSubs = new ArrayList<ExportWriterFormat>();
            for (ExportWriterFormat subFormat : entryFormat.next) {
                if (!subFormat.name.equals("taskreferdocentry") && !subFormat.name.equals("taskresultdocentry")) continue;
                removeSubs.add(subFormat);
            }
            if (removeSubs != null) {
                entryFormat.next.removeAll(removeSubs);
            }
            this.updateMustInputFieds(entryFormat);
            int index = entryFormat.fields.indexOf("respersontx");
            entryFormat.fields.remove("resdepttx");
            entryFormat.fields.add(index + 1, "resdepttx");
            this.updateMulBasedataTips(entryFormat);
        }
        return entryFormat;
    }

    public void updateMustInputFieds(ExportWriterFormat entryFormat) {
        ((Map)entryFormat.properties.get("taskstarttimetx")).put("MustInput", false);
        ((Map)entryFormat.properties.get("taskendtimetx")).put("MustInput", false);
        ((Map)entryFormat.properties.get("respersontx")).put("MustInput", false);
        ((Map)entryFormat.properties.get("resdepttx")).put("MustInput", false);
    }

    public void updateMulBasedataTips(ExportWriterFormat entryFormat) {
        ArrayList<String> tips = new ArrayList<String>();
        tips.add(0, ResManager.loadKDString((String)"\u591a\u4e2a\u57fa\u7840\u8d44\u6599\u7528\u5206\u53f7\uff08;\uff09\u5206\u9694\uff0c\u652f\u6301\u5f55\u5165\u7f16\u7801\u3002", (String)"DeptPlanTaskImpAndExpUtil_7", (String)"pccs-placs-business", (Object[])new Object[0]));
        tips.add(1, ResManager.loadKDString((String)"\u591a\u4e2a\u57fa\u7840\u8d44\u6599\u7528\u5206\u53f7\uff08;\uff09\u5206\u9694\uff0c\u652f\u6301\u5f55\u5165\u540d\u79f0\u3002", (String)"DeptPlanTaskImpAndExpUtil_8", (String)"pccs-placs-business", (Object[])new Object[0]));
        entryFormat.flexColumnDesc.put("multicooperationperson", tips);
        entryFormat.flexColumnDesc.put("multicooperationdept", tips);
        entryFormat.flexColumnDesc.put("transactiontype", tips);
    }

    public void columnHidden(ExportWriterFormat entryFormat) {
        String[] hiddengetColumn = this.getHiddenColumnKey();
        List<String> columnList = Arrays.asList(hiddengetColumn);
        for (String column : columnList) {
            entryFormat.fields.remove(column);
        }
    }

    public DynamicObjectCollection importPlanTask(IFormView view, String url, String appId, String entryKey) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("parentpageid", view.getPageId());
        params.put("url", url);
        params.put("appId", appId);
        params.put("entitynumber", view.getEntityId());
        params.put("entryKey", entryKey);
        DynamicObjectCollection entrys = this.executeImportTask(params);
        DynamicObject entrysdt = this.parentView.getModel().getDataEntity();
        if (entrys != null) {
            String selRule = (String)view.getFormShowParameter().getCustomParam("selRule");
            DynamicObject dept = entrysdt.getDynamicObject("org");
            Object orgId = dept.getPkValue();
            if ("1".equals(selRule)) {
                DeptPlanTaskImpAndExpUtil.calculateDeptByDate(view, (List<DynamicObject>)entrys, orgId, appId);
            } else if ("2".equals(selRule)) {
                DeptPlanTaskImpAndExpUtil.calculateDeptByAbsoluteDuration(view, (List<DynamicObject>)entrys, orgId, appId);
            }
        }
        return entrys;
    }

    public static void calculateDeptByDate(IFormView view, List<DynamicObject> taskList, Object orgId, String appId) {
        for (DynamicObject task : taskList) {
            Date planStartTime = task.getDate("taskstarttimetx");
            Date planEndTime = task.getDate("taskendtimetx");
            BigDecimal newAbsoluteDuration = TaskUtil.getDaysBetweenTwoDateByOrg(orgId, planStartTime, planEndTime, appId);
            task.set("taskjdgqtx", (Object)newAbsoluteDuration.add(BigDecimal.ONE));
            DeptPlanTaskImpAndExpUtil.calCompTimeDeviation(view, task, appId);
        }
    }

    public static void calculateDeptByAbsoluteDuration(IFormView view, List<DynamicObject> taskList, Object orgId, String appId) {
        for (DynamicObject task : taskList) {
            Date planStartTime = task.getDate("taskstarttimetx");
            BigDecimal absoluteDuration = task.getBigDecimal("taskjdgqtx");
            Date newPlanEndTime = TaskUtil.getDateAfterAddDaysByOrg(orgId, planStartTime, absoluteDuration.intValue() - 1, appId);
            task.set("taskendtimetx", (Object)newPlanEndTime);
            DeptPlanTaskImpAndExpUtil.calCompTimeDeviation(view, task, appId);
        }
    }

    public static void calCompTimeDeviation(IFormView view, DynamicObject task, String appId) {
        BigDecimal days;
        Date aimFinishTime = task.getDate("taskmubiaotx");
        Date planEndTime = task.getDate("taskendtimetx");
        DynamicObject project = task.getDynamicObject("taskprojecttx");
        if (aimFinishTime == null || planEndTime == null) {
            return;
        }
        if (project != null) {
            try {
                days = TaskUtil.getDaysBetweenTwoDate(project.getPkValue(), planEndTime, aimFinishTime, appId).subtract(BigDecimal.ONE);
            }
            catch (KDBizException e) {
                view.showTipNotification(e.getMessage());
                days = new BigDecimal(DateUtil.getDaysBetweenTwoDate((Date)planEndTime, (Date)aimFinishTime));
            }
        } else {
            days = new BigDecimal(DateUtil.getDaysBetweenTwoDate((Date)planEndTime, (Date)aimFinishTime));
        }
        task.set("comptimedeviation", (Object)days);
    }
}

