/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.business.utils.task;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;

public class FileAttachmentHelper {
    private static final Log LOG = LogFactory.getLog(FileAttachmentHelper.class);

    public static void copyFileFromAToB(String sourceBillFormId, Object sourceBillId, String sourceAttachKey, String destinationBillFormId, Object destinationBillId, String destinationAttachKey) {
        LOG.info("copyFileFromAToB sourceBillFormId\uff1a{}", (Object)sourceBillFormId);
        LOG.info("copyFileFromAToB sourceBillId\uff1a{}", sourceBillId);
        LOG.info("sourceAttachKey sourceAttachKey\uff1a{}", (Object)sourceAttachKey);
        List sourceFileList = AttachmentServiceHelper.getAttachments((String)sourceBillFormId, (Object)sourceBillId, (String)sourceAttachKey);
        FileAttachmentHelper.copyFileToBillByPk(destinationBillFormId, destinationBillId, destinationAttachKey, sourceFileList);
    }

    public static void copyFileToBillByPk(String destinationBillFormId, Object destinationBillId, String destinationAttachKey, List<Map<String, Object>> attachments) {
        LOG.info("copyFileToBillByPk destinationBillFormId\uff1a{}", (Object)destinationBillFormId);
        LOG.info("copyFileToBillByPk destinationBillId\uff1a{}", destinationBillId);
        LOG.info("destinationBillId destinationAttachKey\uff1a{}", (Object)destinationAttachKey);
        LOG.info("copyFileToBillByPk attachments\uff1a{}", attachments);
        ORM orm = ORM.create();
        for (Map<String, Object> attach : attachments) {
            String url;
            String name;
            Timestamp lastModified;
            QFilter[] filters = new QFilter[]{new QFilter("FNUMBER", "=", (Object)attach.get("uid").toString()), new QFilter("FInterID", "=", (Object)destinationBillId.toString()), new QFilter("FBillType", "=", (Object)destinationBillFormId)};
            DynamicObjectCollection dynColl = orm.getByFilter("bos_attachment", filters);
            if (dynColl != null && !dynColl.isEmpty()) {
                for (DynamicObject dyn : dynColl) {
                    lastModified = (Timestamp)attach.get("lastModified");
                    if (lastModified != null) {
                        dyn.set("FModifyTime", (Object)new Date(lastModified.getTime()));
                    } else {
                        dyn.set("FModifyTime", (Object)new Date());
                    }
                    name = (String)attach.get("name");
                    dyn.set("FaliasFileName", (Object)name);
                    dyn.set("FAttachmentName", (Object)name);
                    dyn.set("FExtName", (Object)(name != null ? name.substring(name.lastIndexOf(46) + 1) : ""));
                    dyn.set("FATTACHMENTSIZE", attach.get("size"));
                    url = String.valueOf(attach.get("url"));
                    dyn.set("FFileId", (Object)FileAttachmentHelper.getUrlPath(url));
                    dyn.set("fattachmentpanel", (Object)destinationAttachKey);
                    orm.update(dyn);
                }
                continue;
            }
            DynamicObject dynamicObject = orm.newDynamicObject("bos_attachment");
            dynamicObject.set("id", (Object)orm.genLongId("bos_attachment"));
            dynamicObject.set("FNUMBER", attach.get("uid"));
            dynamicObject.set("FBillType", (Object)destinationBillFormId);
            dynamicObject.set("FInterID", destinationBillId);
            Date today = new Date();
            lastModified = (Timestamp)attach.get("lastModified");
            if (lastModified != null) {
                dynamicObject.set("FModifyTime", (Object)new Date(lastModified.getTime()));
            } else {
                dynamicObject.set("FModifyTime", (Object)today);
            }
            dynamicObject.set("fcreatetime", (Object)new Date((Long)attach.get("createdate")));
            name = (String)attach.get("name");
            dynamicObject.set("FaliasFileName", (Object)name);
            dynamicObject.set("FAttachmentName", (Object)name);
            dynamicObject.set("FExtName", (Object)(name != null ? name.substring(name.lastIndexOf(46) + 1) : ""));
            dynamicObject.set("FATTACHMENTSIZE", attach.get("size"));
            url = String.valueOf(attach.get("url"));
            dynamicObject.set("FFileId", (Object)FileAttachmentHelper.getUrlPath(url));
            dynamicObject.set("FCREATEMEN", attach.get("FCREATEMEN"));
            dynamicObject.set("fdescription", attach.get("description"));
            dynamicObject.set("fattachmentpanel", (Object)destinationAttachKey);
            orm.insert(dynamicObject);
        }
    }

    private static String getUrlPath(String url) {
        String[] urlArr = url.split("path=/");
        try {
            if (urlArr.length > 1) {
                String[] desUrlArr = urlArr[1].split("&kdedcba");
                return URLDecoder.decode(desUrlArr[0], "UTF-8");
            }
            String[] desUrlArr = urlArr[0].split("&kdedcba");
            return URLDecoder.decode(desUrlArr[0], "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

