/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.business.utils.task;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.user.UserServiceHelper;

public class MultiCooperationPersonUtils {
    public static void writeCodeptsByCoPersons(DynamicObjectCollection cooperationPersons, IDataModel model, int rowIndex) {
        List<Long> cooperationDepts = MultiCooperationPersonUtils.getMultiMainOrgIdsByCopersons(cooperationPersons);
        if (rowIndex >= 0) {
            model.setValue("multicooperationdept", (Object)cooperationDepts.toArray(), rowIndex);
        } else {
            model.setValue("multicooperationdept", (Object)cooperationDepts.toArray());
        }
    }

    public static void hostAndCoMustBeDiffer(DynamicObject responsiblePerson, DynamicObjectCollection cooperationPersons) {
        if (responsiblePerson != null && cooperationPersons != null && cooperationPersons.size() > 0) {
            for (DynamicObject coopPerson : cooperationPersons) {
                if (!responsiblePerson.getPkValue().toString().equals(coopPerson.get("fbasedataid_id").toString())) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u4e3b\u529e\u4eba\u548c\u534f\u529e\u4eba\u4e0d\u53ef\u91cd\u590d\u3002", (String)"MultiCooperationPersonUtils_4", (String)"pccs-placs-business", (Object[])new Object[0]));
            }
        }
    }

    public static List<Long> getMultiMainOrgIdsByCopersons(DynamicObjectCollection cooperationPersons) {
        ArrayList<Long> coDeptIds = new ArrayList<Long>(cooperationPersons.size());
        cooperationPersons.forEach(o -> coDeptIds.add(UserServiceHelper.getUserMainOrgId((long)o.getLong("fbasedataid_id"))));
        return coDeptIds;
    }

    public static List<Long> getMultiAllOrgIdsByCopersons(DynamicObjectCollection cooperationPersons) {
        ArrayList<Long> coDeptIds = new ArrayList<Long>(cooperationPersons.size());
        cooperationPersons.forEach(o -> coDeptIds.addAll(UserServiceHelper.getOrgsUserJoin((long)o.getLong("fbasedataid_id"))));
        return coDeptIds;
    }

    public static List<Long> getAllCopersonIdsByCodepts(DynamicObjectCollection cooperationDepts) {
        ArrayList<Long> copersonIds = new ArrayList<Long>();
        if (cooperationDepts != null && cooperationDepts.size() > 0) {
            List codeptIds = cooperationDepts.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList());
            copersonIds.addAll(UserServiceHelper.getAllUsersOfOrg(codeptIds));
        }
        return copersonIds;
    }

    public static void dealBatchModifyPersons(IFormView view, Map<String, Object> dataMap) {
        if (dataMap != null) {
            String batchResPersonId = (String)dataMap.get("directperson");
            String batchResDeptId = (String)dataMap.get("directorg");
            List batchCooPersonIds = (List)dataMap.get("multicooperationperson");
            List batchCooDeptIds = (List)dataMap.get("multicooperationdept");
            TreeEntryGrid grid = (TreeEntryGrid)view.getControl("taskentity");
            int[] selRows = grid.getSelectRows();
            boolean hasTaskOfCompleted = false;
            for (int index : selRows) {
                DynamicObject directPerson;
                BigDecimal percent = (BigDecimal)view.getModel().getValue("percent", index);
                if (percent != null && percent.intValue() == 100) {
                    hasTaskOfCompleted = true;
                    continue;
                }
                if (batchResPersonId != null && batchCooPersonIds != null && batchCooPersonIds.size() > 0) {
                    view.getModel().setValue("responsibleperson", null, index);
                    view.getModel().setValue("multicooperationperson", null, index);
                    view.getModel().setValue("responsibleperson", (Object)batchResPersonId, index);
                    view.getModel().setValue("multicooperationperson", (Object)batchCooPersonIds.toArray(), index);
                }
                if (batchResPersonId != null && (batchCooPersonIds == null || batchCooPersonIds.size() == 0)) {
                    DynamicObjectCollection inDirectPersons = (DynamicObjectCollection)view.getModel().getValue("multicooperationperson", index);
                    List inDirectPersonIds = inDirectPersons.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList());
                    if (inDirectPersons.size() > 0 && inDirectPersonIds.contains(Long.parseLong(batchResPersonId))) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u4e3b\u529e\u4eba\u548c\u534f\u529e\u4eba\u4e0d\u53ef\u91cd\u590d\u3002", (String)"MultiCooperationPersonUtils_4", (String)"pccs-placs-business", (Object[])new Object[0]));
                        view.getModel().setValue("responsibleperson", null, index);
                    } else {
                        view.getModel().setValue("responsibleperson", (Object)batchResPersonId, index);
                    }
                }
                if (batchResPersonId == null && batchCooPersonIds != null && batchCooPersonIds.size() > 0 && (directPerson = (DynamicObject)view.getModel().getValue("responsibleperson", index)) != null) {
                    if (batchCooPersonIds.contains(Long.parseLong(directPerson.getPkValue().toString()))) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u4e3b\u529e\u4eba\u548c\u534f\u529e\u4eba\u4e0d\u53ef\u91cd\u590d\u3002", (String)"MultiCooperationPersonUtils_4", (String)"pccs-placs-business", (Object[])new Object[0]));
                        view.getModel().setValue("multicooperationperson", null, index);
                    } else {
                        view.getModel().setValue("multicooperationperson", (Object)batchCooPersonIds.toArray(), index);
                    }
                }
                if (batchResDeptId != null) {
                    view.getModel().setValue("responsibledept", (Object)batchResDeptId, index);
                }
                if (batchCooDeptIds == null || batchCooDeptIds.size() <= 0) continue;
                view.getModel().setValue("multicooperationdept", (Object)batchCooDeptIds.toArray(), index);
            }
            if (hasTaskOfCompleted) {
                view.showTipNotification(ResManager.loadKDString((String)"\u201c\u6279\u91cf\u4fee\u6539\u4eba\u5458\u201d\u4e0d\u5f71\u54cd\u5df2\u5b8c\u6210\u7684\u4efb\u52a1\u3002", (String)"MultiCooperationPersonUtils_5", (String)"pccs-placs-business", (Object[])new Object[0]));
            }
            grid.selectRows(-1);
        }
    }

    public static void importMultiCooPersonOrDepts(DynamicObject newEntry, String newField, DynamicObject relationTask, String relaField) {
        ORM orm = ORM.create();
        DynamicObjectCollection relaCollect = relationTask.getDynamicObjectCollection(relaField);
        DynamicObjectType relaDT = relaCollect.getDynamicObjectType();
        long[] longIds = orm.genLongIds((IDataEntityType)relaDT, relaCollect.size());
        DynamicObjectCollection newCollect = new DynamicObjectCollection();
        for (int i = 0; i < relaCollect.size(); ++i) {
            DynamicObject personOrDept = (DynamicObject)relaCollect.get(i);
            DynamicObject newPersonOrDept = new DynamicObject(relaDT);
            newPersonOrDept.set("pkid", (Object)longIds[i]);
            newPersonOrDept.set("fbasedataid", personOrDept.get("fbasedataid"));
            newPersonOrDept.set("fbasedataid_id", personOrDept.get("fbasedataid_id"));
            newCollect.add((Object)newPersonOrDept);
        }
        newEntry.set(newField, (Object)newCollect);
    }
}

