/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.business.utils.task;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.CellStyle;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pccs.placs.business.utils.task.TaskUtil;
import kd.pccs.placs.common.enums.LogicalEnum;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;

public class PlanEntryUtil {
    public static DynamicObject cloneTaskToEntry(DynamicObject task, DynamicObjectType dt) {
        DynamicObject entry = new DynamicObject(dt);
        entry.set("id", task.getPkValue());
        entry.set("id", task.getPkValue());
        entry.set("name", (Object)task.getString("name"));
        entry.set("absoluteduration", (Object)task.getBigDecimal("absoluteduration"));
        entry.set("achievementnode", task.get("achievementnode"));
        entry.set("aimfinishtime", task.get("aimfinishtime"));
        entry.set("comptimedeviation", task.get("comptimedeviation"));
        entry.set("controllevel", task.get("controllevel"));
        entry.set("responsibledept", task.get("responsibledept"));
        entry.set("responsibleperson", task.get("responsibleperson"));
        entry.set("cooperationdept", task.get("cooperationdept"));
        entry.set("cooperationperson", task.get("cooperationperson"));
        entry.set("isleaf", task.get("isleaf"));
        entry.set("level", task.get("level"));
        entry.set("pid", task.getDynamicObject("parent") == null ? Integer.valueOf(0) : task.getDynamicObject("parent").getPkValue());
        entry.set("logical", task.get("logical"));
        entry.set("pid", (Object)task.getDynamicObject("parent"));
        entry.set("percent", (Object)task.getBigDecimal("percent"));
        entry.set("planstarttime", task.get("planstarttime"));
        entry.set("planendtime", task.get("planendtime"));
        entry.set("pretask", task.get("prechangetask"));
        entry.set("realendtime", task.get("realendtime"));
        entry.set("relativeduration", task.get("relativeduration"));
        entry.set("specialtype", task.get("majortype"));
        entry.set("number", task.get("number"));
        entry.set("tasktype", task.get("tasktype"));
        return entry;
    }

    public static int getSameLevelChildIndex(IFormView view, IDataModel model, int seq) {
        String parentTaskId = (String)model.getValue("id", seq);
        int lastChildIndex = seq;
        HashSet<String> parentIdSet = new HashSet<String>();
        parentIdSet.add(parentTaskId);
        int rowCount = model.getEntryRowCount("taskentity");
        for (int i = seq + 1; i < rowCount; ++i) {
            String curParentId;
            DynamicObject curParent = (DynamicObject)model.getValue("pid", i);
            String string = curParentId = curParent == null ? "" : curParent.getString("id");
            if (!parentIdSet.contains(curParentId)) break;
            String curTaskId = (String)model.getValue("id", i);
            parentIdSet.add(curTaskId);
            if (!curParentId.equals(parentTaskId)) continue;
            lastChildIndex = i;
            break;
        }
        return lastChildIndex;
    }

    public void beforeEntryF7Select(IFormView view, IDataModel model, BeforeF7SelectEvent arg0, String appId) {
        String propName = arg0.getProperty().getName();
        int curIndex = model.getEntryCurrentRowIndex("taskentity");
        if (curIndex < 0) {
            view.showMessage(ResManager.loadKDStringExt((String)"\u5f53\u524d\u884c\u83b7\u53d6\u5931\u8d25\u3002", (String)"PlanEntryUtil_5", (String)"pccs-placs-business", (Object[])new Object[0]));
            return;
        }
        switch (propName) {
            case "pretask": {
                String taskId = (String)model.getValue("id", curIndex);
                PlanEntryUtil.setPreTaskFilter(arg0, taskId, appId);
                break;
            }
            case "responsibleperson": {
                DynamicObject responsibleDept = (DynamicObject)model.getValue("responsibledept");
                if (responsibleDept == null) break;
                List userIds = UserServiceHelper.getAllUsersOfOrg((long)Long.parseLong(responsibleDept.getPkValue().toString()));
                QFilter userFilter = new QFilter("id", "in", (Object)userIds);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(userFilter);
                break;
            }
            case "responsibledept": {
                DynamicObject responsiblePreson = (DynamicObject)model.getValue("responsibleperson");
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                if (responsiblePreson != null) {
                    List deptIds = UserServiceHelper.getUserDepartment((long)Long.parseLong(responsiblePreson.getPkValue().toString()), (boolean)false);
                    QFilter orgFilter = new QFilter("id", "in", (Object)deptIds);
                    showParameter.getListFilterParameter().setFilter(orgFilter);
                }
                showParameter.setMultiSelect(false);
                break;
            }
            case "cooperationperson": {
                DynamicObject cooperationDept = (DynamicObject)model.getValue("cooperationdept");
                if (cooperationDept == null) break;
                List userIds = UserServiceHelper.getAllUsersOfOrg((long)Long.parseLong(cooperationDept.getPkValue().toString()));
                QFilter userFilter = new QFilter("id", "in", (Object)userIds);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(userFilter);
                break;
            }
            case "cooperationdept": {
                DynamicObject cooperationPreson = (DynamicObject)model.getValue("cooperationperson");
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                if (cooperationPreson != null) {
                    List deptIds = UserServiceHelper.getUserDepartment((long)Long.parseLong(cooperationPreson.getPkValue().toString()), (boolean)false);
                    QFilter orgFilter = new QFilter("id", "in", (Object)deptIds);
                    showParameter.getListFilterParameter().setFilter(orgFilter);
                }
                showParameter.setMultiSelect(false);
                break;
            }
            case "specialtype": {
                DynamicObject projectKind;
                DynamicObject project = (DynamicObject)model.getValue("project");
                if (project == null || (projectKind = this.getProjectKind(project)) == null) break;
                QFilter kindFilter = new QFilter("group", "=", (Object)projectKind.getString("id"));
                QFilter enbleFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(kindFilter.and(enbleFilter));
                break;
            }
        }
    }

    public DynamicObject getProjectKind(DynamicObject project) {
        return project.getDynamicObject("group");
    }

    public static void saveTask(IFormView view, IDataModel model, String appId) {
        int rowCount = model.getEntryRowCount("taskentity");
        DynamicObject[] savedTaskArr = new DynamicObject[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject rowObj = model.getEntryRowEntity("taskentity", i);
            String taskId = (String)model.getValue("id", i);
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)MetaDataUtil.getEntityId((String)appId, (String)"task"));
            task.set("name", (Object)rowObj.getString("name"));
            task.set("number", (Object)rowObj.getString("number"));
            task.set("controllevel", (Object)rowObj.getDynamicObject("controllevel"));
            task.set("majortype", (Object)rowObj.getDynamicObject("specialtype"));
            task.set("tasktype", (Object)rowObj.getDynamicObject("tasktype"));
            task.set("absoluteduration", (Object)rowObj.getBigDecimal("absoluteduration"));
            task.set("pretask", (Object)rowObj.getDynamicObject("pretask"));
            task.set("logical", (Object)rowObj.getString("logical"));
            task.set("parent", (Object)rowObj.getDynamicObject("pid"));
            task.set("level", (Object)rowObj.getBigDecimal("level"));
            task.set("isleaf", (Object)rowObj.getBoolean("isleaf"));
            task.set("relativeduration", (Object)rowObj.getBigDecimal("relativeduration"));
            task.set("planstarttime", (Object)rowObj.getDate("planstarttime"));
            task.set("planendtime", (Object)rowObj.getDate("planendtime"));
            task.set("aimfinishtime", (Object)rowObj.getDate("aimfinishtime"));
            task.set("comptimedeviation", (Object)rowObj.getBigDecimal("comptimedeviation"));
            task.set("responsibleperson", (Object)rowObj.getDynamicObject("responsibleperson"));
            task.set("responsibledept", (Object)rowObj.getDynamicObject("responsibledept"));
            task.set("cooperationperson", (Object)rowObj.getDynamicObject("cooperationperson"));
            task.set("cooperationdept", (Object)rowObj.getDynamicObject("cooperationdept"));
            task.set("achievementnode", (Object)rowObj.getString("achievementnode"));
            task.set("taskseq", (Object)(i + 1));
            savedTaskArr[i] = task;
        }
        SaveServiceHelper.save((DynamicObject[])savedTaskArr);
    }

    public static void setRowTaskObj(IFormView view, IDataModel model, DynamicObject task, int seq) {
        model.beginInit();
        model.setValue("name", (Object)task.getString("name"), seq);
        model.setValue("number", (Object)task.getString("number"), seq);
        model.setValue("controllevel", (Object)task.getDynamicObject("controllevel"), seq);
        model.setValue("specialtype", (Object)task.getDynamicObject("majortype"), seq);
        model.setValue("tasktype", (Object)task.getDynamicObject("tasktype"), seq);
        model.setValue("absoluteduration", (Object)task.getBigDecimal("absoluteduration"), seq);
        model.setValue("pretask", (Object)task.getDynamicObject("pretask"), seq);
        model.setValue("pid", (Object)task.getDynamicObject("parent"), seq);
        model.setValue("level", (Object)task.getBigDecimal("level"), seq);
        model.setValue("isleaf", (Object)task.getBoolean("isleaf"), seq);
        model.setValue("relativeduration", (Object)task.getBigDecimal("relativeduration"), seq);
        model.setValue("planstarttime", (Object)task.getDate("planstarttime"), seq);
        model.setValue("planendtime", (Object)task.getDate("planendtime"), seq);
        model.setValue("responsibleperson", (Object)task.getDynamicObject("responsibleperson"), seq);
        model.setValue("responsibledept", (Object)task.getDynamicObject("responsibledept"), seq);
        model.setValue("cooperationperson", (Object)task.getDynamicObject("cooperationperson"), seq);
        model.setValue("cooperationdept", (Object)task.getDynamicObject("cooperationdept"), seq);
        model.setValue("id", (Object)task.getString("id"), seq);
        model.setValue("aimfinishtime", (Object)task.getDate("aimfinishtime"), seq);
        model.setValue("comptimedeviation", (Object)task.getBigDecimal("comptimedeviation"), seq);
        model.setValue("logical", (Object)task.getString("logical"), seq);
        model.setValue("achievementnode", (Object)task.getString("achievementnode"), seq);
        model.setValue("realendtime", (Object)task.getString("realendtime"), seq);
        model.setValue("percent", (Object)task.getString("percent"), seq);
        model.endInit();
        view.updateView("taskentity");
    }

    public static void setRowTaskObjForImp(IFormView view, IDataModel model, DynamicObject task, int seq) {
        model.setValue("id", (Object)task.getString("id"), seq);
        model.setValue("name", (Object)task.getString("name"), seq);
        model.setValue("number", (Object)task.getString("number"), seq);
        model.setValue("controllevel", (Object)task.getDynamicObject("controllevel"), seq);
        model.setValue("specialtype", (Object)task.getDynamicObject("majortype"), seq);
        model.setValue("tasktype", (Object)task.getDynamicObject("tasktype"), seq);
        model.setValue("achievementnode", (Object)task.getString("achievementnode"), seq);
        model.setValue("level", (Object)task.getBigDecimal("level"), seq);
        model.setValue("isleaf", (Object)task.getBoolean("isleaf"), seq);
        model.setValue("comptimedeviation", (Object)task.getBigDecimal("comptimedeviation"), seq);
        model.beginInit();
        model.setValue("absoluteduration", (Object)task.getBigDecimal("absoluteduration"), seq);
        model.setValue("planstarttime", (Object)task.getDate("planstarttime"), seq);
        model.setValue("planendtime", (Object)task.getDate("planendtime"), seq);
        model.setValue("pretask", (Object)task.getDynamicObject("pretask"), seq);
        model.setValue("pid", (Object)task.getDynamicObject("parent"), seq);
        model.setValue("logical", (Object)task.getString("logical"), seq);
        model.setValue("relativeduration", (Object)task.getBigDecimal("relativeduration"), seq);
        model.setValue("aimfinishtime", (Object)task.getDate("aimfinishtime"), seq);
        model.setValue("responsibleperson", (Object)task.getDynamicObject("responsibleperson"), seq);
        model.setValue("responsibledept", (Object)task.getDynamicObject("responsibledept"), seq);
        model.setValue("cooperationperson", (Object)task.getDynamicObject("cooperationperson"), seq);
        model.setValue("cooperationdept", (Object)task.getDynamicObject("cooperationdept"), seq);
        model.endInit();
        view.updateView("absoluteduration", seq);
        view.updateView("planstarttime", seq);
        view.updateView("planendtime", seq);
        view.updateView("pretask", seq);
        view.updateView("pid", seq);
        view.updateView("logical", seq);
        view.updateView("relativeduration", seq);
        view.updateView("aimfinishtime", seq);
        view.updateView("responsibleperson", seq);
        view.updateView("responsibledept", seq);
        view.updateView("cooperationperson", seq);
        view.updateView("cooperationdept", seq);
    }

    public static void updateTaskEntryComTimeDeviationColor(IFormView view, IDataModel model) {
        DynamicObjectCollection taskEntry = model.getEntryEntity("taskentity");
        EntryGrid grid = (EntryGrid)view.getControl("taskentity");
        ArrayList<CellStyle> statusStyles = new ArrayList<CellStyle>(taskEntry.size());
        for (int i = 0; i < taskEntry.size(); ++i) {
            BigDecimal comTimeDeviation = ((DynamicObject)taskEntry.get(i)).getBigDecimal("comptimedeviation");
            CellStyle statusStyle = new CellStyle();
            statusStyle.setRow(i);
            statusStyle.setFieldKey("comptimedeviation");
            if (comTimeDeviation.compareTo(BigDecimal.ZERO) > 0) {
                statusStyle.setForeColor("#00DD2C");
            } else if (comTimeDeviation.compareTo(BigDecimal.ZERO) < 0) {
                statusStyle.setForeColor("#FF0000");
            }
            statusStyles.add(statusStyle);
        }
        grid.setCellStyle(statusStyles);
    }

    public static void calCompTimeDeviation(IFormView view, IDataModel model, int curIndex, String appId) {
        BigDecimal days;
        Date aimFinishTime = (Date)model.getValue("aimfinishtime", curIndex);
        Date planEndTime = (Date)model.getValue("planendtime", curIndex);
        DynamicObject project = (DynamicObject)model.getValue("project");
        if (aimFinishTime == null || planEndTime == null) {
            model.setValue("comptimedeviation", null, curIndex);
            return;
        }
        if (project != null) {
            try {
                days = TaskUtil.getDaysBetweenTwoDate(project.getPkValue(), planEndTime, aimFinishTime, appId).subtract(BigDecimal.ONE);
            }
            catch (KDBizException e) {
                view.showTipNotification(e.getMessage());
                days = new BigDecimal(DateUtil.getDaysBetweenTwoDate((Date)planEndTime, (Date)aimFinishTime));
            }
        } else {
            days = new BigDecimal(DateUtil.getDaysBetweenTwoDate((Date)planEndTime, (Date)aimFinishTime));
        }
        model.setValue("comptimedeviation", (Object)days, curIndex);
        PlanEntryUtil.updateTimeDeviationColor(view, model, curIndex);
        view.updateView("taskentity");
    }

    public static void updateTimeDeviationColor(IFormView view, IDataModel model, int curIndex) {
        BigDecimal comTimeDeviation = (BigDecimal)model.getValue("comptimedeviation", curIndex);
        EntryGrid grid = (EntryGrid)view.getControl("taskentity");
        ArrayList<CellStyle> statusStyles = new ArrayList<CellStyle>();
        CellStyle statusStyle = new CellStyle();
        statusStyle.setRow(curIndex);
        statusStyle.setFieldKey("comptimedeviation");
        if (comTimeDeviation.compareTo(BigDecimal.ZERO) > 0) {
            statusStyle.setForeColor("#00DD2C");
        } else if (comTimeDeviation.compareTo(BigDecimal.ZERO) < 0) {
            statusStyle.setForeColor("#FF0000");
        } else {
            statusStyle.setForeColor("#666");
        }
        statusStyles.add(statusStyle);
        grid.setCellStyle(statusStyles);
    }

    public static void calPlanTimeByPreTaskAndLogical(IFormView view, IDataModel model, int curIndex, String appId) {
        block42: {
            Date preTaskPlanEndTime;
            DynamicObject preTask = (DynamicObject)model.getValue("pretask", curIndex);
            if (preTask == null) {
                return;
            }
            preTask = BusinessDataServiceHelper.loadSingle((Object)preTask.getString("id"), (String)MetaDataUtil.getEntityId((String)appId, (String)"task"));
            int rowCount = model.getEntryRowCount("taskentity");
            if (rowCount == 0) {
                return;
            }
            for (int i = 0; i < rowCount; ++i) {
                String taskId = (String)model.getValue("id", i);
                if (!StringUtils.equals((CharSequence)String.valueOf(preTask.getPkValue()), (CharSequence)taskId)) continue;
                PlanEntryUtil.setRowValToTask(view, model, preTask, i);
            }
            String logical = (String)model.getValue("logical", curIndex);
            BigDecimal absDuration = (BigDecimal)model.getValue("absoluteduration", curIndex);
            DynamicObject project = (DynamicObject)model.getValue("project");
            BigDecimal relativeduration = (BigDecimal)model.getValue("relativeduration");
            if ((relativeduration = relativeduration.add(BigDecimal.ONE)).floatValue() < 0.0f) {
                relativeduration = relativeduration.subtract(BigDecimal.ONE);
            }
            model.beginInit();
            if (StringUtils.equals((CharSequence)LogicalEnum.START_START.getValue(), (CharSequence)logical)) {
                Date preTaskPlanStartTime = preTask.getDate("planstarttime");
                if (preTaskPlanStartTime != null) {
                    if (project != null) {
                        try {
                            Date planStartTime = TaskUtil.getDateAfterAddRelativeDays(project.getPkValue(), preTaskPlanStartTime, relativeduration.intValue(), appId);
                            if (PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planstarttime", planStartTime, appId)) break block42;
                            model.setValue("planstarttime", (Object)planStartTime, curIndex);
                            try {
                                Date planEndTime = TaskUtil.getDateAfterAddDays(project.getPkValue(), planStartTime, absDuration.intValue() - 1, appId);
                                if (!PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planstarttime", planEndTime, appId)) {
                                    model.setValue("planendtime", (Object)planEndTime, curIndex);
                                }
                            }
                            catch (KDBizException e) {
                                view.showTipNotification(e.getMessage());
                                model.setValue("planstarttime", null, curIndex);
                            }
                        }
                        catch (KDBizException e) {
                            view.showTipNotification(e.getMessage());
                            model.setValue("planstarttime", null, curIndex);
                        }
                    } else {
                        Date planStartTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanStartTime, (int)relativeduration.intValue());
                        model.setValue("planstarttime", (Object)planStartTime, curIndex);
                        Date planEndTime = DateUtil.getDateAfterAddDays((Date)planStartTime, (int)(absDuration.intValue() - 1));
                        model.setValue("planendtime", (Object)planEndTime, curIndex);
                    }
                }
            } else if (StringUtils.equals((CharSequence)LogicalEnum.FINISH_START.getValue(), (CharSequence)logical)) {
                Date preTaskPlanEndTime2 = preTask.getDate("planendtime");
                if (preTaskPlanEndTime2 != null) {
                    if (project != null) {
                        try {
                            Date planStartTime = TaskUtil.getDateAfterAddRelativeDays(project.getPkValue(), preTaskPlanEndTime2, relativeduration.intValue(), appId);
                            if (PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planstarttime", planStartTime, appId)) break block42;
                            model.setValue("planstarttime", (Object)planStartTime, curIndex);
                            try {
                                Date planEndTime = TaskUtil.getDateAfterAddDays(project.getPkValue(), planStartTime, absDuration.intValue() - 1, appId);
                                if (!PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planstarttime", planEndTime, appId)) {
                                    model.setValue("planendtime", (Object)planEndTime, curIndex);
                                }
                            }
                            catch (KDBizException e) {
                                view.showTipNotification(e.getMessage());
                                model.setValue("planstarttime", null, curIndex);
                            }
                        }
                        catch (KDBizException e) {
                            view.showTipNotification(e.getMessage());
                            model.setValue("planstarttime", null, curIndex);
                        }
                    } else {
                        Date planStartTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanEndTime2, (int)relativeduration.intValue());
                        model.setValue("planstarttime", (Object)planStartTime, curIndex);
                        Date planEndTime = DateUtil.getDateAfterAddDays((Date)planStartTime, (int)(absDuration.intValue() - 1));
                        model.setValue("planendtime", (Object)planEndTime, curIndex);
                    }
                }
            } else if (StringUtils.equals((CharSequence)LogicalEnum.START_FINISH.getValue(), (CharSequence)logical)) {
                Date preTaskPlanStartTime = preTask.getDate("planstarttime");
                if (preTaskPlanStartTime != null) {
                    if (project != null) {
                        try {
                            Date planEndTime = TaskUtil.getDateAfterAddRelativeDays(project.getPkValue(), preTaskPlanStartTime, relativeduration.intValue(), appId);
                            if (PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planendtime", planEndTime, appId)) break block42;
                            model.setValue("planendtime", (Object)planEndTime, curIndex);
                            try {
                                Date planStartTime = TaskUtil.getDateAfterAddDays(project.getPkValue(), planEndTime, -absDuration.intValue(), appId);
                                if (!PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planstarttime", planStartTime, appId)) {
                                    model.setValue("planstarttime", (Object)planStartTime, curIndex);
                                }
                            }
                            catch (KDBizException e) {
                                view.showTipNotification(e.getMessage());
                                model.setValue("planstarttime", null, curIndex);
                            }
                        }
                        catch (KDBizException e) {
                            view.showTipNotification(e.getMessage());
                            model.setValue("planendtime", null, curIndex);
                        }
                    } else {
                        Date planEndTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanStartTime, (int)relativeduration.intValue());
                        model.setValue("planendtime", (Object)planEndTime, curIndex);
                        Date planStartTime = DateUtil.getDateAfterAddDays((Date)planEndTime, (int)(-absDuration.intValue() + 1));
                        model.setValue("planstarttime", (Object)planStartTime, curIndex);
                    }
                }
            } else if (StringUtils.equals((CharSequence)LogicalEnum.FINISH_FINISH.getValue(), (CharSequence)logical) && (preTaskPlanEndTime = preTask.getDate("planendtime")) != null) {
                if (project != null) {
                    try {
                        Date planEndTime = TaskUtil.getDateAfterAddRelativeDays(project.getPkValue(), preTaskPlanEndTime, relativeduration.intValue(), appId);
                        if (PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planendtime", planEndTime, appId)) break block42;
                        model.setValue("planendtime", (Object)planEndTime, curIndex);
                        try {
                            Date planStartTime = TaskUtil.getDateAfterAddDays(project.getPkValue(), planEndTime, -absDuration.intValue(), appId);
                            if (!PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planstarttime", planStartTime, appId)) {
                                model.setValue("planstarttime", (Object)planStartTime, curIndex);
                            }
                        }
                        catch (KDBizException e) {
                            view.showTipNotification(e.getMessage());
                            model.setValue("planstarttime", null, curIndex);
                        }
                    }
                    catch (KDBizException e) {
                        view.showTipNotification(e.getMessage());
                        model.setValue("planendtime", null, curIndex);
                    }
                } else {
                    Date planEndTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanEndTime, (int)relativeduration.intValue());
                    model.setValue("planendtime", (Object)planEndTime, curIndex);
                    Date planStartTime = DateUtil.getDateAfterAddDays((Date)planEndTime, (int)(-absDuration.intValue() + 1));
                    model.setValue("planstarttime", (Object)planStartTime, curIndex);
                }
            }
        }
        model.endInit();
        PlanEntryUtil.calCompTimeDeviation(view, model, curIndex, appId);
        view.updateView("taskentity");
        PlanEntryUtil.updateTaskEntryComTimeDeviationColor(view, model);
    }

    public static void calMarjorPlanTimeByPreTaskAndLogical(IFormView view, IDataModel model, int curIndex, BigDecimal oldRelativeschedule, String appId) {
        block42: {
            Date preTaskPlanEndTime;
            DynamicObject preTask = (DynamicObject)model.getValue("pretask", curIndex);
            if (preTask == null) {
                return;
            }
            preTask = BusinessDataServiceHelper.loadSingle((Object)preTask.getString("id"), (String)MetaDataUtil.getEntityId((String)appId, (String)"task"));
            int rowCount = model.getEntryRowCount("taskentity");
            if (rowCount == 0) {
                return;
            }
            for (int i = 0; i < rowCount; ++i) {
                String taskId = (String)model.getValue("id", i);
                if (!StringUtils.equals((CharSequence)String.valueOf(preTask.getPkValue()), (CharSequence)taskId)) continue;
                PlanEntryUtil.setRowValToTask(view, model, preTask, i);
            }
            String logical = (String)model.getValue("logical", curIndex);
            BigDecimal absDuration = (BigDecimal)model.getValue("absoluteduration", curIndex);
            DynamicObject project = (DynamicObject)model.getValue("project");
            BigDecimal relativeduration = (BigDecimal)model.getValue("relativeduration");
            if ((relativeduration = relativeduration.add(BigDecimal.ONE)).floatValue() < 0.0f) {
                relativeduration = relativeduration.subtract(BigDecimal.ONE);
            }
            model.beginInit();
            if (StringUtils.equals((CharSequence)LogicalEnum.START_START.getValue(), (CharSequence)logical)) {
                Date preTaskPlanStartTime = preTask.getDate("planstarttime");
                if (preTaskPlanStartTime != null) {
                    if (project != null) {
                        try {
                            Date planStartTime = TaskUtil.getDateAfterAddRelativeDays(project.getPkValue(), preTaskPlanStartTime, relativeduration.intValue(), appId);
                            if (PlanEntryUtil.checkOutMainTaskTime(view, model, curIndex, "planstarttime", planStartTime, oldRelativeschedule, appId)) break block42;
                            model.setValue("planstarttime", (Object)planStartTime, curIndex);
                            try {
                                Date planEndTime = TaskUtil.getDateAfterAddDays(project.getPkValue(), planStartTime, absDuration.intValue() - 1, appId);
                                if (!PlanEntryUtil.checkOutMainTaskTime(view, model, curIndex, "planstarttime", planEndTime, oldRelativeschedule, appId)) {
                                    model.setValue("planendtime", (Object)planEndTime, curIndex);
                                }
                            }
                            catch (KDBizException e) {
                                view.showTipNotification(e.getMessage());
                                model.setValue("planstarttime", null, curIndex);
                            }
                        }
                        catch (KDBizException e) {
                            view.showTipNotification(e.getMessage());
                            model.setValue("planstarttime", null, curIndex);
                        }
                    } else {
                        Date planStartTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanStartTime, (int)relativeduration.intValue());
                        model.setValue("planstarttime", (Object)planStartTime, curIndex);
                        Date planEndTime = DateUtil.getDateAfterAddDays((Date)planStartTime, (int)(absDuration.intValue() - 1));
                        model.setValue("planendtime", (Object)planEndTime, curIndex);
                    }
                }
            } else if (StringUtils.equals((CharSequence)LogicalEnum.FINISH_START.getValue(), (CharSequence)logical)) {
                Date preTaskPlanEndTime2 = preTask.getDate("planendtime");
                if (preTaskPlanEndTime2 != null) {
                    if (project != null) {
                        try {
                            Date planStartTime = TaskUtil.getDateAfterAddRelativeDays(project.getPkValue(), preTaskPlanEndTime2, relativeduration.intValue(), appId);
                            if (PlanEntryUtil.checkOutMainTaskTime(view, model, curIndex, "planstarttime", planStartTime, oldRelativeschedule, appId)) break block42;
                            model.setValue("planstarttime", (Object)planStartTime, curIndex);
                            try {
                                Date planEndTime = TaskUtil.getDateAfterAddDays(project.getPkValue(), planStartTime, absDuration.intValue() - 1, appId);
                                if (!PlanEntryUtil.checkOutMainTaskTime(view, model, curIndex, "planstarttime", planEndTime, oldRelativeschedule, appId)) {
                                    model.setValue("planendtime", (Object)planEndTime, curIndex);
                                }
                            }
                            catch (KDBizException e) {
                                view.showTipNotification(e.getMessage());
                                model.setValue("planstarttime", null, curIndex);
                            }
                        }
                        catch (KDBizException e) {
                            view.showTipNotification(e.getMessage());
                            model.setValue("planstarttime", null, curIndex);
                        }
                    } else {
                        Date planStartTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanEndTime2, (int)relativeduration.intValue());
                        model.setValue("planstarttime", (Object)planStartTime, curIndex);
                        Date planEndTime = DateUtil.getDateAfterAddDays((Date)planStartTime, (int)(absDuration.intValue() - 1));
                        model.setValue("planendtime", (Object)planEndTime, curIndex);
                    }
                }
            } else if (StringUtils.equals((CharSequence)LogicalEnum.START_FINISH.getValue(), (CharSequence)logical)) {
                Date preTaskPlanStartTime = preTask.getDate("planstarttime");
                if (preTaskPlanStartTime != null) {
                    if (project != null) {
                        try {
                            Date planEndTime = TaskUtil.getDateAfterAddRelativeDays(project.getPkValue(), preTaskPlanStartTime, relativeduration.intValue(), appId);
                            if (PlanEntryUtil.checkOutMainTaskTime(view, model, curIndex, "planendtime", planEndTime, oldRelativeschedule, appId)) break block42;
                            model.setValue("planendtime", (Object)planEndTime, curIndex);
                            try {
                                Date planStartTime = TaskUtil.getDateAfterAddDays(project.getPkValue(), planEndTime, -absDuration.intValue(), appId);
                                if (!PlanEntryUtil.checkOutMainTaskTime(view, model, curIndex, "planstarttime", planStartTime, oldRelativeschedule, appId)) {
                                    model.setValue("planstarttime", (Object)planStartTime, curIndex);
                                }
                            }
                            catch (KDBizException e) {
                                view.showTipNotification(e.getMessage());
                                model.setValue("planstarttime", null, curIndex);
                            }
                        }
                        catch (KDBizException e) {
                            view.showTipNotification(e.getMessage());
                            model.setValue("planendtime", null, curIndex);
                        }
                    } else {
                        Date planEndTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanStartTime, (int)relativeduration.intValue());
                        model.setValue("planendtime", (Object)planEndTime, curIndex);
                        Date planStartTime = DateUtil.getDateAfterAddDays((Date)planEndTime, (int)(-absDuration.intValue() + 1));
                        model.setValue("planstarttime", (Object)planStartTime, curIndex);
                    }
                }
            } else if (StringUtils.equals((CharSequence)LogicalEnum.FINISH_FINISH.getValue(), (CharSequence)logical) && (preTaskPlanEndTime = preTask.getDate("planendtime")) != null) {
                if (project != null) {
                    try {
                        Date planEndTime = TaskUtil.getDateAfterAddRelativeDays(project.getPkValue(), preTaskPlanEndTime, relativeduration.intValue(), appId);
                        if (PlanEntryUtil.checkOutMainTaskTime(view, model, curIndex, "planendtime", planEndTime, oldRelativeschedule, appId)) break block42;
                        model.setValue("planendtime", (Object)planEndTime, curIndex);
                        try {
                            Date planStartTime = TaskUtil.getDateAfterAddDays(project.getPkValue(), planEndTime, -absDuration.intValue(), appId);
                            if (!PlanEntryUtil.checkOutMainTaskTime(view, model, curIndex, "planstarttime", planStartTime, oldRelativeschedule, appId)) {
                                model.setValue("planstarttime", (Object)planStartTime, curIndex);
                            }
                        }
                        catch (KDBizException e) {
                            view.showTipNotification(e.getMessage());
                            model.setValue("planstarttime", null, curIndex);
                        }
                    }
                    catch (KDBizException e) {
                        view.showTipNotification(e.getMessage());
                        model.setValue("planendtime", null, curIndex);
                    }
                } else {
                    Date planEndTime = DateUtil.getDateAfterAddDays((Date)preTaskPlanEndTime, (int)relativeduration.intValue());
                    model.setValue("planendtime", (Object)planEndTime, curIndex);
                    Date planStartTime = DateUtil.getDateAfterAddDays((Date)planEndTime, (int)(-absDuration.intValue() + 1));
                    model.setValue("planstarttime", (Object)planStartTime, curIndex);
                }
            }
        }
        model.endInit();
        PlanEntryUtil.calCompTimeDeviation(view, model, curIndex, appId);
        view.updateView("taskentity");
        PlanEntryUtil.updateTaskEntryComTimeDeviationColor(view, model);
    }

    private static boolean newCheckOutMainTaskTime(IFormView view, IDataModel model, int curIndex, String timeField, Date newTime, String appId) {
        if (newTime == null) {
            return false;
        }
        String taskId = (String)model.getValue("id", curIndex);
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)MetaDataUtil.getEntityId((String)appId, (String)"task"), (String)"belongplantype");
        DynamicObject belongplantype = task.getDynamicObject("belongplantype");
        belongplantype = BusinessDataServiceHelper.loadSingle((Object)belongplantype.getString("id"), (String)MetaDataUtil.getEntityId((String)appId, (String)"majortype"), (String)"plantype");
        DynamicObject belongPlanType = task.getDynamicObject("belongplantype");
        if (belongPlanType != null) {
            DynamicObject sourceParentTask;
            DynamicObject sourceParentBelongPlanType;
            String planType = belongPlanType.getString("plantype");
            if (StringUtils.equals((CharSequence)PlanTypeEnum.MAJORPLAN.getValue(), (CharSequence)planType) && (sourceParentBelongPlanType = (sourceParentTask = TaskUtil.getNearestMainPlanParentTask(task, appId)).getDynamicObject("belongplantype")) != null) {
                String sourceTaskPlanType = sourceParentBelongPlanType.getString("plantype");
                if (StringUtils.equals((CharSequence)PlanTypeEnum.MAINPLAN.getValue(), (CharSequence)sourceTaskPlanType)) {
                    Date sourceTaskPlanStartTime = sourceParentTask.getDate("planstarttime");
                    Date sourceTaskPlanEndTime = sourceParentTask.getDate("planendtime");
                    if (sourceTaskPlanStartTime != null && newTime.before(sourceTaskPlanStartTime)) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u4e13\u9879\u4efb\u52a1\u7684\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u4e3b\u9879\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"PlanEntryUtil_6", (String)"pccs-placs-business", (Object[])new Object[0]));
                        model.setValue(timeField, null, curIndex);
                        return true;
                    }
                    if (sourceTaskPlanEndTime != null && newTime.after(sourceTaskPlanEndTime)) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u4e13\u9879\u4efb\u52a1\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u4e3b\u9879\u7684\u4efb\u52a1\u7684\u5b8c\u6210\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"PlanEntryUtil_7", (String)"pccs-placs-business", (Object[])new Object[0]));
                        model.setValue(timeField, null, curIndex);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean checkOutMainTaskTime(IFormView view, IDataModel model, int curIndex, String timeField, Date newTime, BigDecimal oldRelativeschedule, String appId) {
        if (newTime == null) {
            return false;
        }
        String taskId = (String)model.getValue("id", curIndex);
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)MetaDataUtil.getEntityId((String)appId, (String)"task"), (String)"belongplantype");
        DynamicObject belongPlanType = task.getDynamicObject("belongplantype");
        if (belongPlanType != null) {
            DynamicObject sourceParentTask;
            DynamicObject sourceParentBelongPlanType;
            String planType = belongPlanType.getString("plantype");
            if (StringUtils.equals((CharSequence)PlanTypeEnum.MAJORPLAN.getValue(), (CharSequence)planType) && (sourceParentBelongPlanType = (sourceParentTask = TaskUtil.getNearestMainPlanParentTask(task, appId)).getDynamicObject("belongplantype")) != null) {
                String sourceTaskPlanType = sourceParentBelongPlanType.getString("plantype");
                if (StringUtils.equals((CharSequence)PlanTypeEnum.MAINPLAN.getValue(), (CharSequence)sourceTaskPlanType)) {
                    Date sourceTaskPlanStartTime = sourceParentTask.getDate("planstarttime");
                    Date sourceTaskPlanEndTime = sourceParentTask.getDate("planendtime");
                    if (sourceTaskPlanStartTime != null && newTime.before(sourceTaskPlanStartTime)) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u4e13\u9879\u4efb\u52a1\u7684\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u4e3b\u9879\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"PlanEntryUtil_6", (String)"pccs-placs-business", (Object[])new Object[0]));
                        model.setValue("relativeduration", (Object)oldRelativeschedule, curIndex);
                        return true;
                    }
                    if (sourceTaskPlanEndTime != null && newTime.after(sourceTaskPlanEndTime)) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u4e13\u9879\u4efb\u52a1\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u4e3b\u9879\u7684\u4efb\u52a1\u7684\u5b8c\u6210\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"PlanEntryUtil_7", (String)"pccs-placs-business", (Object[])new Object[0]));
                        model.setValue("relativeduration", (Object)oldRelativeschedule, curIndex);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static void calPlanTime(IFormView view, IDataModel model, int curIndex, String changeField, String appId) {
        Date planStartTime = (Date)model.getValue("planstarttime", curIndex);
        BigDecimal absoluteDuration = (BigDecimal)model.getValue("absoluteduration", curIndex);
        Date planEndTime = (Date)model.getValue("planendtime", curIndex);
        DynamicObject project = (DynamicObject)model.getValue("project");
        if (project == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"PlanEntryUtil_3", (String)"pccs-placs-business", (Object[])new Object[0]));
        }
        switch (changeField) {
            case "absoluteduration": {
                DynamicObject preTask = (DynamicObject)model.getValue("pretask", curIndex);
                String logical = (String)model.getValue("logical", curIndex);
                if (preTask != null && (StringUtils.equals((CharSequence)LogicalEnum.FINISH_FINISH.getValue(), (CharSequence)logical) || StringUtils.equals((CharSequence)LogicalEnum.START_FINISH.getValue(), (CharSequence)logical))) {
                    if (planEndTime == null) break;
                    model.beginInit();
                    Date newPlanStartTime = TaskUtil.getDateAfterAddDays(project.getPkValue(), planEndTime, -absoluteDuration.intValue(), appId);
                    if (PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planstarttime", newPlanStartTime, appId)) {
                        return;
                    }
                    model.setValue("planstarttime", (Object)newPlanStartTime, curIndex);
                    model.endInit();
                    view.updateView("taskentity");
                    break;
                }
                if (planStartTime != null) {
                    model.beginInit();
                    Date newPlanEndTime = TaskUtil.getDateAfterAddDays(project.getPkValue(), planStartTime, absoluteDuration.intValue() - 1, appId);
                    if (PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planendtime", newPlanEndTime, appId)) {
                        return;
                    }
                    model.setValue("planendtime", (Object)newPlanEndTime, curIndex);
                    PlanEntryUtil.calCompTimeDeviation(view, model, curIndex, appId);
                    model.endInit();
                    view.updateView("taskentity");
                    break;
                }
                if (planEndTime == null) break;
                model.beginInit();
                Date newPlanStartTime = TaskUtil.getDateAfterAddDays(project.getPkValue(), planEndTime, -absoluteDuration.intValue(), appId);
                if (PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planstarttime", newPlanStartTime, appId)) {
                    return;
                }
                model.setValue("planstarttime", (Object)newPlanStartTime, curIndex);
                model.endInit();
                view.updateView("taskentity");
                break;
            }
            case "planendtime": {
                if (planStartTime != null) {
                    model.beginInit();
                    BigDecimal newAbsoluteDuration = TaskUtil.getDaysBetweenTwoDate(project.getPkValue(), planStartTime, planEndTime, appId);
                    model.setValue("absoluteduration", (Object)newAbsoluteDuration, curIndex);
                    model.endInit();
                    view.updateView("taskentity");
                    break;
                }
                if (absoluteDuration == null || absoluteDuration.compareTo(BigDecimal.ZERO) <= 0) break;
                model.beginInit();
                Date newPlanStartTime = TaskUtil.getDateAfterAddDays(project.getPkValue(), planEndTime, -absoluteDuration.intValue(), appId);
                if (PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planstarttime", newPlanStartTime, appId)) {
                    return;
                }
                model.setValue("planstarttime", (Object)newPlanStartTime, curIndex);
                model.endInit();
                view.updateView("taskentity");
                break;
            }
            case "planstarttime": {
                DynamicObject preTask = (DynamicObject)model.getValue("pretask", curIndex);
                String logical = (String)model.getValue("logical", curIndex);
                if (preTask != null && (StringUtils.equals((CharSequence)LogicalEnum.START_FINISH.getValue(), (CharSequence)logical) || StringUtils.equals((CharSequence)LogicalEnum.FINISH_FINISH.getValue(), (CharSequence)logical))) {
                    preTask = BusinessDataServiceHelper.loadSingle((Object)preTask.getString("id"), (String)MetaDataUtil.getEntityId((String)appId, (String)"task"));
                    if (planEndTime == null) break;
                    model.beginInit();
                    BigDecimal newAbsoluteDuration = TaskUtil.getDaysBetweenTwoDate(project.getPkValue(), planStartTime, planEndTime, appId);
                    model.setValue("absoluteduration", (Object)newAbsoluteDuration, curIndex);
                    model.endInit();
                    view.updateView("taskentity");
                    break;
                }
                if (absoluteDuration != null && absoluteDuration.compareTo(BigDecimal.ZERO) == 0) {
                    if (planEndTime == null) break;
                    model.beginInit();
                    BigDecimal newAbsoluteDuration = TaskUtil.getDaysBetweenTwoDate(project.getPkValue(), planStartTime, planEndTime, appId);
                    model.setValue("absoluteduration", (Object)newAbsoluteDuration, curIndex);
                    model.endInit();
                    view.updateView("taskentity");
                    break;
                }
                if (absoluteDuration == null || absoluteDuration.compareTo(BigDecimal.ZERO) <= 0) break;
                model.beginInit();
                Date newPlanEndTime = TaskUtil.getDateAfterAddDays(project.getPkValue(), planStartTime, absoluteDuration.intValue() - 1, appId);
                if (PlanEntryUtil.newCheckOutMainTaskTime(view, model, curIndex, "planendtime", newPlanEndTime, appId)) {
                    return;
                }
                model.setValue("planendtime", (Object)newPlanEndTime, curIndex);
                model.setValue("planendtime", (Object)newPlanEndTime, curIndex);
                PlanEntryUtil.calCompTimeDeviation(view, model, curIndex, appId);
                model.endInit();
                view.updateView("taskentity");
                break;
            }
        }
    }

    public static void updateEntryTaskTimeWhenCalModify(IFormView view, IDataModel model, String appId) {
        int i;
        int rowCount = model.getEntryRowCount("taskentity");
        if (rowCount == 0) {
            return;
        }
        HashMap<String, Integer> taskIdIndexMap = new HashMap<String, Integer>();
        ArrayList<DynamicObject> referTaskList = new ArrayList<DynamicObject>();
        DynamicObject majorType = model.getDataEntity().getDynamicObject("majortype");
        if (majorType != null) {
            DynamicObject rowTask;
            String taskId;
            int i2;
            majorType = BusinessDataServiceHelper.loadSingle((Object)majorType.getPkValue(), (String)(appId + "_" + "majortype"));
            String planType = majorType.getString("plantype");
            if (StringUtils.equals((CharSequence)PlanTypeEnum.MAINPLAN.getValue(), (CharSequence)planType)) {
                for (i2 = 0; i2 < rowCount; ++i2) {
                    taskId = (String)model.getValue("id", i2);
                    rowTask = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)MetaDataUtil.getEntityId((String)appId, (String)"task"));
                    PlanEntryUtil.setRowValToTask(view, model, rowTask, i2);
                    referTaskList.add(rowTask);
                    taskIdIndexMap.put(taskId, i2);
                }
            } else if (StringUtils.equals((CharSequence)PlanTypeEnum.MAJORPLAN.getValue(), (CharSequence)planType)) {
                for (i2 = 0; i2 < rowCount; ++i2) {
                    taskId = (String)model.getValue("id", i2);
                    rowTask = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)MetaDataUtil.getEntityId((String)appId, (String)"task"));
                    DynamicObject belongPlanType = rowTask.getDynamicObject("belongplantype");
                    if (belongPlanType == null) continue;
                    String taskBelongPlanType = belongPlanType.getString("plantype");
                    if (!StringUtils.equals((CharSequence)PlanTypeEnum.MAJORPLAN.getValue(), (CharSequence)taskBelongPlanType)) continue;
                    PlanEntryUtil.setRowValToTask(view, model, rowTask, i2);
                    referTaskList.add(rowTask);
                    taskIdIndexMap.put(taskId, i2);
                }
            }
        }
        DynamicObject[] referTaskArr = referTaskList.toArray(new DynamicObject[referTaskList.size()]);
        DynamicObject prObject = (DynamicObject)model.getValue("project");
        for (i = 0; i < referTaskArr.length; ++i) {
            Date planStartTime = referTaskArr[i].getDate("planstarttime");
            BigDecimal absoluteDuration = referTaskArr[i].getBigDecimal("absoluteduration");
            Date planEndTime = TaskUtil.getDateAfterAddDays(prObject.getPkValue(), planStartTime, absoluteDuration.intValue() - 1, appId);
            if (!PlanEntryUtil.newCheckOutMainTaskTime(view, model, (Integer)taskIdIndexMap.get(referTaskArr[i].getString("id")), "planendtime", planEndTime, appId)) {
                referTaskArr[i].set("planendtime", (Object)planEndTime);
                Date aimEndTime = referTaskArr[i].getDate("aimfinishtime");
                BigDecimal compTimeDeviation = TaskUtil.getDaysBetweenTwoDate(prObject.getPkValue(), planEndTime, aimEndTime, appId);
                referTaskArr[i].set("comptimedeviation", (Object)compTimeDeviation);
                continue;
            }
            referTaskArr[i].set("planendtime", null);
            referTaskArr[i].set("aimfinishtime", null);
            referTaskArr[i].set("comptimedeviation", (Object)0);
        }
        for (i = 0; i < referTaskArr.length; ++i) {
            TaskUtil.updataAfterTaskTime(referTaskArr, referTaskArr[i], appId);
            TaskUtil.updateParentTaskTime(referTaskArr, referTaskArr[i], appId);
        }
        for (DynamicObject taskObj : referTaskArr) {
            String taskId = taskObj.getString("id");
            int index = (Integer)taskIdIndexMap.get(taskId);
            model.beginInit();
            model.setValue("absoluteduration", taskObj.get("absoluteduration"), index);
            model.setValue("planstarttime", taskObj.get("planstarttime"), index);
            model.setValue("planendtime", taskObj.get("planendtime"), index);
            model.setValue("aimfinishtime", taskObj.get("aimfinishtime"), index);
            model.setValue("comptimedeviation", taskObj.get("comptimedeviation"), index);
            model.endInit();
        }
        SaveServiceHelper.save((DynamicObject[])referTaskArr);
        view.updateView("taskentity");
    }

    public static void updateReferTaskTime(IFormView view, IDataModel model, DynamicObject task, String appId) {
        int rowCount = model.getEntryRowCount("taskentity");
        if (rowCount == 0) {
            return;
        }
        HashMap<String, Integer> taskIdIndexMap = new HashMap<String, Integer>(rowCount);
        DynamicObject[] referTaskArr = new DynamicObject[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject rowTask;
            String taskId = (String)model.getValue("id", i);
            referTaskArr[i] = rowTask = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)MetaDataUtil.getEntityId((String)appId, (String)"task"));
            PlanEntryUtil.setRowValToTask(view, model, rowTask, i);
            taskIdIndexMap.put(taskId, i);
        }
        TaskUtil.updataAfterTaskTime(referTaskArr, task, appId);
        TaskUtil.updateParentTaskTime(referTaskArr, task, appId);
        for (DynamicObject taskObj : referTaskArr) {
            String taskId = taskObj.getString("id");
            int index = (Integer)taskIdIndexMap.get(taskId);
            model.beginInit();
            model.setValue("absoluteduration", taskObj.get("absoluteduration"), index);
            model.setValue("planstarttime", taskObj.get("planstarttime"), index);
            model.setValue("planendtime", taskObj.get("planendtime"), index);
            model.setValue("aimfinishtime", taskObj.get("aimfinishtime"), index);
            model.setValue("comptimedeviation", taskObj.get("comptimedeviation"), index);
            model.endInit();
            view.updateView("absoluteduration", index);
            view.updateView("planstarttime", index);
            view.updateView("planendtime", index);
            view.updateView("aimfinishtime", index);
            view.updateView("comptimedeviation", index);
        }
    }

    public static void updateReferTaskTimeForTreeGrade(IFormView view, IDataModel model, DynamicObject task, String appId) {
        int rowCount = model.getEntryRowCount("taskentity");
        if (rowCount == 0) {
            return;
        }
        HashMap<String, Integer> taskIdIndexMap = new HashMap<String, Integer>(rowCount);
        DynamicObject[] referTaskArr = new DynamicObject[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            String taskId = (String)model.getValue("id", i);
            DynamicObject rowTask = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)MetaDataUtil.getEntityId((String)appId, (String)"task"));
            PlanEntryUtil.setRowValToTask(view, model, rowTask, i);
            referTaskArr[i] = rowTask;
            taskIdIndexMap.put(taskId, i);
        }
        PlanEntryUtil.checkPreTask(view, Arrays.asList(referTaskArr), appId);
        TaskUtil.updataAfterTaskTime(referTaskArr, task, appId);
        TaskUtil.updateParentTaskTime(referTaskArr, task, appId);
        for (DynamicObject taskObj : referTaskArr) {
            String taskId = taskObj.getString("id");
            int index = (Integer)taskIdIndexMap.get(taskId);
            model.beginInit();
            model.setValue("absoluteduration", taskObj.get("absoluteduration"), index);
            model.setValue("planstarttime", taskObj.get("planstarttime"), index);
            model.setValue("planendtime", taskObj.get("planendtime"), index);
            model.setValue("aimfinishtime", taskObj.get("aimfinishtime"), index);
            model.setValue("comptimedeviation", taskObj.get("comptimedeviation"), index);
            model.endInit();
            view.updateView("absoluteduration", index);
            view.updateView("planstarttime", index);
            view.updateView("planendtime", index);
            view.updateView("aimfinishtime", index);
            view.updateView("comptimedeviation", index);
        }
    }

    private static void checkPreTask(IFormView view, List<DynamicObject> taskList, String appId) {
        for (int i = 0; i < taskList.size(); ++i) {
            DynamicObject task = taskList.get(i);
            DynamicObject preTask = task.getDynamicObject("pretask");
            if (preTask == null) continue;
            boolean flag = false;
            boolean flag1 = PlanEntryUtil.preTaskIdInParentIds(view, taskList, preTask.getString("id"), task, appId);
            boolean flag2 = PlanEntryUtil.preTaskIdInAfterTaskIds(taskList, preTask.getString("id"), task);
            if (task.getString("id").equals(preTask.getString("id"))) {
                flag = true;
            }
            if (!flag && !flag1 && !flag2) continue;
            task.set("pretask", null);
            task.set("logical", null);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
        }
    }

    private static boolean preTaskIdInParentIds(IFormView view, List<DynamicObject> taskList, String preTaskId, DynamicObject task, String appId) {
        if (task == null || task.getDynamicObject("parent") == null) {
            return false;
        }
        for (DynamicObject parentTask = task.getDynamicObject("parent"); parentTask != null; parentTask = parentTask.getDynamicObject("parent")) {
            boolean hasUpdate = false;
            for (DynamicObject taskObject : taskList) {
                if (!taskObject.getString("id").equals(parentTask.getString("id"))) continue;
                parentTask = taskObject;
                hasUpdate = true;
                break;
            }
            if (!hasUpdate) {
                parentTask = BusinessDataServiceHelper.loadSingle((Object)parentTask.getString("id"), (String)MetaDataUtil.getEntityId((String)appId, (String)"task"));
            }
            if (!preTaskId.equals(parentTask.getString("id"))) continue;
            return true;
        }
        return false;
    }

    private static boolean preTaskIdInAfterTaskIds(List<DynamicObject> taskList, String preTaskId, DynamicObject task) {
        if (task == null) {
            return false;
        }
        for (DynamicObject curTask : taskList) {
            DynamicObject preTask = curTask.getDynamicObject("pretask");
            if (preTask == null || !preTask.getString("id").equals(task.getString("id"))) continue;
            if (preTaskId.equals(preTask.getString("id"))) {
                return true;
            }
            PlanEntryUtil.preTaskIdInAfterTaskIds(taskList, preTaskId, curTask);
        }
        return false;
    }

    public static void setRowValToTask(IFormView view, IDataModel model, DynamicObject task, int curIndex) {
        BigDecimal absoluteShedule = (BigDecimal)model.getValue("absoluteduration", curIndex);
        BigDecimal relativeSchedule = (BigDecimal)model.getValue("relativeduration", curIndex);
        Date planbegindate = (Date)model.getValue("planstarttime", curIndex);
        Date planenddate = (Date)model.getValue("planendtime", curIndex);
        Date aimfinishtime = (Date)model.getValue("aimfinishtime", curIndex);
        BigDecimal comptimedeviation = (BigDecimal)model.getValue("comptimedeviation", curIndex);
        DynamicObject parentTask = (DynamicObject)model.getValue("pid", curIndex);
        DynamicObject preTask = (DynamicObject)model.getValue("pretask", curIndex);
        task.set("absoluteduration", (Object)absoluteShedule);
        task.set("relativeduration", (Object)relativeSchedule);
        task.set("planstarttime", (Object)planbegindate);
        task.set("planendtime", (Object)planenddate);
        task.set("aimfinishtime", (Object)aimfinishtime);
        task.set("comptimedeviation", (Object)comptimedeviation);
        task.set("parent", (Object)parentTask);
        task.set("pretask", (Object)preTask);
    }

    public static void setPreTaskFilter(BeforeF7SelectEvent arg, String taskId, String appId) {
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            return;
        }
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)MetaDataUtil.getEntityId((String)appId, (String)"task"));
        QFilter mulInPutFilter = new QFilter("name", "is not null", (Object)"").and(new QFilter("planstarttime", "is not null", (Object)"")).and(new QFilter("planendtime", "is not null", (Object)""));
        DynamicObject belongPlanType = task.getDynamicObject("belongplantype");
        Set<Object> parentIdSet = TaskUtil.getParentAndAfterTaskIdSet(task, appId);
        QFilter notParentFilter = new QFilter("id", "not in", parentIdSet);
        QFilter notSelfPkFilter = new QFilter("id", "!=", (Object)taskId);
        QFilter sourceTaskFilter = new QFilter("sourcetask", "=", (Object)"0");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter notFenjieFilter = new QFilter("belongplantype.plantype", "!=", (Object)PlanTypeEnum.DEPTFENJIEPLAN.getValue());
        DynamicObject prObject = task.getDynamicObject("project");
        ListShowParameter showParameter1 = (ListShowParameter)arg.getFormShowParameter();
        if (prObject != null) {
            QFilter projectFilter = new QFilter("project", "=", prObject.getPkValue());
            if (belongPlanType != null) {
                if (StringUtils.equals((CharSequence)PlanTypeEnum.MAJORPLAN.getValue(), (CharSequence)belongPlanType.getString("plantype"))) {
                    DynamicObject[] taskArr = PlanEntryUtil.getThisTaskBelongPlanTask(task, appId);
                    HashSet<Object> thisIdSet = new HashSet<Object>(16);
                    for (DynamicObject thisTask : taskArr) {
                        thisIdSet.add(thisTask.getPkValue());
                    }
                    Set<Object> prePlanTaskIdSet = PlanEntryUtil.getThisTaskBelongPlanPrePlanTaskIdSet(task, appId);
                    QFilter notInPrePlanTaskIdSet = new QFilter("id", "not in", prePlanTaskIdSet);
                    QFilter filter = projectFilter.and(sourceTaskFilter).and(statusFilter).and(notInPrePlanTaskIdSet);
                    QFilter filter2 = new QFilter("id", "in", thisIdSet);
                    QFilter filter3 = filter.or(filter2).and(mulInPutFilter).and(notSelfPkFilter).and(notParentFilter);
                    showParameter1.getListFilterParameter().getQFilters().add(filter3.and(notFenjieFilter));
                } else {
                    Set<Object> taskIdSet = PlanEntryUtil.getThisTaskBelongPlanTaskIdSet(task, appId);
                    QFilter filter = new QFilter("id", "in", taskIdSet);
                    showParameter1.getListFilterParameter().getQFilters().add(filter.and(notSelfPkFilter).and(notParentFilter).and(mulInPutFilter));
                }
            } else {
                showParameter1.getListFilterParameter().getQFilters().add(projectFilter.and(notSelfPkFilter).and(notParentFilter).and(mulInPutFilter));
            }
        } else {
            showParameter1.getListFilterParameter().getQFilters().add(notSelfPkFilter.and(notParentFilter).and(mulInPutFilter));
        }
    }

    public static Set<Object> getThisTaskBelongPlanPrePlanTaskIdSet(DynamicObject task, String appId) {
        HashSet<Object> idSet = new HashSet<Object>();
        return idSet;
    }

    public static DynamicObject[] getThisTaskBelongPlanTask(DynamicObject task, String appId) {
        return new DynamicObject[0];
    }

    public static Set<Object> getThisTaskBelongPlanTaskIdSet(DynamicObject task, String appId) {
        HashSet<Object> idSet = new HashSet<Object>();
        if (task == null) {
            return idSet;
        }
        return idSet;
    }
}

