/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.business.utils.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pccs.placs.business.excelimport.CommonDataExporter;
import kd.pccs.placs.business.excelimport.CommonImportAndExport;
import kd.pccs.placs.business.utils.task.PlanTaskPOIHelper;
import kd.pccs.placs.business.utils.task.TaskUtil;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.DefaultEnum;
import kd.pccs.placs.common.enums.LogicalEnum;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.MatcherUtils;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.common.utils.poi.POIHelper;
import org.apache.commons.lang3.ArrayUtils;

public class PlanTaskImpAndExpUtil
extends CommonImportAndExport {
    protected static final Log logger = LogFactory.getLog(PlanTaskImpAndExpUtil.class);
    protected static final String ERRORINFOCOLUMN = "errorinfo";
    protected static final String TASKSHEET = "tasksheet";
    protected static final String RESULTSHEET = "resultsheet";
    protected IFormView view;

    public PlanTaskImpAndExpUtil() {
    }

    public PlanTaskImpAndExpUtil(IFormView view) {
        this.view = view;
    }

    protected String getFileName(DefaultEnum isNormal) {
        if (DefaultEnum.YES.getValue().equalsIgnoreCase(isNormal.getValue())) {
            return ResManager.loadKDString((String)"\u4efb\u52a1\u6e05\u5355", (String)"PlanTaskImpAndExpUtil_0", (String)"pccs-placs-business", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u679c", (String)"PlanTaskImpAndExpUtil_1", (String)"pccs-placs-business", (Object[])new Object[0]);
    }

    protected String getSheetName(DefaultEnum isNormal) {
        if (DefaultEnum.YES.getValue().equalsIgnoreCase(isNormal.getValue())) {
            return ResManager.loadKDString((String)"\u4efb\u52a1\u6e05\u5355\u5217\u8868", (String)"PlanTaskImpAndExpUtil_2", (String)"pccs-placs-business", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u679c\u5217\u8868", (String)"PlanTaskImpAndExpUtil_3", (String)"pccs-placs-business", (Object[])new Object[0]);
    }

    protected String[] getBusiExtendsColumnKey() {
        return new String[0];
    }

    protected String[] getHiddenColumnKey() {
        return new String[]{"level", "isleaf", "realendtime", "percent", "status", "relationtask", "cooperationperson", "cooperationdept", "achievementnode", "enable", "islatest", "prechangetask", "sourcetask", "tasksource", "taskversion", "taskproject", "completionstatus", "templatetask", "responsiblepost", "associatepost", "expecttime", "aimfinishtime", "comptimedeviation", "completedescription", "number", "belongplantype", "sourcetask", "isrelated", "meetassigncount", "realtimedeviation"};
    }

    protected String[] getNormalCommonColumnKey() {
        return new String[]{"name", "controllevel", "majortype", "tasktype", "achievementnode", "pretask", "logical", "parent", "relativeduration", "absoluteduration", "planstarttime", "planendtime", "aimfinishtime", "responsibleperson", "responsibleperson.number", "responsibledept", "multicooperationperson", "multicooperationperson.number", "multicooperationdept", "relationtask", "id", "comment"};
    }

    protected String[] getUnNormalCommonColumnKey() {
        return new String[]{ERRORINFOCOLUMN, "name", "controllevel", "majortype", "tasktype", "achievementnode", "pretask", "logical", "parent", "relativeduration", "absoluteduration", "planstarttime", "planendtime", "aimfinishtime", "responsibleperson", "responsibleperson.number", "responsibledept", "multicooperationperson", "multicooperationperson.number", "multicooperationdept", "relationtask", "id", "comment"};
    }

    protected String[] getColumnKey(DefaultEnum isNormal) {
        if (DefaultEnum.YES.getValue().equalsIgnoreCase(isNormal.getValue())) {
            return (String[])ArrayUtils.addAll((Object[])this.getNormalCommonColumnKey(), (Object[])this.getBusiExtendsColumnKey());
        }
        return (String[])ArrayUtils.addAll((Object[])this.getUnNormalCommonColumnKey(), (Object[])this.getBusiExtendsColumnKey());
    }

    protected String[] getDeptColumnKey(DefaultEnum isNormal) {
        if (DefaultEnum.YES.getValue().equalsIgnoreCase(isNormal.getValue())) {
            return (String[])ArrayUtils.addAll((Object[])this.getNormalCommonDeptColumnKey(), (Object[])this.getBusiExtendsColumnKey());
        }
        return (String[])ArrayUtils.addAll((Object[])this.getUnNormalCommonDeptColumnKey(), (Object[])this.getBusiExtendsColumnKey());
    }

    protected String[] getNormalCommonDeptColumnKey() {
        return new String[]{"name", "tasktype", "parent", "absoluteduration", "planstarttime", "planendtime", "aimfinishtime", "responsibleperson", "responsibleperson.number", "responsibledept", "multicooperationperson", "multicooperationperson.number", "multicooperationdept", "relationtask", "id"};
    }

    protected String[] getUnNormalCommonDeptColumnKey() {
        return new String[]{ERRORINFOCOLUMN, "name", "tasktype", "parent", "absoluteduration", "planstarttime", "planendtime", "aimfinishtime", "responsibleperson", "responsibleperson.number", "responsibledept", "multicooperationperson", "multicooperationperson.number", "multicooperationdept", "relationtask", "id"};
    }

    protected String[] getExtendsHeads() {
        return new String[0];
    }

    protected String[] getNormalCommonHeads() {
        return new String[]{ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0", (String)"PlanTaskImpAndExpUtil_4", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ba1\u63a7\u7ea7\u522b", (String)"PlanTaskImpAndExpUtil_5", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e13\u4e1a\u7c7b\u578b", (String)"PlanTaskImpAndExpUtil_6", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b", (String)"PlanTaskImpAndExpUtil_7", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6210\u679c\u8282\u70b9", (String)"PlanTaskImpAndExpUtil_8", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u524d\u7f6e\u4efb\u52a1", (String)"PlanTaskImpAndExpUtil_9", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u903b\u8f91\u5173\u7cfb", (String)"PlanTaskImpAndExpUtil_10", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0a\u7ea7", (String)"PlanTaskImpAndExpUtil_11", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u76f8\u5bf9\u5de5\u671f", (String)"PlanTaskImpAndExpUtil_12", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7edd\u5bf9\u5de5\u671f", (String)"PlanTaskImpAndExpUtil_13", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4", (String)"PlanTaskImpAndExpUtil_14", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4", (String)"PlanTaskImpAndExpUtil_15", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5185\u63a7\u5b8c\u6210\u65f6\u95f4", (String)"PlanTaskImpAndExpUtil_16", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u4eba.\u59d3\u540d", (String)"PlanTaskImpAndExpUtil_17", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u4eba.\u5de5\u53f7", (String)"PlanTaskImpAndExpUtil_18", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u4eba\u90e8\u95e8", (String)"PlanTaskImpAndExpUtil_19", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u529e\u4eba.\u59d3\u540d", (String)"PlanTaskImpAndExpUtil_20", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u529e\u4eba.\u5de5\u53f7", (String)"PlanTaskImpAndExpUtil_21", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u529e\u90e8\u95e8", (String)"PlanTaskImpAndExpUtil_22", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5173\u8054\u4efb\u52a1.\u4e3b\u952e", (String)"PlanTaskImpAndExpUtil_23", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1.\u4e3b\u952e", (String)"PlanTaskImpAndExpUtil_24", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5907\u6ce8", (String)"PlanTaskImpAndExpUtil_25", (String)"pccs-placs-business", (Object[])new Object[0])};
    }

    protected String[] getUnNormalCommonHeads() {
        return new String[]{ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u63d0\u793a\u4fe1\u606f", (String)"PlanTaskImpAndExpUtil_26", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0", (String)"PlanTaskImpAndExpUtil_4", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ba1\u63a7\u7ea7\u522b", (String)"PlanTaskImpAndExpUtil_5", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e13\u4e1a\u7c7b\u578b", (String)"PlanTaskImpAndExpUtil_6", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b", (String)"PlanTaskImpAndExpUtil_7", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6210\u679c\u8282\u70b9", (String)"PlanTaskImpAndExpUtil_8", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u524d\u7f6e\u4efb\u52a1", (String)"PlanTaskImpAndExpUtil_9", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u903b\u8f91\u5173\u7cfb", (String)"PlanTaskImpAndExpUtil_10", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0a\u7ea7", (String)"PlanTaskImpAndExpUtil_11", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u76f8\u5bf9\u5de5\u671f", (String)"PlanTaskImpAndExpUtil_12", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7edd\u5bf9\u5de5\u671f", (String)"PlanTaskImpAndExpUtil_13", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4", (String)"PlanTaskImpAndExpUtil_14", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4", (String)"PlanTaskImpAndExpUtil_15", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5185\u63a7\u5b8c\u6210\u65f6\u95f4", (String)"PlanTaskImpAndExpUtil_16", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u4eba.\u59d3\u540d", (String)"PlanTaskImpAndExpUtil_17", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u4eba.\u5de5\u53f7", (String)"PlanTaskImpAndExpUtil_18", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u4eba\u90e8\u95e8", (String)"PlanTaskImpAndExpUtil_19", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u529e\u4eba.\u59d3\u540d", (String)"PlanTaskImpAndExpUtil_20", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u529e\u4eba.\u5de5\u53f7", (String)"PlanTaskImpAndExpUtil_21", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u529e\u90e8\u95e8", (String)"PlanTaskImpAndExpUtil_22", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5173\u8054\u4efb\u52a1.\u4e3b\u952e", (String)"PlanTaskImpAndExpUtil_23", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1.\u4e3b\u952e", (String)"PlanTaskImpAndExpUtil_24", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5907\u6ce8", (String)"PlanTaskImpAndExpUtil_25", (String)"pccs-placs-business", (Object[])new Object[0])};
    }

    protected String[] getHeader(DefaultEnum isNormal) {
        if (DefaultEnum.YES.getValue().equalsIgnoreCase(isNormal.getValue())) {
            return (String[])ArrayUtils.addAll((Object[])this.getNormalCommonHeads(), (Object[])this.getExtendsHeads());
        }
        return (String[])ArrayUtils.addAll((Object[])this.getUnNormalCommonHeads(), (Object[])this.getExtendsHeads());
    }

    protected String[] getDeptHeader(DefaultEnum isNormal) {
        if (DefaultEnum.YES.getValue().equalsIgnoreCase(isNormal.getValue())) {
            return (String[])ArrayUtils.addAll((Object[])this.getNormalCommonDeptHeads(), (Object[])this.getExtendsHeads());
        }
        return (String[])ArrayUtils.addAll((Object[])this.getUnNormalCommonDeptHeads(), (Object[])this.getExtendsHeads());
    }

    protected String[] getNormalCommonDeptHeads() {
        return new String[]{ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0", (String)"PlanTaskImpAndExpUtil_4", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b", (String)"PlanTaskImpAndExpUtil_7", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0a\u7ea7", (String)"PlanTaskImpAndExpUtil_11", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7edd\u5bf9\u5de5\u671f", (String)"PlanTaskImpAndExpUtil_13", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4", (String)"PlanTaskImpAndExpUtil_14", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4", (String)"PlanTaskImpAndExpUtil_15", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5185\u63a7\u5b8c\u6210\u65f6\u95f4", (String)"PlanTaskImpAndExpUtil_16", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u4eba.\u59d3\u540d", (String)"PlanTaskImpAndExpUtil_17", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u4eba.\u5de5\u53f7", (String)"PlanTaskImpAndExpUtil_18", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u4eba\u90e8\u95e8", (String)"PlanTaskImpAndExpUtil_19", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u529e\u4eba.\u59d3\u540d", (String)"PlanTaskImpAndExpUtil_20", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u529e\u4eba.\u5de5\u53f7", (String)"PlanTaskImpAndExpUtil_21", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u529e\u90e8\u95e8", (String)"PlanTaskImpAndExpUtil_22", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5173\u8054\u4efb\u52a1.\u4e3b\u952e", (String)"PlanTaskImpAndExpUtil_23", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1.\u4e3b\u952e", (String)"PlanTaskImpAndExpUtil_24", (String)"pccs-placs-business", (Object[])new Object[0])};
    }

    protected String[] getUnNormalCommonDeptHeads() {
        return new String[]{ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u63d0\u793a\u4fe1\u606f", (String)"PlanTaskImpAndExpUtil_26", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0", (String)"PlanTaskImpAndExpUtil_4", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b", (String)"PlanTaskImpAndExpUtil_7", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0a\u7ea7", (String)"PlanTaskImpAndExpUtil_11", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7edd\u5bf9\u5de5\u671f", (String)"PlanTaskImpAndExpUtil_13", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4", (String)"PlanTaskImpAndExpUtil_14", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4", (String)"PlanTaskImpAndExpUtil_15", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5185\u63a7\u5b8c\u6210\u65f6\u95f4", (String)"PlanTaskImpAndExpUtil_16", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u4eba.\u59d3\u540d", (String)"PlanTaskImpAndExpUtil_17", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u4eba.\u5de5\u53f7", (String)"PlanTaskImpAndExpUtil_18", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u4eba\u90e8\u95e8", (String)"PlanTaskImpAndExpUtil_19", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u529e\u4eba.\u59d3\u540d", (String)"PlanTaskImpAndExpUtil_20", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u529e\u4eba.\u5de5\u53f7", (String)"PlanTaskImpAndExpUtil_21", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u529e\u90e8\u95e8", (String)"PlanTaskImpAndExpUtil_22", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5173\u8054\u4efb\u52a1.\u4e3b\u952e", (String)"PlanTaskImpAndExpUtil_23", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1.\u4e3b\u952e", (String)"PlanTaskImpAndExpUtil_24", (String)"pccs-placs-business", (Object[])new Object[0])};
    }

    protected List<String> getDeptMustFillColumn() {
        return Arrays.asList(ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0", (String)"PlanTaskImpAndExpUtil_4", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b", (String)"PlanTaskImpAndExpUtil_7", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4", (String)"PlanTaskImpAndExpUtil_14", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4", (String)"PlanTaskImpAndExpUtil_15", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u4eba.\u59d3\u540d", (String)"PlanTaskImpAndExpUtil_17", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u90e8\u95e8", (String)"PlanTaskImpAndExpUtil_27", (String)"pccs-placs-business", (Object[])new Object[0]));
    }

    protected List<String> getMustFillColumn() {
        return Arrays.asList(ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0", (String)"PlanTaskImpAndExpUtil_4", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ba1\u63a7\u7ea7\u522b", (String)"PlanTaskImpAndExpUtil_5", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b", (String)"PlanTaskImpAndExpUtil_7", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6210\u679c\u8282\u70b9", (String)"PlanTaskImpAndExpUtil_8", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4", (String)"PlanTaskImpAndExpUtil_14", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4", (String)"PlanTaskImpAndExpUtil_15", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u4eba.\u59d3\u540d", (String)"PlanTaskImpAndExpUtil_17", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u90e8\u95e8", (String)"PlanTaskImpAndExpUtil_27", (String)"pccs-placs-business", (Object[])new Object[0]));
    }

    protected void exportModelExtend(DynamicObject task, JSONObject taskData) {
    }

    public void exportModel(IFormView view, DynamicObjectCollection tasks, String appId) {
        JSONArray data = new JSONArray();
        if (tasks != null) {
            for (DynamicObject task : tasks) {
                JSONObject taskData = new JSONObject();
                taskData.put("name", (Object)task.getLocaleString("name").getLocaleValue());
                DynamicObject controlLevel = task.getDynamicObject("controllevel");
                taskData.put("controllevel", (Object)(controlLevel == null ? "" : controlLevel.getLocaleString("name").getLocaleValue()));
                DynamicObject specType = task.getDynamicObject("majortype");
                taskData.put("majortype", (Object)(specType == null ? "" : specType.getLocaleString("name").getLocaleValue()));
                DynamicObject taskType = task.getDynamicObject("tasktype");
                taskData.put("tasktype", (Object)(taskType == null ? "" : taskType.getLocaleString("name").getLocaleValue()));
                String achievementNode = task.getString("achievementnode");
                taskData.put("achievementnode", (Object)DefaultEnum.getEnumByValue((Object)achievementNode).getName());
                DynamicObject preTask = task.getDynamicObject("pretask");
                taskData.put("pretask", (Object)(preTask == null ? "" : preTask.getLocaleString("name").getLocaleValue()));
                taskData.put("logical", (Object)(StringUtils.isBlank((CharSequence)task.getString("logical")) ? "" : LogicalEnum.getEnumByValue((Object)task.getString("logical")).getName()));
                DynamicObject parent = task.getDynamicObject("parent");
                taskData.put("parent", (Object)(parent == null ? "" : parent.getLocaleString("name").getLocaleValue()));
                taskData.put("relativeduration", (Object)task.getBigDecimal("relativeduration"));
                taskData.put("absoluteduration", (Object)task.getBigDecimal("absoluteduration"));
                taskData.put("planstarttime", (Object)(task.getDate("planstarttime") == null ? "" : this.sdf.format(task.getDate("planstarttime"))));
                taskData.put("planendtime", (Object)(task.getDate("planendtime") == null ? "" : this.sdf.format(task.getDate("planendtime"))));
                taskData.put("aimfinishtime", (Object)(task.getDate("aimfinishtime") == null ? "" : this.sdf.format(task.getDate("aimfinishtime"))));
                DynamicObject directPerson = task.getDynamicObject("responsibleperson");
                taskData.put("responsibleperson", (Object)(directPerson == null ? "" : directPerson.getLocaleString("name").getLocaleValue()));
                taskData.put("responsibleperson.number", (Object)(directPerson == null ? "" : directPerson.getString("number")));
                DynamicObject directOrg = task.getDynamicObject("responsibledept");
                taskData.put("responsibledept", (Object)(directOrg == null ? "" : directOrg.getLocaleString("name").getLocaleValue()));
                DynamicObjectCollection indirectPerson = task.getDynamicObjectCollection("multicooperationperson");
                StringBuilder indirectPersonStr = new StringBuilder();
                indirectPerson.stream().map(o -> indirectPersonStr.append(o == null ? "" : o.getDynamicObject("fbasedataid").getLocaleString("name").getLocaleValue() + ";")).count();
                if (indirectPersonStr.length() > 0) {
                    indirectPersonStr.deleteCharAt(indirectPersonStr.length() - 1);
                }
                taskData.put("multicooperationperson", (Object)indirectPersonStr);
                StringBuilder indirectPersonNumStr = new StringBuilder();
                indirectPerson.stream().map(o -> indirectPersonNumStr.append(o == null ? "" : o.getDynamicObject("fbasedataid").getString("number") + ";")).count();
                if (indirectPersonNumStr.length() > 0) {
                    indirectPersonNumStr.deleteCharAt(indirectPersonNumStr.length() - 1);
                }
                taskData.put("multicooperationperson.number", (Object)indirectPersonNumStr);
                DynamicObjectCollection indirectOrg = task.getDynamicObjectCollection("multicooperationdept");
                StringBuilder indirectOrgStr = new StringBuilder();
                indirectOrg.stream().map(o -> indirectOrgStr.append(o == null ? "" : o.getDynamicObject("fbasedataid").getLocaleString("name").getLocaleValue() + ";")).count();
                if (indirectOrgStr.length() > 0) {
                    indirectOrgStr.deleteCharAt(indirectOrgStr.length() - 1);
                }
                taskData.put("multicooperationdept", (Object)indirectOrgStr);
                DynamicObject relationTask = task.getDynamicObject("relationtask");
                taskData.put("relationtask", relationTask == null ? "" : relationTask.getPkValue());
                taskData.put("id", task.getPkValue());
                taskData.put("comment", (Object)task.getString("comment"));
                this.exportModelExtend(task, taskData);
                data.add((Object)taskData);
            }
        }
        PlanTaskPOIHelper helper = this.getPlanTaskPOIHelper();
        helper.setControlLevelList(this.getControlLevelList());
        helper.setMajorTypeList(this.getMajorTypeList());
        helper.setTaskTypeList(this.getTaskTypeList(appId));
        String url = helper.exportExcel(this.getFileName(DefaultEnum.YES), this.getSheetName(DefaultEnum.YES), this.getHeader(DefaultEnum.YES), this.getColumnKey(DefaultEnum.YES), this.getMustFillColumn(), data);
        view.download(url);
        view.showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6210\u529f\u3002", (String)"PlanTaskImpAndExpUtil_28", (String)"pccs-placs-business", (Object[])new Object[0]), Integer.valueOf(2000));
    }

    public void exportDeptModel(IFormView view, DynamicObjectCollection tasks, String appId) {
        JSONArray data = new JSONArray();
        if (tasks != null) {
            for (DynamicObject task : tasks) {
                JSONObject taskData = new JSONObject();
                taskData.put("name", (Object)task.getLocaleString("name").getLocaleValue());
                DynamicObject taskType = task.getDynamicObject("tasktype");
                taskData.put("tasktype", (Object)(taskType == null ? "" : taskType.getLocaleString("name").getLocaleValue()));
                DynamicObject parent = task.getDynamicObject("parent");
                taskData.put("parent", (Object)(parent == null ? "" : parent.getLocaleString("name").getLocaleValue()));
                taskData.put("absoluteduration", (Object)task.getBigDecimal("absoluteduration"));
                taskData.put("planstarttime", (Object)(task.getDate("planstarttime") == null ? "" : this.sdf.format(task.getDate("planstarttime"))));
                taskData.put("planendtime", (Object)(task.getDate("planendtime") == null ? "" : this.sdf.format(task.getDate("planendtime"))));
                taskData.put("aimfinishtime", (Object)(task.getDate("aimfinishtime") == null ? "" : this.sdf.format(task.getDate("aimfinishtime"))));
                DynamicObject directPerson = task.getDynamicObject("responsibleperson");
                taskData.put("responsibleperson", (Object)(directPerson == null ? "" : directPerson.getLocaleString("name").getLocaleValue()));
                taskData.put("responsibleperson.number", (Object)(directPerson == null ? "" : directPerson.getString("number")));
                DynamicObject directOrg = task.getDynamicObject("responsibledept");
                taskData.put("responsibledept", (Object)(directOrg == null ? "" : directOrg.getLocaleString("name").getLocaleValue()));
                DynamicObjectCollection indirectPersons = task.getDynamicObjectCollection("multicooperationperson");
                StringBuilder indPerStr = new StringBuilder();
                StringBuilder indPerNumStr = new StringBuilder();
                if (indirectPersons != null && indirectPersons.size() > 0) {
                    indirectPersons.stream().map(o -> indPerStr.append(o.getDynamicObject("fbasedataid").getLocaleString("name").getLocaleValue()).append(';')).count();
                    if (indPerStr.length() > 0) {
                        indPerStr.deleteCharAt(indPerStr.length() - 1);
                    }
                    indirectPersons.stream().map(o -> indPerNumStr.append(o.getDynamicObject("fbasedataid").getString("number")).append(';')).count();
                    if (indPerNumStr.length() > 0) {
                        indPerNumStr.deleteCharAt(indPerNumStr.length() - 1);
                    }
                }
                taskData.put("multicooperationperson", (Object)indPerStr);
                taskData.put("multicooperationperson.number", (Object)indPerNumStr);
                DynamicObjectCollection indirectOrgs = task.getDynamicObjectCollection("multicooperationdept");
                StringBuilder indOrgsStr = new StringBuilder();
                if (indirectOrgs != null && indirectOrgs.size() > 0) {
                    indirectOrgs.stream().map(o -> indOrgsStr.append(o.getDynamicObject("fbasedataid").getLocaleString("name").getLocaleValue()).append(';')).count();
                    if (indOrgsStr.length() > 0) {
                        indOrgsStr.deleteCharAt(indOrgsStr.length() - 1);
                    }
                }
                taskData.put("multicooperationdept", (Object)indOrgsStr);
                DynamicObject relationTask = task.getDynamicObject("relationtask");
                taskData.put("relationtask", relationTask == null ? "" : relationTask.getPkValue());
                taskData.put("id", task.getPkValue());
                this.exportModelExtend(task, taskData);
                data.add((Object)taskData);
            }
        }
        PlanTaskPOIHelper helper = this.getPlanTaskPOIHelper();
        helper.setTaskTypeList(this.getTaskTypeList(appId));
        String url = helper.exportExcel(this.getFileName(DefaultEnum.YES), this.getSheetName(DefaultEnum.YES), this.getDeptHeader(DefaultEnum.YES), this.getDeptColumnKey(DefaultEnum.YES), this.getDeptMustFillColumn(), data);
        view.download(url);
        view.showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6210\u529f\u3002", (String)"PlanTaskImpAndExpUtil_28", (String)"pccs-placs-business", (Object[])new Object[0]), Integer.valueOf(2000));
    }

    @Override
    public String executeExportTask(Map<String, Object> params) throws KDException {
        this.params.putAll(params);
        boolean exportData = (Boolean)this.params.get("isExportData");
        this.formator = this.loadExportFormat();
        ArrayList<ExportWriterFormat> formats = new ArrayList<ExportWriterFormat>(10);
        formats.add(this.formator);
        CommonDataExporter exporter = new CommonDataExporter("sheet1", formats);
        String fileName = this.genDataExportFileName(LocalDate.now());
        if (exportData) {
            this.exportData(exporter, formats);
        }
        String url = exporter.flush(fileName, 5000);
        return url;
    }

    @Override
    public ExportWriterFormat loadExportFormat() {
        MetadataService metaService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String formatJson = metaService.getExportWriter(this.getEntityNumber(), 0L, null, null);
        List formats = JSONObject.parseArray((String)formatJson, ExportWriterFormat.class);
        ExportWriterFormat format = (ExportWriterFormat)formats.get(0);
        ExportWriterFormat entryFormat = null;
        for (ExportWriterFormat format1 : format.next) {
            if (!format1.name.equals(this.getEntryKey())) continue;
            entryFormat = format1;
            break;
        }
        if (entryFormat != null) {
            entryFormat.fields.remove("name");
            entryFormat.fields.add(0, "name");
            this.params.put("name", "name");
            entryFormat.fields.add(1, "parent");
            HashMap<String, String> parentValue = new HashMap<String, String>();
            parentValue.put("InputType", "multilang");
            parentValue.put("MustInput", "false");
            parentValue.put("DisplayName", ResManager.loadKDString((String)"\u4e0a\u7ea7\u540d\u79f0", (String)"PlanTaskImpAndExpUtil_72", (String)"pccs-placs-business", (Object[])new Object[0]));
            parentValue.put("DataKey", (String)((Map)entryFormat.properties.get("name")).get("DataKey"));
            parentValue.put("propName", "parent");
            entryFormat.properties.put("parent", parentValue);
            ArrayList<String> parentColumn = new ArrayList<String>(1);
            parentColumn.add("parent");
            entryFormat.flexColumn.put("parent", parentColumn);
            ArrayList<String> parentDisplay = new ArrayList<String>(1);
            parentDisplay.add(ResManager.loadKDString((String)"\u4e0a\u7ea7\u540d\u79f0", (String)"PlanTaskImpAndExpUtil_72", (String)"pccs-placs-business", (Object[])new Object[0]));
            entryFormat.flexColumnDisplay.put("parent", parentDisplay);
            ArrayList<String> parentDesc = new ArrayList<String>(1);
            parentDesc.add(ResManager.loadKDString((String)"\u6587\u672c", (String)"PlanTaskImpAndExpUtil_73", (String)"pccs-placs-business", (Object[])new Object[0]));
            entryFormat.flexColumnDesc.put("parent", parentDesc);
            this.columnHidden(entryFormat);
            ArrayList<ExportWriterFormat> removeSubs = new ArrayList<ExportWriterFormat>();
            for (ExportWriterFormat subFormat : entryFormat.next) {
                if (subFormat.name.equals("taskresultdocentry")) {
                    JSONArray option = new JSONArray();
                    option.add((Object)ResManager.loadKDString((String)"\u662f # true", (String)"PlanTaskImpAndExpUtil_74", (String)"pccs-placs-business", (Object[])new Object[0]));
                    option.add((Object)ResManager.loadKDString((String)"\u5426 # false", (String)"PlanTaskImpAndExpUtil_75", (String)"pccs-placs-business", (Object[])new Object[0]));
                    ((Map)subFormat.properties.get("force")).put("InputType", option);
                    continue;
                }
                if (!subFormat.name.equals("taskreferdocentry")) continue;
                removeSubs.add(subFormat);
            }
            if (removeSubs != null) {
                entryFormat.next.removeAll(removeSubs);
            }
            this.updateMustInputFieds(entryFormat);
            this.updateMulBasedataTips(entryFormat);
        }
        return entryFormat;
    }

    public void updateMustInputFieds(ExportWriterFormat entryFormat) {
        ((Map)entryFormat.properties.get("planstarttime")).put("MustInput", false);
        ((Map)entryFormat.properties.get("planendtime")).put("MustInput", false);
        ((Map)entryFormat.properties.get("responsibleperson")).put("MustInput", false);
        ((Map)entryFormat.properties.get("responsibledept")).put("MustInput", false);
    }

    public void updateMulBasedataTips(ExportWriterFormat entryFormat) {
        ArrayList<String> tips = new ArrayList<String>();
        tips.add(0, ResManager.loadKDString((String)"\u591a\u4e2a\u57fa\u7840\u8d44\u6599\u7528\u5206\u53f7\uff08;\uff09\u5206\u9694\uff0c\u652f\u6301\u5f55\u5165\u7f16\u7801\u3002", (String)"PlanTaskImpAndExpUtil_84", (String)"pccs-placs-business", (Object[])new Object[0]));
        tips.add(1, ResManager.loadKDString((String)"\u591a\u4e2a\u57fa\u7840\u8d44\u6599\u7528\u5206\u53f7\uff08;\uff09\u5206\u9694\uff0c\u652f\u6301\u5f55\u5165\u540d\u79f0\u3002", (String)"PlanTaskImpAndExpUtil_85", (String)"pccs-placs-business", (Object[])new Object[0]));
        entryFormat.flexColumnDesc.put("multicooperationperson", tips);
        entryFormat.flexColumnDesc.put("multicooperationdept", tips);
        entryFormat.flexColumnDesc.put("transactiontype", tips);
    }

    public void columnHidden(ExportWriterFormat entryFormat) {
        String[] hiddengetColumn = this.getHiddenColumnKey();
        List<String> columnList = Arrays.asList(hiddengetColumn);
        for (String column : columnList) {
            entryFormat.fields.remove(column);
        }
    }

    protected PlanTaskPOIHelper getPlanTaskPOIHelper() {
        return new PlanTaskPOIHelper();
    }

    protected Map<String, String> preTaskRelationMap(JSONArray data) {
        HashMap<String, String> maps = new HashMap<String, String>();
        for (Object row : data) {
            JSONArray column = JSONArray.parseArray((String)row.toString());
            String taskId = null;
            String pid = null;
            for (Object columnName : column) {
                JSONObject columnValue = JSONObject.parseObject((String)columnName.toString());
                String cellValue = columnValue.getString("cellValue");
                String columnKey = columnValue.getString("columnKey");
                if ("name".equalsIgnoreCase(columnKey)) {
                    taskId = cellValue;
                    continue;
                }
                if (!"parent".equalsIgnoreCase(columnKey)) continue;
                pid = cellValue;
            }
            maps.put(taskId, pid);
        }
        return maps;
    }

    protected boolean preTaskValid(JSONArray data, String currentRowTaskName, String preTaskName) {
        Map<String, String> preTaskRelation = this.preTaskRelationMap(data);
        ArrayList<String> parentTaskNameList = new ArrayList<String>(10);
        if (preTaskRelation.containsKey(currentRowTaskName)) {
            String parentTaskName = preTaskRelation.get(currentRowTaskName);
            while (StringUtils.isNotBlank((CharSequence)parentTaskName)) {
                parentTaskNameList.add(parentTaskName);
                preTaskRelation.remove(parentTaskName);
                parentTaskName = preTaskRelation.get(parentTaskName);
            }
        }
        return parentTaskNameList.contains(preTaskName);
    }

    protected boolean busiExtendsVail(IFormView view, String columnKey, String cellValue, JSONArray errorMsg) {
        return false;
    }

    public List<DynamicObject> importTask(IFormView view, String url, String appId) {
        String columnKeyHash = POIHelper.stringArrayToHash((String[])this.getColumnKey(DefaultEnum.YES));
        PlanTaskPOIHelper helper = this.getPlanTaskPOIHelper();
        JSONArray data = helper.newInputExcelForTask(url, columnKeyHash);
        if (data == null || data.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\u3002\u8bf7\u68c0\u67e5\u6a21\u677f\u662f\u5426\u5339\u914d\uff0c\u6216\u8005\u5bfc\u5165\u6587\u4ef6\u662f\u5426\u4e3a\u7a7a\u3002", (String)"PlanTaskImpAndExpUtil_87", (String)"pccs-placs-business", (Object[])new Object[0]));
        }
        boolean hasError = false;
        JSONArray errorData = new JSONArray();
        ArrayList<String> nameList = new ArrayList<String>(10);
        for (Object row : data) {
            JSONArray column = JSONArray.parseArray((String)row.toString());
            JSONObject errorInfo = new JSONObject();
            errorInfo.put("columnKey", (Object)ERRORINFOCOLUMN);
            errorInfo.put("columnName", (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u63d0\u793a\u4fe1\u606f", (String)"PlanTaskImpAndExpUtil_26", (String)"pccs-placs-business", (Object[])new Object[0]));
            JSONArray errorMsg = new JSONArray();
            String currentRowTaskName = null;
            String responsiblepersonName = null;
            String responsiblepersonNumber = null;
            String planstarttime = null;
            Iterator iterator = column.iterator();
            while (iterator.hasNext()) {
                String columnKey;
                String cellValue;
                block112: {
                    Object enableFilter;
                    QFilter nameFilter;
                    Object columnName = iterator.next();
                    JSONObject columnValue = JSONObject.parseObject((String)columnName.toString());
                    cellValue = columnValue.getString("cellValue");
                    columnKey = columnValue.getString("columnKey");
                    if ("name".equalsIgnoreCase(columnKey)) {
                        if (StringUtils.isBlank((CharSequence)cellValue)) {
                            errorMsg.add((Object)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4efb\u52a1\u540d\u79f0\u201d\u3002", (String)"PlanTaskImpAndExpUtil_88", (String)"pccs-placs-business", (Object[])new Object[0]));
                            hasError = true;
                        } else if (nameList.contains(cellValue)) {
                            errorMsg.add((Object)ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"PlanTaskImpAndExpUtil_89", (String)"pccs-placs-business", (Object[])new Object[0]));
                            hasError = true;
                        } else if (StringUtils.isNotBlank((CharSequence)cellValue) && cellValue.length() > 50) {
                            errorMsg.add((Object)ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0\u8fc7\u957f\uff0c\u5e94\u8be5\u5c0f\u4e8e50\u4e2a\u5b57\u7b26\u3002", (String)"PlanTaskImpAndExpUtil_32", (String)"pccs-placs-business", (Object[])new Object[0]));
                            hasError = true;
                        } else {
                            currentRowTaskName = cellValue;
                            nameList.add(cellValue);
                        }
                    } else if ("controllevel".equalsIgnoreCase(columnKey)) {
                        if (StringUtils.isBlank((CharSequence)cellValue)) {
                            errorMsg.add((Object)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7ba1\u63a7\u7ea7\u522b\u201d\u3002", (String)"PlanTaskImpAndExpUtil_90", (String)"pccs-placs-business", (Object[])new Object[0]));
                            hasError = true;
                        } else {
                            nameFilter = new QFilter("name", "=", (Object)cellValue);
                            enableFilter = new QFilter("enable", "=", (Object)DefaultEnum.YES.getValue());
                            DynamicObject controlLevel = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)appId, (String)"controllevel"), (String)"", (QFilter[])new QFilter[]{nameFilter, enableFilter});
                            if (controlLevel == null) {
                                errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7ba1\u63a7\u7ea7\u522b\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"PlanTaskImpAndExpUtil_34", (String)"pccs-placs-business", (Object[])new Object[0]), cellValue));
                                hasError = true;
                            }
                        }
                    } else if ("tasktype".equalsIgnoreCase(columnKey)) {
                        if (StringUtils.isBlank((CharSequence)cellValue)) {
                            errorMsg.add((Object)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4efb\u52a1\u7c7b\u578b\u201d\u3002", (String)"PlanTaskImpAndExpUtil_91", (String)"pccs-placs-business", (Object[])new Object[0]));
                            hasError = true;
                        } else {
                            nameFilter = new QFilter("name", "=", (Object)cellValue);
                            enableFilter = new QFilter("enable", "=", (Object)DefaultEnum.YES.getValue());
                            DynamicObject taskType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)appId, (String)"tasktype"), (String)"", (QFilter[])new QFilter[]{nameFilter, enableFilter});
                            if (taskType == null) {
                                errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"PlanTaskImpAndExpUtil_36", (String)"pccs-placs-business", (Object[])new Object[0]), cellValue));
                                hasError = true;
                            }
                        }
                    } else if ("achievementnode".equalsIgnoreCase(columnKey)) {
                        if (StringUtils.isBlank((CharSequence)cellValue)) {
                            errorMsg.add((Object)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u679c\u8282\u70b9\u201d\u3002", (String)"PlanTaskImpAndExpUtil_92", (String)"pccs-placs-business", (Object[])new Object[0]));
                            hasError = true;
                        } else {
                            String achievementNode = DefaultEnum.getEnumByName((Object)cellValue).getValue();
                            if (!DefaultEnum.YES.getValue().equalsIgnoreCase(achievementNode) && !DefaultEnum.NO.getValue().equalsIgnoreCase(achievementNode)) {
                                errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u6210\u679c\u8282\u70b9\u7684\u503c\u53ea\u80fd\u4e3a\u201c%1$s\u201d\u6216\u201c%2$s\u201d\u3002", (String)"PlanTaskImpAndExpUtil_93", (String)"pccs-placs-business", (Object[])new Object[0]), DefaultEnum.YES.getName(), DefaultEnum.NO.getName()));
                                hasError = true;
                            }
                        }
                    } else if ("planstarttime".equalsIgnoreCase(columnKey)) {
                        if (StringUtils.isBlank((CharSequence)cellValue)) {
                            planstarttime = null;
                            errorMsg.add((Object)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u201d\u3002", (String)"PlanTaskImpAndExpUtil_94", (String)"pccs-placs-business", (Object[])new Object[0]));
                            hasError = true;
                        }
                        try {
                            planstarttime = cellValue;
                            Long.parseLong(cellValue);
                        }
                        catch (NumberFormatException e) {
                            try {
                                this.sdf.parse(cellValue);
                            }
                            catch (Exception e1) {
                                errorMsg.add((Object)ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u201d\u683c\u5f0f\u6709\u8bef\u3002", (String)"PlanTaskImpAndExpUtil_95", (String)"pccs-placs-business", (Object[])new Object[0]));
                                hasError = true;
                            }
                        }
                    } else {
                        JSONObject columnValue1;
                        Object columnData;
                        String number;
                        if ("planendtime".equalsIgnoreCase(columnKey)) {
                            if (StringUtils.isBlank((CharSequence)cellValue)) {
                                errorMsg.add((Object)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u201d\u3002", (String)"PlanTaskImpAndExpUtil_96", (String)"pccs-placs-business", (Object[])new Object[0]));
                                hasError = true;
                            }
                            try {
                                Long.parseLong(cellValue);
                            }
                            catch (NumberFormatException e) {
                                try {
                                    this.sdf.parse(cellValue);
                                }
                                catch (Exception e1) {
                                    errorMsg.add((Object)ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u201d\u683c\u5f0f\u6709\u8bef\u3002", (String)"PlanTaskImpAndExpUtil_97", (String)"pccs-placs-business", (Object[])new Object[0]));
                                    hasError = true;
                                }
                            }
                            try {
                                if (planstarttime != null && StringUtils.isNotBlank((CharSequence)cellValue) && this.sdf.parse(cellValue).compareTo(this.sdf.parse(planstarttime)) < 0) {
                                    errorMsg.add((Object)ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u5e94\u665a\u4e8e\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u3002", (String)"PlanTaskImpAndExpUtil_98", (String)"pccs-placs-business", (Object[])new Object[0]));
                                    hasError = true;
                                }
                                break block112;
                            }
                            catch (ParseException e) {
                                if (planstarttime != null && StringUtils.isNotBlank((CharSequence)cellValue) && cellValue.compareTo(planstarttime) < 0) {
                                    errorMsg.add((Object)ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u5e94\u665a\u4e8e\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u3002", (String)"PlanTaskImpAndExpUtil_98", (String)"pccs-placs-business", (Object[])new Object[0]));
                                    hasError = true;
                                }
                                break block112;
                            }
                        }
                        if ("responsibleperson".equalsIgnoreCase(columnKey)) {
                            responsiblepersonName = cellValue;
                            if (StringUtils.isBlank((CharSequence)cellValue)) {
                                errorMsg.add((Object)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8d23\u4efb\u4eba\u201d\u3002", (String)"PlanTaskImpAndExpUtil_99", (String)"pccs-placs-business", (Object[])new Object[0]));
                                hasError = true;
                            } else {
                                DynamicObject[] responsiblePersons;
                                number = null;
                                Iterator e1 = column.iterator();
                                while (e1.hasNext()) {
                                    columnData = e1.next();
                                    columnValue1 = JSONObject.parseObject((String)columnData.toString());
                                    String columnKey1 = columnValue1.getString("columnKey");
                                    if (!columnKey1.equalsIgnoreCase("responsibleperson.number")) continue;
                                    responsiblepersonNumber = number = columnValue1.getString("cellValue");
                                    break;
                                }
                                QFilter nameFilter2 = new QFilter("name", "=", (Object)cellValue);
                                QFilter enableFilter2 = new QFilter("enable", "=", (Object)DefaultEnum.YES.getValue());
                                QFilter numberFilter = null;
                                if (StringUtils.isNotBlank((CharSequence)number)) {
                                    numberFilter = new QFilter("number", "=", (Object)number);
                                }
                                if ((responsiblePersons = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,name,number", (QFilter[])new QFilter[]{nameFilter2, numberFilter, enableFilter2})).length > 1) {
                                    if (StringUtils.isBlank((CharSequence)number)) {
                                        errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5b58\u5728\u591a\u4e2a\u59d3\u540d\u4e3a\u201c%s\u201d\u7684\u8d23\u4efb\u4eba\u3002", (String)"PlanTaskImpAndExpUtil_44", (String)"pccs-placs-business", (Object[])new Object[0]), cellValue));
                                    } else {
                                        errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5b58\u5728\u591a\u4e2a\u59d3\u540d\u4e3a\u201c%1$s\u201d\uff0c\u5de5\u53f7\u4e3a\u201c%2$s\u201d\u7684\u8d23\u4efb\u4eba\u3002", (String)"PlanTaskImpAndExpUtil_79", (String)"pccs-placs-business", (Object[])new Object[0]), cellValue, number));
                                    }
                                    hasError = true;
                                } else if (responsiblePersons.length == 0) {
                                    if (StringUtils.isBlank((CharSequence)number)) {
                                        errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u59d3\u540d\u4e3a\u201c%s\u201d\u7684\u8d23\u4efb\u4eba\u3002", (String)"PlanTaskImpAndExpUtil_46", (String)"pccs-placs-business", (Object[])new Object[0]), cellValue));
                                    } else {
                                        errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u59d3\u540d\u4e3a\u201c%1$s\u201d,\u7f16\u53f7\u4e3a\u201c%2$s\u201d\u7684\u8d23\u4efb\u4eba\u3002", (String)"PlanTaskImpAndExpUtil_80", (String)"pccs-placs-business", (Object[])new Object[0]), cellValue, number));
                                    }
                                    hasError = true;
                                }
                            }
                        } else {
                            String absolutedurationValue;
                            if ("aimfinishtime".equalsIgnoreCase(columnKey)) {
                                if (StringUtils.isBlank((CharSequence)cellValue)) continue;
                                try {
                                    Long.parseLong(cellValue);
                                }
                                catch (NumberFormatException e) {
                                    try {
                                        this.sdf.parse(cellValue);
                                    }
                                    catch (Exception e1) {
                                        errorMsg.add((Object)ResManager.loadKDString((String)"\u201c\u5185\u63a7\u5b8c\u6210\u65f6\u95f4\u201d\u683c\u5f0f\u6709\u8bef\u3002", (String)"PlanTaskImpAndExpUtil_100", (String)"pccs-placs-business", (Object[])new Object[0]));
                                        hasError = true;
                                    }
                                }
                                try {
                                    if (planstarttime != null && StringUtils.isNotBlank((CharSequence)cellValue) && this.sdf.parse(cellValue).compareTo(this.sdf.parse(planstarttime)) < 0) {
                                        errorMsg.add((Object)ResManager.loadKDString((String)"\u5185\u63a7\u5b8c\u6210\u65f6\u95f4\u5fc5\u987b\u665a\u4e8e\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u3002", (String)"PlanTaskImpAndExpUtil_101", (String)"pccs-placs-business", (Object[])new Object[0]));
                                        hasError = true;
                                    }
                                    break block112;
                                }
                                catch (ParseException e) {
                                    if (planstarttime != null && StringUtils.isNotBlank((CharSequence)cellValue) && cellValue.compareTo(planstarttime) < 0) {
                                        errorMsg.add((Object)ResManager.loadKDString((String)"\u5185\u63a7\u5b8c\u6210\u65f6\u95f4\u5fc5\u987b\u665a\u4e8e\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u3002", (String)"PlanTaskImpAndExpUtil_101", (String)"pccs-placs-business", (Object[])new Object[0]));
                                        hasError = true;
                                    }
                                    break block112;
                                }
                            }
                            if ("majortype".equalsIgnoreCase(columnKey)) {
                                if (StringUtils.isBlank((CharSequence)cellValue)) continue;
                                DynamicObject project = (DynamicObject)view.getModel().getValue("project");
                                DynamicObject projectKind = this.getGroup(project);
                                DynamicObject majorType = this.validMajorType(cellValue, appId, projectKind);
                                if (majorType == null) {
                                    if (projectKind == null) {
                                        errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u540d\u79f0\u4e3a\u201c%s\u201d\u7684\u4e13\u4e1a\u7c7b\u578b\u3002", (String)"PlanTaskImpAndExpUtil_49", (String)"pccs-placs-business", (Object[])new Object[0]), cellValue));
                                    } else {
                                        errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%1$s\u201d\u6240\u5c5e\u7684\u9879\u76ee\u5206\u7c7b\u201c%2$s\u201d\u4e0b\u4e0d\u5b58\u5728\u540d\u79f0\u4e3a\u201c%3$s\u201d\u7684\u4e13\u4e1a\u7c7b\u578b\u3002", (String)"PlanTaskImpAndExpUtil_81", (String)"pccs-placs-business", (Object[])new Object[0]), project.getLocaleString("name").getLocaleValue(), projectKind.getLocaleString("name").getLocaleValue(), cellValue));
                                    }
                                    hasError = true;
                                }
                            } else if ("responsibledept".equalsIgnoreCase(columnKey)) {
                                if (StringUtils.isBlank((CharSequence)cellValue)) continue;
                                nameFilter = new QFilter("name", "=", (Object)cellValue);
                                enableFilter = new QFilter("enable", "=", (Object)DefaultEnum.YES.getValue());
                                DynamicObject responsibleDept = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{nameFilter, enableFilter});
                                if (responsibleDept == null) {
                                    errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u540d\u79f0\u4e3a\u201c%s\u201d\u7684\u8d23\u4efb\u90e8\u95e8\u3002", (String)"PlanTaskImpAndExpUtil_51", (String)"pccs-placs-business", (Object[])new Object[0]), cellValue));
                                    hasError = true;
                                }
                            } else if ("multicooperationperson".equalsIgnoreCase(columnKey)) {
                                if (StringUtils.isBlank((CharSequence)cellValue)) continue;
                                number = null;
                                enableFilter = column.iterator();
                                while (enableFilter.hasNext()) {
                                    columnData = enableFilter.next();
                                    columnValue1 = JSONObject.parseObject((String)columnData.toString());
                                    String columnKey1 = columnValue1.getString("columnKey");
                                    if (!columnKey1.equalsIgnoreCase("multicooperationperson.number")) continue;
                                    number = columnValue1.getString("cellValue");
                                    break;
                                }
                                String[] cooPersonStrs = cellValue.split(";|\uff1b");
                                String[] cooPersonNumStrs = new String[]{};
                                if (StringUtils.isNotBlank((CharSequence)number)) {
                                    cooPersonNumStrs = number.split(";|\uff1b");
                                }
                                if (responsiblepersonName != null) {
                                    for (int i = 0; i < cooPersonStrs.length; ++i) {
                                        if (cooPersonNumStrs.length > i && responsiblepersonNumber != null) {
                                            if (!cooPersonStrs[i].equalsIgnoreCase(responsiblepersonName) || !cooPersonNumStrs[i].equalsIgnoreCase(responsiblepersonNumber)) continue;
                                            errorMsg.add((Object)ResManager.loadKDString((String)"\u534f\u529e\u4eba\u4e0e\u8d23\u4efb\u4eba\u4e0d\u80fd\u4e3a\u540c\u4e00\u4eba\u3002", (String)"PlanTaskImpAndExpUtil_52", (String)"pccs-placs-business", (Object[])new Object[0]));
                                            hasError = true;
                                            break;
                                        }
                                        if (!cooPersonStrs[i].equalsIgnoreCase(responsiblepersonName)) continue;
                                        errorMsg.add((Object)ResManager.loadKDString((String)"\u534f\u529e\u4eba\u4e0e\u8d23\u4efb\u4eba\u4e0d\u80fd\u4e3a\u540c\u4e00\u4eba\u3002", (String)"PlanTaskImpAndExpUtil_52", (String)"pccs-placs-business", (Object[])new Object[0]));
                                        hasError = true;
                                        break;
                                    }
                                }
                                QFilter enableFilter3 = new QFilter("enable", "=", (Object)DefaultEnum.YES.getValue());
                                for (int i = 0; i < cooPersonStrs.length; ++i) {
                                    DynamicObject[] cooPersons;
                                    QFilter nameFilter3 = new QFilter("name", "=", (Object)cooPersonStrs[i]);
                                    QFilter numberFilter = null;
                                    if (cooPersonNumStrs.length > i && StringUtils.isNotBlank((CharSequence)cooPersonNumStrs[i])) {
                                        numberFilter = new QFilter("number", "=", (Object)cooPersonNumStrs[i]);
                                    }
                                    if ((cooPersons = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,name,number", (QFilter[])new QFilter[]{nameFilter3, numberFilter, enableFilter3})).length == 0) {
                                        if (cooPersonNumStrs.length > i && StringUtils.isNotBlank((CharSequence)cooPersonNumStrs[i])) {
                                            errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u6ca1\u6709\u627e\u5230\u59d3\u540d\u4e3a\u201c%1$s\u201d\uff0c\u7f16\u53f7\u4e3a\u201c%2$s\u201d\u7684\u534f\u529e\u4eba\u3002", (String)"PlanTaskImpAndExpUtil_102", (String)"pccs-placs-business", (Object[])new Object[0]), cooPersonStrs[i], cooPersonNumStrs[i]));
                                        } else {
                                            errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u59d3\u540d\u4e3a\u201c%s\u201d\u7684\u534f\u529e\u4eba\u3002", (String)"PlanTaskImpAndExpUtil_55", (String)"pccs-placs-business", (Object[])new Object[0]), cooPersonStrs[i]));
                                        }
                                        hasError = true;
                                        continue;
                                    }
                                    if (cooPersons.length <= 1) continue;
                                    if (cooPersonNumStrs.length > i && StringUtils.isNotBlank((CharSequence)cooPersonNumStrs[i])) {
                                        errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5b58\u5728\u591a\u4e2a\u59d3\u540d\u4e3a\u201c%1$s\u201d\uff0c\u7f16\u53f7\u4e3a\u201c%2$s\u201d\u7684\u534f\u529e\u4eba\u3002", (String)"PlanTaskImpAndExpUtil_103", (String)"pccs-placs-business", (Object[])new Object[0]), cooPersonStrs[i], cooPersonNumStrs[i]));
                                    } else {
                                        errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5b58\u5728\u591a\u4e2a\u59d3\u540d\u4e3a\u201c%s\u201d\u7684\u534f\u529e\u4eba\uff0c\u8bf7\u8f93\u5165\u6240\u6709\u534f\u529e\u4eba\u7684\u5de5\u53f7\u3002", (String)"PlanTaskImpAndExpUtil_71", (String)"pccs-placs-business", (Object[])new Object[0]), cooPersonStrs[i]));
                                    }
                                    hasError = true;
                                }
                            } else if ("multicooperationdept".equalsIgnoreCase(columnKey)) {
                                if (StringUtils.isBlank((CharSequence)cellValue)) continue;
                                nameFilter = new QFilter("name", "in", (Object)cellValue.split(";|\uff1b"));
                                DynamicObject[] cooperationDept = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{nameFilter, enableFilter = new QFilter("enable", "=", (Object)DefaultEnum.YES.getValue())});
                                if (cooperationDept.length == 0) {
                                    errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u540d\u79f0\u4e3a\u201c%s\u201d\u7684\u534f\u529e\u90e8\u95e8\u3002", (String)"PlanTaskImpAndExpUtil_57", (String)"pccs-placs-business", (Object[])new Object[0]), cellValue));
                                    hasError = true;
                                }
                            } else if ("pretask".equals(columnKey)) {
                                if (StringUtils.isBlank((CharSequence)cellValue)) continue;
                                if (cellValue.equals(currentRowTaskName)) {
                                    errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u524d\u7f6e\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e0e\u5f53\u524d\u4efb\u52a1\u540d\u79f0\u201c%s\u201d\u76f8\u540c\u3002", (String)"PlanTaskImpAndExpUtil_58", (String)"pccs-placs-business", (Object[])new Object[0]), cellValue));
                                    hasError = true;
                                }
                                if (this.preTaskValid(data, currentRowTaskName, cellValue)) {
                                    errorMsg.add((Object)ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u7684\u4e0a\u7ea7\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u5176\u524d\u7f6e\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PlanTaskImpAndExpUtil_104", (String)"pccs-placs-business", (Object[])new Object[0]));
                                    hasError = true;
                                }
                            } else if ("parent".equals(columnKey)) {
                                if (StringUtils.isBlank((CharSequence)cellValue)) continue;
                                if (cellValue.equals(currentRowTaskName)) {
                                    errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e0e\u5f53\u524d\u4efb\u52a1\u540d\u79f0\u201c%s\u201d\u76f8\u540c\u3002", (String)"PlanTaskImpAndExpUtil_60", (String)"pccs-placs-business", (Object[])new Object[0]), cellValue));
                                    hasError = true;
                                }
                            } else if ("comment".equals(columnKey)) {
                                if (StringUtils.isBlank((CharSequence)cellValue)) continue;
                                if (cellValue.length() > 50) {
                                    errorMsg.add((Object)ResManager.loadKDString((String)"\u5907\u6ce8\u5185\u5bb9\u5e94\u5c0f\u4e8e50\u4e2a\u5b57\u7b26\u3002", (String)"PlanTaskImpAndExpUtil_105", (String)"pccs-placs-business", (Object[])new Object[0]));
                                    hasError = true;
                                }
                            } else if ("relativeduration".equals(columnKey) && StringUtils.isNotBlank((CharSequence)cellValue)) {
                                String relativedurationValue = MatcherUtils.getActualValue((String)cellValue);
                                if (!MatcherUtils.isNumeric((String)relativedurationValue)) {
                                    errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u76f8\u5bf9\u5de5\u671f\u201c%s\u201d\u4e0d\u662f\u6574\u6570\u3002", (String)"PlanTaskImpAndExpUtil_67", (String)"pccs-placs-business", (Object[])new Object[0]), cellValue));
                                    hasError = true;
                                }
                            } else if ("absoluteduration".equals(columnKey) && StringUtils.isNotBlank((CharSequence)cellValue) && !MatcherUtils.isPureDigital((String)(absolutedurationValue = MatcherUtils.getActualValue((String)cellValue)))) {
                                errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7edd\u5bf9\u5de5\u671f\u201c%s\u201d\u5fc5\u987b\u4e3a\u6b63\u6574\u6570\u3002", (String)"PlanTaskImpAndExpUtil_106", (String)"pccs-placs-business", (Object[])new Object[0]), cellValue));
                                hasError = true;
                            }
                        }
                    }
                }
                hasError = hasError || this.busiExtendsVail(view, columnKey, cellValue, errorMsg);
            }
            if (errorMsg.size() > 0) {
                errorInfo.put("cellValue", (Object)String.format(ResManager.loadKDString((String)"\u6570\u636e\u6709\u8bef\uff1a%s\u3002", (String)"PlanTaskImpAndExpUtil_107", (String)"pccs-placs-business", (Object[])new Object[0]), errorMsg));
            } else {
                errorInfo.put("cellValue", (Object)ResManager.loadKDString((String)"\u6570\u636e\u65e0\u8bef\u3002", (String)"PlanTaskImpAndExpUtil_108", (String)"pccs-placs-business", (Object[])new Object[0]));
            }
            column.add(0, (Object)errorInfo);
            errorData.add((Object)column);
        }
        if (hasError) {
            String exportUrl = helper.exportExcel(this.getFileName(DefaultEnum.NO), this.getSheetName(DefaultEnum.NO), this.getHeader(DefaultEnum.NO), this.getColumnKey(DefaultEnum.NO), this.getMustFillColumn(), errorData);
            view.download(exportUrl);
            view.showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u300a\u5bfc\u5165\u7ed3\u679c.xls\u300b\u3002", (String)"PlanTaskImpAndExpUtil_86", (String)"pccs-placs-business", (Object[])new Object[0]), Integer.valueOf(3000));
            return null;
        }
        int seq = 0;
        ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>();
        for (Object obj : data) {
            this.createTask(view, JSONArray.parseArray((String)obj.toString()), taskList, seq, appId);
            ++seq;
        }
        String selRule = (String)view.getFormShowParameter().getCustomParam("selRule");
        if (!taskList.isEmpty() && "1".equals(selRule)) {
            PlanTaskImpAndExpUtil.calculateByDate(view, taskList, appId);
        } else if (!taskList.isEmpty() && "2".equals(selRule)) {
            PlanTaskImpAndExpUtil.calculateByAbsoluteDuration(view, taskList, appId);
        }
        if (!taskList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])taskList.toArray(new DynamicObject[taskList.size()]));
        }
        return taskList;
    }

    public List<DynamicObject> importDeptTask(IFormView view, String url, String appId) {
        String columnKeyHash = POIHelper.stringArrayToHash((String[])this.getDeptColumnKey(DefaultEnum.YES));
        PlanTaskPOIHelper helper = this.getPlanTaskPOIHelper();
        JSONArray data = helper.newInputExcelForTask(url, columnKeyHash);
        if (data == null || data.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\u3002\u8bf7\u68c0\u67e5\u6a21\u677f\u662f\u5426\u5339\u914d\uff0c\u6216\u8005\u5bfc\u5165\u6587\u4ef6\u662f\u5426\u4e3a\u7a7a\u3002", (String)"PlanTaskImpAndExpUtil_87", (String)"pccs-placs-business", (Object[])new Object[0]));
        }
        JSONArray errorData = new JSONArray();
        boolean hasError = this.checkoutData(view, appId, data, errorData);
        if (hasError) {
            String exportUrl = helper.exportExcel(this.getFileName(DefaultEnum.NO), this.getSheetName(DefaultEnum.NO), this.getDeptHeader(DefaultEnum.NO), this.getDeptColumnKey(DefaultEnum.NO), this.getDeptMustFillColumn(), errorData);
            view.download(exportUrl);
            view.showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u300a\u5bfc\u5165\u7ed3\u679c.xls\u300b", (String)"PlanTaskImpAndExpUtil_64", (String)"pccs-placs-business", (Object[])new Object[0]), Integer.valueOf(3000));
            return null;
        }
        ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>();
        DynamicObjectCollection tasks = this.view.getParentView().getModel().getEntryEntity("taskentity");
        int seq = tasks.size() + 1;
        for (Object obj : data) {
            this.createDeptTask(view, JSONArray.parseArray((String)obj.toString()), taskList, appId, seq);
            ++seq;
        }
        String selRule = (String)view.getFormShowParameter().getCustomParam("selRule");
        DynamicObject dept = (DynamicObject)this.view.getParentView().getModel().getValue("org");
        Object orgId = dept.getPkValue();
        if (!taskList.isEmpty() && "1".equals(selRule)) {
            PlanTaskImpAndExpUtil.calculateDeptByDate(view, taskList, orgId, appId);
        } else if (!taskList.isEmpty() && "2".equals(selRule)) {
            PlanTaskImpAndExpUtil.calculateDeptByAbsoluteDuration(view, taskList, orgId, appId);
        }
        if (!taskList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])taskList.toArray(new DynamicObject[taskList.size()]));
        }
        return taskList;
    }

    protected boolean checkoutData(IFormView view, String appId, JSONArray data, JSONArray errorData) {
        boolean hasError = false;
        ArrayList<String> nameList = new ArrayList<String>(10);
        for (Object row : data) {
            JSONArray column = JSONArray.parseArray((String)row.toString());
            JSONObject errorInfo = new JSONObject();
            errorInfo.put("columnKey", (Object)ERRORINFOCOLUMN);
            errorInfo.put("columnName", (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u63d0\u793a\u4fe1\u606f", (String)"PlanTaskImpAndExpUtil_26", (String)"pccs-placs-business", (Object[])new Object[0]));
            JSONArray errorMsg = new JSONArray();
            String currentRowTaskName = null;
            String responsiblepersonName = null;
            String responsiblepersonNumber = null;
            String planstarttime = null;
            for (Object columnName : column) {
                String absolutedurationValue;
                String columnKey1;
                String number;
                Object enableFilter;
                QFilter nameFilter;
                JSONObject columnValue = JSONObject.parseObject((String)columnName.toString());
                String cellValue = columnValue.getString("cellValue");
                String columnKey = columnValue.getString("columnKey");
                if ("name".equalsIgnoreCase(columnKey)) {
                    if (StringUtils.isBlank((CharSequence)cellValue)) {
                        errorMsg.add((Object)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4efb\u52a1\u540d\u79f0\u201d\u3002", (String)"PlanTaskImpAndExpUtil_88", (String)"pccs-placs-business", (Object[])new Object[0]));
                        hasError = true;
                    } else if (nameList.contains(cellValue)) {
                        errorMsg.add((Object)ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"PlanTaskImpAndExpUtil_89", (String)"pccs-placs-business", (Object[])new Object[0]));
                        hasError = true;
                    } else if (StringUtils.isNotBlank((CharSequence)cellValue) && cellValue.length() > 80) {
                        errorMsg.add((Object)ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0\u5e94\u5c0f\u4e8e80\u4e2a\u5b57\u7b26\u3002", (String)"PlanTaskImpAndExpUtil_109", (String)"pccs-placs-business", (Object[])new Object[0]));
                        hasError = true;
                    } else {
                        currentRowTaskName = cellValue;
                        nameList.add(cellValue);
                    }
                } else if ("tasktype".equalsIgnoreCase(columnKey)) {
                    if (StringUtils.isBlank((CharSequence)cellValue)) {
                        errorMsg.add((Object)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4efb\u52a1\u7c7b\u578b\u201d\u3002", (String)"PlanTaskImpAndExpUtil_91", (String)"pccs-placs-business", (Object[])new Object[0]));
                        hasError = true;
                    } else {
                        nameFilter = new QFilter("name", "=", (Object)cellValue);
                        enableFilter = new QFilter("enable", "=", (Object)DefaultEnum.YES.getValue());
                        DynamicObject taskType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)appId, (String)"tasktype"), (String)"", (QFilter[])new QFilter[]{nameFilter, enableFilter});
                        if (taskType == null) {
                            errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"PlanTaskImpAndExpUtil_36", (String)"pccs-placs-business", (Object[])new Object[0]), cellValue));
                            hasError = true;
                        }
                    }
                } else if ("planstarttime".equalsIgnoreCase(columnKey)) {
                    if (StringUtils.isBlank((CharSequence)cellValue)) {
                        planstarttime = null;
                        errorMsg.add((Object)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u201d\u3002", (String)"PlanTaskImpAndExpUtil_94", (String)"pccs-placs-business", (Object[])new Object[0]));
                        hasError = true;
                    }
                    try {
                        planstarttime = cellValue;
                        Long.parseLong(cellValue);
                    }
                    catch (NumberFormatException e) {
                        try {
                            this.sdf.parse(cellValue);
                        }
                        catch (Exception e1) {
                            errorMsg.add((Object)ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u201d\u683c\u5f0f\u6709\u8bef\u3002", (String)"PlanTaskImpAndExpUtil_95", (String)"pccs-placs-business", (Object[])new Object[0]));
                            hasError = true;
                        }
                    }
                } else if ("planendtime".equalsIgnoreCase(columnKey)) {
                    if (StringUtils.isBlank((CharSequence)cellValue)) {
                        errorMsg.add((Object)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u201d\u3002", (String)"PlanTaskImpAndExpUtil_96", (String)"pccs-placs-business", (Object[])new Object[0]));
                        hasError = true;
                    }
                    try {
                        Long.parseLong(cellValue);
                    }
                    catch (NumberFormatException e) {
                        try {
                            this.sdf.parse(cellValue);
                        }
                        catch (Exception e1) {
                            errorMsg.add((Object)ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u201d\u683c\u5f0f\u6709\u8bef\u3002", (String)"PlanTaskImpAndExpUtil_97", (String)"pccs-placs-business", (Object[])new Object[0]));
                            hasError = true;
                        }
                    }
                    try {
                        if (planstarttime != null && StringUtils.isNotBlank((CharSequence)cellValue) && this.sdf.parse(cellValue).compareTo(this.sdf.parse(planstarttime)) < 0) {
                            errorMsg.add((Object)ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u5e94\u665a\u4e8e\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u3002", (String)"PlanTaskImpAndExpUtil_98", (String)"pccs-placs-business", (Object[])new Object[0]));
                            hasError = true;
                        }
                    }
                    catch (ParseException e) {
                        logger.error("ParseException\uff1a", (Throwable)e);
                    }
                } else if ("responsibleperson".equalsIgnoreCase(columnKey)) {
                    responsiblepersonName = cellValue;
                    if (StringUtils.isBlank((CharSequence)cellValue)) {
                        errorMsg.add((Object)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8d23\u4efb\u4eba\u201d\u3002", (String)"PlanTaskImpAndExpUtil_99", (String)"pccs-placs-business", (Object[])new Object[0]));
                        hasError = true;
                    } else {
                        DynamicObject[] responsiblePersons;
                        number = null;
                        for (Object columnData : column) {
                            JSONObject columnValue1 = JSONObject.parseObject((String)columnData.toString());
                            columnKey1 = columnValue1.getString("columnKey");
                            if (!columnKey1.equalsIgnoreCase("responsibleperson.number")) continue;
                            responsiblepersonNumber = number = columnValue1.getString("cellValue");
                            break;
                        }
                        QFilter nameFilter2 = new QFilter("name", "=", (Object)cellValue);
                        QFilter enableFilter2 = new QFilter("enable", "=", (Object)DefaultEnum.YES.getValue());
                        QFilter numberFilter = null;
                        if (StringUtils.isNotBlank((CharSequence)number)) {
                            numberFilter = new QFilter("number", "=", (Object)number);
                        }
                        if ((responsiblePersons = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,name,number", (QFilter[])new QFilter[]{nameFilter2, numberFilter, enableFilter2})).length > 1) {
                            if (StringUtils.isBlank((CharSequence)number)) {
                                errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5b58\u5728\u591a\u4e2a\u59d3\u540d\u4e3a\u201c%s\u201d\u7684\u8d23\u4efb\u4eba\u3002", (String)"PlanTaskImpAndExpUtil_44", (String)"pccs-placs-business", (Object[])new Object[0]), cellValue));
                            } else {
                                errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5b58\u5728\u591a\u4e2a\u59d3\u540d\u4e3a\u201c%1$s\u201d\uff0c\u5de5\u53f7\u4e3a\u201c%2$s\u201d\u7684\u8d23\u4efb\u4eba\u3002", (String)"PlanTaskImpAndExpUtil_79", (String)"pccs-placs-business", (Object[])new Object[0]), cellValue, number));
                            }
                            hasError = true;
                        } else if (responsiblePersons.length == 0) {
                            if (StringUtils.isBlank((CharSequence)number)) {
                                errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u59d3\u540d\u4e3a\u201c%s\u201d\u7684\u8d23\u4efb\u4eba\u3002", (String)"PlanTaskImpAndExpUtil_46", (String)"pccs-placs-business", (Object[])new Object[0]), cellValue));
                            } else {
                                errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u59d3\u540d\u4e3a\u201c%1$s\u201d,\u7f16\u53f7\u4e3a\u201c%2$s\u201d\u7684\u8d23\u4efb\u4eba\u3002", (String)"PlanTaskImpAndExpUtil_80", (String)"pccs-placs-business", (Object[])new Object[0]), cellValue, number));
                            }
                            hasError = true;
                        }
                    }
                } else if ("aimfinishtime".equalsIgnoreCase(columnKey)) {
                    if (StringUtils.isBlank((CharSequence)cellValue)) continue;
                    try {
                        Long.parseLong(cellValue);
                    }
                    catch (NumberFormatException e) {
                        try {
                            this.sdf.parse(cellValue);
                        }
                        catch (Exception e1) {
                            errorMsg.add((Object)ResManager.loadKDString((String)"\u201c\u5185\u63a7\u5b8c\u6210\u65f6\u95f4\u201d\u683c\u5f0f\u6709\u8bef\u3002", (String)"PlanTaskImpAndExpUtil_100", (String)"pccs-placs-business", (Object[])new Object[0]));
                            hasError = true;
                        }
                    }
                    try {
                        if (planstarttime != null && StringUtils.isNotBlank((CharSequence)cellValue) && this.sdf.parse(cellValue).compareTo(this.sdf.parse(planstarttime)) < 0) {
                            errorMsg.add((Object)ResManager.loadKDString((String)"\u5185\u63a7\u5b8c\u6210\u65f6\u95f4\u5fc5\u987b\u665a\u4e8e\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u3002", (String)"PlanTaskImpAndExpUtil_101", (String)"pccs-placs-business", (Object[])new Object[0]));
                            hasError = true;
                        }
                    }
                    catch (ParseException e) {
                        logger.error("ParseException\uff1a", (Throwable)e);
                    }
                } else if ("responsibledept".equalsIgnoreCase(columnKey)) {
                    if (StringUtils.isBlank((CharSequence)cellValue)) continue;
                    nameFilter = new QFilter("name", "=", (Object)cellValue);
                    enableFilter = new QFilter("enable", "=", (Object)DefaultEnum.YES.getValue());
                    DynamicObject responsibleDept = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{nameFilter, enableFilter});
                    if (responsibleDept == null) {
                        errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u540d\u79f0\u4e3a\u201c%s\u201d\u7684\u8d23\u4efb\u90e8\u95e8\u3002", (String)"PlanTaskImpAndExpUtil_51", (String)"pccs-placs-business", (Object[])new Object[0]), cellValue));
                        hasError = true;
                    }
                } else if ("multicooperationperson".equalsIgnoreCase(columnKey)) {
                    if (StringUtils.isBlank((CharSequence)cellValue)) continue;
                    number = null;
                    enableFilter = column.iterator();
                    while (enableFilter.hasNext()) {
                        Object columnData;
                        columnData = enableFilter.next();
                        JSONObject columnValue1 = JSONObject.parseObject((String)columnData.toString());
                        columnKey1 = columnValue1.getString("columnKey");
                        if (!columnKey1.equalsIgnoreCase("multicooperationperson.number")) continue;
                        number = columnValue1.getString("cellValue");
                        break;
                    }
                    String[] cooPersonStrs = cellValue.split(";|\uff1b");
                    String[] cooPersonNumStrs = new String[]{};
                    if (StringUtils.isNotBlank((CharSequence)number)) {
                        cooPersonNumStrs = number.split(";|\uff1b");
                    }
                    if (responsiblepersonName != null) {
                        for (int i = 0; i < cooPersonStrs.length; ++i) {
                            if (cooPersonNumStrs.length > i && responsiblepersonNumber != null) {
                                if (!cooPersonStrs[i].equalsIgnoreCase(responsiblepersonName) || !cooPersonNumStrs[i].equalsIgnoreCase(responsiblepersonNumber)) continue;
                                errorMsg.add((Object)ResManager.loadKDString((String)"\u534f\u529e\u4eba\u4e0e\u8d23\u4efb\u4eba\u4e0d\u80fd\u4e3a\u540c\u4e00\u4eba\u3002", (String)"PlanTaskImpAndExpUtil_52", (String)"pccs-placs-business", (Object[])new Object[0]));
                                hasError = true;
                                break;
                            }
                            if (!cooPersonStrs[i].equalsIgnoreCase(responsiblepersonName)) continue;
                            errorMsg.add((Object)ResManager.loadKDString((String)"\u534f\u529e\u4eba\u4e0e\u8d23\u4efb\u4eba\u4e0d\u80fd\u4e3a\u540c\u4e00\u4eba\u3002", (String)"PlanTaskImpAndExpUtil_52", (String)"pccs-placs-business", (Object[])new Object[0]));
                            hasError = true;
                            break;
                        }
                    }
                    for (int i = 0; i < cooPersonStrs.length; ++i) {
                        DynamicObject[] cooPersons;
                        QFilter nameFilter3 = new QFilter("name", "=", (Object)cooPersonStrs[i]);
                        QFilter enableFilter3 = new QFilter("enable", "=", (Object)DefaultEnum.YES.getValue());
                        QFilter numberFilter = null;
                        if (cooPersonNumStrs.length > i && StringUtils.isNotBlank((CharSequence)cooPersonNumStrs[i])) {
                            numberFilter = new QFilter("number", "=", (Object)cooPersonNumStrs[i]);
                        }
                        if ((cooPersons = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,name,number", (QFilter[])new QFilter[]{nameFilter3, numberFilter, enableFilter3})).length == 0) {
                            if (cooPersonNumStrs.length > i && StringUtils.isNotBlank((CharSequence)cooPersonNumStrs[i])) {
                                errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u6ca1\u6709\u627e\u5230\u59d3\u540d\u4e3a\u201c%1$s\u201d\uff0c\u7f16\u53f7\u4e3a\u201c%2$s\u201d\u7684\u534f\u529e\u4eba\u3002", (String)"PlanTaskImpAndExpUtil_102", (String)"pccs-placs-business", (Object[])new Object[0]), cooPersonStrs[i], cooPersonNumStrs[i]));
                            } else {
                                errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u59d3\u540d\u4e3a\u201c%s\u201d\u7684\u534f\u529e\u4eba\u3002", (String)"PlanTaskImpAndExpUtil_55", (String)"pccs-placs-business", (Object[])new Object[0]), cooPersonStrs[i]));
                            }
                            hasError = true;
                            continue;
                        }
                        if (cooPersons.length <= 1) continue;
                        if (cooPersonNumStrs.length > i && StringUtils.isNotBlank((CharSequence)cooPersonNumStrs[i])) {
                            errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5b58\u5728\u591a\u4e2a\u59d3\u540d\u4e3a\u201c%1$s\u201d\uff0c\u7f16\u53f7\u4e3a\u201c%2$s\u201d\u7684\u534f\u529e\u4eba\u3002", (String)"PlanTaskImpAndExpUtil_103", (String)"pccs-placs-business", (Object[])new Object[0]), cooPersonStrs[i], cooPersonNumStrs[i]));
                        } else {
                            errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5b58\u5728\u591a\u4e2a\u59d3\u540d\u4e3a\u201c%s\u201d\u7684\u534f\u529e\u4eba\uff0c\u8bf7\u8f93\u5165\u6240\u6709\u534f\u529e\u4eba\u7684\u5de5\u53f7\u3002", (String)"PlanTaskImpAndExpUtil_71", (String)"pccs-placs-business", (Object[])new Object[0]), cooPersonStrs[i]));
                        }
                        hasError = true;
                    }
                } else if ("multicooperationdept".equalsIgnoreCase(columnKey)) {
                    if (StringUtils.isBlank((CharSequence)cellValue)) continue;
                    nameFilter = new QFilter("name", "in", (Object)cellValue.split(";|\uff1b"));
                    DynamicObject[] cooperationDepts = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{nameFilter, enableFilter = new QFilter("enable", "in", (Object)DefaultEnum.YES.getValue())});
                    if (cooperationDepts.length == 0) {
                        errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u540d\u79f0\u4e3a\u201c%s\u201d\u7684\u534f\u529e\u90e8\u95e8\u3002", (String)"PlanTaskImpAndExpUtil_57", (String)"pccs-placs-business", (Object[])new Object[0]), cellValue));
                        hasError = true;
                    }
                } else if ("parent".equals(columnKey)) {
                    if (StringUtils.isBlank((CharSequence)cellValue)) continue;
                    if (cellValue.equals(currentRowTaskName)) {
                        errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e0e\u5f53\u524d\u4efb\u52a1\u540d\u79f0\u201c%s\u201d\u76f8\u540c\u3002", (String)"PlanTaskImpAndExpUtil_60", (String)"pccs-placs-business", (Object[])new Object[0]), cellValue));
                        hasError = true;
                    }
                } else if ("absoluteduration".equals(columnKey) && StringUtils.isNotBlank((CharSequence)cellValue) && !MatcherUtils.isPureDigital((String)(absolutedurationValue = MatcherUtils.getActualValue((String)cellValue)))) {
                    errorMsg.add((Object)String.format(ResManager.loadKDString((String)"\u7edd\u5bf9\u5de5\u671f\u201c%s\u201d\u5fc5\u987b\u4e3a\u6b63\u6574\u6570\u3002", (String)"PlanTaskImpAndExpUtil_106", (String)"pccs-placs-business", (Object[])new Object[0]), cellValue));
                    hasError = true;
                }
                hasError = hasError || this.busiExtendsVail(view, columnKey, cellValue, errorMsg);
            }
            if (errorMsg.size() > 0) {
                errorInfo.put("cellValue", (Object)String.format(ResManager.loadKDString((String)"\u6570\u636e\u6709\u8bef\uff1a%s\u3002", (String)"PlanTaskImpAndExpUtil_107", (String)"pccs-placs-business", (Object[])new Object[0]), errorMsg));
            } else {
                errorInfo.put("cellValue", (Object)ResManager.loadKDString((String)"\u6570\u636e\u65e0\u8bef\u3002", (String)"PlanTaskImpAndExpUtil_108", (String)"pccs-placs-business", (Object[])new Object[0]));
            }
            column.add(0, (Object)errorInfo);
            errorData.add((Object)column);
        }
        return hasError;
    }

    public void exportCommonModel(IFormView view, boolean isExportData) {
        String parentPageId = null;
        String entityNumber = null;
        if (isExportData) {
            parentPageId = view.getPageId();
            entityNumber = view.getEntityId();
        } else {
            parentPageId = view.getParentView().getPageId();
            entityNumber = view.getParentView().getEntityId();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("parentpageid", parentPageId);
        params.put("isExportData", isExportData);
        params.put("entitynumber", entityNumber);
        params.put("entryKey", "taskentity");
        String url = this.executeExportTask(params);
        view.download(url);
        view.showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6210\u529f\u3002", (String)"PlanTaskImpAndExpUtil_28", (String)"pccs-placs-business", (Object[])new Object[0]), Integer.valueOf(2000));
    }

    public DynamicObjectCollection importPlanTask(IFormView view, String url, String appId, String entryKey) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("parentpageid", view.getPageId());
        params.put("url", url);
        params.put("appId", appId);
        params.put("entitynumber", view.getEntityId());
        params.put("entryKey", entryKey);
        DynamicObjectCollection entrys = this.executeImportTask(params);
        DynamicObject entrysdt = this.parentView.getModel().getDataEntity();
        DynamicObject project = entrysdt.getDynamicObject("project");
        if (entrys != null) {
            for (DynamicObject entry : entrys) {
                if (entry.getDynamicObject("taskproject") != null) continue;
                entry.set("taskproject", (Object)project);
            }
            String selRule = (String)view.getFormShowParameter().getCustomParam("selRule");
            if ("1".equals(selRule)) {
                PlanTaskImpAndExpUtil.calculateDurationByDate(view, entrys, appId);
            } else if ("2".equals(selRule)) {
                PlanTaskImpAndExpUtil.calculateTimeByAbsoluteDuration(view, entrys, appId);
            }
        }
        return entrys;
    }

    public static void calculateDurationByDate(IFormView view, DynamicObjectCollection entrys, String appId) {
        for (DynamicObject task : entrys) {
            DynamicObject project = task.getDynamicObject("taskproject");
            Date planStartTime = task.getDate("planstarttime");
            Date planEndTime = task.getDate("planendtime");
            BigDecimal newAbsoluteDuration = TaskUtil.getDaysBetweenTwoDate(project != null ? project.getPkValue() : null, planStartTime, planEndTime, appId);
            task.set("absoluteduration", (Object)newAbsoluteDuration);
            if (task.getDynamicObject("belongplantype") != null) {
                DynamicObject belongPlanType = BusinessDataServiceHelper.loadSingleFromCache((Object)task.getDynamicObject("belongplantype").getString("id"), (String)MetaDataUtil.getEntityId((String)appId, (String)"majortype"));
                task.set("belongplantype", (Object)belongPlanType);
            }
            PlanTaskImpAndExpUtil.calCompTimeDeviationNew(view, task, appId);
        }
    }

    public static void calCompTimeDeviationNew(IFormView view, DynamicObject task, String appId) {
        BigDecimal days;
        Date aimFinishTime = task.getDate("aimfinishtime");
        Date planEndTime = task.getDate("planendtime");
        DynamicObject project = task.getDynamicObject("taskproject");
        if (aimFinishTime == null || planEndTime == null) {
            return;
        }
        if (project != null) {
            try {
                days = TaskUtil.getDaysBetweenTwoDate(project.getPkValue(), planEndTime, aimFinishTime, appId).subtract(BigDecimal.ONE);
            }
            catch (KDBizException e) {
                view.showTipNotification(e.getMessage());
                days = new BigDecimal(DateUtil.getDaysBetweenTwoDate((Date)planEndTime, (Date)aimFinishTime));
            }
        } else {
            days = new BigDecimal(DateUtil.getDaysBetweenTwoDate((Date)planEndTime, (Date)aimFinishTime));
        }
        task.set("comptimedeviation", (Object)days);
    }

    public static void calculateTimeByAbsoluteDuration(IFormView view, DynamicObjectCollection taskList, String appId) {
        for (DynamicObject task : taskList) {
            DynamicObject project = task.getDynamicObject("taskproject");
            Date planStartTime = task.getDate("planstarttime");
            BigDecimal absoluteDuration = task.getBigDecimal("absoluteduration");
            Date newPlanEndTime = TaskUtil.getDateAfterAddDays(project != null ? project.getPkValue() : null, planStartTime, absoluteDuration.intValue() - 1, appId);
            task.set("planendtime", (Object)newPlanEndTime);
            PlanTaskImpAndExpUtil.calCompTimeDeviationNew(view, task, appId);
        }
    }

    protected DynamicObject validMajorType(String cellValue, String appId, DynamicObject projectKind) {
        QFilter nameFilter = new QFilter("name", "=", (Object)cellValue);
        QFilter projectKindFilter = new QFilter("group", "=", projectKind == null ? Long.valueOf(0L) : projectKind.getPkValue()).or("group", "=", (Object)0L);
        QFilter enableFilter = new QFilter("enable", "=", (Object)DefaultEnum.YES.getValue());
        return BusinessDataServiceHelper.loadSingleFromCache((String)MetaDataUtil.getEntityId((String)appId, (String)"majortype"), (String)"id,name", (QFilter[])new QFilter[]{projectKindFilter, enableFilter, nameFilter});
    }

    protected DynamicObject getGroup(DynamicObject project) {
        return project.getDynamicObject("group");
    }

    public static void calculateByDate(IFormView view, List<DynamicObject> taskList, String appId) {
        for (DynamicObject task : taskList) {
            DynamicObject project = task.getDynamicObject("project");
            Date planStartTime = task.getDate("planstarttime");
            Date planEndTime = task.getDate("planendtime");
            BigDecimal newAbsoluteDuration = TaskUtil.getDaysBetweenTwoDate(project.getPkValue(), planStartTime, planEndTime, appId);
            task.set("absoluteduration", (Object)newAbsoluteDuration);
            if (task.getDynamicObject("belongplantype") != null) {
                DynamicObject belongPlanType = BusinessDataServiceHelper.loadSingleFromCache((Object)task.getDynamicObject("belongplantype").getString("id"), (String)MetaDataUtil.getEntityId((String)appId, (String)"majortype"));
                task.set("belongplantype", (Object)belongPlanType);
            }
            PlanTaskImpAndExpUtil.calCompTimeDeviation(view, task, appId);
        }
    }

    public static void calculateByAbsoluteDuration(IFormView view, List<DynamicObject> taskList, String appId) {
        for (DynamicObject task : taskList) {
            DynamicObject project = task.getDynamicObject("project");
            Date planStartTime = task.getDate("planstarttime");
            BigDecimal absoluteDuration = task.getBigDecimal("absoluteduration");
            Date newPlanEndTime = TaskUtil.getDateAfterAddDays(project.getPkValue(), planStartTime, absoluteDuration.intValue() - 1, appId);
            task.set("planendtime", (Object)newPlanEndTime);
            PlanTaskImpAndExpUtil.calCompTimeDeviation(view, task, appId);
        }
    }

    public static void calculateDeptByDate(IFormView view, List<DynamicObject> taskList, Object orgId, String appId) {
        for (DynamicObject task : taskList) {
            Date planStartTime = task.getDate("planstarttime");
            Date planEndTime = task.getDate("planendtime");
            BigDecimal newAbsoluteDuration = TaskUtil.getDaysBetweenTwoDateByOrg(orgId, planStartTime, planEndTime, appId);
            task.set("absoluteduration", (Object)newAbsoluteDuration.add(BigDecimal.ONE));
            PlanTaskImpAndExpUtil.calCompTimeDeviation(view, task, appId);
        }
    }

    public static void calculateDeptByAbsoluteDuration(IFormView view, List<DynamicObject> taskList, Object orgId, String appId) {
        for (DynamicObject task : taskList) {
            Date planStartTime = task.getDate("planstarttime");
            BigDecimal absoluteDuration = task.getBigDecimal("absoluteduration");
            Date newPlanEndTime = TaskUtil.getDateAfterAddDaysByOrg(orgId, planStartTime, absoluteDuration.intValue() - 1, appId);
            task.set("planendtime", (Object)newPlanEndTime);
            PlanTaskImpAndExpUtil.calCompTimeDeviation(view, task, appId);
        }
    }

    public static void calCompTimeDeviation(IFormView view, DynamicObject task, String appId) {
        BigDecimal days;
        Date aimFinishTime = task.getDate("aimfinishtime");
        Date planEndTime = task.getDate("planendtime");
        DynamicObject project = task.getDynamicObject("project");
        if (aimFinishTime == null || planEndTime == null) {
            return;
        }
        if (project != null) {
            try {
                days = TaskUtil.getDaysBetweenTwoDate(project.getPkValue(), planEndTime, aimFinishTime, appId).subtract(BigDecimal.ONE);
                task.set("comptimedeviation", (Object)days);
            }
            catch (KDBizException e) {
                view.showTipNotification(e.getMessage());
                days = new BigDecimal(DateUtil.getDaysBetweenTwoDate((Date)planEndTime, (Date)aimFinishTime));
            }
        } else {
            days = new BigDecimal(DateUtil.getDaysBetweenTwoDate((Date)planEndTime, (Date)aimFinishTime));
        }
        task.set("comptimedeviation", (Object)days);
    }

    public static void calCompTimeDeviation(DynamicObject task, String appId) {
        BigDecimal days;
        Date aimFinishTime = task.getDate("aimfinishtime");
        Date planEndTime = task.getDate("planendtime");
        DynamicObject project = task.getDynamicObject("project");
        if (aimFinishTime == null || planEndTime == null) {
            return;
        }
        if (project != null) {
            try {
                days = TaskUtil.getDaysBetweenTwoDate(project.getPkValue(), planEndTime, aimFinishTime, appId).subtract(BigDecimal.ONE);
            }
            catch (KDBizException e) {
                days = new BigDecimal(DateUtil.getDaysBetweenTwoDate((Date)planEndTime, (Date)aimFinishTime));
            }
        } else {
            days = new BigDecimal(DateUtil.getDaysBetweenTwoDate((Date)planEndTime, (Date)aimFinishTime));
        }
        task.set("comptimedeviation", (Object)days);
    }

    protected void extendsProperty(DynamicObject project, String columnKey, String cellValue, DynamicObject task, QFilter enableFilter) {
    }

    protected void createTask(IFormView view, JSONArray jArray, List<DynamicObject> taskList, int seq, String appId) {
        IDataModel model = view.getModel();
        DynamicObject majorType = (DynamicObject)model.getValue("majortype");
        boolean isFromMasterPlan = false;
        Object taskPk = 0L;
        for (Object taskColumn : jArray) {
            JSONObject jObject = JSONObject.parseObject((String)taskColumn.toString());
            String columnKey = jObject.getString("columnKey");
            Object cellValueObject = jObject.get((Object)"cellValue");
            if ("relationtask".equalsIgnoreCase(columnKey)) {
                if (!StringUtils.isNotBlank((Object)cellValueObject)) continue;
                isFromMasterPlan = true;
                continue;
            }
            if (!"id".equalsIgnoreCase(columnKey)) continue;
            taskPk = cellValueObject;
        }
        if (isFromMasterPlan) {
            DynamicObject task1 = BusinessDataServiceHelper.loadSingle((Object)taskPk, (DynamicObjectType)MetaDataUtil.getDT((String)appId, (String)"task"));
            taskList.add(task1);
            return;
        }
        DynamicObject task = null;
        ORM orm = ORM.create();
        Long taskId = orm.genLongId(MetaDataUtil.getEntityId((String)appId, (String)"task"));
        for (Object taskColumn : jArray) {
            JSONObject jObject = JSONObject.parseObject((String)taskColumn.toString());
            String columnKey = jObject.getString("columnKey");
            Object cellValueObject = jObject.get((Object)"cellValue");
            if (!columnKey.equalsIgnoreCase("id")) continue;
            if (cellValueObject == null || StringUtils.isEmpty((CharSequence)cellValueObject.toString())) {
                task = new DynamicObject(MetaDataUtil.getDT((String)appId, (String)"task"));
                task.set("id", (Object)taskId);
                break;
            }
            DynamicObject[] tasks = BusinessDataServiceHelper.load((Object[])new Object[]{cellValueObject}, (DynamicObjectType)MetaDataUtil.getDT((String)appId, (String)"task"));
            if (tasks == null || tasks.length == 0) {
                task = new DynamicObject(MetaDataUtil.getDT((String)appId, (String)"task"));
                task.set("id", (Object)taskId);
                break;
            }
            task = tasks[0];
            break;
        }
        if (task == null) {
            task = new DynamicObject(MetaDataUtil.getDT((String)appId, (String)"task"));
            task.set("id", (Object)taskId);
        }
        task.set("planid", model.getDataEntity().getPkValue());
        DynamicObject project = (DynamicObject)model.getValue("project");
        task.set("project", (Object)project);
        task.set("completionstatus", (Object)CompletionStatusEnum.UNSTART.getValue());
        task.set("taskseq", (Object)seq);
        task.set("enable", (Object)1);
        task.set("status", (Object)StatusEnum.TEMPSAVE.getValue());
        task.set("islatest", (Object)DefaultEnum.YES.getValue());
        task.set("version", (Object)BigDecimal.ONE);
        task.set("level", (Object)1);
        task.set("isleaf", (Object)Boolean.TRUE);
        task.set("belongplantype", (Object)majorType);
        task.set("tasksource", (Object)majorType);
        boolean isSamePerson = false;
        QFilter enableFilter = new QFilter("enable", "=", (Object)DefaultEnum.YES.getValue());
        for (Object column : jArray) {
            Object columnKey1;
            JSONObject columnValue1;
            String number;
            Object nameFilter;
            String cellValue;
            JSONObject jObject = JSONObject.parseObject((String)column.toString());
            String columnKey = jObject.getString("columnKey");
            Object cellValueObject = jObject.get((Object)"cellValue");
            if ((cellValueObject == null || StringUtils.isEmpty((CharSequence)cellValueObject.toString())) && !columnKey.equalsIgnoreCase("responsibledept") && !columnKey.equalsIgnoreCase("multicooperationdept")) continue;
            String string = cellValue = cellValueObject != null ? cellValueObject.toString() : "";
            if (columnKey.equalsIgnoreCase("name")) {
                task.set("name", (Object)cellValue);
            } else if (columnKey.equalsIgnoreCase("controllevel")) {
                nameFilter = new QFilter("name", "=", (Object)cellValue);
                DynamicObject controlLevel = BusinessDataServiceHelper.loadSingleFromCache((String)MetaDataUtil.getEntityId((String)appId, (String)"controllevel"), (String)"id", (QFilter[])new QFilter[]{nameFilter, enableFilter});
                task.set("controllevel", (Object)controlLevel);
            } else if (columnKey.equalsIgnoreCase("majortype")) {
                if (StringUtils.isBlank((CharSequence)cellValue)) continue;
                DynamicObject majorTypeObj = this.validMajorType(cellValue, appId, this.getGroup(project));
                if (majorTypeObj != null) {
                    task.set("majortype", (Object)majorTypeObj);
                }
            } else if (columnKey.equalsIgnoreCase("tasktype")) {
                nameFilter = new QFilter("name", "=", (Object)cellValue);
                QFilter proFilter = new QFilter("checkboxisprojecttask", "=", (Object)DefaultEnum.YES.getValue());
                DynamicObject taskType = BusinessDataServiceHelper.loadSingleFromCache((String)MetaDataUtil.getEntityId((String)appId, (String)"tasktype"), (String)"id,name", (QFilter[])new QFilter[]{enableFilter, nameFilter, proFilter});
                if (taskType != null) {
                    task.set("tasktype", (Object)taskType);
                }
            } else if (columnKey.equalsIgnoreCase("achievementnode")) {
                if (DefaultEnum.YES.getName().equals(cellValue)) {
                    task.set("achievementnode", (Object)DefaultEnum.YES.getValue());
                } else {
                    task.set("achievementnode", (Object)DefaultEnum.NO.getValue());
                }
            } else if (columnKey.equalsIgnoreCase("pretask")) {
                if (StringUtils.isBlank((CharSequence)cellValue)) continue;
                for (DynamicObject preTask : taskList) {
                    if (!cellValue.equals(preTask.getString("name"))) continue;
                    task.set("pretask", (Object)preTask);
                    break;
                }
            } else if (columnKey.equalsIgnoreCase("logical")) {
                if (StringUtils.isBlank((CharSequence)cellValue)) continue;
                if (cellValue.equalsIgnoreCase(LogicalEnum.START_START.getName())) {
                    task.set("logical", (Object)LogicalEnum.START_START.getValue());
                } else if (cellValue.equalsIgnoreCase(LogicalEnum.START_FINISH.getName())) {
                    task.set("logical", (Object)LogicalEnum.START_FINISH.getValue());
                } else if (cellValue.equalsIgnoreCase(LogicalEnum.FINISH_START.getName())) {
                    task.set("logical", (Object)LogicalEnum.FINISH_START.getValue());
                } else if (cellValue.equalsIgnoreCase(LogicalEnum.FINISH_FINISH.getName())) {
                    task.set("logical", (Object)LogicalEnum.FINISH_FINISH.getValue());
                }
            } else if (columnKey.equalsIgnoreCase("parent")) {
                if (StringUtils.isBlank((CharSequence)cellValue)) continue;
                for (DynamicObject parentTask : taskList) {
                    if (!cellValue.equals(parentTask.getString("name"))) continue;
                    task.set("parent", (Object)parentTask);
                    BigDecimal level = parentTask.getBigDecimal("level").add(BigDecimal.ONE);
                    task.set("level", (Object)level);
                    parentTask.set("isleaf", (Object)Boolean.FALSE);
                }
            } else if (columnKey.equalsIgnoreCase("relativeduration")) {
                task.set("relativeduration", (Object)new BigDecimal(cellValue));
            } else if (columnKey.equalsIgnoreCase("absoluteduration")) {
                task.set("absoluteduration", (Object)new BigDecimal(cellValue));
            } else if (columnKey.equalsIgnoreCase("planstarttime")) {
                Date planEndTime = new Date();
                try {
                    planEndTime.setTime(Long.parseLong(cellValue));
                }
                catch (NumberFormatException e) {
                    try {
                        planEndTime = this.sdf.parse(cellValue);
                    }
                    catch (ParseException e1) {
                        logger.info(String.format("Excel\u4e2d\u5bfc\u5165\u7684\u65e5\u671f\u201c%s\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", cellValue));
                    }
                }
                task.set("planstarttime", (Object)planEndTime);
            } else if (columnKey.equalsIgnoreCase("planendtime")) {
                Date planStartTime = new Date();
                try {
                    planStartTime.setTime(Long.parseLong(cellValue));
                }
                catch (NumberFormatException e) {
                    try {
                        planStartTime = this.sdf.parse(cellValue);
                    }
                    catch (ParseException e1) {
                        logger.info(String.format("Excel\u4e2d\u5bfc\u5165\u7684\u65e5\u671f\u201c%s\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", cellValue));
                    }
                }
                task.set("planendtime", (Object)planStartTime);
            } else if (columnKey.equalsIgnoreCase("aimfinishtime")) {
                if (StringUtils.isNotBlank((CharSequence)cellValue)) {
                    Date aimFinishTime = new Date();
                    try {
                        aimFinishTime.setTime(Long.parseLong(cellValue));
                    }
                    catch (NumberFormatException e) {
                        try {
                            aimFinishTime = this.sdf.parse(cellValue);
                        }
                        catch (ParseException e1) {
                            logger.info(String.format("Excel\u4e2d\u5bfc\u5165\u7684\u65e5\u671f\u201c%s\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", cellValue));
                        }
                    }
                    task.set("aimfinishtime", (Object)aimFinishTime);
                }
            } else if (columnKey.equalsIgnoreCase("responsibleperson")) {
                QFilter nameFilter2;
                DynamicObject directPerson;
                number = null;
                for (Object columnData : jArray) {
                    columnValue1 = JSONObject.parseObject((String)columnData.toString());
                    columnKey1 = columnValue1.getString("columnKey");
                    if (!((String)columnKey1).equalsIgnoreCase("responsibleperson.number")) continue;
                    number = columnValue1.getString("cellValue");
                    break;
                }
                QFilter numberFilter = null;
                if (StringUtils.isNotBlank(number)) {
                    numberFilter = new QFilter("number", "=", number);
                }
                if ((directPerson = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{nameFilter2 = new QFilter("name", "=", (Object)cellValue), numberFilter, enableFilter})) != null) {
                    task.set("responsibleperson", (Object)directPerson);
                }
            } else if (columnKey.equalsIgnoreCase("responsibledept")) {
                DynamicObject directPerson = task.getDynamicObject("responsibleperson");
                if (directPerson != null && StringUtils.isNotBlank((CharSequence)cellValue)) {
                    List deptIds = UserServiceHelper.getUserDepartment((long)Long.parseLong(directPerson.getPkValue().toString()), (boolean)false);
                    QFilter directPersonFilter = new QFilter("id", "in", (Object)deptIds);
                    Map directOrgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{directPersonFilter, enableFilter});
                    for (Map.Entry entry : directOrgs.entrySet()) {
                        DynamicObject entry2 = (DynamicObject)entry.getValue();
                        if (!cellValue.equals(entry2.getString("name"))) continue;
                        task.set("responsibledept", entry2.getPkValue());
                        break;
                    }
                } else if (directPerson != null && StringUtils.isBlank((CharSequence)cellValue)) {
                    long orgid = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(directPerson.getPkValue().toString()));
                    task.set("responsibledept", (Object)orgid);
                } else {
                    QFilter nameFilter3 = new QFilter("name", "=", (Object)cellValue);
                    DynamicObject directOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{nameFilter3, enableFilter});
                    if (directOrg != null) {
                        task.set("responsibledept", (Object)directOrg);
                    }
                }
            } else if (columnKey.equalsIgnoreCase("multicooperationperson")) {
                Iterator numberFilter;
                if (StringUtils.isBlank((CharSequence)cellValue)) continue;
                number = null;
                for (Object columnData : jArray) {
                    columnValue1 = JSONObject.parseObject((String)columnData.toString());
                    columnKey1 = columnValue1.getString("columnKey");
                    if (!((String)columnKey1).equalsIgnoreCase("multicooperationperson.number")) continue;
                    number = columnValue1.getString("cellValue");
                    break;
                }
                String[] cooPersonStrs = cellValue.split(";|\uff1b");
                String[] cooPersonNumStrs = new String[]{};
                if (StringUtils.isNotBlank((CharSequence)number)) {
                    cooPersonNumStrs = number.split(";|\uff1b");
                }
                DynamicObjectCollection cooPersonCol = new DynamicObjectCollection();
                for (int i = 0; i < cooPersonStrs.length; ++i) {
                    QFilter qFilter = new QFilter("name", "=", (Object)cooPersonStrs[i]);
                    numberFilter = null;
                    if (cooPersonNumStrs.length > i && StringUtils.isNotBlank((CharSequence)cooPersonNumStrs[i])) {
                        numberFilter = new QFilter("number", "=", (Object)cooPersonNumStrs[i]);
                    }
                    DynamicObject cooPerson = BusinessDataServiceHelper.loadSingle((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{qFilter, numberFilter, enableFilter});
                    cooPersonCol.add((Object)cooPerson);
                }
                DynamicObjectCollection cooperationPerson = task.getDynamicObjectCollection("multicooperationperson");
                DynamicObjectType dynamicObjectType = cooperationPerson.getDynamicObjectType();
                cooperationPerson.clear();
                numberFilter = cooPersonCol.iterator();
                while (numberFilter.hasNext()) {
                    DynamicObject coper = (DynamicObject)numberFilter.next();
                    DynamicObject copersonRow = new DynamicObject(dynamicObjectType);
                    copersonRow.set("pkid", (Object)orm.genLongId((IDataEntityType)dynamicObjectType));
                    copersonRow.set("fbasedataid", (Object)coper);
                    copersonRow.set("fbasedataid_id", coper.getPkValue());
                    cooperationPerson.add((Object)copersonRow);
                }
                if (cooperationPerson.size() != 0) {
                    task.set("multicooperationperson", (Object)cooperationPerson);
                    DynamicObject responsiblePerson = task.getDynamicObject("responsibleperson");
                    if (responsiblePerson != null && cooperationPerson.stream().map(o -> o.getPkValue().toString().equals(responsiblePerson.getPkValue())).filter(o -> o).count() > 0L) {
                        task.set("multicooperationperson", null);
                        isSamePerson = true;
                    }
                }
            } else if (columnKey.equalsIgnoreCase("multicooperationdept")) {
                if (StringUtils.isBlank((CharSequence)cellValue)) {
                    DynamicObjectCollection cooPersons = task.getDynamicObjectCollection("multicooperationperson");
                    if (cooPersons == null || cooPersons.size() <= 0) continue;
                    ArrayList cooDeptIds = new ArrayList();
                    cooPersons.stream().map(o -> cooDeptIds.add(UserServiceHelper.getUserMainOrgId((long)o.getLong("fbasedataid_id")))).count();
                    DynamicObjectCollection cooDepts = new DynamicObjectCollection();
                    for (Long cooDeptId : cooDeptIds) {
                        if (cooDeptId <= 0L) continue;
                        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)cooDeptId, (String)"bos_org");
                        cooDepts.add((Object)dynamicObject);
                    }
                    DynamicObjectType DT = task.getDynamicObjectCollection("multicooperationdept").getDynamicObjectType();
                    DynamicObjectCollection cooDeptsCOL = new DynamicObjectCollection();
                    for (Object cooD : cooDepts) {
                        DynamicObject cooDept = new DynamicObject(DT);
                        cooDept.set("pkid", (Object)orm.genLongId((IDataEntityType)DT));
                        cooDept.set("fbasedataid", cooD);
                        cooDept.set("fbasedataid_id", cooD.getPkValue());
                        cooDeptsCOL.add((Object)cooDept);
                    }
                    task.set("multicooperationdept", (Object)cooDeptsCOL);
                    continue;
                }
                if (isSamePerson) {
                    task.set("multicooperationdept", null);
                    continue;
                }
                DynamicObjectCollection inDirectPerson = (DynamicObjectCollection)task.get("multicooperationperson");
                if (inDirectPerson != null) {
                    Object cooD;
                    ArrayList inDeptIds = new ArrayList();
                    inDirectPerson.stream().map(o -> inDeptIds.addAll(UserServiceHelper.getUserDepartment((long)o.getLong("fbasedataid_id"), (boolean)false))).count();
                    QFilter inDirectDeptsFilter = new QFilter("id", "in", inDeptIds);
                    Map indirectOrgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{inDirectDeptsFilter, enableFilter});
                    DynamicObjectCollection depts = task.getDynamicObjectCollection("multicooperationdept");
                    DynamicObjectType dynamicObjectType = depts.getDynamicObjectType();
                    depts.clear();
                    cooD = indirectOrgs.entrySet().iterator();
                    while (cooD.hasNext()) {
                        Map.Entry item = (Map.Entry)cooD.next();
                        DynamicObject entry = (DynamicObject)item.getValue();
                        DynamicObject entrydept = new DynamicObject(dynamicObjectType);
                        if (!cellValue.contains(entry.getString("name"))) continue;
                        entrydept.set("pkid", (Object)orm.genLongId((IDataEntityType)dynamicObjectType));
                        entrydept.set("fbasedataid", (Object)entry);
                        entrydept.set("fbasedataid_id", entry.getPkValue());
                        depts.add((Object)entrydept);
                    }
                    task.set("multicooperationdept", (Object)depts);
                } else {
                    String[] cooDeptStrs = cellValue.split(";|\uff1b");
                    DynamicObjectCollection indirectOrgs = new DynamicObjectCollection();
                    for (int i = 0; i < cooDeptStrs.length; ++i) {
                        QFilter nameFilter5 = new QFilter("name", "=", (Object)cooDeptStrs[i]);
                        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{nameFilter5, enableFilter});
                        indirectOrgs.add((Object)dynamicObject);
                    }
                    DynamicObjectCollection orgs = task.getDynamicObjectCollection("multicooperationdept");
                    DynamicObjectType dt2 = orgs.getDynamicObjectType();
                    orgs.clear();
                    for (DynamicObject indOrg : indirectOrgs) {
                        DynamicObject iOrg = new DynamicObject(dt2);
                        iOrg.set("pkid", (Object)orm.genLongId((IDataEntityType)dt2));
                        iOrg.set("fbasedataid", (Object)indOrg);
                        iOrg.set("fbasedataid_id", indOrg.getPkValue());
                        orgs.add((Object)indOrg);
                    }
                    if (indirectOrgs != null) {
                        task.set("multicooperationdept", (Object)orgs);
                    }
                }
            } else if (columnKey.equalsIgnoreCase("comment")) {
                if (StringUtils.isBlank((CharSequence)cellValue)) continue;
                task.set("comment", (Object)cellValue);
            }
            this.extendsProperty(project, columnKey, cellValue, task, enableFilter);
        }
        taskList.add(task);
    }

    protected void createDeptTask(IFormView view, JSONArray jArray, List<DynamicObject> taskList, String appId, int seq) {
        IDataModel model = view.getModel();
        DynamicObject task = new DynamicObject(MetaDataUtil.getDT((String)appId, (String)"task"));
        ORM orm = ORM.create();
        Long taskId = orm.genLongId(MetaDataUtil.getEntityId((String)appId, (String)"task"));
        task.set("id", (Object)taskId);
        task.set("taskseq", (Object)seq);
        task.set("planid", model.getDataEntity().getPkValue());
        task.set("project", null);
        task.set("completionstatus", (Object)CompletionStatusEnum.UNSTART.getValue());
        task.set("enable", (Object)1);
        task.set("status", (Object)StatusEnum.TEMPSAVE.getValue());
        task.set("islatest", (Object)DefaultEnum.YES.getValue());
        task.set("version", (Object)BigDecimal.ONE);
        task.set("level", (Object)1);
        task.set("isleaf", (Object)Boolean.TRUE);
        QFilter tasksourceFilter = new QFilter("number", "=", (Object)"TRANSACTIONPLAN_S");
        DynamicObject tasksource = BusinessDataServiceHelper.loadSingle((String)(appId + "_tasksource"), (String)"id,number,name,group", (QFilter[])new QFilter[]{tasksourceFilter});
        task.set("tasksource", (Object)tasksource);
        QFilter plantypeFilter = new QFilter("plantype", "=", (Object)PlanTypeEnum.DEPTPLAN.getValue());
        DynamicObject belongplantype = BusinessDataServiceHelper.loadSingle((String)(appId + "_plantype"), (String)"id,number,name,plantype,group", (QFilter[])new QFilter[]{plantypeFilter});
        task.set("belongplantype", (Object)belongplantype);
        task.set("achievementnode", (Object)DefaultEnum.NO.getValue());
        boolean isSamePerson = false;
        QFilter enableFilter = new QFilter("enable", "=", (Object)DefaultEnum.YES.getValue());
        for (Object column : jArray) {
            Object columnKey1;
            JSONObject columnValue1;
            String number;
            String cellValue;
            JSONObject jObject = JSONObject.parseObject((String)column.toString());
            String columnKey = jObject.getString("columnKey");
            Object cellValueObject = jObject.get((Object)"cellValue");
            if ((cellValueObject == null || StringUtils.isEmpty((CharSequence)cellValueObject.toString())) && !columnKey.equalsIgnoreCase("responsibledept") && !columnKey.equalsIgnoreCase("multicooperationdept")) continue;
            String string = cellValue = cellValueObject != null ? cellValueObject.toString() : "";
            if (columnKey.equalsIgnoreCase("name")) {
                task.set("name", (Object)cellValue);
            } else if (columnKey.equalsIgnoreCase("tasktype")) {
                QFilter nameFilter = new QFilter("name", "=", (Object)cellValue);
                QFilter proFilter = new QFilter("checkboxisprojecttask", "!=", (Object)DefaultEnum.YES.getValue());
                DynamicObject taskType = BusinessDataServiceHelper.loadSingleFromCache((String)MetaDataUtil.getEntityId((String)appId, (String)"tasktype"), (String)"id,name", (QFilter[])new QFilter[]{enableFilter, nameFilter, proFilter});
                if (taskType != null) {
                    task.set("tasktype", (Object)taskType);
                }
            } else if (columnKey.equalsIgnoreCase("parent")) {
                if (StringUtils.isBlank((CharSequence)cellValue)) continue;
                for (DynamicObject parentTask : taskList) {
                    if (!cellValue.equals(parentTask.getString("name"))) continue;
                    task.set("parent", (Object)parentTask);
                    BigDecimal level = parentTask.getBigDecimal("level").add(BigDecimal.ONE);
                    task.set("level", (Object)level);
                    parentTask.set("isleaf", (Object)Boolean.FALSE);
                }
            } else if (columnKey.equalsIgnoreCase("absoluteduration")) {
                task.set("absoluteduration", (Object)new BigDecimal(cellValue));
            } else if (columnKey.equalsIgnoreCase("planstarttime")) {
                Date planStartTime = new Date();
                try {
                    planStartTime.setTime(Long.parseLong(cellValue));
                }
                catch (NumberFormatException e) {
                    try {
                        planStartTime = this.sdf.parse(cellValue);
                    }
                    catch (ParseException e1) {
                        logger.info(String.format("Excel\u4e2d\u5bfc\u5165\u7684\u65e5\u671f\u201c%s\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", cellValue));
                    }
                }
                task.set("planstarttime", (Object)planStartTime);
            } else if (columnKey.equalsIgnoreCase("planendtime")) {
                Date planEndTime = new Date();
                try {
                    planEndTime.setTime(Long.parseLong(cellValue));
                }
                catch (NumberFormatException e) {
                    try {
                        planEndTime = this.sdf.parse(cellValue);
                    }
                    catch (ParseException e1) {
                        logger.info(String.format("Excel\u4e2d\u5bfc\u5165\u7684\u65e5\u671f\u201c%s\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", cellValue));
                    }
                }
                task.set("planendtime", (Object)planEndTime);
            } else if (columnKey.equalsIgnoreCase("aimfinishtime")) {
                if (StringUtils.isNotBlank((CharSequence)cellValue)) {
                    Date aimFinishTime = new Date();
                    try {
                        aimFinishTime.setTime(Long.parseLong(cellValue));
                    }
                    catch (NumberFormatException e) {
                        try {
                            aimFinishTime = this.sdf.parse(cellValue);
                        }
                        catch (ParseException e1) {
                            logger.info(String.format("Excel\u4e2d\u5bfc\u5165\u7684\u65e5\u671f\u201c%s\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", cellValue));
                        }
                    }
                    task.set("aimfinishtime", (Object)aimFinishTime);
                }
            } else if (columnKey.equalsIgnoreCase("responsibleperson")) {
                QFilter nameFilter;
                DynamicObject directPerson;
                number = null;
                for (Object columnData : jArray) {
                    columnValue1 = JSONObject.parseObject((String)columnData.toString());
                    columnKey1 = columnValue1.getString("columnKey");
                    if (!((String)columnKey1).equalsIgnoreCase("responsibleperson.number")) continue;
                    number = columnValue1.getString("cellValue");
                    break;
                }
                QFilter numberFilter = null;
                if (StringUtils.isNotBlank(number)) {
                    numberFilter = new QFilter("number", "=", number);
                }
                if ((directPerson = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{nameFilter = new QFilter("name", "=", (Object)cellValue), numberFilter, enableFilter})) != null) {
                    task.set("responsibleperson", (Object)directPerson);
                }
            } else if (columnKey.equalsIgnoreCase("responsibledept")) {
                DynamicObject directPerson = task.getDynamicObject("responsibleperson");
                if (directPerson != null && StringUtils.isNotBlank((CharSequence)cellValue)) {
                    List deptIds = UserServiceHelper.getUserDepartment((long)Long.parseLong(directPerson.getPkValue().toString()), (boolean)false);
                    QFilter directPersonFilter = new QFilter("id", "in", (Object)deptIds);
                    Map directOrgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{directPersonFilter, enableFilter});
                    for (Map.Entry entry : directOrgs.entrySet()) {
                        DynamicObject entry2 = (DynamicObject)entry.getValue();
                        if (!cellValue.equals(entry2.getString("name"))) continue;
                        task.set("responsibledept", entry2.getPkValue());
                        break;
                    }
                } else if (directPerson != null && StringUtils.isBlank((CharSequence)cellValue)) {
                    long orgid = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(directPerson.getPkValue().toString()));
                    task.set("responsibledept", (Object)orgid);
                } else {
                    QFilter nameFilter = new QFilter("name", "=", (Object)cellValue);
                    DynamicObject directOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{nameFilter, enableFilter});
                    if (directOrg != null) {
                        task.set("responsibledept", (Object)directOrg);
                    }
                }
            } else if (columnKey.equalsIgnoreCase("multicooperationperson")) {
                if (StringUtils.isBlank((CharSequence)cellValue)) continue;
                number = null;
                for (Object columnData : jArray) {
                    columnValue1 = JSONObject.parseObject((String)columnData.toString());
                    columnKey1 = columnValue1.getString("columnKey");
                    if (!((String)columnKey1).equalsIgnoreCase("multicooperationperson.number")) continue;
                    number = columnValue1.getString("cellValue");
                    break;
                }
                String[] cooPersonStrs = cellValue.split(";|\uff1b");
                String[] cooPersonNumStrs = new String[]{};
                if (StringUtils.isNotBlank((CharSequence)number)) {
                    cooPersonNumStrs = number.split(";|\uff1b");
                }
                DynamicObjectCollection cooPersonCol = new DynamicObjectCollection();
                for (int i = 0; i < cooPersonStrs.length; ++i) {
                    QFilter qFilter = new QFilter("name", "=", (Object)cooPersonStrs[i]);
                    QFilter numberFilter = null;
                    if (cooPersonNumStrs.length > i && StringUtils.isNotBlank((CharSequence)cooPersonNumStrs[i])) {
                        numberFilter = new QFilter("number", "=", (Object)cooPersonNumStrs[i]);
                    }
                    DynamicObject cooPerson = BusinessDataServiceHelper.loadSingle((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{qFilter, numberFilter, enableFilter});
                    cooPersonCol.add((Object)cooPerson);
                }
                DynamicObjectCollection cooperationPerson = task.getDynamicObjectCollection("multicooperationperson");
                DynamicObjectType dynamicObjectType = cooperationPerson.getDynamicObjectType();
                cooperationPerson.clear();
                Iterator numberFilter = cooPersonCol.iterator();
                while (numberFilter.hasNext()) {
                    DynamicObject coper = (DynamicObject)numberFilter.next();
                    DynamicObject copersonRow = new DynamicObject(dynamicObjectType);
                    copersonRow.set("pkid", (Object)orm.genLongId((IDataEntityType)dynamicObjectType));
                    copersonRow.set("fbasedataid", (Object)coper);
                    copersonRow.set("fbasedataid_id", coper.getPkValue());
                    cooperationPerson.add((Object)copersonRow);
                }
                if (cooperationPerson.size() != 0) {
                    task.set("multicooperationperson", (Object)cooperationPerson);
                    DynamicObject responsiblePerson = task.getDynamicObject("responsibleperson");
                    if (responsiblePerson != null && cooperationPerson.stream().map(o -> o.getPkValue().toString().equals(responsiblePerson.getPkValue())).filter(o -> o).count() > 0L) {
                        task.set("multicooperationperson", null);
                        isSamePerson = true;
                    }
                }
            } else if (columnKey.equalsIgnoreCase("multicooperationdept")) {
                if (StringUtils.isBlank((CharSequence)cellValue)) {
                    DynamicObjectCollection cooPersons = task.getDynamicObjectCollection("multicooperationperson");
                    if (cooPersons == null || cooPersons.size() <= 0) continue;
                    ArrayList cooDeptIds = new ArrayList();
                    cooPersons.stream().map(o -> cooDeptIds.add(UserServiceHelper.getUserMainOrgId((long)o.getLong("fbasedataid_id")))).count();
                    DynamicObjectCollection cooDepts = new DynamicObjectCollection();
                    for (Long cooDeptId : cooDeptIds) {
                        if (cooDeptId <= 0L) continue;
                        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)cooDeptId, (String)"bos_org");
                        cooDepts.add((Object)dynamicObject);
                    }
                    DynamicObjectType DT = task.getDynamicObjectCollection("multicooperationdept").getDynamicObjectType();
                    DynamicObjectCollection cooDeptsCOL = new DynamicObjectCollection();
                    for (DynamicObject cooD : cooDepts) {
                        DynamicObject cooDept = new DynamicObject(DT);
                        cooDept.set("pkid", (Object)orm.genLongId((IDataEntityType)DT));
                        cooDept.set("fbasedataid", (Object)cooD);
                        cooDept.set("fbasedataid_id", cooD.getPkValue());
                        cooDeptsCOL.add((Object)cooDept);
                    }
                    task.set("multicooperationdept", (Object)cooDeptsCOL);
                    continue;
                }
                if (isSamePerson) {
                    task.set("multicooperationperson", null);
                    task.set("multicooperationdept", null);
                    continue;
                }
                DynamicObjectCollection inDirectPerson = (DynamicObjectCollection)task.get("multicooperationperson");
                if (inDirectPerson != null) {
                    ArrayList inDeptIds = new ArrayList();
                    inDirectPerson.stream().map(o -> inDeptIds.addAll(UserServiceHelper.getUserDepartment((long)o.getLong("fbasedataid_id"), (boolean)false))).count();
                    QFilter inDirectDeptsFilter = new QFilter("id", "in", inDeptIds);
                    Map indirectOrgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{inDirectDeptsFilter, enableFilter});
                    DynamicObjectCollection depts = task.getDynamicObjectCollection("multicooperationdept");
                    DynamicObjectType dynamicObjectType = depts.getDynamicObjectType();
                    depts.clear();
                    for (Map.Entry item : indirectOrgs.entrySet()) {
                        DynamicObject entry = (DynamicObject)item.getValue();
                        DynamicObject entrydept = new DynamicObject(dynamicObjectType);
                        if (!cellValue.contains(entry.getString("name"))) continue;
                        entrydept.set("pkid", (Object)orm.genLongId((IDataEntityType)dynamicObjectType));
                        entrydept.set("fbasedataid", (Object)entry);
                        entrydept.set("fbasedataid_id", entry.getPkValue());
                        depts.add((Object)entrydept);
                    }
                    task.set("multicooperationdept", (Object)depts);
                } else {
                    QFilter nameFilter = new QFilter("name", "in", (Object)cellValue.split(";|\uff1b"));
                    DynamicObject[] indirectOrg = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{nameFilter, enableFilter});
                    DynamicObjectCollection orgs = task.getDynamicObjectCollection("multicooperationdept");
                    DynamicObjectType dt2 = orgs.getDynamicObjectType();
                    orgs.clear();
                    for (DynamicObject indOrg : indirectOrg) {
                        DynamicObject iOrg = new DynamicObject(dt2);
                        iOrg.set("pkid", (Object)orm.genLongId((IDataEntityType)dt2));
                        iOrg.set("fbasedataid", (Object)indOrg);
                        iOrg.set("fbasedataid_id", indOrg.getPkValue());
                        orgs.add((Object)indOrg);
                    }
                    if (indirectOrg != null) {
                        task.set("multicooperationdept", (Object)orgs);
                    }
                }
            }
            this.extendsProperty(null, columnKey, cellValue, task, enableFilter);
        }
        taskList.add(task);
    }

    protected List<String> getControlLevelList() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf(DefaultEnum.YES.getValue().charAt(0)));
        DynamicObject[] controlLevelList = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.view.getFormShowParameter().getFormId().split("_")[0], (String)"controllevel"), (String)"name", (QFilter[])new QFilter[]{enableFilter});
        return Arrays.stream(controlLevelList).map(entry -> entry.getLocaleString("name").getLocaleValue()).collect(Collectors.toList());
    }

    protected List<String> getMajorTypeList() {
        DynamicObject projectKind;
        DynamicObject project;
        QFilter projectKindFilter = null;
        IDataEntityProperty projectProperty = this.view.getParentView().getModel().getDataEntityType().findProperty("project");
        projectKindFilter = projectProperty != null ? ((project = (DynamicObject)this.view.getParentView().getModel().getValue("project")) != null ? new QFilter("group", "=", (projectKind = this.getGroup(project)) == null ? Long.valueOf(0L) : projectKind.getPkValue()).or("group", "=", (Object)0L) : new QFilter("group", "=", (Object)0L)) : new QFilter("group", "=", (Object)0L);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf(DefaultEnum.YES.getValue().charAt(0)));
        QFilter majorTypeFilter = new QFilter("plantype", "=", (Object)PlanTypeEnum.MAJORPLAN.getValue());
        DynamicObject[] majorTypeList = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.view.getFormShowParameter().getFormId().split("_")[0], (String)"majortype"), (String)"name", (QFilter[])new QFilter[]{enableFilter, projectKindFilter, majorTypeFilter});
        return Arrays.stream(majorTypeList).map(entry -> entry.getLocaleString("name").getLocaleValue()).collect(Collectors.toList());
    }

    protected List<String> getTaskTypeList(String appId) {
        String name = this.view.getParentView().getModel().getDataEntityType().getName();
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf(DefaultEnum.YES.getValue().charAt(0)));
        QFilter qFilter = null;
        DynamicObject[] taskTypeList = null;
        qFilter = StringUtil.equals((String)name, (String)(appId + "_deptplan")) ? new QFilter("checkboxisprojecttask", "!=", (Object)"1") : new QFilter("checkboxisprojecttask", "=", (Object)"1");
        taskTypeList = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.view.getFormShowParameter().getFormId().split("_")[0], (String)"tasktype"), (String)"name,checkboxisprojecttask", (QFilter[])new QFilter[]{enableFilter, qFilter});
        return Arrays.stream(taskTypeList).map(entry -> entry.getLocaleString("name").getLocaleValue()).collect(Collectors.toList());
    }
}

