/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.business.utils.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.format.DateFormatObject;
import kd.bos.entity.format.FormatObject;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.pccs.placs.common.enums.DefaultEnum;
import kd.pccs.placs.common.enums.LogicalEnum;
import kd.pccs.placs.common.utils.poi.POIHelper;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddressList;

public class PlanTaskPOIHelper {
    private static final Log logger = LogFactory.getLog(PlanTaskPOIHelper.class);
    private List<String> controlLevelList;
    private List<String> majorTypeList;
    private List<String> taskTypeList;

    public String exportExcel(String fileName, String sheetName, String[] header, String[] columnKey, List<String> mustFillColumn, JSONArray data) {
        Cell nameCell;
        int i;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        Row columnKeyHashRow = sheet.createRow(0);
        columnKeyHashRow.setHeight((short)0);
        Cell columnKeyHashCell = columnKeyHashRow.createCell(0);
        columnKeyHashCell.setCellValue(POIHelper.stringArrayToHash((String[])columnKey));
        Row columnKeyRow = sheet.createRow(1);
        columnKeyRow.setHeight((short)0);
        Row nameRow = sheet.createRow(2);
        List<String> columnKeyList = Arrays.asList(columnKey);
        int nameColumnIndex = columnKeyList.indexOf("name");
        sheet.addValidationData((DataValidation)this.setTip("name", 3, 1000, nameColumnIndex, nameColumnIndex, ResManager.loadKDString((String)"\u6587\u672c\u5b57\u7b26\u4e32", (String)"PlanTaskPOIHelper_0", (String)"pccs-placs-business", (Object[])new Object[0])));
        int controlLevelColumnIndex = columnKeyList.indexOf("controllevel");
        sheet.addValidationData((DataValidation)this.setTip("controllevel", 3, 1000, controlLevelColumnIndex, controlLevelColumnIndex, ResManager.loadKDString((String)"\u7ba1\u63a7\u7ea7\u522b\u57fa\u7840\u8d44\u6599\uff0c\u652f\u6301\u5f55\u5165\u540d\u79f0\u3002", (String)"PlanTaskPOIHelper_1", (String)"pccs-placs-business", (Object[])new Object[0])));
        int majorTypeColumnIndex = columnKeyList.indexOf("majortype");
        sheet.addValidationData((DataValidation)this.setTip("majortype", 3, 1000, majorTypeColumnIndex, majorTypeColumnIndex, ResManager.loadKDString((String)"\u4e13\u4e1a\u7c7b\u578b\u57fa\u7840\u8d44\u6599\uff0c\u652f\u6301\u5f55\u5165\u540d\u79f0\u3002", (String)"PlanTaskPOIHelper_2", (String)"pccs-placs-business", (Object[])new Object[0])));
        int taskTypeColumnIndex = columnKeyList.indexOf("tasktype");
        sheet.addValidationData((DataValidation)this.setTip("tasktype", 3, 1000, taskTypeColumnIndex, taskTypeColumnIndex, ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b\u57fa\u7840\u8d44\u6599\uff0c\u652f\u6301\u5f55\u5165\u540d\u79f0\u3002", (String)"PlanTaskPOIHelper_3", (String)"pccs-placs-business", (Object[])new Object[0])));
        int achievementNodeColumnIndex = columnKeyList.indexOf("achievementnode");
        sheet.addValidationData((DataValidation)this.setTip("achievementnode", 3, 1000, achievementNodeColumnIndex, achievementNodeColumnIndex, ResManager.loadKDString((String)"\u679a\u4e3e\u503c", (String)"PlanTaskPOIHelper_4", (String)"pccs-placs-business", (Object[])new Object[0])));
        int preTaskColumnIndex = columnKeyList.indexOf("pretask");
        sheet.addValidationData((DataValidation)this.setTip("pretask", 3, 1000, preTaskColumnIndex, preTaskColumnIndex, ResManager.loadKDString((String)"\u586b\u5199\u4efb\u52a1\u540d\u79f0\u3002\u6ce8\u610f\uff1a\u524d\u7f6e\u4efb\u52a1\u4e0d\u80fd\u4e3a\u4e0a\u7ea7\u4efb\u52a1\uff0c\u5426\u5219\u5bfc\u5165\u540e\u4f1a\u5bfc\u81f4\u6570\u636e\u5f02\u5e38\u5e76\u62a5\u9519\u3002", (String)"PlanTaskPOIHelper_19", (String)"pccs-placs-business", (Object[])new Object[0])));
        int logicalColumnIndex = columnKeyList.indexOf("logical");
        sheet.addValidationData((DataValidation)this.setTip("logical", 3, 1000, logicalColumnIndex, logicalColumnIndex, ResManager.loadKDString((String)"\u679a\u4e3e\u503c", (String)"PlanTaskPOIHelper_4", (String)"pccs-placs-business", (Object[])new Object[0])));
        int parentColumnIndex = columnKeyList.indexOf("parent");
        sheet.addValidationData((DataValidation)this.setTip("parent", 3, 1000, parentColumnIndex, parentColumnIndex, ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0", (String)"PlanTaskPOIHelper_6", (String)"pccs-placs-business", (Object[])new Object[0])));
        int relativeDurationColumnIndex = columnKeyList.indexOf("relativeduration");
        sheet.addValidationData((DataValidation)this.setTip("relativeduration", 3, 1000, relativeDurationColumnIndex, relativeDurationColumnIndex, ResManager.loadKDString((String)"\u6574\u6570", (String)"PlanTaskPOIHelper_14", (String)"pccs-placs-business", (Object[])new Object[0])));
        int absoluteDurationColumnIndex = columnKeyList.indexOf("absoluteduration");
        sheet.addValidationData((DataValidation)this.setTip("absoluteduration", 3, 1000, absoluteDurationColumnIndex, absoluteDurationColumnIndex, ResManager.loadKDString((String)"\u6b63\u6574\u6570", (String)"PlanTaskPOIHelper_15", (String)"pccs-placs-business", (Object[])new Object[0])));
        FormatObject formatObject = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
        DateFormatObject dateFormat = formatObject.getDateFormat();
        int planStartTimeColumnIndex = columnKeyList.indexOf("planstarttime");
        sheet.addValidationData((DataValidation)this.setTip("planstarttime", 3, 1000, planStartTimeColumnIndex, planStartTimeColumnIndex, String.format(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\uff1a%s", (String)"PlanTaskPOIHelper_8", (String)"pccs-placs-business", (Object[])new Object[0]), dateFormat.getDateFormat())));
        int planEndTimeColumnIndex = columnKeyList.indexOf("planendtime");
        sheet.addValidationData((DataValidation)this.setTip("planendtime", 3, 1000, planEndTimeColumnIndex, planEndTimeColumnIndex, String.format(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\uff1a%s", (String)"PlanTaskPOIHelper_8", (String)"pccs-placs-business", (Object[])new Object[0]), dateFormat.getDateFormat())));
        int aimFinishTimeColumnIndex = columnKeyList.indexOf("aimfinishtime");
        sheet.addValidationData((DataValidation)this.setTip("aimfinishtime", 3, 1000, aimFinishTimeColumnIndex, aimFinishTimeColumnIndex, String.format(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\uff1a%s", (String)"PlanTaskPOIHelper_8", (String)"pccs-placs-business", (Object[])new Object[0]), dateFormat.getDateFormat())));
        int responsiblePersonColumnIndex = columnKeyList.indexOf("responsibleperson");
        sheet.addValidationData((DataValidation)this.setTip("responsibleperson", 3, 1000, responsiblePersonColumnIndex, responsiblePersonColumnIndex, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\uff0c\u652f\u6301\u5f55\u5165\u540d\u79f0\u3002", (String)"PlanTaskPOIHelper_9", (String)"pccs-placs-business", (Object[])new Object[0])));
        int responsiblePersonNumberColumnIndex = columnKeyList.indexOf("responsibleperson.number");
        sheet.addValidationData((DataValidation)this.setTip("responsibleperson.number", 3, 1000, responsiblePersonNumberColumnIndex, responsiblePersonNumberColumnIndex, ResManager.loadKDString((String)"\u6587\u672c\u5b57\u7b26\u4e32", (String)"PlanTaskPOIHelper_0", (String)"pccs-placs-business", (Object[])new Object[0])));
        int cooperationPersonColumnIndex = columnKeyList.indexOf("multicooperationperson");
        sheet.addValidationData((DataValidation)this.setTip("multicooperationperson", 3, 1000, cooperationPersonColumnIndex, cooperationPersonColumnIndex, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\uff0c\u652f\u6301\u5f55\u5165\u540d\u79f0\uff0c\u591a\u534f\u529e\u4eba\u8bf7\u7528\u5206\u53f7\u5206\u9694\u3002", (String)"PlanTaskPOIHelper_16", (String)"pccs-placs-business", (Object[])new Object[0])));
        int cooperationPersonNumberColumnIndex = columnKeyList.indexOf("multicooperationperson.number");
        sheet.addValidationData((DataValidation)this.setTip("multicooperationperson.number", 3, 1000, cooperationPersonNumberColumnIndex, cooperationPersonNumberColumnIndex, ResManager.loadKDString((String)"\u6587\u672c\u5b57\u7b26\u4e32\uff0c\u591a\u534f\u529e\u4eba\u8bf7\u7528\u5206\u53f7\u5206\u9694\u3002", (String)"PlanTaskPOIHelper_20", (String)"pccs-placs-business", (Object[])new Object[0])));
        int responsibleDeptColumnIndex = columnKeyList.indexOf("responsibledept");
        sheet.addValidationData((DataValidation)this.setTip("responsibledept", 3, 1000, responsibleDeptColumnIndex, responsibleDeptColumnIndex, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\uff0c\u652f\u6301\u5f55\u5165\u540d\u79f0\u3002", (String)"PlanTaskPOIHelper_9", (String)"pccs-placs-business", (Object[])new Object[0])));
        int cooperationDeptColumnIndex = columnKeyList.indexOf("multicooperationdept");
        sheet.addValidationData((DataValidation)this.setTip("multicooperationdept", 3, 1000, cooperationDeptColumnIndex, cooperationDeptColumnIndex, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\uff0c\u652f\u6301\u5f55\u5165\u540d\u79f0\uff0c\u591a\u534f\u529e\u90e8\u95e8\u8bf7\u7528\u5206\u53f7\u5206\u9694\u3002", (String)"PlanTaskPOIHelper_18", (String)"pccs-placs-business", (Object[])new Object[0])));
        int relationTaskColumnIndex = columnKeyList.indexOf("relationtask");
        sheet.addValidationData((DataValidation)this.setTip("relationtask", 3, 1000, relationTaskColumnIndex, relationTaskColumnIndex, ResManager.loadKDString((String)"\u8bf7\u52ff\u624b\u52a8\u5f55\u5165\u3002", (String)"PlanTaskPOIHelper_10", (String)"pccs-placs-business", (Object[])new Object[0])));
        sheet.setColumnHidden(relationTaskColumnIndex, true);
        int idColumnIndex = columnKeyList.indexOf("id");
        sheet.addValidationData((DataValidation)this.setTip("id", 3, 1000, idColumnIndex, idColumnIndex, ResManager.loadKDString((String)"\u8bf7\u52ff\u624b\u52a8\u5f55\u5165\u3002", (String)"PlanTaskPOIHelper_10", (String)"pccs-placs-business", (Object[])new Object[0])));
        sheet.setColumnHidden(idColumnIndex, true);
        for (i = 0; i < header.length; ++i) {
            HSSFCellStyle titleCellStyle = wb.createCellStyle();
            titleCellStyle.setAlignment(HorizontalAlignment.CENTER);
            titleCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            titleCellStyle.setBorderTop(BorderStyle.THIN);
            titleCellStyle.setBorderLeft(BorderStyle.THIN);
            titleCellStyle.setBorderRight(BorderStyle.THIN);
            titleCellStyle.setBorderBottom(BorderStyle.THIN);
            titleCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            titleCellStyle.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
            sheet.setColumnWidth(i, header[i].getBytes(StandardCharsets.UTF_8).length * 2 * 256);
            Cell columnKeyCell = columnKeyRow.createCell(i);
            columnKeyCell.setCellValue(columnKey[i]);
            columnKeyCell.setCellStyle((CellStyle)titleCellStyle);
            nameCell = nameRow.createCell(i);
            titleCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            titleCellStyle.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
            HSSFFont headFont = wb.createFont();
            if (mustFillColumn != null && mustFillColumn.contains(header[i])) {
                headFont.setColor(IndexedColors.RED.getIndex());
                nameCell.setCellValue(header[i] + "*");
            } else {
                headFont.setColor(IndexedColors.BLACK.getIndex());
                nameCell.setCellValue(header[i]);
            }
            titleCellStyle.setFont((Font)headFont);
            nameCell.setCellStyle((CellStyle)titleCellStyle);
        }
        if (data != null && !data.isEmpty()) {
            for (i = 0; i < data.size(); ++i) {
                int j;
                nameRow = sheet.createRow(i + 3);
                if (data.get(i) instanceof JSONObject) {
                    JSONObject jsonObject = data.getJSONObject(i);
                    for (j = 0; j < columnKey.length; ++j) {
                        HSSFCellStyle cellStyle = wb.createCellStyle();
                        cellStyle.setBorderTop(BorderStyle.THIN);
                        cellStyle.setBorderLeft(BorderStyle.THIN);
                        cellStyle.setBorderRight(BorderStyle.THIN);
                        cellStyle.setBorderBottom(BorderStyle.THIN);
                        nameCell = nameRow.createCell(j);
                        if (columnKey[j].equalsIgnoreCase("relativeduration") || columnKey[j].equalsIgnoreCase("absoluteduration")) {
                            cellStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"0"));
                            nameCell.setCellValue(Double.parseDouble(jsonObject.get((Object)columnKey[j]).toString()));
                        } else {
                            nameCell.setCellValue(jsonObject.get((Object)columnKey[j]) == null ? null : jsonObject.get((Object)columnKey[j]).toString());
                        }
                        nameCell.setCellStyle((CellStyle)cellStyle);
                    }
                    continue;
                }
                if (!(data.get(i) instanceof JSONArray)) continue;
                JSONArray jsonArray = data.getJSONArray(i);
                for (j = 0; j < jsonArray.size(); ++j) {
                    JSONObject jsonObject = JSONObject.parseObject((String)jsonArray.get(j).toString());
                    HSSFCellStyle cellStyle = wb.createCellStyle();
                    cellStyle.setBorderTop(BorderStyle.THIN);
                    cellStyle.setBorderLeft(BorderStyle.THIN);
                    cellStyle.setBorderRight(BorderStyle.THIN);
                    cellStyle.setBorderBottom(BorderStyle.THIN);
                    nameCell = nameRow.createCell(j);
                    if (columnKey[j].equalsIgnoreCase("relativeduration") || columnKey[j].equalsIgnoreCase("absoluteduration")) {
                        try {
                            jsonObject.getDoubleValue("cellValue");
                        }
                        catch (Exception e) {
                            logger.info(String.format("\u201c%s\u201d\u5217\u7684\u6570\u636e\u201c%s\u201d\u4e0d\u662f\u6570\u503c\u7c7b\u578b\u3002", jsonObject.get((Object)"columnName"), jsonObject.get((Object)"cellValue")));
                        }
                    } else {
                        String cellValueStr = jsonObject.getString("cellValue");
                        if (StringUtils.isNotBlank((CharSequence)cellValueStr) && (columnKey[j].equalsIgnoreCase("planstarttime") || columnKey[j].equalsIgnoreCase("planendtime") || columnKey[j].equalsIgnoreCase("aimfinishtime"))) {
                            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat.getDateFormat());
                            String timeStr = cellValueStr;
                            try {
                                sdf.parse(timeStr);
                                nameCell.setCellValue(timeStr);
                            }
                            catch (ParseException e) {
                                Date date = new Date(Long.parseLong(timeStr));
                                nameCell.setCellValue(sdf.format(date));
                            }
                        } else {
                            nameCell.setCellValue(cellValueStr);
                        }
                    }
                    nameCell.setCellStyle((CellStyle)cellStyle);
                }
            }
        }
        fileName = StringUtils.isBlank((CharSequence)fileName) ? System.currentTimeMillis() + ".xls" : fileName + ".xls";
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)os);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 5000);
        try {
            wb.close();
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        return url;
    }

    public HSSFDataValidation setTip(String key, int firstRow, int lastRow, int firstCol, int lastCol, String tip) {
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
        DVConstraint dvConstraint = null;
        switch (key) {
            case "achievementnode": {
                String[] dataArray = new String[]{DefaultEnum.YES.getName(), DefaultEnum.NO.getName()};
                dvConstraint = DVConstraint.createExplicitListConstraint((String[])dataArray);
                break;
            }
            case "logical": {
                String[] dataArray1 = new String[]{LogicalEnum.START_START.getName(), LogicalEnum.START_FINISH.getName(), LogicalEnum.FINISH_START.getName(), LogicalEnum.FINISH_FINISH.getName()};
                dvConstraint = DVConstraint.createExplicitListConstraint((String[])dataArray1);
                break;
            }
            case "controllevel": {
                List<String> dataList = this.getControlLevelList();
                if (dataList == null || dataList.isEmpty()) break;
                dvConstraint = DVConstraint.createExplicitListConstraint((String[])dataList.toArray(new String[dataList.size()]));
                break;
            }
            case "majortype": {
                List<String> dataList1 = this.getMajorTypeList();
                if (dataList1 == null || dataList1.isEmpty()) break;
                dvConstraint = DVConstraint.createExplicitListConstraint((String[])dataList1.toArray(new String[dataList1.size()]));
                break;
            }
            case "tasktype": {
                List<String> dataList2 = this.getTaskTypeList();
                if (dataList2 == null || dataList2.isEmpty()) break;
                dvConstraint = DVConstraint.createExplicitListConstraint((String[])dataList2.toArray(new String[dataList2.size()]));
                break;
            }
            case "absoluteduration": {
                dvConstraint = DVConstraint.createNumericConstraint((int)1, (int)0, (String)"-1000000", (String)"1000000000");
                break;
            }
        }
        if (dvConstraint == null) {
            dvConstraint = DVConstraint.createCustomFormulaConstraint((String)"BB1");
        }
        HSSFDataValidation dataValidation = new HSSFDataValidation(addressList, (DataValidationConstraint)dvConstraint);
        dataValidation.createErrorBox(ResManager.loadKDString((String)"\u9519\u8bef\u63d0\u793a", (String)"PlanTaskPOIHelper_11", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8f93\u5165\u7684\u683c\u5f0f\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"PlanTaskPOIHelper_21", (String)"pccs-placs-business", (Object[])new Object[0]));
        dataValidation.setSuppressDropDownArrow(false);
        if (tip != null) {
            dataValidation.createPromptBox(ResManager.loadKDString((String)"\u8f93\u5165\u63d0\u793a", (String)"PlanTaskPOIHelper_13", (String)"pccs-placs-business", (Object[])new Object[0]), tip);
        }
        dataValidation.setShowPromptBox(true);
        return dataValidation;
    }

    public static Set<String> getHeadByExcel(String url) {
        HashSet<String> returnArray = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            FileService service = FileServiceFactory.getAttachmentFileService();
            InputStream in = service.getInputStream(url);
            try {
                POIFSFileSystem fs = new POIFSFileSystem(in);
                HSSFWorkbook wb = new HSSFWorkbook(fs);
                HSSFSheet sheet = wb.getSheetAt(0);
                HSSFRow columnKeyRow = sheet.getRow(0);
                int columnNum = columnKeyRow.getLastCellNum();
                for (int i = 0; i < columnNum; ++i) {
                    columnKeyRow.getCell(i).setCellType(CellType.STRING);
                    String headkey = columnKeyRow.getCell(i).getStringCellValue();
                    if ("".equals(columnKeyRow.getCell(i).getStringCellValue())) continue;
                    returnArray.add(headkey);
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        return returnArray;
    }

    public JSONArray newInputExcelForTask(String url, String columnHashCode) {
        JSONArray jsonArray = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream in = cache.getInputStream(url);
            try {
                Workbook wb = WorkbookFactory.create((InputStream)in);
                Sheet sheet = wb.getSheetAt(0);
                int rowNum = sheet.getLastRowNum();
                if (rowNum <= 2) {
                    return jsonArray;
                }
                Row columnKeyRow = sheet.getRow(1);
                Row headerRow = sheet.getRow(2);
                Row columnKeyHashRow = sheet.getRow(0);
                columnKeyHashRow.getCell(0).setCellType(CellType.STRING);
                String columnKeyHashCellValue = columnKeyHashRow.getCell(0).getStringCellValue();
                if (!StringUtils.equals((CharSequence)columnKeyHashCellValue, (CharSequence)columnHashCode)) {
                    return jsonArray;
                }
                int columnNum = columnKeyRow.getLastCellNum();
                for (int j = 3; j <= rowNum; ++j) {
                    JSONArray jsonRow = new JSONArray();
                    Row iRow = sheet.getRow(j);
                    if (iRow == null) continue;
                    for (int i = 0; i < columnNum; ++i) {
                        JSONObject jsonObject = new JSONObject();
                        Cell columnKeyRowCell = columnKeyRow.getCell(i);
                        Cell headRowCell = headerRow.getCell(i);
                        columnKeyRowCell.setCellType(CellType.STRING);
                        headRowCell.setCellType(CellType.STRING);
                        jsonObject.put("columnKey", (Object)columnKeyRowCell.getStringCellValue());
                        jsonObject.put("columnName", (Object)headRowCell.getStringCellValue());
                        Cell cell = iRow.getCell(i);
                        if (cell != null) {
                            if (cell.getCellType() == CellType.NUMERIC) {
                                cell.setCellType(CellType.NUMERIC);
                                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                    jsonObject.put("cellValue", (Object)cell.getDateCellValue());
                                } else {
                                    jsonObject.put("cellValue", (Object)cell.getNumericCellValue());
                                }
                            } else {
                                cell.setCellType(CellType.STRING);
                                jsonObject.put("cellValue", (Object)cell.getStringCellValue());
                            }
                        } else {
                            jsonObject.put("cellValue", null);
                        }
                        jsonRow.add((Object)jsonObject);
                    }
                    jsonArray.add((Object)jsonRow);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        return jsonArray;
    }

    public List<String> getControlLevelList() {
        return this.controlLevelList;
    }

    public void setControlLevelList(List<String> controlLevelList) {
        this.controlLevelList = controlLevelList;
    }

    public List<String> getMajorTypeList() {
        return this.majorTypeList;
    }

    public void setMajorTypeList(List<String> majorTypeList) {
        this.majorTypeList = majorTypeList;
    }

    public List<String> getTaskTypeList() {
        return this.taskTypeList;
    }

    public void setTaskTypeList(List<String> taskTypeList) {
        this.taskTypeList = taskTypeList;
    }
}

