/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.business.utils.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.DefaultEnum;
import kd.pccs.placs.common.enums.EnableEnum;
import kd.pccs.placs.common.enums.LogicalEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.enums.TransactionTypeEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.common.utils.poi.POIHelper;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddressList;

public class PlanTplUtil {
    private static final Log logger = LogFactory.getLog(PlanTplUtil.class);

    private PlanTplUtil() {
    }

    protected static void setTx(DynamicObjectCollection transactiontype, DynamicObject newTask, ORM orm) {
        DynamicObjectType type = transactiontype.getDynamicObjectType();
        long[] longIds = orm.genLongIds((IDataEntityType)type, transactiontype.size());
        DynamicObjectCollection newCollect = new DynamicObjectCollection();
        for (int i = 0; i < transactiontype.size(); ++i) {
            DynamicObject tx = (DynamicObject)transactiontype.get(i);
            DynamicObject newtx = new DynamicObject(type);
            newtx.set("pkid", (Object)longIds[i]);
            newtx.set("fbasedataid", tx.get("fbasedataid"));
            newtx.set("fbasedataid_id", tx.get("fbasedataid_id"));
            newCollect.add((Object)newtx);
        }
        newTask.set("transactiontype", (Object)newCollect);
    }

    public static void generateTaskListBySelectTask(Object planTplTasks, IFormView formView) {
        IDataModel dataModel = formView.getModel();
        DynamicObject projectPlan = dataModel.getDataEntity();
        DynamicObjectCollection taskEntryCol = dataModel.getEntryEntity("taskentity");
        DynamicObject project = projectPlan.getDynamicObject("project");
        DynamicObject majorType = projectPlan.getDynamicObject("majortype");
        String formId = formView.getFormShowParameter().getFormId();
        String appId = formView.getFormShowParameter().getAppId();
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            appId = formId.split("_")[0];
        }
        ArrayList<String> oldTaskNames = new ArrayList<String>(10);
        HashMap<String, DynamicObject> tplTaskIdMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject task : taskEntryCol) {
            oldTaskNames.add(task.get("name").toString());
            tplTaskIdMap.put(task.getPkValue().toString(), task);
        }
        String pageCache = formView.getPageCache().get("oldIdToNewId");
        JSONObject pageCacheIds = pageCache != null ? JSONObject.parseObject((String)pageCache) : new JSONObject();
        JSONObject srcOldIdToNewId = new JSONObject();
        Set keys = pageCacheIds.keySet();
        block1: for (String key : keys) {
            String value = pageCacheIds.getString(key);
            for (DynamicObject task : taskEntryCol) {
                if (!value.equals(task.getPkValue().toString())) continue;
                srcOldIdToNewId.put(key, (Object)value);
                continue block1;
            }
        }
        List taskIdList = (List)planTplTasks;
        QFilter taskIdFilter = new QFilter("id", "in", (Object)taskIdList);
        DynamicObject[] planTplTaskListCol = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"plantpltask"), (String)"number, name, status, creator, modifier, enable, createtime, modifytime, masterid, longnumber, level, fullname, isleaf, parent, controllevel, spectype, tasktype, transactiontype, absoluteduration, pretask, pretaskid, logical, relativeduration, responsiblepost, associatepost, relevantdoc, disable, taskseq,taskresultdocdetail.resultname,taskresultdocdetail.force,taskresultdocdetail.frequency,taskresultdocdetail.resultdescription", (QFilter[])new QFilter[]{taskIdFilter});
        DynamicObjectType taskDt = taskEntryCol.getDynamicObjectType();
        JSONObject oldIdToNewId = new JSONObject();
        if (planTplTaskListCol.length > 0) {
            ORM orm = ORM.create();
            long[] taskIds = orm.genLongIds((IDataEntityType)taskDt, planTplTaskListCol.length);
            int index = 0;
            for (DynamicObject planTplTask : planTplTaskListCol) {
                boolean disAble = planTplTask.getBoolean("disable");
                if (disAble) continue;
                if (planTplTask.getBoolean("isleaf") && oldTaskNames.contains(planTplTask.get("name").toString())) {
                    formView.showMessage(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4efb\u52a1\uff1a%s\u3002", (String)"PlanTplUtil_7", (String)"pccs-placs-business", (Object[])new Object[0]), planTplTask.get("name")));
                    return;
                }
                if (!planTplTask.getBoolean("isleaf") && oldTaskNames.contains(planTplTask.get("name").toString())) continue;
                DynamicObject newTask = new DynamicObject(taskDt);
                Long taskId = taskIds[index++];
                newTask.set("id", (Object)taskId);
                newTask.set("taskproject", (Object)project);
                newTask.set("completionstatus", (Object)CompletionStatusEnum.UNSTART.getValue());
                newTask.set("seq", planTplTask.get("taskseq"));
                newTask.set("belongplantype", (Object)majorType);
                newTask.set("tasksource", (Object)majorType);
                newTask.set("name", planTplTask.get("name"));
                newTask.set("status", (Object)StatusEnum.TEMPSAVE.getValue());
                newTask.set("enable", (Object)EnableEnum.ENABLE.getValue());
                newTask.set("isleaf", planTplTask.get("isleaf"));
                Object parent = srcOldIdToNewId.get(planTplTask.get("parent_id")) == null ? planTplTask.get("parent_id") : srcOldIdToNewId.get(planTplTask.get("parent_id"));
                DynamicObject parentTask = (DynamicObject)tplTaskIdMap.get(parent.toString());
                Object pId = parentTask == null ? Integer.valueOf(0) : parentTask.getPkValue();
                newTask.set("pid", pId);
                newTask.set("level", (Object)(parentTask == null ? 1 : parentTask.getInt("level") + 1));
                if (planTplTask.getLong("pretaskid") != 0L) {
                    for (DynamicObject planTask : planTplTaskListCol) {
                        if (!planTask.getPkValue().equals(planTplTask.getLong("pretaskid"))) continue;
                        newTask.set("pretask", (Object)planTask);
                        break;
                    }
                } else {
                    newTask.set("pretask", null);
                }
                newTask.set("logical", (Object)planTplTask.getString("logical"));
                newTask.set("controllevel", (Object)planTplTask.getDynamicObject("controllevel"));
                newTask.set("tasktype", (Object)planTplTask.getDynamicObject("tasktype"));
                newTask.set("responsiblepost", planTplTask.get("responsiblepost"));
                newTask.set("associatepost", planTplTask.get("associatepost"));
                newTask.set("templatetask", planTplTask.getPkValue());
                newTask.set("absoluteduration", planTplTask.get("absoluteduration"));
                newTask.set("relativeduration", planTplTask.get("relativeduration"));
                if (MetaDataUtil.getEntityId((String)appId, (String)"masterplan").equals(formId)) {
                    newTask.set("specialtype", planTplTask.get("spectype"));
                } else if (MetaDataUtil.getEntityId((String)appId, (String)"specialplan").equals(formId)) {
                    newTask.set("specialtype", (Object)majorType);
                }
                DynamicObjectCollection transactiontype = null;
                if (null != planTplTask.get("transactiontype")) {
                    transactiontype = (DynamicObjectCollection)planTplTask.get("transactiontype");
                    PlanTplUtil.setTx(transactiontype, newTask, orm);
                }
                boolean showResultDoc = false;
                if (transactiontype != null) {
                    for (DynamicObject tx : transactiontype) {
                        Long baseDataId = tx.getLong("fbasedataid_id");
                        DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)appId, (String)"transactiontype"));
                        if (!Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.get("number"))) continue;
                        showResultDoc = true;
                    }
                }
                if (showResultDoc) {
                    DynamicObjectCollection taskResultDocEntryCol = newTask.getDynamicObjectCollection("taskresultdocentry");
                    DynamicObjectType taskResultDocDT = taskResultDocEntryCol.getDynamicObjectType();
                    DynamicObjectCollection planTplTaskResultDocEntryCol = planTplTask.getDynamicObjectCollection("taskresultdocdetail");
                    int seq = 1;
                    for (DynamicObject planTplTaskResultDocEntry : planTplTaskResultDocEntryCol) {
                        DynamicObject newTaskResultDoc = new DynamicObject(taskResultDocDT);
                        newTaskResultDoc.set("seq", (Object)seq++);
                        newTaskResultDoc.set("resultname", planTplTaskResultDocEntry.get("resultname"));
                        newTaskResultDoc.set("force", planTplTaskResultDocEntry.get("force"));
                        newTaskResultDoc.set("frequency", planTplTaskResultDocEntry.get("frequency"));
                        newTaskResultDoc.set("resultdescription", planTplTaskResultDocEntry.get("resultdescription"));
                        taskResultDocEntryCol.add((Object)newTaskResultDoc);
                    }
                }
                DynamicObjectCollection referDocEntryCol = newTask.getDynamicObjectCollection("taskreferdocentry");
                DynamicObjectType referDocEntryDT = referDocEntryCol.getDynamicObjectType();
                DynamicObjectCollection relevantDocCol = planTplTask.getDynamicObjectCollection("relevantdoc");
                for (DynamicObject relevantDoc : relevantDocCol) {
                    DynamicObject newReferDocEntry = new DynamicObject(referDocEntryDT);
                    DynamicObjectCollection referDocCol = newReferDocEntry.getDynamicObjectCollection("attachment");
                    DynamicObjectType referDocDT = referDocCol.getDynamicObjectType();
                    DynamicObject newReferDoc = new DynamicObject(referDocDT);
                    DynamicObject relevantFile = relevantDoc.getDynamicObject("fbasedataid");
                    newReferDoc.set("fbasedataid", (Object)relevantFile);
                    String docxName = relevantFile.getString("name");
                    String description = relevantFile.getString("description");
                    newReferDocEntry.set("referdocname", (Object)docxName);
                    newReferDocEntry.set("description", (Object)description);
                    referDocCol.add((Object)newReferDoc);
                    newReferDocEntry.set("attachment", (Object)referDocCol);
                    referDocEntryCol.add((Object)newReferDocEntry);
                }
                taskEntryCol.add((Object)newTask);
                tplTaskIdMap.put(planTplTask.getPkValue().toString(), newTask);
                oldIdToNewId.put(planTplTask.getPkValue().toString(), (Object)taskId);
            }
            srcOldIdToNewId.putAll((Map)oldIdToNewId);
            formView.getPageCache().put("oldIdToNewId", JSONObject.toJSONString((Object)srcOldIdToNewId));
        }
        DynamicObject relatedMasterTask = projectPlan.getDynamicObject("relatedmastertask");
        if (MetaDataUtil.getEntityId((String)appId, (String)"specialplan").equals(formId) && relatedMasterTask != null && !taskEntryCol.isEmpty()) {
            DynamicObject taskEntry = (DynamicObject)taskEntryCol.get(0);
            for (int i = 1; i < taskEntryCol.size(); ++i) {
                DynamicObject taskObj = (DynamicObject)taskEntryCol.get(i);
                Long pid = taskObj.getLong("pid");
                if (pid != null && pid != 0L) continue;
                taskObj.set("pid", taskEntry.getPkValue());
                taskObj.set("level", (Object)(taskEntry.getInt("level") + 1));
            }
        }
        PlanTplUtil.setPreTask(taskEntryCol);
        dataModel.updateEntryCache(taskEntryCol);
        formView.updateView("taskentity");
        formView.invokeOperation("save");
        for (int i = 0; i < taskEntryCol.size(); ++i) {
            Object pretaskId = formView.getModel().getValue("pretask_id", i);
            if (pretaskId == null || (Long)pretaskId == 0L) continue;
            formView.getModel().setValue("pretask", (Object)BusinessDataServiceHelper.loadSingle((Object)pretaskId, (String)MetaDataUtil.getEntityId((String)appId, (String)"task")), i);
        }
    }

    private static void setPreTask(DynamicObjectCollection taskEntryCol) {
        HashMap<String, DynamicObject> taskNameMap = new HashMap<String, DynamicObject>(16);
        List taskEntryCols = taskEntryCol.stream().filter(task -> task.getDynamicObject("relationtask") == null).collect(Collectors.toList());
        for (DynamicObject task2 : taskEntryCols) {
            taskNameMap.put(task2.getString("name"), task2);
        }
        for (DynamicObject task2 : taskEntryCols) {
            if (StringUtils.isNotBlank((CharSequence)task2.getString("pretask"))) {
                task2.set("pretask", taskNameMap.get(task2.getDynamicObject("pretask").getString("name")));
                continue;
            }
            task2.set("logical", null);
        }
    }

    public static void getAfterTaskIdSet(List<DynamicObject> taskList, Set<Object> idSet, DynamicObject currentTask) {
        for (int i = 0; i < taskList.size(); ++i) {
            DynamicObject task = taskList.get(i);
            Long preTaskId = task.getLong("pretaskid");
            if (preTaskId == 0L || !currentTask.getPkValue().equals(preTaskId)) continue;
            idSet.add(task.getPkValue());
            if (task.get("pid") != null) {
                PlanTplUtil.getParentIdSet(taskList, idSet, task);
            }
            PlanTplUtil.getAfterTaskIdSet(taskList, idSet, task);
        }
    }

    public static void getParentIdSet(List<DynamicObject> taskList, Set<Object> idSet, DynamicObject currentTask) {
        Object parentTaskId = currentTask.get("pid");
        if (parentTaskId == null) {
            return;
        }
        for (int i = 0; i < taskList.size(); ++i) {
            DynamicObject task = taskList.get(i);
            if (!parentTaskId.equals(task.getPkValue())) continue;
            idSet.add(task.getPkValue());
            PlanTplUtil.getAfterTaskIdSet(taskList, idSet, task);
            if (task.get("pid") == null) continue;
            PlanTplUtil.getParentIdSet(taskList, idSet, task);
        }
    }

    public static String outPutExcel(String appId, Object proKindId, String fileName, String sheetName, String[] header, String[] columnKey, List<String> mustFillColumn, JSONArray data) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFRow columnKeyHashRow = sheet.createRow(0);
        columnKeyHashRow.setHeight((short)0);
        Cell columnKeyHashCell = columnKeyHashRow.createCell(0);
        columnKeyHashCell.setCellValue(POIHelper.stringArrayToHash((String[])columnKey));
        HSSFRow columnKeyRow = sheet.createRow(1);
        columnKeyRow.setHeight((short)0);
        HSSFRow nameRow = sheet.createRow(2);
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        DynamicObject[] controlLevelArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"controllevel"), (String)"name", (QFilter[])new QFilter[]{enableFilter});
        List<String> clNameList = Arrays.stream(controlLevelArr).map(cl -> cl.getString("name")).collect(Collectors.toList());
        QFilter isProjectTaskFilter = new QFilter("checkboxisprojecttask", "=", (Object)"1");
        DynamicObject[] taskTypeArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"tasktype"), (String)"name", (QFilter[])new QFilter[]{enableFilter, isProjectTaskFilter});
        List<String> taskTypeNameList = Arrays.stream(taskTypeArr).map(tt -> tt.getString("name")).collect(Collectors.toList());
        QFilter kindFilter = new QFilter("group", "=", proKindId).or(new QFilter("group", "=", (Object)0L));
        QFilter notSysFilter = new QFilter("issysfield", "!=", (Object)"1");
        DynamicObject[] majorTypeArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"majortype"), (String)"name", (QFilter[])new QFilter[]{enableFilter, kindFilter, notSysFilter});
        List<String> majorTypeNameList = Arrays.stream(majorTypeArr).map(mt -> mt.getString("name")).collect(Collectors.toList());
        sheet.addValidationData((DataValidation)PlanTplUtil.getDataValidation(3, 4, 0, 0, ResManager.loadKDString((String)"\u6587\u672c", (String)"PlanTplUtil_0", (String)"pccs-placs-business", (Object[])new Object[0]), null, 0));
        sheet.addValidationData((DataValidation)PlanTplUtil.getDataValidation(3, 6000, 1, 1, null, clNameList.toArray(new String[clNameList.size()]), 7));
        sheet.addValidationData((DataValidation)PlanTplUtil.getDataValidation(3, 6000, 2, 2, null, majorTypeNameList.toArray(new String[majorTypeNameList.size()]), 7));
        sheet.addValidationData((DataValidation)PlanTplUtil.getDataValidation(3, 6000, 3, 3, null, taskTypeNameList.toArray(new String[taskTypeNameList.size()]), 7));
        sheet.addValidationData((DataValidation)PlanTplUtil.getDataValidation(3, 6000, 4, 4, ResManager.loadKDString((String)"\u6570\u5b57", (String)"PlanTplUtil_1", (String)"pccs-placs-business", (Object[])new Object[0]), null, 1));
        sheet.addValidationData((DataValidation)PlanTplUtil.getDataValidation(3, 6000, 5, 5, null, new String[]{DefaultEnum.YES.getName(), DefaultEnum.NO.getName()}, 7));
        sheet.addValidationData((DataValidation)PlanTplUtil.getDataValidation(3, 4, 6, 6, ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0", (String)"PlanTplUtil_2", (String)"pccs-placs-business", (Object[])new Object[0]), null, 0));
        sheet.addValidationData((DataValidation)PlanTplUtil.getDataValidation(3, 6000, 7, 7, null, new String[]{LogicalEnum.START_START.getName(), LogicalEnum.START_FINISH.getName(), LogicalEnum.FINISH_START.getName(), LogicalEnum.FINISH_FINISH.getName()}, 7));
        sheet.addValidationData((DataValidation)PlanTplUtil.getDataValidation(3, 4, 8, 8, ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0", (String)"PlanTplUtil_2", (String)"pccs-placs-business", (Object[])new Object[0]), null, 0));
        sheet.addValidationData((DataValidation)PlanTplUtil.getDataValidation(3, 6000, 9, 9, ResManager.loadKDString((String)"\u6570\u5b57", (String)"PlanTplUtil_1", (String)"pccs-placs-business", (Object[])new Object[0]), null, 1));
        HSSFCellStyle titleCellStyle = wb.createCellStyle();
        titleCellStyle.setAlignment(HorizontalAlignment.CENTER);
        titleCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        titleCellStyle.setBorderTop(BorderStyle.THIN);
        titleCellStyle.setBorderLeft(BorderStyle.THIN);
        titleCellStyle.setBorderRight(BorderStyle.THIN);
        titleCellStyle.setBorderBottom(BorderStyle.THIN);
        titleCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        titleCellStyle.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        Cell columnKeyCell = null;
        Cell nameCell = null;
        for (int i = 0; i < header.length; ++i) {
            sheet.setColumnWidth(i, header[i].getBytes(StandardCharsets.UTF_8).length * 2 * 256);
            columnKeyCell = columnKeyRow.createCell(i);
            columnKeyCell.setCellValue(columnKey[i]);
            columnKeyCell.setCellStyle((CellStyle)titleCellStyle);
            nameCell = nameRow.createCell(i);
            if (mustFillColumn != null && mustFillColumn.contains(header[i])) {
                HSSFCellStyle mustFillColumnStyle = wb.createCellStyle();
                mustFillColumnStyle.setAlignment(HorizontalAlignment.CENTER);
                mustFillColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                mustFillColumnStyle.setBorderTop(BorderStyle.THIN);
                mustFillColumnStyle.setBorderLeft(BorderStyle.THIN);
                mustFillColumnStyle.setBorderRight(BorderStyle.THIN);
                mustFillColumnStyle.setBorderBottom(BorderStyle.THIN);
                mustFillColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                mustFillColumnStyle.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
                HSSFFont mheadFont = wb.createFont();
                mheadFont.setColor(IndexedColors.RED.getIndex());
                mustFillColumnStyle.setFont((Font)mheadFont);
                nameCell.setCellValue(header[i] + "*");
                nameCell.setCellStyle((CellStyle)mustFillColumnStyle);
                continue;
            }
            nameCell.setCellValue(header[i]);
            nameCell.setCellStyle((CellStyle)titleCellStyle);
        }
        HSSFCellStyle css = wb.createCellStyle();
        HSSFDataFormat format = wb.createDataFormat();
        css.setDataFormat(format.getFormat("@"));
        sheet.setDefaultColumnStyle(10, (CellStyle)css);
        sheet.setDefaultColumnStyle(11, (CellStyle)css);
        sheet.setDefaultColumnStyle(12, (CellStyle)css);
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        if (data != null && !data.isEmpty()) {
            for (int i = 0; i < data.size(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                nameRow = sheet.createRow(i + 3);
                for (int j = 0; j < columnKey.length; ++j) {
                    nameCell = nameRow.createCell(j);
                    nameCell.setCellValue(jsonObject.get((Object)columnKey[j]) == null ? null : jsonObject.get((Object)columnKey[j]).toString());
                    nameCell.setCellStyle((CellStyle)cellStyle);
                }
            }
        }
        fileName = StringUtils.isBlank((CharSequence)fileName) ? System.currentTimeMillis() + ".xls" : fileName + ".xls";
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)os);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 5000);
        if (wb != null) {
            try {
                wb.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        return url;
    }

    public static HSSFDataValidation getDataValidation(int firstRow, int lastRow, int firstCol, int lastCol, String tip, String[] dvConstraintArr, int type) {
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
        DVConstraint dvConstraint = null;
        switch (type) {
            case 1: {
                dvConstraint = DVConstraint.createNumericConstraint((int)1, (int)0, (String)"0", (String)"10000");
                break;
            }
            case 7: {
                dvConstraint = DVConstraint.createExplicitListConstraint((String[])dvConstraintArr);
                break;
            }
            default: {
                dvConstraint = DVConstraint.createCustomFormulaConstraint((String)"BB1");
            }
        }
        HSSFDataValidation dataValidation = new HSSFDataValidation(addressList, (DataValidationConstraint)dvConstraint);
        dataValidation.createErrorBox(ResManager.loadKDString((String)"\u9519\u8bef\u63d0\u793a", (String)"PlanTplUtil_3", (String)"pccs-placs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8f93\u5165\u7684\u683c\u5f0f\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"PlanTplUtil_8", (String)"pccs-placs-business", (Object[])new Object[0]));
        dataValidation.setSuppressDropDownArrow(false);
        if (tip != null) {
            dataValidation.createPromptBox(ResManager.loadKDString((String)"\u8f93\u5165\u63d0\u793a", (String)"PlanTplUtil_5", (String)"pccs-placs-business", (Object[])new Object[0]), tip);
        }
        dataValidation.setShowPromptBox(true);
        return dataValidation;
    }
}

