/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.business.utils.task;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.lang.Lang;
import kd.bos.mvc.export.ExportSheetStyle;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.pccs.placs.business.excelimport.CommonDataExporter;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ProgressDataExporter
extends CommonDataExporter {
    public ProgressDataExporter(String sheetName, List<ExportWriterFormat> formats) {
        this.wb = new SXSSFWorkbook(-1);
        this.wb.setCompressTempFiles(true);
        this.sheet = this.wb.createSheet(sheetName);
        this.sheet.setColumnHidden(0, Boolean.TRUE.booleanValue());
        this.dropdownSheet = this.wb.createSheet("dropdown_items_sheet");
        this.styles = new ExportSheetStyle(this.wb);
        HashMap<Integer, String> propDisplayNames = new HashMap<Integer, String>();
        int headerOffset = 1;
        for (ExportWriterFormat format : formats) {
            headerOffset = this.writeHeader(this.wb, this.sheet, this.dropdownSheet, this.styles, format, headerOffset, propDisplayNames, this.columnKey);
        }
        int dropdownItemsSheetIndex = this.wb.getSheetIndex("dropdown_items_sheet");
        if (dropdownItemsSheetIndex >= 0) {
            this.wb.setSheetHidden(dropdownItemsSheetIndex, true);
        }
    }

    @Override
    public int splitColumnData(SXSSFWorkbook wb, SXSSFSheet sheet, SXSSFRow dataRow, CellStyle styles, ExportWriterFormat format, Map<String, Object> property, String fieldName, int offset, Map<Integer, String> propDisplayNames, int defaultColWidth, Object inputType, DynamicObject data, DynamicObjectCollection dataList, CreationHelper creationHelper, CellStyle cellStyle, Map<String, Object> params) {
        block11: {
            cellStyle.setDataFormat(creationHelper.createDataFormat().getFormat("@"));
            List splitCols = (List)format.flexColumn.get(fieldName);
            List splitColDisplayNames = (List)format.flexColumnDisplay.get(fieldName);
            List splitColDesc = (List)format.flexColumnDesc.get(fieldName);
            if ("multilang".equals(inputType)) {
                Lang lang = RequestContext.get().getLang();
                String value = "";
                if ("parent".equals(fieldName)) {
                    return ++offset;
                }
                value = "zh_CN".equals(lang.name()) ? data.getLocaleString(fieldName).getLocaleValue_zh_CN() : ("zh_TW".equals(lang.name()) ? data.getLocaleString(fieldName).getLocaleValue_zh_TW() : data.getLocaleString(fieldName).getLocaleValue_en());
                SXSSFCell cell = ProgressDataExporter.createCell((SXSSFWorkbook)wb, (SXSSFRow)dataRow, (int)offset, (CellStyle)styles);
                cell.setCellValue(value);
                cell.setCellStyle(cellStyle);
                sheet.setColumnWidth(offset, ProgressDataExporter.calcColumnWidth(value, (String)splitColDisplayNames.get(0), defaultColWidth));
                return ++offset;
            }
            if (splitCols == null) break block11;
            if (data.get(fieldName) instanceof DynamicObjectCollection) {
                DynamicObjectCollection dtColl = data.getDynamicObjectCollection(fieldName);
                String col = null;
                for (int j = 0; j < splitCols.size(); ++j) {
                    int colIndex = offset;
                    col = ((String)splitCols.get(j)).split("\\.")[1];
                    if (dtColl != null) {
                        StringBuilder value = new StringBuilder();
                        String finalCol = col;
                        if ("name".equals(finalCol)) {
                            dtColl.stream().map(o -> value.append(o == null ? "" : o.getDynamicObject("fbasedataid").getLocaleString(finalCol).getLocaleValue() + ";")).count();
                        } else {
                            dtColl.stream().map(o -> value.append(o == null ? "" : o.getDynamicObject("fbasedataid").getString(finalCol) + ";")).count();
                        }
                        if (value.length() > 0) {
                            value.deleteCharAt(value.length() - 1);
                        }
                        SXSSFCell cell = ProgressDataExporter.createCell((SXSSFWorkbook)wb, (SXSSFRow)dataRow, (int)colIndex, (CellStyle)styles);
                        cell.setCellValue(value.toString());
                        cell.setCellStyle(cellStyle);
                        sheet.setColumnWidth(offset, ProgressDataExporter.calcColumnWidth(value.toString(), (String)splitColDisplayNames.get(j), defaultColWidth));
                    }
                    ++offset;
                }
            } else {
                DynamicObject dt = data.getDynamicObject(fieldName);
                for (int j = 0; j < splitCols.size(); ++j) {
                    int colIndex = offset;
                    if (dt != null) {
                        String value = String.valueOf(dt.get(((String)splitCols.get(j)).split("\\.")[1]));
                        SXSSFCell cell = ProgressDataExporter.createCell((SXSSFWorkbook)wb, (SXSSFRow)dataRow, (int)colIndex, (CellStyle)styles);
                        cell.setCellValue(value);
                        cell.setCellStyle(cellStyle);
                        sheet.setColumnWidth(offset, ProgressDataExporter.calcColumnWidth(value, (String)splitColDisplayNames.get(j), defaultColWidth));
                    }
                    ++offset;
                }
            }
        }
        return offset;
    }
}

