/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.business.utils.task;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.business.excelimport.CommonImportAndExport;
import kd.pccs.placs.business.utils.task.ProgressDataExporter;
import kd.pccs.placs.business.utils.task.TaskUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;

public class ProgressTaskImpAndExpUtil
extends CommonImportAndExport {
    protected IFormView view;

    public ProgressTaskImpAndExpUtil() {
    }

    public ProgressTaskImpAndExpUtil(IFormView view) {
        this.view = view;
    }

    protected String[] getHiddenColumnKey() {
        return new String[]{"status", "sourcetask", "completedescription", "parent", "islatest", "isleaf", "taskversion", "level", "completionstatus", "expecttime", "realendtime", "taskpercent", "tasksource", "meettask"};
    }

    protected String[] getNormalCommonColumnKey() {
        return new String[]{"name", "transactiontype", "taskproject", "planstarttime1", "planendtime1", "absoluteduration1", "taskpercent", "completedescription", "inchargeperson", "inchargeperson.number", "inchargedept", "multicooperator", "multicooperator.number", "multicooperatedept", "id"};
    }

    public void exportProgressModel(IFormView view, boolean isExportData, String entryKey) {
        String parentPageId = null;
        String entityNumber = null;
        if (isExportData) {
            parentPageId = view.getPageId();
            entityNumber = view.getEntityId();
        } else {
            parentPageId = view.getParentView().getPageId();
            entityNumber = view.getParentView().getEntityId();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("parentpageid", parentPageId);
        params.put("isExportData", isExportData);
        params.put("entitynumber", entityNumber);
        params.put("entryKey", entryKey);
        String url = this.executeExportTask(params);
        view.download(url);
        view.showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6210\u529f\u3002", (String)"ProgressTaskImpAndExpUtil_0", (String)"pccs-placs-business", (Object[])new Object[0]), Integer.valueOf(2000));
    }

    @Override
    public String executeExportTask(Map<String, Object> params) throws KDException {
        this.params.putAll(params);
        boolean exportData = (Boolean)this.params.get("isExportData");
        this.formator = this.loadExportFormat();
        ArrayList<ExportWriterFormat> formats = new ArrayList<ExportWriterFormat>(10);
        formats.add(this.formator);
        ProgressDataExporter exporter = new ProgressDataExporter("sheet1", formats);
        String fileName = this.genDataExportFileName(LocalDate.now());
        if (exportData) {
            this.exportData(exporter, formats);
        }
        String url = exporter.flush(fileName, 5000);
        return url;
    }

    @Override
    public ExportWriterFormat loadExportFormat() {
        MetadataService metaService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String formatJson = metaService.getExportWriter(this.getEntityNumber(), 0L, null, null);
        List formats = JSONObject.parseArray((String)formatJson, ExportWriterFormat.class);
        ExportWriterFormat format = (ExportWriterFormat)formats.get(0);
        ExportWriterFormat entryFormat = null;
        for (ExportWriterFormat format1 : format.next) {
            if (!format1.name.equals(this.getEntryKey())) continue;
            entryFormat = format1;
            break;
        }
        if (entryFormat != null) {
            entryFormat.fields.remove("name");
            entryFormat.fields.add(0, "name");
            this.params.put("name", "name");
            entryFormat.fields.add(1, "parent");
            HashMap<String, String> parentValue = new HashMap<String, String>();
            parentValue.put("InputType", "multilang");
            parentValue.put("MustInput", "false");
            parentValue.put("DisplayName", ResManager.loadKDString((String)"\u4e0a\u7ea7\u540d\u79f0", (String)"ProgressTaskImpAndExpUtil_1", (String)"pccs-placs-business", (Object[])new Object[0]));
            parentValue.put("DataKey", (String)((Map)entryFormat.properties.get("name")).get("DataKey"));
            parentValue.put("propName", "parent");
            entryFormat.properties.put("parent", parentValue);
            ArrayList<String> parentColumn = new ArrayList<String>(1);
            parentColumn.add("parent");
            entryFormat.flexColumn.put("parent", parentColumn);
            ArrayList<String> parentDisplay = new ArrayList<String>(1);
            parentDisplay.add(ResManager.loadKDString((String)"\u4e0a\u7ea7\u540d\u79f0", (String)"ProgressTaskImpAndExpUtil_1", (String)"pccs-placs-business", (Object[])new Object[0]));
            entryFormat.flexColumnDisplay.put("parent", parentDisplay);
            ArrayList<String> parentDesc = new ArrayList<String>(1);
            parentDesc.add(ResManager.loadKDString((String)"\u6587\u672c", (String)"ProgressTaskImpAndExpUtil_2", (String)"pccs-placs-business", (Object[])new Object[0]));
            entryFormat.flexColumnDesc.put("parent", parentDesc);
            this.columnHidden(entryFormat);
            ArrayList<ExportWriterFormat> removeSubs = new ArrayList<ExportWriterFormat>();
            for (ExportWriterFormat subFormat : entryFormat.next) {
                if (!subFormat.name.equals("taskresultdocentry")) continue;
                removeSubs.add(subFormat);
            }
            if (removeSubs != null) {
                entryFormat.next.removeAll(removeSubs);
            }
            this.updateMustInputFieds(entryFormat);
            int index = entryFormat.fields.indexOf("inchargeperson");
            entryFormat.fields.remove("inchargedept");
            entryFormat.fields.add(index + 1, "inchargedept");
            this.updateMulBasedataTips(entryFormat);
        }
        return entryFormat;
    }

    public void updateMustInputFieds(ExportWriterFormat entryFormat) {
        ((Map)entryFormat.properties.get("planstarttime1")).put("MustInput", false);
        ((Map)entryFormat.properties.get("planendtime1")).put("MustInput", false);
        ((Map)entryFormat.properties.get("inchargeperson")).put("MustInput", false);
        ((Map)entryFormat.properties.get("inchargedept")).put("MustInput", false);
    }

    public void updateMulBasedataTips(ExportWriterFormat entryFormat) {
        ArrayList<String> tips = new ArrayList<String>();
        tips.add(0, ResManager.loadKDString((String)"\u591a\u4e2a\u57fa\u7840\u8d44\u6599\u7528\u5206\u53f7\uff08;\uff09\u5206\u9694\uff0c\u652f\u6301\u5f55\u5165\u7f16\u7801\u3002", (String)"ProgressTaskImpAndExpUtil_5", (String)"pccs-placs-business", (Object[])new Object[0]));
        tips.add(1, ResManager.loadKDString((String)"\u591a\u4e2a\u57fa\u7840\u8d44\u6599\u7528\u5206\u53f7\uff08;\uff09\u5206\u9694\uff0c\u652f\u6301\u5f55\u5165\u540d\u79f0\u3002", (String)"ProgressTaskImpAndExpUtil_6", (String)"pccs-placs-business", (Object[])new Object[0]));
        entryFormat.flexColumnDesc.put("multicooperator", tips);
        entryFormat.flexColumnDesc.put("multicooperatedept", tips);
        entryFormat.flexColumnDesc.put("transactiontype", tips);
    }

    public void columnHidden(ExportWriterFormat entryFormat) {
        String[] hiddengetColumn = this.getHiddenColumnKey();
        List<String> columnList = Arrays.asList(hiddengetColumn);
        for (String column : columnList) {
            entryFormat.fields.remove(column);
        }
    }

    public DynamicObjectCollection importPlanTask(IFormView view, String url, String appId, String entryKey) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("parentpageid", view.getPageId());
        params.put("url", url);
        params.put("appId", appId);
        params.put("entitynumber", view.getEntityId());
        params.put("entryKey", entryKey);
        DynamicObjectCollection entrys = this.executeImportTask(params);
        DynamicObject entrysdt = this.parentView.getModel().getDataEntity();
        if (entrys != null) {
            String selRule = (String)view.getFormShowParameter().getCustomParam("selRule");
            DynamicObject reportingtask = entrysdt.getDynamicObject("task");
            long orgId = this.getOrgIdByReportingtask(reportingtask, appId);
            if ("1".equals(selRule)) {
                ProgressTaskImpAndExpUtil.calculateDeptByDate(view, (List<DynamicObject>)entrys, orgId, appId);
            } else if ("2".equals(selRule)) {
                ProgressTaskImpAndExpUtil.calculateDeptByAbsoluteDuration(view, (List<DynamicObject>)entrys, orgId, appId);
            }
        }
        return entrys;
    }

    protected long getOrgIdByReportingtask(DynamicObject reportingtask, String appId) {
        if (reportingtask == null) {
            return 0L;
        }
        if ((reportingtask = BusinessDataServiceHelper.loadSingle((Object)reportingtask.getPkValue(), (String)MetaDataUtil.getEntityId((String)appId, (String)"task"))).getDynamicObject("meettask") != null) {
            return this.getOrgIdByReportingtask(reportingtask.getDynamicObject("meettask"), appId);
        }
        long planId = reportingtask.getLong("planid");
        DynamicObject belongplantype = reportingtask.getDynamicObject("belongplantype");
        String plantype = belongplantype.getString("plantype");
        QFilter filter1 = new QFilter("id", "=", (Object)planId);
        long orgId = 0L;
        DynamicObject[] sourcePlan = null;
        if (StringUtils.equals((CharSequence)"1", (CharSequence)plantype)) {
            sourcePlan = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"masterplan"), (String)"org", (QFilter[])new QFilter[]{filter1});
        } else if (StringUtils.equals((CharSequence)"2", (CharSequence)plantype)) {
            sourcePlan = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"specialplan"), (String)"org", (QFilter[])new QFilter[]{filter1});
        } else if (StringUtils.equals((CharSequence)"3", (CharSequence)plantype) || StringUtils.equals((CharSequence)"5", (CharSequence)plantype)) {
            sourcePlan = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"deptplan"), (String)"org", (QFilter[])new QFilter[]{filter1});
        } else if (StringUtils.equals((CharSequence)"4", (CharSequence)plantype)) {
            sourcePlan = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"personplan"), (String)"org", (QFilter[])new QFilter[]{filter1});
        }
        if (sourcePlan != null && sourcePlan.length > 0) {
            orgId = (Long)sourcePlan[0].getDynamicObject("org").getPkValue();
        }
        return orgId;
    }

    public static void calculateDeptByDate(IFormView view, List<DynamicObject> taskList, Object orgId, String appId) {
        for (DynamicObject task : taskList) {
            Date planStartTime = task.getDate("planstarttime1");
            Date planEndTime = task.getDate("planendtime1");
            BigDecimal newAbsoluteDuration = TaskUtil.getDaysBetweenTwoDateByOrg(orgId, planStartTime, planEndTime, appId);
            task.set("absoluteduration1", (Object)newAbsoluteDuration.add(BigDecimal.ONE));
        }
    }

    public static void calculateDeptByAbsoluteDuration(IFormView view, List<DynamicObject> taskList, Object orgId, String appId) {
        for (DynamicObject task : taskList) {
            Date planStartTime = task.getDate("planstarttime1");
            BigDecimal absoluteDuration = task.getBigDecimal("absoluteduration1");
            Date newPlanEndTime = TaskUtil.getDateAfterAddDaysByOrg(orgId, planStartTime, absoluteDuration.intValue() - 1, appId);
            task.set("planendtime1", (Object)newPlanEndTime);
        }
    }
}

