/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.business.utils.task;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.business.utils.task.TaskUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;

public class RiskColorUtil {
    public static void setColor(String appId, DynamicObject[] tasks, boolean isAdjust) {
        StringBuilder seletors = new StringBuilder();
        seletors.append("id").append(',').append("tasktype").append(',').append("planendtime").append(',').append("riskcolor").append(',').append("islatest").append(',').append("sourcetask").append(',').append("prechangetask").append(',').append("project").append(',').append("belongplantype").append(',').append("planid");
        for (DynamicObject task : tasks) {
            DynamicObject taskType = task.getDynamicObject("tasktype");
            Date planEndTime = task.getDate("planendtime");
            DynamicObject project = task.getDynamicObject("project");
            if (taskType == null || planEndTime == null) continue;
            QFilter taskFilter = new QFilter("task", "=", task.getPkValue());
            QFilter lastFilter = new QFilter("latest", "=", (Object)Boolean.TRUE);
            DynamicObject[] taskReport = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"taskreport"), (String)"percent,completetime", (QFilter[])new QFilter[]{taskFilter, lastFilter});
            if (taskReport.length > 0) {
                if (taskReport[0].getInt("percent") == 100) {
                    task.set("riskcolor", null);
                    continue;
                }
                Date completetime = taskReport[0].getDate("completetime");
                if (completetime != null && completetime.compareTo(planEndTime) > 0) {
                    BigDecimal newAbsoluteDuration;
                    QFilter filter = new QFilter("tasktype", "=", taskType.getPkValue());
                    DynamicObject[] riskWarnings = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"riskwarningset"), (String)"risktime, riskcolor, tasktype", (QFilter[])new QFilter[]{filter}, (String)"risktime");
                    if (project != null) {
                        newAbsoluteDuration = TaskUtil.getDaysBetweenTwoDate(project.getPkValue(), RiskColorUtil.getStartTime(), planEndTime, appId);
                    } else {
                        DynamicObject[] sourcePlan = null;
                        DynamicObject belongplantype = task.getDynamicObject("belongplantype");
                        if (belongplantype != null) {
                            String plantype = belongplantype.getString("plantype");
                            QFilter filter1 = new QFilter("id", "=", task.get("planid"));
                            if (StringUtils.equals((CharSequence)"3", (CharSequence)plantype)) {
                                sourcePlan = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"deptplan"), (String)"org", (QFilter[])new QFilter[]{filter1});
                            } else if (StringUtils.equals((CharSequence)"4", (CharSequence)plantype)) {
                                sourcePlan = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"personplan"), (String)"org", (QFilter[])new QFilter[]{filter1});
                            }
                        }
                        if (sourcePlan != null && sourcePlan.length > 0) {
                            newAbsoluteDuration = TaskUtil.getAbsDurationByOrgId(sourcePlan[0].getDynamicObject("org").getPkValue(), RiskColorUtil.getStartTime(), planEndTime, appId);
                        } else {
                            return;
                        }
                    }
                    boolean isRisk = false;
                    for (int i = 0; i < riskWarnings.length; ++i) {
                        DynamicObject risk = riskWarnings[i];
                        if (newAbsoluteDuration.compareTo(risk.getBigDecimal("risktime")) > 0 || newAbsoluteDuration.compareTo(BigDecimal.ZERO) <= 0) continue;
                        task.set("riskcolor", (Object)risk.getString("riskcolor"));
                        isRisk = true;
                        break;
                    }
                    if (isRisk) continue;
                    task.set("riskcolor", null);
                    continue;
                }
                task.set("riskcolor", null);
                continue;
            }
            boolean isLatest = task.getBoolean("islatest");
            DynamicObject sourceTask = task.getDynamicObject("sourcetask");
            DynamicObject precChangeTask = task.getDynamicObject("prechangetask");
            if (isAdjust) {
                isLatest = true;
            }
            if (!isLatest || precChangeTask == null || sourceTask == null) continue;
            QFilter sourceTaskFilter = new QFilter("sourcetask", "=", sourceTask.getPkValue());
            QFilter[] filters = new QFilter[]{sourceTaskFilter};
            QFilter historyTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"task"), (String)seletors.toString(), (QFilter[])filters);
            HashSet<Object> taskIds = new HashSet<Object>(((DynamicObject[])historyTasks).length);
            for (DynamicObject historyTask : historyTasks) {
                taskIds.add(historyTask.getPkValue());
            }
            QFilter taskFilterHis = new QFilter("task", "in", taskIds);
            QFilter lastFilterHis = new QFilter("latest", "=", (Object)Boolean.TRUE);
            DynamicObject[] taskReportHis = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"taskreport"), (String)"percent,completetime", (QFilter[])new QFilter[]{taskFilterHis, lastFilterHis});
            if (taskReportHis.length <= 0) continue;
            if (taskReportHis[0].getInt("percent") == 100) {
                task.set("riskcolor", null);
                continue;
            }
            Date completetime = taskReportHis[0].getDate("completetime");
            if (completetime != null && completetime.compareTo(planEndTime) > 0) {
                BigDecimal newAbsoluteDuration;
                QFilter filter = new QFilter("tasktype", "=", taskType.getPkValue());
                DynamicObject[] riskWarnings = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"riskwarningset"), (String)"risktime, riskcolor, tasktype", (QFilter[])new QFilter[]{filter}, (String)"risktime");
                if (project != null) {
                    newAbsoluteDuration = TaskUtil.getDaysBetweenTwoDate(project.getPkValue(), RiskColorUtil.getStartTime(), planEndTime, appId);
                } else {
                    DynamicObject[] sourcePlan = null;
                    DynamicObject belongplantype = task.getDynamicObject("belongplantype");
                    if (belongplantype != null) {
                        String plantype = belongplantype.getString("plantype");
                        QFilter filter1 = new QFilter("id", "=", task.get("planid"));
                        if (StringUtils.equals((CharSequence)"3", (CharSequence)plantype)) {
                            sourcePlan = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"deptplan"), (String)"org", (QFilter[])new QFilter[]{filter1});
                        } else if (StringUtils.equals((CharSequence)"4", (CharSequence)plantype)) {
                            sourcePlan = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"personplan"), (String)"org", (QFilter[])new QFilter[]{filter1});
                        }
                    }
                    if (sourcePlan != null && sourcePlan.length > 0) {
                        newAbsoluteDuration = TaskUtil.getAbsDurationByOrgId(sourcePlan[0].getDynamicObject("org").getPkValue(), RiskColorUtil.getStartTime(), planEndTime, appId);
                    } else {
                        return;
                    }
                }
                boolean isRisk = false;
                for (int i = 0; i < riskWarnings.length; ++i) {
                    DynamicObject risk = riskWarnings[i];
                    if (newAbsoluteDuration.compareTo(risk.getBigDecimal("risktime")) > 0 || newAbsoluteDuration.compareTo(BigDecimal.ZERO) <= 0) continue;
                    task.set("riskcolor", (Object)risk.getString("riskcolor"));
                    isRisk = true;
                    break;
                }
                if (isRisk) continue;
                task.set("riskcolor", null);
                continue;
            }
            task.set("riskcolor", null);
        }
    }

    private static Date getStartTime() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime();
    }
}

