/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.business.utils.task;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.url.UrlService;
import kd.pccs.placs.business.utils.task.AttachInfo;
import kd.pccs.placs.business.utils.task.AttachmentClassification;
import org.apache.commons.collections4.CollectionUtils;

public class TaskReportAttachMobUtil {
    private static final Set<String> IMAGE_MEDIA_TYPE = new HashSet<String>(Arrays.asList("png", "jpg", "gif"));
    private static final Set<String> VIDEO_MEDIA_TYPE = new HashSet<String>(Arrays.asList("mp4", "ogg", "webm"));

    public static AttachmentClassification classify(List<DynamicObjectCollection> allAttachments) {
        AttachmentClassification attachmentClassification = new AttachmentClassification();
        if (CollectionUtils.isEmpty(allAttachments)) {
            return attachmentClassification;
        }
        for (int i = 0; i < allAttachments.size(); ++i) {
            DynamicObjectCollection dynamicObjects = allAttachments.get(i);
            for (DynamicObject dynamicObject : dynamicObjects) {
                DynamicObject attachment = dynamicObject.getDynamicObject(1);
                TaskReportAttachMobUtil.classify(attachment, attachmentClassification);
            }
        }
        return attachmentClassification;
    }

    public static AttachmentClassification classifyAttachments(List<DynamicObject> attachments) {
        AttachmentClassification attachmentClassification = new AttachmentClassification();
        if (CollectionUtils.isEmpty(attachments)) {
            return attachmentClassification;
        }
        attachments.stream().forEach(attachment -> TaskReportAttachMobUtil.classify(attachment, attachmentClassification));
        return attachmentClassification;
    }

    protected static void classify(DynamicObject attachment, AttachmentClassification attachmentClassification) {
        RequestContext requestContext = RequestContext.get();
        String clientFullContextPath = requestContext.getClientFullContextPath();
        String type = attachment.getString("type");
        String url = attachment.getString("url");
        String name = attachment.getString("name");
        if (StringUtils.isEmpty((CharSequence)type) || StringUtils.isEmpty((CharSequence)url)) {
            return;
        }
        if (IMAGE_MEDIA_TYPE.contains(type) && attachmentClassification.getImageUrls().size() <= 9) {
            attachmentClassification.getImageUrls().add(new AttachInfo(url, name, type));
            return;
        }
        if (!url.contains(clientFullContextPath)) {
            url = UrlService.getAttachmentFullUrl((String)url);
        }
        if (VIDEO_MEDIA_TYPE.contains(type) && attachmentClassification.getVideoUrls().size() <= 1) {
            attachmentClassification.getVideoUrls().add(new AttachInfo(url, name, type));
            return;
        }
        attachmentClassification.getOtherUrls().add(new AttachInfo(url, name, type));
    }
}

