/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.business.utils.task;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.pccs.placs.common.utils.DateUtil;
import org.apache.commons.lang3.time.DateUtils;

public class TaskReportDateMobUtil {
    private static final String PATTEN_DEFAULT_YMD = "yyyy-MM-dd";
    private static final String PATTERN_MD = "MM-dd";

    public static String toShowName(Date date) {
        if (date == null) {
            return "";
        }
        if (TaskReportDateMobUtil.isToday(date)) {
            return TaskReportDateMobUtil.getTodayName();
        }
        if (TaskReportDateMobUtil.isYesterday(date)) {
            return TaskReportDateMobUtil.getYesterdayName();
        }
        return TaskReportDateMobUtil.toShortDate(date);
    }

    protected static String toShortDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(PATTERN_MD);
        return simpleDateFormat.format(date);
    }

    protected static boolean isToday(Date date) {
        Date currentDate = DateUtil.getCurrentDate();
        return TaskReportDateMobUtil.isInDay(date, currentDate);
    }

    protected static boolean isYesterday(Date date) {
        Date currentDate = DateUtil.getCurrentDate();
        Date yesterday = DateUtils.addDays((Date)currentDate, (int)-1);
        return TaskReportDateMobUtil.isInDay(date, yesterday);
    }

    protected static boolean isInDay(Date date, Date date1) {
        SimpleDateFormat sf = new SimpleDateFormat(PATTEN_DEFAULT_YMD);
        String day1 = sf.format(date1);
        String day = sf.format(date);
        return day1.equals(day);
    }

    protected static String getTodayName() {
        return ResManager.loadKDString((String)"\u4eca\u5929", (String)"TaskReportDateMobUtil_0", (String)"pccs-placs-business", (Object[])new Object[0]);
    }

    protected static String getYesterdayName() {
        return ResManager.loadKDString((String)"\u6628\u5929", (String)"TaskReportDateMobUtil_1", (String)"pccs-placs-business", (Object[])new Object[0]);
    }
}

