/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.business.utils.task;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.LogicalEnum;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;

public class TaskUtil {
    private static final String selectString = "id,parent,pretask,belongplantype,project,percent,completionstatus,realendtime,planstarttime,aimfinishtime,planendtime,absoluteduration,logical,relativeduration,comptimedeviation";
    private static final String DATATYPE_WORK = "1";

    public static void updateTaskStatusByIdSet(Set<Object> taskIdSet, String appId) {
        int compareResult;
        String completionStatus;
        int i;
        QFilter idFilter = new QFilter("id", "in", taskIdSet);
        Date nowDate = new Date();
        DynamicObject[] taskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"task"), (String)"id,completionstatus,percent,planstarttime,planendtime,realendtime", (QFilter[])new QFilter[]{idFilter});
        for (i = 0; i < taskArr.length; ++i) {
            Date planStartTime;
            completionStatus = taskArr[i].getString("completionstatus");
            if (!StringUtils.equals((CharSequence)completionStatus, (CharSequence)CompletionStatusEnum.UNSTART.getValue()) || (planStartTime = taskArr[i].getDate("planstarttime")) == null || (compareResult = DateUtil.compareByDay((Date)planStartTime, (Date)nowDate)) == 1) continue;
            taskArr[i].set("completionstatus", (Object)CompletionStatusEnum.PROGRESSING.getValue());
        }
        for (i = 0; i < taskArr.length; ++i) {
            Date planEndTime;
            completionStatus = taskArr[i].getString("completionstatus");
            if (!StringUtils.equals((CharSequence)completionStatus, (CharSequence)CompletionStatusEnum.PROGRESSING.getValue()) || (planEndTime = taskArr[i].getDate("planendtime")) == null || (compareResult = DateUtil.compareByDay((Date)planEndTime, (Date)nowDate)) != -1) continue;
            taskArr[i].set("completionstatus", (Object)CompletionStatusEnum.OVERDUE.getValue());
        }
        TaskUtil.updateTaskStatusByPlanTime(taskArr, appId);
        SaveServiceHelper.save((DynamicObject[])taskArr);
    }

    public static void autoUpdateUnStartToInProcess(String appId) {
        DynamicObject[] unStartTaskArr;
        ArrayList<DynamicObject> changedStatusTaskList = new ArrayList<DynamicObject>();
        Date nowDate = new Date();
        QFilter statusFilter = new QFilter("completionstatus", "=", (Object)CompletionStatusEnum.UNSTART.getValue());
        for (DynamicObject unStartTask : unStartTaskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"task"), (String)"id,completionstatus,planstarttime", (QFilter[])new QFilter[]{statusFilter})) {
            int compareResult;
            Date planStartTime = unStartTask.getDate("planstarttime");
            if (planStartTime == null || (compareResult = DateUtil.compareByDay((Date)planStartTime, (Date)nowDate)) == 1) continue;
            unStartTask.set("completionstatus", (Object)CompletionStatusEnum.PROGRESSING.getValue());
            changedStatusTaskList.add(unStartTask);
        }
        SaveServiceHelper.save((DynamicObject[])changedStatusTaskList.toArray(new DynamicObject[changedStatusTaskList.size()]));
    }

    public static void autoUpdateInProcessToOverdue(String appId) {
        DynamicObject[] inProcessTaskArr;
        ArrayList<DynamicObject> changedStatusTaskList = new ArrayList<DynamicObject>();
        Date nowDate = new Date();
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(CompletionStatusEnum.PROGRESSING.getValue());
        statusList.add(CompletionStatusEnum.ESTIMATEDELAY.getValue());
        QFilter statusFilter = new QFilter("completionstatus", "in", statusList);
        for (DynamicObject inProcessTask : inProcessTaskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"task"), (String)"id,completionstatus,planendtime", (QFilter[])new QFilter[]{statusFilter})) {
            int compareResult;
            Date planEndTime = inProcessTask.getDate("planendtime");
            if (planEndTime == null || (compareResult = DateUtil.compareByDay((Date)planEndTime, (Date)nowDate)) != -1) continue;
            inProcessTask.set("completionstatus", (Object)CompletionStatusEnum.OVERDUE.getValue());
            changedStatusTaskList.add(inProcessTask);
        }
        SaveServiceHelper.save((DynamicObject[])changedStatusTaskList.toArray(new DynamicObject[changedStatusTaskList.size()]));
    }

    public static Date getDateAfterAddDays(Object projectId, Date srcDate, int days, String appId) {
        List<DynamicObject> calList = TaskUtil.getCalendarList(projectId, appId);
        return TaskUtil.getDateAfterAddDays(calList, srcDate, days);
    }

    public static Date getDateAfterAddDays(Object projectId, Object orgId, Date srcDate, int days, String appId) {
        List<DynamicObject> calList = TaskUtil.getCalendarListByProject(projectId, appId);
        if (calList.size() == 0) {
            calList = TaskUtil.getCalListByOrg(orgId, appId);
        }
        return TaskUtil.getDateAfterAddDays(calList, srcDate, days);
    }

    public static Date getDateAfterAddDays(List<DynamicObject> calList, Date srcDate, int days) {
        if (srcDate == null) {
            return null;
        }
        return TaskUtil.getDateByCalList(calList, srcDate, days);
    }

    public static Date getDateAfterAddRelativeDays(Object projectId, Date srcDate, int relativeDays, String appId) {
        List<DynamicObject> calList = TaskUtil.getCalendarList(projectId, appId);
        return TaskUtil.getDateAfterAddRelativeDays(calList, srcDate, relativeDays);
    }

    public static Date getDateAfterAddRelativeDays(Object projectId, Object orgId, Date srcDate, int relativeDays, String appId) {
        List<DynamicObject> calList = TaskUtil.getCalendarListByProject(projectId, appId);
        if (calList.size() == 0) {
            calList = TaskUtil.getCalListByOrg(orgId, appId);
        }
        return TaskUtil.getDateAfterAddRelativeDays(calList, srcDate, relativeDays);
    }

    public static Date getDateAfterAddRelativeDays(List<DynamicObject> calList, Date srcDate, int relativeDays) {
        if (srcDate == null) {
            return null;
        }
        if (relativeDays == 0) {
            return srcDate;
        }
        return TaskUtil.getDateByCalListByRelative(calList, srcDate, relativeDays);
    }

    private static Date getDateByCalListByRelative(List<DynamicObject> calList, Date srcDate, int days) {
        if (calList != null && calList.size() > 0) {
            List<DynamicObject> projectCalendarDetailList = TaskUtil.getCalendarDetailList(calList);
            ArrayList<DynamicObject> workDateDetailList = new ArrayList<DynamicObject>();
            boolean srcDateIsWorkDay = false;
            if (days < 0) {
                for (DynamicObject projectCalendarDetail : projectCalendarDetailList) {
                    String dateType = projectCalendarDetail.getString("datetype");
                    if (!StringUtils.equals((CharSequence)DATATYPE_WORK, (CharSequence)dateType)) continue;
                    Date workDate = projectCalendarDetail.getDate("workdate");
                    if (srcDate.compareTo(workDate) == 0) {
                        srcDateIsWorkDay = true;
                    }
                    if (workDate.compareTo(srcDate) > 0) continue;
                    workDateDetailList.add(projectCalendarDetail);
                }
                if (workDateDetailList.size() < Math.abs(days)) {
                    String msg = String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u5de5\u671f\u540e\uff0c\u53d1\u73b0%1$s\u7684%2$s\u5929\u540e\u7684\u65e5\u671f\u4e0d\u5728\u5de5\u4f5c\u65e5\u5386\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u6709\u6548\u671f\u3002", (String)"TaskUtil_16", (String)"pccs-placs-business", (Object[])new Object[0]), srcDate.toString(), days);
                    throw new KDBizException(msg);
                }
                DynamicObject aimCalendar = (DynamicObject)workDateDetailList.get(workDateDetailList.size() + days);
                return aimCalendar.getDate("workdate");
            }
            for (DynamicObject projectCalendarDetail : projectCalendarDetailList) {
                String dateType = projectCalendarDetail.getString("datetype");
                if (!StringUtils.equals((CharSequence)DATATYPE_WORK, (CharSequence)dateType)) continue;
                Date workDate = projectCalendarDetail.getDate("workdate");
                if (srcDate.compareTo(workDate) == 0) {
                    srcDateIsWorkDay = true;
                }
                if (workDate.compareTo(srcDate) < 0) continue;
                workDateDetailList.add(projectCalendarDetail);
            }
            if (!srcDateIsWorkDay) {
                --days;
            }
            if (workDateDetailList.size() < days + 1) {
                String msg = String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u5de5\u671f\u540e\uff0c\u53d1\u73b0%1$s\u7684%2$s\u5929\u540e\u7684\u65e5\u671f\u4e0d\u5728\u5de5\u4f5c\u65e5\u5386\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u6709\u6548\u671f\u3002", (String)"TaskUtil_16", (String)"pccs-placs-business", (Object[])new Object[0]), srcDate.toString(), days);
                throw new KDBizException(msg);
            }
            DynamicObject aimCalendar = (DynamicObject)workDateDetailList.get(days);
            return aimCalendar.getDate("workdate");
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u9879\u76ee\u65e5\u5386\u4ee5\u53ca\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\u3002", (String)"TaskUtil_17", (String)"pccs-placs-business", (Object[])new Object[0]));
    }

    public static boolean checkDateIsWorkDay(Date date, Object id, int type, String appId) {
        boolean isWorkDay = false;
        List<DynamicObject> calList = type == 1 ? TaskUtil.getCalendarList(id, appId) : TaskUtil.getCalListByOrg(id, appId);
        List<DynamicObject> projectCalendarDetailList = TaskUtil.getCalendarDetailList(calList);
        for (DynamicObject projectCalendarDetail : projectCalendarDetailList) {
            Date workDate;
            String dateType = projectCalendarDetail.getString("datetype");
            if (!StringUtils.equals((CharSequence)DATATYPE_WORK, (CharSequence)dateType) || date.compareTo(workDate = projectCalendarDetail.getDate("workdate")) != 0) continue;
            isWorkDay = true;
            return isWorkDay;
        }
        return isWorkDay;
    }

    public static Date getDateAfterAddDaysByOrg(Object orgId, Date srcDate, int days, String appId) {
        if (orgId == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7ec4\u7ec7\u201d\u3002", (String)"TaskUtil_18", (String)"pccs-placs-business", (Object[])new Object[0]));
        }
        if (srcDate == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(srcDate);
        List<DynamicObject> calList = TaskUtil.getCalListByOrg(orgId, appId);
        return TaskUtil.getDateByCalList(calList, srcDate, days);
    }

    public static Date getDateAfterAddRelativeDaysByOrg(Object orgId, Date srcDate, int relativeDays, String appId) {
        if (orgId == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u9879\u76ee\u201d\u3002", (String)"TaskUtil_19", (String)"pccs-placs-business", (Object[])new Object[0]));
        }
        if (srcDate == null) {
            return null;
        }
        if (relativeDays == 0) {
            return srcDate;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(srcDate);
        List<DynamicObject> calList = TaskUtil.getCalListByOrg(orgId, appId);
        return TaskUtil.getDateByCalListByRelative(calList, srcDate, relativeDays);
    }

    public static BigDecimal getAbsDurationByOrgId(Object orgId, Date beginDate, Date endDate, String appId) {
        List<DynamicObject> calList = TaskUtil.getCalListByOrg(orgId, appId);
        return TaskUtil.getDaysByCalList(calList, beginDate, endDate);
    }

    public static List<DynamicObject> getCalListByOrg(Object orgId, String appId) {
        List<DynamicObject> calList = new ArrayList<DynamicObject>();
        QFilter orgFilter = new QFilter("org", "=", orgId);
        DynamicObject[] orgCalendarArr = BusinessDataServiceHelper.load((String)(appId + "_projworkcalendarset"), (String)"id,project,org,isindividuation,dateentry,dateentry.seq,dateentry.datetype,dateentry.workdate,version", (QFilter[])new QFilter[]{orgFilter}, (String)"isindividuation desc,createtime desc", (int)2);
        if (orgCalendarArr != null && orgCalendarArr.length > 0) {
            for (int i = 0; i < orgCalendarArr.length; ++i) {
                calList.add(orgCalendarArr[i]);
            }
        } else {
            List supOrg = OrgUnitServiceHelper.getSuperiorOrgs((String)"15", (long)Long.parseLong(orgId.toString()));
            if (supOrg != null && supOrg.size() > 0 && (Long)supOrg.get(0) != 0L) {
                calList = TaskUtil.getCalListByOrg(supOrg.get(0), appId);
            } else {
                QFilter defaultVersionFilter = new QFilter("version", "=", (Object)"default");
                for (DynamicObject dynamicObject : orgCalendarArr = BusinessDataServiceHelper.load((String)(appId + "_projworkcalendarset"), (String)"id,project,org,isindividuation,dateentry,dateentry.seq,dateentry.datetype,dateentry.workdate,version", (QFilter[])new QFilter[]{defaultVersionFilter}, (String)"isindividuation desc")) {
                    calList.add(dynamicObject);
                }
            }
        }
        return calList;
    }

    private static List<DynamicObject> getCalendarList(Object projectId, String appId) {
        ArrayList<DynamicObject> calList;
        block9: {
            Map projectCalendarArr;
            block7: {
                block8: {
                    calList = new ArrayList<DynamicObject>();
                    QFilter projectFilter = new QFilter("project", "=", projectId);
                    projectCalendarArr = BusinessDataServiceHelper.loadFromCache((String)(appId + "_projworkcalendarset"), (String)"id,project,isindividuation,dateentry,dateentry.seq,dateentry.datetype,dateentry.workdate,version", (QFilter[])new QFilter[]{projectFilter}, (String)"isindividuation desc");
                    if (projectCalendarArr == null || projectCalendarArr.isEmpty()) break block7;
                    if (projectCalendarArr.size() != 2) break block8;
                    for (Map.Entry entry : projectCalendarArr.entrySet()) {
                        calList.add((DynamicObject)entry.getValue());
                    }
                    break block9;
                }
                if (projectCalendarArr.size() != 1) break block9;
                DynamicObject projectCal = null;
                for (Map.Entry entry : projectCalendarArr.entrySet()) {
                    projectCal = (DynamicObject)entry.getValue();
                }
                if (projectCal != null && !projectCal.getBoolean("isindividuation")) {
                    for (Map.Entry entry : projectCalendarArr.entrySet()) {
                        calList.add((DynamicObject)entry.getValue());
                    }
                } else {
                    QFilter defaultVersionFilter = new QFilter("version", "=", (Object)"default");
                    DynamicObject[] defProjectCalendarArr = BusinessDataServiceHelper.load((String)(appId + "_projworkcalendarset"), (String)"id,project,isindividuation,dateentry,dateentry.seq,dateentry.datetype,dateentry.workdate,version", (QFilter[])new QFilter[]{defaultVersionFilter}, (String)"isindividuation desc");
                    calList.add(projectCal);
                    for (DynamicObject dynamicObject : defProjectCalendarArr) {
                        calList.add(dynamicObject);
                    }
                }
                break block9;
            }
            QFilter defaultVersionFilter = new QFilter("version", "=", (Object)"default");
            projectCalendarArr = BusinessDataServiceHelper.loadFromCache((String)(appId + "_projworkcalendarset"), (String)"id,project,isindividuation,dateentry,dateentry.seq,dateentry.datetype,dateentry.workdate,version", (QFilter[])new QFilter[]{defaultVersionFilter}, (String)"isindividuation desc");
            for (Map.Entry entry : projectCalendarArr.entrySet()) {
                calList.add((DynamicObject)entry.getValue());
            }
        }
        return calList;
    }

    public static List<DynamicObject> getCalendarListByProject(Object projectId, String appId) {
        ArrayList<DynamicObject> calList;
        block6: {
            Map projectCalendarArr;
            block7: {
                calList = new ArrayList<DynamicObject>();
                QFilter projectFilter = new QFilter("project", "=", projectId);
                projectCalendarArr = BusinessDataServiceHelper.loadFromCache((String)(appId + "_projworkcalendarset"), (String)"id,project,isindividuation,dateentry,dateentry.seq,dateentry.datetype,dateentry.workdate,version", (QFilter[])new QFilter[]{projectFilter}, (String)"isindividuation desc");
                if (projectCalendarArr == null || projectCalendarArr.isEmpty()) break block6;
                if (projectCalendarArr.size() != 2) break block7;
                for (Map.Entry entry : projectCalendarArr.entrySet()) {
                    calList.add((DynamicObject)entry.getValue());
                }
                break block6;
            }
            if (projectCalendarArr.size() != 1) break block6;
            DynamicObject projectCal = null;
            for (Map.Entry entry : projectCalendarArr.entrySet()) {
                projectCal = (DynamicObject)entry.getValue();
            }
            if (projectCal != null && !projectCal.getBoolean("isindividuation")) {
                for (Map.Entry entry : projectCalendarArr.entrySet()) {
                    calList.add((DynamicObject)entry.getValue());
                }
            } else {
                QFilter defaultVersionFilter = new QFilter("version", "=", (Object)"default");
                DynamicObject[] defProjectCalendarArr = BusinessDataServiceHelper.load((String)(appId + "_projworkcalendarset"), (String)"id,project,isindividuation,dateentry,dateentry.seq,dateentry.datetype,dateentry.workdate,version", (QFilter[])new QFilter[]{defaultVersionFilter}, (String)"isindividuation desc");
                calList.add(projectCal);
                for (DynamicObject dynamicObject : defProjectCalendarArr) {
                    calList.add(dynamicObject);
                }
            }
        }
        return calList;
    }

    public static BigDecimal getAbsDuration(Object projectId, Date beginDate, Date endDate, String appId) {
        List<DynamicObject> calList = TaskUtil.getCalendarList(projectId, appId);
        return TaskUtil.getAbsDuration(calList, beginDate, endDate);
    }

    public static BigDecimal getAbsDuration(List<DynamicObject> calList, Date beginDate, Date endDate) {
        return TaskUtil.getDaysByCalList(calList, beginDate, endDate);
    }

    private static Date getDateByCalList(List<DynamicObject> calList, Date srcDate, int days) {
        if (calList != null && calList.size() > 0) {
            List<DynamicObject> projectCalendarDetailList = TaskUtil.getCalendarDetailList(calList);
            ArrayList<DynamicObject> workDateDetailList = new ArrayList<DynamicObject>();
            if (days < 0) {
                for (DynamicObject projectCalendarDetail : projectCalendarDetailList) {
                    Date workDate;
                    String dateType = projectCalendarDetail.getString("datetype");
                    if (!StringUtils.equals((CharSequence)DATATYPE_WORK, (CharSequence)dateType) || (workDate = projectCalendarDetail.getDate("workdate")).compareTo(srcDate) > 0) continue;
                    workDateDetailList.add(projectCalendarDetail);
                }
                if (workDateDetailList.size() < Math.abs(days)) {
                    String msg = ResManager.loadKDString((String)"\u4f9d\u636e\u201c\u7edd\u5bf9\u5de5\u671f\u201d\u8ba1\u7b97\uff0c\u201c\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u201d\u5df2\u8d85\u51fa\u65e5\u5386\u8bbe\u7f6e\u8303\u56f4\uff0c\u8bf7\u4fee\u6539\u201c\u7edd\u5bf9\u5de5\u671f\u201d\u3002", (String)"TaskUtil_20", (String)"pccs-placs-business", (Object[])new Object[0]);
                    throw new KDBizException(msg);
                }
                DynamicObject aimCalendar = (DynamicObject)workDateDetailList.get(workDateDetailList.size() + days);
                return aimCalendar.getDate("workdate");
            }
            for (DynamicObject projectCalendarDetail : projectCalendarDetailList) {
                Date workDate;
                String dateType = projectCalendarDetail.getString("datetype");
                if (!StringUtils.equals((CharSequence)DATATYPE_WORK, (CharSequence)dateType) || (workDate = projectCalendarDetail.getDate("workdate")).compareTo(srcDate) < 0) continue;
                workDateDetailList.add(projectCalendarDetail);
            }
            if (workDateDetailList.size() < days + 1) {
                String msg = ResManager.loadKDString((String)"\u4f9d\u636e\u201c\u7edd\u5bf9\u5de5\u671f\u201d\u8ba1\u7b97\uff0c\u201c\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u201d\u5df2\u8d85\u51fa\u65e5\u5386\u8bbe\u7f6e\u8303\u56f4\uff0c\u8bf7\u4fee\u6539\u201c\u7edd\u5bf9\u5de5\u671f\u201d\u3002", (String)"TaskUtil_20", (String)"pccs-placs-business", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            DynamicObject aimCalendar = (DynamicObject)workDateDetailList.get(days);
            return aimCalendar.getDate("workdate");
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u9879\u76ee\u65e5\u5386\u4ee5\u53ca\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\u3002", (String)"TaskUtil_17", (String)"pccs-placs-business", (Object[])new Object[0]));
    }

    private static BigDecimal getDaysByCalList(List<DynamicObject> calList, Date beginDate, Date endDate) {
        ArrayList<DynamicObject> workDateDetailList = new ArrayList<DynamicObject>();
        if (calList != null && calList.size() > 0) {
            List<DynamicObject> projectCalendarDetailList = TaskUtil.getCalendarDetailList(calList);
            if (projectCalendarDetailList.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u9879\u76ee\u65e5\u5386\u4ee5\u53ca\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\u3002", (String)"TaskUtil_17", (String)"pccs-placs-business", (Object[])new Object[0]));
            }
            for (DynamicObject projectCalendarDetail : projectCalendarDetailList) {
                Date workDate;
                String dateType = projectCalendarDetail.getString("datetype");
                if (!StringUtils.equals((CharSequence)DATATYPE_WORK, (CharSequence)dateType) || (!(workDate = projectCalendarDetail.getDate("workdate")).after(beginDate) || !workDate.before(endDate)) && workDate.getTime() != beginDate.getTime() && workDate.getTime() != endDate.getTime()) continue;
                workDateDetailList.add(projectCalendarDetail);
            }
            return BigDecimal.valueOf(workDateDetailList.size());
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u9879\u76ee\u65e5\u5386\u4ee5\u53ca\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\u3002", (String)"TaskUtil_17", (String)"pccs-placs-business", (Object[])new Object[0]));
    }

    public static BigDecimal getDaysBetweenTwoDate(Object projectId, Date beginDate, Date endDate, String appId) {
        List<DynamicObject> calList = TaskUtil.getCalendarList(projectId, appId);
        return TaskUtil.getDaysBetweenTwoDate(calList, beginDate, endDate);
    }

    public static BigDecimal getDaysBetweenTwoDate(Object projectId, Object orgId, Date beginDate, Date endDate, String appId) {
        List<DynamicObject> calList = TaskUtil.getCalendarListByProject(projectId, appId);
        if (calList.size() == 0) {
            calList = TaskUtil.getCalListByOrg(orgId, appId);
        }
        return TaskUtil.getDaysBetweenTwoDate(calList, beginDate, endDate);
    }

    public static BigDecimal getDaysBetweenTwoDate(List<DynamicObject> calList, Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            return BigDecimal.ZERO;
        }
        if (beginDate.before(endDate) || beginDate.getTime() == endDate.getTime()) {
            return TaskUtil.getAbsDuration(calList, beginDate, endDate);
        }
        return BigDecimal.ZERO.subtract(TaskUtil.getAbsDuration(calList, endDate, beginDate));
    }

    public static BigDecimal getDaysBetweenTwoDateByOrg(Object orgId, Date beginDate, Date endDate, String appId) {
        if (beginDate == null || endDate == null) {
            return BigDecimal.ZERO;
        }
        if (beginDate.before(endDate) || beginDate.getTime() == endDate.getTime()) {
            return TaskUtil.getAbsDurationByOrgId(orgId, beginDate, endDate, appId);
        }
        return BigDecimal.ZERO.subtract(TaskUtil.getAbsDurationByOrgId(orgId, endDate, beginDate, appId));
    }

    public static String updateResultDoc(String resultDoc, int flag, int number) {
        String[] docNumArr = resultDoc.split("/");
        if (docNumArr.length != 2) {
            return resultDoc;
        }
        if (flag == 0) {
            String xString = docNumArr[0];
            String newString = xString.replaceFirst("\\d+", String.valueOf(number));
            return newString + "/" + docNumArr[1];
        }
        String xString = docNumArr[1];
        String newString = xString.replaceFirst("\\d+", String.valueOf(number));
        return docNumArr[0] + "/" + newString;
    }

    public static void updateReferTaskTime(DynamicObject Task, String appId) {
        DynamicObject project = Task.getDynamicObject("project");
        QFilter projectFilter = null;
        if (project != null) {
            projectFilter = new QFilter("project", "=", project.getPkValue());
        }
        QFilter notAuditFilter = new QFilter("status", "!=", (Object)"C");
        DynamicObject[] referTaskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"task"), (String)selectString, (QFilter[])new QFilter[]{projectFilter, notAuditFilter});
        TaskUtil.updataAfterTaskTime(referTaskArr, Task, appId);
        TaskUtil.updateParentTaskTime(referTaskArr, Task, appId);
        TaskUtil.updateTaskStatusByPlanTime(referTaskArr, appId);
        SaveServiceHelper.save((DynamicObject[])referTaskArr);
    }

    public static void updataAfterTaskTime(DynamicObject[] referTaskArr, DynamicObject currentTask, String appId) {
        for (int i = 0; i < referTaskArr.length; ++i) {
            DynamicObject preTaskOfReferTask = referTaskArr[i].getDynamicObject("pretask");
            if (preTaskOfReferTask == null) continue;
            Object preTaskId = preTaskOfReferTask.getPkValue();
            if (!currentTask.getPkValue().equals(preTaskId)) continue;
            TaskUtil.updateTimeByLogicAndPreTask(referTaskArr[i], currentTask, appId);
            if (TaskUtil.needToUpdateParentTime(referTaskArr[i])) {
                TaskUtil.updateParentTaskTime(referTaskArr, referTaskArr[i], appId);
            }
            TaskUtil.updataAfterTaskTime(referTaskArr, referTaskArr[i], appId);
        }
    }

    public static boolean needToUpdateParentTime(DynamicObject currentTask) {
        boolean flag = false;
        DynamicObject parentTask = currentTask.getDynamicObject("parent");
        if (parentTask != null) {
            Date afterUpdatePlanStartTime = currentTask.getDate("planstarttime");
            Date afterUpdatePlanEndTime = currentTask.getDate("planendtime");
            Date parentTaskPlanStartTime = parentTask.getDate("planstarttime");
            Date parentTaskPlanEndTime = parentTask.getDate("planendtime");
            if (afterUpdatePlanStartTime != null && parentTaskPlanStartTime == null || afterUpdatePlanEndTime != null && parentTaskPlanEndTime == null) {
                flag = true;
                return flag;
            }
            if (afterUpdatePlanStartTime != null && parentTaskPlanStartTime != null && afterUpdatePlanEndTime != null && parentTaskPlanEndTime != null && (afterUpdatePlanStartTime.before(parentTaskPlanStartTime) || afterUpdatePlanEndTime.after(parentTaskPlanEndTime))) {
                flag = true;
            }
        }
        return flag;
    }

    public static void updateTimeByLogicAndPreTask(DynamicObject currentTask, DynamicObject preTask, String appId) {
        Date planStartTime = preTask.getDate("planstarttime");
        Date planEndTime = preTask.getDate("planendtime");
        String logical = currentTask.getString("logical");
        DynamicObject project = currentTask.getDynamicObject("project");
        if (project == null) {
            return;
        }
        List<DynamicObject> calList = TaskUtil.getCalendarList(project.getPkValue(), appId);
        int relativeduration = currentTask.getInt("relativeduration");
        if (++relativeduration < 0) {
            --relativeduration;
        }
        if (StringUtils.equals((CharSequence)LogicalEnum.START_START.getValue(), (CharSequence)logical)) {
            Date newAfterTaskPlanStartTime = TaskUtil.getDateAfterAddRelativeDays(calList, planStartTime, relativeduration);
            TaskUtil.newCheckOutMainTaskTime(currentTask, newAfterTaskPlanStartTime, appId);
            currentTask.set("planstarttime", (Object)newAfterTaskPlanStartTime);
            BigDecimal absDuration = currentTask.getBigDecimal("absoluteduration");
            Date newAfterTaskPlanEndTime = TaskUtil.getDateAfterAddDays(calList, newAfterTaskPlanStartTime, absDuration.intValue() - 1);
            TaskUtil.newCheckOutMainTaskTime(currentTask, newAfterTaskPlanEndTime, appId);
            currentTask.set("planendtime", (Object)newAfterTaskPlanEndTime);
            BigDecimal days = TaskUtil.getDaysBetweenTwoDate(calList, newAfterTaskPlanEndTime, currentTask.getDate("aimfinishtime")).subtract(BigDecimal.ONE);
            currentTask.set("comptimedeviation", (Object)days);
        } else if (StringUtils.equals((CharSequence)LogicalEnum.START_FINISH.getValue(), (CharSequence)logical)) {
            Date newAfterTaskPlanEndTime = TaskUtil.getDateAfterAddRelativeDays(calList, planStartTime, relativeduration);
            TaskUtil.newCheckOutMainTaskTime(currentTask, newAfterTaskPlanEndTime, appId);
            currentTask.set("planendtime", (Object)newAfterTaskPlanEndTime);
            BigDecimal days = TaskUtil.getDaysBetweenTwoDate(calList, newAfterTaskPlanEndTime, currentTask.getDate("aimfinishtime")).subtract(BigDecimal.ONE);
            currentTask.set("comptimedeviation", (Object)days);
            BigDecimal absDuration = currentTask.getBigDecimal("absoluteduration");
            Date newAfterTaskPlanStartTime = TaskUtil.getDateAfterAddDays(calList, newAfterTaskPlanEndTime, -absDuration.intValue());
            TaskUtil.newCheckOutMainTaskTime(currentTask, newAfterTaskPlanStartTime, appId);
            currentTask.set("planstarttime", (Object)newAfterTaskPlanStartTime);
        } else if (StringUtils.equals((CharSequence)LogicalEnum.FINISH_START.getValue(), (CharSequence)logical)) {
            Date newAfterTaskPlanStartTime = TaskUtil.getDateAfterAddRelativeDays(calList, planEndTime, relativeduration);
            TaskUtil.newCheckOutMainTaskTime(currentTask, newAfterTaskPlanStartTime, appId);
            currentTask.set("planstarttime", (Object)newAfterTaskPlanStartTime);
            BigDecimal absDuration = currentTask.getBigDecimal("absoluteduration");
            Date newAfterTaskPlanEndTime = TaskUtil.getDateAfterAddDays(calList, newAfterTaskPlanStartTime, absDuration.intValue() - 1);
            TaskUtil.newCheckOutMainTaskTime(currentTask, newAfterTaskPlanEndTime, appId);
            currentTask.set("planendtime", (Object)newAfterTaskPlanEndTime);
            BigDecimal days = TaskUtil.getDaysBetweenTwoDate(calList, newAfterTaskPlanEndTime, currentTask.getDate("aimfinishtime")).subtract(BigDecimal.ONE);
            currentTask.set("comptimedeviation", (Object)days);
        } else if (StringUtils.equals((CharSequence)LogicalEnum.FINISH_FINISH.getValue(), (CharSequence)logical)) {
            Date newAfterTaskPlanEndTime = TaskUtil.getDateAfterAddRelativeDays(calList, planEndTime, relativeduration);
            TaskUtil.newCheckOutMainTaskTime(currentTask, newAfterTaskPlanEndTime, appId);
            currentTask.set("planendtime", (Object)newAfterTaskPlanEndTime);
            BigDecimal days = TaskUtil.getDaysBetweenTwoDate(calList, newAfterTaskPlanEndTime, currentTask.getDate("aimfinishtime")).subtract(BigDecimal.ONE);
            currentTask.set("comptimedeviation", (Object)days);
            BigDecimal absDuration = currentTask.getBigDecimal("absoluteduration");
            Date newAfterTaskPlanStartTime = TaskUtil.getDateAfterAddDays(calList, newAfterTaskPlanEndTime, -absDuration.intValue());
            TaskUtil.newCheckOutMainTaskTime(currentTask, newAfterTaskPlanStartTime, appId);
            currentTask.set("planstarttime", (Object)newAfterTaskPlanStartTime);
        }
    }

    public static void updateParentTaskTime(DynamicObject[] referTaskArr, DynamicObject currentTask, String appId) {
        DynamicObject parentTask = currentTask.getDynamicObject("parent");
        if (parentTask == null) {
            return;
        }
        for (int i = 0; i < referTaskArr.length; ++i) {
            if (!parentTask.getPkValue().equals(referTaskArr[i].getPkValue())) continue;
            DynamicObject currentTaskBelongPlanType = currentTask.getDynamicObject("belongplantype");
            DynamicObject parentTaskBelongPlanType = referTaskArr[i].getDynamicObject("belongplantype");
            if (currentTaskBelongPlanType != null && parentTaskBelongPlanType != null && StringUtils.equals((CharSequence)currentTaskBelongPlanType.getString("plantype"), (CharSequence)PlanTypeEnum.MAJORPLAN.getValue()) && StringUtils.equals((CharSequence)parentTaskBelongPlanType.getString("plantype"), (CharSequence)PlanTypeEnum.MAINPLAN.getValue())) {
                return;
            }
            List<Date> timeList = TaskUtil.getTimeListBySameParent(parentTask, referTaskArr);
            if (timeList == null || timeList.size() == 0) continue;
            TaskUtil.updateParentTaskTimeByTime(referTaskArr[i], timeList.get(0), timeList.get(1), appId);
            TaskUtil.updataAfterTaskTime(referTaskArr, referTaskArr[i], appId);
            TaskUtil.updateParentTaskTime(referTaskArr, referTaskArr[i], appId);
        }
    }

    private static List<Date> getTimeListBySameParent(DynamicObject parentTask, DynamicObject[] referTaskArr) {
        ArrayList<Date> timeList = new ArrayList<Date>();
        boolean changeFlag = false;
        Date firstStartTime = null;
        Date lastEndTime = null;
        for (int i = 0; i < referTaskArr.length; ++i) {
            DynamicObject parentTaskOfReferTask = referTaskArr[i].getDynamicObject("parent");
            if (parentTaskOfReferTask == null) continue;
            Object parentId = parentTaskOfReferTask.getPkValue();
            if (!parentTask.getPkValue().equals(parentId)) continue;
            Date planStartTime = referTaskArr[i].getDate("planstarttime");
            Date planEndTime = referTaskArr[i].getDate("planendtime");
            if (planStartTime != null && (firstStartTime == null || planStartTime.before(firstStartTime))) {
                firstStartTime = planStartTime;
                changeFlag = true;
            }
            if (planEndTime == null || lastEndTime != null && !planEndTime.after(lastEndTime)) continue;
            lastEndTime = planEndTime;
            changeFlag = true;
        }
        if (changeFlag) {
            timeList.add(firstStartTime);
            timeList.add(lastEndTime);
        }
        return timeList;
    }

    public static void updateParentTaskTimeByTime(DynamicObject parentTask, Date startTime, Date endTime, String appId) {
        DynamicObject project = parentTask.getDynamicObject("project");
        if (project != null) {
            List<DynamicObject> calList = TaskUtil.getCalendarList(project.getPkValue(), appId);
            parentTask.set("planstarttime", (Object)startTime);
            parentTask.set("planendtime", (Object)endTime);
            Date parentAimEndTime = parentTask.getDate("aimfinishtime");
            if (parentAimEndTime == null) {
                parentTask.set("aimfinishtime", (Object)endTime);
            }
            BigDecimal absDays = TaskUtil.getDaysBetweenTwoDate(calList, startTime, endTime);
            parentTask.set("absoluteduration", (Object)absDays);
            BigDecimal days = TaskUtil.getDaysBetweenTwoDate(calList, endTime, parentTask.getDate("aimfinishtime")).subtract(BigDecimal.ONE);
            parentTask.set("comptimedeviation", (Object)days);
        }
    }

    public static void updateParentTaskTimeByCurrentTask(DynamicObject parentTask, DynamicObject currentTask, String appId) {
        DynamicObject project = currentTask.getDynamicObject("project");
        if (project == null) {
            return;
        }
        List<DynamicObject> calList = TaskUtil.getCalendarList(project.getPkValue(), appId);
        Date afterUpdatePlanStartTime = currentTask.getDate("planstarttime");
        Date afterUpdatePlanEndTime = currentTask.getDate("planendtime");
        Date parentTaskPlanStartTime = parentTask.getDate("planstarttime");
        Date parentTaskPlanEndTime = parentTask.getDate("planendtime");
        if (afterUpdatePlanStartTime != null && (parentTaskPlanStartTime == null || afterUpdatePlanStartTime.before(parentTaskPlanStartTime))) {
            parentTask.set("planstarttime", (Object)afterUpdatePlanStartTime);
            BigDecimal absDuration = parentTask.getBigDecimal("absoluteduration");
            Date newAfterTaskPlanEndTime = TaskUtil.getDateAfterAddDays(calList, afterUpdatePlanStartTime, absDuration.intValue() - 1);
            parentTask.set("planendtime", (Object)newAfterTaskPlanEndTime);
            BigDecimal days = TaskUtil.getDaysBetweenTwoDate(calList, newAfterTaskPlanEndTime, parentTask.getDate("aimfinishtime")).subtract(BigDecimal.ONE);
            parentTask.set("comptimedeviation", (Object)days);
        }
        if (afterUpdatePlanEndTime != null && (parentTaskPlanEndTime == null || afterUpdatePlanEndTime.after(parentTaskPlanEndTime))) {
            parentTask.set("planendtime", (Object)afterUpdatePlanEndTime);
            if (parentTask.getDate("aimfinishtime") == null) {
                parentTask.set("aimfinishtime", (Object)afterUpdatePlanEndTime);
            }
            BigDecimal days = TaskUtil.getDaysBetweenTwoDate(calList, afterUpdatePlanEndTime, parentTask.getDate("aimfinishtime")).subtract(BigDecimal.ONE);
            parentTask.set("comptimedeviation", (Object)days);
            Date afterTaskPlanStartTime = parentTask.getDate("planstarttime");
            BigDecimal absDuration = TaskUtil.getDaysBetweenTwoDate(calList, afterTaskPlanStartTime, afterUpdatePlanEndTime);
            parentTask.set("absoluteduration", (Object)absDuration);
        }
    }

    private static List<DynamicObject> updateAllTaskEndTimeByProjectWhenCalChange(Object projectId, int prior, String appId) {
        DynamicObject[] taskArr;
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("C");
        statusList.add("B");
        QFilter statusFilter = new QFilter("status", "not in", statusList);
        ArrayList<DynamicObject> afterUpdateEndTimeTaskList = new ArrayList<DynamicObject>();
        if (projectId != null && StringUtils.equals((CharSequence)projectId.toString(), (CharSequence)"0")) {
            QFilter isProjectFilter = new QFilter("project", "!=", (Object)0L);
            taskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"task"), (String)"id,level,parent,pretask,project,belongplantype,completionstatus,planstarttime,planendtime,absoluteduration,logical,relativeduration,comptimedeviation", (QFilter[])new QFilter[]{isProjectFilter, statusFilter});
        } else {
            QFilter projectFilter = new QFilter("project", "=", projectId);
            taskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"task"), (String)"id,level,parent,pretask,project,belongplantype,completionstatus,planstarttime,planendtime,aimfinishtime,absoluteduration,logical,relativeduration,comptimedeviation", (QFilter[])new QFilter[]{projectFilter, statusFilter});
        }
        List<DynamicObject> calList = TaskUtil.getCalendarList(projectId, appId);
        if (prior == 1) {
            for (DynamicObject task : taskArr) {
                Date planStartTime = task.getDate("planstarttime");
                BigDecimal absoluteDuration = task.getBigDecimal("absoluteduration");
                Date planEndTime = TaskUtil.getDateAfterAddDays(calList, planStartTime, absoluteDuration.intValue() - 1);
                task.set("planendtime", (Object)planEndTime);
                Date aimEndTime = task.getDate("aimfinishtime");
                BigDecimal compTimeDeviation = TaskUtil.getDaysBetweenTwoDate(calList, planEndTime, aimEndTime).subtract(BigDecimal.ONE);
                task.set("comptimedeviation", (Object)compTimeDeviation);
                afterUpdateEndTimeTaskList.add(task);
            }
        } else {
            for (DynamicObject task : taskArr) {
                Date planStartTime = task.getDate("planstarttime");
                Date planEndTime = task.getDate("planendtime");
                BigDecimal absDuration = TaskUtil.getDaysBetweenTwoDate(calList, planStartTime, planEndTime);
                task.set("absoluteduration", (Object)absDuration);
                afterUpdateEndTimeTaskList.add(task);
            }
        }
        return afterUpdateEndTimeTaskList;
    }

    private static List<DynamicObject> updateAllTaskEndTime(DynamicObject[] taskArr, int prior, String appId) {
        ArrayList<DynamicObject> afterUpdateEndTimeTaskList = new ArrayList<DynamicObject>();
        if (prior == 1) {
            for (DynamicObject task : taskArr) {
                Date planStartTime = task.getDate("planstarttime");
                BigDecimal absoluteDuration = task.getBigDecimal("absoluteduration");
                DynamicObject project = task.getDynamicObject("project");
                if (project == null) continue;
                List<DynamicObject> calList = TaskUtil.getCalendarList(project.getPkValue(), appId);
                Date planEndTime = TaskUtil.getDateAfterAddDays(calList, planStartTime, absoluteDuration.intValue() - 1);
                task.set("planendtime", (Object)planEndTime);
                Date aimEndTime = task.getDate("aimfinishtime");
                BigDecimal compTimeDeviation = TaskUtil.getDaysBetweenTwoDate(calList, planEndTime, aimEndTime).subtract(BigDecimal.ONE);
                task.set("comptimedeviation", (Object)compTimeDeviation);
                afterUpdateEndTimeTaskList.add(task);
            }
        } else {
            for (DynamicObject task : taskArr) {
                Date planStartTime = task.getDate("planstarttime");
                Date planEndTime = task.getDate("planendtime");
                DynamicObject project = task.getDynamicObject("project");
                if (project == null) continue;
                List<DynamicObject> calList = TaskUtil.getCalendarList(project.getPkValue(), appId);
                BigDecimal absDuration = TaskUtil.getDaysBetweenTwoDate(calList, planStartTime, planEndTime);
                task.set("absoluteduration", (Object)absDuration);
                afterUpdateEndTimeTaskList.add(task);
            }
        }
        return afterUpdateEndTimeTaskList;
    }

    public static void updateTimeWhenCalChange(Object projectId, int prior, String appId) {
        List<DynamicObject> afterUpdateEndTimeTaskList = TaskUtil.updateAllTaskEndTimeByProjectWhenCalChange(projectId, prior, appId);
        DynamicObject[] afterUpdateEndTimeTaskArr = afterUpdateEndTimeTaskList.toArray(new DynamicObject[afterUpdateEndTimeTaskList.size()]);
        if (prior == 2) {
            SaveServiceHelper.save((DynamicObject[])afterUpdateEndTimeTaskArr);
            return;
        }
        for (int i = 0; i < afterUpdateEndTimeTaskList.size(); ++i) {
            TaskUtil.updataAfterTaskTime(afterUpdateEndTimeTaskArr, afterUpdateEndTimeTaskArr[i], appId);
            TaskUtil.updateParentTaskTime(afterUpdateEndTimeTaskArr, afterUpdateEndTimeTaskArr[i], appId);
        }
        SaveServiceHelper.save((DynamicObject[])afterUpdateEndTimeTaskArr);
    }

    public static void updateTimeWhenOrgCalChange(Object orgId, int prior, String appId) {
        TaskUtil.updateTimeByOrg(Long.valueOf(String.valueOf(orgId)), prior, appId);
        ArrayList<Long> orgList = new ArrayList<Long>();
        orgList.add(Long.valueOf(String.valueOf(orgId)));
        List directSubOrgList = OrgUnitServiceHelper.getSubOrgLimitLevel(orgList, (int)1, (boolean)false);
        if (directSubOrgList != null && !directSubOrgList.isEmpty()) {
            ArrayList<Long> noCalOrgList = new ArrayList<Long>();
            for (Long directSubOrg : directSubOrgList) {
                QFilter orgFilter = new QFilter("org", "=", (Object)directSubOrg);
                boolean isExist = QueryServiceHelper.exists((String)(appId + "_projworkcalendarset"), (QFilter[])new QFilter[]{orgFilter});
                if (isExist) continue;
                noCalOrgList.add(directSubOrg);
            }
            for (Long noCalOrg : noCalOrgList) {
                TaskUtil.updateTimeWhenOrgCalChange(noCalOrg, prior, appId);
            }
        }
    }

    private static void updateTimeByOrg(Long orgId, int prior, String appId) {
        Set<Object> taskIdSet = TaskUtil.getTaskIdSetByOrgId(orgId, appId);
        TaskUtil.updateDeptTaskTime(taskIdSet, prior, orgId, appId);
    }

    public static void updateDeptTaskTime(Set<Object> taskIdSet, int prior, Long orgId, String appId) {
        DynamicObject[] taskArr = BusinessDataServiceHelper.load((Object[])taskIdSet.toArray(), (DynamicObjectType)MetaDataUtil.getDT((String)appId, (String)"task"));
        ArrayList<DynamicObject> afterUpdateEndTimeTaskList = new ArrayList<DynamicObject>();
        if (prior == 1) {
            for (DynamicObject task : taskArr) {
                Date planStartTime = task.getDate("planstarttime");
                BigDecimal absoluteDuration = task.getBigDecimal("absoluteduration");
                Date planEndTime = TaskUtil.getDateAfterAddDaysByOrg(orgId, planStartTime, absoluteDuration.intValue() - 1, appId);
                task.set("planendtime", (Object)planEndTime);
                Date aimEndTime = task.getDate("aimfinishtime");
                BigDecimal compTimeDeviation = TaskUtil.getDaysBetweenTwoDateByOrg(orgId, planEndTime, aimEndTime, appId);
                task.set("comptimedeviation", (Object)compTimeDeviation);
                afterUpdateEndTimeTaskList.add(task);
            }
        } else {
            for (DynamicObject task : taskArr) {
                Date planStartTime = task.getDate("planstarttime");
                Date planEndTime = task.getDate("planendtime");
                BigDecimal absDuration = TaskUtil.getDaysBetweenTwoDateByOrg(orgId, planStartTime, planEndTime, appId);
                task.set("absoluteduration", (Object)absDuration.add(BigDecimal.ONE));
                afterUpdateEndTimeTaskList.add(task);
            }
        }
        SaveServiceHelper.save((DynamicObject[])afterUpdateEndTimeTaskList.toArray(new DynamicObject[afterUpdateEndTimeTaskList.size()]));
    }

    public static void updateTimeWhenDefaultCalChange(int prior, String appId) {
        TaskUtil.updateProjectTaskTime(prior, appId);
        Long rootOrg = OrgUnitServiceHelper.getRootOrgId();
        TaskUtil.updateTimeWhenOrgCalChange(rootOrg, prior, appId);
    }

    public static void updateProjectTaskTime(int prior, String appId) {
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("C");
        statusList.add("B");
        QFilter statusFilter = new QFilter("status", "not in", statusList);
        DynamicObject[] projCalArr = BusinessDataServiceHelper.load((String)(appId + "_projworkcalendarset"), (String)"id,project", (QFilter[])new QFilter[]{new QFilter("project", "!=", (Object)0L)});
        HashSet<Object> hasCalProjectIdSet = new HashSet<Object>();
        for (DynamicObject projCal : projCalArr) {
            DynamicObject project = projCal.getDynamicObject("project");
            if (project == null) continue;
            hasCalProjectIdSet.add(project.getPkValue());
        }
        QFilter projectNotInCalFilter = new QFilter("project", "not in", hasCalProjectIdSet);
        QFilter projectNotNullFilter = new QFilter("project", "!=", (Object)0L);
        DynamicObject[] taskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"task"), (String)"id,level,parent,pretask,project,belongplantype,completionstatus,planstarttime,planendtime,absoluteduration,logical,relativeduration,comptimedeviation,aimfinishtime", (QFilter[])new QFilter[]{projectNotInCalFilter, projectNotNullFilter, statusFilter});
        List<DynamicObject> afterUpdateEndTimeTaskList = TaskUtil.updateAllTaskEndTime(taskArr, prior, appId);
        DynamicObject[] afterUpdateEndTimeTaskArr = afterUpdateEndTimeTaskList.toArray(new DynamicObject[afterUpdateEndTimeTaskList.size()]);
        if (prior == 2) {
            SaveServiceHelper.save((DynamicObject[])afterUpdateEndTimeTaskArr);
            return;
        }
        for (int i = 0; i < afterUpdateEndTimeTaskList.size(); ++i) {
            TaskUtil.updataAfterTaskTime(afterUpdateEndTimeTaskArr, afterUpdateEndTimeTaskArr[i], appId);
            TaskUtil.updateParentTaskTime(afterUpdateEndTimeTaskArr, afterUpdateEndTimeTaskArr[i], appId);
        }
        SaveServiceHelper.save((DynamicObject[])afterUpdateEndTimeTaskArr);
    }

    public static Set<Object> getTaskIdSetByOrgId(Object orgId, String appId) {
        DynamicObject[] presonPlanArr;
        HashSet<Object> taskIdSet = new HashSet<Object>();
        QFilter orgFilter = null;
        if (StringUtils.isNotBlank((Object)orgId)) {
            orgFilter = new QFilter("org", "=", (Object)Long.parseLong(String.valueOf(orgId)));
        }
        QFilter billStatusFilter = new QFilter("billstatus", "!=", (Object)"C");
        DynamicObject[] deptPlanArr = BusinessDataServiceHelper.load((String)(appId + "_" + "deptplan"), (String)"id,org,billstatus,taskentity,taskentity.relationtask,taskentity.taskprojecttx", (QFilter[])new QFilter[]{billStatusFilter, orgFilter});
        if (deptPlanArr != null && deptPlanArr.length > 0) {
            for (DynamicObject deptPlan : deptPlanArr) {
                DynamicObjectCollection taskEntryCol = deptPlan.getDynamicObjectCollection("taskentity");
                if (taskEntryCol == null || taskEntryCol.isEmpty()) continue;
                for (DynamicObject taskEntry : taskEntryCol) {
                    DynamicObject project;
                    if (taskEntry.get("relationtask") != null || (project = taskEntry.getDynamicObject("taskprojecttx")) != null) continue;
                    taskIdSet.add(taskEntry.getPkValue());
                }
            }
        }
        if ((presonPlanArr = BusinessDataServiceHelper.load((String)(appId + "_" + "personplan"), (String)"id,org,billstatus,entryentity,entryentity.relationtask", (QFilter[])new QFilter[]{billStatusFilter, orgFilter})) != null && presonPlanArr.length > 0) {
            for (DynamicObject personPlan : presonPlanArr) {
                DynamicObjectCollection taskEntryCol = personPlan.getDynamicObjectCollection("entryentity");
                if (taskEntryCol == null || taskEntryCol.isEmpty()) continue;
                for (DynamicObject dynamicObject : taskEntryCol) {
                    if (dynamicObject.getDynamicObject("relationtask") == null) continue;
                    taskIdSet.add(dynamicObject.getPkValue());
                }
            }
        }
        return taskIdSet;
    }

    public static Set<Object> getParentAndAfterTaskIdSet(DynamicObject currentTask, String appId) {
        HashSet<Object> idSet = new HashSet<Object>();
        DynamicObject project = currentTask.getDynamicObject("project");
        QFilter projectFilter = null;
        if (project != null) {
            projectFilter = new QFilter("project", "=", project.getPkValue());
        }
        DynamicObject[] sameProjectTaskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"task"), (String)"id,name,parent,pretask", (QFilter[])new QFilter[]{projectFilter});
        TaskUtil.getAfterTaskIdSet(sameProjectTaskArr, idSet, currentTask);
        TaskUtil.getParentIdSet(sameProjectTaskArr, idSet, currentTask);
        return idSet;
    }

    private static void getParentIdSet(DynamicObject[] referTaskArr, Set<Object> idSet, DynamicObject currentTask) {
        DynamicObject parentTask = currentTask.getDynamicObject("parent");
        if (parentTask == null) {
            return;
        }
        for (int i = 0; i < referTaskArr.length; ++i) {
            if (!parentTask.getPkValue().equals(referTaskArr[i].getPkValue())) continue;
            idSet.add(referTaskArr[i].getPkValue());
            TaskUtil.getAfterTaskIdSet(referTaskArr, idSet, referTaskArr[i]);
            if (referTaskArr[i].getDynamicObject("parent") == null) continue;
            TaskUtil.getParentIdSet(referTaskArr, idSet, referTaskArr[i]);
        }
    }

    private static void getAfterTaskIdSet(DynamicObject[] referTaskArr, Set<Object> idSet, DynamicObject currentTask) {
        for (int i = 0; i < referTaskArr.length; ++i) {
            DynamicObject preTaskOfReferTask = referTaskArr[i].getDynamicObject("pretask");
            if (preTaskOfReferTask == null) continue;
            Object preTaskId = preTaskOfReferTask.getPkValue();
            if (!currentTask.getPkValue().equals(preTaskId)) continue;
            idSet.add(referTaskArr[i].getPkValue());
            if (referTaskArr[i].getDynamicObject("parent") != null) {
                TaskUtil.getParentIdSet(referTaskArr, idSet, referTaskArr[i]);
            }
            TaskUtil.getAfterTaskIdSet(referTaskArr, idSet, referTaskArr[i]);
        }
    }

    public static void cleanPreTaskAndLogicalWhereDelTask(Object taskId, String appId) {
        QFilter preTaskFilter = new QFilter("pretask", "=", taskId);
        DynamicObject[] taskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"task"), (String)"id,name,pretask,logical", (QFilter[])new QFilter[]{preTaskFilter});
        if (taskArr != null && taskArr.length > 0) {
            for (int i = 0; i < taskArr.length; ++i) {
                taskArr[i].set("pretask", null);
                taskArr[i].set("logical", null);
            }
            SaveServiceHelper.save((DynamicObject[])taskArr);
        }
    }

    public static void cleanParentPreTaskAndlogical(DynamicObject task, String appId) {
        DynamicObject belongPlanType = task.getDynamicObject("belongplantype");
        String planType = belongPlanType.getString("plantype");
        DynamicObject parent = task.getDynamicObject("parent");
        if (parent != null) {
            DynamicObject newParent = BusinessDataServiceHelper.loadSingle((Object)parent.getPkValue(), (String)MetaDataUtil.getEntityId((String)appId, (String)"task"));
            DynamicObject parentBelongPlanType = newParent.getDynamicObject("belongplantype");
            String parentPlanType = parentBelongPlanType.getString("plantype");
            if (StringUtils.equals((CharSequence)planType, (CharSequence)PlanTypeEnum.MAJORPLAN.getValue()) && StringUtils.equals((CharSequence)parentPlanType, (CharSequence)PlanTypeEnum.MAINPLAN.getValue())) {
                return;
            }
            if (newParent.get("pretask") != null || StringUtils.isNotBlank((CharSequence)newParent.getString("logical"))) {
                newParent.set("pretask", null);
                newParent.set("logical", null);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newParent});
            }
        }
    }

    public static List<DynamicObject> getCalendarDetailList(List<DynamicObject> calList) {
        ArrayList<DynamicObject> projectCalendarDetailList = new ArrayList<DynamicObject>();
        HashSet<Date> individuationDate = new HashSet<Date>();
        for (int i = 0; i < calList.size(); ++i) {
            Date workDate;
            DynamicObjectCollection dateEntry;
            DynamicObject projectCalendar = calList.get(i);
            boolean isIndividuation = projectCalendar.getBoolean("isindividuation");
            if (isIndividuation) {
                dateEntry = projectCalendar.getDynamicObjectCollection("dateentry");
                for (DynamicObject dynamicObject : dateEntry) {
                    workDate = dynamicObject.getDate("workdate");
                    individuationDate.add(workDate);
                    projectCalendarDetailList.add(dynamicObject);
                }
                continue;
            }
            dateEntry = projectCalendar.getDynamicObjectCollection("dateentry");
            for (DynamicObject dynamicObject : dateEntry) {
                workDate = dynamicObject.getDate("workdate");
                if (individuationDate.contains(workDate)) continue;
                projectCalendarDetailList.add(dynamicObject);
            }
        }
        Collections.sort(projectCalendarDetailList, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Date date2;
                Date date1 = o1.getDate("workdate");
                if (date1.after(date2 = o2.getDate("workdate"))) {
                    return 1;
                }
                if (date1.equals(date2)) {
                    return 0;
                }
                return -1;
            }
        });
        return projectCalendarDetailList;
    }

    public static Calendar getFirstDayByOrg(Object orgId, String appId) {
        if (orgId != null) {
            DynamicObject orgWorkCal = TaskUtil.getOrgCalHead(orgId, appId);
            if (orgWorkCal == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672c\u7ea7\u548c\u4e0a\u7ea7\u5747\u672a\u8bbe\u7f6e\u90e8\u95e8\u65e5\u5386\uff0c\u4e5f\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\u3002", (String)"TaskUtil_21", (String)"pccs-placs-business", (Object[])new Object[0]));
            }
            int yearFrom = orgWorkCal.getInt("expiringyearfrom");
            int monthFrom = orgWorkCal.getInt("expiringmonthfrom");
            Calendar firstDay = Calendar.getInstance();
            firstDay.set(yearFrom, monthFrom - 1, 1, 0, 0, 0);
            return firstDay;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u90e8\u95e8\u201d\u3002", (String)"TaskUtil_22", (String)"pccs-placs-business", (Object[])new Object[0]));
    }

    private static DynamicObject getOrgCalHead(Object orgId, String appId) {
        String selectCalString = "id,expiringyearfrom,expiringmonthfrom,expiringyearto,expiringmonthto";
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId.toString()));
        QFilter isIndividuationFilter = new QFilter("isindividuation", "=", (Object)"0");
        DynamicObject orgWorkCal = BusinessDataServiceHelper.loadSingle((String)(appId + "_projworkcalendarset"), (String)selectCalString, (QFilter[])new QFilter[]{orgFilter, isIndividuationFilter});
        if (orgWorkCal == null) {
            List supOrg = OrgUnitServiceHelper.getSuperiorOrgs((String)"15", (long)Long.parseLong(orgId.toString()));
            if (supOrg != null && supOrg.size() > 0 && (Long)supOrg.get(0) != 0L) {
                return TaskUtil.getOrgCalHead(supOrg.get(0), appId);
            }
            QFilter defaultVersionFilter = new QFilter("version", "=", (Object)"default");
            orgWorkCal = BusinessDataServiceHelper.loadSingle((String)(appId + "_projworkcalendarset"), (String)selectCalString, (QFilter[])new QFilter[]{defaultVersionFilter, isIndividuationFilter});
            return orgWorkCal;
        }
        return orgWorkCal;
    }

    public static Calendar getEndDayByOrg(Object orgId, String appId) {
        if (orgId != null) {
            DynamicObject orgWorkCal = TaskUtil.getOrgCalHead(orgId, appId);
            if (orgWorkCal == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672c\u7ea7\u548c\u4e0a\u7ea7\u5747\u672a\u8bbe\u7f6e\u90e8\u95e8\u65e5\u5386\uff0c\u4e5f\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\u3002", (String)"TaskUtil_21", (String)"pccs-placs-business", (Object[])new Object[0]));
            }
            int yearTo = orgWorkCal.getInt("expiringyearto");
            int monthTo = orgWorkCal.getInt("expiringmonthto");
            Calendar endDay = Calendar.getInstance();
            endDay.set(yearTo, monthTo - 1, 1, 0, 0, 0);
            endDay.set(yearTo, monthTo - 1, endDay.getActualMaximum(5), 0, 0, 0);
            return endDay;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaskUtil_7", (String)"pccs-placs-business", (Object[])new Object[0]));
    }

    public static Calendar getFirstDayByProject(Object projectId, String appId) {
        String selectString = "id,expiringyearfrom,expiringmonthfrom,expiringyearto,expiringmonthto";
        if (projectId != null) {
            QFilter projectFilter = new QFilter("project", "=", projectId);
            QFilter isIndividuationFilter = new QFilter("isindividuation", "=", (Object)"0");
            DynamicObject projWorkCal = BusinessDataServiceHelper.loadSingle((String)(appId + "_projworkcalendarset"), (String)selectString, (QFilter[])new QFilter[]{projectFilter, isIndividuationFilter});
            if (projWorkCal == null) {
                QFilter defaultVersionFilter = new QFilter("version", "=", (Object)"default");
                projWorkCal = BusinessDataServiceHelper.loadSingle((String)(appId + "_projworkcalendarset"), (String)selectString, (QFilter[])new QFilter[]{defaultVersionFilter, isIndividuationFilter});
                if (projWorkCal == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u9879\u76ee\u65e5\u5386\u4ee5\u53ca\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\u3002", (String)"TaskUtil_17", (String)"pccs-placs-business", (Object[])new Object[0]));
                }
            }
            int yearFrom = projWorkCal.getInt("expiringyearfrom");
            int monthFrom = projWorkCal.getInt("expiringmonthfrom");
            Calendar firstDay = Calendar.getInstance();
            firstDay.set(yearFrom, monthFrom - 1, 1, 0, 0, 0);
            return firstDay;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaskUtil_3", (String)"pccs-placs-business", (Object[])new Object[0]));
    }

    public static Calendar getFirstDayByProAndOrg(Object projectId, Object orgId, String appId) {
        String selectString = "id,expiringyearfrom,expiringmonthfrom,expiringyearto,expiringmonthto";
        if (projectId != null) {
            QFilter projectFilter = new QFilter("project", "=", projectId);
            QFilter isIndividuationFilter = new QFilter("isindividuation", "=", (Object)"0");
            DynamicObject projWorkCal = BusinessDataServiceHelper.loadSingle((String)(appId + "_projworkcalendarset"), (String)selectString, (QFilter[])new QFilter[]{projectFilter, isIndividuationFilter});
            if (projWorkCal == null && (projWorkCal = TaskUtil.getOrgCalHead(orgId, appId)) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672c\u7ea7\u548c\u4e0a\u7ea7\u5747\u672a\u8bbe\u7f6e\u90e8\u95e8\u65e5\u5386\uff0c\u4e5f\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\u3002", (String)"TaskUtil_21", (String)"pccs-placs-business", (Object[])new Object[0]));
            }
            int yearFrom = projWorkCal.getInt("expiringyearfrom");
            int monthFrom = projWorkCal.getInt("expiringmonthfrom");
            Calendar firstDay = Calendar.getInstance();
            firstDay.set(yearFrom, monthFrom - 1, 1, 0, 0, 0);
            return firstDay;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaskUtil_3", (String)"pccs-placs-business", (Object[])new Object[0]));
    }

    public static Calendar getEndDayByProject(Object projectId, String appId) {
        String selectString = "id,expiringyearfrom,expiringmonthfrom,expiringyearto,expiringmonthto";
        if (projectId != null) {
            QFilter projectFilter = new QFilter("project", "=", projectId);
            QFilter isIndividuationFilter = new QFilter("isindividuation", "=", (Object)"0");
            DynamicObject projWorkCal = BusinessDataServiceHelper.loadSingle((String)(appId + "_projworkcalendarset"), (String)selectString, (QFilter[])new QFilter[]{projectFilter, isIndividuationFilter});
            if (projWorkCal == null) {
                QFilter defaultVersionFilter = new QFilter("version", "=", (Object)"default");
                projWorkCal = BusinessDataServiceHelper.loadSingle((String)(appId + "_projworkcalendarset"), (String)selectString, (QFilter[])new QFilter[]{defaultVersionFilter, isIndividuationFilter});
                if (projWorkCal == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u9879\u76ee\u65e5\u5386\u4ee5\u53ca\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\u3002", (String)"TaskUtil_17", (String)"pccs-placs-business", (Object[])new Object[0]));
                }
            }
            int yearTo = projWorkCal.getInt("expiringyearto");
            int monthTo = projWorkCal.getInt("expiringmonthto");
            Calendar endDay = Calendar.getInstance();
            endDay.set(yearTo, monthTo - 1, 1, 0, 0, 0);
            endDay.set(yearTo, monthTo - 1, endDay.getActualMaximum(5), 0, 0, 0);
            return endDay;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaskUtil_3", (String)"pccs-placs-business", (Object[])new Object[0]));
    }

    public static Calendar getEndDayByProjectAndOrg(Object projectId, Object orgId, String appId) {
        String selectString = "id,expiringyearfrom,expiringmonthfrom,expiringyearto,expiringmonthto";
        if (projectId != null) {
            QFilter projectFilter = new QFilter("project", "=", projectId);
            QFilter isIndividuationFilter = new QFilter("isindividuation", "=", (Object)"0");
            DynamicObject projWorkCal = BusinessDataServiceHelper.loadSingle((String)(appId + "_projworkcalendarset"), (String)selectString, (QFilter[])new QFilter[]{projectFilter, isIndividuationFilter});
            if (projWorkCal == null && (projWorkCal = TaskUtil.getOrgCalHead(orgId, appId)) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672c\u7ea7\u548c\u4e0a\u7ea7\u5747\u672a\u8bbe\u7f6e\u90e8\u95e8\u65e5\u5386\uff0c\u4e5f\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\u3002", (String)"TaskUtil_21", (String)"pccs-placs-business", (Object[])new Object[0]));
            }
            int yearTo = projWorkCal.getInt("expiringyearto");
            int monthTo = projWorkCal.getInt("expiringmonthto");
            Calendar endDay = Calendar.getInstance();
            endDay.set(yearTo, monthTo - 1, 1, 0, 0, 0);
            endDay.set(yearTo, monthTo - 1, endDay.getActualMaximum(5), 0, 0, 0);
            return endDay;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaskUtil_3", (String)"pccs-placs-business", (Object[])new Object[0]));
    }

    public static boolean checkBeforeBeginTimeByHeadData(DynamicObject task, Date time, String appId) {
        if (time == null) {
            return false;
        }
        Calendar theTime = Calendar.getInstance();
        theTime.setTime(time);
        DynamicObject project = task.getDynamicObject("project");
        String selectString = "id,expiringyearfrom,expiringmonthfrom,expiringyearto,expiringmonthto";
        if (project != null) {
            QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
            QFilter isIndividuationFilter = new QFilter("isindividuation", "=", (Object)"0");
            DynamicObject projWorkCal = BusinessDataServiceHelper.loadSingle((String)(appId + "_projworkcalendarset"), (String)selectString, (QFilter[])new QFilter[]{projectFilter, isIndividuationFilter});
            if (projWorkCal == null) {
                QFilter defaultVersionFilter = new QFilter("version", "=", (Object)"default");
                projWorkCal = BusinessDataServiceHelper.loadSingle((String)(appId + "_projworkcalendarset"), (String)selectString, (QFilter[])new QFilter[]{defaultVersionFilter, isIndividuationFilter});
                if (projWorkCal == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u9879\u76ee\u65e5\u5386\u4ee5\u53ca\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\u3002", (String)"TaskUtil_17", (String)"pccs-placs-business", (Object[])new Object[0]));
                }
            }
            int yearFrom = projWorkCal.getInt("expiringyearfrom");
            int monthFrom = projWorkCal.getInt("expiringmonthfrom");
            Calendar firstDay = Calendar.getInstance();
            firstDay.set(yearFrom, monthFrom - 1, 1, 0, 0, 0);
            return theTime.before(firstDay);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u6ca1\u6709\u6302\u5728\u9879\u76ee\u4e0b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaskUtil_8", (String)"pccs-placs-business", (Object[])new Object[0]));
    }

    public static boolean checkAfterEndTimeByHeadData(DynamicObject task, Date time, String appId) {
        if (time == null) {
            return false;
        }
        Calendar theTime = Calendar.getInstance();
        theTime.setTime(time);
        DynamicObject project = task.getDynamicObject("project");
        String selectString = "id,expiringyearfrom,expiringmonthfrom,expiringyearto,expiringmonthto";
        if (project != null) {
            QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
            QFilter isIndividuationFilter = new QFilter("isindividuation", "=", (Object)"0");
            DynamicObject projWorkCal = BusinessDataServiceHelper.loadSingle((String)(appId + "_projworkcalendarset"), (String)selectString, (QFilter[])new QFilter[]{projectFilter, isIndividuationFilter});
            if (projWorkCal == null) {
                QFilter defaultVersionFilter = new QFilter("version", "=", (Object)"default");
                projWorkCal = BusinessDataServiceHelper.loadSingle((String)(appId + "_projworkcalendarset"), (String)selectString, (QFilter[])new QFilter[]{defaultVersionFilter, isIndividuationFilter});
                if (projWorkCal == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u9879\u76ee\u65e5\u5386\u4ee5\u53ca\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\u3002", (String)"TaskUtil_17", (String)"pccs-placs-business", (Object[])new Object[0]));
                }
            }
            int yearTo = projWorkCal.getInt("expiringyearto");
            int monthTo = projWorkCal.getInt("expiringmonthto");
            Calendar endDay = Calendar.getInstance();
            endDay.set(yearTo, monthTo - 1, 1, 0, 0, 0);
            endDay.set(yearTo, monthTo - 1, endDay.getActualMaximum(5), 0, 0, 0);
            return theTime.after(endDay);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u6ca1\u6709\u6302\u5728\u9879\u76ee\u4e0b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaskUtil_8", (String)"pccs-placs-business", (Object[])new Object[0]));
    }

    public static DynamicObject getNearestMainPlanParentTask(DynamicObject task, String appId) {
        DynamicObject currentTask = BusinessDataServiceHelper.loadSingle((Object)task.getPkValue(), (String)MetaDataUtil.getEntityId((String)appId, (String)"task"));
        DynamicObject parentTask = currentTask.getDynamicObject("parent");
        if (parentTask != null) {
            DynamicObject newParentTask = BusinessDataServiceHelper.loadSingle((Object)parentTask.getPkValue(), (String)MetaDataUtil.getEntityId((String)appId, (String)"task"));
            DynamicObject parentBelongPlanType = newParentTask.getDynamicObject("belongplantype");
            if (parentBelongPlanType != null) {
                String planType = parentBelongPlanType.getString("plantype");
                if (StringUtils.equals((CharSequence)PlanTypeEnum.MAINPLAN.getValue(), (CharSequence)planType)) {
                    return newParentTask;
                }
            }
            currentTask = TaskUtil.getNearestMainPlanParentTask(parentTask, appId);
        }
        return currentTask;
    }

    public static void newCheckOutMainTaskTime(DynamicObject task, Date newTime, String appId) {
        if (newTime == null) {
            return;
        }
        DynamicObject belongPlanType = task.getDynamicObject("belongplantype");
        if (belongPlanType != null) {
            DynamicObject sourceParentTask;
            DynamicObject sourceParentBelongPlanType;
            boolean isFromDB;
            String planType = belongPlanType.getString("plantype");
            if (StringUtils.equals((CharSequence)PlanTypeEnum.MAJORPLAN.getValue(), (CharSequence)planType) && (isFromDB = task.getDataEntityState().getFromDatabase()) && (sourceParentBelongPlanType = (sourceParentTask = TaskUtil.getNearestMainPlanParentTask(task, appId)).getDynamicObject("belongplantype")) != null) {
                String sourceTaskPlanType = sourceParentBelongPlanType.getString("plantype");
                if (StringUtils.equals((CharSequence)PlanTypeEnum.MAINPLAN.getValue(), (CharSequence)sourceTaskPlanType)) {
                    Date sourceTaskPlanStartTime = sourceParentTask.getDate("planstarttime");
                    Date sourceTaskPlanEndTime = sourceParentTask.getDate("planendtime");
                    if (sourceTaskPlanStartTime != null && newTime.before(sourceTaskPlanStartTime)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e13\u9879\u4efb\u52a1\u7684\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u4e3b\u9879\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"TaskUtil_23", (String)"pccs-placs-business", (Object[])new Object[0]));
                    }
                    if (sourceTaskPlanEndTime != null && newTime.after(sourceTaskPlanEndTime)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e13\u9879\u7684\u4efb\u52a1\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u4e3b\u9879\u7684\u4efb\u52a1\u7684\u5b8c\u6210\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"TaskUtil_10", (String)"pccs-placs-business", (Object[])new Object[0]));
                    }
                }
            }
        }
    }

    public static void updateTaskStatusByPlanTime(DynamicObject[] taskArr, String appId) {
        Date nowDate = new Date();
        for (int i = 0; i < taskArr.length; ++i) {
            String completeStatus = taskArr[i].getString("completionstatus");
            Date planEndTime = taskArr[i].getDate("planendtime");
            Date planStartTime = taskArr[i].getDate("planstarttime");
            if (StringUtils.equals((CharSequence)CompletionStatusEnum.UNSTART.getValue(), (CharSequence)completeStatus)) {
                int compareResult = DateUtil.compareByDay((Date)planStartTime, (Date)nowDate);
                if (compareResult == 1) continue;
                compareResult = DateUtil.compareByDay((Date)planEndTime, (Date)nowDate);
                if (compareResult == -1) {
                    taskArr[i].set("completionstatus", (Object)CompletionStatusEnum.OVERDUE.getValue());
                    continue;
                }
                taskArr[i].set("completionstatus", (Object)CompletionStatusEnum.PROGRESSING.getValue());
                continue;
            }
            if (StringUtils.equals((CharSequence)CompletionStatusEnum.PROGRESSING.getValue(), (CharSequence)completeStatus) || StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUE.getValue(), (CharSequence)completeStatus) || StringUtils.equals((CharSequence)CompletionStatusEnum.ESTIMATEDELAY.getValue(), (CharSequence)completeStatus)) {
                BigDecimal percent = taskArr[i].getBigDecimal("percent");
                if (percent != null && percent.compareTo(BigDecimal.ZERO) > 0) {
                    QFilter lasestFilter = new QFilter("latest", "=", (Object)DATATYPE_WORK);
                    QFilter auditFilter = new QFilter("billstatus", "=", (Object)"C");
                    QFilter taskFilter = new QFilter("task", "=", taskArr[i].getPkValue());
                    DynamicObject taskReport = BusinessDataServiceHelper.loadSingle((String)(appId + "_taskreport"), (String)"id,completetime", (QFilter[])new QFilter[]{lasestFilter, auditFilter, taskFilter});
                    if (taskReport == null) continue;
                    Date completeTime = taskReport.getDate("completetime");
                    int compareResult = DateUtil.compareByDay((Date)completeTime, (Date)planEndTime);
                    if (compareResult > 0) {
                        compareResult = DateUtil.compareByDay((Date)planEndTime, (Date)nowDate);
                        if (compareResult == -1) {
                            taskArr[i].set("completionstatus", (Object)CompletionStatusEnum.OVERDUE.getValue());
                            continue;
                        }
                        taskArr[i].set("completionstatus", (Object)CompletionStatusEnum.ESTIMATEDELAY.getValue());
                        continue;
                    }
                    taskArr[i].set("completionstatus", (Object)CompletionStatusEnum.PROGRESSING.getValue());
                    continue;
                }
                int compareResult = DateUtil.compareByDay((Date)planStartTime, (Date)nowDate);
                if (compareResult != 1) {
                    compareResult = DateUtil.compareByDay((Date)planEndTime, (Date)nowDate);
                    if (compareResult == -1) {
                        taskArr[i].set("completionstatus", (Object)CompletionStatusEnum.OVERDUE.getValue());
                        continue;
                    }
                    taskArr[i].set("completionstatus", (Object)CompletionStatusEnum.PROGRESSING.getValue());
                    continue;
                }
                taskArr[i].set("completionstatus", (Object)CompletionStatusEnum.UNSTART.getValue());
                continue;
            }
            if (!StringUtils.equals((CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue(), (CharSequence)completeStatus) && !StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue(), (CharSequence)completeStatus)) continue;
            Date realEndTime = taskArr[i].getDate("realendtime");
            int compareResult = DateUtil.compareByDay((Date)planEndTime, (Date)realEndTime);
            if (compareResult == -1) {
                taskArr[i].set("completionstatus", (Object)CompletionStatusEnum.OVERDUECOMPLETE.getValue());
                continue;
            }
            taskArr[i].set("completionstatus", (Object)CompletionStatusEnum.ONTIMECOMPLETE.getValue());
        }
    }
}

