/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.business.utils.task;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.placs.common.enums.PlanTypeEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;

public class TreeEntryUtils {
    private static final String DOWNGRADE = "downgrade";
    private static final String UPGRADE = "upgrade";

    private TreeEntryUtils() {
    }

    public static void upgradeRow(IFormView view, IDataModel model, int[] selRows, String entityId, String appId) {
        DynamicObject entry;
        if (selRows.length <= 0) {
            view.showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u5148\u9009\u4e2d\u884c\u3002", (String)"TreeEntryUtils_10", (String)"pccs-placs-business", (Object[])new Object[0]));
            return;
        }
        int beginSeq = model.getEntryCurrentRowIndex("taskentity");
        int level = (Integer)model.getValue("level", beginSeq);
        if (level == 1) {
            view.showMessage(ResManager.loadKDStringExt((String)"\u5f53\u524d\u8282\u70b9\u4e3a\u6839\u8282\u70b9\uff0c\u65e0\u6cd5\u5347\u7ea7\u3002", (String)"TreeEntryUtils_13", (String)"pccs-placs-business", (Object[])new Object[0]));
            return;
        }
        DynamicObject currentRow = model.getEntryRowEntity("taskentity", beginSeq);
        String formId = view.getFormShowParameter().getFormId();
        if ((appId + "_specialplan").equals(formId) && currentRow.getDynamicObject("relationtask") != null) {
            view.showMessage(ResManager.loadKDStringExt((String)"\u5f53\u524d\u8282\u70b9\u7531\u4e3b\u9879\u8ba1\u5212\u5f15\u5165\uff0c\u4e0d\u5141\u8bb8\u5347\u7ea7\u3002", (String)"TreeEntryUtils_14", (String)"pccs-placs-business", (Object[])new Object[0]));
            return;
        }
        int endSeq = TreeEntryUtils.findLastChildIndex(beginSeq, model);
        String parentTaskId = currentRow.getString("pid");
        for (int i = beginSeq - 1; i >= 0; --i) {
            DynamicObject seqTask = model.getEntryRowEntity("taskentity", i);
            if (!parentTaskId.equals(seqTask.getPkValue().toString()) || seqTask.getString("pid").equals("0") || seqTask.getDynamicObject("relationtask") == null) continue;
            view.showMessage(ResManager.loadKDStringExt((String)"\u4e0a\u7ea7\u8282\u70b9\u4e3a\u4e3b\u9879\u4efb\u52a1\uff0c\u4e0d\u5141\u8bb8\u5347\u7ea7\u3002", (String)"TreeEntryUtils_3", (String)"pccs-placs-business", (Object[])new Object[0]));
            return;
        }
        int parentTaskIndex = -1;
        Object grandpaId = null;
        boolean hasOtherChild = false;
        for (int i = beginSeq - 1; i >= 0; --i) {
            DynamicObject entry2 = model.getEntryRowEntity("taskentity", i);
            String curTaskId = entry2.getString("id");
            if (!StringUtils.equals((CharSequence)curTaskId, (CharSequence)parentTaskId)) continue;
            DynamicObjectCollection tasks = model.getEntryEntity("taskentity");
            int index = i + 1;
            while (i < tasks.size()) {
                if (index != beginSeq && ((DynamicObject)tasks.get(index)).getString("pid").equals(parentTaskId)) {
                    hasOtherChild = true;
                    break;
                }
                ++i;
            }
            if (!hasOtherChild) {
                entry2.set("isleaf", (Object)Boolean.TRUE);
            }
            parentTaskIndex = i;
            grandpaId = entry2.getString("pid");
            break;
        }
        int grandpaIndex = -1;
        for (int i = parentTaskIndex - 1; i >= 0; --i) {
            entry = model.getEntryRowEntity("taskentity", i);
            String curTaskId = entry.getString("id");
            if (!StringUtils.equals((CharSequence)curTaskId, grandpaId)) continue;
            grandpaIndex = i;
            break;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)entityId, (CharSequence)"deptplan") && parentTaskIndex != -1 && StringUtils.equalsIgnoreCase((CharSequence)entityId, (CharSequence)(appId + "_" + "deptplan"))) {
            DynamicObject relationTask = (DynamicObject)model.getValue("relationtask", parentTaskIndex);
            DynamicObject plantype = currentRow.getDynamicObject("belongplantype");
            if (relationTask != null && plantype != null && StringUtils.equalsIgnoreCase((CharSequence)plantype.getString("plantype"), (CharSequence)PlanTypeEnum.DEPTFENJIEPLAN.getValue())) {
                view.showMessage(ResManager.loadKDStringExt((String)"\u5f53\u524d\u5206\u89e3\u4efb\u52a1\u7684\u7236\u7ea7\u4e3a\u5f15\u5165\u4efb\u52a1\uff0c\u4e0d\u5141\u8bb8\u5347\u7ea7\u3002", (String)"TreeEntryUtils_15", (String)"pccs-placs-business", (Object[])new Object[0]));
                return;
            }
        }
        currentRow = model.getEntryRowEntity("taskentity", beginSeq);
        currentRow.set("pid", grandpaId == null ? Integer.valueOf(0) : grandpaId);
        for (int i = beginSeq; i <= endSeq; ++i) {
            entry = model.getEntryRowEntity("taskentity", i);
            model.setValue("level", (Object)entry.getBigDecimal("level").subtract(BigDecimal.ONE), i);
        }
        model.updateEntryCache(model.getEntryEntity("taskentity"));
        view.updateView("taskentity");
    }

    public static void downgradeRow(IFormView view, IDataModel model, int[] selRows, String entityId, String appId) {
        Object parentTaskPkId;
        Long preChangeTaskId;
        DynamicObject relationTask;
        if (selRows.length <= 0) {
            view.showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u5148\u9009\u4e2d\u884c", (String)"TreeEntryUtils_0", (String)"pccs-placs-business", (Object[])new Object[0]));
            return;
        }
        int beginSeq = model.getEntryCurrentRowIndex("taskentity");
        boolean isFirstNode = TreeEntryUtils.checkFirstNode(beginSeq, view, model);
        if (isFirstNode) {
            return;
        }
        int endSeq = TreeEntryUtils.findLastChildIndex(beginSeq, model);
        model.setValue("isleaf", (Object)Boolean.TRUE, endSeq);
        String parentTaskId = model.getEntryRowEntity("taskentity", beginSeq).getString("pid");
        DynamicObject parentTask = TreeEntryUtils.findLastSameParentTask(beginSeq, parentTaskId, model);
        String formId = view.getFormShowParameter().getFormId();
        DynamicObject currentRow = model.getEntryRowEntity("taskentity", beginSeq);
        if ((appId + "_specialplan").equals(formId) && currentRow.getDynamicObject("relationtask") != null) {
            view.showMessage(ResManager.loadKDStringExt((String)"\u5f53\u524d\u8282\u70b9\u7531\u4e3b\u9879\u8ba1\u5212\u5f15\u5165\uff0c\u4e0d\u5141\u8bb8\u964d\u7ea7\u3002", (String)"TreeEntryUtils_16", (String)"pccs-placs-business", (Object[])new Object[0]));
            return;
        }
        if (parentTask != null && (appId + "_majorplan").equals(formId)) {
            DynamicObject belongPlanType = parentTask.getDynamicObject("belongplantype");
            boolean isleaf = parentTask.getBoolean("isleaf");
            if (!isleaf && "1".equals(belongPlanType.getString("plantype"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u964d\u7ea7\u7684\u4e0a\u7ea7\u8282\u70b9\u4e3a\u975e\u660e\u7ec6\u4e3b\u9879\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TreeEntryUtils_17", (String)"pccs-placs-business", (Object[])new Object[0]));
            }
        }
        if (parentTask != null && (appId + "_specialplan").equals(formId) && (relationTask = parentTask.getDynamicObject("relationtask")) != null && !relationTask.getBoolean("isleaf")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u964d\u7ea7\u7684\u4e0a\u7ea7\u8282\u70b9\u4e3a\u975e\u660e\u7ec6\u4e3b\u9879\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TreeEntryUtils_17", (String)"pccs-placs-business", (Object[])new Object[0]));
        }
        int parentIndex = 0;
        for (int i = beginSeq - 1; i >= 0; --i) {
            String curTaskId = model.getEntryRowEntity("taskentity", i).getPkValue().toString();
            if (parentTask == null || !curTaskId.equals(parentTask.getString("id"))) continue;
            model.setValue("isleaf", (Object)Boolean.FALSE, i);
            parentIndex = i;
        }
        if (StringUtils.equals((CharSequence)entityId, (CharSequence)MetaDataUtil.getEntityId((String)appId, (String)"masterplan")) && parentIndex >= 0 && (preChangeTaskId = Long.valueOf(model.getEntryRowEntity("taskentity", parentIndex).getLong("prechangetask_id"))) != 0L) {
            long sourceTaskId = model.getEntryRowEntity("taskentity", parentIndex).getLong("sourcetask_id");
            HashSet<Long> taskIdSet = new HashSet<Long>(16);
            DynamicObjectCollection sameSourceTaskCol = QueryServiceHelper.query((String)MetaDataUtil.getEntityId((String)appId, (String)"task"), (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcetask", "=", (Object)sourceTaskId)});
            for (DynamicObject sameSourceTask : sameSourceTaskCol) {
                taskIdSet.add(sameSourceTask.getLong("id"));
            }
            QFilter relatedMasterTaskFilter = new QFilter("relatedmastertask", "in", taskIdSet);
            DynamicObject specPlan = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)appId, (String)"specialplan"), (String)"id", (QFilter[])new QFilter[]{relatedMasterTaskFilter});
            if (specPlan != null) {
                view.showMessage(ResManager.loadKDStringExt((String)"\u8be5\u8282\u70b9\u65e0\u6cd5\u964d\u7ea7\u4e3a\u5b50\u7ea7\uff0c\u56e0\u4e3a\u5b83\u88ab\u7528\u4f5c\u5173\u8054\u4efb\u52a1\u3002", (String)"TreeEntryUtils_18", (String)"pccs-placs-business", (Object[])new Object[0]));
                return;
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)entityId, (CharSequence)(appId + "_" + "deptplan")) && parentIndex >= 0 && model.getValue("relationtask", parentIndex) != null) {
            view.showMessage(ResManager.loadKDStringExt((String)"\u8be5\u8282\u70b9\u4e0d\u80fd\u964d\u7ea7\u4e3a\u5f15\u5165\u4efb\u52a1\u7684\u5b50\u7ea7\u3002", (String)"TreeEntryUtils_12", (String)"pccs-placs-business", (Object[])new Object[0]));
            return;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)entityId, (CharSequence)(appId + "_" + "deptplan"))) {
            model.setValue("pretask", null, parentIndex);
            model.setValue("logical", null, parentIndex);
        }
        if ((parentTaskPkId = parentTask.getPkValue()) == null) {
            return;
        }
        DynamicObject entryRowEntiry = model.getEntryRowEntity("taskentity", beginSeq);
        entryRowEntiry.set("pid", parentTaskPkId);
        model.setValue("isleaf", (Object)Boolean.FALSE, parentIndex);
        for (int i = endSeq; i >= beginSeq; --i) {
            DynamicObject curRowEntiry = model.getEntryRowEntity("taskentity", i);
            model.setValue("level", (Object)curRowEntiry.getBigDecimal("level").add(BigDecimal.ONE), i);
        }
        model.updateCache();
        view.updateView("taskentity");
    }

    public static boolean isAllowMoveDown(IDataModel dataModel, int[] selectRows, String entryId) {
        boolean bAllowMove = true;
        int maxRow = Integer.MIN_VALUE;
        for (int i : selectRows) {
            if (maxRow >= i) continue;
            maxRow = i;
        }
        int rowCount = dataModel.getEntryRowCount(entryId);
        if (maxRow >= rowCount - 1) {
            bAllowMove = false;
        } else {
            bAllowMove = false;
            Object pid = dataModel.getEntryRowEntity(entryId, maxRow).get("pid");
            int j = 1;
            while (dataModel.getEntryRowEntity(entryId, maxRow + j) != null) {
                if (pid.equals(dataModel.getEntryRowEntity(entryId, maxRow + j).get("pid"))) {
                    bAllowMove = true;
                    break;
                }
                ++j;
            }
            for (int i : selectRows) {
                if (pid.equals(dataModel.getEntryRowEntity(entryId, i).get("pid"))) continue;
                bAllowMove = false;
            }
        }
        return bAllowMove;
    }

    public static boolean isAllowMoveUp(IDataModel dataModel, int[] selectRows, String entryId) {
        boolean bAllowMove = true;
        int minRow = Integer.MAX_VALUE;
        for (int i : selectRows) {
            if (minRow <= i) continue;
            minRow = i;
        }
        if (minRow <= 0) {
            bAllowMove = false;
        } else {
            Object pid = dataModel.getEntryRowEntity(entryId, minRow).get("pid");
            for (int i : selectRows) {
                if (pid.equals(dataModel.getEntryRowEntity(entryId, i).get("pid"))) continue;
                bAllowMove = false;
            }
            if (pid != null && !pid.toString().equals("0") && pid.equals(dataModel.getEntryRowEntity(entryId, minRow - 1).getPkValue())) {
                bAllowMove = false;
            }
        }
        return bAllowMove;
    }

    private static int findLastChildIndex(int beginSeq, IDataModel model) {
        int rowCount = model.getEntryRowCount("taskentity") - 1;
        int endSeq = beginSeq;
        if (beginSeq < rowCount) {
            Long thisTaskId = (Long)model.getEntryRowEntity("taskentity", beginSeq).getPkValue();
            HashSet<Long> parents = new HashSet<Long>();
            parents.add(thisTaskId);
            while (endSeq < rowCount) {
                DynamicObject nextRow;
                Long nextRowTaskParentId;
                if (!parents.contains(nextRowTaskParentId = Long.valueOf((nextRow = model.getEntryRowEntity("taskentity", ++endSeq)).getLong("pid")))) {
                    --endSeq;
                    break;
                }
                parents.add((Long)model.getEntryRowEntity("taskentity", endSeq).getPkValue());
            }
        }
        return endSeq;
    }

    private static void setRowObj(DynamicObject rowObj, int seq, IFormView view, String entityId, String appId) {
        IDataModel model = view.getModel();
        if (StringUtils.equalsIgnoreCase((CharSequence)entityId, (CharSequence)(appId + "_" + "deptplan"))) {
            model.beginInit();
            model.setValue("level", (Object)rowObj.getBigDecimal("level"), seq);
            model.setValue("isleaf", (Object)rowObj.getBoolean("isleaf"), seq);
            model.setValue("tasknametx", (Object)rowObj.getString("tasknametx"), seq);
            model.setValue("taskcontrolleveltx", (Object)rowObj.getDynamicObject("taskcontrolleveltx"), seq);
            model.setValue("taskstarttimetx", (Object)rowObj.getDate("taskstarttimetx"), seq);
            model.setValue("taskendtimetx", (Object)rowObj.getDate("taskendtimetx"), seq);
            model.setValue("taskmubiaotx", (Object)rowObj.getDate("taskmubiaotx"), seq);
            model.setValue("tasktimepctx", (Object)rowObj.getBigDecimal("tasktimepctx"), seq);
            model.setValue("taskjdgqtx", (Object)rowObj.getBigDecimal("taskjdgqtx"), seq);
            model.setValue("respersontx", (Object)rowObj.getDynamicObject("respersontx"), seq);
            model.setValue("resdepttx", (Object)rowObj.getDynamicObject("resdepttx"), seq);
            model.setValue("coopersontx", (Object)rowObj.getDynamicObject("coopersontx"), seq);
            model.setValue("coodepttx", (Object)rowObj.getDynamicObject("coodepttx"), seq);
            model.setValue("belongplantype", rowObj.get("belongplantype"), seq);
            model.setValue("completionstatus", rowObj.get("completionstatus"), seq);
            model.setValue("majortype", rowObj.get("majortype"), seq);
            model.setValue("percent", rowObj.get("percent"), seq);
            model.setValue("prechangetask", rowObj.get("prechangetask"), seq);
            model.setValue("relationtask", rowObj.get("relationtask"), seq);
            model.setValue("taskprojecttx", rowObj.get("taskprojecttx"), seq);
            model.setValue("tasksource", rowObj.get("tasksource"), seq);
            model.setValue("sourcetask", rowObj.get("sourcetask"), seq);
            model.setValue("tasktype", rowObj.get("tasktype"), seq);
            model.setValue("taskversion", rowObj.get("taskversion"), seq);
            model.endInit();
            view.updateView("tasknametx", seq);
            view.updateView("taskcontrolleveltx", seq);
            view.updateView("taskstarttimetx", seq);
            view.updateView("taskendtimetx", seq);
            view.updateView("taskmubiaotx", seq);
            view.updateView("tasktimepctx", seq);
            view.updateView("taskjdgqtx", seq);
            view.updateView("respersontx", seq);
            view.updateView("resdepttx", seq);
            view.updateView("coopersontx", seq);
            view.updateView("coodepttx", seq);
            view.updateView("belongplantype", seq);
            view.updateView("taskprojecttx", seq);
            view.updateView("tasksource", seq);
            view.updateView("taskversion", seq);
            view.updateView("tasksourcetx", seq);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)entityId, (CharSequence)(appId + "_" + "masterplan"))) {
            model.beginInit();
            model.setValue("name", (Object)rowObj.getString("name"), seq);
            model.setValue("number", (Object)rowObj.getString("number"), seq);
            model.setValue("controllevel", (Object)rowObj.getDynamicObject("controllevel"), seq);
            model.setValue("specialtype", (Object)rowObj.getDynamicObject("specialtype"), seq);
            model.setValue("tasktype", (Object)rowObj.getDynamicObject("tasktype"), seq);
            model.setValue("absoluteduration", (Object)rowObj.getBigDecimal("absoluteduration"), seq);
            model.setValue("pretask", (Object)rowObj.getDynamicObject("pretask"), seq);
            model.setValue("logical", (Object)rowObj.getString("logical"), seq);
            model.setValue("level", (Object)rowObj.getBigDecimal("level"), seq);
            model.setValue("isleaf", (Object)rowObj.getBoolean("isleaf"), seq);
            model.setValue("relativeduration", (Object)rowObj.getBigDecimal("relativeduration"), seq);
            model.setValue("planstarttime", (Object)rowObj.getDate("planstarttime"), seq);
            model.setValue("planendtime", (Object)rowObj.getDate("planendtime"), seq);
            model.setValue("aimfinishtime", (Object)rowObj.getDate("aimfinishtime"), seq);
            model.setValue("comptimedeviation", (Object)rowObj.getBigDecimal("comptimedeviation"), seq);
            model.setValue("responsibleperson", (Object)rowObj.getDynamicObject("responsibleperson"), seq);
            model.setValue("responsibledept", (Object)rowObj.getDynamicObject("responsibledept"), seq);
            model.setValue("cooperationperson", (Object)rowObj.getDynamicObject("cooperationperson"), seq);
            model.setValue("cooperationdept", (Object)rowObj.getDynamicObject("cooperationdept"), seq);
            model.endInit();
            view.updateView("name", seq);
            view.updateView("number", seq);
            view.updateView("controllevel", seq);
            view.updateView("tasktype", seq);
            view.updateView("specialtype", seq);
            view.updateView("absoluteduration", seq);
            view.updateView("pretask", seq);
            view.updateView("logical", seq);
            view.updateView("relativeduration", seq);
            view.updateView("planstarttime", seq);
            view.updateView("planendtime", seq);
            view.updateView("aimfinishtime", seq);
            view.updateView("comptimedeviation", seq);
            view.updateView("responsibleperson", seq);
            view.updateView("responsibledept", seq);
            view.updateView("cooperationperson", seq);
            view.updateView("cooperationdept", seq);
            view.updateView("name", seq);
            view.updateView("level", seq);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)entityId, (CharSequence)(appId + "_" + "specialplan"))) {
            model.beginInit();
            model.setValue("name", (Object)rowObj.getString("name"), seq);
            model.setValue("number", (Object)rowObj.getString("number"), seq);
            model.setValue("controllevel", (Object)rowObj.getDynamicObject("controllevel"), seq);
            model.setValue("specialtype", (Object)rowObj.getDynamicObject("specialtype"), seq);
            model.setValue("tasktype", (Object)rowObj.getDynamicObject("tasktype"), seq);
            model.setValue("absoluteduration", (Object)rowObj.getBigDecimal("absoluteduration"), seq);
            model.setValue("pretask", (Object)rowObj.getDynamicObject("pretask"), seq);
            model.setValue("logical", (Object)rowObj.getString("logical"), seq);
            model.setValue("level", (Object)rowObj.getBigDecimal("level"), seq);
            model.setValue("isleaf", (Object)rowObj.getBoolean("isleaf"), seq);
            model.setValue("relativeduration", (Object)rowObj.getBigDecimal("relativeduration"), seq);
            model.setValue("planstarttime", (Object)rowObj.getDate("planstarttime"), seq);
            model.setValue("planendtime", (Object)rowObj.getDate("planendtime"), seq);
            model.setValue("aimfinishtime", (Object)rowObj.getDate("aimfinishtime"), seq);
            model.setValue("comptimedeviation", (Object)rowObj.getBigDecimal("comptimedeviation"), seq);
            model.setValue("responsibleperson", (Object)rowObj.getDynamicObject("responsibleperson"), seq);
            model.setValue("responsibledept", (Object)rowObj.getDynamicObject("responsibledept"), seq);
            model.setValue("cooperationperson", (Object)rowObj.getDynamicObject("cooperationperson"), seq);
            model.setValue("cooperationdept", (Object)rowObj.getDynamicObject("cooperationdept"), seq);
            model.endInit();
            view.updateView("name", seq);
            view.updateView("number", seq);
            view.updateView("controllevel", seq);
            view.updateView("tasktype", seq);
            view.updateView("specialtype", seq);
            view.updateView("absoluteduration", seq);
            view.updateView("pretask", seq);
            view.updateView("logical", seq);
            view.updateView("relativeduration", seq);
            view.updateView("planstarttime", seq);
            view.updateView("planendtime", seq);
            view.updateView("aimfinishtime", seq);
            view.updateView("comptimedeviation", seq);
            view.updateView("responsibleperson", seq);
            view.updateView("responsibledept", seq);
            view.updateView("cooperationperson", seq);
            view.updateView("cooperationdept", seq);
            view.updateView("name", seq);
            view.updateView("level", seq);
        }
    }

    private static void insertRowObjToEntry(List<DynamicObject> rowObjsList, String type, IFormView view, String entityId, String appId, Map<String, Integer> oldIdAndNewIndexMap) {
        IDataModel model = view.getModel();
        if (rowObjsList == null || rowObjsList.isEmpty()) {
            return;
        }
        int size = rowObjsList.size();
        for (int i = size - 1; i >= 0; --i) {
            DynamicObject insertRow = rowObjsList.get(i);
            String pid = insertRow.getString("pid");
            Integer parentRowIndex = oldIdAndNewIndexMap.get(pid);
            if (parentRowIndex == null) continue;
            int insertIndex = model.insertEntryRow("taskentity", parentRowIndex.intValue());
            oldIdAndNewIndexMap.put(insertRow.getPkValue().toString(), insertIndex);
            if (StringUtils.equals((CharSequence)UPGRADE, (CharSequence)type)) {
                insertRow.set("level", (Object)(insertRow.getInt("level") - 1));
            } else {
                insertRow.set("level", (Object)(insertRow.getInt("level") + 1));
            }
            TreeEntryUtils.setRowObj(insertRow, insertIndex, view, entityId, appId);
        }
    }

    private static boolean checkFirstNode(int index, IFormView view, IDataModel model) {
        DynamicObject preRowObj;
        DynamicObject curRowObj;
        String parentTaskId;
        int beginSeq = index;
        if (beginSeq == 0) {
            view.showMessage(ResManager.loadKDStringExt((String)"\u8be5\u8282\u70b9\u662f\u672c\u7ea7\u8282\u70b9\u7684\u7b2c\u4e00\u4e2a\u8282\u70b9\uff0c\u4e0d\u5141\u8bb8\u964d\u7ea7\u3002", (String)"TreeEntryUtils_8", (String)"pccs-placs-business", (Object[])new Object[0]));
            return true;
        }
        if (beginSeq > 0 && (parentTaskId = (curRowObj = model.getEntryRowEntity("taskentity", beginSeq)).getString("pid")).equals((preRowObj = model.getEntryRowEntity("taskentity", beginSeq - 1)).getPkValue().toString())) {
            view.showMessage(ResManager.loadKDStringExt((String)"\u8be5\u8282\u70b9\u662f\u672c\u7ea7\u8282\u70b9\u7684\u7b2c\u4e00\u4e2a\u8282\u70b9\uff0c\u4e0d\u5141\u8bb8\u964d\u7ea7\u3002", (String)"TreeEntryUtils_8", (String)"pccs-placs-business", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private static DynamicObject findLastSameParentTask(int beginSeq, String parentTaskId, IDataModel model) {
        for (int i = beginSeq - 1; i >= 0; --i) {
            String pid = model.getEntryRowEntity("taskentity", i).getString("pid");
            if (!pid.equals(parentTaskId)) continue;
            return model.getEntryRowEntity("taskentity", i);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Set<Integer> getAllChildRowIndex(int[] selectRows, DynamicObjectCollection entryEntity) {
        void var7_10;
        HashSet<Integer> childSet = new HashSet<Integer>();
        HashMap<Object, Set<Integer>> parentToChildIndex = new HashMap<Object, Set<Integer>>();
        HashSet<Object> selectEntryIds = new HashSet<Object>();
        int[] nArray = selectRows;
        int n = nArray.length;
        boolean bl = false;
        while (var7_10 < n) {
            int i = nArray[var7_10];
            Object entryId = ((DynamicObject)entryEntity.get(i)).getPkValue();
            selectEntryIds.add(entryId);
            childSet.add(i);
            ++var7_10;
        }
        int i = 0;
        for (DynamicObject dynamicObject : entryEntity) {
            Object pid = dynamicObject.get("pid");
            if (!parentToChildIndex.containsKey(pid)) {
                parentToChildIndex.put(pid, new HashSet());
            }
            ((Set)parentToChildIndex.get(pid)).add(i);
            ++i;
        }
        for (Object e : selectEntryIds) {
            TreeEntryUtils.addChildRowIndex(e, childSet, parentToChildIndex, entryEntity, selectEntryIds);
        }
        return childSet;
    }

    private static void addChildRowIndex(Object pkValue, HashSet<Integer> childSet, Map<Object, Set<Integer>> parentToChildIndex, DynamicObjectCollection entryEntity, HashSet<Object> selectEntryIds) {
        Set<Integer> childEntryIndexSet = parentToChildIndex.get(pkValue);
        if (childEntryIndexSet != null) {
            for (Integer index : childEntryIndexSet) {
                childSet.add(index);
                DynamicObject deleteRow = (DynamicObject)entryEntity.get(index.intValue());
                if (selectEntryIds.contains(deleteRow.getPkValue())) continue;
                TreeEntryUtils.addChildRowIndex(deleteRow.getPkValue(), childSet, parentToChildIndex, entryEntity, selectEntryIds);
            }
        }
    }
}

