/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.business.utils.task;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import org.apache.commons.lang3.time.DateUtils;

public class WorkHoursUtils {
    protected static final String PROJLEADER_ROLEID = "117VXH+9X6P2";
    protected IFormView view;

    public WorkHoursUtils() {
    }

    public WorkHoursUtils(IFormView view) {
        this.view = view;
    }

    public static Map<String, List<String>> getDays(Date start, Date end) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(16);
        ArrayList<String> days = new ArrayList<String>(10);
        ArrayList<String> shortdays = new ArrayList<String>(10);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        tempEnd.add(5, 1);
        while (tempStart.before(tempEnd)) {
            String format = dateFormat.format(tempStart.getTime());
            days.add(format);
            shortdays.add(DateUtil.monthDayClearZero((String)format));
            tempStart.add(6, 1);
        }
        result.put("days", days);
        result.put("shortdays", shortdays);
        return result;
    }

    public static boolean canSubmit(DynamicObject workHoursListObj, Date workhoursstarttime, String appID) {
        for (int i = 1; i <= 7; ++i) {
            boolean hasFill = false;
            String actualColumKey = "day_" + i + "_actual";
            BigDecimal actualWorkHours = workHoursListObj.getBigDecimal(actualColumKey);
            String effectiveColumKey = "day_" + i + "_effective";
            BigDecimal effectiveWorkHours = workHoursListObj.getBigDecimal(effectiveColumKey);
            if (actualWorkHours != null && actualWorkHours.compareTo(BigDecimal.ZERO) > 0) {
                hasFill = true;
            }
            if (effectiveWorkHours != null && effectiveWorkHours.compareTo(BigDecimal.ZERO) > 0) {
                hasFill = true;
            }
            if (!hasFill) continue;
            Date workdate = DateUtils.addDays((Date)DateUtil.getThisWeekSunDay((Date)workhoursstarttime), (int)(i - 1));
            workdate = DateUtil.parseShortDate((String)DateUtil.formatShortDate((Date)workdate));
            DynamicObject taskObj = workHoursListObj.getDynamicObject("task");
            ArrayList<QFilter> qlist = new ArrayList<QFilter>(10);
            qlist.add(new QFilter("workdate", "=", (Object)workdate));
            qlist.add(new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId())));
            qlist.add(new QFilter("task", "=", taskObj.getPkValue()));
            qlist.add(new QFilter("status", "=", (Object)StatusEnum.TEMPSAVE.getValue()));
            DynamicObject[] workhoursObjs = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appID, (String)"workhours"), (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,task,workdate,actualhour,effectivehour", (QFilter[])qlist.toArray(new QFilter[qlist.size()]));
            if (workhoursObjs == null || workhoursObjs.length == 0) continue;
            return true;
        }
        return false;
    }

    public static DynamicObject getWorkhoursObj(Date workdate, DynamicObject taskObj, String appID) {
        ArrayList<QFilter> qlist = new ArrayList<QFilter>(10);
        qlist.add(new QFilter("workdate", "=", (Object)workdate));
        qlist.add(new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId())));
        qlist.add(new QFilter("task", "=", taskObj.getPkValue()));
        DynamicObject[] workhoursObjs = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appID, (String)"workhours"), (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,task,workdate,actualhour,effectivehour", (QFilter[])qlist.toArray(new QFilter[qlist.size()]));
        if (workhoursObjs == null || workhoursObjs.length == 0) {
            return null;
        }
        DynamicObject workhoursObj = workhoursObjs[0];
        return workhoursObj;
    }

    public static Map<Object, DynamicObject> getSplitBills(String oriBillID, String appID) {
        QFilter oriBillFilter = new QFilter("oribillid", "=", (Object)oriBillID);
        return BusinessDataServiceHelper.loadFromCache((String)MetaDataUtil.getEntityId((String)appID, (String)"workhours_bill"), (QFilter[])new QFilter[]{oriBillFilter});
    }

    public boolean isProjMaster(String userId) {
        return this.isProjManger(userId) || this.isProjLeader(userId);
    }

    public boolean isProjManger(String userId) {
        List<Object> projManagerProjects = this.getProjManagerProjects(userId);
        return !CollectionUtils.isEmpty(projManagerProjects);
    }

    public boolean isProjLeader(String userId) {
        Object resultDatas = DispatchServiceHelper.invokeBOSService((String)"base", (String)"PermissionService", (String)"getRolesByUser", (Object[])new Object[]{Long.valueOf(userId)});
        if (resultDatas != null) {
            Set hasRoleIds = (Set)resultDatas;
            return hasRoleIds.contains(PROJLEADER_ROLEID);
        }
        return false;
    }

    public boolean isDeptManager(String userId) {
        return !CollectionUtils.isEmpty(this.getManagerDepts(userId));
    }

    public List<Object> getProjManagerProjects(String userID) {
        QFilter userFilter = new QFilter("teamentry.member.id", "=", (Object)Long.valueOf(userID));
        QFilter isProjManagerFilter = new QFilter("teamentry.ischarge", "=", (Object)"1");
        DynamicObjectCollection pmas_team = QueryServiceHelper.query((String)"pmas_team", (String)"id,project", (QFilter[])new QFilter[]{userFilter, isProjManagerFilter});
        if (CollectionUtils.isEmpty((Collection)pmas_team)) {
            return null;
        }
        return pmas_team.stream().map(object -> object.get("project")).collect(Collectors.toList());
    }

    public List<Object> getManagerDepts(String userID) {
        QFilter userFilter = new QFilter("id", "=", (Object)Long.valueOf(userID));
        QFilter isDeptManagerFilter = new QFilter("entryentity.isincharge", "=", (Object)"1");
        DynamicObjectCollection bos_user = QueryServiceHelper.query((String)"bos_user", (String)"entryentity.dpt", (QFilter[])new QFilter[]{userFilter, isDeptManagerFilter});
        if (CollectionUtils.isEmpty((Collection)bos_user)) {
            return null;
        }
        return bos_user.stream().map(object -> object.get("entryentity.dpt")).collect(Collectors.toList());
    }

    public boolean isProjManager(DynamicObject projectObj, String userId) {
        List<Object> projManagerProjects = this.getProjManagerProjects(userId);
        if (CollectionUtils.isEmpty(projManagerProjects)) {
            return false;
        }
        return projManagerProjects.contains(projectObj.getPkValue());
    }

    public boolean isDeptManager(DynamicObject departObj, String userId) {
        List<Object> managerDepts = this.getManagerDepts(userId);
        if (CollectionUtils.isEmpty(managerDepts)) {
            return false;
        }
        return managerDepts.contains(departObj.getPkValue());
    }

    public static boolean isSourceBill(DynamicObject workHoursBillObj) {
        return StringUtils.isBlank((CharSequence)workHoursBillObj.getString("oribillid"));
    }

    public static boolean isSingleSplitBill(DynamicObject workHoursBillObj) {
        return StringUtils.equals((CharSequence)workHoursBillObj.getPkValue().toString(), (CharSequence)workHoursBillObj.getString("oribillid"));
    }
}

