/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.formplugin.budget;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.org.model.EnableEnum;
import kd.bos.org.model.StatusEnum;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmas.business.helper.BudgetBillHelper;
import kd.pmgt.pmas.formplugin.base.AbstractPmasBillPlugin;
import kd.pmgt.pmbs.business.helper.FileAttachmentHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.business.helper.ProjectHelper;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.param.BudgetExportParam;
import kd.pmgt.pmbs.common.tree.Tree;
import kd.pmgt.pmbs.common.tree.TreeNode;
import kd.pmgt.pmbs.common.utils.BudgetEntryOperateHelper;
import kd.pmgt.pmbs.common.utils.CurrencyFormatUtil;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;

public class BudgetBillPlugin
extends AbstractPmasBillPlugin
implements UploadListener,
BeforeF7SelectListener {
    private static final int NOTPREVANDPRES = -1;
    private static final int ISFROMPRESTAGE = 0;
    private static final int ISFROMPREVERSION = 1;
    private static final int ISFROMPRESANDPREV = 2;
    private static final String ADDROW = "addrow";
    private static final String ADDSUBORDINATE = "addsubordinate";
    private static final String DELETEROW = "deleterow";
    private static final String ADDBUDGET = "addbudget";
    private static final String MOVEENTRYUP = "moveentryup";
    private static final String MOVEENTRYDOWN = "moveentrydown";
    private static final String IMPORTEXCEL = "importexcel";
    private static final String EXPORTEXCEL = "exportexcel";
    private static final String IMPORTBUDGETITEM = "importbudgetitem";
    private static final String IMPORTFROMTPL = "importfromtpl";
    private static final String NEW = "NEW";
    private static final String ADJUST = "ADJUST";
    private static final String UPGRADE = "upgrade";
    private static final String DOWNGRADE = "downgrade";
    private static final String SAVE = "save";
    private static final String NAME = "name";
    private static final String Number = "number";
    private static final String DELETEROWCALLBACKID = "deleterowcallbackid";
    public static final String BUDGET_CONTROL_MODE = "budgetcontrolmode";
    public static final String PROJECT_COST_CONTROL = "projectcostcontrol";
    private String[] columnKeys = null;
    private static final String ATTACHMENTPANEL = "attachmentpanel";

    private String[] getHeader() {
        return new String[]{ResManager.loadKDString((String)"\u9884\u7b97\u9879\u540d\u79f0", (String)"BudgetBillPlugin_0", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0a\u7ea7\u540d\u79f0", (String)"BudgetBillPlugin_1", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u672c\u9636\u6bb5\u91d1\u989d", (String)"BudgetBillPlugin_2", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6807\u51c6\u9884\u7b97\u9879", (String)"BudgetBillPlugin_3", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5907\u6ce8", (String)"BudgetBillPlugin_4", (String)"pmgt-pmas-formplugin", (Object[])new Object[0])};
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject[] pros;
        super.afterCreateNewData(e);
        Object adjustId = this.getView().getFormShowParameter().getCustomParam("adjustId");
        Object projectId = this.getView().getFormShowParameter().getCustomParam("projectId");
        this.getModel().setValue("project", projectId);
        DynamicObject projectObj = (DynamicObject)this.getModel().getValue("project");
        String projectName = "";
        if (projectObj != null) {
            projectName = ((OrmLocaleValue)projectObj.get(NAME)).getLocaleValue();
            this.getModel().setValue("group", projectObj.get("group"));
        }
        Object sourceType = this.getModel().getValue("sourcetype");
        String formName = BudgetSourceTypeEnum.OUT.getValue().equals(sourceType) ? ResManager.loadKDString((String)"\u652f\u51fa\u9884\u7b97", (String)"BudgetBillPlugin_5", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]) : (BudgetSourceTypeEnum.IN.getValue().equals(sourceType) ? ResManager.loadKDString((String)"\u6536\u5165\u9884\u7b97", (String)"BudgetBillPlugin_6", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u603b\u4f53\u9884\u7b97", (String)"BudgetBillPlugin_7", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
        if (adjustId == null) {
            Date curBillDate;
            this.getModel().setValue("type", (Object)NEW);
            BigDecimal version = ((BigDecimal)this.getModel().getValue("version")).setScale(1);
            this.getModel().setValue(NAME, (Object)String.format("%s-%s%s", projectName, formName, version.toPlainString()));
            if (!BudgetSourceTypeEnum.TOTAL.getValue().equals(sourceType) && (curBillDate = (Date)this.getModel().getValue("year")) != null) {
                LocalDate localDate = curBillDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    this.getModel().setValue("year", (Object)sdf.parse(localDate.getYear() + "-01-01"));
                }
                catch (ParseException parseException) {
                    this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"BudgetBillPlugin_8", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                }
            }
        } else {
            this.getModel().setValue("id", (Object)ORM.create().genLongId((IDataEntityType)this.getModel().getDataEntityType()));
            this.getModel().setValue("type", (Object)ADJUST);
            DynamicObject adjust = BudgetSourceTypeEnum.OUT.getValue().equals(sourceType) ? BusinessDataServiceHelper.loadSingle((Object)adjustId, (String)"pmas_outbudget") : (BudgetSourceTypeEnum.IN.getValue().equals(sourceType) ? BusinessDataServiceHelper.loadSingle((Object)adjustId, (String)"pmas_inbudget") : BusinessDataServiceHelper.loadSingle((Object)adjustId, (String)"pmas_totalbudget"));
            BigDecimal newversion = adjust.getBigDecimal("version").add(BigDecimal.ONE).setScale(1);
            BigDecimal amount = adjust.getBigDecimal("totalamount");
            BigDecimal presamount = adjust.getBigDecimal("presamount");
            this.getModel().setValue("prevamount", (Object)amount);
            this.getModel().setValue("presamount", (Object)presamount);
            this.getModel().setValue("totalamount", (Object)amount);
            this.getModel().setValue("schangeamount", (Object)amount.subtract(presamount));
            this.getModel().setValue("budgetstage", adjust.get("budgetstage"));
            this.getModel().setValue("org", adjust.get("org"));
            this.getModel().setValue("version", (Object)newversion);
            this.getModel().setValue(NAME, (Object)String.format("%s-%s%s", projectName, formName, newversion.toPlainString()));
            if (!BudgetSourceTypeEnum.TOTAL.getValue().equals(sourceType)) {
                Date budgetYear = adjust.getDate("year");
                this.getModel().setValue("year", (Object)adjust.getDate("year"));
                if (projectObj != null) {
                    Map proInvestBudgetAmtMap = new BudgetBillHelper().getProInvestBudgetAmt(budgetYear, Long.valueOf(Long.parseLong(projectObj.getPkValue().toString())), NEW);
                    this.getModel().setValue("totalyearamt", proInvestBudgetAmtMap.get("yearBudgetAppAmt"));
                }
            } else {
                if (projectObj != null) {
                    Map proInvestBudgetAmtMap = new BudgetBillHelper().getProInvestBudgetAmt(new Date(), Long.valueOf(Long.parseLong(projectObj.getPkValue().toString())), NEW);
                    this.getModel().setValue("proapprovalamt", proInvestBudgetAmtMap.get("proBudgetAppAmt"));
                }
                this.getModel().setValue("projectapplydate", (Object)adjust.getDate("projectapplydate"));
                Date planBeginDate = adjust.getDate("planbegindate");
                Date planEndDate = adjust.getDate("planenddate");
                if (projectObj != null) {
                    QFilter qFilter = new QFilter("pro", "=", (Object)Long.parseLong(projectObj.getPkValue().toString()));
                    qFilter.and("billstatus", "=", (Object)kd.pmgt.pmbs.common.enums.StatusEnum.CHECKED.getValue());
                    DynamicObject[] proAdjustBills = BusinessDataServiceHelper.load((String)"pmas_pro_approvaladjust", (String)String.join((CharSequence)",", "planbegindate", "planenddate"), (QFilter[])new QFilter[]{qFilter}, (String)" version desc");
                    if (proAdjustBills.length > 0) {
                        planBeginDate = proAdjustBills[0].getDate("planbegindate");
                        planEndDate = proAdjustBills[0].getDate("planenddate");
                    }
                }
                this.getModel().setValue("planbegindate", (Object)planBeginDate);
                this.getModel().setValue("planenddate", (Object)planEndDate);
            }
            DynamicObjectCollection entries = adjust.getDynamicObjectCollection("treeentryentity");
            this.getModel().deleteEntryData("treeentryentity");
            boolean isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)Long.parseLong(projectId.toString()));
            if (isNew && !BudgetSourceTypeEnum.IN.getValue().equals(sourceType)) {
                this.fillCurBudgetEntry(Long.parseLong(projectId.toString()), entries, true);
            } else {
                BudgetEntryOperateHelper.fillTreeEntryByEntryEntity((DynamicObjectCollection)entries, (boolean)false, (boolean)true, (IFormView)this.getView(), (String)"treeentryentity", (String)"budgetitemname", (String)"budgetitemnum", (String)"descriptionentry", (String)"budgetitem");
            }
            String sourceBillFormId = adjust.getDynamicObjectType().toString();
            Object sourceBillId = adjust.getPkValue();
            String destinationFormId = this.getView().getFormShowParameter().getFormId();
            Object destinationBillId = this.getModel().getDataEntity().getPkValue();
            FileAttachmentHelper.copyFileFromAToB((String)sourceBillFormId, (Object)sourceBillId, (String)ATTACHMENTPANEL, (String)destinationFormId, (Object)destinationBillId, (String)ATTACHMENTPANEL);
        }
        this.setAmountEnable();
        if (projectObj != null && (pros = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"id,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", projectObj.getPkValue())})) != null && pros.length > 0) {
            this.getModel().setValue("currency", pros[0].get("currencyfield"));
        }
    }

    private void setAmountEnable() {
        BudgetEntryOperateHelper.setAmountColumnEnable((String)"treeentryentity", (String)"budgetamount", (IFormView)this.getView());
        BudgetEntryOperateHelper.setTotalAmountEnable((IFormView)this.getView(), (String)"treeentryentity", (String)"totalamount");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("treeentryentity");
        grid.setCollapse(false);
        this.getModel().updateCache();
    }

    public void afterBindData(EventObject e) {
        Object value;
        super.afterBindData(e);
        Object sourceType = this.getModel().getValue("sourcetype");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (!OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            if (OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus()) && project != null) {
                this.getPageCache().put("defaultProjectid", project.getPkValue().toString());
            }
            BudgetEntryOperateHelper.setAmountColumnEnable((String)"treeentryentity", (String)"budgetamount", (IFormView)this.getView());
            BudgetEntryOperateHelper.setTotalAmountEnable((IFormView)this.getView(), (String)"treeentryentity", (String)"totalamount");
        }
        if (ADJUST.equals((value = this.getModel().getValue("type")).toString())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"budgetstage", "project", "vchangeamount", "prevamount", "viamount", "vichangeamount"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"sichangeamount", "fromtpl", IMPORTEXCEL});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"vchangeamount", "prevamount", "sichangeamount", "viamount", "vichangeamount"});
        }
        if (project != null) {
            String budgetType;
            DynamicObject budgetStage = (DynamicObject)this.getModel().getValue("budgetstage");
            DynamicObject preBudgetStage = this.getPreBudgetStage(project, budgetStage);
            if (preBudgetStage == null) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"presamount", "schangeamount", "siamount"});
            } else {
                this.setPreBudgetName(preBudgetStage, null);
                this.getView().setVisible(Boolean.FALSE, new String[]{"fromtpl", IMPORTEXCEL});
                this.getView().setVisible(Boolean.TRUE, new String[]{"sichangeamount"});
            }
            String string = budgetType = StringUtils.equals((CharSequence)ADJUST, (CharSequence)((String)this.getModel().getValue("type"))) ? ADJUST : NEW;
            if (!BudgetSourceTypeEnum.TOTAL.getValue().equals(sourceType)) {
                Object year = this.getModel().getValue("year");
                if (year != null) {
                    Map proInvestBudgetAmtMap = new BudgetBillHelper().getProInvestBudgetAmt((Date)year, Long.valueOf(Long.parseLong(project.getPkValue().toString())), budgetType);
                    BigDecimal yearBudgetAppAmt = (BigDecimal)proInvestBudgetAmtMap.get("yearBudgetAppAmt");
                    if (StringUtils.equals((CharSequence)ADJUST, (CharSequence)budgetType)) {
                        BigDecimal totalYearAmt = (BigDecimal)this.getModel().getValue("totalyearamt");
                        if (yearBudgetAppAmt.compareTo(BigDecimal.ZERO) > 0 && yearBudgetAppAmt.compareTo(totalYearAmt) != 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u5e74\u5ea6\u7acb\u9879\u91d1\u989d\u5df2\u53d1\u751f\u8c03\u6574\uff0c\u7cfb\u7edf\u5df2\u81ea\u52a8\u66f4\u65b0\u3002", (String)"BudgetBillPlugin_9", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                        }
                    }
                    if (yearBudgetAppAmt.compareTo(BigDecimal.ZERO) > 0) {
                        this.getModel().setValue("totalyearamt", (Object)yearBudgetAppAmt);
                    }
                    yearBudgetAppAmt = (BigDecimal)this.getModel().getValue("totalyearamt");
                    this.getView().setEnable(Boolean.valueOf(yearBudgetAppAmt.compareTo(BigDecimal.ZERO) == 0), new String[]{"totalyearamt"});
                }
            } else {
                Map proInvestBudgetAmtMap = new BudgetBillHelper().getProInvestBudgetAmt(new Date(), Long.valueOf(Long.parseLong(project.getPkValue().toString())), budgetType);
                BigDecimal proBudgetAppAmt = (BigDecimal)proInvestBudgetAmtMap.get("proBudgetAppAmt");
                if (StringUtils.equals((CharSequence)ADJUST, (CharSequence)budgetType)) {
                    BigDecimal proApprovalAmt = (BigDecimal)this.getModel().getValue("proapprovalamt");
                    if (proBudgetAppAmt.compareTo(BigDecimal.ZERO) > 0 && proBudgetAppAmt.compareTo(proApprovalAmt) != 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u7acb\u9879\u91d1\u989d\u5df2\u53d1\u751f\u8c03\u6574\uff0c\u7cfb\u7edf\u5df2\u81ea\u52a8\u66f4\u65b0\u3002", (String)"BudgetBillPlugin_10", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    }
                    this.getView().setVisible(Boolean.FALSE, new String[]{"sichangeamount", "schangeamount"});
                }
                if (proBudgetAppAmt.compareTo(BigDecimal.ZERO) > 0) {
                    this.getModel().setValue("proapprovalamt", (Object)proBudgetAppAmt);
                }
                proBudgetAppAmt = (BigDecimal)this.getModel().getValue("proapprovalamt");
                this.getView().setEnable(Boolean.valueOf(proBudgetAppAmt.compareTo(BigDecimal.ZERO) == 0), new String[]{"proapprovalamt"});
            }
        }
        this.setBudgetEntrySumRow();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        int rowIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        DynamicObject budgetStage = (DynamicObject)this.getModel().getValue("budgetstage");
        Object sourceType = this.getModel().getValue("sourcetype");
        switch (name) {
            case "budgetitem": {
                String budgetItemNum;
                DynamicObject budgetItem = (DynamicObject)this.getModel().getValue("budgetitem", rowIndex);
                if (budgetItem == null) break;
                String budgetItemName = (String)this.getModel().getValue("budgetitemname", rowIndex);
                if (StringUtils.isEmpty((CharSequence)budgetItemName)) {
                    this.getModel().setValue("budgetitemname", (Object)budgetItem.getString(NAME), rowIndex);
                }
                if (!StringUtils.isEmpty((CharSequence)(budgetItemNum = (String)this.getModel().getValue("budgetitemnum", rowIndex)))) break;
                this.getModel().setValue("budgetitemnum", (Object)budgetItem.getString(Number), rowIndex);
                break;
            }
            case "budgetitemname": {
                boolean isRepeat = BudgetEntryOperateHelper.checkNameIsRepeat((int)rowIndex, (String)"treeentryentity", (String)"budgetitemname", (IFormView)this.getView());
                if (!isRepeat) break;
                this.getModel().setValue("budgetitemname", changeData.getOldValue(), rowIndex);
                break;
            }
            case "itemtotalamount": {
                BudgetEntryOperateHelper.setAmountColumnValue((IFormView)this.getView(), (String)"treeentryentity", (String)"itemtotalamount");
                this.setBudgetEntrySumRow();
                break;
            }
            case "budgetamount": {
                BigDecimal amount = (BigDecimal)newValue;
                BigDecimal totalAmount = BudgetEntryOperateHelper.setAmountColumnValue((IFormView)this.getView(), (String)"treeentryentity", (String)"budgetamount");
                BudgetEntryOperateHelper.setTotalAmount((BigDecimal)totalAmount, (IFormView)this.getView(), (String)"totalamount");
                BigDecimal siamount = (BigDecimal)this.getModel().getValue("siamount", rowIndex);
                BigDecimal viamount = (BigDecimal)this.getModel().getValue("viamount", rowIndex);
                int isFromPre = this.isCurrentRowFromPre(rowIndex);
                Object value = this.getModel().getValue("type");
                if (NEW.equals(value.toString())) {
                    if (isFromPre == -1) {
                        if (null == this.getModel().getValue("project")) break;
                        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
                        DynamicObject[] existedProBudgets = this.isExistBudgetCurProject(project);
                        if (existedProBudgets != null && existedProBudgets.length > 0) {
                            this.getModel().setValue("sichangeamount", (Object)amount.subtract(siamount), rowIndex);
                            this.getModel().beginInit();
                            BudgetEntryOperateHelper.setAmountColumnValue((IFormView)this.getView(), (String)"treeentryentity", (String)"sichangeamount");
                            this.getModel().endInit();
                        }
                    }
                    if (isFromPre == 0 || isFromPre == 2) {
                        this.getModel().setValue("sichangeamount", (Object)amount.subtract(siamount), rowIndex);
                        this.getModel().beginInit();
                        BudgetEntryOperateHelper.setAmountColumnValue((IFormView)this.getView(), (String)"treeentryentity", (String)"sichangeamount");
                        this.getModel().endInit();
                    }
                }
                if (ADJUST.equals(value.toString())) {
                    this.getModel().setValue("vichangeamount", (Object)amount.subtract(viamount), rowIndex);
                    this.getModel().beginInit();
                    BudgetEntryOperateHelper.setAmountColumnValue((IFormView)this.getView(), (String)"treeentryentity", (String)"vichangeamount");
                    this.getModel().endInit();
                    this.getModel().setValue("sichangeamount", (Object)amount.subtract(siamount), rowIndex);
                    this.getModel().beginInit();
                    BudgetEntryOperateHelper.setAmountColumnValue((IFormView)this.getView(), (String)"treeentryentity", (String)"sichangeamount");
                    this.getModel().endInit();
                }
                this.setBudgetEntrySumRow();
                break;
            }
            case "totalamount": {
                BigDecimal total = (BigDecimal)newValue;
                BigDecimal prev = (BigDecimal)this.getModel().getValue("prevamount");
                BigDecimal pres = (BigDecimal)this.getModel().getValue("presamount");
                this.getModel().setValue("schangeamount", (Object)total.subtract(pres));
                this.getModel().setValue("vchangeamount", (Object)total.subtract(prev));
                break;
            }
            case "project": {
                int rowCount = this.getModel().getEntryRowCount("treeentryentity");
                if (rowCount > 0) {
                    DynamicObject pro;
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u9879\u76ee\u5c06\u6e05\u7a7a\u6240\u6709\u660e\u7ec6\u6570\u636e\uff0c\u4e14\u65e0\u6cd5\u6062\u590d\uff0c\u662f\u5426\u786e\u5b9a\u5207\u6362\uff1f", (String)"BudgetBillPlugin_11", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("project", (IFormPlugin)this));
                    String newProject = null;
                    String oldProject = null;
                    if (newValue != null) {
                        pro = (DynamicObject)newValue;
                        newProject = pro.getPkValue().toString();
                    }
                    if (oldValue != null) {
                        pro = (DynamicObject)oldValue;
                        oldProject = pro.getPkValue().toString();
                    }
                    this.getPageCache().put("newproject", newProject);
                    this.getPageCache().put("oldproject", oldProject);
                    return;
                }
                this.changeProject(newValue);
                break;
            }
            case "budgetstage": {
                int entryRowCount = this.getModel().getEntryRowCount("treeentryentity");
                if (entryRowCount > 0) {
                    DynamicObject stage;
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u9884\u7b97\u9636\u6bb5\u5c06\u6e05\u7a7a\u9884\u7b97\u660e\u7ec6\u4e2d\u73b0\u6709\u6570\u636e\u4e14\u4e0d\u53ef\u6062\u590d\uff0c\u662f\u5426\u786e\u5b9a\u5207\u6362\uff1f", (String)"BudgetBillPlugin_12", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("budgetstage", (IFormPlugin)this));
                    String oldStage = null;
                    String newStage = null;
                    if (oldValue != null) {
                        stage = (DynamicObject)oldValue;
                        oldStage = stage.getPkValue().toString();
                    }
                    if (newValue != null) {
                        stage = (DynamicObject)newValue;
                        newStage = stage.getPkValue().toString();
                    }
                    this.getPageCache().put("oldstage", oldStage);
                    this.getPageCache().put("newstage", newStage);
                    return;
                }
                this.changeBudgetStage(newValue);
                break;
            }
            case "year": {
                if (newValue == null) break;
                Date budgetYear = (Date)changeData.getNewValue();
                if (budgetYear == null) {
                    return;
                }
                DynamicObject projectObj = (DynamicObject)this.getModel().getValue("project");
                if (projectObj == null) break;
                if (this.gainIsValidProBudget(projectObj, budgetYear, budgetStage) != null) {
                    this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u5f53\u524d\u9879\u76ee\u548c\u9879\u76ee\u9636\u6bb5\u4e0b\uff0c\u5df2\u5b58\u5728\u8be5\u5e74\u5ea6\u7684\u9884\u7b97\u7f16\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5e74\u5ea6\u3002", (String)"BudgetBillPlugin_13", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("year", null);
                    return;
                }
                String errorMsg = this.checkHisBudget(projectObj, budgetYear, "changeYear");
                if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                    this.getView().showErrorNotification(errorMsg);
                    this.getModel().setValue("year", null);
                }
                Map proInvestBudgetAmtMap = new BudgetBillHelper().getProInvestBudgetAmt(budgetYear, Long.valueOf(Long.parseLong(projectObj.getPkValue().toString())), NEW);
                this.getModel().setValue("totalyearamt", proInvestBudgetAmtMap.get("yearBudgetAppAmt"));
                this.getView().setEnable(Boolean.valueOf(((BigDecimal)proInvestBudgetAmtMap.get("yearBudgetAppAmt")).compareTo(BigDecimal.ZERO) == 0), new String[]{"totalyearamt"});
                if (budgetStage == null) {
                    return;
                }
                this.checkProIsFirstBudget(budgetStage);
                this.setAmountEnable();
                break;
            }
            case "planbegindate": {
                Date planEndDate;
                Date planBeginDate;
                if (!StringUtils.equals((CharSequence)"TOTAL", (CharSequence)sourceType.toString())) break;
                Object planEndDateObj = this.getModel().getValue("planenddate");
                if (newValue == null || planEndDateObj == null || !(planBeginDate = (Date)newValue).after(planEndDate = (Date)planEndDateObj)) break;
                this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u8ba1\u5212\u5b8c\u6210\u65e5\u671f\u4e0d\u5f97\u5c0f\u4e8e\u8ba1\u5212\u5f00\u59cb\u65e5\u671f", (String)"BudgetBillPlugin_14", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("planbegindate", null);
                break;
            }
            case "planenddate": {
                Date planEndDate;
                Date planBeginDate;
                if (!StringUtils.equals((CharSequence)"TOTAL", (CharSequence)sourceType.toString())) break;
                Object planBeginDateObj = this.getModel().getValue("planbegindate");
                if (newValue == null || planBeginDateObj == null || !(planBeginDate = (Date)planBeginDateObj).after(planEndDate = (Date)newValue)) break;
                this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u8ba1\u5212\u5b8c\u6210\u65e5\u671f\u4e0d\u5f97\u5c0f\u4e8e\u8ba1\u5212\u5f00\u59cb\u65e5\u671f", (String)"BudgetBillPlugin_14", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("planenddate", null);
                break;
            }
        }
    }

    private void changeBudgetStage(Object newValue) {
        if (newValue != null) {
            DynamicObject budgetStage = (DynamicObject)newValue;
            this.checkProIsFirstBudget(budgetStage);
        } else {
            this.getModel().setValue("prevamount", (Object)BigDecimal.ZERO);
            this.getModel().setValue("presamount", (Object)BigDecimal.ZERO);
            this.getModel().setValue("totalamount", (Object)BigDecimal.ZERO);
            this.getModel().deleteEntryData("treeentryentity");
            this.setPreBudgetName(null, null);
        }
        this.setAmountEnable();
    }

    private void changeProject(Object newValue) {
        Object sourceType = this.getModel().getValue("sourcetype");
        if (newValue != null) {
            DynamicObject projectObj = (DynamicObject)newValue;
            if (!BudgetSourceTypeEnum.TOTAL.getValue().equals(sourceType)) {
                String errorMsg;
                Date budgetYear = (Date)this.getModel().getValue("year");
                if (budgetYear != null && StringUtils.isNotBlank((CharSequence)(errorMsg = this.checkHisBudget(projectObj, budgetYear, "changeProject")))) {
                    this.getView().showErrorNotification(errorMsg);
                    this.getModel().setValue("project", null);
                }
                if (budgetYear != null) {
                    Map proInvestBudgetAmtMap = new BudgetBillHelper().getProInvestBudgetAmt(budgetYear, Long.valueOf(Long.parseLong(projectObj.getPkValue().toString())), NEW);
                    this.getModel().setValue("totalyearamt", proInvestBudgetAmtMap.get("yearBudgetAppAmt"));
                    this.getView().setEnable(Boolean.valueOf(((BigDecimal)proInvestBudgetAmtMap.get("yearBudgetAppAmt")).compareTo(BigDecimal.ZERO) == 0), new String[]{"totalyearamt"});
                }
            } else {
                Map proInvestBudgetAmtMap = new BudgetBillHelper().getProInvestBudgetAmt(new Date(), Long.valueOf(Long.parseLong(projectObj.getPkValue().toString())), NEW);
                this.getModel().setValue("proapprovalamt", proInvestBudgetAmtMap.get("proBudgetAppAmt"));
                this.getView().setEnable(Boolean.valueOf(((BigDecimal)proInvestBudgetAmtMap.get("proBudgetAppAmt")).compareTo(BigDecimal.ZERO) == 0), new String[]{"proapprovalamt"});
            }
            this.isExistNoCheckedBudgets(projectObj, this.getView().getFormShowParameter().getStatus());
            this.setDefaultBudgetStage(projectObj);
            DynamicObject[] pros = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"id,kind,currencyfield,planbegindate,planenddate,projectapplydate", (QFilter[])new QFilter[]{new QFilter("pro", "=", projectObj.getPkValue())});
            if (pros != null && pros.length > 0) {
                this.getModel().setValue("currency", pros[0].get("currencyfield"));
                this.getModel().setValue("group", pros[0].get("kind"));
                this.getModel().setValue("projectapplydate", pros[0].get("projectapplydate"));
                Object planBeginDate = pros[0].get("planbegindate");
                Object planEndDate = pros[0].get("planenddate");
                QFilter qFilter = new QFilter("pro", "=", (Object)Long.parseLong(projectObj.getPkValue().toString()));
                qFilter.and("billstatus", "=", (Object)kd.pmgt.pmbs.common.enums.StatusEnum.CHECKED.getValue());
                DynamicObject[] proAdjustBills = BusinessDataServiceHelper.load((String)"pmas_pro_approvaladjust", (String)String.join((CharSequence)",", "planbegindate", "planenddate"), (QFilter[])new QFilter[]{qFilter}, (String)" version desc");
                if (proAdjustBills.length > 0) {
                    planBeginDate = proAdjustBills[0].get("planbegindate");
                    planEndDate = proAdjustBills[0].get("planenddate");
                }
                this.getModel().setValue("planbegindate", planBeginDate);
                this.getModel().setValue("planenddate", planEndDate);
            }
        } else {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            this.getModel().setValue("currency", (Object)CurrencyHelper.getCurrency((Long)((Long)org.getPkValue())));
            this.getModel().beginInit();
            this.getModel().setValue("budgetstage", null);
            this.getModel().endInit();
            this.getView().updateView("budgetstage");
            this.getModel().setValue("group", null);
            this.getModel().deleteEntryData("treeentryentity");
            this.getModel().setValue("totalyearamt", (Object)BigDecimal.ZERO);
            if (BudgetSourceTypeEnum.TOTAL.getValue().equals(sourceType)) {
                this.getModel().setValue("proapprovalamt", (Object)BigDecimal.ZERO);
            }
            this.getModel().setValue("prevamount", (Object)BigDecimal.ZERO);
            this.getModel().setValue("presamount", (Object)BigDecimal.ZERO);
            this.getModel().setValue("totalamount", (Object)BigDecimal.ZERO);
            this.getModel().setValue("projectapplydate", null);
            this.getModel().setValue("planbegindate", null);
            this.getModel().setValue("planenddate", null);
        }
        this.setAmountEnable();
    }

    private String checkHisBudget(DynamicObject projectObj, Date budgetYear, String changeProperty) {
        DynamicObject existBudget;
        Date validDate;
        String errorMsg = null;
        DynamicObject[] existBudgets = this.isExistBudgetCurProject(projectObj);
        if (existBudgets.length > 0 && (validDate = (existBudget = existBudgets[0]).getDate("year")) != null) {
            int selectYear;
            LocalDate localDate = validDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            LocalDate budgeDate = budgetYear.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            int validYear = localDate.getYear();
            if (validYear > (selectYear = budgeDate.getYear())) {
                errorMsg = "changeYear".equals(changeProperty) ? String.format(ResManager.loadKDStringExt((String)"\u5f53\u524d\u9879\u76ee\u5df2\u5b58\u5728%1$s\u5e74\u7684\u9884\u7b97\u7f16\u5236\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u7f16\u5236\u5c0f\u4e8e\u8be5\u5e74\u5ea6\u7684\u9884\u7b97\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u9879\u76ee\u6216\u5e74\u5ea6\u3002", (String)"BudgetBillPlugin_15", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), localDate.getYear()) : String.format(ResManager.loadKDStringExt((String)"\u5f53\u524d\u9879\u76ee\u5df2\u5b58\u5728%1$s\u5e74\u7684\u9884\u7b97\u7f16\u5236\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u7f16\u5236\u5c0f\u4e8e\u8be5\u5e74\u5ea6\u7684\u9884\u7b97\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u9879\u76ee\u6216\u5e74\u5ea6\u3002", (String)"BudgetBillPlugin_16", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), localDate.getYear());
            }
        }
        return errorMsg;
    }

    private DynamicObject gainIsValidProBudget(DynamicObject projectObj, Date budgetYear, DynamicObject budgetStage) {
        DynamicObject budget = null;
        if (budgetYear != null && budgetStage != null) {
            QFilter filter = new QFilter("project", "=", (Object)Long.parseLong(projectObj.getPkValue().toString()));
            LocalDate localDate = budgetYear.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            filter.and("YEAR(year)", "=", (Object)localDate.getYear());
            filter.and("budgetstage", "=", (Object)Long.parseLong(budgetStage.getPkValue().toString()));
            filter.and("isvalid", "=", (Object)true);
            filter.and("sourcetype", "=", (Object)this.getBudgetSourceType());
            DynamicObject[] budgetBills = BusinessDataServiceHelper.load((String)"pmas_budget", (String)"id", (QFilter[])new QFilter[]{filter});
            if (budgetBills.length > 0) {
                budget = BusinessDataServiceHelper.loadSingle((Object)budgetBills[0].getPkValue(), (String)"pmas_budget");
            }
        }
        return budget;
    }

    private void isExistNoCheckedBudgets(DynamicObject projectObj, OperationStatus operationStatus) {
        QFilter statusFilter;
        QFilter typeFilter;
        QFilter proFilter = new QFilter("project", "=", projectObj.getPkValue());
        DynamicObject[] noCheckedProBudgets = BusinessDataServiceHelper.load((String)"pmas_budget", (String)"id", (QFilter[])new QFilter[]{proFilter, typeFilter = new QFilter("sourcetype", "=", (Object)this.getBudgetSourceType()), statusFilter = new QFilter("billstatus", "!=", (Object)kd.pmgt.pmbs.common.enums.StatusEnum.CHECKED.getValue())});
        if (noCheckedProBudgets != null && noCheckedProBudgets.length > 0) {
            if (OperationStatus.EDIT.equals((Object)operationStatus)) {
                String defaultProjectid = this.getPageCache().get("defaultProjectid");
                if (StringUtils.equals((CharSequence)defaultProjectid, (CharSequence)projectObj.getString("id"))) {
                    return;
                }
            } else {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%1$s\u201d\u5b58\u5728\u672a\u5ba1\u6838\u7684\u9884\u7b97\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BudgetBillPlugin_17", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), projectObj.getString(NAME)));
            }
        }
    }

    private void checkProIsFirstBudget(DynamicObject budgetStage) {
        Object value = this.getModel().getValue("type");
        if (ADJUST.equals(value.toString())) {
            return;
        }
        DynamicObject pro = (DynamicObject)this.getModel().getValue("project");
        DynamicObject[] existedProBudgets = this.isExistBudgetCurProject(pro);
        if (existedProBudgets != null && existedProBudgets.length > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fromtpl", IMPORTEXCEL});
            DynamicObject preBudget = BusinessDataServiceHelper.loadSingle((Object)existedProBudgets[0].getPkValue(), (String)"pmas_budget");
            DynamicObject preBudgetStage = preBudget.getDynamicObject("budgetstage");
            if (preBudgetStage != null) {
                long preBudgetStageNo = preBudgetStage.getLong("seqno");
                long budgetStageBo = budgetStage.getLong("seqno");
                if (BudgetSourceTypeEnum.TOTAL.getValue().equals(this.getBudgetSourceType())) {
                    if (budgetStageBo <= preBudgetStageNo) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u9884\u7b97\u9636\u6bb5\u5e94\u5927\u4e8e\u53c2\u7167\u9636\u6bb5\u201c%1$s\u201d\u3002", (String)"BudgetBillPlugin_18", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), preBudgetStage.getString(NAME)));
                    }
                } else {
                    int validYear;
                    int selectYear;
                    Date budgetYear = (Date)this.getModel().getValue("year");
                    Date validDate = preBudget.getDate("year");
                    if (validDate != null && budgetYear != null && ((selectYear = budgetYear.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear()) == (validYear = validDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear()) ? budgetStageBo <= preBudgetStageNo : selectYear > validYear && budgetStageBo < preBudgetStageNo)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u9884\u7b97\u9636\u6bb5\u5e94\u5927\u4e8e\u53c2\u7167\u9636\u6bb5\u201c%1$s\u201d\u3002", (String)"BudgetBillPlugin_18", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), preBudgetStage.getString(NAME)));
                    }
                }
                this.setBudgetEntryByPreStage(preBudget);
                if (BudgetSourceTypeEnum.TOTAL.getValue().equals(this.getBudgetSourceType())) {
                    this.setPreBudgetName(preBudgetStage, null);
                } else {
                    this.setPreBudgetName(preBudgetStage, preBudget.getDate("year"));
                }
            }
        } else {
            this.setFirstBudgetEntry(pro);
        }
    }

    private DynamicObject[] isExistBudgetCurProject(DynamicObject project) {
        QFilter proFilter = new QFilter("project", "=", project.getPkValue());
        QFilter typeFilter = new QFilter("sourcetype", "=", (Object)this.getBudgetSourceType());
        QFilter validFilter = new QFilter("isvalid", "=", (Object)"1");
        if (BudgetSourceTypeEnum.TOTAL.getValue().equals(this.getBudgetSourceType())) {
            return BusinessDataServiceHelper.load((String)"pmas_budget", (String)"id", (QFilter[])new QFilter[]{proFilter, typeFilter, validFilter}, (String)"budgetstage.seqno desc", (int)1);
        }
        return BusinessDataServiceHelper.load((String)"pmas_budget", (String)"id,year", (QFilter[])new QFilter[]{proFilter, typeFilter, validFilter}, (String)"budgetstage.seqno desc,year desc", (int)1);
    }

    private void setFirstBudgetEntry(DynamicObject project) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"presamount", "schangeamount", "siamount"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"sichangeamount"});
        this.getModel().deleteEntryData("treeentryentity");
        if (project == null) {
            return;
        }
        boolean isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)Long.parseLong(project.getPkValue().toString()));
        if (isNew) {
            this.fillCurBudgetEntry(Long.parseLong(project.getPkValue().toString()), null, false);
            BudgetEntryOperateHelper.setAmountColumnEnable((String)"treeentryentity", (String)"budgetamount", (IFormView)this.getView());
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("treeentryentity");
            BigDecimal totalAmt = BigDecimal.ZERO;
            if (!entryEntity.isEmpty()) {
                totalAmt = entryEntity.stream().filter(o -> o.getLong("pid") == 0L).map(o -> o.getBigDecimal("budgetamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            }
            BudgetEntryOperateHelper.setTotalAmount((BigDecimal)totalAmt, (IFormView)this.getView(), (String)"totalamount");
            BudgetEntryOperateHelper.setTotalAmountEnable((IFormView)this.getView(), (String)"treeentryentity", (String)"totalamount");
            this.setBudgetEntrySumRow();
        } else if (BudgetSourceTypeEnum.OUT.getValue().equals(this.getBudgetSourceType())) {
            this.fillEntryByTotalBudget(project);
        } else if (BudgetSourceTypeEnum.TOTAL.getValue().equals(this.getBudgetSourceType())) {
            this.fillEntryByYearBudget(project);
        } else {
            this.fillEntryByProTemplate(project);
        }
    }

    private void fillEntryByYearBudget(DynamicObject projectObj) {
        if (projectObj != null) {
            QFilter qFilter = new QFilter("project", "=", (Object)Long.parseLong(projectObj.getPkValue().toString()));
            qFilter.and("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
            QFilter statusQFilter = new QFilter("isvalid", "=", (Object)DefaultEnum.YES.getValue());
            DynamicObject[] yearBudgets = BusinessDataServiceHelper.load((String)"pmas_outbudget", (String)"id", (QFilter[])new QFilter[]{qFilter, statusQFilter}, (String)"budgetstage.seqno desc,year desc", (int)1);
            if (yearBudgets.length != 0) {
                DynamicObject yearBudget = BusinessDataServiceHelper.loadSingle((Object)yearBudgets[0].getPkValue(), (String)"pmas_outbudget");
                DynamicObjectCollection budgetEntry = yearBudget.getDynamicObjectCollection("treeentryentity");
                BudgetEntryOperateHelper.fillTreeEntryByEntryEntity((DynamicObjectCollection)budgetEntry, (boolean)false, (boolean)false, (IFormView)this.getView(), (String)"treeentryentity", (String)"budgetitemname", (String)"budgetitemnum", (String)"descriptionentry", (String)"budgetitem");
                DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity("treeentryentity");
                if (entryEntity.size() > 0) {
                    for (DynamicObject entry : entryEntity) {
                        entry.set("ispres", (Object)true);
                        entry.set("isprev", (Object)true);
                    }
                }
                this.getModel().updateEntryCache(entryEntity);
                this.getView().updateView("treeentryentity");
                BudgetEntryOperateHelper.setAmountColumnEnable((String)"treeentryentity", (String)"budgetamount", (IFormView)this.getView());
                BudgetEntryOperateHelper.setTotalAmount((BigDecimal)yearBudget.getBigDecimal("totalamount"), (IFormView)this.getView(), (String)"totalamount");
                BudgetEntryOperateHelper.setTotalAmountEnable((IFormView)this.getView(), (String)"treeentryentity", (String)"totalamount");
                this.setBudgetEntrySumRow();
            } else {
                this.fillEntryByProTemplate(projectObj);
            }
        }
    }

    private void fillEntryByTotalBudget(DynamicObject projectObj) {
        if (projectObj != null) {
            QFilter qFilter = new QFilter("project", "=", (Object)Long.parseLong(projectObj.getPkValue().toString()));
            qFilter.and("sourcetype", "=", (Object)BudgetSourceTypeEnum.TOTAL.getValue());
            QFilter statusQFilter = new QFilter("isvalid", "=", (Object)DefaultEnum.YES.getValue());
            DynamicObject[] totalBudgets = BusinessDataServiceHelper.load((String)"pmas_totalbudget", (String)"id", (QFilter[])new QFilter[]{qFilter, statusQFilter});
            if (totalBudgets.length == 0) {
                statusQFilter = new QFilter("billstatus", "=", (Object)kd.pmgt.pmbs.common.enums.StatusEnum.UNCHECKED.getValue());
                totalBudgets = BusinessDataServiceHelper.load((String)"pmas_totalbudget", (String)"id", (QFilter[])new QFilter[]{qFilter, statusQFilter});
            }
            if (totalBudgets.length == 0) {
                statusQFilter = new QFilter("billstatus", "=", (Object)kd.pmgt.pmbs.common.enums.StatusEnum.TEMPSAVE.getValue());
                totalBudgets = BusinessDataServiceHelper.load((String)"pmas_totalbudget", (String)"id", (QFilter[])new QFilter[]{qFilter, statusQFilter});
            }
            if (totalBudgets.length > 0) {
                DynamicObject totalBudget = BusinessDataServiceHelper.loadSingle((Object)totalBudgets[0].getPkValue(), (String)"pmas_totalbudget");
                DynamicObjectCollection budgetEntry = totalBudget.getDynamicObjectCollection("treeentryentity");
                BudgetEntryOperateHelper.fillTreeEntryByEntryEntity((DynamicObjectCollection)budgetEntry, (boolean)false, (boolean)false, (IFormView)this.getView(), (String)"treeentryentity", (String)"budgetitemname", (String)"budgetitemnum", (String)"descriptionentry", (String)"budgetitem");
                DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity("treeentryentity");
                if (entryEntity.size() > 0) {
                    for (DynamicObject entry : entryEntity) {
                        entry.set("ispres", (Object)true);
                        entry.set("isprev", (Object)true);
                    }
                }
                this.getModel().updateEntryCache(entryEntity);
                this.getView().updateView("treeentryentity");
                BudgetEntryOperateHelper.setAmountColumnEnable((String)"treeentryentity", (String)"budgetamount", (IFormView)this.getView());
                BudgetEntryOperateHelper.setTotalAmount((BigDecimal)totalBudget.getBigDecimal("totalamount"), (IFormView)this.getView(), (String)"totalamount");
                BudgetEntryOperateHelper.setTotalAmountEnable((IFormView)this.getView(), (String)"treeentryentity", (String)"totalamount");
                this.setBudgetEntrySumRow();
            } else {
                this.fillEntryByProTemplate(projectObj);
            }
        }
    }

    private void setBudgetEntryByPreStage(DynamicObject existedProBudget) {
        DynamicObject preBudget = BusinessDataServiceHelper.loadSingle((Object)existedProBudget.getPkValue(), (String)"pmas_budget");
        DynamicObjectCollection preEntries = preBudget.getDynamicObjectCollection("treeentryentity");
        if (BudgetSourceTypeEnum.TOTAL.getValue().equals(this.getBudgetSourceType())) {
            this.getModel().setValue("presamount", (Object)preBudget.getBigDecimal("totalamount"));
            this.getModel().setValue("totalamount", (Object)preBudget.getBigDecimal("totalamount"));
        } else {
            Date preBudgetDate = preBudget.getDate("year");
            Date budgetDate = (Date)this.getModel().getValue("year");
            if (budgetDate != null) {
                int preYear;
                int selectYear = budgetDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
                if (selectYear != (preYear = preBudgetDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear())) {
                    this.getModel().setValue("presamount", (Object)BigDecimal.ZERO);
                    this.getModel().setValue("totalamount", (Object)BigDecimal.ZERO);
                    if (preEntries.size() > 0) {
                        preEntries.forEach(preEntry -> {
                            preEntry.set("budgetamount", (Object)BigDecimal.ZERO);
                            preEntry.set("siamount", (Object)BigDecimal.ZERO);
                        });
                    }
                } else {
                    this.getModel().setValue("presamount", (Object)preBudget.getBigDecimal("totalamount"));
                    this.getModel().setValue("totalamount", (Object)preBudget.getBigDecimal("totalamount"));
                }
            } else {
                this.getModel().setValue("presamount", (Object)preBudget.getBigDecimal("totalamount"));
                this.getModel().setValue("totalamount", (Object)preBudget.getBigDecimal("totalamount"));
            }
        }
        this.getModel().setValue("schangeamount", (Object)BigDecimal.ZERO);
        this.getView().setVisible(Boolean.TRUE, new String[]{"presamount", "schangeamount", "siamount"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"sichangeamount"});
        this.getModel().deleteEntryData("treeentryentity");
        DynamicObject project = preBudget.getDynamicObject("project");
        boolean isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)Long.parseLong(project.getPkValue().toString()));
        if (isNew) {
            this.fillCurBudgetEntry(Long.parseLong(project.getPkValue().toString()), preEntries, false);
            this.setBudgetEntrySumRow();
        } else {
            BudgetEntryOperateHelper.fillTreeEntryByEntryEntity((DynamicObjectCollection)preEntries, (boolean)false, (boolean)false, (IFormView)this.getView(), (String)"treeentryentity", (String)"budgetitemname", (String)"budgetitemnum", (String)"descriptionentry", (String)"budgetitem");
            if (preEntries.isEmpty()) {
                return;
            }
            DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity("treeentryentity");
            if (entryEntity.size() > 0) {
                for (DynamicObject entry : entryEntity) {
                    entry.set("ispres", (Object)true);
                }
            }
            this.getModel().updateEntryCache(entryEntity);
            this.getView().updateView("treeentryentity");
        }
    }

    private void setPreBudgetName(DynamicObject preBud, Date preBudgetYear) {
        int preYear;
        int selectYear;
        Date budgetDate;
        if (preBudgetYear != null && preBud != null && (budgetDate = (Date)this.getModel().getValue("year")) != null && (selectYear = budgetDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear()) != (preYear = preBudgetYear.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"presamount"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"siamount"});
            return;
        }
        String budgetStageName = ResManager.loadKDString((String)"\u53c2\u7167", (String)"BudgetBillPlugin_19", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]);
        if (preBud != null) {
            budgetStageName = preBud.getString(NAME);
        }
        AmountEdit presAmount = (AmountEdit)this.getControl("presamount");
        TreeEntryGrid treeGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        List fieldEdits = treeGrid.getFieldEdits();
        LocaleString stageName = new LocaleString("zh_CN", String.format(ResManager.loadKDString((String)"%1$s\u9636\u6bb5\u91d1\u989d", (String)"BudgetBillPlugin_20", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), budgetStageName));
        treeGrid.setColumnProperty(((FieldEdit)fieldEdits.get(3)).getFieldKey(), "header", (Object)stageName);
        presAmount.setCaption(new LocaleString("zh_CN", String.format(ResManager.loadKDString((String)"%1$s\u9636\u6bb5\u603b\u91d1\u989d", (String)"BudgetBillPlugin_21", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), budgetStageName)));
    }

    private List<Integer> isTotal(int[] selectRows) {
        ArrayList<Integer> isTotalIndex = new ArrayList<Integer>();
        for (int i = 0; i < selectRows.length; ++i) {
            Boolean isTotal = (Boolean)this.getModel().getValue("istotal", selectRows[i]);
            if (!isTotal.booleanValue()) continue;
            isTotalIndex.add(selectRows[i]);
        }
        return isTotalIndex;
    }

    private List<Integer> isPresOrIsPrev(int[] selectRows) {
        Object value = this.getModel().getValue("type");
        boolean isAdjust = false;
        if (ADJUST.equals(value)) {
            isAdjust = true;
        }
        ArrayList<Integer> presPrevIndexs = new ArrayList<Integer>();
        for (int i = 0; i < selectRows.length; ++i) {
            Boolean isPres = (Boolean)this.getModel().getValue("ispres", selectRows[i]);
            Boolean isPrev = (Boolean)this.getModel().getValue("isprev", selectRows[i]);
            if (isPres == null) {
                isPres = Boolean.FALSE;
            }
            if (isPrev == null) {
                isPrev = Boolean.FALSE;
            }
            if (isAdjust) {
                if (!isPrev.booleanValue()) continue;
                presPrevIndexs.add(selectRows[i]);
                continue;
            }
            if (!isPres.booleanValue()) continue;
            presPrevIndexs.add(selectRows[i]);
        }
        return presPrevIndexs;
    }

    private String getIsPrevOrIsPrevTip() {
        String tip = ResManager.loadKDString((String)"\u4e0a\u4e2a\u9636\u6bb5", (String)"BudgetBillPlugin_22", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]);
        Object value = this.getModel().getValue("type");
        if (ADJUST.equals(value.toString())) {
            tip = ResManager.loadKDString((String)"\u4e0a\u4e2a\u7248\u672c", (String)"BudgetBillPlugin_23", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]);
        }
        return tip;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject project;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        int[] selectRows = treeEntryGrid.getSelectRows();
        Object sourceType = this.getModel().getValue("sourcetype");
        Object number = this.getModel().getValue("billno");
        Object templateName = this.getModel().getValue(NAME);
        String name = "";
        if (templateName != null) {
            name = templateName.toString();
        }
        if ((project = (DynamicObject)this.getModel().getValue("project")) == null && (StringUtils.equals((CharSequence)operateKey, (CharSequence)IMPORTFROMTPL) || StringUtils.equals((CharSequence)operateKey, (CharSequence)IMPORTEXCEL) || StringUtils.equals((CharSequence)operateKey, (CharSequence)ADDBUDGET) || StringUtils.equals((CharSequence)operateKey, (CharSequence)ADDROW) || StringUtils.equals((CharSequence)operateKey, (CharSequence)UPGRADE) || StringUtils.equals((CharSequence)operateKey, (CharSequence)DOWNGRADE))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u3002", (String)"BudgetBillPlugin_24", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        boolean isNew = false;
        if (project != null) {
            isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)Long.parseLong(project.getPkValue().toString()));
        }
        List<Integer> presOrIsPrevIndex = this.isPresOrIsPrev(selectRows);
        switch (operateKey) {
            case "save": {
                this.beforeDoSave(args, number);
                break;
            }
            case "submit": {
                this.beforeDoSubmit(args);
                break;
            }
            case "addrow": {
                BudgetEntryOperateHelper.addRow((IFormView)this.getView(), (String)"treeentryentity", (String)"budgetamount", (boolean)true, (String)ADDROW);
                BudgetEntryOperateHelper.setTotalAmountEnable((IFormView)this.getView(), (String)"treeentryentity", (String)"totalamount");
                BigDecimal totalAmount = BudgetEntryOperateHelper.setAmountColumnValue((IFormView)this.getView(), (String)"treeentryentity", (String)"budgetamount");
                BudgetEntryOperateHelper.setTotalAmount((BigDecimal)totalAmount, (IFormView)this.getView(), (String)"totalamount");
                break;
            }
            case "addsubordinate": {
                this.addRow(selectRows);
                break;
            }
            case "deleterow": {
                this.deleteRow(args, selectRows, presOrIsPrevIndex);
                break;
            }
            case "addbudget": {
                if (selectRows.length > 1) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u540c\u65f6\u4e3a\u591a\u4e2a\u9884\u7b97\u9879\u6dfb\u52a0\u5b50\u7ea7\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BudgetBillPlugin_25", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(ADDBUDGET, (IFormPlugin)this));
                    return;
                }
                this.importBudgetItem();
                break;
            }
            case "moveentryup": {
                if (selectRows.length <= 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u79fb\u64cd\u4f5c\u4ec5\u652f\u6301\u5355\u9009\u3002", (String)"BudgetBillPlugin_26", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            case "moveentrydown": {
                if (selectRows.length <= 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u79fb\u64cd\u4f5c\u4ec5\u652f\u6301\u5355\u9009\u3002", (String)"BudgetBillPlugin_27", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            case "importexcel": {
                String tplSheetName = name;
                if ("".equals(name.trim())) {
                    tplSheetName = ResManager.loadKDString((String)"\u9884\u7b97\u5bfc\u5165\u6a21\u677f", (String)"BudgetBillPlugin_28", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]);
                }
                BudgetEntryOperateHelper.importExcel((AbstractBillPlugIn)this, (String)tplSheetName, (String[])this.getHeader(), (String)IMPORTEXCEL);
                break;
            }
            case "exportexcel": {
                String sheetName = name;
                if ("".equals(name.trim())) {
                    sheetName = ResManager.loadKDString((String)"\u9884\u7b97", (String)"BudgetBillPlugin_29", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]);
                }
                this.columnKeys = new String[]{"budgetitemname", "budgetamount", "budgetitem", "descriptionentry"};
                BudgetExportParam budgetExportParam = new BudgetExportParam(this.getView(), "treeentryentity", "budgetitemname", false);
                budgetExportParam.setCurrency((DynamicObject)this.getModel().getValue("currency"));
                BudgetEntryOperateHelper.exportExcel((BudgetExportParam)budgetExportParam, (String)sheetName, (String[])this.columnKeys, (String[])this.getHeader());
                break;
            }
            case "upgrade": {
                if (!presOrIsPrevIndex.isEmpty()) {
                    String indexs = presOrIsPrevIndex.stream().map(i -> String.valueOf(i + 1)).collect(Collectors.joining(","));
                    String tip = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u660e\u7ec6\u6765\u81ea\u201c%2$s\u201d\uff0c\u4e0d\u5141\u8bb8\u5347\u7ea7\u964d\u7ea7\u3002", (String)"BudgetBillPlugin_30", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), indexs, this.getIsPrevOrIsPrevTip());
                    this.getView().showTipNotification(tip);
                    args.setCancel(true);
                    return;
                }
                if (selectRows.length > 0) {
                    DynamicObjectCollection treeEntryEntity = this.getModel().getEntryEntity("treeentryentity");
                    for (int selectRow : selectRows) {
                        DynamicObjectCollection performEntry;
                        DynamicObject selectDyn = (DynamicObject)treeEntryEntity.get(selectRow);
                        DynamicObject budgetItem = selectDyn.getDynamicObject("projectbudgetitem");
                        if (isNew) {
                            String tip = "";
                            boolean isTotal = selectDyn.getBoolean("istotal");
                            if (isTotal) {
                                tip = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u660e\u7ec6\u6765\u81ea\u603b\u4f53\u9884\u7b97\uff0c\u4e0d\u5141\u8bb8\u5347\u7ea7\u964d\u7ea7\u3002", (String)"BudgetBillPlugin_31", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), selectRow + 1);
                            } else {
                                boolean isUsage = ProBudgetControlHelper.checkBudgetItemIsUsage((DynamicObject)budgetItem);
                                if (isUsage) {
                                    tip = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u9884\u7b97\u9879\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u5347\u7ea7\u3002", (String)"BudgetBillPlugin_32", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), selectRow + 1);
                                }
                            }
                            if (StringUtils.isEmpty((CharSequence)tip)) continue;
                            this.getView().showTipNotification(tip);
                            args.setCancel(true);
                            return;
                        }
                        if (budgetItem == null || (performEntry = (budgetItem = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(budgetItem.getPkValue().toString()), (String)"pmas_projectbudgetperform")).getDynamicObjectCollection("performentry")) == null || performEntry.size() <= 0) continue;
                        String tip = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u9884\u7b97\u9879\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u5347\u7ea7\u3002", (String)"BudgetBillPlugin_32", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), selectRow + 1);
                        this.getView().showTipNotification(tip);
                        args.setCancel(true);
                        return;
                    }
                }
                BudgetEntryOperateHelper.upgrade((IFormView)this.getView(), (String)"treeentryentity", (String)"budgetitem", (String)"budgetitemname", (String)"budgetamount", (String)"totalamount", (String)"budgetitemnum", (String)"descriptionentry", (boolean)true);
                break;
            }
            case "downgrade": {
                if (!presOrIsPrevIndex.isEmpty()) {
                    String indexs = presOrIsPrevIndex.stream().map(i -> String.valueOf(i + 1)).collect(Collectors.joining(","));
                    String tip = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u660e\u7ec6\u6765\u81ea\u201c%2$s\u201d\uff0c\u4e0d\u5141\u8bb8\u5347\u7ea7\u964d\u7ea7\u3002", (String)"BudgetBillPlugin_30", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), indexs, this.getIsPrevOrIsPrevTip());
                    this.getView().showTipNotification(tip);
                    args.setCancel(true);
                    return;
                }
                String errorTip = this.checkParent(this.getView(), isNew);
                if (StringUtils.isNotBlank((CharSequence)errorTip)) {
                    this.getView().showTipNotification(errorTip);
                    args.setCancel(true);
                    return;
                }
                BudgetEntryOperateHelper.downgrade((IFormView)this.getView(), (String)"treeentryentity", (String)"budgetitem", (String)"budgetitemname", (String)"budgetamount", (String)"totalamount", (String)"budgetitemnum", (String)"descriptionentry", (boolean)true);
                break;
            }
            case "importfromtpl": {
                int rowCount = this.getModel().getEntryRowCount("treeentryentity");
                if (rowCount > 0) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5f15\u5165\u6a21\u677f\u5c06\u8986\u76d6\u5f53\u524d\u9884\u7b97\u660e\u7ec6\u5185\u5bb9\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BudgetBillPlugin_33", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(IMPORTFROMTPL, (IFormPlugin)this));
                    break;
                }
                BudgetEntryOperateHelper.importTemplate((AbstractBillPlugIn)this, (Object)sourceType, (String)IMPORTFROMTPL);
                break;
            }
        }
    }

    private String checkParent(IFormView formView, boolean isNew) {
        boolean isTotal;
        String errorTip = "";
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)formView.getControl("treeentryentity");
        int[] index = treeEntryGrid.getSelectRows();
        if (index.length != 1) {
            errorTip = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"BudgetBillPlugin_34", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]);
            return errorTip;
        }
        int selectIndex = formView.getModel().getEntryCurrentRowIndex("treeentryentity");
        DynamicObject selectRow = formView.getModel().getEntryRowEntity("treeentryentity", selectIndex);
        if (isNew && (isTotal = selectRow.getBoolean("istotal"))) {
            errorTip = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u660e\u7ec6\u6765\u81ea\u603b\u4f53\u9884\u7b97\uff0c\u4e0d\u5141\u8bb8\u5347\u7ea7\u964d\u7ea7\u3002", (String)"BudgetBillPlugin_31", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), selectIndex + 1);
            return errorTip;
        }
        DynamicObject brother = BudgetBillPlugin.getBrother(selectRow, formView.getModel().getEntryEntity("treeentryentity"));
        String parentId = brother != null ? brother.getString("id") : "0";
        DynamicObjectCollection entryEntity = formView.getModel().getEntryEntity("treeentryentity");
        Optional<DynamicObject> findFirst = entryEntity.stream().filter(entity -> entity.getPkValue().toString().equals(parentId)).findFirst();
        if (findFirst.isPresent()) {
            DynamicObjectCollection performEntry;
            DynamicObject parent = findFirst.get();
            DynamicObject budgetItem = parent.getDynamicObject("projectbudgetitem");
            if (isNew) {
                boolean isUsage = ProBudgetControlHelper.checkBudgetItemIsUsage((DynamicObject)budgetItem);
                if (isUsage) {
                    errorTip = ResManager.loadKDString((String)"\u8be5\u9884\u7b97\u9879\u5df2\u88ab\u4f7f\u7528\uff0c\u65e0\u6cd5\u6dfb\u52a0\u4e0b\u7ea7\u9884\u7b97\u9879\u3002", (String)"BudgetBillPlugin_35", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]);
                }
            } else if (budgetItem != null && (performEntry = (budgetItem = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(budgetItem.getPkValue().toString()), (String)"pmas_projectbudgetperform")).getDynamicObjectCollection("performentry")) != null && performEntry.size() > 0) {
                errorTip = ResManager.loadKDString((String)"\u8be5\u9884\u7b97\u9879\u5df2\u88ab\u4f7f\u7528\uff0c\u65e0\u6cd5\u6dfb\u52a0\u4e0b\u7ea7\u9884\u7b97\u9879\u3002", (String)"BudgetBillPlugin_35", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]);
            }
        }
        return errorTip;
    }

    public static DynamicObject getBrother(DynamicObject currentNode, DynamicObjectCollection collection) {
        DynamicObject brother = null;
        for (int i = currentNode.getInt("seq") - 2; i >= 0; --i) {
            if (!StringUtils.equals((CharSequence)currentNode.getString("pid"), (CharSequence)((DynamicObject)collection.get(i)).getString("pid"))) continue;
            brother = (DynamicObject)collection.get(i);
            break;
        }
        return brother;
    }

    private void deleteRow(BeforeDoOperationEventArgs args, int[] selectRows, List<Integer> presOrIsPrevIndex) {
        if (selectRows.length > 0) {
            if (presOrIsPrevIndex.size() > 0) {
                if (presOrIsPrevIndex.size() == selectRows.length) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u884c\u5747\u4e3a%1$s\u5e26\u5165\u7684\u660e\u7ec6\uff0c\u4e0d\u53ef\u5220\u9664\uff0c\u8bf7\u5c06\u91d1\u989d\u8bbe\u4e3a0\u3002", (String)"BudgetBillPlugin_36", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), this.getIsPrevOrIsPrevTip()));
                } else {
                    String indexs = presOrIsPrevIndex.stream().map(i -> String.valueOf(i + 1)).collect(Collectors.joining(","));
                    String tip = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u660e\u7ec6\u6765\u81ea\u201c%2$s\u201d\uff0c\u4e0d\u53ef\u5220\u9664\uff0c\u8bf7\u5c06\u91d1\u989d\u8bbe\u4e3a0\u3002\u7cfb\u7edf\u5c06\u5220\u9664\u5176\u4ed6\u660e\u7ec6\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BudgetBillPlugin_37", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), indexs, this.getIsPrevOrIsPrevTip());
                    ConfirmCallBackListener delectCallback = new ConfirmCallBackListener(DELETEROWCALLBACKID, (IFormPlugin)this);
                    this.getView().showConfirm(tip, MessageBoxOptions.OKCancel, ConfirmTypes.Delete, delectCallback);
                }
                args.setCancel(true);
                return;
            }
            List<Integer> isTotalIndex = this.isTotal(selectRows);
            if (isTotalIndex.size() > 0) {
                if (isTotalIndex.size() == selectRows.length) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u884c\u5747\u4e3a\u603b\u4f53\u9884\u7b97\u5e26\u5165\u7684\u660e\u7ec6\uff0c\u4e0d\u53ef\u5220\u9664\uff0c\u8bf7\u5c06\u91d1\u989d\u8bbe\u4e3a0\u3002", (String)"BudgetBillPlugin_38", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                } else {
                    String index = isTotalIndex.stream().map(i -> String.valueOf(i + 1)).collect(Collectors.joining(","));
                    String tip = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u660e\u7ec6\u6765\u81ea\u201c\u603b\u4f53\u9884\u7b97\u201d\uff0c\u4e0d\u53ef\u5220\u9664\uff0c\u8bf7\u5c06\u91d1\u989d\u8bbe\u4e3a0\u3002\u7cfb\u7edf\u5c06\u5220\u9664\u5176\u4ed6\u660e\u7ec6\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BudgetBillPlugin_39", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), index);
                    ConfirmCallBackListener delCallback = new ConfirmCallBackListener(DELETEROWCALLBACKID, (IFormPlugin)this);
                    this.getView().showConfirm(tip, MessageBoxOptions.OKCancel, ConfirmTypes.Delete, delCallback);
                }
                args.setCancel(true);
                return;
            }
        }
        BudgetEntryOperateHelper.deleteRow((AbstractBillPlugIn)this, (String)"treeentryentity", (String)"budgetamount", (String)"totalamount", (String)DELETEROW, (boolean)true);
    }

    private void addRow(int[] selectRows) {
        if (selectRows.length == 1) {
            Object projectObj = this.getModel().getValue("project");
            int selectRowIndex = selectRows[0];
            DynamicObjectCollection treeEntryEntity = this.getModel().getEntryEntity("treeentryentity");
            DynamicObject entry = (DynamicObject)treeEntryEntity.get(selectRowIndex);
            DynamicObject budgetItem = entry.getDynamicObject("projectbudgetitem");
            if (budgetItem != null) {
                if (projectObj == null) {
                    return;
                }
                DynamicObject project = (DynamicObject)projectObj;
                boolean isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)Long.parseLong(project.getPkValue().toString()));
                if (!isNew) {
                    DynamicObjectCollection performEntry = (budgetItem = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(budgetItem.getPkValue().toString()), (String)"pmas_projectbudgetperform")).getDynamicObjectCollection("performentry");
                    if (performEntry != null && performEntry.size() > 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u9884\u7b97\u9879\u5df2\u88ab\u4f7f\u7528\uff0c\u65e0\u6cd5\u6dfb\u52a0\u4e0b\u7ea7\u9884\u7b97\u9879\u3002", (String)"BudgetBillPlugin_40", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    Object sourceTypeObj = this.getModel().getValue("sourcetype");
                    if (sourceTypeObj != null) {
                        QFilter qFilter;
                        String sourceType;
                        DynamicObjectCollection details = null;
                        String string = sourceType = StringUtils.equals((CharSequence)"IN", (CharSequence)sourceTypeObj.toString()) ? "IN" : "OUT";
                        if (StringUtils.equals((CharSequence)"TOTAL", (CharSequence)sourceTypeObj.toString())) {
                            qFilter = new QFilter("tbudgettype", "=", (Object)sourceType);
                            qFilter.and("tproject", "=", (Object)Long.parseLong(project.getPkValue().toString()));
                            DynamicObject totalBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{qFilter});
                            if (totalBudgetCtrl != null) {
                                details = totalBudgetCtrl.getDynamicObjectCollection("tbudgetctrldetail");
                            }
                        } else {
                            DynamicObject yearBudgetCtrl;
                            qFilter = new QFilter("ybudgettype", "=", (Object)sourceType);
                            qFilter.and("yproject", "=", (Object)Long.parseLong(project.getPkValue().toString()));
                            Object yearObj = this.getModel().getValue("year");
                            if (yearObj != null) {
                                qFilter.and("yyear", "=", yearObj);
                            }
                            if ((yearBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrl", (QFilter[])new QFilter[]{qFilter})) != null) {
                                details = yearBudgetCtrl.getDynamicObjectCollection("ybudgetctrldetail");
                            }
                        }
                        if (details != null && !details.isEmpty()) {
                            String amountId;
                            DynamicObject entryCtrl;
                            BigDecimal occupyAmt;
                            long budgetItemId = Long.parseLong(budgetItem.getPkValue().toString());
                            Optional<DynamicObject> first = details.stream().filter(o -> o.getDynamicObject("budget") != null).filter(o -> Long.parseLong(o.getDynamicObject("budget").getPkValue().toString()) == budgetItemId).findFirst();
                            if (first.isPresent() && (occupyAmt = (entryCtrl = first.get()).getBigDecimal(amountId = StringUtils.equals((CharSequence)"TOTAL", (CharSequence)sourceTypeObj.toString()) ? "occupyamt" : "preoccupyusageamt")).compareTo(BigDecimal.ZERO) > 0) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u9884\u7b97\u9879\u5df2\u53d1\u751f\u9884\u7b97\u5360\u7528\uff0c\u65e0\u6cd5\u6dfb\u52a0\u4e0b\u7ea7\u9884\u7b97\u9879\u3002", (String)"BudgetBillPlugin_41", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                            }
                        }
                    }
                }
            }
        }
        BudgetEntryOperateHelper.addRow((IFormView)this.getView(), (String)"treeentryentity", (String)"budgetamount", (boolean)true, (String)ADDSUBORDINATE);
        BudgetEntryOperateHelper.setTotalAmountEnable((IFormView)this.getView(), (String)"treeentryentity", (String)"totalamount");
        BigDecimal totalAmount = BudgetEntryOperateHelper.setAmountColumnValue((IFormView)this.getView(), (String)"treeentryentity", (String)"budgetamount");
        BudgetEntryOperateHelper.setAmountColumnValue((IFormView)this.getView(), (String)"treeentryentity", (String)"itemtotalamount");
        BudgetEntryOperateHelper.setAmountColumnValue((IFormView)this.getView(), (String)"treeentryentity", (String)"sichangeamount");
        BudgetEntryOperateHelper.setAmountColumnValue((IFormView)this.getView(), (String)"treeentryentity", (String)"vichangeamount");
        BudgetEntryOperateHelper.setTotalAmount((BigDecimal)totalAmount, (IFormView)this.getView(), (String)"totalamount");
    }

    private void beforeDoSubmit(BeforeDoOperationEventArgs args) {
        Object budgetStage = this.getModel().getValue("budgetstage");
        if (budgetStage == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u9884\u7b97\u9636\u6bb5\u201d\u3002", (String)"BudgetBillPlugin_42", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        BigDecimal version1 = (BigDecimal)this.getModel().getValue("version");
        if (this.isProjectAndVersionRepeat(version1)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u5df2\u5b58\u5728%1$s\u7248\u672c\u7684\u5355\u636e\u3002", (String)"BudgetBillPlugin_43", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), version1.setScale(1).toString()));
            args.setCancel(true);
            return;
        }
    }

    private void beforeDoSave(BeforeDoOperationEventArgs args, Object number) {
        if (number == null || "".equals(number.toString().trim())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5355\u636e\u7f16\u53f7\u201d\u3002", (String)"BudgetBillPlugin_44", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Object budgetStage = this.getModel().getValue("budgetstage");
        if (budgetStage == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u9884\u7b97\u9636\u6bb5\u201d\u3002", (String)"BudgetBillPlugin_42", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        BigDecimal version = (BigDecimal)this.getModel().getValue("version");
        if (this.isProjectAndVersionRepeat(version)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u5f53\u524d\u9879\u76ee\u5df2\u5b58\u5728%1$s\u7248\u672c\u7684\u5355\u636e\u3002", (String)"BudgetBillPlugin_45", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), version.setScale(1).toString()));
            args.setCancel(true);
            return;
        }
    }

    private int isCurrentRowFromPre(int selectRowIndex) {
        int isFromPre = -1;
        Boolean isPrev = (Boolean)this.getModel().getValue("isprev", selectRowIndex);
        Boolean isPres = (Boolean)this.getModel().getValue("ispres", selectRowIndex);
        if (isPrev.booleanValue()) {
            isFromPre += 2;
        }
        if (isPres.booleanValue()) {
            ++isFromPre;
        }
        if (isPres.booleanValue() || isPrev.booleanValue()) {
            return isFromPre;
        }
        String pid = this.getModel().getEntryRowEntity("treeentryentity", selectRowIndex).getString("pid");
        while (!"0".equals(pid) && pid != null) {
            DynamicObject entry = this.getEntryById(pid);
            if (entry != null) {
                isPres = entry.getBoolean("ispres");
            }
            if (entry != null) {
                isPrev = entry.getBoolean("isprev");
            }
            if (isPrev.booleanValue()) {
                isFromPre += 2;
            }
            if (isPres.booleanValue()) {
                ++isFromPre;
            }
            if (isPrev.booleanValue() || isPres.booleanValue()) {
                return isFromPre;
            }
            if (entry == null) continue;
            pid = entry.getString("pid");
        }
        return isFromPre;
    }

    private DynamicObject getEntryById(String id) {
        DynamicObject parent = null;
        if (id == null) {
            return parent;
        }
        DynamicObjectCollection entries = this.getModel().getEntryEntity("treeentryentity");
        for (DynamicObject ob : entries) {
            if (!id.equals(ob.getString("id"))) continue;
            parent = ob;
            break;
        }
        return parent;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "moveentryup": 
            case "moveentrydown": {
                BudgetEntryOperateHelper.setAmountColumnEnable((String)"treeentryentity", (String)"budgetamount", (IFormView)this.getView());
                this.setBudgetEntrySumRow();
                break;
            }
            case "addrow": 
            case "addsubordinate": 
            case "deleterow": {
                this.setBudgetEntrySumRow();
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit budgetStage = (BasedataEdit)this.getControl("budgetstage");
        budgetStage.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit parentPro = (BasedataEdit)this.getControl("project");
        parentPro.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        parentPro.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)ProjectHelper.getProjectDetailShowParameter((Object)beforeF7ViewDetailEvent.getPkId()));
        });
        BasedataEdit budgetitem = (BasedataEdit)this.getControl("budgetitem");
        budgetitem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (callBackId) {
            case "importfromtpl": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                Object sourceType = this.getModel().getValue("sourcetype");
                BudgetEntryOperateHelper.importTemplate((AbstractBillPlugIn)this, (Object)sourceType, (String)IMPORTFROMTPL);
                break;
            }
            case "deleterow": {
                this.deleteRowConfirm(result);
                break;
            }
            case "deleterowcallbackid": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
                int[] selectRows = treeEntryGrid.getSelectRows();
                List<Integer> presOrIsPrev = this.isPresOrIsPrev(selectRows);
                List<Integer> isTotal = this.isTotal(selectRows);
                ArrayList<Integer> deletes = new ArrayList<Integer>();
                for (int i = 0; i < selectRows.length; ++i) {
                    if (!presOrIsPrev.isEmpty() && !presOrIsPrev.contains(selectRows[i])) {
                        deletes.add(selectRows[i]);
                    }
                    if (isTotal.isEmpty() || isTotal.contains(selectRows[i])) continue;
                    deletes.add(selectRows[i]);
                }
                if (deletes.size() == 0) break;
                int[] dels = deletes.stream().mapToInt(Integer::valueOf).toArray();
                treeEntryGrid.clearEntryState();
                treeEntryGrid.selectRows(dels, 0);
                BudgetEntryOperateHelper.deleteRow((AbstractBillPlugIn)this, (String)"treeentryentity", (String)"budgetamount", (String)"totalamount", (String)DELETEROW, (boolean)true);
                break;
            }
            case "addbudget": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                this.importBudgetItem();
                break;
            }
            case "project": {
                String newProject = this.getPageCache().get("newproject");
                String oldProject = this.getPageCache().get("oldproject");
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    DynamicObject project = StringUtils.isBlank((CharSequence)newProject) ? null : BusinessDataServiceHelper.loadSingle((Object)newProject, (String)"bd_project");
                    this.changeProject(project);
                    break;
                }
                this.getModel().beginInit();
                DynamicObject project = StringUtils.isBlank((CharSequence)oldProject) ? null : BusinessDataServiceHelper.loadSingle((Object)oldProject, (String)"bd_project");
                this.getModel().setValue("project", (Object)project);
                this.getModel().endInit();
                this.getView().updateView("project");
                break;
            }
            case "budgetstage": {
                String oldStage = this.getPageCache().get("oldstage");
                String newStage = this.getPageCache().get("newstage");
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    DynamicObject stage = StringUtils.isBlank((CharSequence)newStage) ? null : BusinessDataServiceHelper.loadSingle((Object)newStage, (String)"pmbs_budgetstage");
                    this.changeBudgetStage(stage);
                    break;
                }
                this.getModel().beginInit();
                DynamicObject stage = StringUtils.isBlank((CharSequence)oldStage) ? null : BusinessDataServiceHelper.loadSingle((Object)oldStage, (String)"pmbs_budgetstage");
                this.getModel().setValue("budgetstage", (Object)stage);
                this.getModel().endInit();
                this.getView().updateView("budgetstage");
                break;
            }
        }
    }

    private void deleteRowConfirm(MessageBoxResult result) {
        if (MessageBoxResult.Yes.equals((Object)result)) {
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
            int[] selectRows = treeEntryGrid.getSelectRows();
            Set allChildRowIndex = BudgetEntryOperateHelper.getAllChildRowIndex((int[])selectRows, (DynamicObjectCollection)this.getModel().getEntryEntity("treeentryentity"));
            IDataModel entryOperate = this.getModel();
            int i = 0;
            int[] deleteRows = new int[allChildRowIndex.size()];
            Iterator iterator = allChildRowIndex.iterator();
            while (iterator.hasNext()) {
                deleteRows[i] = (Integer)iterator.next();
                ++i;
            }
            Set parentIdSet = BudgetEntryOperateHelper.getSelectRowParents((IDataModel)this.getView().getModel(), (int[])selectRows, (String)"treeentryentity");
            entryOperate.deleteEntryRows("treeentryentity", deleteRows);
            this.getModel().updateCache();
            BudgetEntryOperateHelper.resetParentAmountValue((IDataModel)this.getView().getModel(), (Set)parentIdSet, (String)"treeentryentity", (String)"budgetamount");
            BudgetEntryOperateHelper.setAmountColumnEnable((String)"treeentryentity", (String)"budgetamount", (IFormView)this.getView());
            BigDecimal totalAmount = BudgetEntryOperateHelper.setAmountColumnValue((IFormView)this.getView(), (String)"treeentryentity", (String)"budgetamount");
            BudgetEntryOperateHelper.setTotalAmount((BigDecimal)totalAmount, (IFormView)this.getView(), (String)"totalamount");
            BudgetEntryOperateHelper.setTotalAmountEnable((IFormView)this.getView(), (String)"treeentryentity", (String)"totalamount");
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "importbudgetitem": {
                this.importBudgetItemCloseCallBack(e);
                BudgetEntryOperateHelper.setTotalAmountEnable((IFormView)this.getView(), (String)"treeentryentity", (String)"totalamount");
                BigDecimal totalAmount = BudgetEntryOperateHelper.setAmountColumnValue((IFormView)this.getView(), (String)"treeentryentity", (String)"budgetamount");
                BudgetEntryOperateHelper.setTotalAmount((BigDecimal)totalAmount, (IFormView)this.getView(), (String)"totalamount");
                break;
            }
            case "importfromtpl": {
                this.importFromTplCloseCallBack(e);
                break;
            }
            case "importexcel": {
                this.importExcelCloseCallBack(e);
                this.setBudgetEntrySumRow();
                break;
            }
        }
    }

    protected void setBudgetEntrySumRow() {
        EntryGrid budgetOutEntry = (EntryGrid)this.getControl("treeentryentity");
        DynamicObjectCollection details = this.getModel().getEntryEntity("treeentryentity");
        if (details.isEmpty()) {
            return;
        }
        BigDecimal itemTotalAmount = details.stream().filter(o -> o.getLong("pid") == 0L).map(o -> o.getBigDecimal("itemtotalamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal totalAmount = details.stream().filter(o -> o.getLong("pid") == 0L).map(o -> o.getBigDecimal("budgetamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal vChangeAmount = details.stream().filter(o -> o.getLong("pid") == 0L).map(o -> o.getBigDecimal("vichangeamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal preVAmount = details.stream().filter(o -> o.getLong("pid") == 0L).map(o -> o.getBigDecimal("viamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal presAmount = details.stream().filter(o -> o.getLong("pid") == 0L).map(o -> o.getBigDecimal("siamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        HashMap<String, String> floatBottomData = new HashMap<String, String>();
        DynamicObject currency = this.getModel().getDataEntity().getDynamicObject("currency");
        floatBottomData.put("itemtotalamount", CurrencyFormatUtil.getAfterFormatString((DynamicObject)currency, (Object)itemTotalAmount));
        floatBottomData.put("budgetamount", CurrencyFormatUtil.getAfterFormatString((DynamicObject)currency, (Object)totalAmount));
        floatBottomData.put("vichangeamount", CurrencyFormatUtil.getAfterFormatString((DynamicObject)currency, (Object)vChangeAmount));
        floatBottomData.put("viamount", CurrencyFormatUtil.getAfterFormatString((DynamicObject)currency, (Object)preVAmount));
        floatBottomData.put("siamount", CurrencyFormatUtil.getAfterFormatString((DynamicObject)currency, (Object)presAmount));
        budgetOutEntry.setFloatButtomData(floatBottomData);
    }

    private void importExcelCloseCallBack(ClosedCallBackEvent e) {
        String url = (String)e.getReturnData();
        if (url == null || "".equals(url.trim())) {
            return;
        }
        List title = BudgetEntryOperateHelper.getHeadByExcel((String)url);
        boolean flag = BudgetEntryOperateHelper.checkTitle((List)title, (String[])this.getHeader());
        if (flag) {
            Tree tree = BudgetEntryOperateHelper.buildTreeFromExcel((String)url, (IFormView)this.getView(), (String)"budget");
            if (tree != null) {
                BudgetEntryOperateHelper.fillEntryData((IFormView)this.getView(), (String)"treeentryentity", (String)"budgetitemname", (Tree)tree, (String)"budget");
                BudgetEntryOperateHelper.setAmountColumnEnable((String)"treeentryentity", (String)"budgetamount", (IFormView)this.getView());
                BigDecimal totalAmount = BudgetEntryOperateHelper.setAmountColumnValue((IFormView)this.getView(), (String)"treeentryentity", (String)"budgetamount");
                BudgetEntryOperateHelper.setTotalAmount((BigDecimal)totalAmount, (IFormView)this.getView(), (String)"totalamount");
                BudgetEntryOperateHelper.setTotalAmountEnable((IFormView)this.getView(), (String)"treeentryentity", (String)"totalamount");
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5bfc\u5165\u7684Excel\u6587\u4ef6\uff0c\u786e\u4fdd\u5176\u683c\u5f0f\u4e0e\u6a21\u677f\u4e00\u81f4\u3002", (String)"BudgetBillPlugin_46", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
        }
    }

    private void importFromTplCloseCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection tplRowCollection = (ListSelectedRowCollection)e.getReturnData();
        if (tplRowCollection == null || tplRowCollection.size() == 0) {
            return;
        }
        Object tplId = tplRowCollection.get(0).getPrimaryKeyValue();
        DynamicObject tpl = BusinessDataServiceHelper.loadSingle((Object)tplId, (String)"pmbs_budgettpl");
        BudgetEntryOperateHelper.fillTreeEntryByTemplate((DynamicObject)tpl, (String)"treeentryentity", (IFormView)this.getView(), (String)"budgetitemname", (String)"budgetitemnum", (String)"descriptionentry", (String)"budgetitem");
        BudgetEntryOperateHelper.setAmountColumnEnable((String)"treeentryentity", (String)"budgetamount", (IFormView)this.getView());
        BudgetEntryOperateHelper.setTotalAmount((BigDecimal)BigDecimal.ZERO, (IFormView)this.getView(), (String)"totalamount");
        BudgetEntryOperateHelper.setTotalAmountEnable((IFormView)this.getView(), (String)"treeentryentity", (String)"totalamount");
    }

    private void importBudgetItemCloseCallBack(ClosedCallBackEvent e) {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        int[] selectRows = treeEntryGrid.getSelectRows();
        ArrayList<Object> selectRowIds = new ArrayList<Object>(16);
        for (int index : selectRows) {
            selectRowIds.add(this.getModel().getEntryRowEntity("treeentryentity", index).getPkValue());
        }
        ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)e.getReturnData();
        if (listSelectedRowCollection == null) {
            return;
        }
        Object[] primaryKeyValues = listSelectedRowCollection.getPrimaryKeyValues();
        Tree budgetItemTree = BudgetEntryOperateHelper.buildBudgetItemTree((Object[])primaryKeyValues);
        if (selectRows.length == 0) {
            List allRootNode = budgetItemTree.getAllRootNode();
            if (allRootNode != null) {
                for (TreeNode rootNode : budgetItemTree.getAllRootNode()) {
                    BudgetEntryOperateHelper.fillRootNode((IFormView)this.getView(), (String)"treeentryentity", (String)"budgetitem", (String)"budgetitemname", (String)"budgetitemnum", (String)"descriptionentry", (TreeNode)rootNode);
                }
            }
        } else {
            for (Object e2 : selectRowIds) {
                int row = BudgetEntryOperateHelper.findRowIndexById(e2, (DynamicObjectCollection)this.getModel().getEntryEntity("treeentryentity"));
                if (row == -1) continue;
                BudgetEntryOperateHelper.insertBudgetItemTree((IFormView)this.getView(), (String)"treeentryentity", (String)"budgetitem", (String)"budgetitemname", (String)"budgetitemnum", (String)"descriptionentry", (Tree)budgetItemTree, (int)row);
                treeEntryGrid.expand(row);
            }
        }
        BudgetEntryOperateHelper.setAmountColumnEnable((String)"treeentryentity", (String)"budgetamount", (IFormView)this.getView());
        BudgetEntryOperateHelper.setTotalAmountEnable((IFormView)this.getView(), (String)"treeentryentity", (String)"totalamount");
    }

    private void fillEntryByProTemplate(DynamicObject projectObj) {
        if (projectObj.getDynamicObject("group") != null) {
            Object projectKindId = projectObj.getDynamicObject("group").getPkValue();
            Object sourceType = this.getModel().getValue("sourcetype");
            DynamicObject tpl = BudgetEntryOperateHelper.getBudgetTemplateByKindId((Object)sourceType, (Object)projectKindId);
            if (tpl != null) {
                BudgetEntryOperateHelper.fillTreeEntryByTemplate((DynamicObject)tpl, (String)"treeentryentity", (IFormView)this.getView(), (String)"budgetitemname", (String)"budgetitemnum", (String)"descriptionentry", (String)"budgetitem");
                BudgetEntryOperateHelper.setAmountColumnEnable((String)"treeentryentity", (String)"budgetamount", (IFormView)this.getView());
                BudgetEntryOperateHelper.setTotalAmount((BigDecimal)BigDecimal.ZERO, (IFormView)this.getView(), (String)"totalamount");
                BudgetEntryOperateHelper.setTotalAmountEnable((IFormView)this.getView(), (String)"treeentryentity", (String)"totalamount");
            }
        }
    }

    private void setDefaultBudgetStage(DynamicObject project) {
        DynamicObject[] existedProBudgets = this.isExistBudgetCurProject(project);
        DynamicObject defaultBudgetStage = null;
        if (existedProBudgets == null || existedProBudgets.length == 0) {
            defaultBudgetStage = this.getDefaultBudgetStage(project);
        }
        this.getModel().beginInit();
        this.getModel().setValue("budgetstage", (Object)defaultBudgetStage);
        this.getModel().endInit();
        this.getView().updateView("budgetstage");
        this.changeBudgetStage(defaultBudgetStage);
    }

    private DynamicObject getDefaultBudgetStage(DynamicObject project) {
        QFilter filter;
        DynamicObject[] projectApproval;
        DynamicObject defualtBudgetStage = null;
        if (project != null && (projectApproval = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"id,budgetentry,budgetentry.budgetstages,budgetentry.budgetstages.seqno,pro,pro.id", (QFilter[])new QFilter[]{filter = new QFilter("pro", "in", project.getPkValue())})) != null && projectApproval.length > 0) {
            DynamicObjectCollection entries = projectApproval[0].getDynamicObjectCollection("budgetentry");
            if (entries != null && entries.size() > 0) {
                defualtBudgetStage = (DynamicObject)((DynamicObject)entries.get(0)).get("budgetstages");
            } else {
                QFilter filter1 = new QFilter("enable", "=", (Object)EnableEnum.Enable);
                QFilter filter2 = new QFilter("status", "=", (Object)StatusEnum.Checked);
                DynamicObject[] budgetstages = BusinessDataServiceHelper.load((String)"pmbs_budgetstage", (String)"id,seqno", (QFilter[])new QFilter[]{filter1, filter2}, (String)"seqno");
                defualtBudgetStage = budgetstages[0];
            }
        }
        return defualtBudgetStage;
    }

    private DynamicObject getPreBudgetStage(DynamicObject project, DynamicObject budgetStage) {
        QFilter seqnoFilter;
        QFilter statusFilter;
        QFilter typeFilter;
        QFilter proFilter;
        DynamicObject[] query;
        DynamicObject preBudgetStage = null;
        if (budgetStage == null) {
            return null;
        }
        if (project != null && (query = BusinessDataServiceHelper.load((String)"pmas_budget", (String)"id", (QFilter[])new QFilter[]{proFilter = new QFilter("project", "=", project.getPkValue()), typeFilter = new QFilter("sourcetype", "=", (Object)this.getBudgetSourceType()), statusFilter = new QFilter("billstatus", "=", (Object)kd.pmgt.pmbs.common.enums.StatusEnum.CHECKED.getValue()), seqnoFilter = new QFilter("budgetstage.seqno", "<", budgetStage.get("seqno"))}, (String)"budgetstage.seqno desc", (int)1)) != null && query.length > 0) {
            DynamicObject preBudget = BusinessDataServiceHelper.loadSingle((Object)query[0].getPkValue(), (String)"pmas_budget");
            preBudgetStage = (DynamicObject)preBudget.get("budgetstage");
        }
        return preBudgetStage;
    }

    private boolean isProjectAndVersionRepeat(BigDecimal version) {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project != null) {
            Object pkValue;
            DynamicObject budgetstage;
            QFilter qFilter = new QFilter("project", "=", project.getPkValue());
            qFilter.and(new QFilter("version", "=", (Object)version));
            if (!BudgetSourceTypeEnum.TOTAL.getValue().equals(this.getBudgetSourceType())) {
                Date curYear = (Date)this.getModel().getValue("year");
                qFilter.and(new QFilter("year", "=", (Object)curYear));
            }
            if ((budgetstage = (DynamicObject)this.getModel().getValue("budgetstage")) != null) {
                qFilter.and("budgetstage", "=", budgetstage.getPkValue());
            }
            if ((pkValue = this.getModel().getDataEntity().getPkValue()) != null && !"0".equals(pkValue.toString())) {
                qFilter.and(new QFilter("id", "!=", pkValue));
            }
            qFilter.and(new QFilter("sourcetype", "=", (Object)this.getBudgetSourceType()));
            return QueryServiceHelper.exists((String)"pmas_budget", (QFilter[])new QFilter[]{qFilter});
        }
        return false;
    }

    private String getBudgetSourceType() {
        String formId;
        String type = "";
        switch (formId = this.getView().getFormShowParameter().getFormId()) {
            case "pmas_inbudget": {
                type = BudgetSourceTypeEnum.IN.getValue();
                break;
            }
            case "pmas_outbudget": {
                type = BudgetSourceTypeEnum.OUT.getValue();
                break;
            }
            case "pmas_totalbudget": {
                type = BudgetSourceTypeEnum.TOTAL.getValue();
                break;
            }
        }
        return type;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        switch (name) {
            case "budgetstage": {
                Date budgetYear;
                if (project != null) {
                    DynamicObject projectApplroval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"id,budgetentry,budgetentry.budgetstages,budgetentry.budgetstages.seqno,pro", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
                    if (projectApplroval != null) {
                        DynamicObjectCollection entries = projectApplroval.getDynamicObjectCollection("budgetentry");
                        Set ids = entries.stream().filter(o -> o.getDynamicObject("budgetstages") != null).map(o -> o.getDynamicObject("budgetstages").getPkValue()).collect(Collectors.toSet());
                        param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", ids));
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u3002", (String)"BudgetBillPlugin_24", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                }
                if (BudgetSourceTypeEnum.TOTAL.getValue().equals(this.getBudgetSourceType()) || (budgetYear = (Date)this.getModel().getValue("year")) != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e74\u5ea6\u3002", (String)"BudgetBillPlugin_47", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "budgetitem": {
                List entryIds;
                if (project == null) break;
                DynamicObject[] settings = null;
                DynamicObject projectKind = project.getDynamicObject("group");
                if (projectKind != null) {
                    settings = BusinessDataServiceHelper.load((String)"pmbs_prokindctrlsetting", (String)"outtreeentryentity.outbudgetitem,intreeentryentity.inbudgetitem", (QFilter[])new QFilter[]{new QFilter("projectkind", "=", projectKind.getPkValue())});
                }
                if (settings == null || settings.length <= 0) break;
                if (StringUtils.equals((CharSequence)this.getView().getEntityId(), (CharSequence)"pmas_inbudget")) {
                    DynamicObjectCollection treeentryentity = settings[0].getDynamicObjectCollection("intreeentryentity");
                    entryIds = treeentryentity.stream().map(o -> o.getDynamicObject("inbudgetitem").getPkValue()).collect(Collectors.toList());
                } else {
                    DynamicObjectCollection treeentryentity = settings[0].getDynamicObjectCollection("outtreeentryentity");
                    entryIds = treeentryentity.stream().map(o -> o.getDynamicObject("outbudgetitem").getPkValue()).collect(Collectors.toList());
                }
                if (entryIds.size() <= 0) break;
                param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", entryIds));
                break;
            }
        }
    }

    private void importBudgetItem() {
        DynamicObject projectKind;
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pmbs_budgetitem", (boolean)true, (int)3, (boolean)true);
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        DynamicObject[] settings = null;
        if (project != null && (projectKind = project.getDynamicObject("group")) != null) {
            settings = BusinessDataServiceHelper.load((String)"pmbs_prokindctrlsetting", (String)"outtreeentryentity.outbudgetitem,intreeentryentity.inbudgetitem", (QFilter[])new QFilter[]{new QFilter("projectkind", "=", projectKind.getPkValue())});
        }
        if (settings != null && settings.length > 0) {
            List entryIds;
            DynamicObjectCollection treeentryentity;
            if (StringUtils.equals((CharSequence)this.getView().getEntityId(), (CharSequence)"pmas_inbudget")) {
                treeentryentity = settings[0].getDynamicObjectCollection("intreeentryentity");
                entryIds = treeentryentity.stream().map(o -> o.getDynamicObject("inbudgetitem").getPkValue()).collect(Collectors.toList());
            } else {
                treeentryentity = settings[0].getDynamicObjectCollection("outtreeentryentity");
                entryIds = treeentryentity.stream().map(o -> o.getDynamicObject("outbudgetitem").getPkValue()).collect(Collectors.toList());
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, IMPORTBUDGETITEM);
            listShowParameter.setCloseCallBack(closeCallBack);
            if (entryIds.size() > 0) {
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", entryIds));
            }
            listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("enable", "=", (Object)"1"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, IMPORTBUDGETITEM);
            listShowParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    private void fillCurBudgetEntry(Long projectId, DynamicObjectCollection lastEntries, boolean isAdjust) {
        DynamicObjectCollection curDetails = this.getModel().getEntryEntity("treeentryentity");
        String sourceType = StringUtils.equals((CharSequence)"pmas_inbudget", (CharSequence)this.getView().getFormShowParameter().getFormId()) ? "IN" : "OUT";
        ProBudgetControlHelper.dealCtrlDetailToTree((DynamicObjectCollection)curDetails, (Long)projectId, (String)sourceType);
        if (lastEntries != null && !lastEntries.isEmpty()) {
            ProBudgetControlHelper.synCtrlDetailToBill((DynamicObjectCollection)curDetails, (DynamicObjectCollection)lastEntries, (boolean)isAdjust);
        }
        if (!curDetails.isEmpty()) {
            curDetails.sort(Comparator.comparing(o -> o.getString("budgetitemnum")));
        }
        this.getModel().updateEntryCache(curDetails);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        treeEntryGrid.setCollapse(false);
        this.getView().updateView("treeentryentity");
    }
}

