/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.formplugin.budget;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmas.formplugin.base.AbstractPmasBillPlugin;
import kd.pmgt.pmbs.common.enums.BudgetCtlModeEnum;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.DimShareType;
import kd.pmgt.pmbs.common.enums.SplitTypeEnum;
import kd.pmgt.pmbs.common.utils.TimeUtils;

public class OutBudgetEditPlugin
extends AbstractPmasBillPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(OutBudgetEditPlugin.class);

    public void afterCreateNewData(EventObject e) {
        Object adjustId = this.getView().getFormShowParameter().getCustomParam("adjustId");
        if (adjustId != null) {
            DynamicObject oldObj = BusinessDataServiceHelper.loadSingle((Object)adjustId, (String)"pmas_outbudget");
            this.getModel().setValue("splittype", (Object)oldObj.getString("splittype"));
            this.getModel().setValue("budgetcontrolmode", oldObj.get("budgetcontrolmode"));
            this.getModel().setValue("projectcostcontrol", oldObj.get("projectcostcontrol"));
            this.getModel().setValue("projectapplydate", oldObj.get("projectapplydate"));
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            if (project == null) {
                return;
            }
            QFilter qFilter = new QFilter("project", "=", project.getPkValue());
            qFilter.and(new QFilter("isvalid", "=", (Object)Boolean.TRUE));
            DynamicObject budgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (QFilter[])new QFilter[]{qFilter});
            if (budgetRecord != null) {
                DynamicObjectCollection realInfoEntry = budgetRecord.getDynamicObjectCollection("realbudgetentry");
                DynamicObjectCollection controlInfoEntry = this.getModel().getEntryEntity("controlinfoentry");
                DynamicObjectType dynamicObjectType = controlInfoEntry.getDynamicObjectType();
                BigDecimal afterSum = realInfoEntry.stream().map(dyn -> dyn.getBigDecimal("realundertakeamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                String sourceType = BudgetSourceTypeEnum.OUT.getValue();
                QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
                QFilter sourceTypeFilter = new QFilter("sourcetype", "=", (Object)sourceType);
                DynamicObject[] projectBudgets = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)"number,name,parent,currency", (QFilter[])new QFilter[]{projectFilter, sourceTypeFilter});
                HashMap<String, Object> projectBudgetMap = new HashMap<String, Object>(10);
                for (DynamicObject projectBudget : projectBudgets) {
                    projectBudgetMap.put(projectBudget.getString("name"), projectBudget.getPkValue());
                }
                for (DynamicObject realInfo : realInfoEntry) {
                    DynamicObject controlInfo = new DynamicObject(dynamicObjectType);
                    controlInfo.set("ctrlbudgetitem", realInfo.get("realbudgetitem"));
                    controlInfo.set("ctrlbudgetitemname", realInfo.get("realprobudgetname"));
                    String proBudgetName = realInfo.getString("realprobudgetname");
                    controlInfo.set("ctrlprobudgetitem", projectBudgetMap.get(proBudgetName));
                    controlInfo.set("undertakeorg", realInfo.get("realundertakeorg"));
                    controlInfo.set("undertakeperiod", realInfo.get("realundertakeperiod"));
                    BigDecimal underTakeAmt = realInfo.getBigDecimal("realundertakeamt");
                    controlInfo.set("beforeamt", (Object)underTakeAmt);
                    controlInfo.set("currentamt", (Object)underTakeAmt);
                    if (afterSum.compareTo(BigDecimal.ZERO) > 0) {
                        controlInfo.set("beforeratio", (Object)underTakeAmt.divide(afterSum, 10, RoundingMode.HALF_UP).multiply(new BigDecimal(100)));
                        controlInfo.set("currentratio", (Object)underTakeAmt.divide(afterSum, 10, RoundingMode.HALF_UP).multiply(new BigDecimal(100)));
                    }
                    controlInfo.set("entryproname", realInfo.get("realproname"));
                    controlInfo.set("entrypronumber", realInfo.get("realpronumber"));
                    Object realProNumber = realInfo.get("realpronumber");
                    if (realProNumber == null || StringUtils.isEmpty((CharSequence)realProNumber.toString())) {
                        realProNumber = 0L;
                    }
                    controlInfo.set("entryproid", realProNumber);
                    controlInfo.set("thisnew", (Object)"0");
                    controlInfoEntry.add((Object)controlInfo);
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.controlBudgetItemMustInput();
        this.setControlinfoentryVisible();
    }

    protected void controlBudgetItemMustInput() {
        String splitType = this.getModel().getDataEntity().getString("splittype");
        String budgetcontrolmode = this.getModel().getDataEntity().getString("budgetcontrolmode");
        BasedataEdit ctrlbudgetitem = (BasedataEdit)this.getControl("ctrlbudgetitem");
        TextEdit ctrlbudgetitemname = (TextEdit)this.getControl("ctrlbudgetitemname");
        TextEdit entryproname = (TextEdit)this.getControl("entryproname");
        if (ctrlbudgetitem != null) {
            ctrlbudgetitem.setMustInput(false);
        }
        if (ctrlbudgetitemname != null) {
            ctrlbudgetitemname.setMustInput(false);
        }
        if (entryproname != null) {
            entryproname.setMustInput(false);
        }
        if (StringUtils.equals((CharSequence)SplitTypeEnum.BUDGETAMTSPLIT.getValue(), (CharSequence)splitType) && ctrlbudgetitemname != null) {
            ctrlbudgetitemname.setMustInput(true);
        }
        if (StringUtils.equals((CharSequence)SplitTypeEnum.SUMSPLIT.getValue(), (CharSequence)splitType) && ctrlbudgetitem != null) {
            ctrlbudgetitem.setMustInput(true);
        }
        if (StringUtils.equals((CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue(), (CharSequence)budgetcontrolmode) && entryproname != null) {
            entryproname.setMustInput(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)"deletecontrolinfoentry", (CharSequence)operateKey)) {
            int[] selectRows;
            EntryGrid controlInfoEntryGrid = (EntryGrid)this.getControl("controlinfoentry");
            for (int i : selectRows = controlInfoEntryGrid.getSelectRows()) {
                Boolean thisnew = (Boolean)model.getValue("thisnew", i);
                if (thisnew.booleanValue()) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u5220\u9664\u975e\u672c\u6b21\u65b0\u589e\u7684\u9884\u7b97\u63a7\u5236\u4fe1\u606f\u3002", (String)"OutBudgetEditPlugin_0", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((CharSequence)"summarybudget", (CharSequence)operateKey)) {
            int budgetRowCount = model.getEntryRowCount("treeentryentity");
            if (budgetRowCount > 0) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6c47\u603b\u9884\u7b97\u5c06\u91cd\u65b0\u8ba1\u7b97\u201c\u9884\u7b97\u660e\u7ec6\u91d1\u989d\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OutBudgetEditPlugin_1", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("summarybudget"));
            } else {
                DynamicObjectCollection controlInfoEntry = model.getEntryEntity("controlinfoentry");
                this.mergeToBudgetEntry(controlInfoEntry, null, false);
            }
        } else if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey) || StringUtils.equals((CharSequence)"submit", (CharSequence)operateKey)) {
            DynamicObject dataEntity = model.getDataEntity();
            String budgetControlMode = dataEntity.getString("budgetcontrolmode");
            if (!StringUtils.equals((CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue(), (CharSequence)budgetControlMode) && !StringUtils.equals((CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue(), (CharSequence)budgetControlMode)) {
                return;
            }
            this.setRealBudgetEntry(model, dataEntity, args);
        }
    }

    private void setRealBudgetEntry(IDataModel model, DynamicObject dataEntity, BeforeDoOperationEventArgs args) {
        model.deleteEntryData("realbudgetentry");
        String splitType = dataEntity.getString("splittype");
        if (StringUtils.equals((CharSequence)SplitTypeEnum.TOTALAMTSPLIT.getValue(), (CharSequence)splitType)) {
            return;
        }
        DynamicObjectCollection controlInfoEntryCol = model.getEntryEntity("controlinfoentry");
        for (DynamicObject controlInfo : controlInfoEntryCol) {
            DynamicObject budgetitem = controlInfo.getDynamicObject("ctrlbudgetitem");
            String ctrloutItemName = controlInfo.getString("ctrlbudgetitemname");
            DynamicObject undertakeOrg = controlInfo.getDynamicObject("undertakeorg");
            Date undertakePeriod = controlInfo.getDate("undertakeperiod");
            long entryproid = controlInfo.getLong("entryproid");
            BigDecimal realundertakeamt = controlInfo.getBigDecimal("currentamt");
            BigDecimal realbeforeamt = controlInfo.getBigDecimal("beforeamt");
            if (this.checkIsRepeat(controlInfo, budgetitem, realbeforeamt, realundertakeamt)) continue;
            int rowIndex = model.createNewEntryRow("realbudgetentry");
            model.setValue("realbudgetitem", (Object)budgetitem, rowIndex);
            model.setValue("realprobudgetname", (Object)ctrloutItemName, rowIndex);
            model.setValue("realundertakeorg", (Object)undertakeOrg, rowIndex);
            model.setValue("realundertakeperiod", (Object)undertakePeriod, rowIndex);
            model.setValue("realproname", controlInfo.get("entryproname"), rowIndex);
            model.setValue("realpronumber", controlInfo.get("entrypronumber"), rowIndex);
            model.setValue("realproid", (Object)entryproid, rowIndex);
            model.setValue("realundertakeamt", (Object)realundertakeamt, rowIndex);
            model.setValue("realbeforeamt", (Object)realbeforeamt, rowIndex);
        }
        this.getView().updateView("realbudgetentry");
    }

    private boolean checkIsRepeat(DynamicObject controlInfo, DynamicObject budgetitem, BigDecimal realBeforeAmt, BigDecimal realUnderTakeAmt) {
        boolean isContinue = false;
        int rowCount = this.getModel().getEntryRowCount("realbudgetentry");
        for (int i = 0; i < rowCount; ++i) {
            Integer realundertakeorgPK;
            Object budgetitemPK = budgetitem == null ? Integer.valueOf(0) : budgetitem.getPkValue();
            Integer undertakeOrgPK = controlInfo.getDynamicObject("undertakeorg") == null ? Integer.valueOf(0) : controlInfo.getDynamicObject("undertakeorg").getPkValue();
            Date ndertakePeriod = controlInfo.getDate("undertakeperiod");
            Long entryproid = controlInfo.getLong("entryproid");
            Integer realbudgetitemPK = this.getModel().getValue("realbudgetitem", i) == null ? Integer.valueOf(0) : ((DynamicObject)this.getModel().getValue("realbudgetitem", i)).getPkValue();
            Integer n = realundertakeorgPK = this.getModel().getValue("realundertakeorg", i) == null ? Integer.valueOf(0) : ((DynamicObject)this.getModel().getValue("realundertakeorg", i)).getPkValue();
            if (budgetitemPK != realbudgetitemPK || undertakeOrgPK != realundertakeorgPK || !TimeUtils.isSameMonth((Date)ndertakePeriod, (Date)((Date)this.getModel().getValue("realundertakeperiod", i))) || !entryproid.equals(this.getModel().getValue("realproid", i))) continue;
            this.getModel().setValue("realbeforeamt", (Object)((BigDecimal)this.getModel().getValue("realbeforeamt", i)).add(realBeforeAmt), i);
            this.getModel().setValue("realundertakeamt", (Object)((BigDecimal)this.getModel().getValue("realundertakeamt", i)).add(realUnderTakeAmt), i);
            isContinue = true;
        }
        return isContinue;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key;
        super.confirmCallBack(messageBoxClosedEvent);
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult()) && StringUtils.equals((CharSequence)"summarybudget", (CharSequence)(key = messageBoxClosedEvent.getCallBackId()))) {
            DynamicObjectCollection budgetEntryCol = this.getModel().getEntryEntity("treeentryentity");
            ArrayList<Integer> needDelSelRows = new ArrayList<Integer>();
            HashMap<String, BigDecimal> budgetTotalAmtMap = new HashMap<String, BigDecimal>(16);
            for (int i = 0; i < budgetEntryCol.size(); ++i) {
                DynamicObject budgetEntry = (DynamicObject)budgetEntryCol.get(i);
                boolean isPres = budgetEntry.getBoolean("ispres");
                boolean isPrev = budgetEntry.getBoolean("isprev");
                boolean isTotal = budgetEntry.getBoolean("istotal");
                if (!(isPres || isPrev || isTotal)) {
                    needDelSelRows.add(i);
                }
                budgetTotalAmtMap.put(budgetEntry.getString("budgetitemnum"), budgetEntry.getBigDecimal("itemtotalamount"));
            }
            int[] delRowArr = needDelSelRows.stream().mapToInt(Integer::intValue).toArray();
            this.getModel().deleteEntryRows("treeentryentity", delRowArr);
            this.getModel().updateCache();
            DynamicObjectCollection controlInfoEntry = this.getModel().getEntryEntity("controlinfoentry");
            this.mergeToBudgetEntry(controlInfoEntry, budgetTotalAmtMap, true);
        }
    }

    private void setControlinfoentryVisible() {
        String splittype = (String)this.getModel().getValue("splittype");
        if (SplitTypeEnum.BUDGETAMTSPLIT.getValue().equals(splittype)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"ctrlbudgetitem"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"ctrlbudgetitemname"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"undertakeorg"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"undertakeperiod"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"beforeamt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"beforeratio"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"currentamt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"currentratio"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"differenceamt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"controlinfocommon"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"summarybudget"});
        } else if (SplitTypeEnum.SUMSPLIT.getValue().equals(splittype)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"ctrlbudgetitem"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ctrlbudgetitemname"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"undertakeorg"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"undertakeperiod"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"beforeamt"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"beforeratio"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"currentamt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"currentratio"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"differenceamt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"controlinfocommon"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"summarybudget"});
        }
        String budgetcontrolmode = (String)this.getModel().getValue("budgetcontrolmode");
        if (BudgetCtlModeEnum.CONTROLANDADJUST.getValue().equals(budgetcontrolmode)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"entryproname"});
        } else if (BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue().equals(budgetcontrolmode)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryproname"});
        }
    }

    private void mergeToBudgetEntry(DynamicObjectCollection controlInfoEntryCol, Map<String, BigDecimal> budgetTotalAmtMap, boolean needReFull) {
        DynamicObjectCollection budgetEntryCol = this.getModel().getEntryEntity("treeentryentity");
        DynamicObjectType budgetEntryType = budgetEntryCol.getDynamicObjectType();
        BigDecimal totalAllAmt = BigDecimal.ZERO;
        HashMap<String, BigDecimal> budgetAmtMap = new HashMap<String, BigDecimal>();
        for (int i = 0; i < controlInfoEntryCol.size(); ++i) {
            BigDecimal ctrlCurrentAmt;
            DynamicObject controlInfoEntry = (DynamicObject)controlInfoEntryCol.get(i);
            DynamicObject ctrlBudgetItem = controlInfoEntry.getDynamicObject("ctrlbudgetitem");
            if (ctrlBudgetItem == null) continue;
            if (!budgetAmtMap.containsKey(ctrlBudgetItem.getString("id"))) {
                ctrlCurrentAmt = controlInfoEntry.getBigDecimal("currentamt");
                budgetAmtMap.put(ctrlBudgetItem.getString("id"), ctrlCurrentAmt);
                continue;
            }
            ctrlCurrentAmt = (BigDecimal)budgetAmtMap.get(ctrlBudgetItem.getString("id"));
            ctrlCurrentAmt = ctrlCurrentAmt.add(controlInfoEntry.getBigDecimal("currentamt"));
            budgetAmtMap.put(ctrlBudgetItem.getString("id"), ctrlCurrentAmt);
        }
        for (Map.Entry entry : budgetAmtMap.entrySet()) {
            BigDecimal totalAmt = (BigDecimal)entry.getValue();
            totalAllAmt = totalAllAmt.add(totalAmt);
            boolean isExist = false;
            for (int i = 0; i < budgetEntryCol.size(); ++i) {
                DynamicObject budgetEntryObj = (DynamicObject)budgetEntryCol.get(i);
                DynamicObject budgetItem = budgetEntryObj.getDynamicObject("budgetitem");
                if (budgetItem == null || !StringUtils.equals((CharSequence)budgetItem.getString("id"), (CharSequence)((CharSequence)entry.getKey()))) continue;
                isExist = true;
                budgetEntryObj.set("budgetamount", (Object)totalAmt);
                boolean isPres = budgetEntryObj.getBoolean("ispres");
                boolean isPrev = budgetEntryObj.getBoolean("isprev");
                if (isPres) {
                    BigDecimal siAmount = budgetEntryObj.getBigDecimal("siamount");
                    budgetEntryObj.set("sichangeamount", (Object)totalAmt.subtract(siAmount));
                }
                if (!isPrev) continue;
                BigDecimal viAmount = budgetEntryObj.getBigDecimal("viamount");
                budgetEntryObj.set("vichangeamount", (Object)totalAmt.subtract(viAmount));
            }
            if (isExist) continue;
            DynamicObject newBudgetEntry = new DynamicObject(budgetEntryType);
            ORM orm = ORM.create();
            long entryId = orm.genLongId((IDataEntityType)budgetEntryType);
            newBudgetEntry.set("id", (Object)entryId);
            DynamicObject budgetItem = BusinessDataServiceHelper.loadSingle(entry.getKey(), (String)"pmbs_budgetitem");
            newBudgetEntry.set("budgetitem", (Object)budgetItem);
            newBudgetEntry.set("budgetamount", (Object)totalAmt);
            if (needReFull) {
                newBudgetEntry.set("budgetitemnum", (Object)budgetItem.getString("number"));
                newBudgetEntry.set("itemtotalamount", (Object)budgetTotalAmtMap.get(budgetItem.getString("number")));
            }
            newBudgetEntry.set("budgetitemname", (Object)budgetItem.getString("name"));
            newBudgetEntry.set("vichangeamount", (Object)totalAmt);
            budgetEntryCol.add((Object)newBudgetEntry);
        }
        this.getModel().updateEntryCache(budgetEntryCol);
        this.getView().updateView("treeentryentity");
        this.getModel().setValue("totalamount", (Object)totalAllAmt);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (StringUtils.equals((CharSequence)"currentamt", (CharSequence)propName)) {
            this.calCurrentratio();
        } else if (StringUtils.equals((CharSequence)"project", (CharSequence)propName)) {
            DynamicObject proApproval = this.getProApproval();
            if (proApproval == null) {
                return;
            }
            this.getModel().setValue("projectapplydate", proApproval.get("projectapplydate"));
            this.getModel().setValue("splittype", proApproval.get("splittype"));
            this.getModel().setValue("budgetcontrolmode", proApproval.get("budgetcontrolmode"));
            this.getModel().setValue("projectcostcontrol", proApproval.get("projectcostcontrol"));
        } else if (StringUtils.equals((CharSequence)"budgetstage", (CharSequence)propName)) {
            Object newValue = changeSet[0].getNewValue();
            if (newValue != null) {
                DynamicObject pro = this.getModel().getDataEntity().getDynamicObject("project");
                DynamicObject[] existedProBudgets = this.isExistBudgetCurProject(pro);
                if (existedProBudgets != null && existedProBudgets.length > 0) {
                    DynamicObject preBudget = BusinessDataServiceHelper.loadSingle((Object)existedProBudgets[0].getPkValue(), (String)"pmas_outbudget");
                    Date preBudgetDate = preBudget.getDate("year");
                    Date budgetDate = (Date)this.getModel().getValue("year");
                    if (preBudgetDate == null || budgetDate == null) {
                        return;
                    }
                    int curYear = budgetDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
                    int preYear = preBudgetDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
                    DynamicObjectCollection oldControlInfoEntry = preBudget.getDynamicObjectCollection("controlinfoentry");
                    DynamicObjectCollection controlInfoEntry = this.getModel().getEntryEntity("controlinfoentry");
                    DynamicObjectType dynamicObjectType = controlInfoEntry.getDynamicObjectType();
                    for (DynamicObject oldControlInfo : oldControlInfoEntry) {
                        DynamicObject controlInfo = new DynamicObject(dynamicObjectType);
                        controlInfo.set("ctrlbudgetitem", oldControlInfo.get("ctrlbudgetitem"));
                        controlInfo.set("ctrlbudgetitemname", oldControlInfo.get("ctrlbudgetitemname"));
                        controlInfo.set("ctrlprobudgetitem", oldControlInfo.get("ctrlprobudgetitem"));
                        controlInfo.set("undertakeorg", oldControlInfo.get("undertakeorg"));
                        controlInfo.set("undertakeperiod", oldControlInfo.get("undertakeperiod"));
                        if (curYear == preYear) {
                            controlInfo.set("beforeamt", oldControlInfo.get("currentamt"));
                            controlInfo.set("currentamt", oldControlInfo.get("currentamt"));
                        }
                        controlInfo.set("beforeratio", oldControlInfo.get("currentratio"));
                        controlInfo.set("currentratio", oldControlInfo.get("currentratio"));
                        controlInfo.set("entryproname", oldControlInfo.get("entryproname"));
                        controlInfo.set("entrypronumber", oldControlInfo.get("entrypronumber"));
                        controlInfo.set("entryproid", oldControlInfo.get("entryproid"));
                        controlInfo.set("controlinfocommon", oldControlInfo.get("controlinfocommon"));
                        controlInfo.set("thisnew", (Object)"0");
                        controlInfoEntry.add((Object)controlInfo);
                    }
                    this.getModel().updateEntryCache(controlInfoEntry);
                    this.getView().updateView("controlinfoentry");
                }
            } else {
                this.getModel().deleteEntryData("controlinfoentry");
                this.getModel().deleteEntryData("realbudgetentry");
            }
        }
    }

    private void calCurrentratio() {
        BigDecimal oneHundred;
        DynamicObjectCollection controlInfoEntry = this.getModel().getEntryEntity("controlinfoentry");
        BigDecimal sum = controlInfoEntry.stream().map(dyn -> dyn.getBigDecimal("currentamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        this.getModel().beginInit();
        for (int i = 0; i < controlInfoEntry.size(); ++i) {
            BigDecimal underTakeAmt = (BigDecimal)this.getModel().getValue("currentamt", i);
            if (sum.compareTo(BigDecimal.ZERO) == 0) {
                this.getModel().setValue("currentratio", (Object)BigDecimal.ZERO, i);
                continue;
            }
            this.getModel().setValue("currentratio", (Object)underTakeAmt.divide(sum, 10, RoundingMode.HALF_UP).multiply(new BigDecimal(100)), i);
        }
        BigDecimal ratioSum = controlInfoEntry.stream().map(dyn -> dyn.getBigDecimal("currentratio")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        if (ratioSum.compareTo(oneHundred = new BigDecimal("100")) != 0 && sum.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal balance = oneHundred.subtract(ratioSum);
            BigDecimal underTakeRatio = (BigDecimal)this.getModel().getValue("currentratio", controlInfoEntry.size() - 1);
            underTakeRatio = underTakeRatio.add(balance);
            this.getModel().setValue("currentratio", (Object)underTakeRatio, controlInfoEntry.size() - 1);
        }
        this.getModel().endInit();
        this.getView().updateView("controlinfoentry");
    }

    public static Map<String, BigDecimal> getTreeEntryEntityRoot(DynamicObjectCollection entrys) {
        HashMap<String, BigDecimal> rootMap = new HashMap<String, BigDecimal>(16);
        for (DynamicObject entry : entrys) {
            String parentId = entry.getString("pid");
            String budgetitemname = entry.getString("budgetitemname");
            if (!StringUtils.equals((CharSequence)"0", (CharSequence)parentId) || budgetitemname == null || budgetitemname.trim().isEmpty()) continue;
            BigDecimal budgetamount = entry.getBigDecimal("budgetamount");
            rootMap.put(budgetitemname, budgetamount);
        }
        return rootMap;
    }

    private DynamicObject[] isExistBudgetCurProject(DynamicObject project) {
        QFilter proFilter = new QFilter("project", "=", project.getPkValue());
        QFilter typeFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
        QFilter validFilter = new QFilter("isvalid", "=", (Object)"1");
        DynamicObject[] existedProBudgets = BusinessDataServiceHelper.load((String)"pmas_budget", (String)"id", (QFilter[])new QFilter[]{proFilter, typeFilter, validFilter}, (String)"budgetstage.seqno", (int)1);
        return existedProBudgets;
    }

    protected DynamicObject getProApproval() {
        Long projectId = (Long)this.getModel().getValue("project_id");
        if (projectId == 0L) {
            return null;
        }
        QFilter projectIdFilter = new QFilter("pro", "=", (Object)projectId);
        DynamicObject proApproval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"budgetcontrolmode,projectcostcontrol,splittype,projectapplydate", (QFilter[])new QFilter[]{projectIdFilter});
        return proApproval;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit ctrlBudgetItemName = (TextEdit)this.getView().getControl("ctrlbudgetitemname");
        ctrlBudgetItemName.addButtonClickListener((ClickListener)this);
        TextEdit entryproname = (TextEdit)this.getView().getControl("entryproname");
        entryproname.addButtonClickListener((ClickListener)this);
        BasedataEdit ctrlBudgetItem = (BasedataEdit)this.getControl("ctrlbudgetitem");
        ctrlBudgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        int selectRow = c.getModel().getEntryCurrentRowIndex("controlinfoentry");
        if (StringUtils.equals((CharSequence)"ctrlbudgetitemname", (CharSequence)key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("pmas_selectbudgetentry");
            showParameter.setCustomParam("key_formId", (Object)"pmas_outbudget");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ctrlbudgetitemname"));
            this.getView().showForm(showParameter);
        } else if (StringUtils.equals((CharSequence)"entryproname", (CharSequence)key)) {
            DynamicObject undertakeOrg = (DynamicObject)this.getModel().getValue("undertakeorg", selectRow);
            if (undertakeOrg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u627f\u62c5\u7ec4\u7ec7\u3002", (String)"OutBudgetEditPlugin_2", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("formId", "eb_sharedimensiontreef7");
            DynamicObject obj = this.getModel().getDataEntity(true);
            String formId = obj.getDynamicObjectType().getName();
            DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(obj.getDynamicObjectType());
            DcJsonSerializer dcJsonSerializer = new DcJsonSerializer((DcBinder)binder);
            dcJsonSerializer.setIsLocaleValueFull(true);
            binder.setOnlyDbProperty(false);
            String serializeObjStr = dcJsonSerializer.serializeToString((Object)obj, null);
            map.put("dynamicObject", serializeObjStr);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
            showParameter.setCustomParam("billNumber", (Object)formId);
            showParameter.setCustomParam("fieldNumber", (Object)"controlinfoentry.entryproname");
            showParameter.setCustomParam("ischeckData", (Object)Boolean.TRUE);
            showParameter.setCustomParam("isMul", (Object)Boolean.FALSE);
            logger.info("\u652f\u51fa\u9884\u7b97\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u9009\u62e9\u9884\u7b97\u9879\u76ee\u63a5\u53e3\u53c2\u6570billNumber\uff1a{}\uff0cdynamicObject\uff1a{}\uff0cserializeObjStr\uff1a{}", new Object[]{formId, obj, serializeObjStr});
            ArrayList budgetMapList = new ArrayList(10);
            HashMap<String, String> budgetFilterMap = new HashMap<String, String>(16);
            budgetFilterMap.put("key", "controlinfoentry.undertakeorg");
            budgetFilterMap.put("value", undertakeOrg.getString("number"));
            budgetFilterMap.put("type", DimShareType.BASEDATA.getIndex());
            budgetFilterMap.put("dimtype", DimShareType.BUDGETDIM.getIndex());
            budgetMapList.add(budgetFilterMap);
            String budgetFilterJson = SerializationUtils.toJsonString(budgetMapList);
            showParameter.setCustomParam("budgetfilter", (Object)budgetFilterJson);
            logger.info("\u652f\u51fa\u9884\u7b97\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u9009\u62e9\u9884\u7b97\u9879\u76ee\u63a5\u53e3\u9884\u7b97\u6570\u8fc7\u6ee4\uff1a{}\uff0cserializeObjStr\uff1a{}", budgetMapList, (Object)budgetFilterJson);
            ArrayList powerMapList = new ArrayList(16);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org", selectRow);
            if (org != null) {
                HashMap<String, String> powerFilterMap = new HashMap<String, String>(16);
                powerFilterMap.put("key", "org");
                powerFilterMap.put("value", org.getString("number"));
                powerFilterMap.put("type", DimShareType.BASEDATA.getIndex());
                powerFilterMap.put("dimtype", DimShareType.BUDGETDIM.getIndex());
                powerMapList.add(powerFilterMap);
            }
            if (budgetMapList.size() > 0) {
                String powerFilterJson = SerializationUtils.toJsonString(powerMapList);
                showParameter.setCustomParam("relation", (Object)powerFilterJson);
                logger.info("\u652f\u51fa\u9884\u7b97\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u9009\u62e9\u9884\u7b97\u9879\u76ee\u63a5\u53e3\u4e1a\u52a1\u7ec4\u7ec7\u8fc7\u6ee4\uff1a{}\uff0cserializeObjStr\uff1a{}", powerMapList, (Object)powerFilterJson);
            }
            CloseCallBack ccb = new CloseCallBack((IFormPlugin)this, "selectProject");
            showParameter.setCloseCallBack(ccb);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss css = new StyleCss();
            showParameter.getOpenStyle().setInlineStyleCss(css);
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)"ctrlbudgetitemname", (CharSequence)actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null) {
                int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("controlinfoentry");
                DynamicObject entryEntity = (DynamicObject)returnData;
                this.getModel().setValue("ctrlbudgetitem", entryEntity.get("budgetitem"), entryCurrentRowIndex);
                this.getModel().setValue("ctrlprobudgetitem", entryEntity.get("probudgetitem"), entryCurrentRowIndex);
                this.getModel().setValue("ctrlbudgetitemname", entryEntity.get("probudgetitemname"), entryCurrentRowIndex);
            }
        } else if (StringUtils.equals((CharSequence)"selectProject", (CharSequence)actionId)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (returnData == null || returnData.isEmpty()) {
                return;
            }
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("controlinfoentry");
            ListSelectedRow row = returnData.get(0);
            this.getModel().setValue("entrypronumber", (Object)row.getNumber(), entryCurrentRowIndex);
            this.getModel().setValue("entryproname", (Object)row.getName(), entryCurrentRowIndex);
            this.getModel().setValue("entryproid", row.getPrimaryKeyValue(), entryCurrentRowIndex);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        DynamicObjectCollection treeentryentity;
        List entryIds;
        DynamicObject[] settings;
        super.beforeF7Select(e);
        String name = e.getProperty().getName();
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (StringUtils.equals((CharSequence)"ctrlbudgetitem", (CharSequence)name) && project != null && (settings = BusinessDataServiceHelper.load((String)"pmbs_prokindctrlsetting", (String)"outtreeentryentity.outbudgetitem,intreeentryentity.inbudgetitem", (QFilter[])new QFilter[]{new QFilter("projectkind", "=", project.getDynamicObject("group").getPkValue())})).length > 0 && (entryIds = (treeentryentity = settings[0].getDynamicObjectCollection("outtreeentryentity")).stream().map(o -> o.getDynamicObject("outbudgetitem").getPkValue()).collect(Collectors.toList())).size() > 0) {
            param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", entryIds));
        }
    }
}

