/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.formplugin.pro;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.ZoneId;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmas.business.helper.ApprovalAmtModifyHelper;
import kd.pmgt.pmas.formplugin.base.AbstractPmasBillPlugin;
import kd.pmgt.pmbs.business.helper.ProjectInitiationHelper;
import kd.pmgt.pmbs.common.enums.BudgetCtlModeEnum;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.SplitTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmbs.common.utils.TextHelper;

public class ApprovalAmtModifyEditPlugin
extends AbstractPmasBillPlugin {
    private static final String OPERATE_VIEW_BUDGET_BALANCE = "viewbudgetbalance";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object year = this.getModel().getValue("year");
        if (year == null) {
            this.getModel().setValue("year", (Object)new Date());
        }
        DateEdit yearEdit = (DateEdit)this.getView().getControl("year");
        Date initDate = DateUtil.getYearStartTime((Date)new Date());
        yearEdit.setMinDate(DateUtil.getBeforeOrNextYearDate((Date)initDate, (boolean)false, (int)1));
        yearEdit.setMaxDate(DateUtil.getBeforeOrNextYearDate((Date)initDate, (boolean)true, (int)3));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String projectId = (String)formShowParameter.getCustomParam("projectId");
        String orgId = (String)formShowParameter.getCustomParam("orgId");
        if (StringUtils.isNotEmpty((CharSequence)projectId) && QueryServiceHelper.exists((String)"bd_project", (Object)projectId)) {
            if (StringUtils.isNotEmpty((CharSequence)orgId)) {
                this.getModel().beginInit();
                this.getModel().setValue("org", (Object)Long.parseLong(orgId));
                this.getModel().endInit();
            }
            DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"bd_project");
            this.getModel().setValue("project", (Object)project);
        }
        this.setViewEvents();
    }

    protected void setViewEvents() {
        int rowSize = this.getModel().getEntryRowCount("fundsourceentry");
        if (rowSize > 0) {
            this.setAmountEnable(false);
        }
        String splitType = (String)this.getModel().getValue("splittype");
        ApprovalAmtModifyHelper.setFieldMustInputAndDateMask((String)splitType, (IFormView)this.getView());
        int rowIndex = 0;
        DynamicObjectCollection controlEntries = this.getModel().getEntryEntity("controlinfoentry");
        for (DynamicObject controlInfo : controlEntries) {
            if (!controlInfo.getBoolean("isentryadd")) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"ctrloutitem", "ctrloutitemname", "undertakeorg", "undertakeperiod", "entryproname"});
            }
            ++rowIndex;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "addcontrolinfoentry": {
                String controlMode = (String)this.getModel().getValue("splittype");
                if (!SplitTypeEnum.BUDGETAMTSPLIT.getValue().equalsIgnoreCase(controlMode)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u63a7\u5236\u65b9\u5f0f\u4e3a\u6309\u9884\u7b97\u9879\u91d1\u989d\u5206\u644a\u65f6\uff0c\u4e0d\u80fd\u65b0\u589e\u9884\u7b97\u9879\u3002", (String)"ApprovalAmtModifyEditPlugin_0", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "deletecontrolinfoentry": {
                DynamicObject row;
                int rowIndex = this.getModel().getEntryCurrentRowIndex("controlinfoentry");
                if (rowIndex == -1 || (row = this.getModel().getEntryRowEntity("controlinfoentry", rowIndex)) == null || row.getBoolean("isentryadd")) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5220\u9664\u624b\u5de5\u589e\u52a0\u7684\u884c\uff0c\u4e0d\u80fd\u5220\u9664\u8001\u6570\u636e\uff0c\u5efa\u8bae\u5c06\u201c\u53d8\u66f4\u540e\u627f\u62c5\u91d1\u989d\u201d\u8bbe\u7f6e\u4e3a0\u3002", (String)"ApprovalAmtModifyEditPlugin_1", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "viewkanban": {
                DynamicObject project = (DynamicObject)this.getModel().getValue("project");
                if (project == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u3002", (String)"ApprovalAmtModifyEditPlugin_2", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                QFilter qFilter = new QFilter("pro", "=", project.getPkValue());
                DynamicObject projectApproval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (QFilter[])new QFilter[]{qFilter});
                if (projectApproval == null) break;
                HashMap<String, Object> custormMap = new HashMap<String, Object>(10);
                custormMap.put("proAppId", projectApproval.getPkValue());
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("formId", "pmba_projectkanban");
                map.put("customParams", custormMap);
                FormShowParameter showParameter = BillShowParameter.createFormShowParameter(map);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(showParameter);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "deleteentry": {
                int rowSize = this.getModel().getEntryRowCount("fundsourceentry");
                if (rowSize == 0) {
                    this.setAmountEnable(true);
                }
                this.setFundSourceEntryScale();
                this.sumToProYearAmount();
                break;
            }
            case "newentry": {
                int rowSize = this.getModel().getEntryRowCount("fundsourceentry");
                if (rowSize <= 0) break;
                this.setAmountEnable(false);
                break;
            }
            case "viewbudgetbalance": {
                Object pkValue = this.getModel().getDataEntity().getPkValue();
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("formId", "eb_bgavailbalance");
                paramMap.put("pkId", pkValue.toString());
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
                break;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String property = e.getKey();
        Object newValue = e.getValue();
        switch (property) {
            case "modifybillno": {
                String newBillNo;
                boolean isExists;
                if (newValue == null) break;
                String budgetControlMode = (String)this.getModel().getValue("budgetcontrolmode");
                if (!StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.NOTCONTROL.getValue()) && TextHelper.containChinese((String)((String)newValue))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u53d7\u4f01\u4e1a\u9884\u7b97\u63a7\u5236\u65b9\u5f0f\u4e3a\u53d7\u63a7\u65f6\uff0c\u7acb\u9879\u7f16\u7801\u53d8\u66f4\u4e0d\u80fd\u5305\u542b\u4e2d\u6587\u3002", (String)"ApprovalAmtModifyEditPlugin_3", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    this.getView().updateView(property);
                }
                if (!(isExists = QueryServiceHelper.exists((String)"pmas_pro_approval", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)(newBillNo = (String)newValue))})) || !QueryServiceHelper.exists((String)"bd_project", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)newBillNo)})) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u7acb\u9879\u5355\u6216\u9879\u76ee\u5df2\u5b58\u5728\u8be5\u7f16\u7801\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\u3002", (String)"ApprovalAmtModifyEditPlugin_4", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(property);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeSet = e.getChangeSet()[0];
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String name = e.getProperty().getName();
        Object newValue = changeSet.getNewValue();
        switch (name) {
            case "project": {
                this.projectChanged(newValue);
                break;
            }
            case "fundsumamount": {
                this.setFundSourceEntryScale();
                break;
            }
            case "fundamount": {
                this.sumToProYearAmount();
                break;
            }
            case "afterundertakeamt": {
                BigDecimal afterUnderTakeAmt = newValue != null ? (BigDecimal)newValue : BigDecimal.ZERO;
                BigDecimal underTakeAmt = (BigDecimal)this.getModel().getValue("undertakeamt", rowIndex);
                this.getModel().setValue("differundertakeamt", (Object)afterUnderTakeAmt.subtract(underTakeAmt), rowIndex);
                DynamicObjectCollection controlEntries = this.getModel().getEntryEntity("controlinfoentry");
                BigDecimal sumAmount = controlEntries.stream().map(obj -> obj.getBigDecimal("afterundertakeamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                if (sumAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                for (DynamicObject entry : controlEntries) {
                    BigDecimal afterUnderTakeAmount = entry.getBigDecimal("afterundertakeamt");
                    entry.set("undertakeratio", (Object)afterUnderTakeAmount.divide(sumAmount, 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)));
                }
                this.getModel().updateEntryCache(controlEntries);
                this.getView().updateView("controlinfoentry");
                break;
            }
            case "splittype": {
                String splitType = (String)this.getModel().getValue("splittype");
                if (SplitTypeEnum.TOTALAMTSPLIT.getValue().equals(splitType)) {
                    this.setDateMask("YYYY");
                    break;
                }
                if (!SplitTypeEnum.BUDGETAMTSPLIT.getValue().equals(splitType) && !SplitTypeEnum.SUMSPLIT.getValue().equals(splitType)) break;
                this.setDateMask("YYYY-MM");
                break;
            }
            case "year": {
                this.changeYear(newValue);
                break;
            }
        }
    }

    protected void sumToProYearAmount() {
        DynamicObjectCollection fundSourceEntry = this.getModel().getEntryEntity("fundsourceentry");
        BigDecimal sumAmount = fundSourceEntry.stream().map(obj -> obj.getBigDecimal("fundamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        this.getModel().setValue("afterproyearamt", (Object)sumAmount);
    }

    protected void projectChanged(Object newValue) {
        QFilter billStatusQFilter;
        if (newValue == null) {
            this.getModel().deleteEntryData("fundsourceentry");
            this.getModel().deleteEntryData("controlinfoentry");
            this.getModel().deleteEntryData("realbudgetentry");
            this.setAmountEnable(true);
            return;
        }
        DynamicObject project = (DynamicObject)newValue;
        QFilter projectQFilter = new QFilter("project", "=", project.getPkValue());
        DynamicObject sameProBill = QueryServiceHelper.queryOne((String)"pmas_approval_amtmodify", (String)"id", (QFilter[])new QFilter[]{projectQFilter, billStatusQFilter = new QFilter("billstatus", "!=", (Object)StatusEnum.CHECKED.getValue())});
        if (sameProBill != null && !this.getModel().getDataEntity().getPkValue().equals(sameProBill.get("id"))) {
            this.getModel().setValue("project", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u9879\u76ee\u4e14\u672a\u5ba1\u6838\u7684\u7acb\u9879\u91d1\u989d\u8c03\u6574\u5355\uff0c\u8bf7\u524d\u5f80\u5904\u7406\u3002", (String)"ApprovalAmtModifyEditPlugin_5", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter proQFilter = new QFilter("pro", "=", project.getPkValue());
        if (!QueryServiceHelper.exists((String)"pmas_pro_approval", (QFilter[])new QFilter[]{proQFilter})) {
            this.getModel().setValue("project", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u7acb\u9879\u7684\u9879\u76ee\u3002", (String)"ApprovalAmtModifyEditPlugin_6", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject approval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (QFilter[])new QFilter[]{proQFilter});
        this.getModel().setValue("kind", approval.get("kind"));
        this.getModel().setValue("modifybillno", approval.get("billno"));
        this.getModel().setValue("modifyname", approval.get("billname"));
        this.getModel().setValue("currency", approval.get("currencyfield"));
        this.getModel().setValue("projectbugamt", approval.get("projcetbugamt"));
        this.getModel().setValue("afterproamt", approval.get("projcetbugamt"));
        this.getModel().setValue("budgetcontrolmode", approval.get("budgetcontrolmode"));
        this.getModel().setValue("splittype", approval.get("splittype"));
        this.getModel().setValue("projectapplydate", approval.get("projectapplydate"));
        this.setProYearAmtByYear(project);
        this.setOutBudgetAmount(project);
        this.setSourceEntry(project);
        ApprovalAmtModifyHelper.setControlInfoEntry((DynamicObject)approval, (IDataModel)this.getModel(), (IFormView)this.getView());
    }

    private void changeYear(Object newValue) {
        if (newValue == null) {
            this.getModel().deleteEntryData("fundsourceentry");
            this.getModel().deleteEntryData("controlinfoentry");
            this.getModel().deleteEntryData("realbudgetentry");
            this.getModel().setValue("proyearbudgetamt", (Object)BigDecimal.ZERO);
            this.getModel().setValue("afterproyearamt", (Object)BigDecimal.ZERO);
            this.setAmountEnable(true);
            return;
        }
        Object projectObj = this.getModel().getValue("project");
        if (projectObj == null) {
            this.getModel().setValue("year", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u3002", (String)"ApprovalAmtModifyEditPlugin_2", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject project = (DynamicObject)projectObj;
        this.setProYearAmtByYear(project);
        this.setOutBudgetAmount(project);
        this.setSourceEntry(project);
        QFilter proQFilter = new QFilter("pro", "=", project.getPkValue());
        DynamicObject approval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (QFilter[])new QFilter[]{proQFilter});
        if (approval != null) {
            ApprovalAmtModifyHelper.setControlInfoEntry((DynamicObject)approval, (IDataModel)this.getModel(), (IFormView)this.getView());
        }
    }

    protected void setProYearAmtByYear(DynamicObject project) {
        BigDecimal proYearAmt = BigDecimal.ZERO;
        Object year = this.getModel().getValue("year");
        if (year != null) {
            proYearAmt = new ProjectInitiationHelper().obtainLastApprovalAmt((Date)year, project);
        }
        this.getModel().setValue("proyearbudgetamt", (Object)proYearAmt);
        this.getModel().setValue("afterproyearamt", (Object)proYearAmt);
    }

    protected void setOutBudgetAmount(DynamicObject project) {
        DynamicObject outBudget;
        QFilter proFilter = new QFilter("project", "=", project.getPkValue());
        proFilter.and(new QFilter("isvalid", "=", (Object)true));
        QFilter typeFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.TOTAL.getValue());
        DynamicObject totalBudget = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudget", (String)"totalamount", (QFilter[])new QFilter[]{proFilter, typeFilter});
        if (totalBudget != null) {
            this.getModel().setValue("prooutbudgetsumamt", totalBudget.get("totalamount"));
        }
        typeFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
        Object year = this.getModel().getValue("year");
        if (year != null) {
            Date curYear = (Date)year;
            int curYearInt = curYear.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
            typeFilter.and("YEAR(year)", "=", (Object)curYearInt);
        }
        if ((outBudget = BusinessDataServiceHelper.loadSingle((String)"pmas_outbudget", (String)"totalamount", (QFilter[])new QFilter[]{proFilter, typeFilter})) != null) {
            this.getModel().setValue("outamount", outBudget.get("totalamount"));
        } else {
            this.getModel().setValue("outamount", (Object)BigDecimal.ZERO);
        }
    }

    protected void setSourceEntry(DynamicObject project) {
        DynamicObjectCollection fundEntry;
        QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
        projectFilter.and(new QFilter("isvalid", "=", (Object)true));
        Object year = this.getModel().getValue("year");
        if (year != null) {
            Date curYear = (Date)year;
            int curYearInt = curYear.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
            projectFilter.and("YEAR(year)", "=", (Object)curYearInt);
        }
        boolean setSourceYAmtToZero = false;
        DynamicObject fundSource = BusinessDataServiceHelper.loadSingle((String)"pmas_projfundsource", (QFilter[])new QFilter[]{projectFilter});
        if (fundSource != null) {
            fundEntry = fundSource.getDynamicObjectCollection("fundentry");
            if (fundEntry != null && fundEntry.size() > 0) {
                this.getModel().deleteEntryData("fundsourceentry");
                this.getModel().batchCreateNewEntryRow("fundsourceentry", fundEntry.size());
                BigDecimal sumAmount = BigDecimal.ZERO;
                BigDecimal amount = BigDecimal.ZERO;
                this.getModel().beginInit();
                for (int i = 0; i < fundEntry.size(); ++i) {
                    DynamicObject fundObject = (DynamicObject)fundEntry.get(i);
                    this.getModel().setValue("fundsourcetype", fundObject.get("sourcetype"), i);
                    this.getModel().setValue("fundformofinvest", fundObject.get("formofinvest"), i);
                    this.getModel().setValue("fundsumamount", fundObject.get("amount"), i);
                    this.getModel().setValue("fundamount", fundObject.get("currententryamt"), i);
                    this.getModel().setValue("fundoldamount", fundObject.get("currententryamt"), i);
                    this.getModel().setValue("entrycurrency", fundObject.get("investcurrency"), i);
                    this.getModel().setValue("fundscale", fundObject.get("scale"), i);
                    this.getModel().setValue("funddescription", fundObject.get("note"), i);
                    sumAmount = sumAmount.add(fundObject.getBigDecimal("amount"));
                    amount = amount.add(fundObject.getBigDecimal("currententryamt"));
                }
                this.getModel().endInit();
                this.getView().updateView("fundsourceentry");
                this.getModel().setValue("projectbugamt", (Object)sumAmount);
                this.getModel().setValue("proyearbudgetamt", (Object)amount);
                this.getModel().setValue("afterproamt", (Object)sumAmount);
                this.getModel().setValue("afterproyearamt", (Object)amount);
                this.setAmountEnable(false);
            } else {
                this.setAmountEnable(true);
                setSourceYAmtToZero = true;
            }
        } else {
            setSourceYAmtToZero = true;
        }
        fundEntry = this.getModel().getEntryEntity("fundsourceentry");
        if (fundEntry.size() > 0 && setSourceYAmtToZero) {
            for (int i = 0; i < fundEntry.size(); ++i) {
                this.getModel().setValue("fundamount", (Object)BigDecimal.ZERO, i);
            }
        }
        this.setAmountEnable(fundEntry.size() <= 0);
    }

    protected void setAmountEnable(boolean enable) {
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{"afterproamt", "afterproyearamt"});
        this.getView().updateView("afterproamt");
        this.getView().updateView("afterproyearamt");
    }

    protected void setFundSourceEntryScale() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("fundsourceentry");
        if (entryEntity.size() > 0) {
            BigDecimal sum = entryEntity.stream().map(obj -> obj.getBigDecimal("fundsumamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            for (DynamicObject entry : entryEntity) {
                BigDecimal totalAmount = entry.getBigDecimal("fundsumamount");
                if (sum.compareTo(BigDecimal.ZERO) > 0) {
                    entry.set("fundscale", (Object)totalAmount.divide(sum, 10, RoundingMode.HALF_UP).multiply(new BigDecimal(100)));
                    continue;
                }
                entry.set("fundscale", (Object)BigDecimal.ZERO);
            }
            this.getModel().setValue("afterproamt", (Object)sum);
        } else {
            this.getModel().setValue("afterproamt", (Object)BigDecimal.ZERO);
        }
        this.getModel().updateEntryCache(entryEntity);
        this.getView().updateView("fundsourceentry");
    }

    private void setDateMask(String mask) {
        IClientViewProxy view = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        view.invokeControlMethod("controlinfoentry", "setColEditorProp", new Object[]{"undertakeperiod", "mask", mask});
        this.getView().updateView("controlinfoentry");
    }
}

