/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.formplugin.pro;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmas.formplugin.base.AbstractPmasListPlugin;
import kd.pmgt.pmbs.business.projectkind.ProjectKindService;

public class ApprovalAmtModifyListPlugin
extends AbstractPmasListPlugin {
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Object billId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        String billFormId = billList.getBillFormId();
        String fieldName = args.getFieldName();
        if ("project_name".equals(fieldName)) {
            args.setCancel(true);
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billFormId);
            QFilter qFilter = new QFilter("pro", "=", bill.getDynamicObject("project").getPkValue());
            qFilter.and(new QFilter("billstatus", "!=", (Object)"A"));
            DynamicObject[] projectApprovals = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (projectApprovals != null && projectApprovals.length > 0) {
                HashMap<String, Object> custormMap = new HashMap<String, Object>(10);
                custormMap.put("proAppId", projectApprovals[0].getPkValue());
                HashMap<String, Object> map = new HashMap<String, Object>(10);
                map.put("formId", "pmba_projectkanban");
                map.put("customParams", custormMap);
                FormShowParameter showParameter = BillShowParameter.createFormShowParameter(map);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(showParameter);
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent event) {
        super.filterContainerBeforeF7Select(event);
        String fieldName = event.getFieldName();
        if (fieldName.startsWith("kind")) {
            this.beforeProjectKindSelect(event);
        }
    }

    protected void beforeProjectKindSelect(BeforeFilterF7SelectEvent event) {
        event.setRefEntityId("bd_projectkind");
        event.setRefPropKey("id");
        ProjectKindService projectKindService = new ProjectKindService();
        DynamicObject[] proKinds = projectKindService.getAuthorizedProjectKindList(null, Long.valueOf(RequestContext.get().getOrgId()));
        Set ids = Arrays.stream(proKinds).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        event.getQfilters().add(new QFilter("id", "in", ids));
    }
}

