/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.formplugin.pro;

import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmas.business.helper.ProjectApprovalHelper;
import kd.pmgt.pmbs.business.helper.UserOrgRangeHelper;
import org.apache.commons.lang3.StringUtils;

public class ChangeProjLeaderPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String OPERATION_CHANGELEADER = "changeleader";

    public void registerListener(EventObject e) {
        BasedataEdit nowLeader = (BasedataEdit)this.getControl("nowleader");
        nowLeader.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (name) {
            case "nowleader": {
                this.changeProleader((DynamicObject)newValue);
                break;
            }
        }
    }

    private void changeProleader(DynamicObject user) {
        if (user != null) {
            user = BusinessDataServiceHelper.loadSingleFromCache((Object)user.getPkValue(), (String)"bos_user");
            this.setProLeaderContact(user, this.getModel().getDataEntity());
        }
    }

    private void setProLeaderContact(DynamicObject user, DynamicObject changeProjLeaderObj) {
        changeProjLeaderObj.set("nowleadertelno", (Object)user.getString("phone"));
        this.getView().updateView();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object projectID = this.getView().getFormShowParameter().getCustomParam("projectID");
        DynamicObject nowTeamObj = ProjectApprovalHelper.getNowTeamObj((Object)projectID);
        if (nowTeamObj != null) {
            this.loadData(nowTeamObj);
        }
        this.getModel().setValue("project", projectID);
    }

    private void loadData(DynamicObject nowTeamObj) {
        this.getModel().setValue("orileader", (Object)nowTeamObj.getDynamicObject("member"));
        this.getModel().setValue("orileadertelno", (Object)nowTeamObj.getString("telno"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)formOperate.getOperateKey(), (CharSequence)OPERATION_CHANGELEADER) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.getView().close();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        if ("nowleader".equals(key)) {
            param.setF7Style(3);
            List qFilterList = param.getListFilterParameter().getQFilters();
            List userOrgRanges = UserOrgRangeHelper.getUserOrgRanges((Long)RequestContext.get().getCurrUserId());
            if (userOrgRanges.size() > 0) {
                qFilterList.add(new QFilter("entryentity.dpt.id", "in", (Object)userOrgRanges));
            }
        }
    }
}

