/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.formplugin.pro;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pmgt.pmas.formplugin.base.AbstractPmasBillPlugin;
import kd.pmgt.pmbs.business.helper.UserOrgRangeHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class ProApprovalApplyEditPlugin
extends AbstractPmasBillPlugin
implements BeforeF7SelectListener {
    private static final String CALLBACK_PROLEADER = "callback_proleader";

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("projectapplydate", (Object)new Date());
    }

    private FormShowParameter buildShowProposal(Object pkId) {
        boolean existSelf = QueryServiceHelper.exists((String)"pmim_projectproposal", (Object)pkId);
        BillShowParameter showParameter = new BillShowParameter();
        if (existSelf) {
            showParameter.setPkId(pkId);
            showParameter.setFormId("pmim_projectproposal");
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        return showParameter;
    }

    protected void setProjectKind() {
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        String projectKindId = (String)parameter.getCustomParam("group");
        if (StringUtils.isNotEmpty((CharSequence)projectKindId)) {
            this.getModel().setValue("group", (Object)Long.parseLong(projectKindId));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit proposal = (BasedataEdit)this.getControl("proproposal");
        proposal.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit projectorg = (BasedataEdit)this.getControl("projectorg");
        projectorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit implementorg = (BasedataEdit)this.getControl("implementorg");
        implementorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit proleader = (BasedataEdit)this.getControl("proleader");
        proleader.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        proposal.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm(this.buildShowProposal(beforeF7ViewDetailEvent.getPkId()));
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setProjectKind();
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (billStatus.equals(StatusEnum.TEMPSAVE.getValue())) {
            long orgId = RequestContext.get().getOrgId();
            DynamicObject org = this.getSuperCompanyOrg(orgId);
            if (org != null) {
                this.getModel().setValue("company", org.getPkValue());
            } else {
                this.getModel().setValue("company", (Object)orgId);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        int entrySize = this.getModel().getEntryRowCount("sourceentry");
        switch (key) {
            case "newentry": {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"totalamount", "annualamount"});
                break;
            }
            case "deleteentry": {
                if (entrySize == 0) {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"totalamount", "annualamount"});
                }
                this.totalAmountChanged();
                this.AnnualAmountChanged();
            }
        }
    }

    protected DynamicObject getSuperCompanyOrg(long orgId) {
        Object id;
        Map mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        if (!mapOrg.isEmpty() && (id = mapOrg.get("id")) != null) {
            return BusinessDataServiceHelper.loadSingle(id, (String)"bos_org", (String)"id,name,number");
        }
        return null;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String name = e.getProperty().getName();
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        List qFilterList = param.getListFilterParameter().getQFilters();
        switch (name) {
            case "proproposal": {
                this.addProposalF7QueryFilterAndCallBack(param, this.getModel().getDataEntity());
                break;
            }
            case "projectorg": 
            case "implementorg": {
                List departments = UserServiceHelper.getUserDepartment((long)RequestContext.get().getCurrUserId(), (boolean)false);
                QFilter qFilter = departments.isEmpty() ? new QFilter("id", "=", (Object)RequestContext.get().getOrgId()) : new QFilter("id", "in", (Object)departments);
                qFilterList.add(qFilter);
                break;
            }
            case "proleader": {
                param.setF7Style(3);
                qFilterList = param.getListFilterParameter().getQFilters();
                long currUserId = RequestContext.get().getCurrUserId();
                List userOrgRanges = UserOrgRangeHelper.getUserOrgRanges((Long)currUserId);
                if (userOrgRanges.size() > 0) {
                    qFilterList.add(new QFilter("entryentity.dpt.id", "in", (Object)userOrgRanges));
                }
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACK_PROLEADER);
                param.setCloseCallBack(closeCallBack);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int rowIndex = changeData.getRowIndex();
        switch (name) {
            case "proleader": {
                if (newValue == null) break;
                DynamicObject leader = (DynamicObject)newValue;
                this.getModel().setValue("leaderconttype", (Object)leader.getLong("phone"));
                break;
            }
            case "proproposal": {
                if (oldValue != null) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u9879\u76ee\u5efa\u8bae\u4e66\u5c06\u4f1a\u5207\u6362\u90e8\u5206\u5b57\u6bb5\u4fe1\u606f\u548c\u5206\u5f55\u4fe1\u606f\u3002", (String)"ProApprovalApplyEditPlugin_0", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("proproposal"));
                    this.getPageCache().put("proproposal", ((DynamicObject)oldValue).getPkValue().toString());
                    return;
                }
                this.projectProposalChanged(newValue);
            }
            case "entrytotalamount": {
                this.totalAmountChanged();
                break;
            }
            case "entryannualamt": {
                this.AnnualAmountChanged();
                break;
            }
            case "projectcurrency": {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("sourceentry");
                DynamicObject currency = (DynamicObject)newValue;
                for (DynamicObject entry : entryEntity) {
                    entry.set("entrycurrency", currency != null ? currency.getPkValue() : null);
                }
                this.getModel().updateEntryCache(entryEntity);
                break;
            }
        }
        this.handleDateEvents(name);
    }

    protected void totalAmountChanged() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("sourceentry");
        BigDecimal sum = entryEntity.stream().map(obj -> obj.getBigDecimal("entrytotalamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        this.getModel().setValue("totalamount", (Object)sum);
        for (DynamicObject entry : entryEntity) {
            BigDecimal totalAmount = entry.getBigDecimal("entrytotalamount");
            if (sum.compareTo(BigDecimal.ZERO) > 0) {
                entry.set("entryscale", (Object)totalAmount.divide(sum, 10, RoundingMode.HALF_UP));
                continue;
            }
            entry.set("entryscale", (Object)BigDecimal.ZERO);
        }
        this.getModel().updateEntryCache(entryEntity);
        this.getView().updateView("sourceentry");
    }

    protected void AnnualAmountChanged() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("sourceentry");
        BigDecimal amount = entryEntity.stream().map(obj -> obj.getBigDecimal("entryannualamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        this.getModel().setValue("annualamount", (Object)amount);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String key;
        super.confirmCallBack(event);
        switch (key = event.getCallBackId()) {
            case "proproposal": {
                if (event.getResult().equals((Object)MessageBoxResult.Yes)) {
                    Object proposal = this.getModel().getValue("proproposal");
                    this.projectProposalChanged(proposal);
                    break;
                }
                this.doOldValueReback(key);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "callback_proleader": {
                this.proLeaderCloseCallBack(e);
            }
        }
    }

    private void proLeaderCloseCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection userObjCollection = (ListSelectedRowCollection)e.getReturnData();
        if (userObjCollection != null) {
            Object userPkValue = userObjCollection.get(0).getPrimaryKeyValue();
            DynamicObject model = this.getModel().getDataEntity();
            DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)userPkValue, (String)"bos_user", (String)"id,phone");
            model.set("proleader", (Object)user);
            model.set("leaderconttype", (Object)user.getString("phone"));
            this.getView().updateView();
        }
    }

    protected void projectProposalChanged(Object newValue) {
        DynamicObject proposal = (DynamicObject)newValue;
        if (proposal != null) {
            proposal = BusinessDataServiceHelper.loadSingle((Object)proposal.getPkValue(), (String)"pmim_projectproposal");
            this.getModel().setValue("billname", (Object)proposal.getString("billname"));
            this.getModel().setValue("investdirection", (Object)proposal.getString("investdirection"));
            this.getModel().setValue("investkind", (Object)proposal.getString("investkind"));
            this.getModel().setValue("industrykind", (Object)proposal.getDynamicObject("projectstatus"));
            this.getModel().setValue("industry", (Object)proposal.getDynamicObject("industry"));
            this.getModel().setValue("projectcurrency", (Object)proposal.getDynamicObject("currency"));
            this.getModel().setValue("isplanpro", proposal.get("proinplan"));
            this.getModel().setValue("totalamount", (Object)proposal.getBigDecimal("proinvestbudappamt"));
            this.getModel().setValue("annualamount", (Object)proposal.getBigDecimal("yearbugapprovalamt"));
            this.getModel().setValue("proinvestbudappamt", (Object)proposal.getBigDecimal("proinvestbudappamt"));
            this.getModel().setValue("yearbugapprovalamt", (Object)proposal.getBigDecimal("yearbugapprovalamt"));
            this.handleProposalEntry(proposal);
        } else {
            this.getModel().setValue("billname", null);
            this.getModel().setValue("investdirection", null);
            this.getModel().setValue("investkind", null);
            this.getModel().setValue("industry", null);
            this.getModel().setValue("industrykind", null);
            DynamicObject currency = this.getCNYCurrency();
            this.getModel().setValue("projectcurrency", currency.getPkValue());
            this.getModel().setValue("isplanpro", (Object)false);
            this.getModel().setValue("totalamount", null);
            this.getModel().setValue("annualamount", null);
            this.getModel().setValue("proinvestbudappamt", null);
            this.getModel().setValue("yearbugapprovalamt", null);
            this.getModel().deleteEntryData("sourceentry");
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"totalamount", "annualamount"});
        }
    }

    protected DynamicObject getCNYCurrency() {
        QFilter numberFilter = new QFilter("number", "=", (Object)"CNY");
        return BusinessDataServiceHelper.loadSingle((String)"bd_currency", (String)"", (QFilter[])new QFilter[]{numberFilter});
    }

    protected void doOldValueReback(String key) {
        String oldValue = this.getPageCache().get(key);
        Long id = Long.parseLong(oldValue);
        this.getModel().beginInit();
        this.getModel().setValue(key, (Object)id);
        this.getView().updateView(key);
        this.getModel().endInit();
    }

    protected void handleProposalEntry(DynamicObject proposal) {
        DynamicObjectCollection proposalSourceEntry = proposal.getDynamicObjectCollection("sourceentry");
        this.getModel().deleteEntryData("sourceentry");
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"totalamount", "annualamount"});
        DynamicObjectCollection sourceEntry = this.getModel().getEntryEntity("sourceentry");
        if (proposalSourceEntry.size() > 0) {
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal annualAmount = BigDecimal.ZERO;
            for (DynamicObject entry : proposalSourceEntry) {
                DynamicObject source = new DynamicObject(sourceEntry.getDynamicObjectType());
                source.set("entryfundresource", (Object)entry.getDynamicObject("sourceentry_fundresource"));
                source.set("entrycaptialform", (Object)entry.getString("sourceentry_formofinvest"));
                BigDecimal sourceAmount = entry.getBigDecimal("sourceentry_amount");
                source.set("entrytotalamount", (Object)sourceAmount);
                totalAmount = totalAmount.add(sourceAmount);
                BigDecimal sourceAnnualAmount = entry.getBigDecimal("currententryamt");
                source.set("entryannualamt", (Object)sourceAnnualAmount);
                annualAmount = annualAmount.add(sourceAnnualAmount);
                source.set("entryscale", (Object)entry.getBigDecimal("sourceentry_scale").divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP));
                source.set("entryremark", (Object)entry.getString("sourceentry_remark"));
                sourceEntry.add((Object)source);
            }
            this.updateSpecialAmount(totalAmount, annualAmount, false);
            this.getModel().updateEntryCache(sourceEntry);
            this.getView().updateView("sourceentry");
        }
    }

    protected void updateSpecialAmount(BigDecimal totalAmount, BigDecimal annualAmount, boolean isEnable) {
        this.getModel().setValue("totalamount", (Object)totalAmount);
        this.getModel().setValue("annualamount", (Object)annualAmount);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"totalamount", "annualamount"});
    }

    protected void handleDateEvents(String name) {
        Date planBeginDate = (Date)this.getModel().getValue("planbegindate");
        Date planEndDate = (Date)this.getModel().getValue("planenddate");
        switch (name) {
            case "planbegindate": {
                if (null != planEndDate && null != planBeginDate && planBeginDate.compareTo(planEndDate) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65e5\u671f\u4e0d\u5f97\u65e9\u4e8e\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u3002", (String)"ProApprovalApplyEditPlugin_1", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("planbegindate", null);
                    return;
                }
                if (null != planBeginDate) {
                    if (planEndDate == null) break;
                    this.setPeriod(planBeginDate, planEndDate);
                    break;
                }
                this.getModel().setValue("investperiod", null);
                break;
            }
            case "planenddate": {
                if (null != planEndDate && null != planBeginDate && planBeginDate.compareTo(planEndDate) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65e5\u671f\u4e0d\u5f97\u65e9\u4e8e\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u3002", (String)"ProApprovalApplyEditPlugin_1", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("planenddate", null);
                    return;
                }
                if (null != planEndDate) {
                    if (planBeginDate == null) break;
                    this.setPeriod(planBeginDate, planEndDate);
                    break;
                }
                this.getModel().setValue("investperiod", null);
            }
        }
    }

    protected void setPeriod(Date planBeginDate, Date planEndDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(planBeginDate);
        int startYear = calendar.get(1);
        int startMonth = calendar.get(2) + 1;
        int startDay = calendar.get(5);
        calendar.clear();
        calendar.setTime(planEndDate);
        int endYear = calendar.get(1);
        int endMonth = calendar.get(2) + 1;
        int endDay = calendar.get(5);
        if (endMonth == startMonth && endDay >= startDay) {
            ++endMonth;
        }
        this.getModel().setValue("investperiod", (Object)String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708", (String)"ProApprovalApplyEditPlugin_2", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), endYear - startYear, endMonth - startMonth));
    }

    protected LocalDate toLocalDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        return localDateTime.toLocalDate();
    }

    protected void addProposalF7QueryFilterAndCallBack(ListShowParameter param, DynamicObject obj) {
        DynamicObject kind = obj.getDynamicObject("group");
        if (kind != null) {
            QFilter kindQFilter = new QFilter("projectkind.id", "=", kind.getPkValue());
            ArrayList<String> bisStatus = new ArrayList<String>();
            bisStatus.add("cancel");
            bisStatus.add("approval");
            QFilter cancelQFilter = new QFilter("bizstatus", "not in", bisStatus);
            cancelQFilter.and("status", "=", (Object)StatusEnum.CHECKED.getValue());
            DynamicObject org = obj.getDynamicObject("org");
            Object orgPK = null;
            if (org != null) {
                orgPK = org.getPkValue();
                QFilter orgQFilter = new QFilter("org", "=", orgPK);
                param.setCustomParam("org", orgPK);
                kindQFilter.and(orgQFilter);
            }
            QFilter isReserveQFilter = new QFilter("reportbudget", "=", (Object)Boolean.TRUE);
            kindQFilter.and(isReserveQFilter);
            QFilter qFilter = new QFilter("inventry.inventry_approvalcon", "=", (Object)"pass");
            qFilter.and("inventry.projecttype", "=", (Object)"pmim_proposalbill_f7");
            DynamicObject[] declares = BusinessDataServiceHelper.load((String)"pmim_aunualinvestplan", (String)String.join((CharSequence)",", "inventry", "inventry_approvalcon", "projectno", "projecttype"), (QFilter[])new QFilter[]{qFilter});
            HashSet proposals = new HashSet(16);
            if (declares.length > 0) {
                for (DynamicObject passDeclare : declares) {
                    DynamicObjectCollection invEntry = passDeclare.getDynamicObjectCollection("inventry");
                    Set passIds = invEntry.stream().filter(o -> StringUtils.equals((CharSequence)o.getString("projecttype"), (CharSequence)"pmim_proposalbill_f7")).filter(o -> StringUtils.equals((CharSequence)o.getString("inventry_approvalcon"), (CharSequence)"pass")).map(o -> Long.parseLong(o.getDynamicObject("projectno").getPkValue().toString())).collect(Collectors.toSet());
                    if (passIds.size() <= 0) continue;
                    proposals.addAll(passIds);
                }
                if (proposals.size() > 0) {
                    kindQFilter.and(new QFilter("id", "in", proposals));
                }
            }
            param.getListFilterParameter().getQFilters().add(kindQFilter);
            HashMap<String, Object> customParam = new HashMap<String, Object>(16);
            customParam.put("group", kind.getPkValue());
            customParam.put("showproject", Boolean.FALSE);
            param.setCustomParams(customParam);
        }
    }
}

