/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.formplugin.pro;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmas.formplugin.base.AbstractPmasBillPlugin;
import kd.pmgt.pmbs.common.enums.BudgetCtlModeEnum;
import kd.pmgt.pmbs.common.enums.DimShareType;
import kd.pmgt.pmbs.common.enums.SplitTypeEnum;
import kd.pmgt.pmbs.common.utils.CurrencyFormatUtil;
import kd.pmgt.pmbs.common.utils.TimeUtils;

public class ProBudgetSplitEditPlugin
extends AbstractPmasBillPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final Log logger = LogFactory.getLog(ProBudgetSplitEditPlugin.class);
    private static final String OPERATE_APPROVAL_SUBMIT = "approvalsubmit";
    private static final String OPERATION_REPROT_SUBMIT = "reportsubmit";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setOutBudgetEntrySumRow();
        this.controlBudgetItemMustInput();
    }

    protected void controlBudgetItemMustInput() {
        String splitType = this.getModel().getDataEntity().getString("splittype");
        String budgetcontrolmode = this.getModel().getDataEntity().getString("budgetcontrolmode");
        TextEdit ctrloutitemname = (TextEdit)this.getControl("ctrloutitemname");
        TextEdit entryproname = (TextEdit)this.getControl("entryproname");
        if (ctrloutitemname != null) {
            ctrloutitemname.setMustInput(false);
        }
        if (entryproname != null) {
            entryproname.setMustInput(false);
        }
        if (StringUtils.equals((CharSequence)SplitTypeEnum.BUDGETAMTSPLIT.getValue(), (CharSequence)splitType) && ctrloutitemname != null) {
            ctrloutitemname.setMustInput(true);
        }
        if (StringUtils.equals((CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue(), (CharSequence)budgetcontrolmode) && entryproname != null) {
            entryproname.setMustInput(true);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit ctrlOutItemName = (TextEdit)this.getView().getControl("ctrloutitemname");
        ctrlOutItemName.addButtonClickListener((ClickListener)this);
        TextEdit entryProName = (TextEdit)this.getView().getControl("entryproname");
        entryProName.addButtonClickListener((ClickListener)this);
        BasedataEdit ctrlOutItem = (BasedataEdit)this.getControl("ctrloutitem");
        ctrlOutItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)"summarybudget", (CharSequence)operateKey)) {
            int budgetRowCount = model.getEntryRowCount("budgetout");
            if (budgetRowCount > 0) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6c47\u603b\u9884\u7b97\u5c06\u91cd\u65b0\u8ba1\u7b97\u201c\u9884\u7b97\u660e\u7ec6\u91d1\u989d\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProBudgetSplitEditPlugin_0", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("summarybudget"));
            } else {
                DynamicObjectCollection controlInfoEntry = model.getEntryEntity("controlinfoentry");
                this.mergeToBudgetEntry(controlInfoEntry);
            }
        } else if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey) || StringUtils.equals((CharSequence)"submit", (CharSequence)operateKey) || StringUtils.equals((CharSequence)OPERATE_APPROVAL_SUBMIT, (CharSequence)operateKey) || StringUtils.equals((CharSequence)OPERATION_REPROT_SUBMIT, (CharSequence)operateKey)) {
            DynamicObject dataEntity = model.getDataEntity();
            String budgetControlMode = dataEntity.getString("budgetcontrolmode");
            if (StringUtils.equals((CharSequence)BudgetCtlModeEnum.NOTCONTROL.getValue(), (CharSequence)budgetControlMode)) {
                return;
            }
            this.setRealBudgetEntry(model, dataEntity, args);
        }
    }

    private void setRealBudgetEntry(IDataModel model, DynamicObject dataEntity, BeforeDoOperationEventArgs args) {
        model.deleteEntryData("realbudgetentry");
        String splitType = dataEntity.getString("splittype");
        DynamicObjectCollection controlInfoEntryCol = model.getEntryEntity("controlinfoentry");
        if (StringUtils.equals((CharSequence)SplitTypeEnum.TOTALAMTSPLIT.getValue(), (CharSequence)splitType)) {
            int controlInfoSize = controlInfoEntryCol.size();
            if (controlInfoSize == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9884\u7b97\u5206\u644a\u660e\u7ec6\u3002", (String)"ProBudgetSplitEditPlugin_1", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            BigDecimal outAmount = dataEntity.getBigDecimal("proyearbudgetamt");
            if (outAmount.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u7acb\u9879\u5e74\u5ea6\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002", (String)"ProBudgetSplitEditPlugin_2", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        int rowIndex = 0;
        for (DynamicObject controlInfo : controlInfoEntryCol) {
            DynamicObject budgetitem = controlInfo.getDynamicObject("ctrloutitem");
            String ctrloutItemName = controlInfo.getString("ctrloutitemname");
            DynamicObject undertakeOrg = controlInfo.getDynamicObject("undertakeorg");
            Date undertakePeriod = controlInfo.getDate("undertakeperiod");
            ComboProp prop = (ComboProp)this.getModel().getProperty("defmonth");
            Object month = prop.getDefValue();
            if (StringUtils.equals((CharSequence)SplitTypeEnum.TOTALAMTSPLIT.getValue(), (CharSequence)splitType)) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(undertakePeriod);
                if (month != null) {
                    calendar.set(2, Integer.parseInt(month.toString()) - 1);
                } else {
                    calendar.set(2, 0);
                }
                undertakePeriod = calendar.getTime();
            }
            long entryproid = controlInfo.getLong("entryproid");
            BigDecimal realundertakeamt = controlInfo.getBigDecimal("undertakeamt");
            if (this.checkIsRepeat(controlInfo, budgetitem, realundertakeamt)) continue;
            model.createNewEntryRow("realbudgetentry");
            model.setValue("realbudgetitem", (Object)budgetitem, rowIndex);
            model.setValue("realprobudgetname", (Object)ctrloutItemName, rowIndex);
            model.setValue("realundertakeorg", (Object)undertakeOrg, rowIndex);
            model.setValue("realundertakeperiod", (Object)undertakePeriod, rowIndex);
            model.setValue("realproname", controlInfo.get("entryproname"), rowIndex);
            model.setValue("realpronumber", controlInfo.get("entrypronumber"), rowIndex);
            model.setValue("realproid", (Object)entryproid, rowIndex);
            model.setValue("realundertakeamt", (Object)realundertakeamt, rowIndex);
            ++rowIndex;
        }
        this.getView().updateView("realbudgetentry");
    }

    private boolean checkIsRepeat(DynamicObject controlInfo, DynamicObject budgetitem, BigDecimal realUndertakeAmt) {
        boolean isContinue = false;
        int rowCount = this.getModel().getEntryRowCount("realbudgetentry");
        for (int i = 0; i < rowCount; ++i) {
            Integer realundertakeorgPK;
            Object budgetitemPK = budgetitem == null ? Integer.valueOf(0) : budgetitem.getPkValue();
            Integer undertakeOrgPK = controlInfo.getDynamicObject("undertakeorg") == null ? Integer.valueOf(0) : controlInfo.getDynamicObject("undertakeorg").getPkValue();
            Date undertakePeriod = controlInfo.getDate("undertakeperiod");
            Long entryproid = controlInfo.getLong("entryproid");
            Integer realbudgetitemPK = this.getModel().getValue("realbudgetitem", i) == null ? Integer.valueOf(0) : ((DynamicObject)this.getModel().getValue("realbudgetitem", i)).getPkValue();
            Integer n = realundertakeorgPK = this.getModel().getValue("realundertakeorg", i) == null ? Integer.valueOf(0) : ((DynamicObject)this.getModel().getValue("realundertakeorg", i)).getPkValue();
            if (budgetitemPK != realbudgetitemPK || undertakeOrgPK != realundertakeorgPK || !TimeUtils.isSameMonth((Date)undertakePeriod, (Date)((Date)this.getModel().getValue("realundertakeperiod", i))) || !entryproid.equals(this.getModel().getValue("realproid", i))) continue;
            this.getModel().setValue("realundertakeamt", (Object)((BigDecimal)this.getModel().getValue("realundertakeamt", i)).add(realUndertakeAmt), i);
            isContinue = true;
        }
        return isContinue;
    }

    private void mergeToBudgetEntry(DynamicObjectCollection controlInfoEntryCol) {
        DynamicObjectCollection budgetEntryCol = this.getModel().getEntryEntity("budgetout");
        DynamicObjectType budgetEntryType = budgetEntryCol.getDynamicObjectType();
        HashMap<String, BigDecimal> budgetAmtMap = new HashMap<String, BigDecimal>();
        BigDecimal totalAllAmt = BigDecimal.ZERO;
        for (int i = 0; i < controlInfoEntryCol.size(); ++i) {
            BigDecimal ctrlCurrentAmt;
            DynamicObject controlInfoEntry = (DynamicObject)controlInfoEntryCol.get(i);
            DynamicObject ctrlBudgetItem = controlInfoEntry.getDynamicObject("ctrloutitem");
            if (ctrlBudgetItem == null) continue;
            if (!budgetAmtMap.containsKey(ctrlBudgetItem.getString("id"))) {
                ctrlCurrentAmt = controlInfoEntry.getBigDecimal("undertakeamt");
                budgetAmtMap.put(ctrlBudgetItem.getString("id"), ctrlCurrentAmt);
                continue;
            }
            ctrlCurrentAmt = (BigDecimal)budgetAmtMap.get(ctrlBudgetItem.getString("id"));
            ctrlCurrentAmt = ctrlCurrentAmt.add(controlInfoEntry.getBigDecimal("undertakeamt"));
            budgetAmtMap.put(ctrlBudgetItem.getString("id"), ctrlCurrentAmt);
        }
        for (Map.Entry entry : budgetAmtMap.entrySet()) {
            BigDecimal totalAmt = (BigDecimal)entry.getValue();
            totalAllAmt = totalAllAmt.add(totalAmt);
            boolean isExist = false;
            for (int i = 0; i < budgetEntryCol.size(); ++i) {
                DynamicObject budgetEntryObj = (DynamicObject)budgetEntryCol.get(i);
                DynamicObject budgetItem = budgetEntryObj.getDynamicObject("outitem");
                if (budgetItem == null || !StringUtils.equals((CharSequence)budgetItem.getString("id"), (CharSequence)((CharSequence)entry.getKey()))) continue;
                isExist = true;
                budgetEntryObj.set("bdoutamount", (Object)totalAmt);
            }
            if (isExist) continue;
            DynamicObject newBudgetEntry = new DynamicObject(budgetEntryType);
            ORM orm = ORM.create();
            long entryId = orm.genLongId((IDataEntityType)budgetEntryType);
            newBudgetEntry.set("id", (Object)entryId);
            DynamicObject budgetItem = BusinessDataServiceHelper.loadSingle(entry.getKey(), (String)"pmbs_budgetitem");
            newBudgetEntry.set("outitem", (Object)budgetItem);
            newBudgetEntry.set("bdoutamount", (Object)totalAmt);
            newBudgetEntry.set("outitemname", (Object)budgetItem.getString("name"));
            budgetEntryCol.add((Object)newBudgetEntry);
        }
        this.getModel().updateEntryCache(budgetEntryCol);
        this.getView().updateView("budgetout");
        this.getModel().setValue("outamount", (Object)totalAllAmt);
        this.getModel().setValue("proyearbudgetamt", (Object)totalAllAmt);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"outamount", (CharSequence)propName)) {
            this.setOutBudgetEntrySumRow();
        } else if (StringUtils.equals((CharSequence)"splittype", (CharSequence)propName)) {
            this.controlBudgetItemMustInput();
        }
    }

    public static <T> T deSerializedToDynaObj(String entityNumber, String bizDataJson) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)dt);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        return (T)jser.deserializeFromString(bizDataJson, null);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        int selectRow = c.getModel().getEntryCurrentRowIndex("controlinfoentry");
        if (StringUtils.equals((CharSequence)"ctrloutitemname", (CharSequence)key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("pmas_selectbudgetentry");
            showParameter.setCustomParam("key_formId", (Object)"pmas_pro_approval");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ctrloutitemname"));
            this.getView().showForm(showParameter);
        } else if (StringUtils.equals((CharSequence)"entryproname", (CharSequence)key)) {
            DynamicObject undertakeOrg = (DynamicObject)this.getModel().getValue("undertakeorg", selectRow);
            if (undertakeOrg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u627f\u62c5\u7ec4\u7ec7\u3002", (String)"ProBudgetSplitEditPlugin_3", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("formId", "eb_sharedimensiontreef7");
            DynamicObject obj = this.getModel().getDataEntity(true);
            String formId = obj.getDynamicObjectType().getName();
            DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(obj.getDynamicObjectType());
            DcJsonSerializer dcJsonSerializer = new DcJsonSerializer((DcBinder)binder);
            dcJsonSerializer.setIsLocaleValueFull(true);
            binder.setOnlyDbProperty(false);
            String serializeObjStr = dcJsonSerializer.serializeToString((Object)obj, null);
            map.put("dynamicObject", serializeObjStr);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
            showParameter.setCustomParam("billNumber", (Object)formId);
            showParameter.setCustomParam("fieldNumber", (Object)"controlinfoentry.entryproname");
            showParameter.setCustomParam("ischeckData", (Object)Boolean.TRUE);
            showParameter.setCustomParam("isMul", (Object)Boolean.FALSE);
            logger.info("\u7acb\u9879\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u9009\u62e9\u9884\u7b97\u9879\u76ee\u63a5\u53e3\u53c2\u6570billNumber\uff1a{}\uff0cdynamicObject\uff1a{}\uff0cserializeObjStr\uff1a{}", new Object[]{formId, obj, serializeObjStr});
            ArrayList budgetMapList = new ArrayList(10);
            HashMap<String, String> budgetFilterMap = new HashMap<String, String>(16);
            budgetFilterMap.put("key", "controlinfoentry.undertakeorg");
            budgetFilterMap.put("value", undertakeOrg.getString("number"));
            budgetFilterMap.put("type", DimShareType.BASEDATA.getIndex());
            budgetFilterMap.put("dimtype", DimShareType.BUDGETDIM.getIndex());
            budgetMapList.add(budgetFilterMap);
            String budgetFilterJson = SerializationUtils.toJsonString(budgetMapList);
            showParameter.setCustomParam("budgetfilter", (Object)budgetFilterJson);
            logger.info("\u7acb\u9879\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u9009\u62e9\u9884\u7b97\u9879\u76ee\u63a5\u53e3\u9884\u7b97\u6570\u8fc7\u6ee4\uff1a{}\uff0cserializeObjStr\uff1a{}", budgetMapList, (Object)budgetFilterJson);
            ArrayList powerMapList = new ArrayList(16);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org", selectRow);
            if (org != null) {
                HashMap<String, String> powerFilterMap = new HashMap<String, String>(16);
                powerFilterMap.put("key", "org");
                powerFilterMap.put("value", org.getString("number"));
                powerFilterMap.put("type", DimShareType.BASEDATA.getIndex());
                powerFilterMap.put("dimtype", DimShareType.BUDGETDIM.getIndex());
                powerMapList.add(powerFilterMap);
            }
            if (budgetMapList.size() > 0) {
                String powerFilterJson = SerializationUtils.toJsonString(powerMapList);
                showParameter.setCustomParam("relation", (Object)powerFilterJson);
                logger.info("\u7acb\u9879\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u9009\u62e9\u9884\u7b97\u9879\u76ee\u63a5\u53e3\u4e1a\u52a1\u7ec4\u7ec7\u8fc7\u6ee4\uff1a{}\uff0cserializeObjStr\uff1a{}", powerMapList, (Object)powerFilterJson);
            }
            CloseCallBack ccb = new CloseCallBack((IFormPlugin)this, "selectProject");
            showParameter.setCloseCallBack(ccb);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss css = new StyleCss();
            showParameter.getOpenStyle().setInlineStyleCss(css);
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)"ctrloutitemname", (CharSequence)actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null) {
                int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("controlinfoentry");
                DynamicObject entryEntity = (DynamicObject)returnData;
                this.getModel().setValue("ctrloutitem", entryEntity.get("budgetitem"), entryCurrentRowIndex);
                this.getModel().setValue("ctrloutitemname", entryEntity.get("probudgetitemname"), entryCurrentRowIndex);
            }
        } else if (StringUtils.equals((CharSequence)"selectProject", (CharSequence)actionId)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (returnData == null || returnData.isEmpty()) {
                return;
            }
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("controlinfoentry");
            ListSelectedRow row = returnData.get(0);
            this.getModel().setValue("entrypronumber", (Object)row.getNumber(), entryCurrentRowIndex);
            this.getModel().setValue("entryproname", (Object)row.getName(), entryCurrentRowIndex);
            this.getModel().setValue("entryproid", row.getPrimaryKeyValue(), entryCurrentRowIndex);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key;
        super.confirmCallBack(messageBoxClosedEvent);
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult()) && StringUtils.equals((CharSequence)"summarybudget", (CharSequence)(key = messageBoxClosedEvent.getCallBackId()))) {
            this.getModel().deleteEntryData("budgetout");
            this.getModel().updateCache();
            DynamicObjectCollection controlInfoEntry = this.getModel().getEntryEntity("controlinfoentry");
            this.mergeToBudgetEntry(controlInfoEntry);
        }
    }

    protected void setOutBudgetEntrySumRow() {
        EntryGrid budgetOutEntry = (EntryGrid)this.getControl("budgetout");
        BigDecimal outAmount = this.getModel().getDataEntity().getBigDecimal("outamount");
        HashMap<String, String> floatButtomData = new HashMap<String, String>();
        DynamicObject currency = this.getModel().getDataEntity().getDynamicObject("currencyfield");
        floatButtomData.put("bdoutamount", CurrencyFormatUtil.getAfterFormatString((DynamicObject)currency, (Object)outAmount));
        budgetOutEntry.setFloatButtomData(floatButtomData);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        if (StringUtils.equals((CharSequence)"ctrloutitem", (CharSequence)name)) {
            DynamicObjectCollection treeentryentity;
            List entryIds;
            DynamicObject kind = this.getModel().getDataEntity().getDynamicObject("kind");
            if (kind == null) {
                return;
            }
            DynamicObject setting = BusinessDataServiceHelper.loadSingle((String)"pmbs_prokindctrlsetting", (String)"outtreeentryentity.outbudgetitem,intreeentryentity.inbudgetitem", (QFilter[])new QFilter[]{new QFilter("projectkind", "=", kind.getPkValue())});
            if (setting != null && (entryIds = (treeentryentity = setting.getDynamicObjectCollection("outtreeentryentity")).stream().map(o -> o.getDynamicObject("outbudgetitem").getPkValue()).collect(Collectors.toList())).size() > 0) {
                param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", entryIds));
            }
        }
    }
}

