/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.formplugin.pro;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class ProjectConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(ProjectConvertPlugin.class);

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] projectEntityArray;
        ArrayList bitIndexFieldNames = Lists.newArrayList((Object[])new String[]{"sourcedata", "bitindex", "srcindex"});
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        String projectFormId = "bd_project";
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)projectFormId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        boolean supportNewCtrlStrategy = formMetadata.getItems().stream().map(it -> {
            if (it instanceof FieldAp) {
                return it.getKey();
            }
            return null;
        }).anyMatch(bitIndexFieldNames::contains);
        logger.info("bd_project use supportNewCtrlStrategy: {}", (Object)supportNewCtrlStrategy);
        if (!supportNewCtrlStrategy) {
            return;
        }
        for (ExtendedDataEntity projectEntity : projectEntityArray = targetExtDataEntitySet.FindByEntityKey(projectFormId)) {
            DynamicObject project = projectEntity.getDataEntity();
            new BaseDataCommonService().generateBaseDataBitIndexAndSourceId(new DynamicObject[]{project}, projectFormId);
            DynamicObject orgCu = project.getDynamicObject("createorg");
            if (orgCu == null) continue;
            String ctrlStrategy = BaseDataServiceHelper.getBdCtrlStrgy((String)projectFormId, (String)orgCu.getPkValue().toString());
            project.set("ctrlstrategy", (Object)ctrlStrategy);
        }
    }
}

