/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.formplugin.pro;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.RefEntityTypeCache;
import kd.bos.entity.RefPropType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextAreaProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextAreaField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.pmgt.pmas.formplugin.base.AbstractPmasBillPlugin;
import kd.pmgt.pmbs.common.enums.FieldTypeEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;
import org.apache.commons.lang3.StringUtils;

public class ProjectDynamicFieldInContainerPlugin
extends AbstractPmasBillPlugin
implements ClickListener,
BeforeF7SelectListener,
UploadListener {
    private static final String KEY_MYFIELDCONTAINER = "dynamicfieldincontainer";
    private static final String GROUPID_SUBFIX_KEY = "_groupId";
    private static final String BOS_ASSISTANT_KEY = "bos_assistantdata_detail";
    private static final String CACHE_DYNAMIC_FIELD_INFO = "cache_dynamic_field_info";

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter source = (FormShowParameter)e.getSource();
        FlexPanelAp headAp = this.createDynamicPanel(source);
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", KEY_MYFIELDCONTAINER);
        if (headAp.getKey() != null) {
            mapHead.put("items", (String)headAp.createControl().get("items"));
        }
        e.getItems().add(mapHead);
    }

    private FlexPanelAp createDynamicPanel(FormShowParameter source) {
        List<HashMap<String, String>> dynamicFieldCollects = this.getAllField(source);
        FlexPanelAp headPanelAp = new FlexPanelAp();
        if (dynamicFieldCollects.size() > 0) {
            headPanelAp.setKey("headAp");
            for (int i = 0; i <= dynamicFieldCollects.size() - 1; ++i) {
                HashMap<String, String> field = dynamicFieldCollects.get(i);
                FieldAp dynamicField = this.createDynamicField(field);
                if (dynamicField == null) continue;
                headPanelAp.getItems().add(dynamicField);
            }
        }
        return headPanelAp;
    }

    private FieldAp createDynamicField(HashMap<String, String> fieldObj) {
        String fieldkey = fieldObj.get("fieldkey");
        String showName = fieldObj.get("showname");
        String type = fieldObj.get("fieldtype");
        DateField field = null;
        if (FieldTypeEnum.DATETYPE.getValue().equals(type)) {
            field = new DateField();
        } else if (FieldTypeEnum.NUMBERTYPE.getValue().equals(type)) {
            field = new DecimalField();
            ((DecimalField)field).setScale(2);
        } else if (FieldTypeEnum.TEXTTYPE.getValue().equals(type)) {
            field = new TextField();
            ((TextField)field).setMaxLength(255);
        } else if (FieldTypeEnum.BOOLEANTYPE.getValue().equals(type)) {
            field = new CheckBoxField();
        } else if (FieldTypeEnum.TIMETYPE.getValue().equals(type)) {
            field = new DateTimeField();
        } else if (FieldTypeEnum.LONGTEXTTYPE.getValue().equals(type)) {
            field = new TextAreaField();
            ((TextAreaField)field).setMaxLength(800);
        } else if (FieldTypeEnum.ASSISTDATATYPE.getValue().equals(type)) {
            field = new BasedataField();
            field.setId(fieldkey);
            field.setKey(fieldkey);
            ((BasedataField)field).setViewDetail(false);
            String entityId = MetadataDao.getIdByNumber((String)BOS_ASSISTANT_KEY, (MetaCategory)MetaCategory.Entity);
            EntityMetadata xEntityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            field.setEntityMetadata(xEntityMetadata);
            ((BasedataField)field).setBaseEntityId(entityId);
            ((BasedataField)field).setBizBasedata(true);
        }
        FieldAp fieldAp = null;
        if (field != null) {
            fieldAp = this.createFieldAp(fieldkey, showName, type);
            field.setKey(fieldkey);
            field.setId(fieldkey);
            String o = fieldObj.get("ismustinput");
            field.setMustInput(Boolean.parseBoolean(o));
            fieldAp.setField((Field)field);
        }
        return fieldAp;
    }

    private void registDynamicProps(MainEntityType newMainType) {
        List<HashMap<String, String>> allField = this.getAllField(null);
        if (allField.size() > 0) {
            for (int i = 0; i <= allField.size() - 1; ++i) {
                DateProp property = null;
                AssistantProp dynamicComplexProperty = null;
                HashMap<String, String> fieldObj = allField.get(i);
                String fieldkey = fieldObj.get("fieldkey");
                String type = fieldObj.get("fieldtype");
                String showName = fieldObj.get("showname");
                if (FieldTypeEnum.DATETYPE.getValue().equals(type)) {
                    property = this.createDateProp(fieldkey, showName);
                } else if (FieldTypeEnum.NUMBERTYPE.getValue().equals(type)) {
                    property = this.createDecimalProp(fieldkey, showName);
                } else if (FieldTypeEnum.TEXTTYPE.getValue().equals(type)) {
                    property = this.createTextProp(fieldkey, showName);
                } else if (FieldTypeEnum.BOOLEANTYPE.getValue().equals(type)) {
                    property = this.createBooleanProp(fieldkey, showName);
                } else if (FieldTypeEnum.TIMETYPE.getValue().equals(type)) {
                    property = this.createDateTimeProp(fieldkey, showName);
                } else if (FieldTypeEnum.LONGTEXTTYPE.getValue().equals(type)) {
                    property = this.createTextAreaProp(fieldkey, showName);
                } else if (FieldTypeEnum.ASSISTDATATYPE.getValue().equals(type)) {
                    String groupId = fieldObj.get(fieldkey + GROUPID_SUBFIX_KEY);
                    dynamicComplexProperty = this.createAssProp(fieldkey, showName, BOS_ASSISTANT_KEY, groupId == null ? null : groupId.toString());
                }
                if (property != null) {
                    boolean isMust = Boolean.parseBoolean(fieldObj.get("ismustinput"));
                    ((FieldProp)property).setMustInput(isMust);
                    newMainType.registerSimpleProperty((DynamicSimpleProperty)property);
                }
                if (dynamicComplexProperty == null) continue;
                newMainType.registerComplexProperty(dynamicComplexProperty);
            }
        }
    }

    private AssistantProp createAssProp(String fieldkey, String showName, String bosAssistantKey, String groupId) {
        AssistantProp assistantProp = new AssistantProp();
        assistantProp.setName(fieldkey);
        assistantProp.setDisplayName(new LocaleString(showName));
        assistantProp.setDbIgnore(true);
        assistantProp.setAlias("");
        assistantProp.setBaseEntityId(bosAssistantKey);
        RefPropType refProp = new RefPropType();
        refProp.setId(bosAssistantKey);
        refProp.setMaster(true);
        refProp.setProps("entryid,name");
        ArrayList<RefPropType> refPropTypes = new ArrayList<RefPropType>();
        refPropTypes.add(refProp);
        RefEntityType refMasterType = (RefEntityType)RefEntityTypeCache.getRefTypes(refPropTypes, (boolean)true).get(refProp.getId());
        LongProp idProp = new LongProp();
        idProp.setAlias("Fentryid");
        idProp.setName(assistantProp.getName() + "_entryid");
        refMasterType.addProperty((DynamicProperty)idProp);
        assistantProp.setComplexType((IDataEntityType)refMasterType);
        assistantProp.setAsstTypeId(groupId);
        assistantProp.setRefIdProp((IDataEntityProperty)idProp);
        return assistantProp;
    }

    private TextProp createTextProp(String key, String displayName) {
        TextProp textProp1 = new TextProp();
        textProp1.setName(key);
        textProp1.setDisplayName(new LocaleString(displayName));
        textProp1.setDbIgnore(true);
        textProp1.setAlias("");
        return textProp1;
    }

    private TextProp createTextAreaProp(String key, String displayName) {
        TextAreaProp textProp1 = new TextAreaProp();
        textProp1.setName(key);
        textProp1.setDisplayName(new LocaleString(displayName));
        textProp1.setDbIgnore(true);
        textProp1.setAlias("");
        return textProp1;
    }

    private DateTimeProp createDateTimeProp(String key, String displayName) {
        DateTimeProp dateTimeProp = new DateTimeProp();
        dateTimeProp.setName(key);
        dateTimeProp.setDisplayName(new LocaleString(displayName));
        dateTimeProp.setDbIgnore(true);
        dateTimeProp.setAlias("");
        return dateTimeProp;
    }

    private DateProp createDateProp(String key, String displayName) {
        DateProp dateProp = new DateProp();
        dateProp.setName(key);
        dateProp.setDisplayName(new LocaleString(displayName));
        dateProp.setDbIgnore(true);
        dateProp.setAlias("");
        return dateProp;
    }

    private BooleanProp createBooleanProp(String key, String displayName) {
        BooleanProp booleanProp = new BooleanProp();
        booleanProp.setName(key);
        booleanProp.setDisplayName(new LocaleString(displayName));
        booleanProp.setDbIgnore(true);
        booleanProp.setAlias("");
        return booleanProp;
    }

    private DecimalProp createDecimalProp(String key, String displayName) {
        DecimalProp decimalProp = new DecimalProp();
        decimalProp.setName(key);
        decimalProp.setDisplayName(new LocaleString(displayName));
        decimalProp.setDbIgnore(true);
        decimalProp.setAlias("");
        return decimalProp;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void beforeBindData(EventObject e) {
        FlexPanelAp dynamicPanel = this.createDynamicPanel(null);
        Container myFldPanel = (Container)this.getView().getControl(KEY_MYFIELDCONTAINER);
        if (dynamicPanel.getKey() != null) {
            myFldPanel.getItems().addAll(((Container)dynamicPanel.buildRuntimeControl()).getItems());
        }
        this.getView().createControlIndex(myFldPanel.getItems());
    }

    public void onGetControl(OnGetControlArgs e) {
        List<HashMap<String, String>> allField = this.getAllField(null);
        if (allField.size() > 0) {
            for (int i = 0; i <= allField.size() - 1; ++i) {
                HashMap<String, String> field = allField.get(i);
                String fieldkey = field.get("fieldkey");
                String type = field.get("fieldtype");
                String groupid = field.get(fieldkey + GROUPID_SUBFIX_KEY);
                if (!StringUtils.equals((CharSequence)fieldkey, (CharSequence)e.getKey())) continue;
                Control control = this.getFieldControl(fieldkey, type, groupid == null ? null : groupid.toString());
                e.setControl(control);
            }
        }
    }

    private List<HashMap<String, String>> getAllField(FormShowParameter source) {
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        String info = null;
        info = source != null ? (String)source.getCustomParams().get(CACHE_DYNAMIC_FIELD_INFO) : (String)this.getView().getFormShowParameter().getCustomParams().get(CACHE_DYNAMIC_FIELD_INFO);
        if (StringUtils.isNotEmpty((CharSequence)info)) {
            JSONArray parse = (JSONArray)JSONArray.parse((String)info);
            result = new ArrayList(10);
            for (int i = 0; i <= parse.size() - 1; ++i) {
                JSONObject o = (JSONObject)parse.get(i);
                HashMap<String, String> temp = new HashMap<String, String>();
                for (String str : o.keySet()) {
                    temp.put(str, o.getString(str));
                }
                result.add(temp);
            }
        }
        return result;
    }

    private Control getFieldControl(String fieldkey, String type, String groupId) {
        DateEdit control = null;
        if (FieldTypeEnum.DATETYPE.getValue().equals(type)) {
            control = new DateEdit();
        } else if (FieldTypeEnum.NUMBERTYPE.getValue().equals(type)) {
            control = new DecimalEdit();
        } else if (FieldTypeEnum.TEXTTYPE.getValue().equals(type)) {
            control = new TextEdit();
        } else if (FieldTypeEnum.BOOLEANTYPE.getValue().equals(type)) {
            control = new FieldEdit();
        } else if (FieldTypeEnum.TIMETYPE.getValue().equals(type)) {
            control = new DateTimeEdit();
        } else if (FieldTypeEnum.LONGTEXTTYPE.getValue().equals(type)) {
            control = new TextEdit();
        } else if (FieldTypeEnum.ASSISTDATATYPE.getValue().equals(type)) {
            control = new BasedataEdit();
            ((BasedataEdit)control).setFieldKey(fieldkey);
            ((BasedataEdit)control).setDisplayProp("name");
            ((BasedataEdit)control).addBeforeF7SelectListener(arg0 -> {
                QFilter filter = new QFilter("group", "=", (Object)groupId);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().getQFilters().add(filter);
            });
        }
        if (control != null) {
            control.setKey(fieldkey);
            control.setView(this.getView());
        }
        return control;
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    private FieldAp createFieldAp(String key, String name, String type) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(key);
        fieldAp.setKey(key);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setBackColor("#FFFFFF");
        fieldAp.setFireUpdEvt(true);
        fieldAp.setFullLine(false);
        if (FieldTypeEnum.LONGTEXTTYPE.getValue().equals(type)) {
            fieldAp.setFullLine(true);
        }
        return fieldAp;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.embarassDynamicFlexView();
        this.updateDynamicEnable();
    }

    private void updateDynamicEnable() {
        String fieldEnable = (String)this.getView().getFormShowParameter().getCustomParam("field_enable");
        List<HashMap<String, String>> allField = this.getAllField(null);
        for (HashMap<String, String> map : allField) {
            this.getView().setEnable(Boolean.valueOf(fieldEnable), new String[]{map.get("fieldkey")});
        }
    }

    private void embarassDynamicFlexView() {
        List<HashMap<String, String>> allField = this.getAllField(null);
        for (int i = 0; i < allField.size(); ++i) {
            HashMap<String, String> object = allField.get(i);
            String fieldkey = object.get("fieldkey");
            String fieldvalue = object.get("fieldvalue");
            String fieldType = object.get("fieldtype");
            Object o = this.convertStringToDynamicField(fieldvalue, fieldType);
            this.getModel().beginInit();
            this.getModel().setValue(fieldkey, o);
            this.getView().updateView(fieldkey);
        }
    }

    private Object convertStringToDynamicField(String fieldValue, String fieldType) {
        Object object = null;
        if (fieldType.equals(FieldTypeEnum.DATETYPE.getValue())) {
            if (StringUtils.isNotEmpty((CharSequence)fieldValue)) {
                object = DateUtil.parseShortDate((String)fieldValue);
            }
        } else if (fieldType.equals(FieldTypeEnum.NUMBERTYPE.getValue())) {
            if (StringUtils.isNotEmpty((CharSequence)fieldValue)) {
                object = Double.valueOf(fieldValue);
            }
        } else if (fieldType.equals(FieldTypeEnum.TEXTTYPE.getValue())) {
            object = fieldValue;
        } else if (fieldType.equals(FieldTypeEnum.BOOLEANTYPE.getValue())) {
            object = StringUtils.isNotEmpty((CharSequence)fieldValue) ? Boolean.valueOf(fieldValue) : Boolean.FALSE;
        } else if (fieldType.equals(FieldTypeEnum.TIMETYPE.getValue())) {
            if (StringUtils.isNotEmpty((CharSequence)fieldValue)) {
                object = DateUtil.parseDate((String)fieldValue);
            }
        } else if (fieldType.equals(FieldTypeEnum.LONGTEXTTYPE.getValue())) {
            object = fieldValue;
        } else if (fieldType.equals(FieldTypeEnum.ASSISTDATATYPE.getValue())) {
            object = fieldValue;
        }
        return object;
    }

    private String convertDynamicFieldToString(Object fieldValue, String fieldType) {
        String result = null;
        if (fieldValue != null && !"".equals(fieldValue)) {
            if (fieldType.equals(FieldTypeEnum.DATETYPE.getValue())) {
                result = DateUtil.formatShortDate((Date)((Date)fieldValue));
            } else if (fieldType.equals(FieldTypeEnum.NUMBERTYPE.getValue())) {
                result = fieldValue.toString();
            } else if (fieldType.equals(FieldTypeEnum.TEXTTYPE.getValue())) {
                result = (String)fieldValue;
            } else if (fieldType.equals(FieldTypeEnum.BOOLEANTYPE.getValue())) {
                result = fieldValue.toString();
            } else if (fieldType.equals(FieldTypeEnum.TIMETYPE.getValue())) {
                result = DateUtil.formatDate((Date)((Date)fieldValue));
            } else if (fieldType.equals(FieldTypeEnum.LONGTEXTTYPE.getValue())) {
                result = (String)fieldValue;
            } else if (fieldType.equals(FieldTypeEnum.ASSISTDATATYPE.getValue())) {
                result = ((DynamicObject)fieldValue).getPkValue() + "";
            }
        }
        return result;
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
        String name = e.getProperty().getName();
        if (e.getChangeSet()[0].getNewValue() == null) {
            String info = this.getFieldInfoCache();
            JSONArray parse = (JSONArray)JSONArray.parse((String)info);
            ArrayList result = new ArrayList(10);
            boolean isNeedUpdateCache = false;
            for (int i = 0; i <= parse.size() - 1; ++i) {
                JSONObject o = (JSONObject)parse.get(i);
                HashMap<String, String> temp = new HashMap<String, String>();
                for (String str : o.keySet()) {
                    temp.put(str, o.getString(str));
                }
                String fieldType = (String)temp.get("fieldtype");
                if (((String)temp.get("fieldkey")).equals(name) && FieldTypeEnum.ASSISTDATATYPE.getValue().equals(fieldType)) {
                    isNeedUpdateCache = true;
                    temp.put("fieldvalue", null);
                }
                result.add(temp);
            }
            if (isNeedUpdateCache) {
                String fieldinfo = JSONObject.toJSONString(result);
                this.getPageCache().put(CACHE_DYNAMIC_FIELD_INFO, fieldinfo);
                this.getView().getFormShowParameter().getCustomParams().put(CACHE_DYNAMIC_FIELD_INFO, fieldinfo);
                this.getView().cacheFormShowParameter();
                this.getView().getParentView().getFormShowParameter().getCustomParams().put(CACHE_DYNAMIC_FIELD_INFO, fieldinfo);
                this.getView().getParentView().cacheFormShowParameter();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String info = this.getFieldInfoCache();
        JSONArray parse = (JSONArray)JSONArray.parse((String)info);
        ArrayList result = new ArrayList(10);
        for (int i = 0; i <= parse.size() - 1; ++i) {
            JSONObject o = (JSONObject)parse.get(i);
            HashMap<String, String> temp = new HashMap<String, String>();
            for (String str : o.keySet()) {
                temp.put(str, o.getString(str));
            }
            String fieldType = (String)temp.get("fieldtype");
            if (((String)temp.get("fieldkey")).equals(name)) {
                temp.put("fieldvalue", this.convertDynamicFieldToString(newValue, fieldType));
            }
            result.add(temp);
        }
        String fieldinfo = JSONObject.toJSONString(result);
        this.getPageCache().put(CACHE_DYNAMIC_FIELD_INFO, fieldinfo);
        this.getView().getFormShowParameter().getCustomParams().put(CACHE_DYNAMIC_FIELD_INFO, fieldinfo);
        this.getView().cacheFormShowParameter();
        this.getView().getParentView().getFormShowParameter().getCustomParams().put(CACHE_DYNAMIC_FIELD_INFO, fieldinfo);
        this.getView().getParentView().cacheFormShowParameter();
    }

    private String getFieldInfoCache() {
        String s = this.getPageCache().get(CACHE_DYNAMIC_FIELD_INFO);
        if (StringUtils.isEmpty((CharSequence)s)) {
            s = (String)this.getView().getFormShowParameter().getCustomParam(CACHE_DYNAMIC_FIELD_INFO);
            this.getPageCache().put(CACHE_DYNAMIC_FIELD_INFO, s);
        }
        return s;
    }
}

