/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.formplugin.projteam;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmas.business.helper.ProjectTeamHelper;
import kd.pmgt.pmas.formplugin.base.AbstractPmasBillPlugin;

public class AddTmemberBatchBillPlugin
extends AbstractPmasBillPlugin
implements BeforeF7SelectListener {
    private static final String SETROLE_OP = "setrole";
    private static final String SETROLE_CALLBACKID = "setrolecallback";
    private static final String OP_DELETEENTRY_OUT = "deleteentry_out";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        super.registerListener(e);
        BasedataEdit teamRole = (BasedataEdit)this.getControl("role");
        teamRole.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit partner = (BasedataEdit)this.getControl("outpartner");
        partner.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        int curRowIndex = this.getModel().getEntryCurrentRowIndex("tmemberentry");
        switch (key) {
            case "role": {
                DynamicObject member = (DynamicObject)this.getModel().getValue("member", curRowIndex);
                if (member != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u4eba\u5458\u3002", (String)"AddTmemberBatchBillPlugin_0", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "outpartner": {
                ProjectTeamHelper.beforeF7OutPartner((FormShowParameter)e.getFormShowParameter());
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "deleteentry": {
                EntryGrid entriGrid = (EntryGrid)this.getView().getControl("tmemberentry");
                int[] selectRows = entriGrid.getSelectRows();
                ArrayList<Integer> cantRemove = new ArrayList<Integer>();
                for (int row : selectRows) {
                    Boolean isOriginal = (Boolean)this.getModel().getValue("isoriginal", row);
                    if (!isOriginal.booleanValue()) continue;
                    cantRemove.add(row);
                }
                if (cantRemove.size() <= 0) break;
                String index = cantRemove.stream().map(o -> o + 1 + "").collect(Collectors.joining(","));
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u662f\u7533\u8bf7\u4eba\u63d0\u4ea4\u7684\u5185\u5bb9\uff0c\u4e0d\u53ef\u5220\u9664\u3002\u5982\u6709\u9700\u8981\uff0c\u8bf7\u4e0e\u7533\u8bf7\u4eba\u6c9f\u901a\u4fee\u6539\u7533\u8bf7\u5355\u3002", (String)"AddTmemberBatchBillPlugin_1", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), index));
                args.setCancel(true);
                break;
            }
            case "deleteentry_out": {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("outtmemberentry");
                int[] selRows = entryGrid.getSelectRows();
                ArrayList<Integer> cantRemoveLst = new ArrayList<Integer>();
                for (int row : selRows) {
                    Boolean isOriginal = (Boolean)this.getModel().getValue("outisoriginal", row);
                    if (!isOriginal.booleanValue()) continue;
                    cantRemoveLst.add(row);
                }
                if (cantRemoveLst.size() <= 0) break;
                String index = cantRemoveLst.stream().map(o -> o + 1 + "").collect(Collectors.joining(","));
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u662f\u7533\u8bf7\u4eba\u63d0\u4ea4\u7684\u5185\u5bb9\uff0c\u4e0d\u53ef\u5220\u9664\u3002\u5982\u6709\u9700\u8981\uff0c\u8bf7\u4e0e\u7533\u8bf7\u4eba\u6c9f\u901a\u4fee\u6539\u7533\u8bf7\u5355\u3002", (String)"AddTmemberBatchBillPlugin_1", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), index));
                args.setCancel(true);
                break;
            }
            case "setrole": {
                EntryGrid gird = (EntryGrid)this.getControl("tmemberentry");
                int[] selectedRows = gird.getEntryState().getSelectedRows();
                if (selectedRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u8bf7\u660e\u7ec6\u884c\u3002", (String)"AddTmemberBatchBillPlugin_2", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                    break;
                }
                List<Long> selectUserIds = this.getSelectUserIds(selectedRows);
                DynamicObject[] userRoles = BusinessDataServiceHelper.load((String)"perm_userrole", (String)"user,role,role.name", (QFilter[])new QFilter[]{new QFilter("user", "in", selectUserIds)});
                List roles = Arrays.stream(userRoles).filter(o -> o.getDynamicObject("role") != null).map(o -> o.getDynamicObject("role").getPkValue().toString()).collect(Collectors.toList());
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("formId", "pmas_setrole");
                hashMap.put("roles", roles);
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(hashMap);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SETROLE_CALLBACKID));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
                break;
            }
        }
    }

    private List<Long> getSelectUserIds(int[] selectedRows) {
        ArrayList<Long> entryIds = new ArrayList<Long>(10);
        for (int row : selectedRows) {
            Long entryId = (Long)this.getModel().getEntryRowEntity("tmemberentry", row).getPkValue();
            entryIds.add(entryId);
        }
        List<String> memberIds = this.querySelectMemberIds(entryIds);
        return memberIds.stream().map(s -> Long.valueOf(s.trim())).collect(Collectors.toList());
    }

    private List<String> querySelectMemberIds(List<Long> entryIds) {
        String collect = entryIds.stream().map(Object::toString).collect(Collectors.joining(","));
        String selectMember = "select fmemberid from t_pmas_addtmemberentry where fentryid in (" + collect + ")";
        List fmemberids = (List)DB.query((DBRoute)new DBRoute(EntityMetadataCache.getDataEntityType((String)"pmas_addtmemberbill").getDBRouteKey()), (String)selectMember, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> memberids = new ArrayList<String>(10);
                while (rs.next()) {
                    memberids.add(rs.getObject("fmemberid").toString());
                }
                return memberids;
            }
        });
        return fmemberids;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "setrolecallback": {
                int[] selectedRows;
                DynamicObject setRoleObj = (DynamicObject)closedCallBackEvent.getReturnData();
                if (setRoleObj == null) break;
                String roleId = setRoleObj.getPkValue().toString();
                EntryGrid gird = (EntryGrid)this.getControl("tmemberentry");
                for (int row : selectedRows = gird.getEntryState().getSelectedRows()) {
                    DynamicObject member = (DynamicObject)this.getModel().getValue("member", row);
                    if (member == null) continue;
                    this.getModel().setValue("role", (Object)roleId, row);
                }
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        int curIndex = changeData.getRowIndex();
        switch (name) {
            case "member": {
                if (!this.isUserRoleUnique(curIndex)) {
                    this.getModel().setValue("member", changeData.getOldValue(), curIndex);
                    break;
                }
                if (newValue == null) {
                    this.getModel().setValue("telno", null, curIndex);
                    break;
                }
                DynamicObject member = (DynamicObject)newValue;
                this.getModel().setValue("telno", (Object)member.getString("phone"), curIndex);
                break;
            }
            case "role": {
                if (this.isUserRoleUnique(curIndex)) break;
                this.getModel().setValue("role", changeData.getOldValue(), curIndex);
                break;
            }
            case "outpartner": {
                DynamicObject partner = (DynamicObject)newValue;
                if (partner == null) break;
                this.getModel().setValue("outbizparter", (Object)ProjectTeamHelper.getBizPartner((Object)partner.getPkValue()), curIndex);
                break;
            }
        }
    }

    private boolean isUserRoleUnique(int changeIndex) {
        long count;
        List members;
        boolean isUnique = true;
        DynamicObject member = (DynamicObject)this.getModel().getValue("member", changeIndex);
        DynamicObject role = (DynamicObject)this.getModel().getValue("role", changeIndex);
        DynamicObjectCollection entries = this.getModel().getEntryEntity("tmemberentry");
        if (member != null) {
            members = entries.stream().filter(o -> member.getPkValue().equals(o.getDynamicObject("member") == null ? null : o.getDynamicObject("member").getPkValue())).collect(Collectors.toList());
            if (role != null && (count = members.stream().filter(o -> role.getPkValue().equals(o.getDynamicObject("role") == null ? null : o.getDynamicObject("role").getPkValue())).count()) > 1L) {
                isUnique = false;
            }
        }
        if (role != null) {
            members = entries.stream().filter(o -> role.getPkValue().equals(o.getDynamicObject("role") == null ? null : o.getDynamicObject("role").getPkValue())).collect(Collectors.toList());
            if (member != null && (count = members.stream().filter(o -> member.getPkValue().equals(o.getDynamicObject("member") == null ? null : o.getDynamicObject("member").getPkValue())).count()) > 1L) {
                isUnique = false;
            }
        }
        if (!isUnique) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4eba\u5458\uff1a%1$s\uff0c\u89d2\u8272\uff1a%2$s\uff0c\u5df2\u5728\u7533\u8bf7\u660e\u7ec6\u4e2d\u3002", (String)"AddTmemberBatchBillPlugin_3", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), member.getString("name"), role.getString("name")));
            this.getModel().setValue("role", null, changeIndex);
        }
        return isUnique;
    }
}

