/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.business.helper;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.enums.BillTypeEnum;
import kd.pmgt.pmbs.common.enums.BudgetCtlModeEnum;
import kd.pmgt.pmbs.common.enums.BudgetCtrlEnum;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.coderule.CodeRuleHelper;
import kd.pmgt.pmbs.servicehelper.BudgetCtrlHelper;

public class ApprovalAmtModifyOpHelper {
    private static final Log logger = LogFactory.getLog(ApprovalAmtModifyOpHelper.class);
    private static final String NUMBER_PREFIX = "_AMT_MODIFY_";

    public static void saveAdjustFundSource(DynamicObject dataEntity) {
        DynamicObject org;
        BigDecimal newVersion;
        DynamicObjectCollection fundSourceEntries = dataEntity.getDynamicObjectCollection("fundsourceentry");
        if (fundSourceEntries.size() == 0) {
            return;
        }
        DynamicObject project = dataEntity.getDynamicObject("project");
        QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
        projectFilter.and(new QFilter("isvalid", "=", (Object)true));
        Date year = dataEntity.getDate("year");
        if (year != null) {
            int curYearInt = year.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
            projectFilter.and("YEAR(year)", "=", (Object)curYearInt);
        }
        DynamicObject fundSource = BusinessDataServiceHelper.loadSingle((String)"pmas_projfundsource", (QFilter[])new QFilter[]{projectFilter});
        DynamicObject source = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_projfundsource"));
        source.set("project", (Object)project);
        source.set("org", dataEntity.get("org"));
        source.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
        source.set("projkind", dataEntity.get("kind"));
        source.set("issys", (Object)DefaultEnum.YES.getValue());
        source.set("isvalid", (Object)DefaultEnum.YES.getValue());
        BigDecimal amount = fundSourceEntries.stream().map(obj -> obj.getBigDecimal("fundsumamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal curInvestamt = fundSourceEntries.stream().map(obj -> obj.getBigDecimal("fundamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        source.set("totalamount", (Object)amount);
        source.set("curinvestamt", (Object)curInvestamt);
        source.set("createorg", dataEntity.get("createorg"));
        source.set("currency", dataEntity.get("currency"));
        source.set("createtime", (Object)dataEntity.getDate("auditdate"));
        source.set("creator", dataEntity.get("creator"));
        source.set("auditor", dataEntity.get("auditor"));
        source.set("auditdate", (Object)dataEntity.getDate("auditdate"));
        source.set("modifier", dataEntity.get("modifier"));
        source.set("modifytime", (Object)dataEntity.getDate("modifytime"));
        if (fundSource != null) {
            newVersion = fundSource.getBigDecimal("version").add(BigDecimal.ONE);
            source.set("billname", (Object)String.format(ResManager.loadKDString((String)"%1$s_\u91d1\u989d\u53d8\u66f4_%2$s", (String)"ApprovalAmtModifyOpHelper_0", (String)"pmgt-pmas-business", (Object[])new Object[0]), project.get("number"), newVersion));
            source.set("version", (Object)newVersion);
            source.set("type", (Object)BillTypeEnum.ADJUST.getValue());
            source.set("totaloldamount", fundSource.get("totalamount"));
            source.set("totaldiffamount", (Object)amount.subtract(fundSource.getBigDecimal("totalamount")));
            source.set("budgetperiod", fundSource.get("budgetperiod"));
            source.set("budgetproname", fundSource.get("budgetproname"));
            source.set("budgetpronumber", fundSource.get("budgetpronumber"));
        } else {
            newVersion = BigDecimal.ONE;
            source.set("billname", (Object)String.format(ResManager.loadKDString((String)"%1$s_\u91d1\u989d\u53d8\u66f4_%2$s", (String)"ApprovalAmtModifyOpHelper_0", (String)"pmgt-pmas-business", (Object[])new Object[0]), project.get("number"), newVersion));
            source.set("version", (Object)newVersion);
            source.set("type", (Object)BillTypeEnum.NEW.getValue());
        }
        if (year != null) {
            source.set("year", (Object)year);
        }
        if ((org = dataEntity.getDynamicObject("org")) != null) {
            String billNo = CodeRuleHelper.getBillNo((String)"pmas_projfundsource", (DynamicObject)source, (String)org.getPkValue().toString());
            if (StringUtils.isEmpty((CharSequence)billNo)) {
                billNo = project.get("number") + NUMBER_PREFIX + source.getBigDecimal("version").setScale(1, 4);
            }
            source.set("billno", (Object)billNo);
        }
        DynamicObjectCollection funSourceCollection = source.getDynamicObjectCollection("fundentry");
        for (DynamicObject funSource : fundSourceEntries) {
            DynamicObject sourceEntry = new DynamicObject(funSourceCollection.getDynamicObjectType());
            sourceEntry.set("sourcetype", (Object)funSource.getDynamicObject("fundsourcetype"));
            sourceEntry.set("amount", (Object)funSource.getBigDecimal("fundsumamount"));
            sourceEntry.set("currententryamt", (Object)funSource.getBigDecimal("fundamount"));
            sourceEntry.set("oldamount", (Object)funSource.getBigDecimal("fundoldamount"));
            sourceEntry.set("diffamount", (Object)funSource.getBigDecimal("fundamount").subtract(funSource.getBigDecimal("fundoldamount")));
            sourceEntry.set("note", (Object)funSource.getString("funddescription"));
            sourceEntry.set("formofinvest", (Object)funSource.getString("fundformofinvest"));
            sourceEntry.set("investcurrency", (Object)funSource.getDynamicObject("entrycurrency"));
            sourceEntry.set("scale", (Object)funSource.getBigDecimal("fundscale"));
            funSourceCollection.add((Object)sourceEntry);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{source});
        if (fundSource != null) {
            fundSource.set("isvalid", (Object)false);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fundSource});
        }
    }

    public static void saveApprovalAndSysPro(DynamicObject dataEntity, DynamicObject approval) {
        int applyDateInt;
        int curYearInt;
        String modifyBillNo = dataEntity.getString("modifybillno");
        String modifyName = dataEntity.getString("modifyname");
        boolean isNameModify = false;
        if (StringUtils.isNotEmpty((CharSequence)modifyBillNo) && !approval.getString("billno").equalsIgnoreCase(modifyBillNo)) {
            approval.set("billno", (Object)modifyBillNo);
            isNameModify = true;
        }
        if (modifyName != null && !approval.getString("billname").equalsIgnoreCase(modifyName)) {
            approval.set("billname", (Object)modifyName);
            isNameModify = true;
        }
        Date year = dataEntity.getDate("year");
        Date applyDate = approval.getDate("projectapplydate");
        boolean isSameYear = false;
        if (year != null && applyDate != null && (curYearInt = year.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear()) == (applyDateInt = applyDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear())) {
            isSameYear = true;
        }
        boolean isAmountModify = false;
        BigDecimal afterProAmt = dataEntity.getBigDecimal("afterproamt");
        BigDecimal afterProYearAmt = dataEntity.getBigDecimal("afterproyearamt");
        if (afterProAmt.compareTo(dataEntity.getBigDecimal("projectbugamt")) != 0 && isSameYear) {
            approval.set("projcetbugamt", (Object)afterProAmt);
            isAmountModify = true;
        }
        if (afterProYearAmt.compareTo(dataEntity.getBigDecimal("proyearbudgetamt")) != 0 && isSameYear) {
            approval.set("proyearbudgetamt", (Object)afterProYearAmt);
            isAmountModify = true;
        }
        if (isAmountModify || isNameModify) {
            SaveServiceHelper.update((DynamicObject)approval);
        }
        if (isNameModify) {
            ApprovalAmtModifyOpHelper.saveSysPro(dataEntity);
        }
    }

    public static void saveSysPro(DynamicObject dataEntity) {
        DynamicObject project = dataEntity.getDynamicObject("project");
        if (project != null) {
            DynamicObject sysPro = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project");
            sysPro.set("number", dataEntity.get("modifybillno"));
            sysPro.set("name", dataEntity.get("modifyname"));
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{sysPro});
                }
                catch (Exception e1) {
                    logger.error("\u540c\u6b65\u65b0\u589e\u9879\u76ee\u5f02\u5e38", (Throwable)e1);
                    h.markRollback();
                    throw e1;
                }
            }
        }
    }

    public static boolean validateIsOccupyAmount(DynamicObject dataEntity) {
        DynamicObjectCollection realBudgetEntries = dataEntity.getDynamicObjectCollection("realbudgetentry");
        return realBudgetEntries.stream().anyMatch(realBudget -> realBudget.getBigDecimal("realdifferenceamt").compareTo(BigDecimal.ZERO) != 0);
    }

    public static void saveBudgetRecord(DynamicObject dataEntity) {
        String billNo = dataEntity.getString("billno");
        Long pk = (Long)dataEntity.getPkValue();
        QFilter qFilter = pk == 0L ? new QFilter("billno", "=", (Object)billNo) : new QFilter("relatebillid", "=", (Object)pk.toString());
        DynamicObject budgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (QFilter[])new QFilter[]{qFilter});
        if (budgetRecord != null) {
            String billSource = budgetRecord.getString("billsource");
            if (StringUtils.equals((CharSequence)"pmas_approval_amtmodify", (CharSequence)billSource)) {
                ApprovalAmtModifyOpHelper.setBudgetRecordFieldValue(dataEntity, budgetRecord, true);
            } else {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmco_budgetrecord");
                budgetRecord = new DynamicObject((DynamicObjectType)dt);
                budgetRecord.set("id", (Object)ORM.create().genLongId("pmco_budgetrecord"));
                ApprovalAmtModifyOpHelper.setBudgetRecordFieldValue(dataEntity, budgetRecord, false);
            }
        } else {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmco_budgetrecord");
            budgetRecord = new DynamicObject((DynamicObjectType)dt);
            budgetRecord.set("id", (Object)ORM.create().genLongId("pmco_budgetrecord"));
            ApprovalAmtModifyOpHelper.setBudgetRecordFieldValue(dataEntity, budgetRecord, false);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{budgetRecord});
    }

    public static void occupyAmount(DynamicObject dataEntity, DynamicObject budgetRecord) {
        if (budgetRecord != null && ApprovalAmtModifyOpHelper.validateIsOccupyAmount(dataEntity)) {
            try {
                DynamicObject lastBudgetRecord = ApprovalAmtModifyOpHelper.getLatestBudgetRecord(dataEntity);
                if (lastBudgetRecord != null) {
                    String lastBillNo = lastBudgetRecord.getString("billno");
                    String msg = String.format(ResManager.loadKDString((String)"\u7acb\u9879\u91d1\u989d\u8c03\u6574\u5355\u201c%1$s\u201d%2$s\u64cd\u4f5c\uff0c\u5bf9\u4e0a\u4e00\u5f20\u5355\u201c%3$s\u201d\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u8fd4\u8fd8\u63a5\u53e3\u201cBgControlService.returnBudget\u201d\uff0c\u8fd4\u8fd8\u64cd\u4f5c%4$s\uff1a", (String)"ApprovalAmtModifyOpHelper_1", (String)"pmgt-pmas-business", (Object[])new Object[0]), dataEntity.getString("billno"), "submit", lastBillNo, "unsubmitoccupy");
                    BudgetCtrlHelper.returnBudget((DynamicObject)lastBudgetRecord, (String)"pmco_budgetrecord", (String)"unsubmitoccupy", (String)msg);
                }
                String msg = String.format(ResManager.loadKDString((String)"\u7acb\u9879\u91d1\u989d\u8c03\u6574\u5355\u201c%1$s\u201d%2$s\u64cd\u4f5c\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u6263\u51cf\u63a5\u53e3\u201cBgControlService.requestBudget\u201d\u505a\u5360\u7528\uff0c\u5360\u7528\u64cd\u4f5c%3$s\uff1a", (String)"ApprovalAmtModifyOpHelper_2", (String)"pmgt-pmas-business", (Object[])new Object[0]), dataEntity.getString("billno"), "submit", "submitoccupy");
                BudgetCtrlHelper.requestBudget((DynamicObject)budgetRecord, (String)"pmco_budgetrecord", (String)"submitoccupy", (boolean)true, (String)msg);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                DynamicObject lastBudgetRecord = ApprovalAmtModifyOpHelper.getLatestBudgetRecord(dataEntity);
                if (lastBudgetRecord != null) {
                    String lastBillNo = lastBudgetRecord.getString("billno");
                    String msg = String.format(ResManager.loadKDString((String)"\u7acb\u9879\u91d1\u989d\u8c03\u6574\u5355\u201c%1$s\u201d%2$s\u64cd\u4f5c\uff0c\u5bf9\u4e0a\u4e00\u5f20\u5355\u201c%3$s\u201d\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u6263\u51cf\u63a5\u53e3\u201cBgControlService.returnBudget\u201d\uff0c\u5360\u7528\u64cd\u4f5c%4$s\uff1a", (String)"ApprovalAmtModifyOpHelper_3", (String)"pmgt-pmas-business", (Object[])new Object[0]), dataEntity.getString("billno"), "submit", lastBillNo, "unsubmitoccupy");
                    BudgetCtrlHelper.requestBudget((DynamicObject)lastBudgetRecord, (String)"pmco_budgetrecord", (String)"unsubmitoccupy", (boolean)true, (String)msg);
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u8fd4\u8fd8\u6263\u51cf\u63a5\u53e3\u5931\u8d25:%s\u201d", (String)"ApprovalAmtModifyOpHelper_4", (String)"pmgt-pmas-business", (Object[])new Object[0]), e));
            }
        }
    }

    public static void occupyChangeAmount(DynamicObject dataEntity, DynamicObject budgetRecord) {
        if (budgetRecord != null && ApprovalAmtModifyOpHelper.validateIsOccupyAmount(dataEntity)) {
            try {
                String msg = String.format(ResManager.loadKDString((String)"\u7acb\u9879\u91d1\u989d\u8c03\u6574\u5355\u201c%1$s\u201d%2$s\u64cd\u4f5c\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u6263\u51cf\u63a5\u53e3\u201cBgControlService.requestBudget\u201d\u505a\u5360\u7528\uff0c\u5360\u7528\u64cd\u4f5c%3$s\uff1a", (String)"ApprovalAmtModifyOpHelper_2", (String)"pmgt-pmas-business", (Object[])new Object[0]), dataEntity.getString("billno"), "submit", "submitoccupy");
                BudgetCtrlHelper.requestBudget((DynamicObject)budgetRecord, (String)"pmco_budgetrecord", (String)"submitoccupy", (boolean)true, (String)msg);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw new KDBizException(e.toString());
            }
        }
    }

    public static void setBudgetRecordFieldValue(DynamicObject dataEntity, DynamicObject budgetRecord, boolean isExistRecord) {
        DynamicObject project;
        QFilter proQFilter;
        DynamicObject approval;
        String budgetControlMode = dataEntity.getString("budgetcontrolmode");
        budgetRecord.set("billno", dataEntity.get("billno"));
        budgetRecord.set("billstatus", (Object)StatusEnum.UNCHECKED.getValue());
        budgetRecord.set("org", dataEntity.get("org"));
        budgetRecord.set("billsource", (Object)"pmas_approval_amtmodify");
        Long pk = (Long)dataEntity.getPkValue();
        if (pk != 0L) {
            budgetRecord.set("relatebillid", (Object)pk.toString());
        }
        if ((approval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (QFilter[])new QFilter[]{proQFilter = new QFilter("pro", "=", (project = dataEntity.getDynamicObject("project")).getPkValue())})) != null) {
            budgetRecord.set("budgetstage", approval.get("budgetstage"));
            budgetRecord.set("projectapplydate", approval.get("projectapplydate"));
            budgetRecord.set("projectcostcontrol", approval.get("projectcostcontrol"));
        }
        budgetRecord.set("project", dataEntity.get("project"));
        budgetRecord.set("totalamount", dataEntity.get("outamount"));
        budgetRecord.set("group", dataEntity.get("kind"));
        budgetRecord.set("currency", dataEntity.get("currency"));
        budgetRecord.set("budgetcontrolmode", dataEntity.get("budgetcontrolmode"));
        budgetRecord.set("isvalid", (Object)Boolean.FALSE);
        if (!isExistRecord) {
            budgetRecord.set("createtime", (Object)new Date());
        }
        budgetRecord.set("modifytime", (Object)new Date());
        DynamicObjectCollection realBudgetEntryCol = dataEntity.getDynamicObjectCollection("realbudgetentry");
        DynamicObjectCollection outBudgetControlInfoEntry = budgetRecord.getDynamicObjectCollection("realbudgetentry");
        DynamicObjectType type = outBudgetControlInfoEntry.getDynamicObjectType();
        outBudgetControlInfoEntry.clear();
        if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue()) || StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue())) {
            int rowIndex = 0;
            for (DynamicObject realBudgetEntry : realBudgetEntryCol) {
                DynamicObject outBudgetControlInfo = new DynamicObject(type);
                outBudgetControlInfo.set("seq", (Object)rowIndex);
                outBudgetControlInfo.set("realprobudgetname", realBudgetEntry.get("realprobudgetname"));
                outBudgetControlInfo.set("realbudgetitem", realBudgetEntry.get("realbudgetitem"));
                outBudgetControlInfo.set("realundertakeorg", realBudgetEntry.get("realundertakeorg"));
                outBudgetControlInfo.set("realundertakeperiod", realBudgetEntry.get("realundertakeperiod"));
                outBudgetControlInfo.set("realproname", realBudgetEntry.get("realproname"));
                outBudgetControlInfo.set("realpronumber", realBudgetEntry.get("realpronumber"));
                outBudgetControlInfo.set("realproid", realBudgetEntry.get("realproid"));
                outBudgetControlInfo.set("realundertakeamt", realBudgetEntry.get("realundertakeamt"));
                outBudgetControlInfo.set("realdifferenceamt", realBudgetEntry.get("realdifferenceamt"));
                outBudgetControlInfo.set("realbeforeamt", realBudgetEntry.get("realbeforeamt"));
                outBudgetControlInfoEntry.add((Object)outBudgetControlInfo);
                ++rowIndex;
            }
        }
    }

    public static void updateBudgetRecordField(DynamicObject dataEntity, String operate) {
        QFilter qFilter = new QFilter("relatebillid", "=", (Object)dataEntity.getPkValue().toString());
        DynamicObject curBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (QFilter[])new QFilter[]{qFilter});
        String budgetControlMode = dataEntity.getString("budgetcontrolmode");
        if (curBudgetRecord == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.NOTCONTROL.getValue())) {
            return;
        }
        if (StringUtils.equals((CharSequence)operate, (CharSequence)"audit")) {
            curBudgetRecord.set("isvalid", (Object)Boolean.TRUE);
            curBudgetRecord.set("modifytime", (Object)new Date());
            curBudgetRecord.set("auditdate", (Object)new Date());
            curBudgetRecord.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
            Date applyDate = dataEntity.getDate("projectapplydate");
            if (applyDate != null) {
                LocalDate localDate = applyDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    curBudgetRecord.set("year", (Object)sdf.parse(localDate.getYear() + "-01-01"));
                }
                catch (ParseException e) {
                    logger.info("\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff1a{}", (Object)e);
                }
            }
            DynamicObject project = dataEntity.getDynamicObject("project");
            QFilter proQFilter = new QFilter("project", "=", project.getPkValue());
            proQFilter.and(new QFilter("isvalid", "=", (Object)Boolean.TRUE));
            DynamicObject[] budgetRecords = BusinessDataServiceHelper.load((String)"pmco_budgetrecord", (String)"id,isvalid", (QFilter[])new QFilter[]{proQFilter});
            if (budgetRecords.length > 0) {
                for (DynamicObject budgetRecord : budgetRecords) {
                    budgetRecord.set("isvalid", (Object)Boolean.FALSE);
                }
                SaveServiceHelper.save((DynamicObject[])budgetRecords);
            }
        } else if (StringUtils.equals((CharSequence)operate, (CharSequence)"unsubmit")) {
            curBudgetRecord.set("billstatus", (Object)StatusEnum.TEMPSAVE.getValue());
            curBudgetRecord.set("isvalid", (Object)Boolean.FALSE);
            curBudgetRecord.set("modifytime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{curBudgetRecord});
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{curBudgetRecord});
    }

    public static void returnOccupyAmount(DynamicObject dataEntity, String curOperate) {
        String billNo = dataEntity.getString("billno");
        QFilter qFilter = new QFilter("relatebillid", "=", (Object)dataEntity.getPkValue().toString());
        DynamicObject newBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (QFilter[])new QFilter[]{qFilter});
        try {
            DynamicObject LatestBudgetRecord;
            String msg = String.format(ResManager.loadKDString((String)"\u7acb\u9879\u91d1\u989d\u8c03\u6574\u5355\u201c%1$s\u201d%2$s\u64cd\u4f5c\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u8fd4\u8fd8\u63a5\u53e3\u201cBgControlService.returnBudget\u201d\uff0c\u8fd4\u8fd8\u64cd\u4f5c%3$s\uff1a", (String)"ApprovalAmtModifyOpHelper_5", (String)"pmgt-pmas-business", (Object[])new Object[0]), billNo, curOperate, "unsubmitoccupy");
            if (newBudgetRecord != null) {
                BudgetCtrlHelper.returnBudget((DynamicObject)newBudgetRecord, (String)"pmco_budgetrecord", (String)"unsubmitoccupy", (String)msg);
            }
            if ((LatestBudgetRecord = ApprovalAmtModifyOpHelper.getLatestBudgetRecord(dataEntity)) != null) {
                String lastBillNo = LatestBudgetRecord.getString("billno");
                msg = String.format(ResManager.loadKDString((String)"\u7acb\u9879\u91d1\u989d\u8c03\u6574\u5355\u201c%1$s\u201d%2$s\u64cd\u4f5c\uff0c\u5bf9\u4e0a\u4e00\u5f20\u5355\u201c%3$s\u201d\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u5360\u7528\u63a5\u53e3\u201cBgControlService.returnBudget\u201d\uff0c\u9884\u7b97\u5360\u7528\u64cd\u4f5c%4$s\uff1a", (String)"ApprovalAmtModifyOpHelper_6", (String)"pmgt-pmas-business", (Object[])new Object[0]), dataEntity.getString("billno"), curOperate, lastBillNo, "unsubmitoccupy");
                BudgetCtrlHelper.requestBudget((DynamicObject)LatestBudgetRecord, (String)"pmco_budgetrecord", (String)"submitoccupy", (boolean)true, (String)msg);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            if (newBudgetRecord != null) {
                String msg = String.format(ResManager.loadKDString((String)"\u7acb\u9879\u91d1\u989d\u8c03\u6574\u5355\u201c%1$s\u201d%2$s\u64cd\u4f5c\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u6263\u51cf\u63a5\u53e3\u201cBgControlService.requestBudget\u201d\u505a\u5360\u7528\uff0c\u5360\u7528\u64cd\u4f5c%3$s\uff1a", (String)"ApprovalAmtModifyOpHelper_2", (String)"pmgt-pmas-business", (Object[])new Object[0]), dataEntity.getString("billno"), "submit", "submitoccupy");
                BudgetCtrlHelper.requestBudget((DynamicObject)newBudgetRecord, (String)"pmco_budgetrecord", (String)"submitoccupy", (boolean)true, (String)msg);
            }
            throw new KDBizException(e.toString());
        }
    }

    public static void returnOccupyChangeAmount(DynamicObject dataEntity, String curOperate) {
        String billNo = dataEntity.getString("billno");
        try {
            String msg = String.format(ResManager.loadKDString((String)"\u7acb\u9879\u91d1\u989d\u8c03\u6574\u5355\u201c%1$s\u201d%2$s\u64cd\u4f5c\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u8fd4\u8fd8\u63a5\u53e3\u201cBgControlService.returnBudget\u201d\uff0c\u8fd4\u8fd8\u64cd\u4f5c%3$s\uff1a", (String)"ApprovalAmtModifyOpHelper_5", (String)"pmgt-pmas-business", (Object[])new Object[0]), billNo, curOperate, "unsubmitoccupy");
            QFilter qFilter = new QFilter("relatebillid", "=", (Object)dataEntity.getPkValue().toString());
            DynamicObject newBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (QFilter[])new QFilter[]{qFilter});
            if (newBudgetRecord != null) {
                BudgetCtrlHelper.returnBudget((DynamicObject)newBudgetRecord, (String)"pmco_budgetrecord", (String)"unsubmitoccupy", (String)msg);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(e.toString());
        }
    }

    public static DynamicObject getLatestBudgetRecord(DynamicObject dataEntity) {
        DynamicObject project = dataEntity.getDynamicObject("project");
        QFilter proQFilter = new QFilter("project", "=", project.getPkValue());
        proQFilter.and(new QFilter("isvalid", "=", (Object)Boolean.TRUE));
        return BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (QFilter[])new QFilter[]{proQFilter});
    }

    public static void validateBudgetBalance(DynamicObject dataEntity) {
        BudgetCtrlHelper.invokeAdjustInterface((DynamicObject)dataEntity, (BudgetCtrlEnum)BudgetCtrlEnum.SUBMIT);
    }

    public static void updateProjectBudgetCtrl(DynamicObject approval) {
        if (approval == null) {
            return;
        }
        DynamicObject project = approval.getDynamicObject("pro");
        if (project == null) {
            return;
        }
        boolean isNewProBudgetCtrl = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)((Long)project.getPkValue()));
        if (!isNewProBudgetCtrl) {
            return;
        }
        project = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project");
        QFilter tFilter = new QFilter("tproject", "=", (Object)Long.parseLong(project.getPkValue().toString()));
        tFilter.and("tbudgettype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
        DynamicObject totalBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{tFilter});
        if (totalBudgetCtrl != null) {
            totalBudgetCtrl.set("proappamt", approval.get("projcetbugamt"));
            totalBudgetCtrl.set("proapporiamt", approval.get("projcetbugamt"));
            if (totalBudgetCtrl.getDynamicObjectCollection("tbudgetctrldetail").size() == 0) {
                totalBudgetCtrl.set("tsumbudamt", approval.get("proyearbudgetamt"));
            }
            SaveServiceHelper.update((DynamicObject)totalBudgetCtrl);
            ProBudgetControlHelper.updateTotalCtrlRate((DynamicObject)project);
        }
        QFilter yFilter = new QFilter("yproject", "=", (Object)Long.parseLong(project.getPkValue().toString()));
        yFilter.and("ybudgettype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
        Date projectApplyDate = approval.getDate("projectapplydate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        if (projectApplyDate == null) {
            projectApplyDate = new Date();
        }
        int year = Integer.parseInt(sdf.format(projectApplyDate));
        yFilter.and("YEAR(yyear)", "=", (Object)year);
        DynamicObject yearBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrl", (QFilter[])new QFilter[]{yFilter});
        if (yearBudgetCtrl != null) {
            yearBudgetCtrl.set("yearproamt", approval.get("proyearbudgetamt"));
            yearBudgetCtrl.set("yearprooriamt", approval.get("proyearbudgetamt"));
            if (yearBudgetCtrl.getDynamicObjectCollection("ybudgetctrldetail").size() == 0) {
                yearBudgetCtrl.set("ybudgetamt", approval.get("proyearbudgetamt"));
            }
            SaveServiceHelper.update((DynamicObject)yearBudgetCtrl);
            ProBudgetControlHelper.updateYearCtrlRate((DynamicObject)project);
        }
    }
}

