/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.business.helper;

import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.business.helper.ProjectInitiationHelper;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class BudgetBillHelper {
    private static final Log logger = LogFactory.getLog(BudgetBillHelper.class);

    public DynamicObject getPreBudgetStage(DynamicObject project, DynamicObject budgetStage, String budgetSourceType) {
        DynamicObject preBudgetStage = null;
        if (budgetStage == null) {
            return null;
        }
        if (project != null) {
            QFilter proFilter = new QFilter("project", "=", project.getPkValue());
            QFilter typeFilter = new QFilter("sourcetype", "=", (Object)budgetSourceType);
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            QFilter validFilter = new QFilter("isvalid", "=", (Object)"1");
            QFilter seqNoFilter = new QFilter("budgetstage.seqno", "<", budgetStage.get("seqno"));
            DynamicObject[] query = BusinessDataServiceHelper.load((String)"pmas_budget", (String)"id", (QFilter[])new QFilter[]{proFilter, typeFilter, statusFilter, seqNoFilter, validFilter}, (String)"budgetstage.seqno desc", (int)1);
            if (query != null && query.length > 0) {
                DynamicObject preBudget = BusinessDataServiceHelper.loadSingle((Object)query[0].getPkValue(), (String)"pmas_budget");
                preBudgetStage = (DynamicObject)preBudget.get("budgetstage");
            }
        }
        return preBudgetStage;
    }

    public DynamicObject getPreBudgetStage(DynamicObject project, DynamicObject budgetStage) {
        DynamicObject preBudgetStage = null;
        if (budgetStage == null) {
            return null;
        }
        if (project != null) {
            QFilter proFilter = new QFilter("project", "=", project.getPkValue());
            QFilter typeFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            QFilter validFilter = new QFilter("isvalid", "=", (Object)"1");
            QFilter seqNoFilter = new QFilter("budgetstage.seqno", "<", budgetStage.get("seqno"));
            DynamicObject[] query = BusinessDataServiceHelper.load((String)"pmas_budget", (String)"id,year", (QFilter[])new QFilter[]{proFilter, typeFilter, statusFilter, seqNoFilter, validFilter}, (String)"budgetstage.seqno desc,year desc", (int)1);
            if (query != null && query.length > 0) {
                DynamicObject preBudget = BusinessDataServiceHelper.loadSingle((Object)query[0].getPkValue(), (String)"pmas_budget");
                preBudgetStage = (DynamicObject)preBudget.get("budgetstage");
            }
        }
        return preBudgetStage;
    }

    public DynamicObject getProApprovalInfo(Long projectId) {
        QFilter qFilter = new QFilter("pro", "=", (Object)projectId);
        return BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (QFilter[])new QFilter[]{qFilter});
    }

    public BigDecimal getAllAssertBudgetSumAmt(Long projectId, String budgetType) {
        BigDecimal sumBudgetAmt = BigDecimal.ZERO;
        QFilter qFilter = new QFilter("project", "=", (Object)projectId);
        qFilter.and("isvalid", "=", (Object)Boolean.TRUE);
        qFilter.and("sourcetype", "=", (Object)budgetType);
        DynamicObject[] budgetBills = BusinessDataServiceHelper.load((String)"pmas_budget", (String)String.join((CharSequence)",", "totalamount"), (QFilter[])new QFilter[]{qFilter});
        if (budgetBills.length > 0) {
            for (DynamicObject budgetBill : budgetBills) {
                sumBudgetAmt = sumBudgetAmt.add(budgetBill.getBigDecimal("totalamount"));
            }
        }
        return sumBudgetAmt;
    }

    public boolean checkIsExistBudgetBill(Long projectId, String budgetType) {
        QFilter qFilter = new QFilter("project", "=", (Object)projectId);
        qFilter.and("isvalid", "=", (Object)Boolean.TRUE);
        qFilter.and("sourcetype", "=", (Object)budgetType);
        return QueryServiceHelper.exists((String)"pmas_budget", (QFilter[])new QFilter[]{qFilter});
    }

    public Map<String, BigDecimal> getProInvestBudgetAmt(Date budgetYear, Long projectId, String budgetType) {
        DynamicObject investList;
        Optional<DynamicObject> first;
        DynamicObject investBill;
        DynamicObjectCollection invEntry;
        ArrayList<Long> projectIds = new ArrayList<Long>(10);
        projectIds.add(projectId);
        QFilter qFilter = new QFilter("pro", "=", (Object)projectId);
        qFilter.and("proproposal", "!=", (Object)0L);
        DynamicObject approval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"proproposal", (QFilter[])new QFilter[]{qFilter});
        if (approval != null && approval.getDynamicObject("proproposal") != null) {
            Long proposalId = Long.parseLong(approval.getDynamicObject("proproposal").getPkValue().toString());
            projectIds.add(proposalId);
        }
        HashMap<String, BigDecimal> proInvestBudgetAmtMap = new HashMap<String, BigDecimal>(16);
        BigDecimal proInvestBudgetAmt = BigDecimal.ZERO;
        BigDecimal yearInvestBudgetAmt = BigDecimal.ZERO;
        int organizationYear = budgetYear.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
        qFilter = new QFilter("YEAR(year)", "=", (Object)organizationYear);
        qFilter.and("effectivestatus", "=", (Object)"1");
        qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        qFilter.and("investentry.projectno", "in", projectIds);
        qFilter.and("investentry.approvalcon", "=", (Object)"pass");
        DynamicObject[] investBills = BusinessDataServiceHelper.load((String)"pmim_investplanadjustment", (String)String.join((CharSequence)",", "investentry", "projectno", "probudappamtafadjust", "yearappamtafadjust"), (QFilter[])new QFilter[]{qFilter}, (String)" auditdate desc", (int)1);
        if (investBills.length > 0 && (invEntry = (investBill = investBills[0]).getDynamicObjectCollection("investentry")).size() > 0 && (first = invEntry.stream().filter(o -> o.getDynamicObject("projectno") != null).filter(o -> projectIds.contains(Long.parseLong(o.getDynamicObject("projectno").getPkValue().toString()))).findFirst()).isPresent()) {
            investList = first.get();
            proInvestBudgetAmt = investList.getBigDecimal("probudappamtafadjust");
            yearInvestBudgetAmt = investList.getBigDecimal("yearappamtafadjust");
        }
        if ("NEW".equals(budgetType)) {
            if (investBills.length == 0) {
                qFilter = new QFilter("YEAR(year)", "=", (Object)organizationYear);
                qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                qFilter.and("inventry.projectno", "=", (Object)projectId);
                qFilter.and("inventry.inventry_approvalcon", "=", (Object)"pass");
                investBills = BusinessDataServiceHelper.load((String)"pmim_aunualinvestplan", (String)String.join((CharSequence)",", "inventry", "projectno", "projcetbugappamt", "inventry_approveamt"), (QFilter[])new QFilter[]{qFilter}, (String)" auditdate desc", (int)1);
                if (investBills.length > 0 && (invEntry = (investBill = investBills[0]).getDynamicObjectCollection("inventry")).size() > 0 && (first = invEntry.stream().filter(o -> o.getDynamicObject("projectno") != null).filter(o -> Long.parseLong(o.getDynamicObject("projectno").getPkValue().toString()) == projectId).findFirst()).isPresent()) {
                    investList = first.get();
                    proInvestBudgetAmt = investList.getBigDecimal("projcetbugappamt");
                    yearInvestBudgetAmt = investList.getBigDecimal("inventry_approveamt");
                }
            }
            if (investBills.length == 0) {
                qFilter = new QFilter("pro", "=", (Object)projectId);
                qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                approval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)String.join((CharSequence)",", "proyearbudgetamt", "projcetbugamt", "pro", "projectapplydate", "createtime"), (QFilter[])new QFilter[]{qFilter});
                if (approval != null) {
                    proInvestBudgetAmt = approval.getBigDecimal("projcetbugamt");
                    yearInvestBudgetAmt = new ProjectInitiationHelper().obtainLastApprovalAmt(budgetYear, approval.getDynamicObject("pro"));
                }
            }
            proInvestBudgetAmt = new ProjectInitiationHelper().getLastApprovalAmt(budgetYear, (Object)projectId, proInvestBudgetAmt);
        }
        proInvestBudgetAmtMap.put("proBudgetAppAmt", proInvestBudgetAmt);
        proInvestBudgetAmtMap.put("yearBudgetAppAmt", yearInvestBudgetAmt);
        return proInvestBudgetAmtMap;
    }
}

