/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.business.helper;

import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.BudgetCtlModeEnum;
import kd.pmgt.pmbs.common.enums.BudgetCtrlEnum;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.BudgetStageEnum;
import kd.pmgt.pmbs.common.enums.MajorTypeEnum;
import kd.pmgt.pmbs.common.enums.ProjectStageEnum;
import kd.pmgt.pmbs.common.enums.SplitTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.StageStatusHelper;
import kd.pmgt.pmbs.servicehelper.BudgetCtrlHelper;

public class OutBudgetOpHelper {
    public static final String BUDGET_CONTROL_MODE = "budgetcontrolmode";
    public static final String PROJECT_COST_CONTROL = "projectcostcontrol";
    public static final String REALBUDGETENTRY = "realbudgetentry";
    public static final String OUTBUDGET_FORMID = "pmas_outbudget";
    private static final Log logger = LogFactory.getLog(OutBudgetOpHelper.class);

    public static void setBudgetRecordFieldValue(DynamicObject dataEntity, DynamicObject budgetRecord, boolean isExistRecord) {
        String budgetControlMode = dataEntity.getString(BUDGET_CONTROL_MODE);
        budgetRecord.set("billno", dataEntity.get("billno"));
        budgetRecord.set("billstatus", (Object)StatusEnum.UNCHECKED.getValue());
        budgetRecord.set("org", dataEntity.get("org"));
        budgetRecord.set("year", (Object)dataEntity.getDate("year"));
        budgetRecord.set("billsource", (Object)OUTBUDGET_FORMID);
        Long pk = (Long)dataEntity.getPkValue();
        if (pk != 0L) {
            budgetRecord.set("relatebillid", (Object)pk.toString());
        }
        budgetRecord.set("budgetstage", dataEntity.get("budgetstage"));
        budgetRecord.set("totalamount", dataEntity.get("totalamount"));
        budgetRecord.set("group", dataEntity.get("group"));
        budgetRecord.set("currency", dataEntity.get("currency"));
        budgetRecord.set("projectapplydate", dataEntity.get("projectapplydate"));
        budgetRecord.set("project", dataEntity.get("project"));
        budgetRecord.set(BUDGET_CONTROL_MODE, (Object)budgetControlMode);
        budgetRecord.set(PROJECT_COST_CONTROL, dataEntity.get(PROJECT_COST_CONTROL));
        if (!isExistRecord) {
            budgetRecord.set("createtime", (Object)new Date());
        }
        budgetRecord.set("modifytime", (Object)new Date());
        DynamicObjectCollection realBudgetEntryCol = dataEntity.getDynamicObjectCollection(REALBUDGETENTRY);
        DynamicObjectCollection outBudgetControlInfoEntry = budgetRecord.getDynamicObjectCollection(REALBUDGETENTRY);
        DynamicObjectType type = outBudgetControlInfoEntry.getDynamicObjectType();
        outBudgetControlInfoEntry.clear();
        for (DynamicObject realBudgetEntry : realBudgetEntryCol) {
            BigDecimal realdifferenceamt;
            DynamicObject outBudgetControlInfo = new DynamicObject(type);
            outBudgetControlInfo.set("seq", realBudgetEntry.get("seq"));
            outBudgetControlInfo.set("realprobudgetname", realBudgetEntry.get("realprobudgetname"));
            outBudgetControlInfo.set("realbudgetitem", realBudgetEntry.get("realbudgetitem"));
            outBudgetControlInfo.set("realundertakeorg", realBudgetEntry.get("realundertakeorg"));
            outBudgetControlInfo.set("realundertakeperiod", realBudgetEntry.get("realundertakeperiod"));
            outBudgetControlInfo.set("realproname", realBudgetEntry.get("realproname"));
            outBudgetControlInfo.set("realpronumber", realBudgetEntry.get("realpronumber"));
            outBudgetControlInfo.set("realproid", realBudgetEntry.get("realproid"));
            if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue())) {
                outBudgetControlInfo.set("realbeforeamt", realBudgetEntry.get("realbeforeamt"));
                outBudgetControlInfo.set("realundertakeamt", realBudgetEntry.get("realundertakeamt"));
                realdifferenceamt = realBudgetEntry.getBigDecimal("realdifferenceamt");
                if (realdifferenceamt.compareTo(BigDecimal.ZERO) == 0) {
                    realdifferenceamt = realBudgetEntry.getBigDecimal("realundertakeamt").subtract(realBudgetEntry.getBigDecimal("realbeforeamt"));
                }
                outBudgetControlInfo.set("realdifferenceamt", (Object)realdifferenceamt);
            } else if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue())) {
                BigDecimal bigDecimal = realdifferenceamt = realBudgetEntry.getBigDecimal("realdifferenceamt").compareTo(BigDecimal.ZERO) > 0 ? realBudgetEntry.getBigDecimal("realdifferenceamt") : BigDecimal.ZERO;
                if (realdifferenceamt.compareTo(BigDecimal.ZERO) == 0) {
                    realdifferenceamt = realBudgetEntry.getBigDecimal("realundertakeamt").subtract(realBudgetEntry.getBigDecimal("realbeforeamt"));
                }
                outBudgetControlInfo.set("realundertakeamt", (Object)realdifferenceamt);
            }
            outBudgetControlInfoEntry.add((Object)outBudgetControlInfo);
        }
    }

    public static void doUnsubmit(DynamicObject[] dataEntities) {
        for (DynamicObject obj : dataEntities) {
            String budgetControlMode = obj.getString(BUDGET_CONTROL_MODE);
            String splitType = obj.getString("splittype");
            if (!SplitTypeEnum.TOTALAMTSPLIT.getValue().equals(splitType)) {
                if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue())) {
                    QFilter outFilter;
                    QFilter validFilter;
                    DynamicObject project = obj.getDynamicObject("project");
                    QFilter proFilter = new QFilter("project", "=", project.getPkValue());
                    DynamicObject[] lastBillObjs = BusinessDataServiceHelper.load((String)OUTBUDGET_FORMID, (String)"id,year", (QFilter[])new QFilter[]{proFilter, validFilter = new QFilter("isvalid", "=", (Object)"1"), outFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue())}, (String)"year desc", (int)1);
                    if (lastBillObjs.length > 0) {
                        DynamicObject lastBillObj = lastBillObjs[0];
                        Date preBudgetDate = lastBillObj.getDate("year");
                        Date budgetDate = obj.getDate("year");
                        int curYear = budgetDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
                        int preYear = preBudgetDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
                        if (preYear != curYear) {
                            OutBudgetOpHelper.returnOccupyChangeAmount(obj, "unsubmit");
                            OutBudgetOpHelper.updateBudgetRecordField(obj, null, "unsubmit");
                        } else {
                            lastBillObj = OutBudgetOpHelper.getLastBillObj(project, "unsubmit");
                            OutBudgetOpHelper.returnOccupyAmount(obj, lastBillObj, "unsubmit");
                            OutBudgetOpHelper.updateBudgetRecordField(obj, lastBillObj, "unsubmit");
                        }
                    }
                } else if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue())) {
                    OutBudgetOpHelper.returnOccupyChangeAmount(obj, "unsubmit");
                    OutBudgetOpHelper.updateBudgetRecordField(obj, null, "unsubmit");
                }
            }
            BigDecimal version = obj.getBigDecimal("version");
            DynamicObject budgetstage = obj.getDynamicObject("budgetstage");
            DynamicObject project = obj.getDynamicObject("project");
            if (budgetstage == null || BigDecimal.valueOf(1.0).compareTo(version) != 0 || !StringUtils.equals((CharSequence)budgetstage.getString("number"), (CharSequence)BudgetStageEnum.PREINSTALL_2.getValue())) continue;
            boolean exist = false;
            QFilter filter1 = new QFilter("project", "=", project.getPkValue());
            DynamicObject[] proTask = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"assigner,projectstatus,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,longnumber,level,fullname,isleaf, parent, controllevel, majortype, tasktype, achievementnode, pretask, logical, relativeduration, absoluteduration, planstarttime, planendtime, aimfinishtime, comptimedeviation, responsibleperson, responsibledept, cooperationperson, cooperationdept, comment, realendtime, resultdoc, prechangetask, version, realtimedeviation, belongplantype, sourcetask, completionstatus, percent, sharer, project, relationtask, islatest, taskseq, planid, riskcolor, responsiblepost, associatepost, templatetask, tasksource, expecttime, multicooperationperson, multicooperationdept, completedescription,taskresultdocentry,billstatus,meettask", (QFilter[])new QFilter[]{filter1});
            if (proTask != null && proTask.length > 0) {
                for (DynamicObject task : proTask) {
                    DynamicObject majortype = task.getDynamicObject("majortype");
                    if (!StringUtils.equals((CharSequence)majortype.getString("number"), (CharSequence)MajorTypeEnum.FEASIBILITYSTUDY_S.getValue())) continue;
                    QFilter filter3 = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                    filter3.or(new QFilter("billstatus", "=", (Object)StatusEnum.UNCHECKED.getValue()));
                    QFilter filter4 = new QFilter("task", "=", task.getPkValue());
                    DynamicObject[] taskReport = BusinessDataServiceHelper.load((String)"pmpm_taskreport", (String)"id,billno,billstatus,persontype,creator,modifier,auditor,auditdate,modifytime,createtime,chengguoentity.id,chengguoentity.attachmentfield,chengguoentity.resultname,chengguoentity.desc,chengguoentity.force,chengguoentity.resultid,chengguoentity.frequency,iscomplete,completetime,tips,reportdesc,huibaojlentity.id,huibaojlentity.completeprocess,huibaojlentity.resultdate,huibaojlentity.reportperson,huibaojlentity.completedesc,huibaojlentity.taskreport,huibaojlentity.historytask,huibaojlentity.resultstatus,task,percent,huibaoperson", (QFilter[])new QFilter[]{filter3, filter4});
                    if (taskReport == null || taskReport.length <= 0) continue;
                    exist = true;
                    break;
                }
            }
            if (exist) continue;
            StageStatusHelper.changeStatus((DynamicObject)project, (ProjectStageEnum)ProjectStageEnum.FEASIBILITYSTUDYSTAGE_S, null);
        }
    }

    public static void returnOccupyChangeAmount(DynamicObject curObj, String curOperate) {
        String billNo = curObj.getString("billno");
        try {
            String msg1 = String.format(ResManager.loadKDString((String)"\u652f\u51fa\u9884\u7b97\u5355\u201c%1$s\u201d%2$s\u64cd\u4f5c\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u8fd4\u8fd8\u63a5\u53e3\u201cBgControlService.returnBudget\u201d\uff0c\u8fd4\u8fd8\u64cd\u4f5c%3$s\uff1a", (String)"OutBudgetOpHelper_0", (String)"pmgt-pmas-business", (Object[])new Object[0]), billNo, curOperate, "unsubmitoccupy");
            QFilter qFilter = new QFilter("relatebillid", "=", (Object)curObj.getPkValue().toString());
            DynamicObject newBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (String)"id, billno", (QFilter[])new QFilter[]{qFilter});
            if (newBudgetRecord != null) {
                BudgetCtrlHelper.returnBudget((DynamicObject)newBudgetRecord, (String)"pmco_budgetrecord", (String)"unsubmitoccupy", (String)msg1);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(e.toString());
        }
    }

    public static void updateBudgetRecordField(DynamicObject dataEntity, DynamicObject lastBillObj, String operate) {
        QFilter qFilter = new QFilter("relatebillid", "=", (Object)dataEntity.getPkValue().toString());
        DynamicObject curBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (String)"billno, billstatus, creator, auditor, org, auditdate, createtime, modifytime, modifier, project, relatebillid, billsource, budgetstage, totalamount, group, currency, projectapplydate, budgetcontrolmode, projectcostcontrol, isvalid, description,year", (QFilter[])new QFilter[]{qFilter});
        String budgetControlMode = dataEntity.getString(BUDGET_CONTROL_MODE);
        if (curBudgetRecord == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.NOTCONTROL.getValue())) {
            return;
        }
        if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue())) {
            if (StringUtils.equals((CharSequence)operate, (CharSequence)"audit") && lastBillObj != null) {
                curBudgetRecord.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
                curBudgetRecord.set("isvalid", (Object)Boolean.TRUE);
                curBudgetRecord.set("modifytime", (Object)new Date());
                curBudgetRecord.set("auditdate", (Object)new Date());
                qFilter = new QFilter("relatebillid", "=", (Object)lastBillObj.getPkValue().toString());
                DynamicObject lastBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (String)"billno, billstatus, creator, auditor, org, auditdate, createtime, modifytime, modifier, project, relatebillid, billsource, budgetstage, totalamount, group, currency, projectapplydate, budgetcontrolmode, projectcostcontrol, isvalid, description,year", (QFilter[])new QFilter[]{qFilter});
                int curRecordDate = curBudgetRecord.getDate("year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
                int lastBillDate = lastBudgetRecord.getDate("year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
                if (curRecordDate == lastBillDate) {
                    lastBudgetRecord.set("isvalid", (Object)Boolean.FALSE);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{curBudgetRecord, lastBudgetRecord});
            } else if (StringUtils.equals((CharSequence)operate, (CharSequence)"unsubmit")) {
                curBudgetRecord.set("billstatus", (Object)StatusEnum.TEMPSAVE.getValue());
                curBudgetRecord.set("isvalid", (Object)Boolean.FALSE);
                curBudgetRecord.set("modifytime", (Object)new Date());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{curBudgetRecord});
            }
        } else if (StringUtils.equals((CharSequence)operate, (CharSequence)"audit")) {
            curBudgetRecord.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
            curBudgetRecord.set("isvalid", (Object)Boolean.TRUE);
            curBudgetRecord.set("modifytime", (Object)new Date());
            curBudgetRecord.set("auditdate", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{curBudgetRecord});
        } else if (StringUtils.equals((CharSequence)operate, (CharSequence)"unsubmit")) {
            curBudgetRecord.set("billstatus", (Object)StatusEnum.TEMPSAVE.getValue());
            curBudgetRecord.set("isvalid", (Object)Boolean.FALSE);
            curBudgetRecord.set("modifytime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{curBudgetRecord});
        }
    }

    public static DynamicObject getLastBillObj(DynamicObject project, String operationKey) {
        DynamicObject[] proBudgets;
        QFilter proFilter = new QFilter("project", "=", project.getPkValue());
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.UNCHECKED.getValue());
        QFilter sourceTypeFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
        if (StringUtils.equals((CharSequence)"submit", (CharSequence)operationKey) && (proBudgets = BusinessDataServiceHelper.load((String)OUTBUDGET_FORMID, (String)"id, billno", (QFilter[])new QFilter[]{proFilter, statusFilter, sourceTypeFilter})).length > 0) {
            DynamicObject proBudget = proBudgets[0];
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5ba1\u6838\u901a\u8fc7\u5df2\u63d0\u4ea4\u72b6\u6001\u7684\u652f\u51fa\u9884\u7b97\u5355\u636e\u201c%s\u201d\uff0c\u518d\u63d0\u4ea4\u3002", (String)"OutBudgetOpHelper_1", (String)"pmgt-pmas-business", (Object[])new Object[0]), proBudget.getString("billno")));
        }
        statusFilter = new QFilter("billstatus", "=", (Object)"C");
        proBudgets = BusinessDataServiceHelper.load((String)OUTBUDGET_FORMID, (String)"id", (QFilter[])new QFilter[]{proFilter, statusFilter, sourceTypeFilter});
        if (proBudgets.length <= 1) {
            proFilter = new QFilter("pro", "=", project.getPkValue());
            return BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"id,projectapplydate", (QFilter[])new QFilter[]{proFilter});
        }
        QFilter validFilter = new QFilter("isvalid", "=", (Object)"1");
        DynamicObject[] lastBillObj = BusinessDataServiceHelper.load((String)OUTBUDGET_FORMID, (String)"id,year", (QFilter[])new QFilter[]{proFilter, validFilter, sourceTypeFilter}, (String)"year desc", (int)1);
        if (lastBillObj.length > 0) {
            return lastBillObj[0];
        }
        return null;
    }

    public static void returnOccupyAmount(DynamicObject curObj, DynamicObject lastObj, String curOperate) {
        String billNo = curObj.getString("billno");
        DynamicObject lastBudgetRecord = null;
        try {
            String msg1 = String.format(ResManager.loadKDString((String)"\u652f\u51fa\u9884\u7b97\u5355\u201c%1$s\u201d%2$s\u64cd\u4f5c\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u8fd4\u8fd8\u63a5\u53e3\u201cBgControlService.returnBudget\u201d\uff0c\u8fd4\u8fd8\u64cd\u4f5c%3$s\uff1a", (String)"OutBudgetOpHelper_0", (String)"pmgt-pmas-business", (Object[])new Object[0]), billNo, curOperate, "unsubmitoccupy");
            QFilter qFilter = new QFilter("relatebillid", "=", (Object)curObj.getPkValue().toString());
            DynamicObject newBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (String)"id, billno", (QFilter[])new QFilter[]{qFilter});
            BudgetCtrlHelper.returnBudget((DynamicObject)newBudgetRecord, (String)"pmco_budgetrecord", (String)"unsubmitoccupy", (String)msg1);
            if (lastObj != null) {
                qFilter = new QFilter("relatebillid", "=", (Object)lastObj.getPkValue().toString());
                lastBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (String)"id, billno", (QFilter[])new QFilter[]{qFilter});
                if (lastBudgetRecord != null) {
                    String lastBillNo = lastBudgetRecord.getString("billno");
                    String msg2 = String.format(ResManager.loadKDString((String)"\u652f\u51fa\u9884\u7b97\u5355\u201c%1$s\u201d%2$s\u64cd\u4f5c\uff0c\u5bf9\u4e0a\u4e00\u5f20\u5355\u201c%3$s\u201d\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u6263\u51cf\u63a5\u53e3\u201cBgControlService.requestBudget\u201d\u505a\u5360\u7528\uff0c\u5360\u7528\u64cd\u4f5c%4$s\uff1a", (String)"OutBudgetOpHelper_2", (String)"pmgt-pmas-business", (Object[])new Object[0]), billNo, curOperate, lastBillNo, "submitoccupy");
                    BudgetCtrlHelper.requestBudget((DynamicObject)lastBudgetRecord, (String)"pmco_budgetrecord", (String)"submitoccupy", (boolean)true, (String)msg2);
                }
            }
        }
        catch (Exception e) {
            if (lastBudgetRecord != null) {
                String lastBillNo = lastBudgetRecord.getString("billno");
                String msg3 = String.format(ResManager.loadKDString((String)"\u652f\u51fa\u9884\u7b97\u5355\u201c%1$s\u201d%2$s\u64cd\u4f5c\uff0c\u5bf9\u4e0a\u4e00\u5f20\u5355\u201c%3$s\u201d\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u6263\u51cf\u63a5\u53e3\u201cBgControlService.requestBudget\u201d\u505a\u5360\u7528\uff0c\u5360\u7528\u64cd\u4f5c%4$s\uff1a\u53d1\u751f\u5f02\u5e38\u3002", (String)"OutBudgetOpHelper_3", (String)"pmgt-pmas-business", (Object[])new Object[0]), billNo, curOperate, lastBillNo, "submitoccupy");
                logger.error(msg3);
            }
            logger.error((Throwable)e);
            throw new KDBizException(e.toString());
        }
    }

    public static void generateAdjustForm(DynamicObject dataEntity, BudgetCtrlEnum type) {
        CloneUtils cloneUtils = new CloneUtils(false, false);
        DynamicObject obj = (DynamicObject)cloneUtils.clone((IDataEntityBase)dataEntity);
        OutBudgetOpHelper.filterOutBudgetEntry(obj);
        String changeAmountProp = OutBudgetOpHelper.getAdjustMoneyProp(obj);
        OutBudgetOpHelper.mergeBudgetItem(obj, changeAmountProp);
        BudgetCtrlHelper.invokeAdjustInterface((DynamicObject)obj, (BudgetCtrlEnum)type);
    }

    @Deprecated
    public static void mergeBudgetItem(DynamicObject dataEntity, String changeAmountProp) {
        DynamicObjectCollection outBudgetEntries = dataEntity.getDynamicObjectCollection("treeentryentity");
        HashMap<DynamicObject, DynamicObject> budgetItemMap = new HashMap<DynamicObject, DynamicObject>(outBudgetEntries.size());
        for (DynamicObject item : outBudgetEntries) {
            DynamicObject budgetItemKey = item.getDynamicObject("budgetitem");
            DynamicObject object = (DynamicObject)budgetItemMap.get(budgetItemKey);
            if (object != null) {
                DynamicObject budgetItem = object;
                BigDecimal amount = budgetItem.getBigDecimal(changeAmountProp).add(item.getBigDecimal(changeAmountProp));
                item.set(changeAmountProp, (Object)amount);
            }
            budgetItemMap.put(budgetItemKey, item);
        }
        if (!budgetItemMap.isEmpty()) {
            outBudgetEntries.clear();
            for (Map.Entry entry : budgetItemMap.entrySet()) {
                DynamicObject budgetItem = (DynamicObject)entry.getValue();
                BigDecimal changeAmount = budgetItem.getBigDecimal(changeAmountProp);
                if (changeAmount == null || changeAmount.intValue() == 0) continue;
                outBudgetEntries.add((Object)budgetItem);
            }
        }
    }

    @Deprecated
    public static String getAdjustMoneyProp(DynamicObject dataEntity) {
        boolean isExistedProBudgets;
        DynamicObject project = dataEntity.getDynamicObject("project");
        String type = dataEntity.getString("type");
        String changeAmountProp = StringUtils.equals((CharSequence)type, (CharSequence)"ADJUST") ? "vichangeamount" : (!(isExistedProBudgets = OutBudgetOpHelper.isExistBudgetCurProject(project)) ? "budgetamount" : "sichangeamount");
        return changeAmountProp;
    }

    public static void validateBudgetBalance(DynamicObject dataEntity, String queryBalance) {
        OutBudgetOpHelper.generateAdjustForm(dataEntity, BudgetCtrlEnum.SUBMIT);
    }

    public static boolean isExistBudgetCurProject(DynamicObject project) {
        QFilter validFilter;
        QFilter typeFilter;
        QFilter proFilter = new QFilter("project", "=", project.getPkValue());
        DynamicObject[] existedProBudgets = BusinessDataServiceHelper.load((String)"pmas_budget", (String)"id", (QFilter[])new QFilter[]{proFilter, typeFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue()), validFilter = new QFilter("isvalid", "=", (Object)"1")}, (String)"budgetstage.seqno", (int)1);
        return existedProBudgets != null && existedProBudgets.length > 0;
    }

    public static void filterOutBudgetEntry(DynamicObjectCollection outBudgetEntryCol) {
        DynamicObjectCollection removeEntries = new DynamicObjectCollection();
        for (DynamicObject item : outBudgetEntryCol) {
            if (item.getLong("pid") == 0L) continue;
            removeEntries.add((Object)item);
        }
        if (!removeEntries.isEmpty()) {
            outBudgetEntryCol.removeAll((Collection)removeEntries);
        }
    }

    @Deprecated
    public static void filterOutBudgetEntry(DynamicObject dataEntity) {
        DynamicObjectCollection outBudgetEntries = dataEntity.getDynamicObjectCollection("treeentryentity");
        DynamicObjectCollection removeEntries = new DynamicObjectCollection();
        for (DynamicObject item : outBudgetEntries) {
            if (item.getLong("pid") == 0L) continue;
            removeEntries.add((Object)item);
        }
        if (!removeEntries.isEmpty()) {
            outBudgetEntries.removeAll((Collection)removeEntries);
        }
    }
}

