/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmas.business.helper.ProjectBudgetBuilder;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.utils.BudgetControlHelper;

public class ProjectBudgetGenerateHelper {
    public static void generateProjectBudget(DynamicObject budgetObj, List<DynamicObject> updateProjectItems, List<DynamicObject> addProjectItems, String sourceType) {
        DynamicObjectCollection treeEntryEntity = budgetObj.getDynamicObjectCollection("treeentryentity");
        Set itemNumberSet = treeEntryEntity.stream().map(dyn -> dyn.getString("budgetitemnum")).collect(Collectors.toSet());
        DynamicObject project = budgetObj.getDynamicObject("project");
        List<Object> projectBudgetList = new ArrayList();
        if (project != null) {
            String budgetType = StringUtils.equals((CharSequence)sourceType, (CharSequence)BudgetSourceTypeEnum.IN.getValue()) ? BudgetSourceTypeEnum.IN.getValue() : BudgetSourceTypeEnum.OUT.getValue();
            QFilter projectFilter = new QFilter("project", "=", (Object)project.getLong("id"));
            QFilter numberFilter = new QFilter("number", "in", itemNumberSet);
            QFilter budgetTypeFilter = new QFilter("sourcetype", "=", (Object)budgetType);
            projectBudgetList = Arrays.stream(BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)"id,number", (QFilter[])new QFilter[]{projectFilter, numberFilter, budgetTypeFilter})).collect(Collectors.toList());
        }
        Map<String, DynamicObject> numberMap = projectBudgetList.stream().collect(Collectors.toMap(dyn -> dyn.getString("number"), dyn -> dyn));
        if (!treeEntryEntity.isEmpty()) {
            List<Map<String, Object>> treeMapList = ProjectBudgetGenerateHelper.buildTree(treeEntryEntity);
            for (DynamicObject budgetEntryObj : treeEntryEntity) {
                DynamicObject projectBudgetItem;
                HashMap<String, Object> treeMap = new HashMap<String, Object>(16);
                for (Map<String, Object> map : treeMapList) {
                    if (!budgetEntryObj.getString("id").equals(map.get("id").toString())) continue;
                    treeMap.putAll(map);
                    break;
                }
                if ((projectBudgetItem = budgetEntryObj.getDynamicObject("projectbudgetitem")) == null) {
                    projectBudgetItem = new ProjectBudgetBuilder(budgetEntryObj.getLong("id")).sourceType(sourceType).project(budgetObj.getDynamicObject("project")).parent(ProjectBudgetGenerateHelper.getProjectBudgetParentId(budgetEntryObj, treeEntryEntity)).currency(budgetObj.getDynamicObject("currency")).build();
                    if (BudgetSourceTypeEnum.TOTAL.getValue().equals(sourceType)) {
                        projectBudgetItem.set("sourcetype", (Object)BudgetSourceTypeEnum.OUT.getValue());
                        ProjectBudgetGenerateHelper.setProjectBudgetByBudgetEntry(projectBudgetItem, budgetEntryObj, null, treeMap);
                        String budgetItemNumber = projectBudgetItem.getString("number");
                        if (numberMap.containsKey(budgetItemNumber)) {
                            budgetEntryObj.set("projectbudgetitem", numberMap.get(budgetItemNumber).getPkValue());
                            continue;
                        }
                        addProjectItems.add(projectBudgetItem);
                        budgetEntryObj.set("projectbudgetitem", budgetEntryObj.getPkValue());
                        continue;
                    }
                    ProjectBudgetGenerateHelper.setProjectBudgetByBudgetEntry(projectBudgetItem, budgetEntryObj, budgetObj.getDate("year"), treeMap);
                    addProjectItems.add(projectBudgetItem);
                    budgetEntryObj.set("projectbudgetitem", budgetEntryObj.getPkValue());
                    continue;
                }
                if (!QueryServiceHelper.exists((String)"pmas_projectbudget", (Object)projectBudgetItem.getPkValue())) continue;
                projectBudgetItem = BusinessDataServiceHelper.loadSingle((Object)projectBudgetItem.getPkValue(), (String)"pmas_projectbudget");
                projectBudgetItem.set("parent", (Object)ProjectBudgetGenerateHelper.getProjectBudgetParentId(budgetEntryObj, treeEntryEntity));
                if (BudgetSourceTypeEnum.TOTAL.getValue().equals(sourceType)) {
                    ProjectBudgetGenerateHelper.setProjectBudgetByBudgetEntry(projectBudgetItem, budgetEntryObj, null, treeMap);
                } else {
                    ProjectBudgetGenerateHelper.setProjectBudgetByBudgetEntry(projectBudgetItem, budgetEntryObj, budgetObj.getDate("year"), treeMap);
                }
                updateProjectItems.add(projectBudgetItem);
            }
        }
        if (project != null) {
            Map controlRateMap = BudgetControlHelper.getControlRateMap((Long)project.getLong("id"));
            ProjectBudgetGenerateHelper.updateProjectBudgetControlInfo(controlRateMap, updateProjectItems);
            ProjectBudgetGenerateHelper.updateProjectBudgetControlInfo(controlRateMap, addProjectItems);
        }
    }

    public static void updateProjectBudgetControlInfo(Map<String, Map<String, DynamicObject>> controlRateMap, List<DynamicObject> projectBudgetItems) {
        if (projectBudgetItems == null || projectBudgetItems.isEmpty()) {
            return;
        }
        Map<String, DynamicObject> projectBudgetMap = controlRateMap.get("proBudgetItemMap");
        Map<String, DynamicObject> standardBudgetMap = controlRateMap.get("budgetItemMap");
        for (DynamicObject projectBudget : projectBudgetItems) {
            DynamicObject controlEntry;
            long standardBudgetId = projectBudget.getLong("budgetitem");
            DynamicObject dynamicObject = controlEntry = projectBudgetMap == null ? null : projectBudgetMap.get(projectBudget.getString("id"));
            if (controlEntry == null && standardBudgetId != 0L && standardBudgetMap != null && standardBudgetMap.get(Long.toString(standardBudgetId)) != null) {
                controlEntry = standardBudgetMap.get(Long.toString(standardBudgetId));
            }
            if (controlEntry != null) {
                BudgetControlHelper.updateProBudgetItemByParam((DynamicObject)projectBudget, (DynamicObject)controlEntry);
            } else {
                BudgetControlHelper.cancelProBudgetItemControl((DynamicObject)projectBudget);
            }
            ProjectBudgetGenerateHelper.countRemainAmountInfo(projectBudget);
        }
    }

    protected static void countRemainAmountInfo(DynamicObject projectBudget) {
        BigDecimal occupyAmount = projectBudget.getBigDecimal("occupyamt") == null ? BigDecimal.ZERO : projectBudget.getBigDecimal("occupyamt");
        BigDecimal performAmount = projectBudget.getBigDecimal("performamt") == null ? BigDecimal.ZERO : projectBudget.getBigDecimal("performamt");
        BigDecimal budgetAmount = projectBudget.getBigDecimal("budgetamount") == null ? BigDecimal.ZERO : projectBudget.getBigDecimal("budgetamount");
        BigDecimal remainAmount = budgetAmount.subtract(occupyAmount).subtract(performAmount);
        projectBudget.set("remainamt", (Object)remainAmount);
        BigDecimal remainRate = BigDecimal.ZERO;
        if (budgetAmount.compareTo(BigDecimal.ZERO) != 0) {
            remainRate = remainAmount.divide(budgetAmount, 10, RoundingMode.HALF_UP);
        }
        projectBudget.set("remainrate", (Object)remainRate);
    }

    private static void setProjectBudgetByBudgetEntry(DynamicObject budgetItem, DynamicObject entry, Date curBiiDate, Map<String, Object> treeMap) {
        budgetItem.set("sequence", (Object)entry.getInt("seq"));
        budgetItem.set("budgetitem", entry.get("budgetitem") == null ? Integer.valueOf(0) : entry.getDynamicObject("budgetitem").getPkValue());
        budgetItem.set("description", entry.get("descriptionentry"));
        budgetItem.set("name", entry.get("budgetitemname"));
        budgetItem.set("number", entry.get("budgetitemnum"));
        budgetItem.set("siamount", entry.get("siamount"));
        budgetItem.set("viamount", entry.get("viamount"));
        budgetItem.set("vichangeamount", entry.get("vichangeamount"));
        budgetItem.set("number", entry.get("budgetitemnum"));
        budgetItem.set("level", treeMap.get("level"));
        budgetItem.set("leaf", treeMap.get("leaf"));
        budgetItem.set("fullname", treeMap.get("fullname"));
        if (curBiiDate == null) {
            budgetItem.set("budgetamount", entry.get("budgetamount"));
        } else {
            DynamicObjectCollection budgetRecord = budgetItem.getDynamicObjectCollection("yearbudgetrecord");
            if (QueryServiceHelper.exists((String)"pmas_projectbudget", (Object)budgetItem.getPkValue())) {
                DynamicObject item = null;
                for (DynamicObject record : budgetRecord) {
                    int curBillYear;
                    Date lastBudgetDate = record.getDate("year");
                    int lastBudgetYear = lastBudgetDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
                    if (lastBudgetYear != (curBillYear = curBiiDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear())) continue;
                    item = record;
                    break;
                }
                if (item == null) {
                    ProjectBudgetGenerateHelper.createProBudgetYearRecord(budgetItem, curBiiDate, entry);
                } else {
                    item.set("curyearamt", entry.get("budgetamount"));
                    item.set("sumbudgetamt", (Object)item.getBigDecimal("lastyearsurplusamt").add(item.getBigDecimal("curyearamt")));
                }
            } else {
                ProjectBudgetGenerateHelper.createProBudgetYearRecord(budgetItem, curBiiDate, entry);
            }
            BigDecimal proBudgetSumAmt = BigDecimal.ZERO;
            if (budgetRecord.size() > 0) {
                for (DynamicObject yearRecord : budgetRecord) {
                    proBudgetSumAmt = proBudgetSumAmt.add(yearRecord.getBigDecimal("curyearamt"));
                }
            }
            budgetItem.set("budgetamount", (Object)proBudgetSumAmt);
        }
    }

    private static void createProBudgetYearRecord(DynamicObject budgetItem, Date curBiiDate, DynamicObject entry) {
        DynamicObjectCollection yearBudgetRecord = budgetItem.getDynamicObjectCollection("yearbudgetrecord");
        DynamicObject item = yearBudgetRecord.addNew();
        if (!QueryServiceHelper.exists((String)"pmas_projectbudget", (Object)budgetItem.getPkValue())) {
            item.set("lastyearsurplusamt", (Object)BigDecimal.ZERO);
        } else {
            item.set("lastyearsurplusamt", (Object)budgetItem.getBigDecimal("budgetamount").subtract(budgetItem.getBigDecimal("occupyamt")));
        }
        item.set("year", (Object)curBiiDate);
        item.set("curyearamt", entry.get("budgetamount"));
        item.set("sumbudgetamt", (Object)item.getBigDecimal("lastyearsurplusamt").add(item.getBigDecimal("curyearamt")));
    }

    private static Long getProjectBudgetParentId(DynamicObject entry, DynamicObjectCollection entrys) {
        long parentId = entry.getLong("pid");
        if (parentId != 0L) {
            for (DynamicObject budgetEntryObj : entrys) {
                long entryId = budgetEntryObj.getLong("id");
                if (parentId != entryId) continue;
                long id = budgetEntryObj.getLong("projectbudgetitem_id");
                return id == 0L ? entryId : id;
            }
        }
        return 0L;
    }

    public static void generateProjectBudget(DynamicObject budget, String sourceType) {
        DynamicObject project;
        ArrayList<DynamicObject> updateProjectItems = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> addProjectItems = new ArrayList<DynamicObject>();
        ProjectBudgetGenerateHelper.generateProjectBudget(budget, updateProjectItems, addProjectItems, sourceType);
        if (!updateProjectItems.isEmpty()) {
            SaveServiceHelper.save((IDataEntityType)updateProjectItems.get(0).getDataEntityType(), (Object[])updateProjectItems.toArray(new DynamicObject[updateProjectItems.size()]));
        }
        if (!addProjectItems.isEmpty()) {
            SaveServiceHelper.save((IDataEntityType)addProjectItems.get(0).getDataEntityType(), (Object[])addProjectItems.toArray(new DynamicObject[addProjectItems.size()]));
        }
        if ((project = budget.getDynamicObject("project")) != null) {
            Map controlRateMap = BudgetControlHelper.getControlRateMap((Long)project.getLong("id"));
            ProjectBudgetGenerateHelper.updateProjectBudgetControlInfo(controlRateMap, updateProjectItems);
            ProjectBudgetGenerateHelper.updateProjectBudgetControlInfo(controlRateMap, addProjectItems);
        }
    }

    public static List<Map<String, Object>> buildTree(DynamicObjectCollection entryEntity) {
        ArrayList<Map<String, Object>> treeList = new ArrayList<Map<String, Object>>();
        for (DynamicObject entry : entryEntity) {
            HashMap<String, Object> treeMap = new HashMap<String, Object>(16);
            String currentId = entry.getString("id");
            treeMap.put("id", currentId);
            ArrayList<DynamicObject> childrenList = new ArrayList<DynamicObject>();
            ProjectBudgetGenerateHelper.getChildrenList(childrenList, entryEntity, currentId);
            treeMap.put("leaf", childrenList.isEmpty());
            String parentId = entry.getString("pid");
            int level = 1;
            level = ProjectBudgetGenerateHelper.getLevel(entryEntity, parentId, level);
            treeMap.put("level", level);
            String fullName = ProjectBudgetGenerateHelper.getFullName(entryEntity, currentId);
            treeMap.put("fullname", fullName);
            treeList.add(treeMap);
        }
        return treeList;
    }

    public static int getLevel(DynamicObjectCollection allList, String parentId, int level) {
        DynamicObject parent = ProjectBudgetGenerateHelper.getParent(allList, parentId);
        if (parent != null) {
            return ProjectBudgetGenerateHelper.getLevel(allList, parent.getString("pid"), ++level);
        }
        return level;
    }

    public static DynamicObject getParent(DynamicObjectCollection allList, String parentId) {
        for (DynamicObject entry : allList) {
            if (!entry.getString("id").equals(parentId)) continue;
            return entry;
        }
        return null;
    }

    public static void getParentList(List<DynamicObject> parentList, DynamicObjectCollection allList, String currentId) {
        for (DynamicObject entry : allList) {
            if (!entry.get("id").toString().equals(currentId)) continue;
            ProjectBudgetGenerateHelper.getParentList(parentList, allList, entry.getString("pid"));
            parentList.add(entry);
        }
    }

    public static void getChildrenList(List<DynamicObject> childrenList, DynamicObjectCollection allList, String currentId) {
        for (DynamicObject entry : allList) {
            if (!entry.getString("pid").equals(currentId)) continue;
            ProjectBudgetGenerateHelper.getChildrenList(childrenList, allList, entry.getString("id"));
            childrenList.add(entry);
        }
    }

    public static String getFullName(DynamicObjectCollection allList, String currentId) {
        ArrayList<DynamicObject> parentList = new ArrayList<DynamicObject>();
        ProjectBudgetGenerateHelper.getParentList(parentList, allList, currentId);
        return parentList.stream().map(parent -> parent.get("budgetitemname").toString()).collect(Collectors.joining("."));
    }
}

